/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.vocab;

import com.sun.xml.internal.fastinfoset.QualifiedName;
import com.sun.xml.internal.fastinfoset.util.CharArrayIntMap;
import com.sun.xml.internal.fastinfoset.util.FixedEntryStringIntMap;
import com.sun.xml.internal.fastinfoset.util.KeyIntMap;
import com.sun.xml.internal.fastinfoset.util.LocalNameQualifiedNamesMap;
import com.sun.xml.internal.fastinfoset.util.StringIntMap;
import com.sun.xml.internal.fastinfoset.vocab.Vocabulary;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class SerializerVocabulary
extends Vocabulary {
    public final StringIntMap restrictedAlphabet;
    public final StringIntMap encodingAlgorithm;
    public final StringIntMap namespaceName;
    public final StringIntMap prefix;
    public final StringIntMap localName;
    public final StringIntMap otherNCName;
    public final StringIntMap otherURI;
    public final StringIntMap attributeValue;
    public final CharArrayIntMap otherString;
    public final CharArrayIntMap characterContentChunk;
    public final LocalNameQualifiedNamesMap elementName;
    public final LocalNameQualifiedNamesMap attributeName;
    public final KeyIntMap[] tables = new KeyIntMap[12];
    protected boolean _useLocalNameAsKey;
    protected SerializerVocabulary _readOnlyVocabulary;

    public SerializerVocabulary() {
        this.restrictedAlphabet = new StringIntMap(4);
        this.tables[0] = this.restrictedAlphabet;
        this.encodingAlgorithm = new StringIntMap(4);
        this.tables[1] = this.encodingAlgorithm;
        this.prefix = new FixedEntryStringIntMap("xml", 8);
        this.tables[2] = this.prefix;
        this.namespaceName = new FixedEntryStringIntMap("http://www.w3.org/XML/1998/namespace", 8);
        this.tables[3] = this.namespaceName;
        this.localName = new StringIntMap();
        this.tables[4] = this.localName;
        this.otherNCName = new StringIntMap(4);
        this.tables[5] = this.otherNCName;
        this.otherURI = new StringIntMap(4);
        this.tables[6] = this.otherURI;
        this.attributeValue = new StringIntMap();
        this.tables[7] = this.attributeValue;
        this.otherString = new CharArrayIntMap(4);
        this.tables[8] = this.otherString;
        this.characterContentChunk = new CharArrayIntMap();
        this.tables[9] = this.characterContentChunk;
        this.elementName = new LocalNameQualifiedNamesMap();
        this.tables[10] = this.elementName;
        this.attributeName = new LocalNameQualifiedNamesMap();
        this.tables[11] = this.attributeName;
    }

    public SerializerVocabulary(com.sun.xml.internal.org.jvnet.fastinfoset.Vocabulary vocabulary, boolean bl) {
        this();
        this._useLocalNameAsKey = bl;
        this.convertVocabulary(vocabulary);
    }

    public SerializerVocabulary getReadOnlyVocabulary() {
        return this._readOnlyVocabulary;
    }

    protected void setReadOnlyVocabulary(SerializerVocabulary serializerVocabulary, boolean bl) {
        for (int i = 0; i < this.tables.length; ++i) {
            this.tables[i].setReadOnlyMap(serializerVocabulary.tables[i], bl);
        }
    }

    public void setInitialVocabulary(SerializerVocabulary serializerVocabulary, boolean bl) {
        this.setExternalVocabularyURI(null);
        this.setInitialReadOnlyVocabulary(true);
        this.setReadOnlyVocabulary(serializerVocabulary, bl);
    }

    public void setExternalVocabulary(String string, SerializerVocabulary serializerVocabulary, boolean bl) {
        this.setInitialReadOnlyVocabulary(false);
        this.setExternalVocabularyURI(string);
        this.setReadOnlyVocabulary(serializerVocabulary, bl);
    }

    public void clear() {
        for (int i = 0; i < this.tables.length; ++i) {
            this.tables[i].clear();
        }
    }

    private void convertVocabulary(com.sun.xml.internal.org.jvnet.fastinfoset.Vocabulary vocabulary) {
        this.addToTable(vocabulary.restrictedAlphabets.iterator(), this.restrictedAlphabet);
        this.addToTable(vocabulary.encodingAlgorithms.iterator(), this.encodingAlgorithm);
        this.addToTable(vocabulary.prefixes.iterator(), this.prefix);
        this.addToTable(vocabulary.namespaceNames.iterator(), this.namespaceName);
        this.addToTable(vocabulary.localNames.iterator(), this.localName);
        this.addToTable(vocabulary.otherNCNames.iterator(), this.otherNCName);
        this.addToTable(vocabulary.otherURIs.iterator(), this.otherURI);
        this.addToTable(vocabulary.attributeValues.iterator(), this.attributeValue);
        this.addToTable(vocabulary.otherStrings.iterator(), this.otherString);
        this.addToTable(vocabulary.characterContentChunks.iterator(), this.characterContentChunk);
        this.addToTable(vocabulary.elements.iterator(), this.elementName);
        this.addToTable(vocabulary.attributes.iterator(), this.attributeName);
    }

    private void addToTable(Iterator iterator, StringIntMap stringIntMap) {
        while (iterator.hasNext()) {
            this.addToTable((String)iterator.next(), stringIntMap);
        }
    }

    private void addToTable(String string, StringIntMap stringIntMap) {
        if (string.length() == 0) {
            return;
        }
        stringIntMap.obtainIndex(string);
    }

    private void addToTable(Iterator iterator, CharArrayIntMap charArrayIntMap) {
        while (iterator.hasNext()) {
            this.addToTable((String)iterator.next(), charArrayIntMap);
        }
    }

    private void addToTable(String string, CharArrayIntMap charArrayIntMap) {
        if (string.length() == 0) {
            return;
        }
        char[] cArray = string.toCharArray();
        charArrayIntMap.obtainIndex(cArray, 0, cArray.length, false);
    }

    private void addToTable(Iterator iterator, LocalNameQualifiedNamesMap localNameQualifiedNamesMap) {
        while (iterator.hasNext()) {
            this.addToNameTable((QName)iterator.next(), localNameQualifiedNamesMap);
        }
    }

    private void addToNameTable(QName qName, LocalNameQualifiedNamesMap localNameQualifiedNamesMap) {
        int n;
        int n2 = -1;
        int n3 = -1;
        if (qName.getNamespaceURI().length() > 0) {
            n2 = this.namespaceName.obtainIndex(qName.getNamespaceURI());
            if (n2 == -1) {
                n2 = this.namespaceName.get(qName.getNamespaceURI());
            }
            if (qName.getPrefix().length() > 0 && (n3 = this.prefix.obtainIndex(qName.getPrefix())) == -1) {
                n3 = this.prefix.get(qName.getPrefix());
            }
        }
        if ((n = this.localName.obtainIndex(qName.getLocalPart())) == -1) {
            n = this.localName.get(qName.getLocalPart());
        }
        QualifiedName qualifiedName = new QualifiedName(qName.getPrefix(), qName.getNamespaceURI(), qName.getLocalPart(), localNameQualifiedNamesMap.getNextIndex(), n3, n2, n);
        LocalNameQualifiedNamesMap.Entry entry = null;
        if (this._useLocalNameAsKey) {
            entry = localNameQualifiedNamesMap.obtainEntry(qName.getLocalPart());
        } else {
            String string = n3 == -1 ? qName.getLocalPart() : qName.getPrefix() + ":" + qName.getLocalPart();
            entry = localNameQualifiedNamesMap.obtainEntry(string);
        }
        entry.addQualifiedName(qualifiedName);
    }
}

