/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.patch;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.internal.core.patch.DiffProject;
import org.eclipse.compare.internal.patch.InputPatchPage;
import org.eclipse.compare.internal.patch.PatchTargetPage;
import org.eclipse.compare.internal.patch.PatchWizard;
import org.eclipse.compare.internal.patch.WorkspacePatcher;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.patch.ApplyPatchModelSynchronizeParticipant;
import org.eclipse.team.internal.ui.synchronize.patch.ApplyPatchSubscriber;
import org.eclipse.team.internal.ui.synchronize.patch.ApplyPatchSubscriberMergeContext;
import org.eclipse.team.internal.ui.synchronize.patch.PatchParsedPage;
import org.eclipse.team.internal.ui.wizards.PatchInaccessibleProjectsPage;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.ui.IWorkbench;

public class ApplyPatchSynchronizationWizard
extends PatchWizard
implements IConfigurationWizard {
    private PatchInaccessibleProjectsPage fPatchInaccessibleProjectsPage;

    public ApplyPatchSynchronizationWizard() {
        this(null, null, new CompareConfiguration());
    }

    public ApplyPatchSynchronizationWizard(IStorage patch, IResource target, CompareConfiguration configuration) {
        super(patch, target, configuration);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        IProject[] projects;
        if (this.fPatchInaccessibleProjectsPage != null && (projects = this.fPatchInaccessibleProjectsPage.getSelectedProjects()) != null && projects.length != 0) {
            this.openSelectedProjects(projects);
        }
        ApplyPatchSubscriber subscriber = new ApplyPatchSubscriber(this.getPatcher());
        ResourceMapping[] inputMappings = Utils.getResourceMappings(subscriber.roots());
        SubscriberScopeManager scopeManager = new SubscriberScopeManager(subscriber.getName(), inputMappings, (Subscriber)subscriber, true);
        ApplyPatchSubscriberMergeContext mergeContext = ApplyPatchSubscriberMergeContext.createContext(subscriber, (ISynchronizationScopeManager)scopeManager);
        ApplyPatchModelSynchronizeParticipant participant = new ApplyPatchModelSynchronizeParticipant((SynchronizationContext)mergeContext);
        TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
        participant.run(null);
        return true;
    }

    public void init(IWorkbench workbench, IProject project) {
    }

    public void addPages() {
        if (this.getPatch() == null) {
            this.fPatchWizardPage = new InputPatchPage((PatchWizard)this);
            this.addPage((IWizardPage)this.fPatchWizardPage);
        }
        if (this.getPatch() == null || !this.getPatcher().isWorkspacePatch()) {
            this.fPatchTargetPage = new PatchTargetPage(this.getPatcher()){

                public IWizardPage getNextPage() {
                    IWizardPage nextPage = super.getNextPage();
                    if (!ApplyPatchSynchronizationWizard.this.isTargetingInaccessibleProjects() && nextPage != this) {
                        return nextPage.getNextPage();
                    }
                    return nextPage;
                }
            };
            this.addPage((IWizardPage)this.fPatchTargetPage);
        }
        if (this.getPatch() == null || this.isTargetingInaccessibleProjects()) {
            this.fPatchInaccessibleProjectsPage = new PatchInaccessibleProjectsPage(this.getPatcher());
            this.addPage((IWizardPage)this.fPatchInaccessibleProjectsPage);
        }
        this.addPage((IWizardPage)new PatchParsedPage());
    }

    public boolean isComplete() {
        return this.getPatch() != null && this.getPatcher().isWorkspacePatch() && !this.isTargetingInaccessibleProjects();
    }

    private boolean isTargetingInaccessibleProjects() {
        DiffProject[] diffProjects = this.getPatcher().getDiffProjects();
        if (diffProjects != null) {
            int i = 0;
            while (i < diffProjects.length) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(diffProjects[i].getName());
                if (!project.isAccessible()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage.getName().equals("PatchInaccessibleProjectsPage")) {
            return currentPage.isPageComplete();
        }
        if (currentPage.getName().equals("PatchParsedPage")) {
            return currentPage.isPageComplete();
        }
        return super.canFinish();
    }

    public WorkspacePatcher getPatcher() {
        return super.getPatcher();
    }

    private void openSelectedProjects(final IProject[] projects) {
        Job openProjectsJob = new Job(TeamUIMessages.PatchInaccessibleProjectsPage_openingProjects){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(TeamUIMessages.PatchInaccessibleProjectsPage_openingProjects, projects.length);
                MultiStatus errorStatus = new MultiStatus("org.eclipse.team.ui", 4, TeamUIMessages.PatchInaccessibleProjectsPage_openingProjects, null);
                int i = 0;
                while (i < projects.length) {
                    IProject project = projects[i];
                    try {
                        project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (CoreException e) {
                        errorStatus.add(e.getStatus());
                    }
                    ++i;
                }
                monitor.done();
                return errorStatus;
            }
        };
        openProjectsJob.setUser(true);
        openProjectsJob.schedule();
    }
}

