/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb;

import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.RfbCapabilityInfo;
import com.glavsoft.rfb.encoding.EncodingType;
import com.glavsoft.transport.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;

public class CapabilityContainer {
    private final Map<Integer, RfbCapabilityInfo> caps = new HashMap<Integer, RfbCapabilityInfo>();

    public void add(RfbCapabilityInfo capabilityInfo) {
        this.caps.put(capabilityInfo.getCode(), capabilityInfo);
    }

    public void add(int code, String vendor, String name) {
        this.caps.put(code, new RfbCapabilityInfo(code, vendor, name));
    }

    public void addEnabled(int code, String vendor, String name) {
        RfbCapabilityInfo capability = new RfbCapabilityInfo(code, vendor, name);
        capability.setEnable(true);
        this.caps.put(code, capability);
    }

    public void setEnable(int id, boolean enable) {
        RfbCapabilityInfo c = this.caps.get(id);
        if (c != null) {
            c.setEnable(enable);
        }
    }

    public void setAllEnable(boolean enable) {
        for (RfbCapabilityInfo c : this.caps.values()) {
            c.setEnable(enable);
        }
    }

    public Collection<EncodingType> getEnabledEncodingTypes() {
        LinkedList<EncodingType> types = new LinkedList<EncodingType>();
        for (RfbCapabilityInfo c : this.caps.values()) {
            if (!c.isEnabled()) continue;
            types.add(EncodingType.byId(c.getCode()));
        }
        return types;
    }

    public void read(Reader reader, int count) throws TransportException {
        while (count-- > 0) {
            RfbCapabilityInfo capInfoReceived = new RfbCapabilityInfo(reader);
            Logger.getLogger("com.glavsoft.rfb").fine(capInfoReceived.toString());
            RfbCapabilityInfo myCapInfo = this.caps.get(capInfoReceived.getCode());
            if (myCapInfo == null) continue;
            myCapInfo.setEnable(true);
        }
    }

    public boolean isSupported(int code) {
        RfbCapabilityInfo myCapInfo = this.caps.get(code);
        if (myCapInfo != null) {
            return myCapInfo.isEnabled();
        }
        return false;
    }

    public boolean isSupported(RfbCapabilityInfo rfbCapabilityInfo) {
        return this.isSupported(rfbCapabilityInfo.getCode());
    }
}

