package webpubsub

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/webpubsub/mgmt/2021-10-01/webpubsub"

// CreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (ResourceType, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CreateOrUpdateFuture.Result.
func (future *CreateOrUpdateFuture) result(client Client) (rt ResourceType, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "webpubsub.CreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		rt.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("webpubsub.CreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rt.Response.Response, err = future.GetResult(sender); err == nil && rt.Response.Response.StatusCode != http.StatusNoContent {
		rt, err = client.CreateOrUpdateResponder(rt.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "webpubsub.CreateOrUpdateFuture", "Result", rt.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeleteFuture.Result.
func (future *DeleteFuture) result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "webpubsub.DeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("webpubsub.DeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Dimension specifications of the Dimension of metrics.
type Dimension struct {
	// Name - The public facing name of the dimension.
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized friendly display name of the dimension.
	DisplayName *string `json:"displayName,omitempty"`
	// InternalName - Name of the dimension as it appears in MDM.
	InternalName *string `json:"internalName,omitempty"`
	// ToBeExportedForShoebox - A Boolean flag indicating whether this dimension should be included for the shoebox export scenario.
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetail.
func (ed ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.).
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// EventHandler properties of event handler.
type EventHandler struct {
	// URLTemplate - Gets or sets the EventHandler URL template. You can use a predefined parameter {hub} and {event} inside the template, the value of the EventHandler URL is dynamically calculated when the client request comes in.
	// For example, UrlTemplate can be `http://example.com/api/{hub}/{event}`. The host part can't contains parameters.
	URLTemplate *string `json:"urlTemplate,omitempty"`
	// UserEventPattern - Gets or sets the matching pattern for event names.
	// There are 3 kind of patterns supported:
	//     1. "*", it to matches any event name
	//     2. Combine multiple events with ",", for example "event1,event2", it matches event "event1" and "event2"
	//     3. The single event name, for example, "event1", it matches "event1"
	UserEventPattern *string `json:"userEventPattern,omitempty"`
	// SystemEvents - Gets ot sets the list of system events.
	SystemEvents *[]string `json:"systemEvents,omitempty"`
	// Auth - Gets or sets the auth settings for an event handler. If not set, no auth is used.
	Auth *UpstreamAuthSettings `json:"auth,omitempty"`
}

// Hub a hub setting
type Hub struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// Properties - Properties of the hub setting.
	Properties *HubProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Hub.
func (h Hub) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if h.Properties != nil {
		objectMap["properties"] = h.Properties
	}
	return json.Marshal(objectMap)
}

// HubList hub setting list
type HubList struct {
	autorest.Response `json:"-"`
	// Value - List of hub settings to this resource.
	Value *[]Hub `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL the client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for HubList.
func (hl HubList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hl.Value != nil {
		objectMap["value"] = hl.Value
	}
	return json.Marshal(objectMap)
}

// HubListIterator provides access to a complete listing of Hub values.
type HubListIterator struct {
	i    int
	page HubListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HubListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HubListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *HubListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HubListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HubListIterator) Response() HubList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HubListIterator) Value() Hub {
	if !iter.page.NotDone() {
		return Hub{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the HubListIterator type.
func NewHubListIterator(page HubListPage) HubListIterator {
	return HubListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (hl HubList) IsEmpty() bool {
	return hl.Value == nil || len(*hl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (hl HubList) hasNextLink() bool {
	return hl.NextLink != nil && len(*hl.NextLink) != 0
}

// hubListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hl HubList) hubListPreparer(ctx context.Context) (*http.Request, error) {
	if !hl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hl.NextLink)))
}

// HubListPage contains a page of Hub values.
type HubListPage struct {
	fn func(context.Context, HubList) (HubList, error)
	hl HubList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HubListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HubListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.hl)
		if err != nil {
			return err
		}
		page.hl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *HubListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HubListPage) NotDone() bool {
	return !page.hl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HubListPage) Response() HubList {
	return page.hl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HubListPage) Values() []Hub {
	if page.hl.IsEmpty() {
		return nil
	}
	return *page.hl.Value
}

// Creates a new instance of the HubListPage type.
func NewHubListPage(cur HubList, getNextPage func(context.Context, HubList) (HubList, error)) HubListPage {
	return HubListPage{
		fn: getNextPage,
		hl: cur,
	}
}

// HubProperties properties of a hub.
type HubProperties struct {
	// EventHandlers - Event handler of a hub.
	EventHandlers *[]EventHandler `json:"eventHandlers,omitempty"`
	// AnonymousConnectPolicy - The settings for configuring if anonymous connections are allowed for this hub: "allow" or "deny". Default to "deny".
	AnonymousConnectPolicy *string `json:"anonymousConnectPolicy,omitempty"`
}

// HubsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type HubsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(HubsClient) (Hub, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *HubsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for HubsCreateOrUpdateFuture.Result.
func (future *HubsCreateOrUpdateFuture) result(client HubsClient) (h Hub, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "webpubsub.HubsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		h.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("webpubsub.HubsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if h.Response.Response, err = future.GetResult(sender); err == nil && h.Response.Response.StatusCode != http.StatusNoContent {
		h, err = client.CreateOrUpdateResponder(h.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "webpubsub.HubsCreateOrUpdateFuture", "Result", h.Response.Response, "Failure responding to request")
		}
	}
	return
}

// HubsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type HubsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(HubsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *HubsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for HubsDeleteFuture.Result.
func (future *HubsDeleteFuture) result(client HubsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "webpubsub.HubsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("webpubsub.HubsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Keys a class represents the access keys of the resource.
type Keys struct {
	autorest.Response `json:"-"`
	// PrimaryKey - The primary access key.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - The secondary access key.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// PrimaryConnectionString - Connection string constructed via the primaryKey
	PrimaryConnectionString *string `json:"primaryConnectionString,omitempty"`
	// SecondaryConnectionString - Connection string constructed via the secondaryKey
	SecondaryConnectionString *string `json:"secondaryConnectionString,omitempty"`
}

// LiveTraceCategory live trace category configuration of a Microsoft.SignalRService resource.
type LiveTraceCategory struct {
	// Name - Gets or sets the live trace category's name.
	// Available values: ConnectivityLogs, MessagingLogs.
	// Case insensitive.
	Name *string `json:"name,omitempty"`
	// Enabled - Indicates whether or the live trace category is enabled.
	// Available values: true, false.
	// Case insensitive.
	Enabled *string `json:"enabled,omitempty"`
}

// LiveTraceConfiguration live trace configuration of a Microsoft.SignalRService resource.
type LiveTraceConfiguration struct {
	// Enabled - Indicates whether or not enable live trace.
	// When it's set to true, live trace client can connect to the service.
	// Otherwise, live trace client can't connect to the service, so that you are unable to receive any log, no matter what you configure in "categories".
	// Available values: true, false.
	// Case insensitive.
	Enabled *string `json:"enabled,omitempty"`
	// Categories - Gets or sets the list of category configurations.
	Categories *[]LiveTraceCategory `json:"categories,omitempty"`
}

// LogSpecification specifications of the Logs for Azure Monitoring.
type LogSpecification struct {
	// Name - Name of the log.
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized friendly display name of the log.
	DisplayName *string `json:"displayName,omitempty"`
}

// ManagedIdentity a class represent managed identities used for request and response
type ManagedIdentity struct {
	// Type - Represent the identity type: systemAssigned, userAssigned, None. Possible values include: 'ManagedIdentityTypeNone', 'ManagedIdentityTypeSystemAssigned', 'ManagedIdentityTypeUserAssigned'
	Type ManagedIdentityType `json:"type,omitempty"`
	// UserAssignedIdentities - Get or set the user assigned identities
	UserAssignedIdentities map[string]*UserAssignedIdentityProperty `json:"userAssignedIdentities"`
	// PrincipalID - READ-ONLY; Get the principal id for the system assigned identity.
	// Only be used in response.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; Get the tenant id for the system assigned identity.
	// Only be used in response
	TenantID *string `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedIdentity.
func (mi ManagedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mi.Type != "" {
		objectMap["type"] = mi.Type
	}
	if mi.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = mi.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// ManagedIdentitySettings managed identity settings for upstream.
type ManagedIdentitySettings struct {
	// Resource - The Resource indicating the App ID URI of the target resource.
	// It also appears in the aud (audience) claim of the issued token.
	Resource *string `json:"resource,omitempty"`
}

// MetricSpecification specifications of the Metrics for Azure Monitoring.
type MetricSpecification struct {
	// Name - Name of the metric.
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized friendly display name of the metric.
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - Localized friendly description of the metric.
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - The unit that makes sense for the metric.
	Unit *string `json:"unit,omitempty"`
	// AggregationType - Only provide one value for this field. Valid values: Average, Minimum, Maximum, Total, Count.
	AggregationType *string `json:"aggregationType,omitempty"`
	// FillGapWithZero - Optional. If set to true, then zero will be returned for time duration where no metric is emitted/published.
	// Ex. a metric that returns the number of times a particular error code was emitted. The error code may not appear
	// often, instead of the RP publishing 0, Shoebox can auto fill in 0s for time periods where nothing was emitted.
	FillGapWithZero *string `json:"fillGapWithZero,omitempty"`
	// Category - The name of the metric category that the metric belongs to. A metric can only belong to a single category.
	Category *string `json:"category,omitempty"`
	// Dimensions - The dimensions of the metrics.
	Dimensions *[]Dimension `json:"dimensions,omitempty"`
}

// NameAvailability result of the request to check name availability. It contains a flag and possible
// reason of failure.
type NameAvailability struct {
	autorest.Response `json:"-"`
	// NameAvailable - Indicates whether the name is available or not.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - The reason of the availability. Required if name is not available.
	Reason *string `json:"reason,omitempty"`
	// Message - The message of the operation.
	Message *string `json:"message,omitempty"`
}

// NameAvailabilityParameters data POST-ed to the nameAvailability action
type NameAvailabilityParameters struct {
	// Type - The resource type. Can be "Microsoft.SignalRService/SignalR" or "Microsoft.SignalRService/webPubSub"
	Type *string `json:"type,omitempty"`
	// Name - The resource name to validate. e.g."my-resource-name"
	Name *string `json:"name,omitempty"`
}

// NetworkACL network ACL
type NetworkACL struct {
	// Allow - Allowed request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
	Allow *[]RequestType `json:"allow,omitempty"`
	// Deny - Denied request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
	Deny *[]RequestType `json:"deny,omitempty"`
}

// NetworkACLs network ACLs for the resource
type NetworkACLs struct {
	// DefaultAction - Default action when no other rule matches. Possible values include: 'ACLActionAllow', 'ACLActionDeny'
	DefaultAction ACLAction `json:"defaultAction,omitempty"`
	// PublicNetwork - ACL for requests from public network
	PublicNetwork *NetworkACL `json:"publicNetwork,omitempty"`
	// PrivateEndpoints - ACLs for requests from private endpoints
	PrivateEndpoints *[]PrivateEndpointACL `json:"privateEndpoints,omitempty"`
}

// Operation REST API operation supported by resource provider.
type Operation struct {
	// Name - Name of the operation with format: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// IsDataAction - If the operation is a data action. (for data plane rbac)
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Display - The object that describes the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - Optional. The intended executor of the operation; governs the display of the operation in the RBAC UX and the audit logs UX.
	Origin *string `json:"origin,omitempty"`
	// Properties - Extra properties for the operation.
	Properties *OperationProperties `json:"properties,omitempty"`
}

// OperationDisplay the object that describes a operation.
type OperationDisplay struct {
	// Provider - Friendly name of the resource provider
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource type on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - The localized friendly name for the operation.
	Operation *string `json:"operation,omitempty"`
	// Description - The localized friendly description for the operation
	Description *string `json:"description,omitempty"`
}

// OperationList result of the request to list REST API operations. It contains a list of operations.
type OperationList struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by the resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - The URL the client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListIterator provides access to a complete listing of Operation values.
type OperationListIterator struct {
	i    int
	page OperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListIterator) Response() OperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListIterator type.
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return OperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ol OperationList) hasNextLink() bool {
	return ol.NextLink != nil && len(*ol.NextLink) != 0
}

// operationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationList) operationListPreparer(ctx context.Context) (*http.Request, error) {
	if !ol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationListPage contains a page of Operation values.
type OperationListPage struct {
	fn func(context.Context, OperationList) (OperationList, error)
	ol OperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ol)
		if err != nil {
			return err
		}
		page.ol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListPage) Response() OperationList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationListPage type.
func NewOperationListPage(cur OperationList, getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return OperationListPage{
		fn: getNextPage,
		ol: cur,
	}
}

// OperationProperties extra Operation properties.
type OperationProperties struct {
	// ServiceSpecification - The service specifications.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// PrivateEndpoint private endpoint
type PrivateEndpoint struct {
	// ID - Full qualified Id of the private endpoint
	ID *string `json:"id,omitempty"`
}

// PrivateEndpointACL ACL for a private endpoint
type PrivateEndpointACL struct {
	// Name - Name of the private endpoint connection
	Name *string `json:"name,omitempty"`
	// Allow - Allowed request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
	Allow *[]RequestType `json:"allow,omitempty"`
	// Deny - Denied request types. The value can be one or more of: ClientConnection, ServerConnection, RESTAPI.
	Deny *[]RequestType `json:"deny,omitempty"`
}

// PrivateEndpointConnection a private endpoint connection to an azure resource
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// PrivateEndpointConnectionProperties - Properties of the private endpoint connection
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				pec.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionList a list of private endpoint connections
type PrivateEndpointConnectionList struct {
	autorest.Response `json:"-"`
	// Value - The list of the private endpoint connections
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
	// NextLink - Request URL that can be used to query next page of private endpoint connections. Returned when the total number of requested private endpoint connections exceed maximum page size.
	NextLink *string `json:"nextLink,omitempty"`
}

// PrivateEndpointConnectionListIterator provides access to a complete listing of PrivateEndpointConnection
// values.
type PrivateEndpointConnectionListIterator struct {
	i    int
	page PrivateEndpointConnectionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateEndpointConnectionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateEndpointConnectionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateEndpointConnectionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateEndpointConnectionListIterator) Response() PrivateEndpointConnectionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateEndpointConnectionListIterator) Value() PrivateEndpointConnection {
	if !iter.page.NotDone() {
		return PrivateEndpointConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateEndpointConnectionListIterator type.
func NewPrivateEndpointConnectionListIterator(page PrivateEndpointConnectionListPage) PrivateEndpointConnectionListIterator {
	return PrivateEndpointConnectionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pecl PrivateEndpointConnectionList) IsEmpty() bool {
	return pecl.Value == nil || len(*pecl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pecl PrivateEndpointConnectionList) hasNextLink() bool {
	return pecl.NextLink != nil && len(*pecl.NextLink) != 0
}

// privateEndpointConnectionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pecl PrivateEndpointConnectionList) privateEndpointConnectionListPreparer(ctx context.Context) (*http.Request, error) {
	if !pecl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pecl.NextLink)))
}

// PrivateEndpointConnectionListPage contains a page of PrivateEndpointConnection values.
type PrivateEndpointConnectionListPage struct {
	fn   func(context.Context, PrivateEndpointConnectionList) (PrivateEndpointConnectionList, error)
	pecl PrivateEndpointConnectionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateEndpointConnectionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pecl)
		if err != nil {
			return err
		}
		page.pecl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateEndpointConnectionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateEndpointConnectionListPage) NotDone() bool {
	return !page.pecl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateEndpointConnectionListPage) Response() PrivateEndpointConnectionList {
	return page.pecl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateEndpointConnectionListPage) Values() []PrivateEndpointConnection {
	if page.pecl.IsEmpty() {
		return nil
	}
	return *page.pecl.Value
}

// Creates a new instance of the PrivateEndpointConnectionListPage type.
func NewPrivateEndpointConnectionListPage(cur PrivateEndpointConnectionList, getNextPage func(context.Context, PrivateEndpointConnectionList) (PrivateEndpointConnectionList, error)) PrivateEndpointConnectionListPage {
	return PrivateEndpointConnectionListPage{
		fn:   getNextPage,
		pecl: cur,
	}
}

// PrivateEndpointConnectionProperties private endpoint connection properties
type PrivateEndpointConnectionProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state of the private endpoint connection. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateRunning', 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateMoving'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// PrivateEndpoint - Private endpoint associated with the private endpoint connection
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// GroupIds - READ-ONLY; Group IDs
	GroupIds *[]string `json:"groupIds,omitempty"`
	// PrivateLinkServiceConnectionState - Connection state
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionProperties.
func (pecp PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pecp.PrivateEndpoint != nil {
		objectMap["privateEndpoint"] = pecp.PrivateEndpoint
	}
	if pecp.PrivateLinkServiceConnectionState != nil {
		objectMap["privateLinkServiceConnectionState"] = pecp.PrivateLinkServiceConnectionState
	}
	return json.Marshal(objectMap)
}

// PrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsDeleteFuture.Result.
func (future *PrivateEndpointConnectionsDeleteFuture) result(client PrivateEndpointConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "webpubsub.PrivateEndpointConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("webpubsub.PrivateEndpointConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateLinkResource private link resource
type PrivateLinkResource struct {
	// PrivateLinkResourceProperties - Properties of a private link resource
	*PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.PrivateLinkResourceProperties != nil {
		objectMap["properties"] = plr.PrivateLinkResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkResource struct.
func (plr *PrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkResourceProperties PrivateLinkResourceProperties
				err = json.Unmarshal(*v, &privateLinkResourceProperties)
				if err != nil {
					return err
				}
				plr.PrivateLinkResourceProperties = &privateLinkResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plr.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateLinkResourceList contains a list of PrivateLinkResource and a possible link to query more results
type PrivateLinkResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of PrivateLinkResource
	Value *[]PrivateLinkResource `json:"value,omitempty"`
	// NextLink - The URL the client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// PrivateLinkResourceListIterator provides access to a complete listing of PrivateLinkResource values.
type PrivateLinkResourceListIterator struct {
	i    int
	page PrivateLinkResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateLinkResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateLinkResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateLinkResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateLinkResourceListIterator) Response() PrivateLinkResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateLinkResourceListIterator) Value() PrivateLinkResource {
	if !iter.page.NotDone() {
		return PrivateLinkResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateLinkResourceListIterator type.
func NewPrivateLinkResourceListIterator(page PrivateLinkResourceListPage) PrivateLinkResourceListIterator {
	return PrivateLinkResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plrl PrivateLinkResourceList) IsEmpty() bool {
	return plrl.Value == nil || len(*plrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plrl PrivateLinkResourceList) hasNextLink() bool {
	return plrl.NextLink != nil && len(*plrl.NextLink) != 0
}

// privateLinkResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plrl PrivateLinkResourceList) privateLinkResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !plrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plrl.NextLink)))
}

// PrivateLinkResourceListPage contains a page of PrivateLinkResource values.
type PrivateLinkResourceListPage struct {
	fn   func(context.Context, PrivateLinkResourceList) (PrivateLinkResourceList, error)
	plrl PrivateLinkResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateLinkResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plrl)
		if err != nil {
			return err
		}
		page.plrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateLinkResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateLinkResourceListPage) NotDone() bool {
	return !page.plrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateLinkResourceListPage) Response() PrivateLinkResourceList {
	return page.plrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateLinkResourceListPage) Values() []PrivateLinkResource {
	if page.plrl.IsEmpty() {
		return nil
	}
	return *page.plrl.Value
}

// Creates a new instance of the PrivateLinkResourceListPage type.
func NewPrivateLinkResourceListPage(cur PrivateLinkResourceList, getNextPage func(context.Context, PrivateLinkResourceList) (PrivateLinkResourceList, error)) PrivateLinkResourceListPage {
	return PrivateLinkResourceListPage{
		fn:   getNextPage,
		plrl: cur,
	}
}

// PrivateLinkResourceProperties private link resource properties
type PrivateLinkResourceProperties struct {
	// GroupID - Group Id of the private link resource
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - Required members of the private link resource
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - Required private DNS zone names
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
	// ShareablePrivateLinkResourceTypes - The list of resources that are onboarded to private link service
	ShareablePrivateLinkResourceTypes *[]ShareablePrivateLinkResourceType `json:"shareablePrivateLinkResourceTypes,omitempty"`
}

// PrivateLinkServiceConnectionState connection state of the private endpoint connection
type PrivateLinkServiceConnectionState struct {
	// Status - Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service. Possible values include: 'PrivateLinkServiceConnectionStatusPending', 'PrivateLinkServiceConnectionStatusApproved', 'PrivateLinkServiceConnectionStatusRejected', 'PrivateLinkServiceConnectionStatusDisconnected'
	Status PrivateLinkServiceConnectionStatus `json:"status,omitempty"`
	// Description - The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// Properties a class that describes the properties of the resource
type Properties struct {
	// ProvisioningState - READ-ONLY; Provisioning state of the resource. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateRunning', 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateMoving'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ExternalIP - READ-ONLY; The publicly accessible IP of the resource.
	ExternalIP *string `json:"externalIP,omitempty"`
	// HostName - READ-ONLY; FQDN of the service instance.
	HostName *string `json:"hostName,omitempty"`
	// PublicPort - READ-ONLY; The publicly accessible port of the resource which is designed for browser/client side usage.
	PublicPort *int32 `json:"publicPort,omitempty"`
	// ServerPort - READ-ONLY; The publicly accessible port of the resource which is designed for customer server side usage.
	ServerPort *int32 `json:"serverPort,omitempty"`
	// Version - READ-ONLY; Version of the resource. Probably you need the same or higher version of client SDKs.
	Version *string `json:"version,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; Private endpoint connections to the resource.
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
	// SharedPrivateLinkResources - READ-ONLY; The list of shared private link resources.
	SharedPrivateLinkResources *[]SharedPrivateLinkResource `json:"sharedPrivateLinkResources,omitempty"`
	// TLS - TLS settings.
	TLS *TLSSettings `json:"tls,omitempty"`
	// HostNamePrefix - READ-ONLY; Deprecated.
	HostNamePrefix *string `json:"hostNamePrefix,omitempty"`
	// LiveTraceConfiguration - Live trace configuration of a Microsoft.SignalRService resource.
	LiveTraceConfiguration *LiveTraceConfiguration `json:"liveTraceConfiguration,omitempty"`
	// ResourceLogConfiguration - Resource log configuration of a Microsoft.SignalRService resource.
	// If resourceLogConfiguration isn't null or empty, it will override options "EnableConnectivityLog" and "EnableMessagingLogs" in features.
	// Otherwise, use options "EnableConnectivityLog" and "EnableMessagingLogs" in features.
	ResourceLogConfiguration *ResourceLogConfiguration `json:"resourceLogConfiguration,omitempty"`
	// NetworkACLs - Network ACLs
	NetworkACLs *NetworkACLs `json:"networkACLs,omitempty"`
	// PublicNetworkAccess - Enable or disable public network access. Default to "Enabled".
	// When it's Enabled, network ACLs still apply.
	// When it's Disabled, public network access is always disabled no matter what you set in network ACLs.
	PublicNetworkAccess *string `json:"publicNetworkAccess,omitempty"`
	// DisableLocalAuth - DisableLocalAuth
	// Enable or disable local auth with AccessKey
	// When set as true, connection with AccessKey=xxx won't work.
	DisableLocalAuth *bool `json:"disableLocalAuth,omitempty"`
	// DisableAadAuth - DisableLocalAuth
	// Enable or disable aad auth
	// When set as true, connection with AuthType=aad won't work.
	DisableAadAuth *bool `json:"disableAadAuth,omitempty"`
}

// MarshalJSON is the custom marshaler for Properties.
func (p Properties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.TLS != nil {
		objectMap["tls"] = p.TLS
	}
	if p.LiveTraceConfiguration != nil {
		objectMap["liveTraceConfiguration"] = p.LiveTraceConfiguration
	}
	if p.ResourceLogConfiguration != nil {
		objectMap["resourceLogConfiguration"] = p.ResourceLogConfiguration
	}
	if p.NetworkACLs != nil {
		objectMap["networkACLs"] = p.NetworkACLs
	}
	if p.PublicNetworkAccess != nil {
		objectMap["publicNetworkAccess"] = p.PublicNetworkAccess
	}
	if p.DisableLocalAuth != nil {
		objectMap["disableLocalAuth"] = p.DisableLocalAuth
	}
	if p.DisableAadAuth != nil {
		objectMap["disableAadAuth"] = p.DisableAadAuth
	}
	return json.Marshal(objectMap)
}

// ProxyResource the resource model definition for a ARM proxy resource. It will have everything other than
// required location and tags
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RegenerateKeyFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RegenerateKeyFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (Keys, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RegenerateKeyFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RegenerateKeyFuture.Result.
func (future *RegenerateKeyFuture) result(client Client) (kVar Keys, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "webpubsub.RegenerateKeyFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		kVar.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("webpubsub.RegenerateKeyFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if kVar.Response.Response, err = future.GetResult(sender); err == nil && kVar.Response.Response.StatusCode != http.StatusNoContent {
		kVar, err = client.RegenerateKeyResponder(kVar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "webpubsub.RegenerateKeyFuture", "Result", kVar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RegenerateKeyParameters parameters describes the request to regenerate access keys
type RegenerateKeyParameters struct {
	// KeyType - The keyType to regenerate. Must be either 'primary' or 'secondary'(case-insensitive). Possible values include: 'KeyTypePrimary', 'KeyTypeSecondary', 'KeyTypeSalt'
	KeyType KeyType `json:"keyType,omitempty"`
}

// Resource the core properties of ARM resources.
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceList object that includes an array of resources and a possible link for next set.
type ResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of the resources
	Value *[]ResourceType `json:"value,omitempty"`
	// NextLink - The URL the client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceListIterator provides access to a complete listing of ResourceType values.
type ResourceListIterator struct {
	i    int
	page ResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceListIterator) Response() ResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceListIterator) Value() ResourceType {
	if !iter.page.NotDone() {
		return ResourceType{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceListIterator type.
func NewResourceListIterator(page ResourceListPage) ResourceListIterator {
	return ResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rl ResourceList) IsEmpty() bool {
	return rl.Value == nil || len(*rl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rl ResourceList) hasNextLink() bool {
	return rl.NextLink != nil && len(*rl.NextLink) != 0
}

// resourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rl ResourceList) resourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !rl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rl.NextLink)))
}

// ResourceListPage contains a page of ResourceType values.
type ResourceListPage struct {
	fn func(context.Context, ResourceList) (ResourceList, error)
	rl ResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rl)
		if err != nil {
			return err
		}
		page.rl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceListPage) NotDone() bool {
	return !page.rl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceListPage) Response() ResourceList {
	return page.rl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceListPage) Values() []ResourceType {
	if page.rl.IsEmpty() {
		return nil
	}
	return *page.rl.Value
}

// Creates a new instance of the ResourceListPage type.
func NewResourceListPage(cur ResourceList, getNextPage func(context.Context, ResourceList) (ResourceList, error)) ResourceListPage {
	return ResourceListPage{
		fn: getNextPage,
		rl: cur,
	}
}

// ResourceLogCategory resource log category configuration of a Microsoft.SignalRService resource.
type ResourceLogCategory struct {
	// Name - Gets or sets the resource log category's name.
	// Available values: ConnectivityLogs, MessagingLogs.
	// Case insensitive.
	Name *string `json:"name,omitempty"`
	// Enabled - Indicates whether or the resource log category is enabled.
	// Available values: true, false.
	// Case insensitive.
	Enabled *string `json:"enabled,omitempty"`
}

// ResourceLogConfiguration resource log configuration of a Microsoft.SignalRService resource.
type ResourceLogConfiguration struct {
	// Categories - Gets or sets the list of category configurations.
	Categories *[]ResourceLogCategory `json:"categories,omitempty"`
}

// ResourceSku the billing information of the resource.
type ResourceSku struct {
	// Name - The name of the SKU. Required.
	//
	// Allowed values: Standard_S1, Free_F1
	Name *string `json:"name,omitempty"`
	// Tier - Optional tier of this particular SKU. 'Standard' or 'Free'.
	//
	// `Basic` is deprecated, use `Standard` instead. Possible values include: 'SkuTierFree', 'SkuTierBasic', 'SkuTierStandard', 'SkuTierPremium'
	Tier SkuTier `json:"tier,omitempty"`
	// Size - READ-ONLY; Not used. Retained for future use.
	Size *string `json:"size,omitempty"`
	// Family - READ-ONLY; Not used. Retained for future use.
	Family *string `json:"family,omitempty"`
	// Capacity - Optional, integer. The unit count of the resource. 1 by default.
	//
	// If present, following values are allowed:
	//     Free: 1
	//     Standard: 1,2,5,10,20,50,100
	Capacity *int32 `json:"capacity,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceSku.
func (rs ResourceSku) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rs.Name != nil {
		objectMap["name"] = rs.Name
	}
	if rs.Tier != "" {
		objectMap["tier"] = rs.Tier
	}
	if rs.Capacity != nil {
		objectMap["capacity"] = rs.Capacity
	}
	return json.Marshal(objectMap)
}

// ResourceType a class represent a resource.
type ResourceType struct {
	autorest.Response `json:"-"`
	// Sku - The billing information of the resource.(e.g. Free, Standard)
	Sku *ResourceSku `json:"sku,omitempty"`
	// Properties - Settings used to provision or configure the resource
	*Properties `json:"properties,omitempty"`
	// Identity - The managed identity response
	Identity *ManagedIdentity `json:"identity,omitempty"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// Location - The GEO location of the resource. e.g. West US | East US | North Central US | South Central US.
	Location *string `json:"location,omitempty"`
	// Tags - Tags of the service which is a list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceType.
func (rt ResourceType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rt.Sku != nil {
		objectMap["sku"] = rt.Sku
	}
	if rt.Properties != nil {
		objectMap["properties"] = rt.Properties
	}
	if rt.Identity != nil {
		objectMap["identity"] = rt.Identity
	}
	if rt.Location != nil {
		objectMap["location"] = rt.Location
	}
	if rt.Tags != nil {
		objectMap["tags"] = rt.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ResourceType struct.
func (rt *ResourceType) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku ResourceSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				rt.Sku = &sku
			}
		case "properties":
			if v != nil {
				var properties Properties
				err = json.Unmarshal(*v, &properties)
				if err != nil {
					return err
				}
				rt.Properties = &properties
			}
		case "identity":
			if v != nil {
				var identity ManagedIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				rt.Identity = &identity
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				rt.SystemData = &systemData
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rt.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rt.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rt.Type = &typeVar
			}
		}
	}

	return nil
}

// RestartFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RestartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RestartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RestartFuture.Result.
func (future *RestartFuture) result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "webpubsub.RestartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("webpubsub.RestartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServiceSpecification an object that describes a specification.
type ServiceSpecification struct {
	// MetricSpecifications - Specifications of the Metrics for Azure Monitoring.
	MetricSpecifications *[]MetricSpecification `json:"metricSpecifications,omitempty"`
	// LogSpecifications - Specifications of the Logs for Azure Monitoring.
	LogSpecifications *[]LogSpecification `json:"logSpecifications,omitempty"`
}

// ShareablePrivateLinkResourceProperties describes the properties of a resource type that has been
// onboarded to private link service
type ShareablePrivateLinkResourceProperties struct {
	// Description - The description of the resource type that has been onboarded to private link service
	Description *string `json:"description,omitempty"`
	// GroupID - The resource provider group id for the resource that has been onboarded to private link service
	GroupID *string `json:"groupId,omitempty"`
	// Type - The resource provider type for the resource that has been onboarded to private link service
	Type *string `json:"type,omitempty"`
}

// ShareablePrivateLinkResourceType describes a  resource type that has been onboarded to private link
// service
type ShareablePrivateLinkResourceType struct {
	// Name - The name of the resource type that has been onboarded to private link service
	Name *string `json:"name,omitempty"`
	// Properties - Describes the properties of a resource type that has been onboarded to private link service
	Properties *ShareablePrivateLinkResourceProperties `json:"properties,omitempty"`
}

// SharedPrivateLinkResource describes a Shared Private Link Resource
type SharedPrivateLinkResource struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// SharedPrivateLinkResourceProperties - Describes the properties of a Shared Private Link Resource
	*SharedPrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SharedPrivateLinkResource.
func (splr SharedPrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if splr.SharedPrivateLinkResourceProperties != nil {
		objectMap["properties"] = splr.SharedPrivateLinkResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SharedPrivateLinkResource struct.
func (splr *SharedPrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				splr.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var sharedPrivateLinkResourceProperties SharedPrivateLinkResourceProperties
				err = json.Unmarshal(*v, &sharedPrivateLinkResourceProperties)
				if err != nil {
					return err
				}
				splr.SharedPrivateLinkResourceProperties = &sharedPrivateLinkResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				splr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				splr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				splr.Type = &typeVar
			}
		}
	}

	return nil
}

// SharedPrivateLinkResourceList a list of shared private link resources
type SharedPrivateLinkResourceList struct {
	autorest.Response `json:"-"`
	// Value - The list of the shared private link resources
	Value *[]SharedPrivateLinkResource `json:"value,omitempty"`
	// NextLink - Request URL that can be used to query next page of private endpoint connections. Returned when the total number of requested private endpoint connections exceed maximum page size.
	NextLink *string `json:"nextLink,omitempty"`
}

// SharedPrivateLinkResourceListIterator provides access to a complete listing of SharedPrivateLinkResource
// values.
type SharedPrivateLinkResourceListIterator struct {
	i    int
	page SharedPrivateLinkResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SharedPrivateLinkResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SharedPrivateLinkResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SharedPrivateLinkResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SharedPrivateLinkResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SharedPrivateLinkResourceListIterator) Response() SharedPrivateLinkResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SharedPrivateLinkResourceListIterator) Value() SharedPrivateLinkResource {
	if !iter.page.NotDone() {
		return SharedPrivateLinkResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SharedPrivateLinkResourceListIterator type.
func NewSharedPrivateLinkResourceListIterator(page SharedPrivateLinkResourceListPage) SharedPrivateLinkResourceListIterator {
	return SharedPrivateLinkResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (splrl SharedPrivateLinkResourceList) IsEmpty() bool {
	return splrl.Value == nil || len(*splrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (splrl SharedPrivateLinkResourceList) hasNextLink() bool {
	return splrl.NextLink != nil && len(*splrl.NextLink) != 0
}

// sharedPrivateLinkResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (splrl SharedPrivateLinkResourceList) sharedPrivateLinkResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !splrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(splrl.NextLink)))
}

// SharedPrivateLinkResourceListPage contains a page of SharedPrivateLinkResource values.
type SharedPrivateLinkResourceListPage struct {
	fn    func(context.Context, SharedPrivateLinkResourceList) (SharedPrivateLinkResourceList, error)
	splrl SharedPrivateLinkResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SharedPrivateLinkResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SharedPrivateLinkResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.splrl)
		if err != nil {
			return err
		}
		page.splrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SharedPrivateLinkResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SharedPrivateLinkResourceListPage) NotDone() bool {
	return !page.splrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SharedPrivateLinkResourceListPage) Response() SharedPrivateLinkResourceList {
	return page.splrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SharedPrivateLinkResourceListPage) Values() []SharedPrivateLinkResource {
	if page.splrl.IsEmpty() {
		return nil
	}
	return *page.splrl.Value
}

// Creates a new instance of the SharedPrivateLinkResourceListPage type.
func NewSharedPrivateLinkResourceListPage(cur SharedPrivateLinkResourceList, getNextPage func(context.Context, SharedPrivateLinkResourceList) (SharedPrivateLinkResourceList, error)) SharedPrivateLinkResourceListPage {
	return SharedPrivateLinkResourceListPage{
		fn:    getNextPage,
		splrl: cur,
	}
}

// SharedPrivateLinkResourceProperties describes the properties of an existing Shared Private Link Resource
type SharedPrivateLinkResourceProperties struct {
	// GroupID - The group id from the provider of resource the shared private link resource is for
	GroupID *string `json:"groupId,omitempty"`
	// PrivateLinkResourceID - The resource id of the resource the shared private link resource is for
	PrivateLinkResourceID *string `json:"privateLinkResourceId,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the shared private link resource. Possible values include: 'ProvisioningStateUnknown', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateRunning', 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateMoving'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// RequestMessage - The request message for requesting approval of the shared private link resource
	RequestMessage *string `json:"requestMessage,omitempty"`
	// Status - READ-ONLY; Status of the shared private link resource. Possible values include: 'SharedPrivateLinkResourceStatusPending', 'SharedPrivateLinkResourceStatusApproved', 'SharedPrivateLinkResourceStatusRejected', 'SharedPrivateLinkResourceStatusDisconnected', 'SharedPrivateLinkResourceStatusTimeout'
	Status SharedPrivateLinkResourceStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for SharedPrivateLinkResourceProperties.
func (splrp SharedPrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if splrp.GroupID != nil {
		objectMap["groupId"] = splrp.GroupID
	}
	if splrp.PrivateLinkResourceID != nil {
		objectMap["privateLinkResourceId"] = splrp.PrivateLinkResourceID
	}
	if splrp.RequestMessage != nil {
		objectMap["requestMessage"] = splrp.RequestMessage
	}
	return json.Marshal(objectMap)
}

// SharedPrivateLinkResourcesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type SharedPrivateLinkResourcesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SharedPrivateLinkResourcesClient) (SharedPrivateLinkResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SharedPrivateLinkResourcesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SharedPrivateLinkResourcesCreateOrUpdateFuture.Result.
func (future *SharedPrivateLinkResourcesCreateOrUpdateFuture) result(client SharedPrivateLinkResourcesClient) (splr SharedPrivateLinkResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "webpubsub.SharedPrivateLinkResourcesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		splr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("webpubsub.SharedPrivateLinkResourcesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if splr.Response.Response, err = future.GetResult(sender); err == nil && splr.Response.Response.StatusCode != http.StatusNoContent {
		splr, err = client.CreateOrUpdateResponder(splr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "webpubsub.SharedPrivateLinkResourcesCreateOrUpdateFuture", "Result", splr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SharedPrivateLinkResourcesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SharedPrivateLinkResourcesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SharedPrivateLinkResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SharedPrivateLinkResourcesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SharedPrivateLinkResourcesDeleteFuture.Result.
func (future *SharedPrivateLinkResourcesDeleteFuture) result(client SharedPrivateLinkResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "webpubsub.SharedPrivateLinkResourcesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("webpubsub.SharedPrivateLinkResourcesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SignalRServiceUsage object that describes a specific usage of the resources.
type SignalRServiceUsage struct {
	// ID - Fully qualified ARM resource id
	ID *string `json:"id,omitempty"`
	// CurrentValue - Current value for the usage quota.
	CurrentValue *int64 `json:"currentValue,omitempty"`
	// Limit - The maximum permitted value for the usage quota. If there is no limit, this value will be -1.
	Limit *int64 `json:"limit,omitempty"`
	// Name - Localizable String object containing the name and a localized value.
	Name *SignalRServiceUsageName `json:"name,omitempty"`
	// Unit - Representing the units of the usage quota. Possible values are: Count, Bytes, Seconds, Percent, CountPerSecond, BytesPerSecond.
	Unit *string `json:"unit,omitempty"`
}

// SignalRServiceUsageList object that includes an array of the resource usages and a possible link for
// next set.
type SignalRServiceUsageList struct {
	autorest.Response `json:"-"`
	// Value - List of the resource usages
	Value *[]SignalRServiceUsage `json:"value,omitempty"`
	// NextLink - The URL the client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// SignalRServiceUsageListIterator provides access to a complete listing of SignalRServiceUsage values.
type SignalRServiceUsageListIterator struct {
	i    int
	page SignalRServiceUsageListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SignalRServiceUsageListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SignalRServiceUsageListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SignalRServiceUsageListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SignalRServiceUsageListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SignalRServiceUsageListIterator) Response() SignalRServiceUsageList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SignalRServiceUsageListIterator) Value() SignalRServiceUsage {
	if !iter.page.NotDone() {
		return SignalRServiceUsage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SignalRServiceUsageListIterator type.
func NewSignalRServiceUsageListIterator(page SignalRServiceUsageListPage) SignalRServiceUsageListIterator {
	return SignalRServiceUsageListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (srsul SignalRServiceUsageList) IsEmpty() bool {
	return srsul.Value == nil || len(*srsul.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (srsul SignalRServiceUsageList) hasNextLink() bool {
	return srsul.NextLink != nil && len(*srsul.NextLink) != 0
}

// signalRServiceUsageListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (srsul SignalRServiceUsageList) signalRServiceUsageListPreparer(ctx context.Context) (*http.Request, error) {
	if !srsul.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(srsul.NextLink)))
}

// SignalRServiceUsageListPage contains a page of SignalRServiceUsage values.
type SignalRServiceUsageListPage struct {
	fn    func(context.Context, SignalRServiceUsageList) (SignalRServiceUsageList, error)
	srsul SignalRServiceUsageList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SignalRServiceUsageListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SignalRServiceUsageListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.srsul)
		if err != nil {
			return err
		}
		page.srsul = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SignalRServiceUsageListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SignalRServiceUsageListPage) NotDone() bool {
	return !page.srsul.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SignalRServiceUsageListPage) Response() SignalRServiceUsageList {
	return page.srsul
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SignalRServiceUsageListPage) Values() []SignalRServiceUsage {
	if page.srsul.IsEmpty() {
		return nil
	}
	return *page.srsul.Value
}

// Creates a new instance of the SignalRServiceUsageListPage type.
func NewSignalRServiceUsageListPage(cur SignalRServiceUsageList, getNextPage func(context.Context, SignalRServiceUsageList) (SignalRServiceUsageList, error)) SignalRServiceUsageListPage {
	return SignalRServiceUsageListPage{
		fn:    getNextPage,
		srsul: cur,
	}
}

// SignalRServiceUsageName localizable String object containing the name and a localized value.
type SignalRServiceUsageName struct {
	// Value - The identifier of the usage.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - Localized name of the usage.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// Sku describes an available sku."
type Sku struct {
	// ResourceType - READ-ONLY; The resource type that this object applies to
	ResourceType *string `json:"resourceType,omitempty"`
	// Sku - READ-ONLY; The exact set of keys that define this sku.
	Sku *ResourceSku `json:"sku,omitempty"`
	// Capacity - READ-ONLY; Specifies the unit of the resource.
	Capacity *SkuCapacity `json:"capacity,omitempty"`
}

// MarshalJSON is the custom marshaler for Sku.
func (s Sku) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SkuCapacity describes scaling information of a sku.
type SkuCapacity struct {
	// Minimum - READ-ONLY; The lowest permitted capacity for this resource
	Minimum *int32 `json:"minimum,omitempty"`
	// Maximum - READ-ONLY; The highest permitted capacity for this resource
	Maximum *int32 `json:"maximum,omitempty"`
	// Default - READ-ONLY; The default capacity.
	Default *int32 `json:"default,omitempty"`
	// AllowedValues - READ-ONLY; Allows capacity value list.
	AllowedValues *[]int32 `json:"allowedValues,omitempty"`
	// ScaleType - READ-ONLY; The scale type applicable to the sku. Possible values include: 'ScaleTypeNone', 'ScaleTypeManual', 'ScaleTypeAutomatic'
	ScaleType ScaleType `json:"scaleType,omitempty"`
}

// MarshalJSON is the custom marshaler for SkuCapacity.
func (sc SkuCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SkuList the list skus operation response
type SkuList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of skus available for the resource.
	Value *[]Sku `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL the client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SkuList.
func (sl SkuList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TLSSettings TLS settings for the resource
type TLSSettings struct {
	// ClientCertEnabled - Request client certificate during TLS handshake if enabled
	ClientCertEnabled *bool `json:"clientCertEnabled,omitempty"`
}

// TrackedResource the resource model definition for a ARM tracked top level resource.
type TrackedResource struct {
	// Location - The GEO location of the resource. e.g. West US | East US | North Central US | South Central US.
	Location *string `json:"location,omitempty"`
	// Tags - Tags of the service which is a list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// UpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type UpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (ResourceType, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *UpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for UpdateFuture.Result.
func (future *UpdateFuture) result(client Client) (rt ResourceType, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "webpubsub.UpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		rt.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("webpubsub.UpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rt.Response.Response, err = future.GetResult(sender); err == nil && rt.Response.Response.StatusCode != http.StatusNoContent {
		rt, err = client.UpdateResponder(rt.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "webpubsub.UpdateFuture", "Result", rt.Response.Response, "Failure responding to request")
		}
	}
	return
}

// UpstreamAuthSettings upstream auth settings.
type UpstreamAuthSettings struct {
	// Type - Gets or sets the type of auth. None or ManagedIdentity is supported now. Possible values include: 'UpstreamAuthTypeNone', 'UpstreamAuthTypeManagedIdentity'
	Type UpstreamAuthType `json:"type,omitempty"`
	// ManagedIdentity - Gets or sets the managed identity settings. It's required if the auth type is set to ManagedIdentity.
	ManagedIdentity *ManagedIdentitySettings `json:"managedIdentity,omitempty"`
}

// UserAssignedIdentityProperty properties of user assigned identity.
type UserAssignedIdentityProperty struct {
	// PrincipalID - READ-ONLY; Get the principal id for the user assigned identity
	PrincipalID *string `json:"principalId,omitempty"`
	// ClientID - READ-ONLY; Get the client id for the user assigned identity
	ClientID *string `json:"clientId,omitempty"`
}

// MarshalJSON is the custom marshaler for UserAssignedIdentityProperty.
func (uaip UserAssignedIdentityProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}
