/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.OS;

public class ImageList {
    long[] surfaces;
    int width = -1;
    int height = -1;
    Image[] images = new Image[4];

    public ImageList() {
        this.surfaces = new long[4];
    }

    public static long convertSurface(Image image) {
        long newSurface = image.surface;
        int type = Cairo.cairo_surface_get_type(newSurface);
        if (type != 0) {
            long cairo;
            Rectangle bounds = DPIUtil.useCairoAutoScale() ? image.getBounds() : image.getBoundsInPixels();
            int format = Cairo.cairo_surface_get_content(newSurface) == 4096 ? 1 : 0;
            if ((newSurface = Cairo.cairo_image_surface_create(format, bounds.width, bounds.height)) == 0L) {
                SWT.error(2);
            }
            if (DPIUtil.useCairoAutoScale()) {
                double[] sx = new double[1];
                double[] sy = new double[1];
                Cairo.cairo_surface_get_device_scale(image.surface, sx, sy);
                if (sx[0] == 0.0 || sy[0] == 0.0) {
                    sx[0] = sy[0] = (double)((float)DPIUtil.getDeviceZoom() / 100.0f);
                }
                Cairo.cairo_surface_set_device_scale(newSurface, sx[0], sy[0]);
            }
            if ((cairo = Cairo.cairo_create(newSurface)) == 0L) {
                SWT.error(2);
            }
            Cairo.cairo_set_operator(cairo, 1);
            Cairo.cairo_set_source_surface(cairo, image.surface, 0.0, 0.0);
            Cairo.cairo_paint(cairo);
            Cairo.cairo_destroy(cairo);
        } else {
            Cairo.cairo_surface_reference(newSurface);
        }
        return newSurface;
    }

    public static long createPixbuf(long surface) {
        int ob;
        int og;
        int or;
        int oa;
        int height;
        int width;
        int format = Cairo.cairo_image_surface_get_format(surface);
        boolean hasAlpha = format == 0;
        long pixbuf = GDK.gdk_pixbuf_new(0, hasAlpha, 8, width = Cairo.cairo_image_surface_get_width(surface), height = Cairo.cairo_image_surface_get_height(surface));
        if (pixbuf == 0L) {
            SWT.error(2);
        }
        int stride = GDK.gdk_pixbuf_get_rowstride(pixbuf);
        long pixels = GDK.gdk_pixbuf_get_pixels(pixbuf);
        if (OS.BIG_ENDIAN) {
            oa = 0;
            or = 1;
            og = 2;
            ob = 3;
        } else {
            oa = 3;
            or = 2;
            og = 1;
            ob = 0;
        }
        byte[] line = new byte[stride];
        long surfaceData = Cairo.cairo_image_surface_get_data(surface);
        if (hasAlpha) {
            for (int y = 0; y < height; ++y) {
                C.memmove(line, surfaceData + (long)(y * stride), (long)stride);
                int x = 0;
                int offset = 0;
                while (x < width) {
                    int a = line[offset + oa] & 0xFF;
                    int r = line[offset + or] & 0xFF;
                    int g = line[offset + og] & 0xFF;
                    int b = line[offset + ob] & 0xFF;
                    line[offset + 3] = (byte)a;
                    if (a != 0) {
                        line[offset + 0] = (byte)((r * 255 + a / 2) / a);
                        line[offset + 1] = (byte)((g * 255 + a / 2) / a);
                        line[offset + 2] = (byte)((b * 255 + a / 2) / a);
                    }
                    ++x;
                    offset += 4;
                }
                C.memmove(pixels + (long)(y * stride), line, (long)stride);
            }
        } else {
            int cairoStride = Cairo.cairo_image_surface_get_stride(surface);
            byte[] cairoLine = new byte[cairoStride];
            for (int y = 0; y < height; ++y) {
                C.memmove(cairoLine, surfaceData + (long)(y * cairoStride), (long)cairoStride);
                int x = 0;
                int offset = 0;
                int cairoOffset = 0;
                while (x < width) {
                    byte r = cairoLine[cairoOffset + or];
                    byte g = cairoLine[cairoOffset + og];
                    byte b = cairoLine[cairoOffset + ob];
                    line[offset + 0] = r;
                    line[offset + 1] = g;
                    line[offset + 2] = b;
                    ++x;
                    offset += 3;
                    cairoOffset += 4;
                }
                C.memmove(pixels + (long)(y * stride), line, (long)stride);
            }
        }
        if (DPIUtil.useCairoAutoScale()) {
            double[] sx = new double[1];
            double[] sy = new double[1];
            Cairo.cairo_surface_get_device_scale(surface, sx, sy);
            if (sx[0] > 1.0 && sy[0] > 1.0) {
                long oldPixbuf = pixbuf;
                pixbuf = GDK.gdk_pixbuf_scale_simple(pixbuf, width / (int)sx[0], height / (int)sy[0], 2);
                OS.g_object_unref(oldPixbuf);
            }
        }
        return pixbuf;
    }

    public static long createPixbuf(Image image) {
        int ob;
        int og;
        int or;
        int oa;
        int height;
        int width;
        long surface = ImageList.convertSurface(image);
        int format = Cairo.cairo_image_surface_get_format(surface);
        boolean hasAlpha = format == 0;
        long pixbuf = GDK.gdk_pixbuf_new(0, hasAlpha, 8, width = Cairo.cairo_image_surface_get_width(surface), height = Cairo.cairo_image_surface_get_height(surface));
        if (pixbuf == 0L) {
            SWT.error(2);
        }
        int stride = GDK.gdk_pixbuf_get_rowstride(pixbuf);
        long pixels = GDK.gdk_pixbuf_get_pixels(pixbuf);
        if (OS.BIG_ENDIAN) {
            oa = 0;
            or = 1;
            og = 2;
            ob = 3;
        } else {
            oa = 3;
            or = 2;
            og = 1;
            ob = 0;
        }
        byte[] line = new byte[stride];
        long surfaceData = Cairo.cairo_image_surface_get_data(surface);
        if (hasAlpha) {
            for (int y = 0; y < height; ++y) {
                C.memmove(line, surfaceData + (long)(y * stride), (long)stride);
                int x = 0;
                int offset = 0;
                while (x < width) {
                    int a = line[offset + oa] & 0xFF;
                    int r = line[offset + or] & 0xFF;
                    int g = line[offset + og] & 0xFF;
                    int b = line[offset + ob] & 0xFF;
                    line[offset + 3] = (byte)a;
                    if (a != 0) {
                        line[offset + 0] = (byte)((r * 255 + a / 2) / a);
                        line[offset + 1] = (byte)((g * 255 + a / 2) / a);
                        line[offset + 2] = (byte)((b * 255 + a / 2) / a);
                    }
                    ++x;
                    offset += 4;
                }
                C.memmove(pixels + (long)(y * stride), line, (long)stride);
            }
        } else {
            int cairoStride = Cairo.cairo_image_surface_get_stride(surface);
            byte[] cairoLine = new byte[cairoStride];
            for (int y = 0; y < height; ++y) {
                C.memmove(cairoLine, surfaceData + (long)(y * cairoStride), (long)cairoStride);
                int x = 0;
                int offset = 0;
                int cairoOffset = 0;
                while (x < width) {
                    byte r = cairoLine[cairoOffset + or];
                    byte g = cairoLine[cairoOffset + og];
                    byte b = cairoLine[cairoOffset + ob];
                    line[offset + 0] = r;
                    line[offset + 1] = g;
                    line[offset + 2] = b;
                    ++x;
                    offset += 3;
                    cairoOffset += 4;
                }
                C.memmove(pixels + (long)(y * stride), line, (long)stride);
            }
        }
        Cairo.cairo_surface_destroy(surface);
        return pixbuf;
    }

    public int add(Image image) {
        int index;
        for (index = 0; index < this.images.length; ++index) {
            if (this.images[index] != null && this.images[index].isDisposed()) {
                Cairo.cairo_surface_destroy(this.surfaces[index]);
                this.images[index] = null;
                this.surfaces[index] = 0L;
            }
            if (this.images[index] == null) break;
        }
        if (index == this.images.length) {
            Image[] newImages = new Image[this.images.length + 4];
            System.arraycopy(this.images, 0, newImages, 0, this.images.length);
            this.images = newImages;
            long[] newPixbufs = new long[this.surfaces.length + 4];
            System.arraycopy(this.surfaces, 0, newPixbufs, 0, this.surfaces.length);
            this.surfaces = newPixbufs;
        }
        this.set(index, image);
        return index;
    }

    public void dispose() {
        if (this.surfaces == null) {
            return;
        }
        for (int index = 0; index < this.surfaces.length; ++index) {
            long surface = this.surfaces[index];
            if (surface == 0L) continue;
            Cairo.cairo_surface_destroy(surface);
        }
        this.images = null;
        this.surfaces = null;
    }

    public Image get(int index) {
        return this.images[index];
    }

    public long getSurface(int index) {
        return this.surfaces[index];
    }

    public int indexOf(Image image) {
        if (image == null) {
            return -1;
        }
        for (int index = 0; index < this.images.length; ++index) {
            if (image != this.images[index]) continue;
            return index;
        }
        return -1;
    }

    public int indexOf(long pixbuf) {
        if (pixbuf == 0L) {
            return -1;
        }
        for (int index = 0; index < this.images.length; ++index) {
            if (pixbuf != this.surfaces[index]) continue;
            return index;
        }
        return -1;
    }

    public boolean isDisposed() {
        return this.images == null;
    }

    public void put(int index, Image image) {
        int count = this.images.length;
        if (0 > index || index >= count) {
            return;
        }
        if (image != null) {
            this.set(index, image);
        } else {
            this.images[index] = null;
            if (this.surfaces[index] != 0L) {
                Cairo.cairo_surface_destroy(this.surfaces[index]);
            }
            this.surfaces[index] = 0L;
        }
    }

    public void remove(Image image) {
        if (image == null) {
            return;
        }
        for (int index = 0; index < this.images.length; ++index) {
            if (image != this.images[index]) continue;
            this.images[index] = null;
            Cairo.cairo_surface_destroy(this.surfaces[index]);
            this.surfaces[index] = 0L;
        }
    }

    void set(int index, Image image) {
        long oldSurface;
        long surface = ImageList.convertSurface(image);
        int w = Cairo.cairo_image_surface_get_width(surface);
        int h = Cairo.cairo_image_surface_get_height(surface);
        Rectangle bounds = DPIUtil.useCairoAutoScale() ? image.getBounds() : image.getBoundsInPixels();
        if (w == 0) {
            w = bounds.width;
        }
        if (h == 0) {
            h = bounds.height;
        }
        if (this.width == -1 || this.height == -1) {
            this.width = w;
            this.height = h;
        }
        if (w != this.width || h != this.height) {
            surface = this.scaleSurface(image, this.width, this.height);
        }
        if ((oldSurface = this.surfaces[index]) != 0L) {
            Cairo.cairo_surface_destroy(oldSurface);
        }
        Cairo.cairo_surface_reference(surface);
        this.surfaces[index] = surface;
        this.images[index] = image;
    }

    long scaleSurface(Image image, int width, int height) {
        Rectangle bounds;
        long cairo;
        int format = Cairo.cairo_surface_get_content(image.surface) == 4096 ? 1 : 0;
        long scaledSurface = Cairo.cairo_image_surface_create(format, width, height);
        if (scaledSurface == 0L) {
            SWT.error(2);
        }
        if ((cairo = Cairo.cairo_create(scaledSurface)) == 0L) {
            SWT.error(2);
        }
        if (DPIUtil.useCairoAutoScale()) {
            int w = Cairo.cairo_image_surface_get_width(image.surface);
            int h = Cairo.cairo_image_surface_get_height(image.surface);
            bounds = w == 0 && h == 0 ? image.getBounds() : new Rectangle(0, 0, w, h);
            double[] sx = new double[1];
            double[] sy = new double[1];
            Cairo.cairo_surface_get_device_scale(image.surface, sx, sy);
            if (sx[0] == 0.0 || sy[0] == 0.0) {
                sx[0] = sy[0] = (double)((float)DPIUtil.getDeviceZoom() / 100.0f);
            }
            Cairo.cairo_surface_set_device_scale(scaledSurface, sx[0], sy[0]);
        } else {
            bounds = image.getBoundsInPixels();
        }
        double scaleX = (double)width / (double)bounds.width;
        double scaleY = (double)height / (double)bounds.height;
        Cairo.cairo_scale(cairo, scaleX, scaleY);
        Cairo.cairo_set_operator(cairo, 1);
        Cairo.cairo_set_source_surface(cairo, image.surface, 0.0, 0.0);
        Cairo.cairo_paint(cairo);
        Cairo.cairo_destroy(cairo);
        return scaledSurface;
    }
}

