/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.graphtofiles;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.graph.graphtofiles.GraphToFilesCtrlr;
import net.sourceforge.squirrel_sql.plugins.graph.graphtofiles.ImageSelection;

public class GraphToFilesDlg
extends JDialog {
    JTabbedPane tabPages;
    JButton btnSaveToFile;
    JButton btnClose;
    JLabel[] lblPages;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GraphToFilesCtrlr.class);

    public GraphToFilesDlg(Window parent, BufferedImage[] images) throws HeadlessException {
        super(parent);
        this.setTitle(s_stringMgr.getString("graphToFile.title"));
        this.buildGui();
        this.lblPages = new JLabel[images.length];
        for (int i = 0; i < images.length; ++i) {
            this.lblPages[i] = new JLabel(new ImageIcon(images[i]));
            this.lblPages[i].setTransferHandler(new ImageSelection());
            this.tabPages.addTab("" + (i + 1), new JScrollPane(this.lblPages[i]));
        }
        this.setSize(500, 450);
        this.setVisible(true);
        GUIUtils.centerWithinParent((Window)this);
    }

    private void buildGui() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.tabPages = new JTabbedPane();
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this.tabPages, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this.createButtonPanel(), gbc);
    }

    private JPanel createButtonPanel() {
        JPanel ret = new JPanel();
        this.btnSaveToFile = new JButton(s_stringMgr.getString("graphToFile.saveFilesTo"));
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)this.btnSaveToFile, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)new JPanel(), gbc);
        this.btnClose = new JButton(s_stringMgr.getString("graphToClipboard.closeButton"));
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)this.btnClose, gbc);
        return ret;
    }
}

