/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tinylaf.controlpanel;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import net.sf.tinylaf.controlpanel.ControlPanel;
import net.sf.tinylaf.controlpanel.ParameterSet;
import net.sf.tinylaf.controlpanel.ParameterSetGenerator;
import net.sf.tinylaf.controlpanel.SBControl;
import net.sf.tinylaf.controlpanel.Selectable;

public class Selection
implements ParameterSetGenerator {
    private Vector selection = new Vector();
    private Vector storedSelection;
    private static ControlPanel controlPanel;
    private static Selection onlyInstance;

    private Selection() {
    }

    public static Selection getSelection(ControlPanel cp) {
        controlPanel = cp;
        if (onlyInstance == null) {
            onlyInstance = new Selection();
        }
        return onlyInstance;
    }

    public void add(Selectable control) {
        this.selection.add(control);
        control.setSelected(true);
        if (!Selection.controlPanel.copyItem.isEnabled()) {
            Selection.controlPanel.copyItem.setEnabled(true);
        }
    }

    public boolean remove(Selectable control) {
        control.setSelected(false);
        boolean retVal = this.selection.remove(control);
        if (this.selection.isEmpty() && Selection.controlPanel.copyItem.isEnabled()) {
            Selection.controlPanel.copyItem.setEnabled(false);
        }
        return retVal;
    }

    public void clearSelection() {
        if (this.selection.isEmpty()) {
            return;
        }
        Iterator ii = ((AbstractList)this.selection).iterator();
        while (ii.hasNext()) {
            ((Selectable)ii.next()).setSelected(false);
        }
        this.selection.clear();
        if (Selection.controlPanel.copyItem.isEnabled()) {
            Selection.controlPanel.copyItem.setEnabled(false);
        }
    }

    public ParameterSet createParameterSet() {
        this.storedSelection = (Vector)this.selection.clone();
        ParameterSet ps = new ParameterSet(this, "");
        Iterator ii = ((AbstractList)this.storedSelection).iterator();
        while (ii.hasNext()) {
            Object control = ii.next();
            if (control instanceof ControlPanel.HSBControl) {
                ps.addParameter((ControlPanel.HSBControl)control);
                continue;
            }
            if (control instanceof SBControl) {
                ps.addParameter((SBControl)control);
                continue;
            }
            if (!(control instanceof ControlPanel.SpreadControl)) continue;
            ps.addParameter((ControlPanel.SpreadControl)control);
        }
        return ps;
    }

    public ParameterSet getParameterSet() {
        ParameterSet ps = new ParameterSet(this, "Selection");
        Iterator ii = ((AbstractList)this.storedSelection).iterator();
        while (ii.hasNext()) {
            Object control = ii.next();
            if (control instanceof ControlPanel.HSBControl) {
                ps.addParameter((ControlPanel.HSBControl)control);
                continue;
            }
            if (control instanceof SBControl) {
                ps.addParameter((SBControl)control);
                continue;
            }
            if (!(control instanceof ControlPanel.SpreadControl)) continue;
            ps.addParameter((ControlPanel.SpreadControl)control);
        }
        return ps;
    }

    public void init(boolean ignored) {
        Iterator ii = ((AbstractList)this.storedSelection).iterator();
        while (ii.hasNext()) {
            Object control = ii.next();
            if (control instanceof ControlPanel.HSBControl) {
                ((ControlPanel.HSBControl)control).update();
                continue;
            }
            if (control instanceof SBControl) {
                ((SBControl)control).update();
                continue;
            }
            if (!(control instanceof ControlPanel.SpreadControl)) continue;
            ((ControlPanel.SpreadControl)control).init();
        }
    }
}

