/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gCLINE.pane;

import edu.harvard.mgh.purcell.gCLINE.PopUpMenu;
import edu.harvard.mgh.purcell.gCLINE.StartFrame;
import edu.harvard.mgh.purcell.gCLINE.data.OperationInfo;
import edu.harvard.mgh.purcell.gCLINE.data.Record;
import edu.harvard.mgh.purcell.gCLINE.pane.FileTransferHandler;
import edu.harvard.mgh.purcell.gCLINE.pane.FileView;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public abstract class OpView {
    private static Logger logger = Logger.getLogger(OpView.class);
    protected JTree myTree;
    private Record data;
    private StartFrame frame;
    private FileView fileViewer;
    private MouseListener treeEvents = new MouseListener(){

        public void mousePressed(MouseEvent e) {
            this.checkEvent(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.checkEvent(e);
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        private void checkEvent(MouseEvent e) {
            logger.info("[treeEvents.checkEvent(MouseEvent)] entering");
            if (e.isPopupTrigger()) {
                logger.info("[treeEvents.checkEvent(MouseEvent)] PopUp triggered");
                if (OpView.this.myTree.getSelectionModel().getSelectionPaths() != null) {
                    String[] filename = new String[1];
                    if (OpView.this.myTree.getSelectionPaths()[0].getPathCount() >= 4) {
                        filename[0] = OpView.this.myTree.getSelectionPaths()[0].getPath()[3].toString();
                    } else {
                        filename = null;
                    }
                    String[] opname = new String[1];
                    if (OpView.this.myTree.getSelectionPaths()[0].getPathCount() >= 2) {
                        String temp = OpView.this.myTree.getSelectionPaths()[0].getPath()[1].toString();
                        opname[0] = temp = temp.split(":")[0];
                    } else {
                        opname = null;
                    }
                    OpView.this.createPopUp(OpView.this.frame, OpView.this.data, filename, opname).show(e.getComponent(), e.getX(), e.getY());
                }
            } else {
                logger.info("[treeEvents.checkEvent(MouseEvent)] event not triggered");
            }
        }
    };
    private Action swapOpDown = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            TreePath current = OpView.this.myTree.getSelectionPath();
            int currentrow = OpView.this.myTree.getSelectionRows()[0];
            DefaultMutableTreeNode currentOp = (DefaultMutableTreeNode)current.getPath()[1];
            DefaultMutableTreeNode next = currentOp.getNextSibling();
            if (next != null) {
                ((DefaultMutableTreeNode)next.getParent()).insert(currentOp, currentrow + 1);
                OpView.this.data.reload();
                OpView.this.myTree.addSelectionRow(currentrow + 1);
            }
        }
    };
    private Action swapOpUp = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            TreePath current = OpView.this.myTree.getSelectionPath();
            int currentrow = OpView.this.myTree.getSelectionRows()[0];
            DefaultMutableTreeNode currentOp = (DefaultMutableTreeNode)current.getPath()[1];
            DefaultMutableTreeNode previous = currentOp.getPreviousSibling();
            if (previous != null) {
                ((DefaultMutableTreeNode)previous.getParent()).insert(currentOp, currentrow - 1);
                OpView.this.data.reload();
                OpView.this.myTree.setSelectionRow(currentrow - 1);
            }
        }
    };

    protected abstract PopUpMenu createPopUp(StartFrame var1, Record var2, String[] var3, String[] var4);

    public OpView(Record d, FileView f) {
        this.data = d;
        this.frame = this.data.frame;
        this.fileViewer = f;
        this.myTree = new JTree(this.data);
        this.myTree.setEditable(true);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                if (OpView.this.myTree.getSelectionCount() == 0) {
                    return;
                }
                File logFile = ((OperationInfo)OpView.this.myTree.getSelectionPath().getPath()[1]).getLog(OpView.this.data.getLocalFolder(), OpView.this.data.getLogExt());
                if (logFile == null) {
                    OpView.this.fileViewer.viewFile("");
                    logger.info("[OpView(...)] no log file found to read");
                } else {
                    OpView.this.fileViewer.viewFile(logFile.toString());
                    logger.info("[OpView(...)] reading: " + logFile.getName());
                }
            }
        });
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setDragEnabled(true);
        this.myTree.addMouseListener(this.treeEvents);
        this.myTree.getInputMap().put(KeyStroke.getKeyStroke("control 1"), "move up");
        this.myTree.getActionMap().put("move up", this.swapOpUp);
        this.myTree.getInputMap().put(KeyStroke.getKeyStroke("control 2"), "move down");
        this.myTree.getActionMap().put("move down", this.swapOpDown);
        this.myTree.setTransferHandler(new FileTransferHandler());
        this.myTree.setDragEnabled(true);
    }

    public JScrollPane toJScrollPane() {
        JScrollPane ans = new JScrollPane(this.myTree);
        ans.setBorder(new TitledBorder("Operations Viewer"));
        return ans;
    }
}

