/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class SshAgentKeyList
extends SubsystemMessage {
    public static final int SSH_AGENT_KEY_LIST = 104;
    private Map keys;

    public SshAgentKeyList(Map keys) {
        super(104);
        this.keys = keys;
    }

    public SshAgentKeyList() {
        super(104);
        this.keys = new HashMap();
    }

    public Map getKeys() {
        return this.keys;
    }

    public String getMessageName() {
        return "SSH_AGENT_KEY_LIST";
    }

    public void constructByteArray(ByteArrayWriter baw) throws IOException, InvalidMessageException {
        try {
            baw.writeInt(this.keys.size());
            for (Map.Entry entry : this.keys.entrySet()) {
                SshPublicKey key = (SshPublicKey)entry.getKey();
                String description = (String)entry.getValue();
                baw.writeBinaryString(key.getEncoded());
                baw.writeString(description);
            }
        }
        catch (IOException ex) {
            throw new InvalidMessageException("Failed to write message data");
        }
    }

    public void constructMessage(ByteArrayReader bar) throws IOException, InvalidMessageException {
        try {
            int num = (int)bar.readInt();
            int i = 0;
            while (i < num) {
                byte[] buf = bar.readBinaryString();
                SshPublicKey key = SshKeyPairFactory.decodePublicKey(buf);
                String description = bar.readString();
                this.keys.put(key, description);
                ++i;
            }
        }
        catch (IOException ex) {
            throw new InvalidMessageException("Failed to read message data");
        }
    }
}

