/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.pentaho.reporting.libraries.pixie.wmf.MfDcState;
import org.pentaho.reporting.libraries.pixie.wmf.MfLogBrush;
import org.pentaho.reporting.libraries.pixie.wmf.MfLogRegion;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;

public class MfCmdFillRegion
extends MfCmd {
    private static final int RECORD_SIZE = 2;
    private static final int POS_REGION = 0;
    private static final int POS_BRUSH = 1;
    private int brushObjectNr;
    private int regionObjectNr;

    public void replay(WmfFile file) {
        MfLogBrush brush = file.getBrushObject(this.brushObjectNr);
        MfLogRegion regio = file.getRegionObject(this.regionObjectNr);
        MfDcState state = file.getCurrentState();
        state.setLogRegion(regio);
        state.setLogBrush(brush);
        Graphics2D graph = file.getGraphics2D();
        Rectangle rec = this.scaleRect(regio.getBounds());
        Rectangle2D.Double rect = new Rectangle2D.Double();
        rect.setFrame(rec.x, rec.y, rec.width, rec.height);
        if (brush.isVisible()) {
            state.preparePaint();
            graph.fill(rect);
            state.postPaint();
        }
    }

    public MfCmd getInstance() {
        return new MfCmdFillRegion();
    }

    public void setRecord(MfRecord record) {
        int regio = record.getParam(0);
        int brush = record.getParam(1);
        this.setBrush(brush);
        this.setRegion(regio);
    }

    public MfRecord getRecord() {
        MfRecord record = new MfRecord(2);
        record.setParam(0, this.getRegion());
        record.setParam(1, this.getBrush());
        return record;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[FILL_REGION] brush=");
        b.append(this.getBrush());
        b.append(" region=");
        b.append(this.getRegion());
        return b.toString();
    }

    public int getBrush() {
        return this.brushObjectNr;
    }

    public void setBrush(int brush) {
        this.brushObjectNr = brush;
    }

    public int getRegion() {
        return this.regionObjectNr;
    }

    public void setRegion(int region) {
        this.regionObjectNr = region;
    }

    public int getFunction() {
        return 552;
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }
}

