// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/audit/bigquery_audit_metadata.proto

package audit

import (
	reflect "reflect"
	sync "sync"

	v1 "google.golang.org/genproto/googleapis/iam/v1"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Describes whether a job should overwrite or append the existing destination
// table if it already exists.
type BigQueryAuditMetadata_WriteDisposition int32

const (
	// Unknown.
	BigQueryAuditMetadata_WRITE_DISPOSITION_UNSPECIFIED BigQueryAuditMetadata_WriteDisposition = 0
	// This job should only be writing to empty tables.
	BigQueryAuditMetadata_WRITE_EMPTY BigQueryAuditMetadata_WriteDisposition = 1
	// This job will truncate the existing table data.
	BigQueryAuditMetadata_WRITE_TRUNCATE BigQueryAuditMetadata_WriteDisposition = 2
	// This job will append to the table.
	BigQueryAuditMetadata_WRITE_APPEND BigQueryAuditMetadata_WriteDisposition = 3
)

// Enum value maps for BigQueryAuditMetadata_WriteDisposition.
var (
	BigQueryAuditMetadata_WriteDisposition_name = map[int32]string{
		0: "WRITE_DISPOSITION_UNSPECIFIED",
		1: "WRITE_EMPTY",
		2: "WRITE_TRUNCATE",
		3: "WRITE_APPEND",
	}
	BigQueryAuditMetadata_WriteDisposition_value = map[string]int32{
		"WRITE_DISPOSITION_UNSPECIFIED": 0,
		"WRITE_EMPTY":                   1,
		"WRITE_TRUNCATE":                2,
		"WRITE_APPEND":                  3,
	}
)

func (x BigQueryAuditMetadata_WriteDisposition) Enum() *BigQueryAuditMetadata_WriteDisposition {
	p := new(BigQueryAuditMetadata_WriteDisposition)
	*p = x
	return p
}

func (x BigQueryAuditMetadata_WriteDisposition) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryAuditMetadata_WriteDisposition) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[0].Descriptor()
}

func (BigQueryAuditMetadata_WriteDisposition) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[0]
}

func (x BigQueryAuditMetadata_WriteDisposition) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryAuditMetadata_WriteDisposition.Descriptor instead.
func (BigQueryAuditMetadata_WriteDisposition) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 0}
}

// Table copy job operation type.
type BigQueryAuditMetadata_OperationType int32

const (
	// Unspecified operation type.
	BigQueryAuditMetadata_OPERATION_TYPE_UNSPECIFIED BigQueryAuditMetadata_OperationType = 0
	// The source and the destination table have the same table type.
	BigQueryAuditMetadata_COPY BigQueryAuditMetadata_OperationType = 1
	// The source table type is TABLE and
	// the destination table type is SNAPSHOT.
	BigQueryAuditMetadata_SNAPSHOT BigQueryAuditMetadata_OperationType = 2
	// The source table type is SNAPSHOT and
	// the destination table type is TABLE.
	BigQueryAuditMetadata_RESTORE BigQueryAuditMetadata_OperationType = 3
)

// Enum value maps for BigQueryAuditMetadata_OperationType.
var (
	BigQueryAuditMetadata_OperationType_name = map[int32]string{
		0: "OPERATION_TYPE_UNSPECIFIED",
		1: "COPY",
		2: "SNAPSHOT",
		3: "RESTORE",
	}
	BigQueryAuditMetadata_OperationType_value = map[string]int32{
		"OPERATION_TYPE_UNSPECIFIED": 0,
		"COPY":                       1,
		"SNAPSHOT":                   2,
		"RESTORE":                    3,
	}
)

func (x BigQueryAuditMetadata_OperationType) Enum() *BigQueryAuditMetadata_OperationType {
	p := new(BigQueryAuditMetadata_OperationType)
	*p = x
	return p
}

func (x BigQueryAuditMetadata_OperationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryAuditMetadata_OperationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[1].Descriptor()
}

func (BigQueryAuditMetadata_OperationType) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[1]
}

func (x BigQueryAuditMetadata_OperationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryAuditMetadata_OperationType.Descriptor instead.
func (BigQueryAuditMetadata_OperationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 1}
}

// Describes whether a job should create a destination table if it doesn't
// exist.
type BigQueryAuditMetadata_CreateDisposition int32

const (
	// Unknown.
	BigQueryAuditMetadata_CREATE_DISPOSITION_UNSPECIFIED BigQueryAuditMetadata_CreateDisposition = 0
	// This job should never create tables.
	BigQueryAuditMetadata_CREATE_NEVER BigQueryAuditMetadata_CreateDisposition = 1
	// This job should create a table if it doesn't already exist.
	BigQueryAuditMetadata_CREATE_IF_NEEDED BigQueryAuditMetadata_CreateDisposition = 2
)

// Enum value maps for BigQueryAuditMetadata_CreateDisposition.
var (
	BigQueryAuditMetadata_CreateDisposition_name = map[int32]string{
		0: "CREATE_DISPOSITION_UNSPECIFIED",
		1: "CREATE_NEVER",
		2: "CREATE_IF_NEEDED",
	}
	BigQueryAuditMetadata_CreateDisposition_value = map[string]int32{
		"CREATE_DISPOSITION_UNSPECIFIED": 0,
		"CREATE_NEVER":                   1,
		"CREATE_IF_NEEDED":               2,
	}
)

func (x BigQueryAuditMetadata_CreateDisposition) Enum() *BigQueryAuditMetadata_CreateDisposition {
	p := new(BigQueryAuditMetadata_CreateDisposition)
	*p = x
	return p
}

func (x BigQueryAuditMetadata_CreateDisposition) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryAuditMetadata_CreateDisposition) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[2].Descriptor()
}

func (BigQueryAuditMetadata_CreateDisposition) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[2]
}

func (x BigQueryAuditMetadata_CreateDisposition) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryAuditMetadata_CreateDisposition.Descriptor instead.
func (BigQueryAuditMetadata_CreateDisposition) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 2}
}

// State of a job.
type BigQueryAuditMetadata_JobState int32

const (
	// State unknown.
	BigQueryAuditMetadata_JOB_STATE_UNSPECIFIED BigQueryAuditMetadata_JobState = 0
	// Job is waiting for the resources.
	BigQueryAuditMetadata_PENDING BigQueryAuditMetadata_JobState = 1
	// Job is running.
	BigQueryAuditMetadata_RUNNING BigQueryAuditMetadata_JobState = 2
	// Job is done.
	BigQueryAuditMetadata_DONE BigQueryAuditMetadata_JobState = 3
)

// Enum value maps for BigQueryAuditMetadata_JobState.
var (
	BigQueryAuditMetadata_JobState_name = map[int32]string{
		0: "JOB_STATE_UNSPECIFIED",
		1: "PENDING",
		2: "RUNNING",
		3: "DONE",
	}
	BigQueryAuditMetadata_JobState_value = map[string]int32{
		"JOB_STATE_UNSPECIFIED": 0,
		"PENDING":               1,
		"RUNNING":               2,
		"DONE":                  3,
	}
)

func (x BigQueryAuditMetadata_JobState) Enum() *BigQueryAuditMetadata_JobState {
	p := new(BigQueryAuditMetadata_JobState)
	*p = x
	return p
}

func (x BigQueryAuditMetadata_JobState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryAuditMetadata_JobState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[3].Descriptor()
}

func (BigQueryAuditMetadata_JobState) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[3]
}

func (x BigQueryAuditMetadata_JobState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryAuditMetadata_JobState.Descriptor instead.
func (BigQueryAuditMetadata_JobState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 3}
}

// Type of the statement (e.g. SELECT, INSERT, CREATE_TABLE, CREATE_MODEL..)
type BigQueryAuditMetadata_QueryStatementType int32

const (
	// Unknown.
	BigQueryAuditMetadata_QUERY_STATEMENT_TYPE_UNSPECIFIED BigQueryAuditMetadata_QueryStatementType = 0
	// SELECT ... FROM &lt;Table list&gt; ...
	BigQueryAuditMetadata_SELECT BigQueryAuditMetadata_QueryStatementType = 1
	// ASSERT &lt;condition&gt; AS 'description'
	BigQueryAuditMetadata_ASSERT BigQueryAuditMetadata_QueryStatementType = 23
	// INSERT INTO &lt;Table&gt; ....
	BigQueryAuditMetadata_INSERT BigQueryAuditMetadata_QueryStatementType = 2
	// UPDATE &lt;Table&gt; SET ...
	BigQueryAuditMetadata_UPDATE BigQueryAuditMetadata_QueryStatementType = 3
	// DELETE &lt;Table&gt; ...
	BigQueryAuditMetadata_DELETE BigQueryAuditMetadata_QueryStatementType = 4
	// MERGE INTO &lt;Table&gt; ....
	BigQueryAuditMetadata_MERGE BigQueryAuditMetadata_QueryStatementType = 5
	// CREATE TABLE &lt;Table&gt; &lt;column list&gt;
	BigQueryAuditMetadata_CREATE_TABLE BigQueryAuditMetadata_QueryStatementType = 6
	// CREATE TABLE &lt;Table&gt; AS SELECT
	BigQueryAuditMetadata_CREATE_TABLE_AS_SELECT BigQueryAuditMetadata_QueryStatementType = 7
	// CREATE VIEW &lt;View&gt;
	BigQueryAuditMetadata_CREATE_VIEW BigQueryAuditMetadata_QueryStatementType = 8
	// CREATE MODEL &lt;Model&gt; AS &lt;Query&gt;
	BigQueryAuditMetadata_CREATE_MODEL BigQueryAuditMetadata_QueryStatementType = 9
	// CREATE MATERIALIZED VIEW &lt;View&gt; AS ...
	BigQueryAuditMetadata_CREATE_MATERIALIZED_VIEW BigQueryAuditMetadata_QueryStatementType = 13
	// CREATE FUNCTION &lt;Function&gt;(&lt;Signature&gt;) AS ...
	BigQueryAuditMetadata_CREATE_FUNCTION BigQueryAuditMetadata_QueryStatementType = 14
	// CREATE PROCEDURE &lt;Procedure&gt;
	BigQueryAuditMetadata_CREATE_PROCEDURE BigQueryAuditMetadata_QueryStatementType = 20
	// CREATE SCHEMA &lt;Schema&gt;
	BigQueryAuditMetadata_CREATE_SCHEMA BigQueryAuditMetadata_QueryStatementType = 53
	// DROP TABLE &lt;Table&gt;
	BigQueryAuditMetadata_DROP_TABLE BigQueryAuditMetadata_QueryStatementType = 10
	// DROP EXTERNAL TABLE &lt;Table&gt;
	BigQueryAuditMetadata_DROP_EXTERNAL_TABLE BigQueryAuditMetadata_QueryStatementType = 33
	// DROP VIEW &lt;View&gt;
	BigQueryAuditMetadata_DROP_VIEW BigQueryAuditMetadata_QueryStatementType = 11
	// DROP MODEL &lt;Model&gt;
	BigQueryAuditMetadata_DROP_MODEL BigQueryAuditMetadata_QueryStatementType = 12
	// DROP MATERIALIZED VIEW &lt;View&gt;
	BigQueryAuditMetadata_DROP_MATERIALIZED_VIEW BigQueryAuditMetadata_QueryStatementType = 15
	// DROP FUNCTION &lt;Function&gt;
	BigQueryAuditMetadata_DROP_FUNCTION BigQueryAuditMetadata_QueryStatementType = 16
	// DROP PROCEDURE &lt;Procedure&gt;
	BigQueryAuditMetadata_DROP_PROCEDURE BigQueryAuditMetadata_QueryStatementType = 21
	// DROP SCHEMA &lt;Schema&gt;
	BigQueryAuditMetadata_DROP_SCHEMA BigQueryAuditMetadata_QueryStatementType = 54
	// ALTER TABLE &lt;Table&gt;
	BigQueryAuditMetadata_ALTER_TABLE BigQueryAuditMetadata_QueryStatementType = 17
	// ALTER VIEW &lt;View&gt;
	BigQueryAuditMetadata_ALTER_VIEW BigQueryAuditMetadata_QueryStatementType = 18
	// ALTER MATERIALIZED_VIEW &lt;view&gt;
	BigQueryAuditMetadata_ALTER_MATERIALIZED_VIEW BigQueryAuditMetadata_QueryStatementType = 22
	// ALTER SCHEMA &lt;Schema&gt;
	BigQueryAuditMetadata_ALTER_SCHEMA BigQueryAuditMetadata_QueryStatementType = 55
	// Script
	BigQueryAuditMetadata_SCRIPT BigQueryAuditMetadata_QueryStatementType = 19
	// TRUNCATE TABLE &lt;Table&gt
	BigQueryAuditMetadata_TRUNCATE_TABLE BigQueryAuditMetadata_QueryStatementType = 26
	// CREATE EXTERNAL TABLE &lt;TABLE&gt;
	BigQueryAuditMetadata_CREATE_EXTERNAL_TABLE BigQueryAuditMetadata_QueryStatementType = 27
	// EXPORT DATA;
	BigQueryAuditMetadata_EXPORT_DATA BigQueryAuditMetadata_QueryStatementType = 28
	// CALL &lt;stored procedure&gt;
	BigQueryAuditMetadata_CALL BigQueryAuditMetadata_QueryStatementType = 29
)

// Enum value maps for BigQueryAuditMetadata_QueryStatementType.
var (
	BigQueryAuditMetadata_QueryStatementType_name = map[int32]string{
		0:  "QUERY_STATEMENT_TYPE_UNSPECIFIED",
		1:  "SELECT",
		23: "ASSERT",
		2:  "INSERT",
		3:  "UPDATE",
		4:  "DELETE",
		5:  "MERGE",
		6:  "CREATE_TABLE",
		7:  "CREATE_TABLE_AS_SELECT",
		8:  "CREATE_VIEW",
		9:  "CREATE_MODEL",
		13: "CREATE_MATERIALIZED_VIEW",
		14: "CREATE_FUNCTION",
		20: "CREATE_PROCEDURE",
		53: "CREATE_SCHEMA",
		10: "DROP_TABLE",
		33: "DROP_EXTERNAL_TABLE",
		11: "DROP_VIEW",
		12: "DROP_MODEL",
		15: "DROP_MATERIALIZED_VIEW",
		16: "DROP_FUNCTION",
		21: "DROP_PROCEDURE",
		54: "DROP_SCHEMA",
		17: "ALTER_TABLE",
		18: "ALTER_VIEW",
		22: "ALTER_MATERIALIZED_VIEW",
		55: "ALTER_SCHEMA",
		19: "SCRIPT",
		26: "TRUNCATE_TABLE",
		27: "CREATE_EXTERNAL_TABLE",
		28: "EXPORT_DATA",
		29: "CALL",
	}
	BigQueryAuditMetadata_QueryStatementType_value = map[string]int32{
		"QUERY_STATEMENT_TYPE_UNSPECIFIED": 0,
		"SELECT":                           1,
		"ASSERT":                           23,
		"INSERT":                           2,
		"UPDATE":                           3,
		"DELETE":                           4,
		"MERGE":                            5,
		"CREATE_TABLE":                     6,
		"CREATE_TABLE_AS_SELECT":           7,
		"CREATE_VIEW":                      8,
		"CREATE_MODEL":                     9,
		"CREATE_MATERIALIZED_VIEW":         13,
		"CREATE_FUNCTION":                  14,
		"CREATE_PROCEDURE":                 20,
		"CREATE_SCHEMA":                    53,
		"DROP_TABLE":                       10,
		"DROP_EXTERNAL_TABLE":              33,
		"DROP_VIEW":                        11,
		"DROP_MODEL":                       12,
		"DROP_MATERIALIZED_VIEW":           15,
		"DROP_FUNCTION":                    16,
		"DROP_PROCEDURE":                   21,
		"DROP_SCHEMA":                      54,
		"ALTER_TABLE":                      17,
		"ALTER_VIEW":                       18,
		"ALTER_MATERIALIZED_VIEW":          22,
		"ALTER_SCHEMA":                     55,
		"SCRIPT":                           19,
		"TRUNCATE_TABLE":                   26,
		"CREATE_EXTERNAL_TABLE":            27,
		"EXPORT_DATA":                      28,
		"CALL":                             29,
	}
)

func (x BigQueryAuditMetadata_QueryStatementType) Enum() *BigQueryAuditMetadata_QueryStatementType {
	p := new(BigQueryAuditMetadata_QueryStatementType)
	*p = x
	return p
}

func (x BigQueryAuditMetadata_QueryStatementType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryAuditMetadata_QueryStatementType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[4].Descriptor()
}

func (BigQueryAuditMetadata_QueryStatementType) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[4]
}

func (x BigQueryAuditMetadata_QueryStatementType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryAuditMetadata_QueryStatementType.Descriptor instead.
func (BigQueryAuditMetadata_QueryStatementType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 4}
}

// Describes how the job was inserted.
type BigQueryAuditMetadata_JobInsertion_Reason int32

const (
	// Unknown.
	BigQueryAuditMetadata_JobInsertion_REASON_UNSPECIFIED BigQueryAuditMetadata_JobInsertion_Reason = 0
	// Job was inserted using the jobs.insert API.
	BigQueryAuditMetadata_JobInsertion_JOB_INSERT_REQUEST BigQueryAuditMetadata_JobInsertion_Reason = 1
	// Job was inserted using the jobs.query RPC.
	BigQueryAuditMetadata_JobInsertion_QUERY_REQUEST BigQueryAuditMetadata_JobInsertion_Reason = 2
)

// Enum value maps for BigQueryAuditMetadata_JobInsertion_Reason.
var (
	BigQueryAuditMetadata_JobInsertion_Reason_name = map[int32]string{
		0: "REASON_UNSPECIFIED",
		1: "JOB_INSERT_REQUEST",
		2: "QUERY_REQUEST",
	}
	BigQueryAuditMetadata_JobInsertion_Reason_value = map[string]int32{
		"REASON_UNSPECIFIED": 0,
		"JOB_INSERT_REQUEST": 1,
		"QUERY_REQUEST":      2,
	}
)

func (x BigQueryAuditMetadata_JobInsertion_Reason) Enum() *BigQueryAuditMetadata_JobInsertion_Reason {
	p := new(BigQueryAuditMetadata_JobInsertion_Reason)
	*p = x
	return p
}

func (x BigQueryAuditMetadata_JobInsertion_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryAuditMetadata_JobInsertion_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[5].Descriptor()
}

func (BigQueryAuditMetadata_JobInsertion_Reason) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[5]
}

func (x BigQueryAuditMetadata_JobInsertion_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryAuditMetadata_JobInsertion_Reason.Descriptor instead.
func (BigQueryAuditMetadata_JobInsertion_Reason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 0, 0}
}

// Describes how the dataset was created.
type BigQueryAuditMetadata_DatasetCreation_Reason int32

const (
	// Unknown.
	BigQueryAuditMetadata_DatasetCreation_REASON_UNSPECIFIED BigQueryAuditMetadata_DatasetCreation_Reason = 0
	// Dataset was created using the datasets.create API.
	BigQueryAuditMetadata_DatasetCreation_CREATE BigQueryAuditMetadata_DatasetCreation_Reason = 1
	// Dataset was created using a query job, e.g., CREATE SCHEMA statement.
	BigQueryAuditMetadata_DatasetCreation_QUERY BigQueryAuditMetadata_DatasetCreation_Reason = 2
)

// Enum value maps for BigQueryAuditMetadata_DatasetCreation_Reason.
var (
	BigQueryAuditMetadata_DatasetCreation_Reason_name = map[int32]string{
		0: "REASON_UNSPECIFIED",
		1: "CREATE",
		2: "QUERY",
	}
	BigQueryAuditMetadata_DatasetCreation_Reason_value = map[string]int32{
		"REASON_UNSPECIFIED": 0,
		"CREATE":             1,
		"QUERY":              2,
	}
)

func (x BigQueryAuditMetadata_DatasetCreation_Reason) Enum() *BigQueryAuditMetadata_DatasetCreation_Reason {
	p := new(BigQueryAuditMetadata_DatasetCreation_Reason)
	*p = x
	return p
}

func (x BigQueryAuditMetadata_DatasetCreation_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryAuditMetadata_DatasetCreation_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[6].Descriptor()
}

func (BigQueryAuditMetadata_DatasetCreation_Reason) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[6]
}

func (x BigQueryAuditMetadata_DatasetCreation_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryAuditMetadata_DatasetCreation_Reason.Descriptor instead.
func (BigQueryAuditMetadata_DatasetCreation_Reason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 2, 0}
}

// Describes how the dataset was changed.
type BigQueryAuditMetadata_DatasetChange_Reason int32

const (
	// Unknown.
	BigQueryAuditMetadata_DatasetChange_REASON_UNSPECIFIED BigQueryAuditMetadata_DatasetChange_Reason = 0
	// Dataset was changed using the datasets.update or datasets.patch API.
	BigQueryAuditMetadata_DatasetChange_UPDATE BigQueryAuditMetadata_DatasetChange_Reason = 1
	// Dataset was changed using the SetIamPolicy API.
	BigQueryAuditMetadata_DatasetChange_SET_IAM_POLICY BigQueryAuditMetadata_DatasetChange_Reason = 2
	// Dataset was changed using a query job, e.g., ALTER SCHEMA statement.
	BigQueryAuditMetadata_DatasetChange_QUERY BigQueryAuditMetadata_DatasetChange_Reason = 3
)

// Enum value maps for BigQueryAuditMetadata_DatasetChange_Reason.
var (
	BigQueryAuditMetadata_DatasetChange_Reason_name = map[int32]string{
		0: "REASON_UNSPECIFIED",
		1: "UPDATE",
		2: "SET_IAM_POLICY",
		3: "QUERY",
	}
	BigQueryAuditMetadata_DatasetChange_Reason_value = map[string]int32{
		"REASON_UNSPECIFIED": 0,
		"UPDATE":             1,
		"SET_IAM_POLICY":     2,
		"QUERY":              3,
	}
)

func (x BigQueryAuditMetadata_DatasetChange_Reason) Enum() *BigQueryAuditMetadata_DatasetChange_Reason {
	p := new(BigQueryAuditMetadata_DatasetChange_Reason)
	*p = x
	return p
}

func (x BigQueryAuditMetadata_DatasetChange_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryAuditMetadata_DatasetChange_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[7].Descriptor()
}

func (BigQueryAuditMetadata_DatasetChange_Reason) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[7]
}

func (x BigQueryAuditMetadata_DatasetChange_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryAuditMetadata_DatasetChange_Reason.Descriptor instead.
func (BigQueryAuditMetadata_DatasetChange_Reason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 3, 0}
}

// Describes how the dataset was deleted.
type BigQueryAuditMetadata_DatasetDeletion_Reason int32

const (
	// Unknown.
	BigQueryAuditMetadata_DatasetDeletion_REASON_UNSPECIFIED BigQueryAuditMetadata_DatasetDeletion_Reason = 0
	// Dataset was deleted using the datasets.delete API.
	BigQueryAuditMetadata_DatasetDeletion_DELETE BigQueryAuditMetadata_DatasetDeletion_Reason = 1
	// Dataset was deleted using a query job, e.g., DROP SCHEMA statement.
	BigQueryAuditMetadata_DatasetDeletion_QUERY BigQueryAuditMetadata_DatasetDeletion_Reason = 2
)

// Enum value maps for BigQueryAuditMetadata_DatasetDeletion_Reason.
var (
	BigQueryAuditMetadata_DatasetDeletion_Reason_name = map[int32]string{
		0: "REASON_UNSPECIFIED",
		1: "DELETE",
		2: "QUERY",
	}
	BigQueryAuditMetadata_DatasetDeletion_Reason_value = map[string]int32{
		"REASON_UNSPECIFIED": 0,
		"DELETE":             1,
		"QUERY":              2,
	}
)

func (x BigQueryAuditMetadata_DatasetDeletion_Reason) Enum() *BigQueryAuditMetadata_DatasetDeletion_Reason {
	p := new(BigQueryAuditMetadata_DatasetDeletion_Reason)
	*p = x
	return p
}

func (x BigQueryAuditMetadata_DatasetDeletion_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryAuditMetadata_DatasetDeletion_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[8].Descriptor()
}

func (BigQueryAuditMetadata_DatasetDeletion_Reason) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[8]
}

func (x BigQueryAuditMetadata_DatasetDeletion_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryAuditMetadata_DatasetDeletion_Reason.Descriptor instead.
func (BigQueryAuditMetadata_DatasetDeletion_Reason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 4, 0}
}

// Describes how the table was created.
type BigQueryAuditMetadata_TableCreation_Reason int32

const (
	// Unknown.
	BigQueryAuditMetadata_TableCreation_REASON_UNSPECIFIED BigQueryAuditMetadata_TableCreation_Reason = 0
	// Table was created as a destination table during a query, load or copy
	// job.
	BigQueryAuditMetadata_TableCreation_JOB BigQueryAuditMetadata_TableCreation_Reason = 1
	// Table was created using a DDL query.
	BigQueryAuditMetadata_TableCreation_QUERY BigQueryAuditMetadata_TableCreation_Reason = 2
	// Table was created using the tables.create API.
	BigQueryAuditMetadata_TableCreation_TABLE_INSERT_REQUEST BigQueryAuditMetadata_TableCreation_Reason = 3
)

// Enum value maps for BigQueryAuditMetadata_TableCreation_Reason.
var (
	BigQueryAuditMetadata_TableCreation_Reason_name = map[int32]string{
		0: "REASON_UNSPECIFIED",
		1: "JOB",
		2: "QUERY",
		3: "TABLE_INSERT_REQUEST",
	}
	BigQueryAuditMetadata_TableCreation_Reason_value = map[string]int32{
		"REASON_UNSPECIFIED":   0,
		"JOB":                  1,
		"QUERY":                2,
		"TABLE_INSERT_REQUEST": 3,
	}
)

func (x BigQueryAuditMetadata_TableCreation_Reason) Enum() *BigQueryAuditMetadata_TableCreation_Reason {
	p := new(BigQueryAuditMetadata_TableCreation_Reason)
	*p = x
	return p
}

func (x BigQueryAuditMetadata_TableCreation_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryAuditMetadata_TableCreation_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[9].Descriptor()
}

func (BigQueryAuditMetadata_TableCreation_Reason) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[9]
}

func (x BigQueryAuditMetadata_TableCreation_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryAuditMetadata_TableCreation_Reason.Descriptor instead.
func (BigQueryAuditMetadata_TableCreation_Reason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 5, 0}
}

// Describes how the model was created.
type BigQueryAuditMetadata_ModelCreation_Reason int32

const (
	// Unknown.
	BigQueryAuditMetadata_ModelCreation_REASON_UNSPECIFIED BigQueryAuditMetadata_ModelCreation_Reason = 0
	// Model was created using a DDL query.
	BigQueryAuditMetadata_ModelCreation_QUERY BigQueryAuditMetadata_ModelCreation_Reason = 2
)

// Enum value maps for BigQueryAuditMetadata_ModelCreation_Reason.
var (
	BigQueryAuditMetadata_ModelCreation_Reason_name = map[int32]string{
		0: "REASON_UNSPECIFIED",
		2: "QUERY",
	}
	BigQueryAuditMetadata_ModelCreation_Reason_value = map[string]int32{
		"REASON_UNSPECIFIED": 0,
		"QUERY":              2,
	}
)

func (x BigQueryAuditMetadata_ModelCreation_Reason) Enum() *BigQueryAuditMetadata_ModelCreation_Reason {
	p := new(BigQueryAuditMetadata_ModelCreation_Reason)
	*p = x
	return p
}

func (x BigQueryAuditMetadata_ModelCreation_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryAuditMetadata_ModelCreation_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[10].Descriptor()
}

func (BigQueryAuditMetadata_ModelCreation_Reason) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[10]
}

func (x BigQueryAuditMetadata_ModelCreation_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryAuditMetadata_ModelCreation_Reason.Descriptor instead.
func (BigQueryAuditMetadata_ModelCreation_Reason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 6, 0}
}

// Describes how the routine was created.
type BigQueryAuditMetadata_RoutineCreation_Reason int32

const (
	// Unknown.
	BigQueryAuditMetadata_RoutineCreation_REASON_UNSPECIFIED BigQueryAuditMetadata_RoutineCreation_Reason = 0
	// Routine was created using a DDL query.
	BigQueryAuditMetadata_RoutineCreation_QUERY BigQueryAuditMetadata_RoutineCreation_Reason = 1
	// Routine was created using the routines.create API.
	BigQueryAuditMetadata_RoutineCreation_ROUTINE_INSERT_REQUEST BigQueryAuditMetadata_RoutineCreation_Reason = 2
)

// Enum value maps for BigQueryAuditMetadata_RoutineCreation_Reason.
var (
	BigQueryAuditMetadata_RoutineCreation_Reason_name = map[int32]string{
		0: "REASON_UNSPECIFIED",
		1: "QUERY",
		2: "ROUTINE_INSERT_REQUEST",
	}
	BigQueryAuditMetadata_RoutineCreation_Reason_value = map[string]int32{
		"REASON_UNSPECIFIED":     0,
		"QUERY":                  1,
		"ROUTINE_INSERT_REQUEST": 2,
	}
)

func (x BigQueryAuditMetadata_RoutineCreation_Reason) Enum() *BigQueryAuditMetadata_RoutineCreation_Reason {
	p := new(BigQueryAuditMetadata_RoutineCreation_Reason)
	*p = x
	return p
}

func (x BigQueryAuditMetadata_RoutineCreation_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryAuditMetadata_RoutineCreation_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[11].Descriptor()
}

func (BigQueryAuditMetadata_RoutineCreation_Reason) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[11]
}

func (x BigQueryAuditMetadata_RoutineCreation_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryAuditMetadata_RoutineCreation_Reason.Descriptor instead.
func (BigQueryAuditMetadata_RoutineCreation_Reason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 7, 0}
}

// Describes how the table data was read.
type BigQueryAuditMetadata_TableDataRead_Reason int32

const (
	// Unknown.
	BigQueryAuditMetadata_TableDataRead_REASON_UNSPECIFIED BigQueryAuditMetadata_TableDataRead_Reason = 0
	// Table was used as a source table during a BigQuery job.
	BigQueryAuditMetadata_TableDataRead_JOB BigQueryAuditMetadata_TableDataRead_Reason = 1
	// Table data was accessed using the tabledata.list API.
	BigQueryAuditMetadata_TableDataRead_TABLEDATA_LIST_REQUEST BigQueryAuditMetadata_TableDataRead_Reason = 2
	// Table data was accessed using the jobs.getQueryResults API.
	BigQueryAuditMetadata_TableDataRead_GET_QUERY_RESULTS_REQUEST BigQueryAuditMetadata_TableDataRead_Reason = 3
	// Table data was accessed using the jobs.query RPC.
	BigQueryAuditMetadata_TableDataRead_QUERY_REQUEST BigQueryAuditMetadata_TableDataRead_Reason = 4
	// Table data was accessed using storage.CreateReadSession API.
	BigQueryAuditMetadata_TableDataRead_CREATE_READ_SESSION BigQueryAuditMetadata_TableDataRead_Reason = 5
	// Table data was accessed during a materialized view refresh.
	BigQueryAuditMetadata_TableDataRead_MATERIALIZED_VIEW_REFRESH BigQueryAuditMetadata_TableDataRead_Reason = 6
)

// Enum value maps for BigQueryAuditMetadata_TableDataRead_Reason.
var (
	BigQueryAuditMetadata_TableDataRead_Reason_name = map[int32]string{
		0: "REASON_UNSPECIFIED",
		1: "JOB",
		2: "TABLEDATA_LIST_REQUEST",
		3: "GET_QUERY_RESULTS_REQUEST",
		4: "QUERY_REQUEST",
		5: "CREATE_READ_SESSION",
		6: "MATERIALIZED_VIEW_REFRESH",
	}
	BigQueryAuditMetadata_TableDataRead_Reason_value = map[string]int32{
		"REASON_UNSPECIFIED":        0,
		"JOB":                       1,
		"TABLEDATA_LIST_REQUEST":    2,
		"GET_QUERY_RESULTS_REQUEST": 3,
		"QUERY_REQUEST":             4,
		"CREATE_READ_SESSION":       5,
		"MATERIALIZED_VIEW_REFRESH": 6,
	}
)

func (x BigQueryAuditMetadata_TableDataRead_Reason) Enum() *BigQueryAuditMetadata_TableDataRead_Reason {
	p := new(BigQueryAuditMetadata_TableDataRead_Reason)
	*p = x
	return p
}

func (x BigQueryAuditMetadata_TableDataRead_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryAuditMetadata_TableDataRead_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[12].Descriptor()
}

func (BigQueryAuditMetadata_TableDataRead_Reason) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[12]
}

func (x BigQueryAuditMetadata_TableDataRead_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryAuditMetadata_TableDataRead_Reason.Descriptor instead.
func (BigQueryAuditMetadata_TableDataRead_Reason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 8, 0}
}

// Describes how the table metadata was changed.
type BigQueryAuditMetadata_TableChange_Reason int32

const (
	// Unknown.
	BigQueryAuditMetadata_TableChange_REASON_UNSPECIFIED BigQueryAuditMetadata_TableChange_Reason = 0
	// Table metadata was updated using the tables.update or tables.patch API.
	BigQueryAuditMetadata_TableChange_TABLE_UPDATE_REQUEST BigQueryAuditMetadata_TableChange_Reason = 1
	// Table was used as a job destination table.
	BigQueryAuditMetadata_TableChange_JOB BigQueryAuditMetadata_TableChange_Reason = 2
	// Table metadata was updated using a DML or DDL query.
	BigQueryAuditMetadata_TableChange_QUERY BigQueryAuditMetadata_TableChange_Reason = 3
)

// Enum value maps for BigQueryAuditMetadata_TableChange_Reason.
var (
	BigQueryAuditMetadata_TableChange_Reason_name = map[int32]string{
		0: "REASON_UNSPECIFIED",
		1: "TABLE_UPDATE_REQUEST",
		2: "JOB",
		3: "QUERY",
	}
	BigQueryAuditMetadata_TableChange_Reason_value = map[string]int32{
		"REASON_UNSPECIFIED":   0,
		"TABLE_UPDATE_REQUEST": 1,
		"JOB":                  2,
		"QUERY":                3,
	}
)

func (x BigQueryAuditMetadata_TableChange_Reason) Enum() *BigQueryAuditMetadata_TableChange_Reason {
	p := new(BigQueryAuditMetadata_TableChange_Reason)
	*p = x
	return p
}

func (x BigQueryAuditMetadata_TableChange_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryAuditMetadata_TableChange_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[13].Descriptor()
}

func (BigQueryAuditMetadata_TableChange_Reason) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[13]
}

func (x BigQueryAuditMetadata_TableChange_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryAuditMetadata_TableChange_Reason.Descriptor instead.
func (BigQueryAuditMetadata_TableChange_Reason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 9, 0}
}

// Describes how the model metadata was changed.
type BigQueryAuditMetadata_ModelMetadataChange_Reason int32

const (
	// Unknown.
	BigQueryAuditMetadata_ModelMetadataChange_REASON_UNSPECIFIED BigQueryAuditMetadata_ModelMetadataChange_Reason = 0
	// Model metadata was updated using the models.patch API.
	BigQueryAuditMetadata_ModelMetadataChange_MODEL_PATCH_REQUEST BigQueryAuditMetadata_ModelMetadataChange_Reason = 1
	// Model metadata was updated using a DDL query.
	BigQueryAuditMetadata_ModelMetadataChange_QUERY BigQueryAuditMetadata_ModelMetadataChange_Reason = 2
)

// Enum value maps for BigQueryAuditMetadata_ModelMetadataChange_Reason.
var (
	BigQueryAuditMetadata_ModelMetadataChange_Reason_name = map[int32]string{
		0: "REASON_UNSPECIFIED",
		1: "MODEL_PATCH_REQUEST",
		2: "QUERY",
	}
	BigQueryAuditMetadata_ModelMetadataChange_Reason_value = map[string]int32{
		"REASON_UNSPECIFIED":  0,
		"MODEL_PATCH_REQUEST": 1,
		"QUERY":               2,
	}
)

func (x BigQueryAuditMetadata_ModelMetadataChange_Reason) Enum() *BigQueryAuditMetadata_ModelMetadataChange_Reason {
	p := new(BigQueryAuditMetadata_ModelMetadataChange_Reason)
	*p = x
	return p
}

func (x BigQueryAuditMetadata_ModelMetadataChange_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryAuditMetadata_ModelMetadataChange_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[14].Descriptor()
}

func (BigQueryAuditMetadata_ModelMetadataChange_Reason) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[14]
}

func (x BigQueryAuditMetadata_ModelMetadataChange_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryAuditMetadata_ModelMetadataChange_Reason.Descriptor instead.
func (BigQueryAuditMetadata_ModelMetadataChange_Reason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 10, 0}
}

// Describes how the routine was updated.
type BigQueryAuditMetadata_RoutineChange_Reason int32

const (
	// Unknown.
	BigQueryAuditMetadata_RoutineChange_REASON_UNSPECIFIED BigQueryAuditMetadata_RoutineChange_Reason = 0
	// Routine was updated using a DDL query.
	BigQueryAuditMetadata_RoutineChange_QUERY BigQueryAuditMetadata_RoutineChange_Reason = 1
	// Routine was updated using the routines.update or routines.patch API.
	BigQueryAuditMetadata_RoutineChange_ROUTINE_UPDATE_REQUEST BigQueryAuditMetadata_RoutineChange_Reason = 2
)

// Enum value maps for BigQueryAuditMetadata_RoutineChange_Reason.
var (
	BigQueryAuditMetadata_RoutineChange_Reason_name = map[int32]string{
		0: "REASON_UNSPECIFIED",
		1: "QUERY",
		2: "ROUTINE_UPDATE_REQUEST",
	}
	BigQueryAuditMetadata_RoutineChange_Reason_value = map[string]int32{
		"REASON_UNSPECIFIED":     0,
		"QUERY":                  1,
		"ROUTINE_UPDATE_REQUEST": 2,
	}
)

func (x BigQueryAuditMetadata_RoutineChange_Reason) Enum() *BigQueryAuditMetadata_RoutineChange_Reason {
	p := new(BigQueryAuditMetadata_RoutineChange_Reason)
	*p = x
	return p
}

func (x BigQueryAuditMetadata_RoutineChange_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryAuditMetadata_RoutineChange_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[15].Descriptor()
}

func (BigQueryAuditMetadata_RoutineChange_Reason) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[15]
}

func (x BigQueryAuditMetadata_RoutineChange_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryAuditMetadata_RoutineChange_Reason.Descriptor instead.
func (BigQueryAuditMetadata_RoutineChange_Reason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 11, 0}
}

// Describes how the table data was changed.
type BigQueryAuditMetadata_TableDataChange_Reason int32

const (
	// Unknown.
	BigQueryAuditMetadata_TableDataChange_REASON_UNSPECIFIED BigQueryAuditMetadata_TableDataChange_Reason = 0
	// Table was used as a job destination table.
	BigQueryAuditMetadata_TableDataChange_JOB BigQueryAuditMetadata_TableDataChange_Reason = 1
	// Table data was updated using a DML or DDL query.
	BigQueryAuditMetadata_TableDataChange_QUERY BigQueryAuditMetadata_TableDataChange_Reason = 2
	// Table data was updated during a materialized view refresh.
	BigQueryAuditMetadata_TableDataChange_MATERIALIZED_VIEW_REFRESH BigQueryAuditMetadata_TableDataChange_Reason = 3
	// Table data was added using the Write API.
	BigQueryAuditMetadata_TableDataChange_WRITE_API BigQueryAuditMetadata_TableDataChange_Reason = 4
)

// Enum value maps for BigQueryAuditMetadata_TableDataChange_Reason.
var (
	BigQueryAuditMetadata_TableDataChange_Reason_name = map[int32]string{
		0: "REASON_UNSPECIFIED",
		1: "JOB",
		2: "QUERY",
		3: "MATERIALIZED_VIEW_REFRESH",
		4: "WRITE_API",
	}
	BigQueryAuditMetadata_TableDataChange_Reason_value = map[string]int32{
		"REASON_UNSPECIFIED":        0,
		"JOB":                       1,
		"QUERY":                     2,
		"MATERIALIZED_VIEW_REFRESH": 3,
		"WRITE_API":                 4,
	}
)

func (x BigQueryAuditMetadata_TableDataChange_Reason) Enum() *BigQueryAuditMetadata_TableDataChange_Reason {
	p := new(BigQueryAuditMetadata_TableDataChange_Reason)
	*p = x
	return p
}

func (x BigQueryAuditMetadata_TableDataChange_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryAuditMetadata_TableDataChange_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[16].Descriptor()
}

func (BigQueryAuditMetadata_TableDataChange_Reason) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[16]
}

func (x BigQueryAuditMetadata_TableDataChange_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryAuditMetadata_TableDataChange_Reason.Descriptor instead.
func (BigQueryAuditMetadata_TableDataChange_Reason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 12, 0}
}

// Describes how the model data was changed.
type BigQueryAuditMetadata_ModelDataChange_Reason int32

const (
	// Unknown.
	BigQueryAuditMetadata_ModelDataChange_REASON_UNSPECIFIED BigQueryAuditMetadata_ModelDataChange_Reason = 0
	// Model data was changed using a DDL query.
	BigQueryAuditMetadata_ModelDataChange_QUERY BigQueryAuditMetadata_ModelDataChange_Reason = 1
)

// Enum value maps for BigQueryAuditMetadata_ModelDataChange_Reason.
var (
	BigQueryAuditMetadata_ModelDataChange_Reason_name = map[int32]string{
		0: "REASON_UNSPECIFIED",
		1: "QUERY",
	}
	BigQueryAuditMetadata_ModelDataChange_Reason_value = map[string]int32{
		"REASON_UNSPECIFIED": 0,
		"QUERY":              1,
	}
)

func (x BigQueryAuditMetadata_ModelDataChange_Reason) Enum() *BigQueryAuditMetadata_ModelDataChange_Reason {
	p := new(BigQueryAuditMetadata_ModelDataChange_Reason)
	*p = x
	return p
}

func (x BigQueryAuditMetadata_ModelDataChange_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryAuditMetadata_ModelDataChange_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[17].Descriptor()
}

func (BigQueryAuditMetadata_ModelDataChange_Reason) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[17]
}

func (x BigQueryAuditMetadata_ModelDataChange_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryAuditMetadata_ModelDataChange_Reason.Descriptor instead.
func (BigQueryAuditMetadata_ModelDataChange_Reason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 13, 0}
}

// Describes how the model data was read.
type BigQueryAuditMetadata_ModelDataRead_Reason int32

const (
	// Unknown.
	BigQueryAuditMetadata_ModelDataRead_REASON_UNSPECIFIED BigQueryAuditMetadata_ModelDataRead_Reason = 0
	// Model was used as a source model during a BigQuery job.
	BigQueryAuditMetadata_ModelDataRead_JOB BigQueryAuditMetadata_ModelDataRead_Reason = 1
)

// Enum value maps for BigQueryAuditMetadata_ModelDataRead_Reason.
var (
	BigQueryAuditMetadata_ModelDataRead_Reason_name = map[int32]string{
		0: "REASON_UNSPECIFIED",
		1: "JOB",
	}
	BigQueryAuditMetadata_ModelDataRead_Reason_value = map[string]int32{
		"REASON_UNSPECIFIED": 0,
		"JOB":                1,
	}
)

func (x BigQueryAuditMetadata_ModelDataRead_Reason) Enum() *BigQueryAuditMetadata_ModelDataRead_Reason {
	p := new(BigQueryAuditMetadata_ModelDataRead_Reason)
	*p = x
	return p
}

func (x BigQueryAuditMetadata_ModelDataRead_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryAuditMetadata_ModelDataRead_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[18].Descriptor()
}

func (BigQueryAuditMetadata_ModelDataRead_Reason) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[18]
}

func (x BigQueryAuditMetadata_ModelDataRead_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryAuditMetadata_ModelDataRead_Reason.Descriptor instead.
func (BigQueryAuditMetadata_ModelDataRead_Reason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 14, 0}
}

// Describes how the table was deleted.
type BigQueryAuditMetadata_TableDeletion_Reason int32

const (
	// Unknown.
	BigQueryAuditMetadata_TableDeletion_REASON_UNSPECIFIED BigQueryAuditMetadata_TableDeletion_Reason = 0
	// Table was deleted using the tables.delete API.
	BigQueryAuditMetadata_TableDeletion_TABLE_DELETE_REQUEST BigQueryAuditMetadata_TableDeletion_Reason = 2
	// Table expired.
	BigQueryAuditMetadata_TableDeletion_EXPIRED BigQueryAuditMetadata_TableDeletion_Reason = 3
	// Table deleted using a DDL query.
	BigQueryAuditMetadata_TableDeletion_QUERY BigQueryAuditMetadata_TableDeletion_Reason = 4
)

// Enum value maps for BigQueryAuditMetadata_TableDeletion_Reason.
var (
	BigQueryAuditMetadata_TableDeletion_Reason_name = map[int32]string{
		0: "REASON_UNSPECIFIED",
		2: "TABLE_DELETE_REQUEST",
		3: "EXPIRED",
		4: "QUERY",
	}
	BigQueryAuditMetadata_TableDeletion_Reason_value = map[string]int32{
		"REASON_UNSPECIFIED":   0,
		"TABLE_DELETE_REQUEST": 2,
		"EXPIRED":              3,
		"QUERY":                4,
	}
)

func (x BigQueryAuditMetadata_TableDeletion_Reason) Enum() *BigQueryAuditMetadata_TableDeletion_Reason {
	p := new(BigQueryAuditMetadata_TableDeletion_Reason)
	*p = x
	return p
}

func (x BigQueryAuditMetadata_TableDeletion_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryAuditMetadata_TableDeletion_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[19].Descriptor()
}

func (BigQueryAuditMetadata_TableDeletion_Reason) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[19]
}

func (x BigQueryAuditMetadata_TableDeletion_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryAuditMetadata_TableDeletion_Reason.Descriptor instead.
func (BigQueryAuditMetadata_TableDeletion_Reason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 16, 0}
}

// Describes how the model was deleted.
type BigQueryAuditMetadata_ModelDeletion_Reason int32

const (
	// Unknown.
	BigQueryAuditMetadata_ModelDeletion_REASON_UNSPECIFIED BigQueryAuditMetadata_ModelDeletion_Reason = 0
	// Model was deleted using the models.delete API.
	BigQueryAuditMetadata_ModelDeletion_MODEL_DELETE_REQUEST BigQueryAuditMetadata_ModelDeletion_Reason = 1
	// Model expired.
	BigQueryAuditMetadata_ModelDeletion_EXPIRED BigQueryAuditMetadata_ModelDeletion_Reason = 2
	// Model was deleted using DDL query.
	BigQueryAuditMetadata_ModelDeletion_QUERY BigQueryAuditMetadata_ModelDeletion_Reason = 3
)

// Enum value maps for BigQueryAuditMetadata_ModelDeletion_Reason.
var (
	BigQueryAuditMetadata_ModelDeletion_Reason_name = map[int32]string{
		0: "REASON_UNSPECIFIED",
		1: "MODEL_DELETE_REQUEST",
		2: "EXPIRED",
		3: "QUERY",
	}
	BigQueryAuditMetadata_ModelDeletion_Reason_value = map[string]int32{
		"REASON_UNSPECIFIED":   0,
		"MODEL_DELETE_REQUEST": 1,
		"EXPIRED":              2,
		"QUERY":                3,
	}
)

func (x BigQueryAuditMetadata_ModelDeletion_Reason) Enum() *BigQueryAuditMetadata_ModelDeletion_Reason {
	p := new(BigQueryAuditMetadata_ModelDeletion_Reason)
	*p = x
	return p
}

func (x BigQueryAuditMetadata_ModelDeletion_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryAuditMetadata_ModelDeletion_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[20].Descriptor()
}

func (BigQueryAuditMetadata_ModelDeletion_Reason) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[20]
}

func (x BigQueryAuditMetadata_ModelDeletion_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryAuditMetadata_ModelDeletion_Reason.Descriptor instead.
func (BigQueryAuditMetadata_ModelDeletion_Reason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 17, 0}
}

// Describes how the routine was deleted.
type BigQueryAuditMetadata_RoutineDeletion_Reason int32

const (
	// Unknown.
	BigQueryAuditMetadata_RoutineDeletion_REASON_UNSPECIFIED BigQueryAuditMetadata_RoutineDeletion_Reason = 0
	// Routine was deleted using DDL query.
	BigQueryAuditMetadata_RoutineDeletion_QUERY BigQueryAuditMetadata_RoutineDeletion_Reason = 1
	// Routine was deleted using the API.
	BigQueryAuditMetadata_RoutineDeletion_ROUTINE_DELETE_REQUEST BigQueryAuditMetadata_RoutineDeletion_Reason = 2
)

// Enum value maps for BigQueryAuditMetadata_RoutineDeletion_Reason.
var (
	BigQueryAuditMetadata_RoutineDeletion_Reason_name = map[int32]string{
		0: "REASON_UNSPECIFIED",
		1: "QUERY",
		2: "ROUTINE_DELETE_REQUEST",
	}
	BigQueryAuditMetadata_RoutineDeletion_Reason_value = map[string]int32{
		"REASON_UNSPECIFIED":     0,
		"QUERY":                  1,
		"ROUTINE_DELETE_REQUEST": 2,
	}
)

func (x BigQueryAuditMetadata_RoutineDeletion_Reason) Enum() *BigQueryAuditMetadata_RoutineDeletion_Reason {
	p := new(BigQueryAuditMetadata_RoutineDeletion_Reason)
	*p = x
	return p
}

func (x BigQueryAuditMetadata_RoutineDeletion_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryAuditMetadata_RoutineDeletion_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[21].Descriptor()
}

func (BigQueryAuditMetadata_RoutineDeletion_Reason) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[21]
}

func (x BigQueryAuditMetadata_RoutineDeletion_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryAuditMetadata_RoutineDeletion_Reason.Descriptor instead.
func (BigQueryAuditMetadata_RoutineDeletion_Reason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 19, 0}
}

// Job type.
type BigQueryAuditMetadata_JobConfig_Type int32

const (
	// Unknown.
	BigQueryAuditMetadata_JobConfig_TYPE_UNSPECIFIED BigQueryAuditMetadata_JobConfig_Type = 0
	// Query job.
	BigQueryAuditMetadata_JobConfig_QUERY BigQueryAuditMetadata_JobConfig_Type = 1
	// Table copy job.
	BigQueryAuditMetadata_JobConfig_COPY BigQueryAuditMetadata_JobConfig_Type = 2
	// Export (extract) job.
	BigQueryAuditMetadata_JobConfig_EXPORT BigQueryAuditMetadata_JobConfig_Type = 3
	// Import (load) job.
	BigQueryAuditMetadata_JobConfig_IMPORT BigQueryAuditMetadata_JobConfig_Type = 4
)

// Enum value maps for BigQueryAuditMetadata_JobConfig_Type.
var (
	BigQueryAuditMetadata_JobConfig_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "QUERY",
		2: "COPY",
		3: "EXPORT",
		4: "IMPORT",
	}
	BigQueryAuditMetadata_JobConfig_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"QUERY":            1,
		"COPY":             2,
		"EXPORT":           3,
		"IMPORT":           4,
	}
)

func (x BigQueryAuditMetadata_JobConfig_Type) Enum() *BigQueryAuditMetadata_JobConfig_Type {
	p := new(BigQueryAuditMetadata_JobConfig_Type)
	*p = x
	return p
}

func (x BigQueryAuditMetadata_JobConfig_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryAuditMetadata_JobConfig_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[22].Descriptor()
}

func (BigQueryAuditMetadata_JobConfig_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[22]
}

func (x BigQueryAuditMetadata_JobConfig_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryAuditMetadata_JobConfig_Type.Descriptor instead.
func (BigQueryAuditMetadata_JobConfig_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 21, 0}
}

// Priority given to the query.
type BigQueryAuditMetadata_JobConfig_Query_Priority int32

const (
	// Unknown.
	BigQueryAuditMetadata_JobConfig_Query_PRIORITY_UNSPECIFIED BigQueryAuditMetadata_JobConfig_Query_Priority = 0
	// Interactive query.
	BigQueryAuditMetadata_JobConfig_Query_QUERY_INTERACTIVE BigQueryAuditMetadata_JobConfig_Query_Priority = 1
	// Batch query.
	BigQueryAuditMetadata_JobConfig_Query_QUERY_BATCH BigQueryAuditMetadata_JobConfig_Query_Priority = 2
)

// Enum value maps for BigQueryAuditMetadata_JobConfig_Query_Priority.
var (
	BigQueryAuditMetadata_JobConfig_Query_Priority_name = map[int32]string{
		0: "PRIORITY_UNSPECIFIED",
		1: "QUERY_INTERACTIVE",
		2: "QUERY_BATCH",
	}
	BigQueryAuditMetadata_JobConfig_Query_Priority_value = map[string]int32{
		"PRIORITY_UNSPECIFIED": 0,
		"QUERY_INTERACTIVE":    1,
		"QUERY_BATCH":          2,
	}
)

func (x BigQueryAuditMetadata_JobConfig_Query_Priority) Enum() *BigQueryAuditMetadata_JobConfig_Query_Priority {
	p := new(BigQueryAuditMetadata_JobConfig_Query_Priority)
	*p = x
	return p
}

func (x BigQueryAuditMetadata_JobConfig_Query_Priority) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryAuditMetadata_JobConfig_Query_Priority) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[23].Descriptor()
}

func (BigQueryAuditMetadata_JobConfig_Query_Priority) Type() protoreflect.EnumType {
	return &file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes[23]
}

func (x BigQueryAuditMetadata_JobConfig_Query_Priority) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryAuditMetadata_JobConfig_Query_Priority.Descriptor instead.
func (BigQueryAuditMetadata_JobConfig_Query_Priority) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 21, 0, 0}
}

// Audit log format for BigQuery cloud audit logs metadata.
type BigQueryAuditMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// BigQuery event information.
	//
	// Types that are assignable to Event:
	//	*BigQueryAuditMetadata_JobInsertion_
	//	*BigQueryAuditMetadata_JobChange_
	//	*BigQueryAuditMetadata_DatasetCreation_
	//	*BigQueryAuditMetadata_DatasetChange_
	//	*BigQueryAuditMetadata_DatasetDeletion_
	//	*BigQueryAuditMetadata_TableCreation_
	//	*BigQueryAuditMetadata_TableChange_
	//	*BigQueryAuditMetadata_TableDeletion_
	//	*BigQueryAuditMetadata_TableDataRead_
	//	*BigQueryAuditMetadata_TableDataChange_
	//	*BigQueryAuditMetadata_ModelDeletion_
	//	*BigQueryAuditMetadata_ModelCreation_
	//	*BigQueryAuditMetadata_ModelMetadataChange_
	//	*BigQueryAuditMetadata_ModelDataChange_
	//	*BigQueryAuditMetadata_ModelDataRead_
	//	*BigQueryAuditMetadata_RoutineCreation_
	//	*BigQueryAuditMetadata_RoutineChange_
	//	*BigQueryAuditMetadata_RoutineDeletion_
	Event isBigQueryAuditMetadata_Event `protobuf_oneof:"event"`
}

func (x *BigQueryAuditMetadata) Reset() {
	*x = BigQueryAuditMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata) ProtoMessage() {}

func (x *BigQueryAuditMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0}
}

func (m *BigQueryAuditMetadata) GetEvent() isBigQueryAuditMetadata_Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (x *BigQueryAuditMetadata) GetJobInsertion() *BigQueryAuditMetadata_JobInsertion {
	if x, ok := x.GetEvent().(*BigQueryAuditMetadata_JobInsertion_); ok {
		return x.JobInsertion
	}
	return nil
}

func (x *BigQueryAuditMetadata) GetJobChange() *BigQueryAuditMetadata_JobChange {
	if x, ok := x.GetEvent().(*BigQueryAuditMetadata_JobChange_); ok {
		return x.JobChange
	}
	return nil
}

func (x *BigQueryAuditMetadata) GetDatasetCreation() *BigQueryAuditMetadata_DatasetCreation {
	if x, ok := x.GetEvent().(*BigQueryAuditMetadata_DatasetCreation_); ok {
		return x.DatasetCreation
	}
	return nil
}

func (x *BigQueryAuditMetadata) GetDatasetChange() *BigQueryAuditMetadata_DatasetChange {
	if x, ok := x.GetEvent().(*BigQueryAuditMetadata_DatasetChange_); ok {
		return x.DatasetChange
	}
	return nil
}

func (x *BigQueryAuditMetadata) GetDatasetDeletion() *BigQueryAuditMetadata_DatasetDeletion {
	if x, ok := x.GetEvent().(*BigQueryAuditMetadata_DatasetDeletion_); ok {
		return x.DatasetDeletion
	}
	return nil
}

func (x *BigQueryAuditMetadata) GetTableCreation() *BigQueryAuditMetadata_TableCreation {
	if x, ok := x.GetEvent().(*BigQueryAuditMetadata_TableCreation_); ok {
		return x.TableCreation
	}
	return nil
}

func (x *BigQueryAuditMetadata) GetTableChange() *BigQueryAuditMetadata_TableChange {
	if x, ok := x.GetEvent().(*BigQueryAuditMetadata_TableChange_); ok {
		return x.TableChange
	}
	return nil
}

func (x *BigQueryAuditMetadata) GetTableDeletion() *BigQueryAuditMetadata_TableDeletion {
	if x, ok := x.GetEvent().(*BigQueryAuditMetadata_TableDeletion_); ok {
		return x.TableDeletion
	}
	return nil
}

func (x *BigQueryAuditMetadata) GetTableDataRead() *BigQueryAuditMetadata_TableDataRead {
	if x, ok := x.GetEvent().(*BigQueryAuditMetadata_TableDataRead_); ok {
		return x.TableDataRead
	}
	return nil
}

func (x *BigQueryAuditMetadata) GetTableDataChange() *BigQueryAuditMetadata_TableDataChange {
	if x, ok := x.GetEvent().(*BigQueryAuditMetadata_TableDataChange_); ok {
		return x.TableDataChange
	}
	return nil
}

func (x *BigQueryAuditMetadata) GetModelDeletion() *BigQueryAuditMetadata_ModelDeletion {
	if x, ok := x.GetEvent().(*BigQueryAuditMetadata_ModelDeletion_); ok {
		return x.ModelDeletion
	}
	return nil
}

func (x *BigQueryAuditMetadata) GetModelCreation() *BigQueryAuditMetadata_ModelCreation {
	if x, ok := x.GetEvent().(*BigQueryAuditMetadata_ModelCreation_); ok {
		return x.ModelCreation
	}
	return nil
}

func (x *BigQueryAuditMetadata) GetModelMetadataChange() *BigQueryAuditMetadata_ModelMetadataChange {
	if x, ok := x.GetEvent().(*BigQueryAuditMetadata_ModelMetadataChange_); ok {
		return x.ModelMetadataChange
	}
	return nil
}

func (x *BigQueryAuditMetadata) GetModelDataChange() *BigQueryAuditMetadata_ModelDataChange {
	if x, ok := x.GetEvent().(*BigQueryAuditMetadata_ModelDataChange_); ok {
		return x.ModelDataChange
	}
	return nil
}

func (x *BigQueryAuditMetadata) GetModelDataRead() *BigQueryAuditMetadata_ModelDataRead {
	if x, ok := x.GetEvent().(*BigQueryAuditMetadata_ModelDataRead_); ok {
		return x.ModelDataRead
	}
	return nil
}

func (x *BigQueryAuditMetadata) GetRoutineCreation() *BigQueryAuditMetadata_RoutineCreation {
	if x, ok := x.GetEvent().(*BigQueryAuditMetadata_RoutineCreation_); ok {
		return x.RoutineCreation
	}
	return nil
}

func (x *BigQueryAuditMetadata) GetRoutineChange() *BigQueryAuditMetadata_RoutineChange {
	if x, ok := x.GetEvent().(*BigQueryAuditMetadata_RoutineChange_); ok {
		return x.RoutineChange
	}
	return nil
}

func (x *BigQueryAuditMetadata) GetRoutineDeletion() *BigQueryAuditMetadata_RoutineDeletion {
	if x, ok := x.GetEvent().(*BigQueryAuditMetadata_RoutineDeletion_); ok {
		return x.RoutineDeletion
	}
	return nil
}

type isBigQueryAuditMetadata_Event interface {
	isBigQueryAuditMetadata_Event()
}

type BigQueryAuditMetadata_JobInsertion_ struct {
	// Job insertion event.
	JobInsertion *BigQueryAuditMetadata_JobInsertion `protobuf:"bytes,1,opt,name=job_insertion,json=jobInsertion,proto3,oneof"`
}

type BigQueryAuditMetadata_JobChange_ struct {
	// Job state change event.
	JobChange *BigQueryAuditMetadata_JobChange `protobuf:"bytes,2,opt,name=job_change,json=jobChange,proto3,oneof"`
}

type BigQueryAuditMetadata_DatasetCreation_ struct {
	// Dataset creation event.
	DatasetCreation *BigQueryAuditMetadata_DatasetCreation `protobuf:"bytes,3,opt,name=dataset_creation,json=datasetCreation,proto3,oneof"`
}

type BigQueryAuditMetadata_DatasetChange_ struct {
	// Dataset change event.
	DatasetChange *BigQueryAuditMetadata_DatasetChange `protobuf:"bytes,4,opt,name=dataset_change,json=datasetChange,proto3,oneof"`
}

type BigQueryAuditMetadata_DatasetDeletion_ struct {
	// Dataset deletion event.
	DatasetDeletion *BigQueryAuditMetadata_DatasetDeletion `protobuf:"bytes,5,opt,name=dataset_deletion,json=datasetDeletion,proto3,oneof"`
}

type BigQueryAuditMetadata_TableCreation_ struct {
	// Table creation event.
	TableCreation *BigQueryAuditMetadata_TableCreation `protobuf:"bytes,6,opt,name=table_creation,json=tableCreation,proto3,oneof"`
}

type BigQueryAuditMetadata_TableChange_ struct {
	// Table metadata change event.
	TableChange *BigQueryAuditMetadata_TableChange `protobuf:"bytes,8,opt,name=table_change,json=tableChange,proto3,oneof"`
}

type BigQueryAuditMetadata_TableDeletion_ struct {
	// Table deletion event.
	TableDeletion *BigQueryAuditMetadata_TableDeletion `protobuf:"bytes,9,opt,name=table_deletion,json=tableDeletion,proto3,oneof"`
}

type BigQueryAuditMetadata_TableDataRead_ struct {
	// Table data read event.
	TableDataRead *BigQueryAuditMetadata_TableDataRead `protobuf:"bytes,10,opt,name=table_data_read,json=tableDataRead,proto3,oneof"`
}

type BigQueryAuditMetadata_TableDataChange_ struct {
	// Table data change event.
	TableDataChange *BigQueryAuditMetadata_TableDataChange `protobuf:"bytes,11,opt,name=table_data_change,json=tableDataChange,proto3,oneof"`
}

type BigQueryAuditMetadata_ModelDeletion_ struct {
	// Model deletion event.
	ModelDeletion *BigQueryAuditMetadata_ModelDeletion `protobuf:"bytes,12,opt,name=model_deletion,json=modelDeletion,proto3,oneof"`
}

type BigQueryAuditMetadata_ModelCreation_ struct {
	// Model creation event.
	ModelCreation *BigQueryAuditMetadata_ModelCreation `protobuf:"bytes,13,opt,name=model_creation,json=modelCreation,proto3,oneof"`
}

type BigQueryAuditMetadata_ModelMetadataChange_ struct {
	// Model metadata change event.
	ModelMetadataChange *BigQueryAuditMetadata_ModelMetadataChange `protobuf:"bytes,14,opt,name=model_metadata_change,json=modelMetadataChange,proto3,oneof"`
}

type BigQueryAuditMetadata_ModelDataChange_ struct {
	// Model data change event.
	ModelDataChange *BigQueryAuditMetadata_ModelDataChange `protobuf:"bytes,15,opt,name=model_data_change,json=modelDataChange,proto3,oneof"`
}

type BigQueryAuditMetadata_ModelDataRead_ struct {
	// Model data read event.
	ModelDataRead *BigQueryAuditMetadata_ModelDataRead `protobuf:"bytes,19,opt,name=model_data_read,json=modelDataRead,proto3,oneof"`
}

type BigQueryAuditMetadata_RoutineCreation_ struct {
	// Routine creation event.
	RoutineCreation *BigQueryAuditMetadata_RoutineCreation `protobuf:"bytes,16,opt,name=routine_creation,json=routineCreation,proto3,oneof"`
}

type BigQueryAuditMetadata_RoutineChange_ struct {
	// Routine change event.
	RoutineChange *BigQueryAuditMetadata_RoutineChange `protobuf:"bytes,17,opt,name=routine_change,json=routineChange,proto3,oneof"`
}

type BigQueryAuditMetadata_RoutineDeletion_ struct {
	// Routine deletion event.
	RoutineDeletion *BigQueryAuditMetadata_RoutineDeletion `protobuf:"bytes,18,opt,name=routine_deletion,json=routineDeletion,proto3,oneof"`
}

func (*BigQueryAuditMetadata_JobInsertion_) isBigQueryAuditMetadata_Event() {}

func (*BigQueryAuditMetadata_JobChange_) isBigQueryAuditMetadata_Event() {}

func (*BigQueryAuditMetadata_DatasetCreation_) isBigQueryAuditMetadata_Event() {}

func (*BigQueryAuditMetadata_DatasetChange_) isBigQueryAuditMetadata_Event() {}

func (*BigQueryAuditMetadata_DatasetDeletion_) isBigQueryAuditMetadata_Event() {}

func (*BigQueryAuditMetadata_TableCreation_) isBigQueryAuditMetadata_Event() {}

func (*BigQueryAuditMetadata_TableChange_) isBigQueryAuditMetadata_Event() {}

func (*BigQueryAuditMetadata_TableDeletion_) isBigQueryAuditMetadata_Event() {}

func (*BigQueryAuditMetadata_TableDataRead_) isBigQueryAuditMetadata_Event() {}

func (*BigQueryAuditMetadata_TableDataChange_) isBigQueryAuditMetadata_Event() {}

func (*BigQueryAuditMetadata_ModelDeletion_) isBigQueryAuditMetadata_Event() {}

func (*BigQueryAuditMetadata_ModelCreation_) isBigQueryAuditMetadata_Event() {}

func (*BigQueryAuditMetadata_ModelMetadataChange_) isBigQueryAuditMetadata_Event() {}

func (*BigQueryAuditMetadata_ModelDataChange_) isBigQueryAuditMetadata_Event() {}

func (*BigQueryAuditMetadata_ModelDataRead_) isBigQueryAuditMetadata_Event() {}

func (*BigQueryAuditMetadata_RoutineCreation_) isBigQueryAuditMetadata_Event() {}

func (*BigQueryAuditMetadata_RoutineChange_) isBigQueryAuditMetadata_Event() {}

func (*BigQueryAuditMetadata_RoutineDeletion_) isBigQueryAuditMetadata_Event() {}

// Job insertion event.
type BigQueryAuditMetadata_JobInsertion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Job metadata.
	Job *BigQueryAuditMetadata_Job `protobuf:"bytes,1,opt,name=job,proto3" json:"job,omitempty"`
	// Describes how the job was inserted.
	Reason BigQueryAuditMetadata_JobInsertion_Reason `protobuf:"varint,2,opt,name=reason,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_JobInsertion_Reason" json:"reason,omitempty"`
}

func (x *BigQueryAuditMetadata_JobInsertion) Reset() {
	*x = BigQueryAuditMetadata_JobInsertion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_JobInsertion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_JobInsertion) ProtoMessage() {}

func (x *BigQueryAuditMetadata_JobInsertion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_JobInsertion.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_JobInsertion) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 0}
}

func (x *BigQueryAuditMetadata_JobInsertion) GetJob() *BigQueryAuditMetadata_Job {
	if x != nil {
		return x.Job
	}
	return nil
}

func (x *BigQueryAuditMetadata_JobInsertion) GetReason() BigQueryAuditMetadata_JobInsertion_Reason {
	if x != nil {
		return x.Reason
	}
	return BigQueryAuditMetadata_JobInsertion_REASON_UNSPECIFIED
}

// Job state change event.
type BigQueryAuditMetadata_JobChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Job state before the job state change.
	Before BigQueryAuditMetadata_JobState `protobuf:"varint,1,opt,name=before,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_JobState" json:"before,omitempty"`
	// Job state after the job state change.
	After BigQueryAuditMetadata_JobState `protobuf:"varint,2,opt,name=after,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_JobState" json:"after,omitempty"`
	// Job metadata.
	Job *BigQueryAuditMetadata_Job `protobuf:"bytes,3,opt,name=job,proto3" json:"job,omitempty"`
}

func (x *BigQueryAuditMetadata_JobChange) Reset() {
	*x = BigQueryAuditMetadata_JobChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_JobChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_JobChange) ProtoMessage() {}

func (x *BigQueryAuditMetadata_JobChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_JobChange.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_JobChange) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 1}
}

func (x *BigQueryAuditMetadata_JobChange) GetBefore() BigQueryAuditMetadata_JobState {
	if x != nil {
		return x.Before
	}
	return BigQueryAuditMetadata_JOB_STATE_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_JobChange) GetAfter() BigQueryAuditMetadata_JobState {
	if x != nil {
		return x.After
	}
	return BigQueryAuditMetadata_JOB_STATE_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_JobChange) GetJob() *BigQueryAuditMetadata_Job {
	if x != nil {
		return x.Job
	}
	return nil
}

// Dataset creation event.
type BigQueryAuditMetadata_DatasetCreation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Dataset metadata.
	Dataset *BigQueryAuditMetadata_Dataset `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Describes how the dataset was created.
	Reason BigQueryAuditMetadata_DatasetCreation_Reason `protobuf:"varint,2,opt,name=reason,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_DatasetCreation_Reason" json:"reason,omitempty"`
	// The URI of the job that created the dataset.
	// Present if the reason is QUERY.
	//
	// Format: `projects/<project_id>/jobs/<job_id>`.
	JobName string `protobuf:"bytes,3,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
}

func (x *BigQueryAuditMetadata_DatasetCreation) Reset() {
	*x = BigQueryAuditMetadata_DatasetCreation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_DatasetCreation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_DatasetCreation) ProtoMessage() {}

func (x *BigQueryAuditMetadata_DatasetCreation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_DatasetCreation.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_DatasetCreation) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 2}
}

func (x *BigQueryAuditMetadata_DatasetCreation) GetDataset() *BigQueryAuditMetadata_Dataset {
	if x != nil {
		return x.Dataset
	}
	return nil
}

func (x *BigQueryAuditMetadata_DatasetCreation) GetReason() BigQueryAuditMetadata_DatasetCreation_Reason {
	if x != nil {
		return x.Reason
	}
	return BigQueryAuditMetadata_DatasetCreation_REASON_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_DatasetCreation) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

// Dataset change event.
type BigQueryAuditMetadata_DatasetChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Dataset metadata after the change.
	Dataset *BigQueryAuditMetadata_Dataset `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Describes how the dataset was changed.
	Reason BigQueryAuditMetadata_DatasetChange_Reason `protobuf:"varint,2,opt,name=reason,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_DatasetChange_Reason" json:"reason,omitempty"`
	// The URI of the job that updated the dataset.
	// Present if the reason is QUERY.
	//
	// Format: `projects/<project_id>/jobs/<job_id>`.
	JobName string `protobuf:"bytes,3,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
}

func (x *BigQueryAuditMetadata_DatasetChange) Reset() {
	*x = BigQueryAuditMetadata_DatasetChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_DatasetChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_DatasetChange) ProtoMessage() {}

func (x *BigQueryAuditMetadata_DatasetChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_DatasetChange.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_DatasetChange) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 3}
}

func (x *BigQueryAuditMetadata_DatasetChange) GetDataset() *BigQueryAuditMetadata_Dataset {
	if x != nil {
		return x.Dataset
	}
	return nil
}

func (x *BigQueryAuditMetadata_DatasetChange) GetReason() BigQueryAuditMetadata_DatasetChange_Reason {
	if x != nil {
		return x.Reason
	}
	return BigQueryAuditMetadata_DatasetChange_REASON_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_DatasetChange) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

// Dataset deletion event.
type BigQueryAuditMetadata_DatasetDeletion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Describes how the dataset was deleted.
	Reason BigQueryAuditMetadata_DatasetDeletion_Reason `protobuf:"varint,1,opt,name=reason,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_DatasetDeletion_Reason" json:"reason,omitempty"`
	// The URI of the job that deleted the dataset.
	// Present if the reason is QUERY.
	//
	// Format: `projects/<project_id>/jobs/<job_id>`.
	JobName string `protobuf:"bytes,2,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
}

func (x *BigQueryAuditMetadata_DatasetDeletion) Reset() {
	*x = BigQueryAuditMetadata_DatasetDeletion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_DatasetDeletion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_DatasetDeletion) ProtoMessage() {}

func (x *BigQueryAuditMetadata_DatasetDeletion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_DatasetDeletion.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_DatasetDeletion) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 4}
}

func (x *BigQueryAuditMetadata_DatasetDeletion) GetReason() BigQueryAuditMetadata_DatasetDeletion_Reason {
	if x != nil {
		return x.Reason
	}
	return BigQueryAuditMetadata_DatasetDeletion_REASON_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_DatasetDeletion) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

// Table creation event.
type BigQueryAuditMetadata_TableCreation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Table metadata.
	Table *BigQueryAuditMetadata_Table `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	// Describes how the table was created.
	Reason BigQueryAuditMetadata_TableCreation_Reason `protobuf:"varint,3,opt,name=reason,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_TableCreation_Reason" json:"reason,omitempty"`
	// The URI of the job that created a table.
	// Present if the reason is JOB or QUERY.
	//
	// Format: `projects/<project_id>/jobs/<job_id>`.
	JobName string `protobuf:"bytes,4,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
}

func (x *BigQueryAuditMetadata_TableCreation) Reset() {
	*x = BigQueryAuditMetadata_TableCreation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_TableCreation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_TableCreation) ProtoMessage() {}

func (x *BigQueryAuditMetadata_TableCreation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_TableCreation.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_TableCreation) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 5}
}

func (x *BigQueryAuditMetadata_TableCreation) GetTable() *BigQueryAuditMetadata_Table {
	if x != nil {
		return x.Table
	}
	return nil
}

func (x *BigQueryAuditMetadata_TableCreation) GetReason() BigQueryAuditMetadata_TableCreation_Reason {
	if x != nil {
		return x.Reason
	}
	return BigQueryAuditMetadata_TableCreation_REASON_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_TableCreation) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

// Model creation event.
type BigQueryAuditMetadata_ModelCreation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Model metadata.
	Model *BigQueryAuditMetadata_Model `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Describes how the model was created.
	Reason BigQueryAuditMetadata_ModelCreation_Reason `protobuf:"varint,3,opt,name=reason,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_ModelCreation_Reason" json:"reason,omitempty"`
	// The URI of the job that created the model.
	//
	// Format: `projects/<project_id>/jobs/<job_id>`.
	JobName string `protobuf:"bytes,4,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
}

func (x *BigQueryAuditMetadata_ModelCreation) Reset() {
	*x = BigQueryAuditMetadata_ModelCreation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_ModelCreation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_ModelCreation) ProtoMessage() {}

func (x *BigQueryAuditMetadata_ModelCreation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_ModelCreation.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_ModelCreation) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 6}
}

func (x *BigQueryAuditMetadata_ModelCreation) GetModel() *BigQueryAuditMetadata_Model {
	if x != nil {
		return x.Model
	}
	return nil
}

func (x *BigQueryAuditMetadata_ModelCreation) GetReason() BigQueryAuditMetadata_ModelCreation_Reason {
	if x != nil {
		return x.Reason
	}
	return BigQueryAuditMetadata_ModelCreation_REASON_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_ModelCreation) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

// Routine creation event.
type BigQueryAuditMetadata_RoutineCreation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Created routine.
	Routine *BigQueryAuditMetadata_Routine `protobuf:"bytes,1,opt,name=routine,proto3" json:"routine,omitempty"`
	// Describes how the routine was created.
	Reason BigQueryAuditMetadata_RoutineCreation_Reason `protobuf:"varint,3,opt,name=reason,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_RoutineCreation_Reason" json:"reason,omitempty"`
	// The URI of the job that created the routine.
	//
	// Format: `projects/<project_id>/jobs/<job_id>`.
	JobName string `protobuf:"bytes,4,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
}

func (x *BigQueryAuditMetadata_RoutineCreation) Reset() {
	*x = BigQueryAuditMetadata_RoutineCreation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_RoutineCreation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_RoutineCreation) ProtoMessage() {}

func (x *BigQueryAuditMetadata_RoutineCreation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_RoutineCreation.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_RoutineCreation) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 7}
}

func (x *BigQueryAuditMetadata_RoutineCreation) GetRoutine() *BigQueryAuditMetadata_Routine {
	if x != nil {
		return x.Routine
	}
	return nil
}

func (x *BigQueryAuditMetadata_RoutineCreation) GetReason() BigQueryAuditMetadata_RoutineCreation_Reason {
	if x != nil {
		return x.Reason
	}
	return BigQueryAuditMetadata_RoutineCreation_REASON_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_RoutineCreation) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

// Table data read event.
type BigQueryAuditMetadata_TableDataRead struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of the accessed fields. Entire list is truncated if the record size
	// exceeds 100K.
	Fields []string `protobuf:"bytes,2,rep,name=fields,proto3" json:"fields,omitempty"`
	// True if the fields list was truncated.
	FieldsTruncated bool `protobuf:"varint,8,opt,name=fields_truncated,json=fieldsTruncated,proto3" json:"fields_truncated,omitempty"`
	// List of the referenced policy tags. That is, policy tags attached to the
	// accessed fields or their ancestors.
	// Policy tag resource name is a string of the format:
	// `projects/<project_id>/locations/<location_id>/taxonomies/<taxonomy_id>/policyTags/<policy_tag_id>`
	PolicyTags []string `protobuf:"bytes,9,rep,name=policy_tags,json=policyTags,proto3" json:"policy_tags,omitempty"`
	// True if the policy tag list was truncated. At most 100 policy tags can be
	// saved.
	PolicyTagsTruncated bool `protobuf:"varint,10,opt,name=policy_tags_truncated,json=policyTagsTruncated,proto3" json:"policy_tags_truncated,omitempty"`
	// Describes how the table data was read.
	Reason BigQueryAuditMetadata_TableDataRead_Reason `protobuf:"varint,3,opt,name=reason,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_TableDataRead_Reason" json:"reason,omitempty"`
	// The URI of the job that read a table.
	// Present if the reason is JOB but can be redacted for privacy reasons.
	//
	// Format: `projects/<project_id>/jobs/<job_id>`.
	JobName string `protobuf:"bytes,4,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
	// The URI of the read session that read a table.
	// Present if the reason is CREATE_READ_SESSION.
	//
	// Format:
	// `projects/<project_id>/locations/<location>/sessions/<session_id>`.
	SessionName string `protobuf:"bytes,5,opt,name=session_name,json=sessionName,proto3" json:"session_name,omitempty"`
}

func (x *BigQueryAuditMetadata_TableDataRead) Reset() {
	*x = BigQueryAuditMetadata_TableDataRead{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_TableDataRead) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_TableDataRead) ProtoMessage() {}

func (x *BigQueryAuditMetadata_TableDataRead) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_TableDataRead.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_TableDataRead) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 8}
}

func (x *BigQueryAuditMetadata_TableDataRead) GetFields() []string {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *BigQueryAuditMetadata_TableDataRead) GetFieldsTruncated() bool {
	if x != nil {
		return x.FieldsTruncated
	}
	return false
}

func (x *BigQueryAuditMetadata_TableDataRead) GetPolicyTags() []string {
	if x != nil {
		return x.PolicyTags
	}
	return nil
}

func (x *BigQueryAuditMetadata_TableDataRead) GetPolicyTagsTruncated() bool {
	if x != nil {
		return x.PolicyTagsTruncated
	}
	return false
}

func (x *BigQueryAuditMetadata_TableDataRead) GetReason() BigQueryAuditMetadata_TableDataRead_Reason {
	if x != nil {
		return x.Reason
	}
	return BigQueryAuditMetadata_TableDataRead_REASON_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_TableDataRead) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

func (x *BigQueryAuditMetadata_TableDataRead) GetSessionName() string {
	if x != nil {
		return x.SessionName
	}
	return ""
}

// Table metadata change event.
type BigQueryAuditMetadata_TableChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Updated table metadata.
	Table *BigQueryAuditMetadata_Table `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	// True if the table was truncated.
	Truncated bool `protobuf:"varint,4,opt,name=truncated,proto3" json:"truncated,omitempty"`
	// Describes how the table metadata was changed.
	Reason BigQueryAuditMetadata_TableChange_Reason `protobuf:"varint,5,opt,name=reason,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_TableChange_Reason" json:"reason,omitempty"`
	// The URI of the job that changed a table.
	// Present if the reason is JOB or QUERY.
	//
	// Format: `projects/<project_id>/jobs/<job_id>`.
	JobName string `protobuf:"bytes,6,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
}

func (x *BigQueryAuditMetadata_TableChange) Reset() {
	*x = BigQueryAuditMetadata_TableChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_TableChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_TableChange) ProtoMessage() {}

func (x *BigQueryAuditMetadata_TableChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_TableChange.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_TableChange) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 9}
}

func (x *BigQueryAuditMetadata_TableChange) GetTable() *BigQueryAuditMetadata_Table {
	if x != nil {
		return x.Table
	}
	return nil
}

func (x *BigQueryAuditMetadata_TableChange) GetTruncated() bool {
	if x != nil {
		return x.Truncated
	}
	return false
}

func (x *BigQueryAuditMetadata_TableChange) GetReason() BigQueryAuditMetadata_TableChange_Reason {
	if x != nil {
		return x.Reason
	}
	return BigQueryAuditMetadata_TableChange_REASON_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_TableChange) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

// Model metadata change event.
type BigQueryAuditMetadata_ModelMetadataChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Updated model.
	Model *BigQueryAuditMetadata_Model `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Describes how the model metadata was changed.
	Reason BigQueryAuditMetadata_ModelMetadataChange_Reason `protobuf:"varint,2,opt,name=reason,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_ModelMetadataChange_Reason" json:"reason,omitempty"`
	// The URI of the job that changed the model metadata.
	// Present if and only if the reason is QUERY.
	//
	// Format: `projects/<project_id>/jobs/<job_id>`.
	JobName string `protobuf:"bytes,3,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
}

func (x *BigQueryAuditMetadata_ModelMetadataChange) Reset() {
	*x = BigQueryAuditMetadata_ModelMetadataChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_ModelMetadataChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_ModelMetadataChange) ProtoMessage() {}

func (x *BigQueryAuditMetadata_ModelMetadataChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_ModelMetadataChange.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_ModelMetadataChange) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 10}
}

func (x *BigQueryAuditMetadata_ModelMetadataChange) GetModel() *BigQueryAuditMetadata_Model {
	if x != nil {
		return x.Model
	}
	return nil
}

func (x *BigQueryAuditMetadata_ModelMetadataChange) GetReason() BigQueryAuditMetadata_ModelMetadataChange_Reason {
	if x != nil {
		return x.Reason
	}
	return BigQueryAuditMetadata_ModelMetadataChange_REASON_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_ModelMetadataChange) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

// Routine change event.
type BigQueryAuditMetadata_RoutineChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Updated routine.
	Routine *BigQueryAuditMetadata_Routine `protobuf:"bytes,1,opt,name=routine,proto3" json:"routine,omitempty"`
	// Describes how the routine was updated.
	Reason BigQueryAuditMetadata_RoutineChange_Reason `protobuf:"varint,3,opt,name=reason,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_RoutineChange_Reason" json:"reason,omitempty"`
	// The URI of the job that updated the routine.
	//
	// Format: `projects/<project_id>/jobs/<job_id>`.
	JobName string `protobuf:"bytes,4,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
}

func (x *BigQueryAuditMetadata_RoutineChange) Reset() {
	*x = BigQueryAuditMetadata_RoutineChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_RoutineChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_RoutineChange) ProtoMessage() {}

func (x *BigQueryAuditMetadata_RoutineChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_RoutineChange.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_RoutineChange) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 11}
}

func (x *BigQueryAuditMetadata_RoutineChange) GetRoutine() *BigQueryAuditMetadata_Routine {
	if x != nil {
		return x.Routine
	}
	return nil
}

func (x *BigQueryAuditMetadata_RoutineChange) GetReason() BigQueryAuditMetadata_RoutineChange_Reason {
	if x != nil {
		return x.Reason
	}
	return BigQueryAuditMetadata_RoutineChange_REASON_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_RoutineChange) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

// Table data change event.
type BigQueryAuditMetadata_TableDataChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of deleted rows.
	DeletedRowsCount int64 `protobuf:"varint,1,opt,name=deleted_rows_count,json=deletedRowsCount,proto3" json:"deleted_rows_count,omitempty"`
	// Number of inserted rows.
	InsertedRowsCount int64 `protobuf:"varint,2,opt,name=inserted_rows_count,json=insertedRowsCount,proto3" json:"inserted_rows_count,omitempty"`
	// True if the table was truncated.
	Truncated bool `protobuf:"varint,3,opt,name=truncated,proto3" json:"truncated,omitempty"`
	// Describes how the table data was changed.
	Reason BigQueryAuditMetadata_TableDataChange_Reason `protobuf:"varint,4,opt,name=reason,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_TableDataChange_Reason" json:"reason,omitempty"`
	// The URI of the job that changed a table.
	//
	// Format: `projects/<project_id>/jobs/<job_id>`.
	JobName string `protobuf:"bytes,5,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
	// If written from WRITE_API, the name of the stream.
	//
	// Format:
	// `projects/<project_id>/datasets/<dataset_id>/tables/<table_id>/streams/<stream_id>`
	StreamName string `protobuf:"bytes,6,opt,name=stream_name,json=streamName,proto3" json:"stream_name,omitempty"`
}

func (x *BigQueryAuditMetadata_TableDataChange) Reset() {
	*x = BigQueryAuditMetadata_TableDataChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_TableDataChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_TableDataChange) ProtoMessage() {}

func (x *BigQueryAuditMetadata_TableDataChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_TableDataChange.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_TableDataChange) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 12}
}

func (x *BigQueryAuditMetadata_TableDataChange) GetDeletedRowsCount() int64 {
	if x != nil {
		return x.DeletedRowsCount
	}
	return 0
}

func (x *BigQueryAuditMetadata_TableDataChange) GetInsertedRowsCount() int64 {
	if x != nil {
		return x.InsertedRowsCount
	}
	return 0
}

func (x *BigQueryAuditMetadata_TableDataChange) GetTruncated() bool {
	if x != nil {
		return x.Truncated
	}
	return false
}

func (x *BigQueryAuditMetadata_TableDataChange) GetReason() BigQueryAuditMetadata_TableDataChange_Reason {
	if x != nil {
		return x.Reason
	}
	return BigQueryAuditMetadata_TableDataChange_REASON_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_TableDataChange) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

func (x *BigQueryAuditMetadata_TableDataChange) GetStreamName() string {
	if x != nil {
		return x.StreamName
	}
	return ""
}

// Model data change event.
type BigQueryAuditMetadata_ModelDataChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Describes how the model data was changed.
	Reason BigQueryAuditMetadata_ModelDataChange_Reason `protobuf:"varint,1,opt,name=reason,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_ModelDataChange_Reason" json:"reason,omitempty"`
	// The URI of the job that changed the model data.
	//
	// Format: `projects/<project_id>/jobs/<job_id>`.
	JobName string `protobuf:"bytes,2,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
}

func (x *BigQueryAuditMetadata_ModelDataChange) Reset() {
	*x = BigQueryAuditMetadata_ModelDataChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_ModelDataChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_ModelDataChange) ProtoMessage() {}

func (x *BigQueryAuditMetadata_ModelDataChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_ModelDataChange.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_ModelDataChange) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 13}
}

func (x *BigQueryAuditMetadata_ModelDataChange) GetReason() BigQueryAuditMetadata_ModelDataChange_Reason {
	if x != nil {
		return x.Reason
	}
	return BigQueryAuditMetadata_ModelDataChange_REASON_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_ModelDataChange) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

// Model data read event.
type BigQueryAuditMetadata_ModelDataRead struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Describes how the model data was read.
	Reason BigQueryAuditMetadata_ModelDataRead_Reason `protobuf:"varint,1,opt,name=reason,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_ModelDataRead_Reason" json:"reason,omitempty"`
	// The URI of the job that read the model data.
	//
	// Format: `projects/<project_id>/jobs/<job_id>`.
	JobName string `protobuf:"bytes,2,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
}

func (x *BigQueryAuditMetadata_ModelDataRead) Reset() {
	*x = BigQueryAuditMetadata_ModelDataRead{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_ModelDataRead) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_ModelDataRead) ProtoMessage() {}

func (x *BigQueryAuditMetadata_ModelDataRead) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_ModelDataRead.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_ModelDataRead) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 14}
}

func (x *BigQueryAuditMetadata_ModelDataRead) GetReason() BigQueryAuditMetadata_ModelDataRead_Reason {
	if x != nil {
		return x.Reason
	}
	return BigQueryAuditMetadata_ModelDataRead_REASON_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_ModelDataRead) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

// BigQuery dataset.
type BigQueryAuditMetadata_Dataset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Dataset URI.
	//
	// Format: `projects/<project_id>/datasets/<dataset_id>`.
	DatasetName string `protobuf:"bytes,1,opt,name=dataset_name,json=datasetName,proto3" json:"dataset_name,omitempty"`
	// Dataset creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Dataset metadata last update time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The access control list for the dataset.
	Acl *BigQueryAuditMetadata_BigQueryAcl `protobuf:"bytes,5,opt,name=acl,proto3" json:"acl,omitempty"`
	// Default expiration time for tables in the dataset.
	DefaultTableExpireDuration *durationpb.Duration `protobuf:"bytes,6,opt,name=default_table_expire_duration,json=defaultTableExpireDuration,proto3" json:"default_table_expire_duration,omitempty"`
	// User-provided metadata for the dataset.
	DatasetInfo *BigQueryAuditMetadata_EntityInfo `protobuf:"bytes,7,opt,name=dataset_info,json=datasetInfo,proto3" json:"dataset_info,omitempty"`
	// Default encryption for tables in the dataset.
	DefaultEncryption *BigQueryAuditMetadata_EncryptionInfo `protobuf:"bytes,8,opt,name=default_encryption,json=defaultEncryption,proto3" json:"default_encryption,omitempty"`
}

func (x *BigQueryAuditMetadata_Dataset) Reset() {
	*x = BigQueryAuditMetadata_Dataset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_Dataset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_Dataset) ProtoMessage() {}

func (x *BigQueryAuditMetadata_Dataset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_Dataset.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_Dataset) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 15}
}

func (x *BigQueryAuditMetadata_Dataset) GetDatasetName() string {
	if x != nil {
		return x.DatasetName
	}
	return ""
}

func (x *BigQueryAuditMetadata_Dataset) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BigQueryAuditMetadata_Dataset) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *BigQueryAuditMetadata_Dataset) GetAcl() *BigQueryAuditMetadata_BigQueryAcl {
	if x != nil {
		return x.Acl
	}
	return nil
}

func (x *BigQueryAuditMetadata_Dataset) GetDefaultTableExpireDuration() *durationpb.Duration {
	if x != nil {
		return x.DefaultTableExpireDuration
	}
	return nil
}

func (x *BigQueryAuditMetadata_Dataset) GetDatasetInfo() *BigQueryAuditMetadata_EntityInfo {
	if x != nil {
		return x.DatasetInfo
	}
	return nil
}

func (x *BigQueryAuditMetadata_Dataset) GetDefaultEncryption() *BigQueryAuditMetadata_EncryptionInfo {
	if x != nil {
		return x.DefaultEncryption
	}
	return nil
}

// Table deletion event.
type BigQueryAuditMetadata_TableDeletion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Describes how the table was deleted.
	Reason BigQueryAuditMetadata_TableDeletion_Reason `protobuf:"varint,1,opt,name=reason,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_TableDeletion_Reason" json:"reason,omitempty"`
	// The URI of the job that deleted a table.
	// Present if the reason is QUERY.
	//
	// Format: `projects/<project_id>/jobs/<job_id>`.
	JobName string `protobuf:"bytes,2,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
}

func (x *BigQueryAuditMetadata_TableDeletion) Reset() {
	*x = BigQueryAuditMetadata_TableDeletion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_TableDeletion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_TableDeletion) ProtoMessage() {}

func (x *BigQueryAuditMetadata_TableDeletion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_TableDeletion.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_TableDeletion) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 16}
}

func (x *BigQueryAuditMetadata_TableDeletion) GetReason() BigQueryAuditMetadata_TableDeletion_Reason {
	if x != nil {
		return x.Reason
	}
	return BigQueryAuditMetadata_TableDeletion_REASON_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_TableDeletion) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

// Model deletion event.
type BigQueryAuditMetadata_ModelDeletion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Describes how the model was deleted.
	Reason BigQueryAuditMetadata_ModelDeletion_Reason `protobuf:"varint,1,opt,name=reason,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_ModelDeletion_Reason" json:"reason,omitempty"`
	// The URI of the job that deleted a model.
	// Present if the reason is QUERY.
	//
	// Format: `projects/<project_id>/jobs/<job_id>`.
	JobName string `protobuf:"bytes,2,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
}

func (x *BigQueryAuditMetadata_ModelDeletion) Reset() {
	*x = BigQueryAuditMetadata_ModelDeletion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_ModelDeletion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_ModelDeletion) ProtoMessage() {}

func (x *BigQueryAuditMetadata_ModelDeletion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_ModelDeletion.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_ModelDeletion) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 17}
}

func (x *BigQueryAuditMetadata_ModelDeletion) GetReason() BigQueryAuditMetadata_ModelDeletion_Reason {
	if x != nil {
		return x.Reason
	}
	return BigQueryAuditMetadata_ModelDeletion_REASON_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_ModelDeletion) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

// Trained BigQuery ML model.
type BigQueryAuditMetadata_Model struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Model URI.
	//
	// Format: `projects/<project_id>/datasets/<dataset_id>/models/<model_id>`.
	ModelName string `protobuf:"bytes,1,opt,name=model_name,json=modelName,proto3" json:"model_name,omitempty"`
	// User-provided metadata for the model.
	ModelInfo *BigQueryAuditMetadata_EntityInfo `protobuf:"bytes,2,opt,name=model_info,json=modelInfo,proto3" json:"model_info,omitempty"`
	// Model expiration time.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Model creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Model last update time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Model encryption information. Set when non-default encryption is used.
	Encryption *BigQueryAuditMetadata_EncryptionInfo `protobuf:"bytes,8,opt,name=encryption,proto3" json:"encryption,omitempty"`
}

func (x *BigQueryAuditMetadata_Model) Reset() {
	*x = BigQueryAuditMetadata_Model{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_Model) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_Model) ProtoMessage() {}

func (x *BigQueryAuditMetadata_Model) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_Model.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_Model) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 18}
}

func (x *BigQueryAuditMetadata_Model) GetModelName() string {
	if x != nil {
		return x.ModelName
	}
	return ""
}

func (x *BigQueryAuditMetadata_Model) GetModelInfo() *BigQueryAuditMetadata_EntityInfo {
	if x != nil {
		return x.ModelInfo
	}
	return nil
}

func (x *BigQueryAuditMetadata_Model) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *BigQueryAuditMetadata_Model) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BigQueryAuditMetadata_Model) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *BigQueryAuditMetadata_Model) GetEncryption() *BigQueryAuditMetadata_EncryptionInfo {
	if x != nil {
		return x.Encryption
	}
	return nil
}

// Routine deletion event.
type BigQueryAuditMetadata_RoutineDeletion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deleted routine.
	Routine *BigQueryAuditMetadata_Routine `protobuf:"bytes,1,opt,name=routine,proto3" json:"routine,omitempty"`
	// Describes how the routine was deleted.
	Reason BigQueryAuditMetadata_RoutineDeletion_Reason `protobuf:"varint,3,opt,name=reason,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_RoutineDeletion_Reason" json:"reason,omitempty"`
	// The URI of the job that deleted the routine.
	// Present if the reason is QUERY.
	//
	// Format: `projects/<project_id>/jobs/<job_id>`.
	JobName string `protobuf:"bytes,4,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
}

func (x *BigQueryAuditMetadata_RoutineDeletion) Reset() {
	*x = BigQueryAuditMetadata_RoutineDeletion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_RoutineDeletion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_RoutineDeletion) ProtoMessage() {}

func (x *BigQueryAuditMetadata_RoutineDeletion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_RoutineDeletion.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_RoutineDeletion) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 19}
}

func (x *BigQueryAuditMetadata_RoutineDeletion) GetRoutine() *BigQueryAuditMetadata_Routine {
	if x != nil {
		return x.Routine
	}
	return nil
}

func (x *BigQueryAuditMetadata_RoutineDeletion) GetReason() BigQueryAuditMetadata_RoutineDeletion_Reason {
	if x != nil {
		return x.Reason
	}
	return BigQueryAuditMetadata_RoutineDeletion_REASON_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_RoutineDeletion) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

// BigQuery job.
type BigQueryAuditMetadata_Job struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Job URI.
	//
	// Format: `projects/<project_id>/jobs/<job_id>`.
	JobName string `protobuf:"bytes,1,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
	// Job configuration.
	JobConfig *BigQueryAuditMetadata_JobConfig `protobuf:"bytes,2,opt,name=job_config,json=jobConfig,proto3" json:"job_config,omitempty"`
	// Job status.
	JobStatus *BigQueryAuditMetadata_JobStatus `protobuf:"bytes,3,opt,name=job_status,json=jobStatus,proto3" json:"job_status,omitempty"`
	// Job statistics.
	JobStats *BigQueryAuditMetadata_JobStats `protobuf:"bytes,4,opt,name=job_stats,json=jobStats,proto3" json:"job_stats,omitempty"`
}

func (x *BigQueryAuditMetadata_Job) Reset() {
	*x = BigQueryAuditMetadata_Job{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_Job) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_Job) ProtoMessage() {}

func (x *BigQueryAuditMetadata_Job) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_Job.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_Job) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 20}
}

func (x *BigQueryAuditMetadata_Job) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

func (x *BigQueryAuditMetadata_Job) GetJobConfig() *BigQueryAuditMetadata_JobConfig {
	if x != nil {
		return x.JobConfig
	}
	return nil
}

func (x *BigQueryAuditMetadata_Job) GetJobStatus() *BigQueryAuditMetadata_JobStatus {
	if x != nil {
		return x.JobStatus
	}
	return nil
}

func (x *BigQueryAuditMetadata_Job) GetJobStats() *BigQueryAuditMetadata_JobStats {
	if x != nil {
		return x.JobStats
	}
	return nil
}

// Job configuration.
// See the [Jobs](https://cloud.google.com/bigquery/docs/reference/v2/jobs)
// API resource for more details on individual fields.
type BigQueryAuditMetadata_JobConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Job type.
	Type BigQueryAuditMetadata_JobConfig_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_JobConfig_Type" json:"type,omitempty"`
	// Job configuration information.
	//
	// Types that are assignable to Config:
	//	*BigQueryAuditMetadata_JobConfig_QueryConfig
	//	*BigQueryAuditMetadata_JobConfig_LoadConfig
	//	*BigQueryAuditMetadata_JobConfig_ExtractConfig
	//	*BigQueryAuditMetadata_JobConfig_TableCopyConfig
	Config isBigQueryAuditMetadata_JobConfig_Config `protobuf_oneof:"config"`
	// Labels provided for the job.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *BigQueryAuditMetadata_JobConfig) Reset() {
	*x = BigQueryAuditMetadata_JobConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_JobConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_JobConfig) ProtoMessage() {}

func (x *BigQueryAuditMetadata_JobConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_JobConfig.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_JobConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 21}
}

func (x *BigQueryAuditMetadata_JobConfig) GetType() BigQueryAuditMetadata_JobConfig_Type {
	if x != nil {
		return x.Type
	}
	return BigQueryAuditMetadata_JobConfig_TYPE_UNSPECIFIED
}

func (m *BigQueryAuditMetadata_JobConfig) GetConfig() isBigQueryAuditMetadata_JobConfig_Config {
	if m != nil {
		return m.Config
	}
	return nil
}

func (x *BigQueryAuditMetadata_JobConfig) GetQueryConfig() *BigQueryAuditMetadata_JobConfig_Query {
	if x, ok := x.GetConfig().(*BigQueryAuditMetadata_JobConfig_QueryConfig); ok {
		return x.QueryConfig
	}
	return nil
}

func (x *BigQueryAuditMetadata_JobConfig) GetLoadConfig() *BigQueryAuditMetadata_JobConfig_Load {
	if x, ok := x.GetConfig().(*BigQueryAuditMetadata_JobConfig_LoadConfig); ok {
		return x.LoadConfig
	}
	return nil
}

func (x *BigQueryAuditMetadata_JobConfig) GetExtractConfig() *BigQueryAuditMetadata_JobConfig_Extract {
	if x, ok := x.GetConfig().(*BigQueryAuditMetadata_JobConfig_ExtractConfig); ok {
		return x.ExtractConfig
	}
	return nil
}

func (x *BigQueryAuditMetadata_JobConfig) GetTableCopyConfig() *BigQueryAuditMetadata_JobConfig_TableCopy {
	if x, ok := x.GetConfig().(*BigQueryAuditMetadata_JobConfig_TableCopyConfig); ok {
		return x.TableCopyConfig
	}
	return nil
}

func (x *BigQueryAuditMetadata_JobConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type isBigQueryAuditMetadata_JobConfig_Config interface {
	isBigQueryAuditMetadata_JobConfig_Config()
}

type BigQueryAuditMetadata_JobConfig_QueryConfig struct {
	// Query job information.
	QueryConfig *BigQueryAuditMetadata_JobConfig_Query `protobuf:"bytes,2,opt,name=query_config,json=queryConfig,proto3,oneof"`
}

type BigQueryAuditMetadata_JobConfig_LoadConfig struct {
	// Load job information.
	LoadConfig *BigQueryAuditMetadata_JobConfig_Load `protobuf:"bytes,3,opt,name=load_config,json=loadConfig,proto3,oneof"`
}

type BigQueryAuditMetadata_JobConfig_ExtractConfig struct {
	// Extract job information.
	ExtractConfig *BigQueryAuditMetadata_JobConfig_Extract `protobuf:"bytes,4,opt,name=extract_config,json=extractConfig,proto3,oneof"`
}

type BigQueryAuditMetadata_JobConfig_TableCopyConfig struct {
	// TableCopy job information.
	TableCopyConfig *BigQueryAuditMetadata_JobConfig_TableCopy `protobuf:"bytes,5,opt,name=table_copy_config,json=tableCopyConfig,proto3,oneof"`
}

func (*BigQueryAuditMetadata_JobConfig_QueryConfig) isBigQueryAuditMetadata_JobConfig_Config() {}

func (*BigQueryAuditMetadata_JobConfig_LoadConfig) isBigQueryAuditMetadata_JobConfig_Config() {}

func (*BigQueryAuditMetadata_JobConfig_ExtractConfig) isBigQueryAuditMetadata_JobConfig_Config() {}

func (*BigQueryAuditMetadata_JobConfig_TableCopyConfig) isBigQueryAuditMetadata_JobConfig_Config() {}

// Definition of an external data source used in a query.
type BigQueryAuditMetadata_TableDefinition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the table, used in queries.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// URIs for the data.
	SourceUris []string `protobuf:"bytes,2,rep,name=source_uris,json=sourceUris,proto3" json:"source_uris,omitempty"`
}

func (x *BigQueryAuditMetadata_TableDefinition) Reset() {
	*x = BigQueryAuditMetadata_TableDefinition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_TableDefinition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_TableDefinition) ProtoMessage() {}

func (x *BigQueryAuditMetadata_TableDefinition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_TableDefinition.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_TableDefinition) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 22}
}

func (x *BigQueryAuditMetadata_TableDefinition) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BigQueryAuditMetadata_TableDefinition) GetSourceUris() []string {
	if x != nil {
		return x.SourceUris
	}
	return nil
}

// Status of a job.
type BigQueryAuditMetadata_JobStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// State of the job.
	JobState BigQueryAuditMetadata_JobState `protobuf:"varint,1,opt,name=job_state,json=jobState,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_JobState" json:"job_state,omitempty"`
	// Job error, if the job failed.
	ErrorResult *status.Status `protobuf:"bytes,2,opt,name=error_result,json=errorResult,proto3" json:"error_result,omitempty"`
	// Errors encountered during the running of the job. Does not necessarily
	// mean that the job has completed or was unsuccessful.
	Errors []*status.Status `protobuf:"bytes,3,rep,name=errors,proto3" json:"errors,omitempty"`
}

func (x *BigQueryAuditMetadata_JobStatus) Reset() {
	*x = BigQueryAuditMetadata_JobStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_JobStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_JobStatus) ProtoMessage() {}

func (x *BigQueryAuditMetadata_JobStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_JobStatus.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_JobStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 23}
}

func (x *BigQueryAuditMetadata_JobStatus) GetJobState() BigQueryAuditMetadata_JobState {
	if x != nil {
		return x.JobState
	}
	return BigQueryAuditMetadata_JOB_STATE_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_JobStatus) GetErrorResult() *status.Status {
	if x != nil {
		return x.ErrorResult
	}
	return nil
}

func (x *BigQueryAuditMetadata_JobStatus) GetErrors() []*status.Status {
	if x != nil {
		return x.Errors
	}
	return nil
}

// Job statistics.
type BigQueryAuditMetadata_JobStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Job creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Job execution start time.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Job completion time.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Statistics specific to the job type.
	//
	// Types that are assignable to Extended:
	//	*BigQueryAuditMetadata_JobStats_QueryStats
	//	*BigQueryAuditMetadata_JobStats_LoadStats
	//	*BigQueryAuditMetadata_JobStats_ExtractStats
	Extended isBigQueryAuditMetadata_JobStats_Extended `protobuf_oneof:"extended"`
	// The total number of slot-ms consumed by the query job.
	TotalSlotMs int64 `protobuf:"varint,10,opt,name=total_slot_ms,json=totalSlotMs,proto3" json:"total_slot_ms,omitempty"`
	// Reservation usage attributed from each tier of a reservation hierarchy.
	ReservationUsage []*BigQueryAuditMetadata_JobStats_ReservationResourceUsage `protobuf:"bytes,11,rep,name=reservation_usage,json=reservationUsage,proto3" json:"reservation_usage,omitempty"`
	// Parent job name. Only present for child jobs.
	ParentJobName string `protobuf:"bytes,12,opt,name=parent_job_name,json=parentJobName,proto3" json:"parent_job_name,omitempty"`
}

func (x *BigQueryAuditMetadata_JobStats) Reset() {
	*x = BigQueryAuditMetadata_JobStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_JobStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_JobStats) ProtoMessage() {}

func (x *BigQueryAuditMetadata_JobStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_JobStats.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_JobStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 24}
}

func (x *BigQueryAuditMetadata_JobStats) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BigQueryAuditMetadata_JobStats) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *BigQueryAuditMetadata_JobStats) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (m *BigQueryAuditMetadata_JobStats) GetExtended() isBigQueryAuditMetadata_JobStats_Extended {
	if m != nil {
		return m.Extended
	}
	return nil
}

func (x *BigQueryAuditMetadata_JobStats) GetQueryStats() *BigQueryAuditMetadata_JobStats_Query {
	if x, ok := x.GetExtended().(*BigQueryAuditMetadata_JobStats_QueryStats); ok {
		return x.QueryStats
	}
	return nil
}

func (x *BigQueryAuditMetadata_JobStats) GetLoadStats() *BigQueryAuditMetadata_JobStats_Load {
	if x, ok := x.GetExtended().(*BigQueryAuditMetadata_JobStats_LoadStats); ok {
		return x.LoadStats
	}
	return nil
}

func (x *BigQueryAuditMetadata_JobStats) GetExtractStats() *BigQueryAuditMetadata_JobStats_Extract {
	if x, ok := x.GetExtended().(*BigQueryAuditMetadata_JobStats_ExtractStats); ok {
		return x.ExtractStats
	}
	return nil
}

func (x *BigQueryAuditMetadata_JobStats) GetTotalSlotMs() int64 {
	if x != nil {
		return x.TotalSlotMs
	}
	return 0
}

func (x *BigQueryAuditMetadata_JobStats) GetReservationUsage() []*BigQueryAuditMetadata_JobStats_ReservationResourceUsage {
	if x != nil {
		return x.ReservationUsage
	}
	return nil
}

func (x *BigQueryAuditMetadata_JobStats) GetParentJobName() string {
	if x != nil {
		return x.ParentJobName
	}
	return ""
}

type isBigQueryAuditMetadata_JobStats_Extended interface {
	isBigQueryAuditMetadata_JobStats_Extended()
}

type BigQueryAuditMetadata_JobStats_QueryStats struct {
	// Query job statistics.
	QueryStats *BigQueryAuditMetadata_JobStats_Query `protobuf:"bytes,8,opt,name=query_stats,json=queryStats,proto3,oneof"`
}

type BigQueryAuditMetadata_JobStats_LoadStats struct {
	// Load job statistics.
	LoadStats *BigQueryAuditMetadata_JobStats_Load `protobuf:"bytes,9,opt,name=load_stats,json=loadStats,proto3,oneof"`
}

type BigQueryAuditMetadata_JobStats_ExtractStats struct {
	// Extract job statistics.
	ExtractStats *BigQueryAuditMetadata_JobStats_Extract `protobuf:"bytes,13,opt,name=extract_stats,json=extractStats,proto3,oneof"`
}

func (*BigQueryAuditMetadata_JobStats_QueryStats) isBigQueryAuditMetadata_JobStats_Extended() {}

func (*BigQueryAuditMetadata_JobStats_LoadStats) isBigQueryAuditMetadata_JobStats_Extended() {}

func (*BigQueryAuditMetadata_JobStats_ExtractStats) isBigQueryAuditMetadata_JobStats_Extended() {}

// BigQuery table.
type BigQueryAuditMetadata_Table struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Table URI.
	//
	// Format: `projects/<project_id>/datasets/<dataset_id>/tables/<table_id>`.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// A JSON representation of the table's schema. Entire field is truncated
	// if exceeds 40K.
	SchemaJson string `protobuf:"bytes,3,opt,name=schema_json,json=schemaJson,proto3" json:"schema_json,omitempty"`
	// True if the schema_json field was truncated.
	SchemaJsonTruncated bool `protobuf:"varint,11,opt,name=schema_json_truncated,json=schemaJsonTruncated,proto3" json:"schema_json_truncated,omitempty"`
	// View metadata. Only present for views.
	View *BigQueryAuditMetadata_TableViewDefinition `protobuf:"bytes,4,opt,name=view,proto3" json:"view,omitempty"`
	// Table expiration time.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// The table creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The last time metadata update time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The last table truncation time.
	TruncateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=truncate_time,json=truncateTime,proto3" json:"truncate_time,omitempty"`
	// Table encryption information. Set when non-default encryption is used.
	Encryption *BigQueryAuditMetadata_EncryptionInfo `protobuf:"bytes,9,opt,name=encryption,proto3" json:"encryption,omitempty"`
	// User-provided metadata for the table.
	TableInfo *BigQueryAuditMetadata_EntityInfo `protobuf:"bytes,10,opt,name=table_info,json=tableInfo,proto3" json:"table_info,omitempty"`
}

func (x *BigQueryAuditMetadata_Table) Reset() {
	*x = BigQueryAuditMetadata_Table{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_Table) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_Table) ProtoMessage() {}

func (x *BigQueryAuditMetadata_Table) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_Table.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_Table) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 25}
}

func (x *BigQueryAuditMetadata_Table) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (x *BigQueryAuditMetadata_Table) GetSchemaJson() string {
	if x != nil {
		return x.SchemaJson
	}
	return ""
}

func (x *BigQueryAuditMetadata_Table) GetSchemaJsonTruncated() bool {
	if x != nil {
		return x.SchemaJsonTruncated
	}
	return false
}

func (x *BigQueryAuditMetadata_Table) GetView() *BigQueryAuditMetadata_TableViewDefinition {
	if x != nil {
		return x.View
	}
	return nil
}

func (x *BigQueryAuditMetadata_Table) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *BigQueryAuditMetadata_Table) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BigQueryAuditMetadata_Table) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *BigQueryAuditMetadata_Table) GetTruncateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.TruncateTime
	}
	return nil
}

func (x *BigQueryAuditMetadata_Table) GetEncryption() *BigQueryAuditMetadata_EncryptionInfo {
	if x != nil {
		return x.Encryption
	}
	return nil
}

func (x *BigQueryAuditMetadata_Table) GetTableInfo() *BigQueryAuditMetadata_EntityInfo {
	if x != nil {
		return x.TableInfo
	}
	return nil
}

// User Defined Function (UDF) or Stored Procedure.
type BigQueryAuditMetadata_Routine struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Routine URI.
	//
	// Format:
	// `projects/<project_id>/datasets/<dataset_id>/routines/<routine_id>`.
	RoutineName string `protobuf:"bytes,1,opt,name=routine_name,json=routineName,proto3" json:"routine_name,omitempty"`
	// Routine creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Routine last update time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *BigQueryAuditMetadata_Routine) Reset() {
	*x = BigQueryAuditMetadata_Routine{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_Routine) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_Routine) ProtoMessage() {}

func (x *BigQueryAuditMetadata_Routine) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_Routine.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_Routine) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 26}
}

func (x *BigQueryAuditMetadata_Routine) GetRoutineName() string {
	if x != nil {
		return x.RoutineName
	}
	return ""
}

func (x *BigQueryAuditMetadata_Routine) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BigQueryAuditMetadata_Routine) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// User-provided metadata for an entity, for e.g. dataset, table or model.
type BigQueryAuditMetadata_EntityInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A short name for the entity.
	FriendlyName string `protobuf:"bytes,1,opt,name=friendly_name,json=friendlyName,proto3" json:"friendly_name,omitempty"`
	// A long description for the entity.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Labels provided for the entity.
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *BigQueryAuditMetadata_EntityInfo) Reset() {
	*x = BigQueryAuditMetadata_EntityInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_EntityInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_EntityInfo) ProtoMessage() {}

func (x *BigQueryAuditMetadata_EntityInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_EntityInfo.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_EntityInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 27}
}

func (x *BigQueryAuditMetadata_EntityInfo) GetFriendlyName() string {
	if x != nil {
		return x.FriendlyName
	}
	return ""
}

func (x *BigQueryAuditMetadata_EntityInfo) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *BigQueryAuditMetadata_EntityInfo) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// View definition.
type BigQueryAuditMetadata_TableViewDefinition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// SQL query defining the view. Truncated if exceeds 40K.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// True if the schema_json field was truncated.
	QueryTruncated bool `protobuf:"varint,2,opt,name=query_truncated,json=queryTruncated,proto3" json:"query_truncated,omitempty"`
}

func (x *BigQueryAuditMetadata_TableViewDefinition) Reset() {
	*x = BigQueryAuditMetadata_TableViewDefinition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_TableViewDefinition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_TableViewDefinition) ProtoMessage() {}

func (x *BigQueryAuditMetadata_TableViewDefinition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_TableViewDefinition.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_TableViewDefinition) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 28}
}

func (x *BigQueryAuditMetadata_TableViewDefinition) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *BigQueryAuditMetadata_TableViewDefinition) GetQueryTruncated() bool {
	if x != nil {
		return x.QueryTruncated
	}
	return false
}

// An access control list.
type BigQueryAuditMetadata_BigQueryAcl struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// IAM policy for the resource.
	Policy *v1.Policy `protobuf:"bytes,1,opt,name=policy,proto3" json:"policy,omitempty"`
	// List of authorized views for a dataset.
	//
	// Format: `projects/<project_id>/datasets/<dataset_id>/tables/<view_id>`.
	AuthorizedViews []string `protobuf:"bytes,2,rep,name=authorized_views,json=authorizedViews,proto3" json:"authorized_views,omitempty"`
}

func (x *BigQueryAuditMetadata_BigQueryAcl) Reset() {
	*x = BigQueryAuditMetadata_BigQueryAcl{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_BigQueryAcl) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_BigQueryAcl) ProtoMessage() {}

func (x *BigQueryAuditMetadata_BigQueryAcl) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_BigQueryAcl.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_BigQueryAcl) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 29}
}

func (x *BigQueryAuditMetadata_BigQueryAcl) GetPolicy() *v1.Policy {
	if x != nil {
		return x.Policy
	}
	return nil
}

func (x *BigQueryAuditMetadata_BigQueryAcl) GetAuthorizedViews() []string {
	if x != nil {
		return x.AuthorizedViews
	}
	return nil
}

// Encryption properties for a table or a job
type BigQueryAuditMetadata_EncryptionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud kms key identifier.
	//
	// Format:
	// `projects/<project_id>/locations/<location>/keyRings/<key_ring_name>/cryptoKeys/<key_name>`
	KmsKeyName string `protobuf:"bytes,1,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
}

func (x *BigQueryAuditMetadata_EncryptionInfo) Reset() {
	*x = BigQueryAuditMetadata_EncryptionInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_EncryptionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_EncryptionInfo) ProtoMessage() {}

func (x *BigQueryAuditMetadata_EncryptionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_EncryptionInfo.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_EncryptionInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 30}
}

func (x *BigQueryAuditMetadata_EncryptionInfo) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

// Query job configuration.
type BigQueryAuditMetadata_JobConfig_Query struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SQL query to run. Truncated if exceeds 50K.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// True if the query field was truncated.
	QueryTruncated bool `protobuf:"varint,10,opt,name=query_truncated,json=queryTruncated,proto3" json:"query_truncated,omitempty"`
	// The destination table for the query results.
	DestinationTable string `protobuf:"bytes,2,opt,name=destination_table,json=destinationTable,proto3" json:"destination_table,omitempty"`
	// Destination table create disposition.
	CreateDisposition BigQueryAuditMetadata_CreateDisposition `protobuf:"varint,3,opt,name=create_disposition,json=createDisposition,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_CreateDisposition" json:"create_disposition,omitempty"`
	// Destination table write disposition.
	WriteDisposition BigQueryAuditMetadata_WriteDisposition `protobuf:"varint,4,opt,name=write_disposition,json=writeDisposition,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_WriteDisposition" json:"write_disposition,omitempty"`
	// Default dataset for the query.
	DefaultDataset string `protobuf:"bytes,5,opt,name=default_dataset,json=defaultDataset,proto3" json:"default_dataset,omitempty"`
	// External data sources used in the query.
	TableDefinitions []*BigQueryAuditMetadata_TableDefinition `protobuf:"bytes,6,rep,name=table_definitions,json=tableDefinitions,proto3" json:"table_definitions,omitempty"`
	// Priority given to the query.
	Priority BigQueryAuditMetadata_JobConfig_Query_Priority `protobuf:"varint,7,opt,name=priority,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_JobConfig_Query_Priority" json:"priority,omitempty"`
	// Result table encryption information. Set when non-default encryption is
	// used.
	DestinationTableEncryption *BigQueryAuditMetadata_EncryptionInfo `protobuf:"bytes,8,opt,name=destination_table_encryption,json=destinationTableEncryption,proto3" json:"destination_table_encryption,omitempty"`
	// Type of the query.
	StatementType BigQueryAuditMetadata_QueryStatementType `protobuf:"varint,9,opt,name=statement_type,json=statementType,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_QueryStatementType" json:"statement_type,omitempty"`
}

func (x *BigQueryAuditMetadata_JobConfig_Query) Reset() {
	*x = BigQueryAuditMetadata_JobConfig_Query{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_JobConfig_Query) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_JobConfig_Query) ProtoMessage() {}

func (x *BigQueryAuditMetadata_JobConfig_Query) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_JobConfig_Query.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_JobConfig_Query) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 21, 0}
}

func (x *BigQueryAuditMetadata_JobConfig_Query) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *BigQueryAuditMetadata_JobConfig_Query) GetQueryTruncated() bool {
	if x != nil {
		return x.QueryTruncated
	}
	return false
}

func (x *BigQueryAuditMetadata_JobConfig_Query) GetDestinationTable() string {
	if x != nil {
		return x.DestinationTable
	}
	return ""
}

func (x *BigQueryAuditMetadata_JobConfig_Query) GetCreateDisposition() BigQueryAuditMetadata_CreateDisposition {
	if x != nil {
		return x.CreateDisposition
	}
	return BigQueryAuditMetadata_CREATE_DISPOSITION_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_JobConfig_Query) GetWriteDisposition() BigQueryAuditMetadata_WriteDisposition {
	if x != nil {
		return x.WriteDisposition
	}
	return BigQueryAuditMetadata_WRITE_DISPOSITION_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_JobConfig_Query) GetDefaultDataset() string {
	if x != nil {
		return x.DefaultDataset
	}
	return ""
}

func (x *BigQueryAuditMetadata_JobConfig_Query) GetTableDefinitions() []*BigQueryAuditMetadata_TableDefinition {
	if x != nil {
		return x.TableDefinitions
	}
	return nil
}

func (x *BigQueryAuditMetadata_JobConfig_Query) GetPriority() BigQueryAuditMetadata_JobConfig_Query_Priority {
	if x != nil {
		return x.Priority
	}
	return BigQueryAuditMetadata_JobConfig_Query_PRIORITY_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_JobConfig_Query) GetDestinationTableEncryption() *BigQueryAuditMetadata_EncryptionInfo {
	if x != nil {
		return x.DestinationTableEncryption
	}
	return nil
}

func (x *BigQueryAuditMetadata_JobConfig_Query) GetStatementType() BigQueryAuditMetadata_QueryStatementType {
	if x != nil {
		return x.StatementType
	}
	return BigQueryAuditMetadata_QUERY_STATEMENT_TYPE_UNSPECIFIED
}

// Load job configuration.
type BigQueryAuditMetadata_JobConfig_Load struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URIs for the data to be imported. Entire list is truncated if exceeds
	// 40K.
	SourceUris []string `protobuf:"bytes,1,rep,name=source_uris,json=sourceUris,proto3" json:"source_uris,omitempty"`
	// True if the source_URIs field was truncated.
	SourceUrisTruncated bool `protobuf:"varint,7,opt,name=source_uris_truncated,json=sourceUrisTruncated,proto3" json:"source_uris_truncated,omitempty"`
	// The table schema in JSON format. Entire field is truncated if exceeds
	// 40K.
	SchemaJson string `protobuf:"bytes,2,opt,name=schema_json,json=schemaJson,proto3" json:"schema_json,omitempty"`
	// True if the schema_json field was truncated.
	SchemaJsonTruncated bool `protobuf:"varint,8,opt,name=schema_json_truncated,json=schemaJsonTruncated,proto3" json:"schema_json_truncated,omitempty"`
	// The destination table for the import.
	DestinationTable string `protobuf:"bytes,3,opt,name=destination_table,json=destinationTable,proto3" json:"destination_table,omitempty"`
	// Destination table create disposition.
	CreateDisposition BigQueryAuditMetadata_CreateDisposition `protobuf:"varint,4,opt,name=create_disposition,json=createDisposition,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_CreateDisposition" json:"create_disposition,omitempty"`
	// Destination table write disposition.
	WriteDisposition BigQueryAuditMetadata_WriteDisposition `protobuf:"varint,5,opt,name=write_disposition,json=writeDisposition,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_WriteDisposition" json:"write_disposition,omitempty"`
	// Result table encryption information. Set when non-default encryption is
	// used.
	DestinationTableEncryption *BigQueryAuditMetadata_EncryptionInfo `protobuf:"bytes,6,opt,name=destination_table_encryption,json=destinationTableEncryption,proto3" json:"destination_table_encryption,omitempty"`
}

func (x *BigQueryAuditMetadata_JobConfig_Load) Reset() {
	*x = BigQueryAuditMetadata_JobConfig_Load{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_JobConfig_Load) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_JobConfig_Load) ProtoMessage() {}

func (x *BigQueryAuditMetadata_JobConfig_Load) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_JobConfig_Load.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_JobConfig_Load) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 21, 1}
}

func (x *BigQueryAuditMetadata_JobConfig_Load) GetSourceUris() []string {
	if x != nil {
		return x.SourceUris
	}
	return nil
}

func (x *BigQueryAuditMetadata_JobConfig_Load) GetSourceUrisTruncated() bool {
	if x != nil {
		return x.SourceUrisTruncated
	}
	return false
}

func (x *BigQueryAuditMetadata_JobConfig_Load) GetSchemaJson() string {
	if x != nil {
		return x.SchemaJson
	}
	return ""
}

func (x *BigQueryAuditMetadata_JobConfig_Load) GetSchemaJsonTruncated() bool {
	if x != nil {
		return x.SchemaJsonTruncated
	}
	return false
}

func (x *BigQueryAuditMetadata_JobConfig_Load) GetDestinationTable() string {
	if x != nil {
		return x.DestinationTable
	}
	return ""
}

func (x *BigQueryAuditMetadata_JobConfig_Load) GetCreateDisposition() BigQueryAuditMetadata_CreateDisposition {
	if x != nil {
		return x.CreateDisposition
	}
	return BigQueryAuditMetadata_CREATE_DISPOSITION_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_JobConfig_Load) GetWriteDisposition() BigQueryAuditMetadata_WriteDisposition {
	if x != nil {
		return x.WriteDisposition
	}
	return BigQueryAuditMetadata_WRITE_DISPOSITION_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_JobConfig_Load) GetDestinationTableEncryption() *BigQueryAuditMetadata_EncryptionInfo {
	if x != nil {
		return x.DestinationTableEncryption
	}
	return nil
}

// Extract job configuration.
type BigQueryAuditMetadata_JobConfig_Extract struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URIs where extracted data should be written. Entire list is truncated
	// if exceeds 50K.
	DestinationUris []string `protobuf:"bytes,1,rep,name=destination_uris,json=destinationUris,proto3" json:"destination_uris,omitempty"`
	// True if the destination_URIs field was truncated.
	DestinationUrisTruncated bool `protobuf:"varint,3,opt,name=destination_uris_truncated,json=destinationUrisTruncated,proto3" json:"destination_uris_truncated,omitempty"`
	// Types that are assignable to Source:
	//	*BigQueryAuditMetadata_JobConfig_Extract_SourceTable
	//	*BigQueryAuditMetadata_JobConfig_Extract_SourceModel
	Source isBigQueryAuditMetadata_JobConfig_Extract_Source `protobuf_oneof:"source"`
}

func (x *BigQueryAuditMetadata_JobConfig_Extract) Reset() {
	*x = BigQueryAuditMetadata_JobConfig_Extract{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_JobConfig_Extract) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_JobConfig_Extract) ProtoMessage() {}

func (x *BigQueryAuditMetadata_JobConfig_Extract) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_JobConfig_Extract.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_JobConfig_Extract) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 21, 2}
}

func (x *BigQueryAuditMetadata_JobConfig_Extract) GetDestinationUris() []string {
	if x != nil {
		return x.DestinationUris
	}
	return nil
}

func (x *BigQueryAuditMetadata_JobConfig_Extract) GetDestinationUrisTruncated() bool {
	if x != nil {
		return x.DestinationUrisTruncated
	}
	return false
}

func (m *BigQueryAuditMetadata_JobConfig_Extract) GetSource() isBigQueryAuditMetadata_JobConfig_Extract_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *BigQueryAuditMetadata_JobConfig_Extract) GetSourceTable() string {
	if x, ok := x.GetSource().(*BigQueryAuditMetadata_JobConfig_Extract_SourceTable); ok {
		return x.SourceTable
	}
	return ""
}

func (x *BigQueryAuditMetadata_JobConfig_Extract) GetSourceModel() string {
	if x, ok := x.GetSource().(*BigQueryAuditMetadata_JobConfig_Extract_SourceModel); ok {
		return x.SourceModel
	}
	return ""
}

type isBigQueryAuditMetadata_JobConfig_Extract_Source interface {
	isBigQueryAuditMetadata_JobConfig_Extract_Source()
}

type BigQueryAuditMetadata_JobConfig_Extract_SourceTable struct {
	// The source table.
	SourceTable string `protobuf:"bytes,2,opt,name=source_table,json=sourceTable,proto3,oneof"`
}

type BigQueryAuditMetadata_JobConfig_Extract_SourceModel struct {
	// The source model.
	SourceModel string `protobuf:"bytes,4,opt,name=source_model,json=sourceModel,proto3,oneof"`
}

func (*BigQueryAuditMetadata_JobConfig_Extract_SourceTable) isBigQueryAuditMetadata_JobConfig_Extract_Source() {
}

func (*BigQueryAuditMetadata_JobConfig_Extract_SourceModel) isBigQueryAuditMetadata_JobConfig_Extract_Source() {
}

// Table copy job configuration.
type BigQueryAuditMetadata_JobConfig_TableCopy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Source tables. Entire list is truncated if exceeds 50K.
	SourceTables []string `protobuf:"bytes,1,rep,name=source_tables,json=sourceTables,proto3" json:"source_tables,omitempty"`
	// True if the source_tables field was truncated.
	SourceTablesTruncated bool `protobuf:"varint,6,opt,name=source_tables_truncated,json=sourceTablesTruncated,proto3" json:"source_tables_truncated,omitempty"`
	// Destination table.
	DestinationTable string `protobuf:"bytes,2,opt,name=destination_table,json=destinationTable,proto3" json:"destination_table,omitempty"`
	// Destination table create disposition.
	CreateDisposition BigQueryAuditMetadata_CreateDisposition `protobuf:"varint,3,opt,name=create_disposition,json=createDisposition,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_CreateDisposition" json:"create_disposition,omitempty"`
	// Destination table write disposition.
	WriteDisposition BigQueryAuditMetadata_WriteDisposition `protobuf:"varint,4,opt,name=write_disposition,json=writeDisposition,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_WriteDisposition" json:"write_disposition,omitempty"`
	// Result table encryption information. Set when non-default encryption is
	// used.
	DestinationTableEncryption *BigQueryAuditMetadata_EncryptionInfo `protobuf:"bytes,5,opt,name=destination_table_encryption,json=destinationTableEncryption,proto3" json:"destination_table_encryption,omitempty"`
	// Supported operation types in the table copy job.
	OperationType BigQueryAuditMetadata_OperationType `protobuf:"varint,7,opt,name=operation_type,json=operationType,proto3,enum=google.cloud.audit.BigQueryAuditMetadata_OperationType" json:"operation_type,omitempty"`
	// Expiration time set on the destination table. Expired tables will be
	// deleted and their storage reclaimed.
	DestinationExpirationTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=destination_expiration_time,json=destinationExpirationTime,proto3" json:"destination_expiration_time,omitempty"`
}

func (x *BigQueryAuditMetadata_JobConfig_TableCopy) Reset() {
	*x = BigQueryAuditMetadata_JobConfig_TableCopy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_JobConfig_TableCopy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_JobConfig_TableCopy) ProtoMessage() {}

func (x *BigQueryAuditMetadata_JobConfig_TableCopy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_JobConfig_TableCopy.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_JobConfig_TableCopy) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 21, 3}
}

func (x *BigQueryAuditMetadata_JobConfig_TableCopy) GetSourceTables() []string {
	if x != nil {
		return x.SourceTables
	}
	return nil
}

func (x *BigQueryAuditMetadata_JobConfig_TableCopy) GetSourceTablesTruncated() bool {
	if x != nil {
		return x.SourceTablesTruncated
	}
	return false
}

func (x *BigQueryAuditMetadata_JobConfig_TableCopy) GetDestinationTable() string {
	if x != nil {
		return x.DestinationTable
	}
	return ""
}

func (x *BigQueryAuditMetadata_JobConfig_TableCopy) GetCreateDisposition() BigQueryAuditMetadata_CreateDisposition {
	if x != nil {
		return x.CreateDisposition
	}
	return BigQueryAuditMetadata_CREATE_DISPOSITION_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_JobConfig_TableCopy) GetWriteDisposition() BigQueryAuditMetadata_WriteDisposition {
	if x != nil {
		return x.WriteDisposition
	}
	return BigQueryAuditMetadata_WRITE_DISPOSITION_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_JobConfig_TableCopy) GetDestinationTableEncryption() *BigQueryAuditMetadata_EncryptionInfo {
	if x != nil {
		return x.DestinationTableEncryption
	}
	return nil
}

func (x *BigQueryAuditMetadata_JobConfig_TableCopy) GetOperationType() BigQueryAuditMetadata_OperationType {
	if x != nil {
		return x.OperationType
	}
	return BigQueryAuditMetadata_OPERATION_TYPE_UNSPECIFIED
}

func (x *BigQueryAuditMetadata_JobConfig_TableCopy) GetDestinationExpirationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DestinationExpirationTime
	}
	return nil
}

// Query job statistics.
type BigQueryAuditMetadata_JobStats_Query struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total bytes processed by the query job.
	TotalProcessedBytes int64 `protobuf:"varint,1,opt,name=total_processed_bytes,json=totalProcessedBytes,proto3" json:"total_processed_bytes,omitempty"`
	// Total bytes billed by the query job.
	TotalBilledBytes int64 `protobuf:"varint,2,opt,name=total_billed_bytes,json=totalBilledBytes,proto3" json:"total_billed_bytes,omitempty"`
	// The tier assigned by the CPU-based billing.
	BillingTier int32 `protobuf:"varint,3,opt,name=billing_tier,json=billingTier,proto3" json:"billing_tier,omitempty"`
	// Tables accessed by the query job.
	ReferencedTables []string `protobuf:"bytes,6,rep,name=referenced_tables,json=referencedTables,proto3" json:"referenced_tables,omitempty"`
	// Views accessed by the query job.
	ReferencedViews []string `protobuf:"bytes,7,rep,name=referenced_views,json=referencedViews,proto3" json:"referenced_views,omitempty"`
	// Routines accessed by the query job.
	ReferencedRoutines []string `protobuf:"bytes,10,rep,name=referenced_routines,json=referencedRoutines,proto3" json:"referenced_routines,omitempty"`
	// Number of output rows produced by the query job.
	OutputRowCount int64 `protobuf:"varint,8,opt,name=output_row_count,json=outputRowCount,proto3" json:"output_row_count,omitempty"`
	// True if the query job results were read from the query cache.
	CacheHit bool `protobuf:"varint,9,opt,name=cache_hit,json=cacheHit,proto3" json:"cache_hit,omitempty"`
}

func (x *BigQueryAuditMetadata_JobStats_Query) Reset() {
	*x = BigQueryAuditMetadata_JobStats_Query{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_JobStats_Query) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_JobStats_Query) ProtoMessage() {}

func (x *BigQueryAuditMetadata_JobStats_Query) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_JobStats_Query.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_JobStats_Query) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 24, 0}
}

func (x *BigQueryAuditMetadata_JobStats_Query) GetTotalProcessedBytes() int64 {
	if x != nil {
		return x.TotalProcessedBytes
	}
	return 0
}

func (x *BigQueryAuditMetadata_JobStats_Query) GetTotalBilledBytes() int64 {
	if x != nil {
		return x.TotalBilledBytes
	}
	return 0
}

func (x *BigQueryAuditMetadata_JobStats_Query) GetBillingTier() int32 {
	if x != nil {
		return x.BillingTier
	}
	return 0
}

func (x *BigQueryAuditMetadata_JobStats_Query) GetReferencedTables() []string {
	if x != nil {
		return x.ReferencedTables
	}
	return nil
}

func (x *BigQueryAuditMetadata_JobStats_Query) GetReferencedViews() []string {
	if x != nil {
		return x.ReferencedViews
	}
	return nil
}

func (x *BigQueryAuditMetadata_JobStats_Query) GetReferencedRoutines() []string {
	if x != nil {
		return x.ReferencedRoutines
	}
	return nil
}

func (x *BigQueryAuditMetadata_JobStats_Query) GetOutputRowCount() int64 {
	if x != nil {
		return x.OutputRowCount
	}
	return 0
}

func (x *BigQueryAuditMetadata_JobStats_Query) GetCacheHit() bool {
	if x != nil {
		return x.CacheHit
	}
	return false
}

// Load job statistics.
type BigQueryAuditMetadata_JobStats_Load struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total bytes loaded by the import job.
	TotalOutputBytes int64 `protobuf:"varint,1,opt,name=total_output_bytes,json=totalOutputBytes,proto3" json:"total_output_bytes,omitempty"`
}

func (x *BigQueryAuditMetadata_JobStats_Load) Reset() {
	*x = BigQueryAuditMetadata_JobStats_Load{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_JobStats_Load) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_JobStats_Load) ProtoMessage() {}

func (x *BigQueryAuditMetadata_JobStats_Load) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_JobStats_Load.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_JobStats_Load) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 24, 1}
}

func (x *BigQueryAuditMetadata_JobStats_Load) GetTotalOutputBytes() int64 {
	if x != nil {
		return x.TotalOutputBytes
	}
	return 0
}

// Extract job statistics.
type BigQueryAuditMetadata_JobStats_Extract struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total bytes exported by the extract job.
	TotalInputBytes int64 `protobuf:"varint,1,opt,name=total_input_bytes,json=totalInputBytes,proto3" json:"total_input_bytes,omitempty"`
}

func (x *BigQueryAuditMetadata_JobStats_Extract) Reset() {
	*x = BigQueryAuditMetadata_JobStats_Extract{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_JobStats_Extract) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_JobStats_Extract) ProtoMessage() {}

func (x *BigQueryAuditMetadata_JobStats_Extract) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_JobStats_Extract.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_JobStats_Extract) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 24, 2}
}

func (x *BigQueryAuditMetadata_JobStats_Extract) GetTotalInputBytes() int64 {
	if x != nil {
		return x.TotalInputBytes
	}
	return 0
}

// Job resource usage breakdown by reservation.
type BigQueryAuditMetadata_JobStats_ReservationResourceUsage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Reservation name or "unreserved" for on-demand resources usage.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Total slot milliseconds used by the reservation for a particular job.
	SlotMs int64 `protobuf:"varint,2,opt,name=slot_ms,json=slotMs,proto3" json:"slot_ms,omitempty"`
}

func (x *BigQueryAuditMetadata_JobStats_ReservationResourceUsage) Reset() {
	*x = BigQueryAuditMetadata_JobStats_ReservationResourceUsage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAuditMetadata_JobStats_ReservationResourceUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAuditMetadata_JobStats_ReservationResourceUsage) ProtoMessage() {}

func (x *BigQueryAuditMetadata_JobStats_ReservationResourceUsage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAuditMetadata_JobStats_ReservationResourceUsage.ProtoReflect.Descriptor instead.
func (*BigQueryAuditMetadata_JobStats_ReservationResourceUsage) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP(), []int{0, 24, 3}
}

func (x *BigQueryAuditMetadata_JobStats_ReservationResourceUsage) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BigQueryAuditMetadata_JobStats_ReservationResourceUsage) GetSlotMs() int64 {
	if x != nil {
		return x.SlotMs
	}
	return 0
}

var File_google_cloud_audit_bigquery_audit_metadata_proto protoreflect.FileDescriptor

var file_google_cloud_audit_bigquery_audit_metadata_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x75, 0x64, 0x69, 0x74, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x61, 0x75,
	0x64, 0x69, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x12, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69,
	0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x90, 0x73, 0x0a,
	0x15, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5d, 0x0a, 0x0d, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x6e,
	0x73, 0x65, 0x72, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64,
	0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4a, 0x6f, 0x62, 0x49, 0x6e, 0x73, 0x65,
	0x72, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0c, 0x6a, 0x6f, 0x62, 0x49, 0x6e, 0x73, 0x65,
	0x72, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x0a, 0x6a, 0x6f, 0x62, 0x5f, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42,
	0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x4a, 0x6f, 0x62, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x00,
	0x52, 0x09, 0x6a, 0x6f, 0x62, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x66, 0x0a, 0x10, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x48, 0x00, 0x52, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x60, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74,
	0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x66, 0x0a, 0x10, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64,
	0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0f, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x60, 0x0a,
	0x0e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x0d, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x5a, 0x0a, 0x0c, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x00, 0x52, 0x0b,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x60, 0x0a, 0x0e, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0d,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x61, 0x0a,
	0x0f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x61, 0x64,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x61, 0x64, 0x48,
	0x00, 0x52, 0x0d, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x61, 0x64,
	0x12, 0x67, 0x0a, 0x11, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74,
	0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61,
	0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x00, 0x52, 0x0f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x60, 0x0a, 0x0e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41,
	0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0d, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x60, 0x0a, 0x0e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0d,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x73, 0x0a,
	0x15, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69,
	0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x00, 0x52, 0x13, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x12, 0x67, 0x0a, 0x11, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64,
	0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x61,
	0x74, 0x61, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x00, 0x52, 0x0f, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x44, 0x61, 0x74, 0x61, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x61, 0x0a, 0x0f, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x18, 0x13,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x61, 0x64, 0x48, 0x00, 0x52,
	0x0d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x61, 0x64, 0x12, 0x66,
	0x0a, 0x10, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x60, 0x0a, 0x0e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75,
	0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69,
	0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x72, 0x6f, 0x75, 0x74, 0x69,
	0x6e, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x66, 0x0a, 0x10, 0x72, 0x6f, 0x75, 0x74,
	0x69, 0x6e, 0x65, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x12, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x52, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x0f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e,
	0x1a, 0xf3, 0x01, 0x0a, 0x0c, 0x4a, 0x6f, 0x62, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x3f, 0x0a, 0x03, 0x6a, 0x6f, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75,
	0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69,
	0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4a, 0x6f, 0x62, 0x52, 0x03, 0x6a,
	0x6f, 0x62, 0x12, 0x55, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4a, 0x6f,
	0x62, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x22, 0x4b, 0x0a, 0x06, 0x52, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x4a,
	0x4f, 0x42, 0x5f, 0x49, 0x4e, 0x53, 0x45, 0x52, 0x54, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53,
	0x54, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x52, 0x45, 0x51,
	0x55, 0x45, 0x53, 0x54, 0x10, 0x02, 0x1a, 0xe2, 0x01, 0x0a, 0x09, 0x4a, 0x6f, 0x62, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x4a, 0x0a, 0x06, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x06, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65,
	0x12, 0x48, 0x0a, 0x05, 0x61, 0x66, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64,
	0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x52, 0x05, 0x61, 0x66, 0x74, 0x65, 0x72, 0x12, 0x3f, 0x0a, 0x03, 0x6a, 0x6f,
	0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x4a, 0x6f, 0x62, 0x52, 0x03, 0x6a, 0x6f, 0x62, 0x1a, 0x8c, 0x02, 0x0a, 0x0f,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x4b, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75,
	0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x58, 0x0a, 0x06,
	0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69,
	0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52, 0x06,
	0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6a, 0x6f, 0x62, 0x4e, 0x61, 0x6d,
	0x65, 0x22, 0x37, 0x0a, 0x06, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x12, 0x52,
	0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12,
	0x09, 0x0a, 0x05, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x02, 0x1a, 0x9c, 0x02, 0x0a, 0x0d, 0x44,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x4b, 0x0a, 0x07,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64,
	0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x56, 0x0a, 0x06, 0x72, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42,
	0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x6a, 0x6f, 0x62, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x4b, 0x0a, 0x06,
	0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a,
	0x0a, 0x06, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x45,
	0x54, 0x5f, 0x49, 0x41, 0x4d, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x10, 0x02, 0x12, 0x09,
	0x0a, 0x05, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x03, 0x1a, 0xbf, 0x01, 0x0a, 0x0f, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a,
	0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64,
	0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52,
	0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6a, 0x6f, 0x62, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6a, 0x6f, 0x62, 0x4e, 0x61,
	0x6d, 0x65, 0x22, 0x37, 0x0a, 0x06, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x12,
	0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x01,
	0x12, 0x09, 0x0a, 0x05, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x02, 0x1a, 0x99, 0x02, 0x0a, 0x0d,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a,
	0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69,
	0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x05, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x12, 0x56, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x08,
	0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6a, 0x6f, 0x62, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x4e, 0x0a, 0x06, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x4a, 0x4f, 0x42,
	0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x02, 0x12, 0x18, 0x0a,
	0x14, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x49, 0x4e, 0x53, 0x45, 0x52, 0x54, 0x5f, 0x52, 0x45,
	0x51, 0x55, 0x45, 0x53, 0x54, 0x10, 0x03, 0x1a, 0xf6, 0x01, 0x0a, 0x0d, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a, 0x05, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x12, 0x56, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75,
	0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6a, 0x6f, 0x62, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6a, 0x6f, 0x62, 0x4e,
	0x61, 0x6d, 0x65, 0x22, 0x2b, 0x0a, 0x06, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x16, 0x0a,
	0x12, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x02,
	0x1a, 0x9c, 0x02, 0x0a, 0x0f, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x07, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x52, 0x07, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x65, 0x12, 0x58, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41,
	0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x52, 0x6f, 0x75,
	0x74, 0x69, 0x6e, 0x65, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6a,
	0x6f, 0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6a,
	0x6f, 0x62, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x47, 0x0a, 0x06, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x51, 0x55, 0x45, 0x52,
	0x59, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x4f, 0x55, 0x54, 0x49, 0x4e, 0x45, 0x5f, 0x49,
	0x4e, 0x53, 0x45, 0x52, 0x54, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x10, 0x02, 0x1a,
	0xef, 0x03, 0x0a, 0x0d, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x61,
	0x64, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x73, 0x5f, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x54, 0x72, 0x75, 0x6e, 0x63,
	0x61, 0x74, 0x65, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74,
	0x61, 0x67, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x54, 0x61, 0x67, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f,
	0x74, 0x61, 0x67, 0x73, 0x5f, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x73,
	0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x12, 0x56, 0x0a, 0x06, 0x72, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42,
	0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65,
	0x61, 0x64, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x6a, 0x6f, 0x62, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x22,
	0xaf, 0x01, 0x0a, 0x06, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45,
	0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x4a, 0x4f, 0x42, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x54,
	0x41, 0x42, 0x4c, 0x45, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x5f, 0x52, 0x45,
	0x51, 0x55, 0x45, 0x53, 0x54, 0x10, 0x02, 0x12, 0x1d, 0x0a, 0x19, 0x47, 0x45, 0x54, 0x5f, 0x51,
	0x55, 0x45, 0x52, 0x59, 0x5f, 0x52, 0x45, 0x53, 0x55, 0x4c, 0x54, 0x53, 0x5f, 0x52, 0x45, 0x51,
	0x55, 0x45, 0x53, 0x54, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f,
	0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x10, 0x04, 0x12, 0x17, 0x0a, 0x13, 0x43, 0x52, 0x45,
	0x41, 0x54, 0x45, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e,
	0x10, 0x05, 0x12, 0x1d, 0x0a, 0x19, 0x4d, 0x41, 0x54, 0x45, 0x52, 0x49, 0x41, 0x4c, 0x49, 0x5a,
	0x45, 0x44, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x52, 0x45, 0x46, 0x52, 0x45, 0x53, 0x48, 0x10,
	0x06, 0x1a, 0xb3, 0x02, 0x0a, 0x0b, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x12, 0x45, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75,
	0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x72, 0x75, 0x6e,
	0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x74, 0x72, 0x75,
	0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x12, 0x54, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x08,
	0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6a, 0x6f, 0x62, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x4e, 0x0a, 0x06, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x54, 0x41, 0x42,
	0x4c, 0x45, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53,
	0x54, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x4a, 0x4f, 0x42, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05,
	0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x03, 0x1a, 0x9b, 0x02, 0x0a, 0x13, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12,
	0x45, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75,
	0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69,
	0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52,
	0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x5c, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52, 0x06, 0x72, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6a, 0x6f, 0x62, 0x4e, 0x61, 0x6d, 0x65, 0x22,
	0x44, 0x0a, 0x06, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x41,
	0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x17, 0x0a, 0x13, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f, 0x50, 0x41, 0x54, 0x43, 0x48,
	0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x51, 0x55,
	0x45, 0x52, 0x59, 0x10, 0x02, 0x1a, 0x98, 0x02, 0x0a, 0x0d, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x4b, 0x0a, 0x07, 0x72, 0x6f, 0x75, 0x74, 0x69,
	0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x52, 0x07, 0x72, 0x6f, 0x75,
	0x74, 0x69, 0x6e, 0x65, 0x12, 0x56, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x08,
	0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6a, 0x6f, 0x62, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x47, 0x0a, 0x06, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x51, 0x55, 0x45,
	0x52, 0x59, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x4f, 0x55, 0x54, 0x49, 0x4e, 0x45, 0x5f,
	0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x10, 0x02,
	0x1a, 0x87, 0x03, 0x0a, 0x0f, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f,
	0x72, 0x6f, 0x77, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x10, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x52, 0x6f, 0x77, 0x73, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x13, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x72,
	0x6f, 0x77, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x11, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x65, 0x64, 0x52, 0x6f, 0x77, 0x73, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x12, 0x58, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75,
	0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x52, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6a, 0x6f,
	0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6a, 0x6f,
	0x62, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x62, 0x0a, 0x06, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x4a, 0x4f, 0x42, 0x10,
	0x01, 0x12, 0x09, 0x0a, 0x05, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x02, 0x12, 0x1d, 0x0a, 0x19,
	0x4d, 0x41, 0x54, 0x45, 0x52, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x45, 0x44, 0x5f, 0x56, 0x49, 0x45,
	0x57, 0x5f, 0x52, 0x45, 0x46, 0x52, 0x45, 0x53, 0x48, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x57,
	0x52, 0x49, 0x54, 0x45, 0x5f, 0x41, 0x50, 0x49, 0x10, 0x04, 0x1a, 0xb3, 0x01, 0x0a, 0x0f, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x58,
	0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75,
	0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69,
	0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44,
	0x61, 0x74, 0x61, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6a, 0x6f, 0x62, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6a, 0x6f, 0x62, 0x4e,
	0x61, 0x6d, 0x65, 0x22, 0x2b, 0x0a, 0x06, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x16, 0x0a,
	0x12, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x01,
	0x1a, 0xad, 0x01, 0x0a, 0x0d, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65,
	0x61, 0x64, 0x12, 0x56, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x61, 0x64, 0x2e, 0x52, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6a, 0x6f,
	0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6a, 0x6f,
	0x62, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x29, 0x0a, 0x06, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12,
	0x16, 0x0a, 0x12, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x4a, 0x4f, 0x42, 0x10, 0x01,
	0x1a, 0x8f, 0x04, 0x0a, 0x07, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x21, 0x0a, 0x0c,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x03, 0x61, 0x63, 0x6c,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x63, 0x6c, 0x52, 0x03, 0x61,
	0x63, 0x6c, 0x12, 0x5c, 0x0a, 0x1d, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1a, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x45, 0x78, 0x70, 0x69, 0x72, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x57, 0x0a, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0b, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x67, 0x0a, 0x12, 0x64, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x11, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x1a, 0xd6, 0x01, 0x0a, 0x0d, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x08,
	0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6a, 0x6f, 0x62, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x52, 0x0a, 0x06, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x54, 0x41, 0x42,
	0x4c, 0x45, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53,
	0x54, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x58, 0x50, 0x49, 0x52, 0x45, 0x44, 0x10, 0x03,
	0x12, 0x09, 0x0a, 0x05, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x04, 0x1a, 0xd6, 0x01, 0x0a, 0x0d,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a,
	0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64,
	0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52, 0x06, 0x72,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6a, 0x6f, 0x62, 0x4e, 0x61, 0x6d, 0x65,
	0x22, 0x52, 0x0a, 0x06, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45,
	0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x45, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07,
	0x45, 0x58, 0x50, 0x49, 0x52, 0x45, 0x44, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x51, 0x55, 0x45,
	0x52, 0x59, 0x10, 0x03, 0x1a, 0x8c, 0x03, 0x0a, 0x05, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x1d,
	0x0a, 0x0a, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x53, 0x0a,
	0x0a, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41,
	0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x3b, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0a, 0x65, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64,
	0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x1a, 0x9c, 0x02, 0x0a, 0x0f, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x07, 0x72, 0x6f, 0x75, 0x74, 0x69,
	0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x52, 0x07, 0x72, 0x6f, 0x75,
	0x74, 0x69, 0x6e, 0x65, 0x12, 0x58, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x19,
	0x0a, 0x08, 0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6a, 0x6f, 0x62, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x47, 0x0a, 0x06, 0x52, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x51,
	0x55, 0x45, 0x52, 0x59, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x4f, 0x55, 0x54, 0x49, 0x4e,
	0x45, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54,
	0x10, 0x02, 0x1a, 0x99, 0x02, 0x0a, 0x03, 0x4a, 0x6f, 0x62, 0x12, 0x19, 0x0a, 0x08, 0x6a, 0x6f,
	0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6a, 0x6f,
	0x62, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x0a, 0x6a, 0x6f, 0x62, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42,
	0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x09,
	0x6a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x52, 0x0a, 0x0a, 0x6a, 0x6f, 0x62,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64,
	0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x09, 0x6a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x4f, 0x0a,
	0x09, 0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75,
	0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4a, 0x6f, 0x62, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x52, 0x08, 0x6a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x73, 0x1a, 0xdc,
	0x17, 0x0a, 0x09, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4c, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e,
	0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x5e, 0x0a, 0x0c, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75,
	0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4a, 0x6f, 0x62, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x48, 0x00, 0x52, 0x0b, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5b, 0x0a, 0x0b, 0x6c, 0x6f,
	0x61, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64,
	0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4a, 0x6f, 0x62, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x0a, 0x6c, 0x6f, 0x61,
	0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x64, 0x0a, 0x0e, 0x65, 0x78, 0x74, 0x72, 0x61,
	0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64,
	0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4a, 0x6f, 0x62, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x48, 0x00, 0x52, 0x0d,
	0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6b, 0x0a,
	0x11, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x70, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x43, 0x6f, 0x70, 0x79, 0x48, 0x00, 0x52, 0x0f, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x43, 0x6f, 0x70, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x57, 0x0a, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e,
	0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x1a, 0xe8, 0x06, 0x0a, 0x05, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x12, 0x27, 0x0a, 0x0f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x72, 0x75,
	0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x12, 0x2b, 0x0a, 0x11,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x6a, 0x0a, 0x12, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x11, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x67, 0x0a, 0x11, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x64,
	0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75,
	0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x57, 0x72, 0x69, 0x74,
	0x65, 0x44, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x77, 0x72,
	0x69, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27,
	0x0a, 0x0f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x66, 0x0a, 0x11, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x5e, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41,
	0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4a, 0x6f, 0x62,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x50, 0x72, 0x69,
	0x6f, 0x72, 0x69, 0x74, 0x79, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12,
	0x7a, 0x0a, 0x1c, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x1a, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x63, 0x0a, 0x0e, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x22, 0x4c, 0x0a, 0x08, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a, 0x14,
	0x50, 0x52, 0x49, 0x4f, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f,
	0x49, 0x4e, 0x54, 0x45, 0x52, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0f, 0x0a,
	0x0b, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x42, 0x41, 0x54, 0x43, 0x48, 0x10, 0x02, 0x1a, 0xae,
	0x04, 0x0a, 0x04, 0x4c, 0x6f, 0x61, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x55, 0x72, 0x69, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x5f, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55,
	0x72, 0x69, 0x73, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x12, 0x1f, 0x0a, 0x0b,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4a, 0x73, 0x6f, 0x6e, 0x12, 0x32, 0x0a,
	0x15, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x74, 0x72, 0x75,
	0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x73, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x4a, 0x73, 0x6f, 0x6e, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x12, 0x2b, 0x0a, 0x11, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x6a,
	0x0a, 0x12, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e,
	0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44,
	0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x67, 0x0a, 0x11, 0x77, 0x72,
	0x69, 0x74, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x10, 0x77, 0x72, 0x69, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x7a, 0x0a, 0x1c, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42,
	0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x1a, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a,
	0xc6, 0x01, 0x0a, 0x07, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x64,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x55, 0x72, 0x69, 0x73, 0x12, 0x3c, 0x0a, 0x1a, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x5f, 0x74, 0x72, 0x75, 0x6e, 0x63,
	0x61, 0x74, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x18, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x72, 0x69, 0x73, 0x54, 0x72, 0x75, 0x6e, 0x63,
	0x61, 0x74, 0x65, 0x64, 0x12, 0x23, 0x0a, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x08,
	0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x1a, 0xa2, 0x05, 0x0a, 0x09, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x43, 0x6f, 0x70, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x36, 0x0a, 0x17, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x5f, 0x74, 0x72, 0x75,
	0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61,
	0x74, 0x65, 0x64, 0x12, 0x2b, 0x0a, 0x11, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x12, 0x6a, 0x0a, 0x12, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69,
	0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x69,
	0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x44, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x67, 0x0a, 0x11,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x10, 0x77, 0x72, 0x69, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7a, 0x0a, 0x1c, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74,
	0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x1a, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x5e, 0x0a, 0x0e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42,
	0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x5a, 0x0a, 0x1b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x19, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x39, 0x0a,
	0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x49, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10,
	0x01, 0x12, 0x08, 0x0a, 0x04, 0x43, 0x4f, 0x50, 0x59, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x45,
	0x58, 0x50, 0x4f, 0x52, 0x54, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x49, 0x4d, 0x50, 0x4f, 0x52,
	0x54, 0x10, 0x04, 0x42, 0x08, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x46, 0x0a,
	0x0f, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75,
	0x72, 0x69, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x55, 0x72, 0x69, 0x73, 0x1a, 0xbf, 0x01, 0x0a, 0x09, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x4f, 0x0a, 0x09, 0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x08, 0x6a, 0x6f, 0x62, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x35, 0x0a, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0b,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x2a, 0x0a, 0x06, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x1a, 0xba, 0x09, 0x0a, 0x08, 0x4a, 0x6f, 0x62, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x5b, 0x0a, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x48, 0x00, 0x52, 0x0a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x12, 0x58, 0x0a, 0x0a, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52,
	0x09, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x61, 0x0a, 0x0d, 0x65, 0x78,
	0x74, 0x72, 0x61, 0x63, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41,
	0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4a, 0x6f, 0x62,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x48, 0x00, 0x52,
	0x0c, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x22, 0x0a,
	0x0d, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x6c, 0x6f, 0x74, 0x5f, 0x6d, 0x73, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x6c, 0x6f, 0x74, 0x4d,
	0x73, 0x12, 0x78, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69,
	0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x2e, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x10, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x4a, 0x6f, 0x62, 0x4e,
	0x61, 0x6d, 0x65, 0x1a, 0xdc, 0x02, 0x0a, 0x05, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x32, 0x0a,
	0x15, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64,
	0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x12, 0x2c, 0x0a, 0x12, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x62, 0x69, 0x6c, 0x6c, 0x65,
	0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x42, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12,
	0x21, 0x0a, 0x0c, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x69, 0x65, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x54, 0x69,
	0x65, 0x72, 0x12, 0x2b, 0x0a, 0x11, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x64,
	0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12,
	0x29, 0x0a, 0x10, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x76, 0x69,
	0x65, 0x77, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x73, 0x12, 0x2f, 0x0a, 0x13, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65,
	0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x6f, 0x77,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x68,
	0x69, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x63, 0x61, 0x63, 0x68, 0x65, 0x48,
	0x69, 0x74, 0x1a, 0x34, 0x0a, 0x04, 0x4c, 0x6f, 0x61, 0x64, 0x12, 0x2c, 0x0a, 0x12, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x1a, 0x35, 0x0a, 0x07, 0x45, 0x78, 0x74, 0x72,
	0x61, 0x63, 0x74, 0x12, 0x2a, 0x0a, 0x11, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f,
	0x74, 0x6f, 0x74, 0x61, 0x6c, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x1a,
	0x47, 0x0a, 0x18, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x17, 0x0a, 0x07, 0x73, 0x6c, 0x6f, 0x74, 0x5f, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x06, 0x73, 0x6c, 0x6f, 0x74, 0x4d, 0x73, 0x42, 0x0a, 0x0a, 0x08, 0x65, 0x78, 0x74, 0x65,
	0x6e, 0x64, 0x65, 0x64, 0x1a, 0xf5, 0x04, 0x0a, 0x05, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a,
	0x0b, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4a, 0x73, 0x6f, 0x6e, 0x12, 0x32,
	0x0a, 0x15, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x74, 0x72,
	0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x4a, 0x73, 0x6f, 0x6e, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x12, 0x51, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75,
	0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x56, 0x69, 0x65, 0x77, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x04, 0x76, 0x69, 0x65, 0x77, 0x12, 0x3b, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x0d,
	0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0c, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x58, 0x0a,
	0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41,
	0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x45, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x65, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74,
	0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x1a, 0xa6, 0x01, 0x0a,
	0x07, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x6f, 0x75, 0x74,
	0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0xe8, 0x01, 0x0a, 0x0a, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x6c, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x66, 0x72, 0x69,
	0x65, 0x6e, 0x64, 0x6c, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74,
	0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x66,
	0x6f, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0x54, 0x0a, 0x13, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x56, 0x69, 0x65, 0x77, 0x44, 0x65, 0x66,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x27, 0x0a,
	0x0f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x71, 0x75, 0x65, 0x72, 0x79, 0x54, 0x72, 0x75,
	0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x1a, 0x67, 0x0a, 0x0b, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x41, 0x63, 0x6c, 0x12, 0x2d, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x65, 0x64, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x73, 0x1a,
	0x32, 0x0a, 0x0e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x20, 0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x22, 0x6c, 0x0a, 0x10, 0x57, 0x72, 0x69, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x1d, 0x57, 0x52, 0x49, 0x54, 0x45,
	0x5f, 0x44, 0x49, 0x53, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x57, 0x52,
	0x49, 0x54, 0x45, 0x5f, 0x45, 0x4d, 0x50, 0x54, 0x59, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x57,
	0x52, 0x49, 0x54, 0x45, 0x5f, 0x54, 0x52, 0x55, 0x4e, 0x43, 0x41, 0x54, 0x45, 0x10, 0x02, 0x12,
	0x10, 0x0a, 0x0c, 0x57, 0x52, 0x49, 0x54, 0x45, 0x5f, 0x41, 0x50, 0x50, 0x45, 0x4e, 0x44, 0x10,
	0x03, 0x22, 0x54, 0x0a, 0x0d, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x43, 0x4f, 0x50, 0x59, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08,
	0x53, 0x4e, 0x41, 0x50, 0x53, 0x48, 0x4f, 0x54, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45,
	0x53, 0x54, 0x4f, 0x52, 0x45, 0x10, 0x03, 0x22, 0x5f, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x44, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x1e,
	0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x10, 0x0a, 0x0c, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x4e, 0x45, 0x56, 0x45, 0x52,
	0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x49, 0x46, 0x5f,
	0x4e, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02, 0x22, 0x49, 0x0a, 0x08, 0x4a, 0x6f, 0x62, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x4a, 0x4f, 0x42, 0x5f, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07,
	0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x4f, 0x4e,
	0x45, 0x10, 0x03, 0x22, 0xf0, 0x04, 0x0a, 0x12, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x51, 0x55,
	0x45, 0x52, 0x59, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0a, 0x0a, 0x06, 0x53, 0x45, 0x4c, 0x45, 0x43, 0x54, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06,
	0x41, 0x53, 0x53, 0x45, 0x52, 0x54, 0x10, 0x17, 0x12, 0x0a, 0x0a, 0x06, 0x49, 0x4e, 0x53, 0x45,
	0x52, 0x54, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x03,
	0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05,
	0x4d, 0x45, 0x52, 0x47, 0x45, 0x10, 0x05, 0x12, 0x10, 0x0a, 0x0c, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x45, 0x5f, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x06, 0x12, 0x1a, 0x0a, 0x16, 0x43, 0x52, 0x45,
	0x41, 0x54, 0x45, 0x5f, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x41, 0x53, 0x5f, 0x53, 0x45, 0x4c,
	0x45, 0x43, 0x54, 0x10, 0x07, 0x12, 0x0f, 0x0a, 0x0b, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f,
	0x56, 0x49, 0x45, 0x57, 0x10, 0x08, 0x12, 0x10, 0x0a, 0x0c, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45,
	0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x10, 0x09, 0x12, 0x1c, 0x0a, 0x18, 0x43, 0x52, 0x45, 0x41,
	0x54, 0x45, 0x5f, 0x4d, 0x41, 0x54, 0x45, 0x52, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x45, 0x44, 0x5f,
	0x56, 0x49, 0x45, 0x57, 0x10, 0x0d, 0x12, 0x13, 0x0a, 0x0f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45,
	0x5f, 0x46, 0x55, 0x4e, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0e, 0x12, 0x14, 0x0a, 0x10, 0x43,
	0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x44, 0x55, 0x52, 0x45, 0x10,
	0x14, 0x12, 0x11, 0x0a, 0x0d, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x43, 0x48, 0x45,
	0x4d, 0x41, 0x10, 0x35, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x52, 0x4f, 0x50, 0x5f, 0x54, 0x41, 0x42,
	0x4c, 0x45, 0x10, 0x0a, 0x12, 0x17, 0x0a, 0x13, 0x44, 0x52, 0x4f, 0x50, 0x5f, 0x45, 0x58, 0x54,
	0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x21, 0x12, 0x0d, 0x0a,
	0x09, 0x44, 0x52, 0x4f, 0x50, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x10, 0x0b, 0x12, 0x0e, 0x0a, 0x0a,
	0x44, 0x52, 0x4f, 0x50, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x10, 0x0c, 0x12, 0x1a, 0x0a, 0x16,
	0x44, 0x52, 0x4f, 0x50, 0x5f, 0x4d, 0x41, 0x54, 0x45, 0x52, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x45,
	0x44, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x10, 0x0f, 0x12, 0x11, 0x0a, 0x0d, 0x44, 0x52, 0x4f, 0x50,
	0x5f, 0x46, 0x55, 0x4e, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x10, 0x12, 0x12, 0x0a, 0x0e, 0x44,
	0x52, 0x4f, 0x50, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x44, 0x55, 0x52, 0x45, 0x10, 0x15, 0x12,
	0x0f, 0x0a, 0x0b, 0x44, 0x52, 0x4f, 0x50, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x41, 0x10, 0x36,
	0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x10,
	0x11, 0x12, 0x0e, 0x0a, 0x0a, 0x41, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x10,
	0x12, 0x12, 0x1b, 0x0a, 0x17, 0x41, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x4d, 0x41, 0x54, 0x45, 0x52,
	0x49, 0x41, 0x4c, 0x49, 0x5a, 0x45, 0x44, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x10, 0x16, 0x12, 0x10,
	0x0a, 0x0c, 0x41, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x41, 0x10, 0x37,
	0x12, 0x0a, 0x0a, 0x06, 0x53, 0x43, 0x52, 0x49, 0x50, 0x54, 0x10, 0x13, 0x12, 0x12, 0x0a, 0x0e,
	0x54, 0x52, 0x55, 0x4e, 0x43, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x1a,
	0x12, 0x19, 0x0a, 0x15, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x52,
	0x4e, 0x41, 0x4c, 0x5f, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x1b, 0x12, 0x0f, 0x0a, 0x0b, 0x45,
	0x58, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x10, 0x1c, 0x12, 0x08, 0x0a, 0x04,
	0x43, 0x41, 0x4c, 0x4c, 0x10, 0x1d, 0x42, 0x07, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x42,
	0x9f, 0x01, 0x0a, 0x16, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x42, 0x1a, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x74, 0x3b, 0x61, 0x75, 0x64, 0x69,
	0x74, 0xa2, 0x02, 0x03, 0x47, 0x43, 0x41, 0xaa, 0x02, 0x12, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x74, 0xca, 0x02, 0x12, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x75, 0x64, 0x69,
	0x74, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescOnce sync.Once
	file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescData = file_google_cloud_audit_bigquery_audit_metadata_proto_rawDesc
)

func file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescGZIP() []byte {
	file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescOnce.Do(func() {
		file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescData)
	})
	return file_google_cloud_audit_bigquery_audit_metadata_proto_rawDescData
}

var file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes = make([]protoimpl.EnumInfo, 24)
var file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes = make([]protoimpl.MessageInfo, 42)
var file_google_cloud_audit_bigquery_audit_metadata_proto_goTypes = []interface{}{
	(BigQueryAuditMetadata_WriteDisposition)(0),           // 0: google.cloud.audit.BigQueryAuditMetadata.WriteDisposition
	(BigQueryAuditMetadata_OperationType)(0),              // 1: google.cloud.audit.BigQueryAuditMetadata.OperationType
	(BigQueryAuditMetadata_CreateDisposition)(0),          // 2: google.cloud.audit.BigQueryAuditMetadata.CreateDisposition
	(BigQueryAuditMetadata_JobState)(0),                   // 3: google.cloud.audit.BigQueryAuditMetadata.JobState
	(BigQueryAuditMetadata_QueryStatementType)(0),         // 4: google.cloud.audit.BigQueryAuditMetadata.QueryStatementType
	(BigQueryAuditMetadata_JobInsertion_Reason)(0),        // 5: google.cloud.audit.BigQueryAuditMetadata.JobInsertion.Reason
	(BigQueryAuditMetadata_DatasetCreation_Reason)(0),     // 6: google.cloud.audit.BigQueryAuditMetadata.DatasetCreation.Reason
	(BigQueryAuditMetadata_DatasetChange_Reason)(0),       // 7: google.cloud.audit.BigQueryAuditMetadata.DatasetChange.Reason
	(BigQueryAuditMetadata_DatasetDeletion_Reason)(0),     // 8: google.cloud.audit.BigQueryAuditMetadata.DatasetDeletion.Reason
	(BigQueryAuditMetadata_TableCreation_Reason)(0),       // 9: google.cloud.audit.BigQueryAuditMetadata.TableCreation.Reason
	(BigQueryAuditMetadata_ModelCreation_Reason)(0),       // 10: google.cloud.audit.BigQueryAuditMetadata.ModelCreation.Reason
	(BigQueryAuditMetadata_RoutineCreation_Reason)(0),     // 11: google.cloud.audit.BigQueryAuditMetadata.RoutineCreation.Reason
	(BigQueryAuditMetadata_TableDataRead_Reason)(0),       // 12: google.cloud.audit.BigQueryAuditMetadata.TableDataRead.Reason
	(BigQueryAuditMetadata_TableChange_Reason)(0),         // 13: google.cloud.audit.BigQueryAuditMetadata.TableChange.Reason
	(BigQueryAuditMetadata_ModelMetadataChange_Reason)(0), // 14: google.cloud.audit.BigQueryAuditMetadata.ModelMetadataChange.Reason
	(BigQueryAuditMetadata_RoutineChange_Reason)(0),       // 15: google.cloud.audit.BigQueryAuditMetadata.RoutineChange.Reason
	(BigQueryAuditMetadata_TableDataChange_Reason)(0),     // 16: google.cloud.audit.BigQueryAuditMetadata.TableDataChange.Reason
	(BigQueryAuditMetadata_ModelDataChange_Reason)(0),     // 17: google.cloud.audit.BigQueryAuditMetadata.ModelDataChange.Reason
	(BigQueryAuditMetadata_ModelDataRead_Reason)(0),       // 18: google.cloud.audit.BigQueryAuditMetadata.ModelDataRead.Reason
	(BigQueryAuditMetadata_TableDeletion_Reason)(0),       // 19: google.cloud.audit.BigQueryAuditMetadata.TableDeletion.Reason
	(BigQueryAuditMetadata_ModelDeletion_Reason)(0),       // 20: google.cloud.audit.BigQueryAuditMetadata.ModelDeletion.Reason
	(BigQueryAuditMetadata_RoutineDeletion_Reason)(0),     // 21: google.cloud.audit.BigQueryAuditMetadata.RoutineDeletion.Reason
	(BigQueryAuditMetadata_JobConfig_Type)(0),             // 22: google.cloud.audit.BigQueryAuditMetadata.JobConfig.Type
	(BigQueryAuditMetadata_JobConfig_Query_Priority)(0),   // 23: google.cloud.audit.BigQueryAuditMetadata.JobConfig.Query.Priority
	(*BigQueryAuditMetadata)(nil),                         // 24: google.cloud.audit.BigQueryAuditMetadata
	(*BigQueryAuditMetadata_JobInsertion)(nil),            // 25: google.cloud.audit.BigQueryAuditMetadata.JobInsertion
	(*BigQueryAuditMetadata_JobChange)(nil),               // 26: google.cloud.audit.BigQueryAuditMetadata.JobChange
	(*BigQueryAuditMetadata_DatasetCreation)(nil),         // 27: google.cloud.audit.BigQueryAuditMetadata.DatasetCreation
	(*BigQueryAuditMetadata_DatasetChange)(nil),           // 28: google.cloud.audit.BigQueryAuditMetadata.DatasetChange
	(*BigQueryAuditMetadata_DatasetDeletion)(nil),         // 29: google.cloud.audit.BigQueryAuditMetadata.DatasetDeletion
	(*BigQueryAuditMetadata_TableCreation)(nil),           // 30: google.cloud.audit.BigQueryAuditMetadata.TableCreation
	(*BigQueryAuditMetadata_ModelCreation)(nil),           // 31: google.cloud.audit.BigQueryAuditMetadata.ModelCreation
	(*BigQueryAuditMetadata_RoutineCreation)(nil),         // 32: google.cloud.audit.BigQueryAuditMetadata.RoutineCreation
	(*BigQueryAuditMetadata_TableDataRead)(nil),           // 33: google.cloud.audit.BigQueryAuditMetadata.TableDataRead
	(*BigQueryAuditMetadata_TableChange)(nil),             // 34: google.cloud.audit.BigQueryAuditMetadata.TableChange
	(*BigQueryAuditMetadata_ModelMetadataChange)(nil),     // 35: google.cloud.audit.BigQueryAuditMetadata.ModelMetadataChange
	(*BigQueryAuditMetadata_RoutineChange)(nil),           // 36: google.cloud.audit.BigQueryAuditMetadata.RoutineChange
	(*BigQueryAuditMetadata_TableDataChange)(nil),         // 37: google.cloud.audit.BigQueryAuditMetadata.TableDataChange
	(*BigQueryAuditMetadata_ModelDataChange)(nil),         // 38: google.cloud.audit.BigQueryAuditMetadata.ModelDataChange
	(*BigQueryAuditMetadata_ModelDataRead)(nil),           // 39: google.cloud.audit.BigQueryAuditMetadata.ModelDataRead
	(*BigQueryAuditMetadata_Dataset)(nil),                 // 40: google.cloud.audit.BigQueryAuditMetadata.Dataset
	(*BigQueryAuditMetadata_TableDeletion)(nil),           // 41: google.cloud.audit.BigQueryAuditMetadata.TableDeletion
	(*BigQueryAuditMetadata_ModelDeletion)(nil),           // 42: google.cloud.audit.BigQueryAuditMetadata.ModelDeletion
	(*BigQueryAuditMetadata_Model)(nil),                   // 43: google.cloud.audit.BigQueryAuditMetadata.Model
	(*BigQueryAuditMetadata_RoutineDeletion)(nil),         // 44: google.cloud.audit.BigQueryAuditMetadata.RoutineDeletion
	(*BigQueryAuditMetadata_Job)(nil),                     // 45: google.cloud.audit.BigQueryAuditMetadata.Job
	(*BigQueryAuditMetadata_JobConfig)(nil),               // 46: google.cloud.audit.BigQueryAuditMetadata.JobConfig
	(*BigQueryAuditMetadata_TableDefinition)(nil),         // 47: google.cloud.audit.BigQueryAuditMetadata.TableDefinition
	(*BigQueryAuditMetadata_JobStatus)(nil),               // 48: google.cloud.audit.BigQueryAuditMetadata.JobStatus
	(*BigQueryAuditMetadata_JobStats)(nil),                // 49: google.cloud.audit.BigQueryAuditMetadata.JobStats
	(*BigQueryAuditMetadata_Table)(nil),                   // 50: google.cloud.audit.BigQueryAuditMetadata.Table
	(*BigQueryAuditMetadata_Routine)(nil),                 // 51: google.cloud.audit.BigQueryAuditMetadata.Routine
	(*BigQueryAuditMetadata_EntityInfo)(nil),              // 52: google.cloud.audit.BigQueryAuditMetadata.EntityInfo
	(*BigQueryAuditMetadata_TableViewDefinition)(nil),     // 53: google.cloud.audit.BigQueryAuditMetadata.TableViewDefinition
	(*BigQueryAuditMetadata_BigQueryAcl)(nil),             // 54: google.cloud.audit.BigQueryAuditMetadata.BigQueryAcl
	(*BigQueryAuditMetadata_EncryptionInfo)(nil),          // 55: google.cloud.audit.BigQueryAuditMetadata.EncryptionInfo
	(*BigQueryAuditMetadata_JobConfig_Query)(nil),         // 56: google.cloud.audit.BigQueryAuditMetadata.JobConfig.Query
	(*BigQueryAuditMetadata_JobConfig_Load)(nil),          // 57: google.cloud.audit.BigQueryAuditMetadata.JobConfig.Load
	(*BigQueryAuditMetadata_JobConfig_Extract)(nil),       // 58: google.cloud.audit.BigQueryAuditMetadata.JobConfig.Extract
	(*BigQueryAuditMetadata_JobConfig_TableCopy)(nil),     // 59: google.cloud.audit.BigQueryAuditMetadata.JobConfig.TableCopy
	nil, // 60: google.cloud.audit.BigQueryAuditMetadata.JobConfig.LabelsEntry
	(*BigQueryAuditMetadata_JobStats_Query)(nil),                    // 61: google.cloud.audit.BigQueryAuditMetadata.JobStats.Query
	(*BigQueryAuditMetadata_JobStats_Load)(nil),                     // 62: google.cloud.audit.BigQueryAuditMetadata.JobStats.Load
	(*BigQueryAuditMetadata_JobStats_Extract)(nil),                  // 63: google.cloud.audit.BigQueryAuditMetadata.JobStats.Extract
	(*BigQueryAuditMetadata_JobStats_ReservationResourceUsage)(nil), // 64: google.cloud.audit.BigQueryAuditMetadata.JobStats.ReservationResourceUsage
	nil,                           // 65: google.cloud.audit.BigQueryAuditMetadata.EntityInfo.LabelsEntry
	(*timestamppb.Timestamp)(nil), // 66: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),   // 67: google.protobuf.Duration
	(*status.Status)(nil),         // 68: google.rpc.Status
	(*v1.Policy)(nil),             // 69: google.iam.v1.Policy
}
var file_google_cloud_audit_bigquery_audit_metadata_proto_depIdxs = []int32{
	25,  // 0: google.cloud.audit.BigQueryAuditMetadata.job_insertion:type_name -> google.cloud.audit.BigQueryAuditMetadata.JobInsertion
	26,  // 1: google.cloud.audit.BigQueryAuditMetadata.job_change:type_name -> google.cloud.audit.BigQueryAuditMetadata.JobChange
	27,  // 2: google.cloud.audit.BigQueryAuditMetadata.dataset_creation:type_name -> google.cloud.audit.BigQueryAuditMetadata.DatasetCreation
	28,  // 3: google.cloud.audit.BigQueryAuditMetadata.dataset_change:type_name -> google.cloud.audit.BigQueryAuditMetadata.DatasetChange
	29,  // 4: google.cloud.audit.BigQueryAuditMetadata.dataset_deletion:type_name -> google.cloud.audit.BigQueryAuditMetadata.DatasetDeletion
	30,  // 5: google.cloud.audit.BigQueryAuditMetadata.table_creation:type_name -> google.cloud.audit.BigQueryAuditMetadata.TableCreation
	34,  // 6: google.cloud.audit.BigQueryAuditMetadata.table_change:type_name -> google.cloud.audit.BigQueryAuditMetadata.TableChange
	41,  // 7: google.cloud.audit.BigQueryAuditMetadata.table_deletion:type_name -> google.cloud.audit.BigQueryAuditMetadata.TableDeletion
	33,  // 8: google.cloud.audit.BigQueryAuditMetadata.table_data_read:type_name -> google.cloud.audit.BigQueryAuditMetadata.TableDataRead
	37,  // 9: google.cloud.audit.BigQueryAuditMetadata.table_data_change:type_name -> google.cloud.audit.BigQueryAuditMetadata.TableDataChange
	42,  // 10: google.cloud.audit.BigQueryAuditMetadata.model_deletion:type_name -> google.cloud.audit.BigQueryAuditMetadata.ModelDeletion
	31,  // 11: google.cloud.audit.BigQueryAuditMetadata.model_creation:type_name -> google.cloud.audit.BigQueryAuditMetadata.ModelCreation
	35,  // 12: google.cloud.audit.BigQueryAuditMetadata.model_metadata_change:type_name -> google.cloud.audit.BigQueryAuditMetadata.ModelMetadataChange
	38,  // 13: google.cloud.audit.BigQueryAuditMetadata.model_data_change:type_name -> google.cloud.audit.BigQueryAuditMetadata.ModelDataChange
	39,  // 14: google.cloud.audit.BigQueryAuditMetadata.model_data_read:type_name -> google.cloud.audit.BigQueryAuditMetadata.ModelDataRead
	32,  // 15: google.cloud.audit.BigQueryAuditMetadata.routine_creation:type_name -> google.cloud.audit.BigQueryAuditMetadata.RoutineCreation
	36,  // 16: google.cloud.audit.BigQueryAuditMetadata.routine_change:type_name -> google.cloud.audit.BigQueryAuditMetadata.RoutineChange
	44,  // 17: google.cloud.audit.BigQueryAuditMetadata.routine_deletion:type_name -> google.cloud.audit.BigQueryAuditMetadata.RoutineDeletion
	45,  // 18: google.cloud.audit.BigQueryAuditMetadata.JobInsertion.job:type_name -> google.cloud.audit.BigQueryAuditMetadata.Job
	5,   // 19: google.cloud.audit.BigQueryAuditMetadata.JobInsertion.reason:type_name -> google.cloud.audit.BigQueryAuditMetadata.JobInsertion.Reason
	3,   // 20: google.cloud.audit.BigQueryAuditMetadata.JobChange.before:type_name -> google.cloud.audit.BigQueryAuditMetadata.JobState
	3,   // 21: google.cloud.audit.BigQueryAuditMetadata.JobChange.after:type_name -> google.cloud.audit.BigQueryAuditMetadata.JobState
	45,  // 22: google.cloud.audit.BigQueryAuditMetadata.JobChange.job:type_name -> google.cloud.audit.BigQueryAuditMetadata.Job
	40,  // 23: google.cloud.audit.BigQueryAuditMetadata.DatasetCreation.dataset:type_name -> google.cloud.audit.BigQueryAuditMetadata.Dataset
	6,   // 24: google.cloud.audit.BigQueryAuditMetadata.DatasetCreation.reason:type_name -> google.cloud.audit.BigQueryAuditMetadata.DatasetCreation.Reason
	40,  // 25: google.cloud.audit.BigQueryAuditMetadata.DatasetChange.dataset:type_name -> google.cloud.audit.BigQueryAuditMetadata.Dataset
	7,   // 26: google.cloud.audit.BigQueryAuditMetadata.DatasetChange.reason:type_name -> google.cloud.audit.BigQueryAuditMetadata.DatasetChange.Reason
	8,   // 27: google.cloud.audit.BigQueryAuditMetadata.DatasetDeletion.reason:type_name -> google.cloud.audit.BigQueryAuditMetadata.DatasetDeletion.Reason
	50,  // 28: google.cloud.audit.BigQueryAuditMetadata.TableCreation.table:type_name -> google.cloud.audit.BigQueryAuditMetadata.Table
	9,   // 29: google.cloud.audit.BigQueryAuditMetadata.TableCreation.reason:type_name -> google.cloud.audit.BigQueryAuditMetadata.TableCreation.Reason
	43,  // 30: google.cloud.audit.BigQueryAuditMetadata.ModelCreation.model:type_name -> google.cloud.audit.BigQueryAuditMetadata.Model
	10,  // 31: google.cloud.audit.BigQueryAuditMetadata.ModelCreation.reason:type_name -> google.cloud.audit.BigQueryAuditMetadata.ModelCreation.Reason
	51,  // 32: google.cloud.audit.BigQueryAuditMetadata.RoutineCreation.routine:type_name -> google.cloud.audit.BigQueryAuditMetadata.Routine
	11,  // 33: google.cloud.audit.BigQueryAuditMetadata.RoutineCreation.reason:type_name -> google.cloud.audit.BigQueryAuditMetadata.RoutineCreation.Reason
	12,  // 34: google.cloud.audit.BigQueryAuditMetadata.TableDataRead.reason:type_name -> google.cloud.audit.BigQueryAuditMetadata.TableDataRead.Reason
	50,  // 35: google.cloud.audit.BigQueryAuditMetadata.TableChange.table:type_name -> google.cloud.audit.BigQueryAuditMetadata.Table
	13,  // 36: google.cloud.audit.BigQueryAuditMetadata.TableChange.reason:type_name -> google.cloud.audit.BigQueryAuditMetadata.TableChange.Reason
	43,  // 37: google.cloud.audit.BigQueryAuditMetadata.ModelMetadataChange.model:type_name -> google.cloud.audit.BigQueryAuditMetadata.Model
	14,  // 38: google.cloud.audit.BigQueryAuditMetadata.ModelMetadataChange.reason:type_name -> google.cloud.audit.BigQueryAuditMetadata.ModelMetadataChange.Reason
	51,  // 39: google.cloud.audit.BigQueryAuditMetadata.RoutineChange.routine:type_name -> google.cloud.audit.BigQueryAuditMetadata.Routine
	15,  // 40: google.cloud.audit.BigQueryAuditMetadata.RoutineChange.reason:type_name -> google.cloud.audit.BigQueryAuditMetadata.RoutineChange.Reason
	16,  // 41: google.cloud.audit.BigQueryAuditMetadata.TableDataChange.reason:type_name -> google.cloud.audit.BigQueryAuditMetadata.TableDataChange.Reason
	17,  // 42: google.cloud.audit.BigQueryAuditMetadata.ModelDataChange.reason:type_name -> google.cloud.audit.BigQueryAuditMetadata.ModelDataChange.Reason
	18,  // 43: google.cloud.audit.BigQueryAuditMetadata.ModelDataRead.reason:type_name -> google.cloud.audit.BigQueryAuditMetadata.ModelDataRead.Reason
	66,  // 44: google.cloud.audit.BigQueryAuditMetadata.Dataset.create_time:type_name -> google.protobuf.Timestamp
	66,  // 45: google.cloud.audit.BigQueryAuditMetadata.Dataset.update_time:type_name -> google.protobuf.Timestamp
	54,  // 46: google.cloud.audit.BigQueryAuditMetadata.Dataset.acl:type_name -> google.cloud.audit.BigQueryAuditMetadata.BigQueryAcl
	67,  // 47: google.cloud.audit.BigQueryAuditMetadata.Dataset.default_table_expire_duration:type_name -> google.protobuf.Duration
	52,  // 48: google.cloud.audit.BigQueryAuditMetadata.Dataset.dataset_info:type_name -> google.cloud.audit.BigQueryAuditMetadata.EntityInfo
	55,  // 49: google.cloud.audit.BigQueryAuditMetadata.Dataset.default_encryption:type_name -> google.cloud.audit.BigQueryAuditMetadata.EncryptionInfo
	19,  // 50: google.cloud.audit.BigQueryAuditMetadata.TableDeletion.reason:type_name -> google.cloud.audit.BigQueryAuditMetadata.TableDeletion.Reason
	20,  // 51: google.cloud.audit.BigQueryAuditMetadata.ModelDeletion.reason:type_name -> google.cloud.audit.BigQueryAuditMetadata.ModelDeletion.Reason
	52,  // 52: google.cloud.audit.BigQueryAuditMetadata.Model.model_info:type_name -> google.cloud.audit.BigQueryAuditMetadata.EntityInfo
	66,  // 53: google.cloud.audit.BigQueryAuditMetadata.Model.expire_time:type_name -> google.protobuf.Timestamp
	66,  // 54: google.cloud.audit.BigQueryAuditMetadata.Model.create_time:type_name -> google.protobuf.Timestamp
	66,  // 55: google.cloud.audit.BigQueryAuditMetadata.Model.update_time:type_name -> google.protobuf.Timestamp
	55,  // 56: google.cloud.audit.BigQueryAuditMetadata.Model.encryption:type_name -> google.cloud.audit.BigQueryAuditMetadata.EncryptionInfo
	51,  // 57: google.cloud.audit.BigQueryAuditMetadata.RoutineDeletion.routine:type_name -> google.cloud.audit.BigQueryAuditMetadata.Routine
	21,  // 58: google.cloud.audit.BigQueryAuditMetadata.RoutineDeletion.reason:type_name -> google.cloud.audit.BigQueryAuditMetadata.RoutineDeletion.Reason
	46,  // 59: google.cloud.audit.BigQueryAuditMetadata.Job.job_config:type_name -> google.cloud.audit.BigQueryAuditMetadata.JobConfig
	48,  // 60: google.cloud.audit.BigQueryAuditMetadata.Job.job_status:type_name -> google.cloud.audit.BigQueryAuditMetadata.JobStatus
	49,  // 61: google.cloud.audit.BigQueryAuditMetadata.Job.job_stats:type_name -> google.cloud.audit.BigQueryAuditMetadata.JobStats
	22,  // 62: google.cloud.audit.BigQueryAuditMetadata.JobConfig.type:type_name -> google.cloud.audit.BigQueryAuditMetadata.JobConfig.Type
	56,  // 63: google.cloud.audit.BigQueryAuditMetadata.JobConfig.query_config:type_name -> google.cloud.audit.BigQueryAuditMetadata.JobConfig.Query
	57,  // 64: google.cloud.audit.BigQueryAuditMetadata.JobConfig.load_config:type_name -> google.cloud.audit.BigQueryAuditMetadata.JobConfig.Load
	58,  // 65: google.cloud.audit.BigQueryAuditMetadata.JobConfig.extract_config:type_name -> google.cloud.audit.BigQueryAuditMetadata.JobConfig.Extract
	59,  // 66: google.cloud.audit.BigQueryAuditMetadata.JobConfig.table_copy_config:type_name -> google.cloud.audit.BigQueryAuditMetadata.JobConfig.TableCopy
	60,  // 67: google.cloud.audit.BigQueryAuditMetadata.JobConfig.labels:type_name -> google.cloud.audit.BigQueryAuditMetadata.JobConfig.LabelsEntry
	3,   // 68: google.cloud.audit.BigQueryAuditMetadata.JobStatus.job_state:type_name -> google.cloud.audit.BigQueryAuditMetadata.JobState
	68,  // 69: google.cloud.audit.BigQueryAuditMetadata.JobStatus.error_result:type_name -> google.rpc.Status
	68,  // 70: google.cloud.audit.BigQueryAuditMetadata.JobStatus.errors:type_name -> google.rpc.Status
	66,  // 71: google.cloud.audit.BigQueryAuditMetadata.JobStats.create_time:type_name -> google.protobuf.Timestamp
	66,  // 72: google.cloud.audit.BigQueryAuditMetadata.JobStats.start_time:type_name -> google.protobuf.Timestamp
	66,  // 73: google.cloud.audit.BigQueryAuditMetadata.JobStats.end_time:type_name -> google.protobuf.Timestamp
	61,  // 74: google.cloud.audit.BigQueryAuditMetadata.JobStats.query_stats:type_name -> google.cloud.audit.BigQueryAuditMetadata.JobStats.Query
	62,  // 75: google.cloud.audit.BigQueryAuditMetadata.JobStats.load_stats:type_name -> google.cloud.audit.BigQueryAuditMetadata.JobStats.Load
	63,  // 76: google.cloud.audit.BigQueryAuditMetadata.JobStats.extract_stats:type_name -> google.cloud.audit.BigQueryAuditMetadata.JobStats.Extract
	64,  // 77: google.cloud.audit.BigQueryAuditMetadata.JobStats.reservation_usage:type_name -> google.cloud.audit.BigQueryAuditMetadata.JobStats.ReservationResourceUsage
	53,  // 78: google.cloud.audit.BigQueryAuditMetadata.Table.view:type_name -> google.cloud.audit.BigQueryAuditMetadata.TableViewDefinition
	66,  // 79: google.cloud.audit.BigQueryAuditMetadata.Table.expire_time:type_name -> google.protobuf.Timestamp
	66,  // 80: google.cloud.audit.BigQueryAuditMetadata.Table.create_time:type_name -> google.protobuf.Timestamp
	66,  // 81: google.cloud.audit.BigQueryAuditMetadata.Table.update_time:type_name -> google.protobuf.Timestamp
	66,  // 82: google.cloud.audit.BigQueryAuditMetadata.Table.truncate_time:type_name -> google.protobuf.Timestamp
	55,  // 83: google.cloud.audit.BigQueryAuditMetadata.Table.encryption:type_name -> google.cloud.audit.BigQueryAuditMetadata.EncryptionInfo
	52,  // 84: google.cloud.audit.BigQueryAuditMetadata.Table.table_info:type_name -> google.cloud.audit.BigQueryAuditMetadata.EntityInfo
	66,  // 85: google.cloud.audit.BigQueryAuditMetadata.Routine.create_time:type_name -> google.protobuf.Timestamp
	66,  // 86: google.cloud.audit.BigQueryAuditMetadata.Routine.update_time:type_name -> google.protobuf.Timestamp
	65,  // 87: google.cloud.audit.BigQueryAuditMetadata.EntityInfo.labels:type_name -> google.cloud.audit.BigQueryAuditMetadata.EntityInfo.LabelsEntry
	69,  // 88: google.cloud.audit.BigQueryAuditMetadata.BigQueryAcl.policy:type_name -> google.iam.v1.Policy
	2,   // 89: google.cloud.audit.BigQueryAuditMetadata.JobConfig.Query.create_disposition:type_name -> google.cloud.audit.BigQueryAuditMetadata.CreateDisposition
	0,   // 90: google.cloud.audit.BigQueryAuditMetadata.JobConfig.Query.write_disposition:type_name -> google.cloud.audit.BigQueryAuditMetadata.WriteDisposition
	47,  // 91: google.cloud.audit.BigQueryAuditMetadata.JobConfig.Query.table_definitions:type_name -> google.cloud.audit.BigQueryAuditMetadata.TableDefinition
	23,  // 92: google.cloud.audit.BigQueryAuditMetadata.JobConfig.Query.priority:type_name -> google.cloud.audit.BigQueryAuditMetadata.JobConfig.Query.Priority
	55,  // 93: google.cloud.audit.BigQueryAuditMetadata.JobConfig.Query.destination_table_encryption:type_name -> google.cloud.audit.BigQueryAuditMetadata.EncryptionInfo
	4,   // 94: google.cloud.audit.BigQueryAuditMetadata.JobConfig.Query.statement_type:type_name -> google.cloud.audit.BigQueryAuditMetadata.QueryStatementType
	2,   // 95: google.cloud.audit.BigQueryAuditMetadata.JobConfig.Load.create_disposition:type_name -> google.cloud.audit.BigQueryAuditMetadata.CreateDisposition
	0,   // 96: google.cloud.audit.BigQueryAuditMetadata.JobConfig.Load.write_disposition:type_name -> google.cloud.audit.BigQueryAuditMetadata.WriteDisposition
	55,  // 97: google.cloud.audit.BigQueryAuditMetadata.JobConfig.Load.destination_table_encryption:type_name -> google.cloud.audit.BigQueryAuditMetadata.EncryptionInfo
	2,   // 98: google.cloud.audit.BigQueryAuditMetadata.JobConfig.TableCopy.create_disposition:type_name -> google.cloud.audit.BigQueryAuditMetadata.CreateDisposition
	0,   // 99: google.cloud.audit.BigQueryAuditMetadata.JobConfig.TableCopy.write_disposition:type_name -> google.cloud.audit.BigQueryAuditMetadata.WriteDisposition
	55,  // 100: google.cloud.audit.BigQueryAuditMetadata.JobConfig.TableCopy.destination_table_encryption:type_name -> google.cloud.audit.BigQueryAuditMetadata.EncryptionInfo
	1,   // 101: google.cloud.audit.BigQueryAuditMetadata.JobConfig.TableCopy.operation_type:type_name -> google.cloud.audit.BigQueryAuditMetadata.OperationType
	66,  // 102: google.cloud.audit.BigQueryAuditMetadata.JobConfig.TableCopy.destination_expiration_time:type_name -> google.protobuf.Timestamp
	103, // [103:103] is the sub-list for method output_type
	103, // [103:103] is the sub-list for method input_type
	103, // [103:103] is the sub-list for extension type_name
	103, // [103:103] is the sub-list for extension extendee
	0,   // [0:103] is the sub-list for field type_name
}

func init() { file_google_cloud_audit_bigquery_audit_metadata_proto_init() }
func file_google_cloud_audit_bigquery_audit_metadata_proto_init() {
	if File_google_cloud_audit_bigquery_audit_metadata_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_JobInsertion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_JobChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_DatasetCreation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_DatasetChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_DatasetDeletion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_TableCreation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_ModelCreation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_RoutineCreation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_TableDataRead); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_TableChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_ModelMetadataChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_RoutineChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_TableDataChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_ModelDataChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_ModelDataRead); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_Dataset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_TableDeletion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_ModelDeletion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_Model); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_RoutineDeletion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_Job); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_JobConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_TableDefinition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_JobStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_JobStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_Table); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_Routine); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_EntityInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_TableViewDefinition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_BigQueryAcl); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_EncryptionInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_JobConfig_Query); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_JobConfig_Load); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_JobConfig_Extract); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_JobConfig_TableCopy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_JobStats_Query); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_JobStats_Load); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_JobStats_Extract); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAuditMetadata_JobStats_ReservationResourceUsage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*BigQueryAuditMetadata_JobInsertion_)(nil),
		(*BigQueryAuditMetadata_JobChange_)(nil),
		(*BigQueryAuditMetadata_DatasetCreation_)(nil),
		(*BigQueryAuditMetadata_DatasetChange_)(nil),
		(*BigQueryAuditMetadata_DatasetDeletion_)(nil),
		(*BigQueryAuditMetadata_TableCreation_)(nil),
		(*BigQueryAuditMetadata_TableChange_)(nil),
		(*BigQueryAuditMetadata_TableDeletion_)(nil),
		(*BigQueryAuditMetadata_TableDataRead_)(nil),
		(*BigQueryAuditMetadata_TableDataChange_)(nil),
		(*BigQueryAuditMetadata_ModelDeletion_)(nil),
		(*BigQueryAuditMetadata_ModelCreation_)(nil),
		(*BigQueryAuditMetadata_ModelMetadataChange_)(nil),
		(*BigQueryAuditMetadata_ModelDataChange_)(nil),
		(*BigQueryAuditMetadata_ModelDataRead_)(nil),
		(*BigQueryAuditMetadata_RoutineCreation_)(nil),
		(*BigQueryAuditMetadata_RoutineChange_)(nil),
		(*BigQueryAuditMetadata_RoutineDeletion_)(nil),
	}
	file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[22].OneofWrappers = []interface{}{
		(*BigQueryAuditMetadata_JobConfig_QueryConfig)(nil),
		(*BigQueryAuditMetadata_JobConfig_LoadConfig)(nil),
		(*BigQueryAuditMetadata_JobConfig_ExtractConfig)(nil),
		(*BigQueryAuditMetadata_JobConfig_TableCopyConfig)(nil),
	}
	file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[25].OneofWrappers = []interface{}{
		(*BigQueryAuditMetadata_JobStats_QueryStats)(nil),
		(*BigQueryAuditMetadata_JobStats_LoadStats)(nil),
		(*BigQueryAuditMetadata_JobStats_ExtractStats)(nil),
	}
	file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes[34].OneofWrappers = []interface{}{
		(*BigQueryAuditMetadata_JobConfig_Extract_SourceTable)(nil),
		(*BigQueryAuditMetadata_JobConfig_Extract_SourceModel)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_audit_bigquery_audit_metadata_proto_rawDesc,
			NumEnums:      24,
			NumMessages:   42,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_audit_bigquery_audit_metadata_proto_goTypes,
		DependencyIndexes: file_google_cloud_audit_bigquery_audit_metadata_proto_depIdxs,
		EnumInfos:         file_google_cloud_audit_bigquery_audit_metadata_proto_enumTypes,
		MessageInfos:      file_google_cloud_audit_bigquery_audit_metadata_proto_msgTypes,
	}.Build()
	File_google_cloud_audit_bigquery_audit_metadata_proto = out.File
	file_google_cloud_audit_bigquery_audit_metadata_proto_rawDesc = nil
	file_google_cloud_audit_bigquery_audit_metadata_proto_goTypes = nil
	file_google_cloud_audit_bigquery_audit_metadata_proto_depIdxs = nil
}
