// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.12.3
// source: google/devtools/remoteworkers/v1test2/command.proto

package remoteworkers

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Describes a shell-style task to execute, suitable for providing as the Bots
// interface's `Lease.payload` field.
type CommandTask struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The inputs to the task.
	Inputs *CommandTask_Inputs `protobuf:"bytes,1,opt,name=inputs,proto3" json:"inputs,omitempty"`
	// The expected outputs from the task.
	ExpectedOutputs *CommandTask_Outputs `protobuf:"bytes,4,opt,name=expected_outputs,json=expectedOutputs,proto3" json:"expected_outputs,omitempty"`
	// The timeouts of this task.
	Timeouts *CommandTask_Timeouts `protobuf:"bytes,5,opt,name=timeouts,proto3" json:"timeouts,omitempty"`
}

func (x *CommandTask) Reset() {
	*x = CommandTask{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandTask) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandTask) ProtoMessage() {}

func (x *CommandTask) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandTask.ProtoReflect.Descriptor instead.
func (*CommandTask) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_command_proto_rawDescGZIP(), []int{0}
}

func (x *CommandTask) GetInputs() *CommandTask_Inputs {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *CommandTask) GetExpectedOutputs() *CommandTask_Outputs {
	if x != nil {
		return x.ExpectedOutputs
	}
	return nil
}

func (x *CommandTask) GetTimeouts() *CommandTask_Timeouts {
	if x != nil {
		return x.Timeouts
	}
	return nil
}

// DEPRECATED - use CommandResult instead.
// Describes the actual outputs from the task.
type CommandOutputs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// exit_code is only fully reliable if the status' code is OK. If the task
	// exceeded its deadline or was cancelled, the process may still produce an
	// exit code as it is cancelled, and this will be populated, but a successful
	// (zero) is unlikely to be correct unless the status code is OK.
	ExitCode int32 `protobuf:"varint,1,opt,name=exit_code,json=exitCode,proto3" json:"exit_code,omitempty"`
	// The output files. The blob referenced by the digest should contain
	// one of the following (implementation-dependent):
	//    * A marshalled DirectoryMetadata of the returned filesystem
	//    * A LUCI-style .isolated file
	Outputs *Digest `protobuf:"bytes,2,opt,name=outputs,proto3" json:"outputs,omitempty"`
}

func (x *CommandOutputs) Reset() {
	*x = CommandOutputs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandOutputs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandOutputs) ProtoMessage() {}

func (x *CommandOutputs) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandOutputs.ProtoReflect.Descriptor instead.
func (*CommandOutputs) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_command_proto_rawDescGZIP(), []int{1}
}

func (x *CommandOutputs) GetExitCode() int32 {
	if x != nil {
		return x.ExitCode
	}
	return 0
}

func (x *CommandOutputs) GetOutputs() *Digest {
	if x != nil {
		return x.Outputs
	}
	return nil
}

// DEPRECATED - use CommandResult instead.
// Can be used as part of CompleteRequest.metadata, or are part of a more
// sophisticated message.
type CommandOverhead struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The elapsed time between calling Accept and Complete. The server will also
	// have its own idea of what this should be, but this excludes the overhead of
	// the RPCs and the bot response time.
	Duration *durationpb.Duration `protobuf:"bytes,1,opt,name=duration,proto3" json:"duration,omitempty"`
	// The amount of time *not* spent executing the command (ie
	// uploading/downloading files).
	Overhead *durationpb.Duration `protobuf:"bytes,2,opt,name=overhead,proto3" json:"overhead,omitempty"`
}

func (x *CommandOverhead) Reset() {
	*x = CommandOverhead{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandOverhead) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandOverhead) ProtoMessage() {}

func (x *CommandOverhead) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandOverhead.ProtoReflect.Descriptor instead.
func (*CommandOverhead) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_command_proto_rawDescGZIP(), []int{2}
}

func (x *CommandOverhead) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *CommandOverhead) GetOverhead() *durationpb.Duration {
	if x != nil {
		return x.Overhead
	}
	return nil
}

// All information about the execution of a command, suitable for providing as
// the Bots interface's `Lease.result` field.
type CommandResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An overall status for the command. For example, if the command timed out,
	// this might have a code of DEADLINE_EXCEEDED; if it was killed by the OS for
	// memory exhaustion, it might have a code of RESOURCE_EXHAUSTED.
	Status *status.Status `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// The exit code of the process. An exit code of "0" should only be trusted if
	// `status` has a code of OK (otherwise it may simply be unset).
	ExitCode int32 `protobuf:"varint,2,opt,name=exit_code,json=exitCode,proto3" json:"exit_code,omitempty"`
	// The output files. The blob referenced by the digest should contain
	// one of the following (implementation-dependent):
	//    * A marshalled DirectoryMetadata of the returned filesystem
	//    * A LUCI-style .isolated file
	Outputs *Digest `protobuf:"bytes,3,opt,name=outputs,proto3" json:"outputs,omitempty"`
	// The elapsed time between calling Accept and Complete. The server will also
	// have its own idea of what this should be, but this excludes the overhead of
	// the RPCs and the bot response time.
	//
	// Deprecated: Do not use.
	Duration *durationpb.Duration `protobuf:"bytes,4,opt,name=duration,proto3" json:"duration,omitempty"`
	// The amount of time *not* spent executing the command (ie
	// uploading/downloading files).
	//
	// Deprecated: Do not use.
	Overhead *durationpb.Duration `protobuf:"bytes,5,opt,name=overhead,proto3" json:"overhead,omitempty"`
	// Implementation-dependent metadata about the task. Both servers and bots
	// may define messages which can be encoded here; bots are free to provide
	// metadata in multiple formats, and servers are free to choose one or more
	// of the values to process and ignore others. In particular, it is *not*
	// considered an error for the bot to provide the server with a field that it
	// doesn't know about.
	Metadata []*anypb.Any `protobuf:"bytes,6,rep,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *CommandResult) Reset() {
	*x = CommandResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandResult) ProtoMessage() {}

func (x *CommandResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandResult.ProtoReflect.Descriptor instead.
func (*CommandResult) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_command_proto_rawDescGZIP(), []int{3}
}

func (x *CommandResult) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *CommandResult) GetExitCode() int32 {
	if x != nil {
		return x.ExitCode
	}
	return 0
}

func (x *CommandResult) GetOutputs() *Digest {
	if x != nil {
		return x.Outputs
	}
	return nil
}

// Deprecated: Do not use.
func (x *CommandResult) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

// Deprecated: Do not use.
func (x *CommandResult) GetOverhead() *durationpb.Duration {
	if x != nil {
		return x.Overhead
	}
	return nil
}

func (x *CommandResult) GetMetadata() []*anypb.Any {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// The metadata for a file. Similar to the equivalent message in the Remote
// Execution API.
type FileMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The path of this file. If this message is part of the
	// CommandOutputs.outputs fields, the path is relative to the execution root
	// and must correspond to an entry in CommandTask.outputs.files. If this
	// message is part of a Directory message, then the path is relative to the
	// root of that directory. All paths MUST be delimited by forward slashes.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// A pointer to the contents of the file. The method by which a client
	// retrieves the contents from a CAS system is not defined here.
	Digest *Digest `protobuf:"bytes,2,opt,name=digest,proto3" json:"digest,omitempty"`
	// If the file is small enough, its contents may also or alternatively be
	// listed here.
	Contents []byte `protobuf:"bytes,3,opt,name=contents,proto3" json:"contents,omitempty"`
	// Properties of the file
	IsExecutable bool `protobuf:"varint,4,opt,name=is_executable,json=isExecutable,proto3" json:"is_executable,omitempty"`
}

func (x *FileMetadata) Reset() {
	*x = FileMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FileMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileMetadata) ProtoMessage() {}

func (x *FileMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileMetadata.ProtoReflect.Descriptor instead.
func (*FileMetadata) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_command_proto_rawDescGZIP(), []int{4}
}

func (x *FileMetadata) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *FileMetadata) GetDigest() *Digest {
	if x != nil {
		return x.Digest
	}
	return nil
}

func (x *FileMetadata) GetContents() []byte {
	if x != nil {
		return x.Contents
	}
	return nil
}

func (x *FileMetadata) GetIsExecutable() bool {
	if x != nil {
		return x.IsExecutable
	}
	return false
}

// The metadata for a directory. Similar to the equivalent message in the Remote
// Execution API.
type DirectoryMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The path of the directory, as in [FileMetadata.path][google.devtools.remoteworkers.v1test2.FileMetadata.path].
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// A pointer to the contents of the directory, in the form of a marshalled
	// Directory message.
	Digest *Digest `protobuf:"bytes,2,opt,name=digest,proto3" json:"digest,omitempty"`
}

func (x *DirectoryMetadata) Reset() {
	*x = DirectoryMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DirectoryMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DirectoryMetadata) ProtoMessage() {}

func (x *DirectoryMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DirectoryMetadata.ProtoReflect.Descriptor instead.
func (*DirectoryMetadata) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_command_proto_rawDescGZIP(), []int{5}
}

func (x *DirectoryMetadata) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *DirectoryMetadata) GetDigest() *Digest {
	if x != nil {
		return x.Digest
	}
	return nil
}

// The CommandTask and CommandResult messages assume the existence of a service
// that can serve blobs of content, identified by a hash and size known as a
// "digest." The method by which these blobs may be retrieved is not specified
// here, but a model implementation is in the Remote Execution API's
// "ContentAddressibleStorage" interface.
//
// In the context of the RWAPI, a Digest will virtually always refer to the
// contents of a file or a directory. The latter is represented by the
// byte-encoded Directory message.
type Digest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A string-encoded hash (eg "1a2b3c", not the byte array [0x1a, 0x2b, 0x3c])
	// using an implementation-defined hash algorithm (eg SHA-256).
	Hash string `protobuf:"bytes,1,opt,name=hash,proto3" json:"hash,omitempty"`
	// The size of the contents. While this is not strictly required as part of an
	// identifier (after all, any given hash will have exactly one canonical
	// size), it's useful in almost all cases when one might want to send or
	// retrieve blobs of content and is included here for this reason.
	SizeBytes int64 `protobuf:"varint,2,opt,name=size_bytes,json=sizeBytes,proto3" json:"size_bytes,omitempty"`
}

func (x *Digest) Reset() {
	*x = Digest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Digest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Digest) ProtoMessage() {}

func (x *Digest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Digest.ProtoReflect.Descriptor instead.
func (*Digest) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_command_proto_rawDescGZIP(), []int{6}
}

func (x *Digest) GetHash() string {
	if x != nil {
		return x.Hash
	}
	return ""
}

func (x *Digest) GetSizeBytes() int64 {
	if x != nil {
		return x.SizeBytes
	}
	return 0
}

// Describes a blob of binary content with its digest.
type Blob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The digest of the blob. This should be verified by the receiver.
	Digest *Digest `protobuf:"bytes,1,opt,name=digest,proto3" json:"digest,omitempty"`
	// The contents of the blob.
	Contents []byte `protobuf:"bytes,2,opt,name=contents,proto3" json:"contents,omitempty"`
}

func (x *Blob) Reset() {
	*x = Blob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Blob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Blob) ProtoMessage() {}

func (x *Blob) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Blob.ProtoReflect.Descriptor instead.
func (*Blob) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_command_proto_rawDescGZIP(), []int{7}
}

func (x *Blob) GetDigest() *Digest {
	if x != nil {
		return x.Digest
	}
	return nil
}

func (x *Blob) GetContents() []byte {
	if x != nil {
		return x.Contents
	}
	return nil
}

// The contents of a directory. Similar to the equivalent message in the Remote
// Execution API.
type Directory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The files in this directory
	Files []*FileMetadata `protobuf:"bytes,1,rep,name=files,proto3" json:"files,omitempty"`
	// Any subdirectories
	Directories []*DirectoryMetadata `protobuf:"bytes,2,rep,name=directories,proto3" json:"directories,omitempty"`
}

func (x *Directory) Reset() {
	*x = Directory{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Directory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Directory) ProtoMessage() {}

func (x *Directory) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Directory.ProtoReflect.Descriptor instead.
func (*Directory) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_command_proto_rawDescGZIP(), []int{8}
}

func (x *Directory) GetFiles() []*FileMetadata {
	if x != nil {
		return x.Files
	}
	return nil
}

func (x *Directory) GetDirectories() []*DirectoryMetadata {
	if x != nil {
		return x.Directories
	}
	return nil
}

// Describes the inputs to a shell-style task.
type CommandTask_Inputs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The command itself to run (e.g., argv).
	//
	// This field should be passed directly to the underlying operating system,
	// and so it must be sensible to that operating system. For example, on
	// Windows, the first argument might be "C:\Windows\System32\ping.exe" -
	// that is, using drive letters and backslashes. A command for a *nix
	// system, on the other hand, would use forward slashes.
	//
	// All other fields in the RWAPI must consistently use forward slashes,
	// since those fields may be interpretted by both the service and the bot.
	Arguments []string `protobuf:"bytes,1,rep,name=arguments,proto3" json:"arguments,omitempty"`
	// The input filesystem to be set up prior to the task beginning. The
	// contents should be a repeated set of FileMetadata messages though other
	// formats are allowed if better for the implementation (eg, a LUCI-style
	// .isolated file).
	//
	// This field is repeated since implementations might want to cache the
	// metadata, in which case it may be useful to break up portions of the
	// filesystem that change frequently (eg, specific input files) from those
	// that don't (eg, standard header files).
	Files []*Digest `protobuf:"bytes,2,rep,name=files,proto3" json:"files,omitempty"`
	// Inline contents for blobs expected to be needed by the bot to execute the
	// task. For example, contents of entries in `files` or blobs that are
	// indirectly referenced by an entry there.
	//
	// The bot should check against this list before downloading required task
	// inputs to reduce the number of communications between itself and the
	// remote CAS server.
	InlineBlobs []*Blob `protobuf:"bytes,4,rep,name=inline_blobs,json=inlineBlobs,proto3" json:"inline_blobs,omitempty"`
	// All environment variables required by the task.
	EnvironmentVariables []*CommandTask_Inputs_EnvironmentVariable `protobuf:"bytes,3,rep,name=environment_variables,json=environmentVariables,proto3" json:"environment_variables,omitempty"`
	// Directory from which a command is executed. It is a relative directory
	// with respect to the bot's working directory (i.e., "./"). If it is
	// non-empty, then it must exist under "./". Otherwise, "./" will be used.
	WorkingDirectory string `protobuf:"bytes,5,opt,name=working_directory,json=workingDirectory,proto3" json:"working_directory,omitempty"`
}

func (x *CommandTask_Inputs) Reset() {
	*x = CommandTask_Inputs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandTask_Inputs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandTask_Inputs) ProtoMessage() {}

func (x *CommandTask_Inputs) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandTask_Inputs.ProtoReflect.Descriptor instead.
func (*CommandTask_Inputs) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_command_proto_rawDescGZIP(), []int{0, 0}
}

func (x *CommandTask_Inputs) GetArguments() []string {
	if x != nil {
		return x.Arguments
	}
	return nil
}

func (x *CommandTask_Inputs) GetFiles() []*Digest {
	if x != nil {
		return x.Files
	}
	return nil
}

func (x *CommandTask_Inputs) GetInlineBlobs() []*Blob {
	if x != nil {
		return x.InlineBlobs
	}
	return nil
}

func (x *CommandTask_Inputs) GetEnvironmentVariables() []*CommandTask_Inputs_EnvironmentVariable {
	if x != nil {
		return x.EnvironmentVariables
	}
	return nil
}

func (x *CommandTask_Inputs) GetWorkingDirectory() string {
	if x != nil {
		return x.WorkingDirectory
	}
	return ""
}

// Describes the expected outputs of the command.
type CommandTask_Outputs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of expected files, relative to the execution root. All paths
	// MUST be delimited by forward slashes.
	Files []string `protobuf:"bytes,1,rep,name=files,proto3" json:"files,omitempty"`
	// A list of expected directories, relative to the execution root. All paths
	// MUST be delimited by forward slashes.
	Directories []string `protobuf:"bytes,2,rep,name=directories,proto3" json:"directories,omitempty"`
	// The destination to which any stdout should be sent. The method by which
	// the bot should send the stream contents to that destination is not
	// defined in this API. As examples, the destination could be a file
	// referenced in the `files` field in this message, or it could be a URI
	// that must be written via the ByteStream API.
	StdoutDestination string `protobuf:"bytes,3,opt,name=stdout_destination,json=stdoutDestination,proto3" json:"stdout_destination,omitempty"`
	// The destination to which any stderr should be sent. The method by which
	// the bot should send the stream contents to that destination is not
	// defined in this API. As examples, the destination could be a file
	// referenced in the `files` field in this message, or it could be a URI
	// that must be written via the ByteStream API.
	StderrDestination string `protobuf:"bytes,4,opt,name=stderr_destination,json=stderrDestination,proto3" json:"stderr_destination,omitempty"`
}

func (x *CommandTask_Outputs) Reset() {
	*x = CommandTask_Outputs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandTask_Outputs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandTask_Outputs) ProtoMessage() {}

func (x *CommandTask_Outputs) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandTask_Outputs.ProtoReflect.Descriptor instead.
func (*CommandTask_Outputs) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_command_proto_rawDescGZIP(), []int{0, 1}
}

func (x *CommandTask_Outputs) GetFiles() []string {
	if x != nil {
		return x.Files
	}
	return nil
}

func (x *CommandTask_Outputs) GetDirectories() []string {
	if x != nil {
		return x.Directories
	}
	return nil
}

func (x *CommandTask_Outputs) GetStdoutDestination() string {
	if x != nil {
		return x.StdoutDestination
	}
	return ""
}

func (x *CommandTask_Outputs) GetStderrDestination() string {
	if x != nil {
		return x.StderrDestination
	}
	return ""
}

// Describes the timeouts associated with this task.
type CommandTask_Timeouts struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This specifies the maximum time that the task can run, excluding the
	// time required to download inputs or upload outputs. That is, the worker
	// will terminate the task if it runs longer than this.
	Execution *durationpb.Duration `protobuf:"bytes,1,opt,name=execution,proto3" json:"execution,omitempty"`
	// This specifies the maximum amount of time the task can be idle - that is,
	// go without generating some output in either stdout or stderr. If the
	// process is silent for more than the specified time, the worker will
	// terminate the task.
	Idle *durationpb.Duration `protobuf:"bytes,2,opt,name=idle,proto3" json:"idle,omitempty"`
	// If the execution or IO timeouts are exceeded, the worker will try to
	// gracefully terminate the task and return any existing logs. However,
	// tasks may be hard-frozen in which case this process will fail. This
	// timeout specifies how long to wait for a terminated task to shut down
	// gracefully (e.g. via SIGTERM) before we bring down the hammer (e.g.
	// SIGKILL on *nix, CTRL_BREAK_EVENT on Windows).
	Shutdown *durationpb.Duration `protobuf:"bytes,3,opt,name=shutdown,proto3" json:"shutdown,omitempty"`
}

func (x *CommandTask_Timeouts) Reset() {
	*x = CommandTask_Timeouts{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandTask_Timeouts) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandTask_Timeouts) ProtoMessage() {}

func (x *CommandTask_Timeouts) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandTask_Timeouts.ProtoReflect.Descriptor instead.
func (*CommandTask_Timeouts) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_command_proto_rawDescGZIP(), []int{0, 2}
}

func (x *CommandTask_Timeouts) GetExecution() *durationpb.Duration {
	if x != nil {
		return x.Execution
	}
	return nil
}

func (x *CommandTask_Timeouts) GetIdle() *durationpb.Duration {
	if x != nil {
		return x.Idle
	}
	return nil
}

func (x *CommandTask_Timeouts) GetShutdown() *durationpb.Duration {
	if x != nil {
		return x.Shutdown
	}
	return nil
}

// An environment variable required by this task.
type CommandTask_Inputs_EnvironmentVariable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The envvar name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The envvar value.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *CommandTask_Inputs_EnvironmentVariable) Reset() {
	*x = CommandTask_Inputs_EnvironmentVariable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommandTask_Inputs_EnvironmentVariable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommandTask_Inputs_EnvironmentVariable) ProtoMessage() {}

func (x *CommandTask_Inputs_EnvironmentVariable) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommandTask_Inputs_EnvironmentVariable.ProtoReflect.Descriptor instead.
func (*CommandTask_Inputs_EnvironmentVariable) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_command_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *CommandTask_Inputs_EnvironmentVariable) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CommandTask_Inputs_EnvironmentVariable) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

var File_google_devtools_remoteworkers_v1test2_command_proto protoreflect.FileDescriptor

var file_google_devtools_remoteworkers_v1test2_command_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2f,
	0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72,
	0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x9f, 0x08, 0x0a, 0x0b, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x54, 0x61, 0x73, 0x6b,
	0x12, 0x51, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73,
	0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x54, 0x61, 0x73, 0x6b, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x52, 0x06, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x73, 0x12, 0x65, 0x0a, 0x10, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31,
	0x74, 0x65, 0x73, 0x74, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x54, 0x61, 0x73,
	0x6b, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x52, 0x0f, 0x65, 0x78, 0x70, 0x65, 0x63,
	0x74, 0x65, 0x64, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x12, 0x57, 0x0a, 0x08, 0x74, 0x69,
	0x6d, 0x65, 0x6f, 0x75, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74,
	0x65, 0x73, 0x74, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x54, 0x61, 0x73, 0x6b,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x73, 0x52, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x6f,
	0x75, 0x74, 0x73, 0x1a, 0xae, 0x03, 0x0a, 0x06, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x1c,
	0x0a, 0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x43, 0x0a, 0x05,
	0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65,
	0x73, 0x74, 0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x05, 0x66, 0x69, 0x6c, 0x65,
	0x73, 0x12, 0x4e, 0x0a, 0x0c, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x62, 0x6c, 0x6f, 0x62,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2e,
	0x42, 0x6c, 0x6f, 0x62, 0x52, 0x0b, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x42, 0x6c, 0x6f, 0x62,
	0x73, 0x12, 0x82, 0x01, 0x0a, 0x15, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x54, 0x61, 0x73, 0x6b, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x2e, 0x45, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65,
	0x52, 0x14, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72,
	0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e,
	0x67, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x10, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x79, 0x1a, 0x3f, 0x0a, 0x13, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x1a, 0x9f, 0x01, 0x0a, 0x07, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73,
	0x12, 0x14, 0x0a, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x2d, 0x0a, 0x12, 0x73, 0x74, 0x64, 0x6f,
	0x75, 0x74, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x73, 0x74, 0x64, 0x6f, 0x75, 0x74, 0x44, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x0a, 0x12, 0x73, 0x74, 0x64, 0x65, 0x72,
	0x72, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x11, 0x73, 0x74, 0x64, 0x65, 0x72, 0x72, 0x44, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xa9, 0x01, 0x0a, 0x08, 0x54, 0x69, 0x6d, 0x65, 0x6f,
	0x75, 0x74, 0x73, 0x12, 0x37, 0x0a, 0x09, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x09, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x0a, 0x04,
	0x69, 0x64, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x69, 0x64, 0x6c, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x73,
	0x68, 0x75, 0x74, 0x64, 0x6f, 0x77, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x73, 0x68, 0x75, 0x74, 0x64, 0x6f,
	0x77, 0x6e, 0x22, 0x76, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x78, 0x69, 0x74, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x65, 0x78, 0x69, 0x74, 0x43, 0x6f, 0x64,
	0x65, 0x12, 0x47, 0x0a, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73,
	0x74, 0x52, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x22, 0x7f, 0x0a, 0x0f, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4f, 0x76, 0x65, 0x72, 0x68, 0x65, 0x61, 0x64, 0x12, 0x35, 0x0a,
	0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x68, 0x65, 0x61, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x68, 0x65, 0x61, 0x64, 0x22, 0xc9, 0x02, 0x0a, 0x0d,
	0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x2a, 0x0a,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x78, 0x69,
	0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x65, 0x78,
	0x69, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x47, 0x0a, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2e,
	0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x12,
	0x39, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x08, 0x6f, 0x76,
	0x65, 0x72, 0x68, 0x65, 0x61, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x02, 0x18, 0x01, 0x52, 0x08, 0x6f, 0x76, 0x65,
	0x72, 0x68, 0x65, 0x61, 0x64, 0x12, 0x30, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xaa, 0x01, 0x0a, 0x0c, 0x46, 0x69, 0x6c, 0x65,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x45, 0x0a, 0x06,
	0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74,
	0x65, 0x73, 0x74, 0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x06, 0x64, 0x69, 0x67,
	0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x23, 0x0a, 0x0d, 0x69, 0x73, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x69, 0x73, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x22, 0x6e, 0x0a, 0x11, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x45, 0x0a,
	0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31,
	0x74, 0x65, 0x73, 0x74, 0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x06, 0x64, 0x69,
	0x67, 0x65, 0x73, 0x74, 0x22, 0x3b, 0x0a, 0x06, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x68, 0x61, 0x73, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x68, 0x61,
	0x73, 0x68, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x73, 0x69, 0x7a, 0x65, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x22, 0x69, 0x0a, 0x04, 0x42, 0x6c, 0x6f, 0x62, 0x12, 0x45, 0x0a, 0x06, 0x64, 0x69, 0x67,
	0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f,
	0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74,
	0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74,
	0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x22, 0xb2, 0x01, 0x0a,
	0x09, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x49, 0x0a, 0x05, 0x66, 0x69,
	0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f,
	0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74,
	0x32, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x05,
	0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x5a, 0x0a, 0x0b, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73,
	0x74, 0x32, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x0b, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x42, 0xc5, 0x01, 0x0a, 0x29, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x42,
	0x15, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x50, 0x01, 0x5a, 0x52, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2f, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x3b, 0x72,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0xa2, 0x02, 0x02, 0x52,
	0x57, 0xaa, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x44, 0x65, 0x76, 0x54, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x73, 0x2e, 0x56, 0x31, 0x54, 0x65, 0x73, 0x74, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_devtools_remoteworkers_v1test2_command_proto_rawDescOnce sync.Once
	file_google_devtools_remoteworkers_v1test2_command_proto_rawDescData = file_google_devtools_remoteworkers_v1test2_command_proto_rawDesc
)

func file_google_devtools_remoteworkers_v1test2_command_proto_rawDescGZIP() []byte {
	file_google_devtools_remoteworkers_v1test2_command_proto_rawDescOnce.Do(func() {
		file_google_devtools_remoteworkers_v1test2_command_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_devtools_remoteworkers_v1test2_command_proto_rawDescData)
	})
	return file_google_devtools_remoteworkers_v1test2_command_proto_rawDescData
}

var file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_devtools_remoteworkers_v1test2_command_proto_goTypes = []interface{}{
	(*CommandTask)(nil),                            // 0: google.devtools.remoteworkers.v1test2.CommandTask
	(*CommandOutputs)(nil),                         // 1: google.devtools.remoteworkers.v1test2.CommandOutputs
	(*CommandOverhead)(nil),                        // 2: google.devtools.remoteworkers.v1test2.CommandOverhead
	(*CommandResult)(nil),                          // 3: google.devtools.remoteworkers.v1test2.CommandResult
	(*FileMetadata)(nil),                           // 4: google.devtools.remoteworkers.v1test2.FileMetadata
	(*DirectoryMetadata)(nil),                      // 5: google.devtools.remoteworkers.v1test2.DirectoryMetadata
	(*Digest)(nil),                                 // 6: google.devtools.remoteworkers.v1test2.Digest
	(*Blob)(nil),                                   // 7: google.devtools.remoteworkers.v1test2.Blob
	(*Directory)(nil),                              // 8: google.devtools.remoteworkers.v1test2.Directory
	(*CommandTask_Inputs)(nil),                     // 9: google.devtools.remoteworkers.v1test2.CommandTask.Inputs
	(*CommandTask_Outputs)(nil),                    // 10: google.devtools.remoteworkers.v1test2.CommandTask.Outputs
	(*CommandTask_Timeouts)(nil),                   // 11: google.devtools.remoteworkers.v1test2.CommandTask.Timeouts
	(*CommandTask_Inputs_EnvironmentVariable)(nil), // 12: google.devtools.remoteworkers.v1test2.CommandTask.Inputs.EnvironmentVariable
	(*durationpb.Duration)(nil),                    // 13: google.protobuf.Duration
	(*status.Status)(nil),                          // 14: google.rpc.Status
	(*anypb.Any)(nil),                              // 15: google.protobuf.Any
}
var file_google_devtools_remoteworkers_v1test2_command_proto_depIdxs = []int32{
	9,  // 0: google.devtools.remoteworkers.v1test2.CommandTask.inputs:type_name -> google.devtools.remoteworkers.v1test2.CommandTask.Inputs
	10, // 1: google.devtools.remoteworkers.v1test2.CommandTask.expected_outputs:type_name -> google.devtools.remoteworkers.v1test2.CommandTask.Outputs
	11, // 2: google.devtools.remoteworkers.v1test2.CommandTask.timeouts:type_name -> google.devtools.remoteworkers.v1test2.CommandTask.Timeouts
	6,  // 3: google.devtools.remoteworkers.v1test2.CommandOutputs.outputs:type_name -> google.devtools.remoteworkers.v1test2.Digest
	13, // 4: google.devtools.remoteworkers.v1test2.CommandOverhead.duration:type_name -> google.protobuf.Duration
	13, // 5: google.devtools.remoteworkers.v1test2.CommandOverhead.overhead:type_name -> google.protobuf.Duration
	14, // 6: google.devtools.remoteworkers.v1test2.CommandResult.status:type_name -> google.rpc.Status
	6,  // 7: google.devtools.remoteworkers.v1test2.CommandResult.outputs:type_name -> google.devtools.remoteworkers.v1test2.Digest
	13, // 8: google.devtools.remoteworkers.v1test2.CommandResult.duration:type_name -> google.protobuf.Duration
	13, // 9: google.devtools.remoteworkers.v1test2.CommandResult.overhead:type_name -> google.protobuf.Duration
	15, // 10: google.devtools.remoteworkers.v1test2.CommandResult.metadata:type_name -> google.protobuf.Any
	6,  // 11: google.devtools.remoteworkers.v1test2.FileMetadata.digest:type_name -> google.devtools.remoteworkers.v1test2.Digest
	6,  // 12: google.devtools.remoteworkers.v1test2.DirectoryMetadata.digest:type_name -> google.devtools.remoteworkers.v1test2.Digest
	6,  // 13: google.devtools.remoteworkers.v1test2.Blob.digest:type_name -> google.devtools.remoteworkers.v1test2.Digest
	4,  // 14: google.devtools.remoteworkers.v1test2.Directory.files:type_name -> google.devtools.remoteworkers.v1test2.FileMetadata
	5,  // 15: google.devtools.remoteworkers.v1test2.Directory.directories:type_name -> google.devtools.remoteworkers.v1test2.DirectoryMetadata
	6,  // 16: google.devtools.remoteworkers.v1test2.CommandTask.Inputs.files:type_name -> google.devtools.remoteworkers.v1test2.Digest
	7,  // 17: google.devtools.remoteworkers.v1test2.CommandTask.Inputs.inline_blobs:type_name -> google.devtools.remoteworkers.v1test2.Blob
	12, // 18: google.devtools.remoteworkers.v1test2.CommandTask.Inputs.environment_variables:type_name -> google.devtools.remoteworkers.v1test2.CommandTask.Inputs.EnvironmentVariable
	13, // 19: google.devtools.remoteworkers.v1test2.CommandTask.Timeouts.execution:type_name -> google.protobuf.Duration
	13, // 20: google.devtools.remoteworkers.v1test2.CommandTask.Timeouts.idle:type_name -> google.protobuf.Duration
	13, // 21: google.devtools.remoteworkers.v1test2.CommandTask.Timeouts.shutdown:type_name -> google.protobuf.Duration
	22, // [22:22] is the sub-list for method output_type
	22, // [22:22] is the sub-list for method input_type
	22, // [22:22] is the sub-list for extension type_name
	22, // [22:22] is the sub-list for extension extendee
	0,  // [0:22] is the sub-list for field type_name
}

func init() { file_google_devtools_remoteworkers_v1test2_command_proto_init() }
func file_google_devtools_remoteworkers_v1test2_command_proto_init() {
	if File_google_devtools_remoteworkers_v1test2_command_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandTask); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandOutputs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandOverhead); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FileMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DirectoryMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Digest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Blob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Directory); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandTask_Inputs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandTask_Outputs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandTask_Timeouts); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommandTask_Inputs_EnvironmentVariable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_devtools_remoteworkers_v1test2_command_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_devtools_remoteworkers_v1test2_command_proto_goTypes,
		DependencyIndexes: file_google_devtools_remoteworkers_v1test2_command_proto_depIdxs,
		MessageInfos:      file_google_devtools_remoteworkers_v1test2_command_proto_msgTypes,
	}.Build()
	File_google_devtools_remoteworkers_v1test2_command_proto = out.File
	file_google_devtools_remoteworkers_v1test2_command_proto_rawDesc = nil
	file_google_devtools_remoteworkers_v1test2_command_proto_goTypes = nil
	file_google_devtools_remoteworkers_v1test2_command_proto_depIdxs = nil
}
