// Copyright 2023 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package drivelabels provides access to the Drive Labels API.
//
// For product documentation, see: https://developers.google.com/drive/labels
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/drivelabels/v2"
//	...
//	ctx := context.Background()
//	drivelabelsService, err := drivelabels.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//	drivelabelsService, err := drivelabels.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	drivelabelsService, err := drivelabels.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package drivelabels // import "google.golang.org/api/drivelabels/v2"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "drivelabels:v2"
const apiName = "drivelabels"
const apiVersion = "v2"
const basePath = "https://drivelabels.googleapis.com/"
const mtlsBasePath = "https://drivelabels.mtls.googleapis.com/"

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Labels = NewLabelsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Labels *LabelsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewLabelsService(s *Service) *LabelsService {
	rs := &LabelsService{s: s}
	return rs
}

type LabelsService struct {
	s *Service
}

// GoogleAppsDriveLabelsV2BadgeColors: The color derived from
// BadgeConfig and changed to the closest recommended supported color.
type GoogleAppsDriveLabelsV2BadgeColors struct {
	// BackgroundColor: Output only. Badge background that pairs with the
	// foreground.
	BackgroundColor *GoogleTypeColor `json:"backgroundColor,omitempty"`

	// ForegroundColor: Output only. Badge foreground that pairs with the
	// background.
	ForegroundColor *GoogleTypeColor `json:"foregroundColor,omitempty"`

	// SoloColor: Output only. Color that can be used for text without a
	// background.
	SoloColor *GoogleTypeColor `json:"soloColor,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BackgroundColor") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BackgroundColor") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2BadgeColors) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2BadgeColors
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2BadgeConfig: Badge status of the label.
type GoogleAppsDriveLabelsV2BadgeConfig struct {
	// Color: The color of the badge. When not specified, no badge is
	// rendered. The background, foreground, and solo (light and dark mode)
	// colors set here are changed in the Drive UI into the closest
	// recommended supported color.
	Color *GoogleTypeColor `json:"color,omitempty"`

	// PriorityOverride: Override the default global priority of this badge.
	// When set to 0, the default priority heuristic is used.
	PriorityOverride int64 `json:"priorityOverride,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Color") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Color") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2BadgeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2BadgeConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2Field: Defines a field that has a display
// name, data type, and other configuration options. This field defines
// the kind of metadata that may be set on a Drive item.
type GoogleAppsDriveLabelsV2Field struct {
	// AppliedCapabilities: Output only. The capabilities this user has on
	// this field and its value when the label is applied on Drive items.
	AppliedCapabilities *GoogleAppsDriveLabelsV2FieldAppliedCapabilities `json:"appliedCapabilities,omitempty"`

	// CreateTime: Output only. The time this field was created.
	CreateTime string `json:"createTime,omitempty"`

	// Creator: Output only. The user who created this field.
	Creator *GoogleAppsDriveLabelsV2UserInfo `json:"creator,omitempty"`

	// DateOptions: Date field options.
	DateOptions *GoogleAppsDriveLabelsV2FieldDateOptions `json:"dateOptions,omitempty"`

	// DisableTime: Output only. The time this field was disabled. This
	// value has no meaning when the field is not disabled.
	DisableTime string `json:"disableTime,omitempty"`

	// Disabler: Output only. The user who disabled this field. This value
	// has no meaning when the field is not disabled.
	Disabler *GoogleAppsDriveLabelsV2UserInfo `json:"disabler,omitempty"`

	// DisplayHints: Output only. UI display hints for rendering a field.
	DisplayHints *GoogleAppsDriveLabelsV2FieldDisplayHints `json:"displayHints,omitempty"`

	// Id: Output only. The key of a field, unique within a label or
	// library. This value is autogenerated. Matches the regex:
	// `([a-zA-Z0-9])+`
	Id string `json:"id,omitempty"`

	// IntegerOptions: Integer field options.
	IntegerOptions *GoogleAppsDriveLabelsV2FieldIntegerOptions `json:"integerOptions,omitempty"`

	// Lifecycle: Output only. The lifecycle of this field.
	Lifecycle *GoogleAppsDriveLabelsV2Lifecycle `json:"lifecycle,omitempty"`

	// LockStatus: Output only. The LockStatus of this field.
	LockStatus *GoogleAppsDriveLabelsV2LockStatus `json:"lockStatus,omitempty"`

	// Properties: The basic properties of the field.
	Properties *GoogleAppsDriveLabelsV2FieldProperties `json:"properties,omitempty"`

	// Publisher: Output only. The user who published this field. This value
	// has no meaning when the field is not published.
	Publisher *GoogleAppsDriveLabelsV2UserInfo `json:"publisher,omitempty"`

	// QueryKey: Output only. The key to use when constructing Drive search
	// queries to find files based on values defined for this field on
	// files. For example, "{query_key}` > 2001-01-01".
	QueryKey string `json:"queryKey,omitempty"`

	// SchemaCapabilities: Output only. The capabilities this user has when
	// editing this field.
	SchemaCapabilities *GoogleAppsDriveLabelsV2FieldSchemaCapabilities `json:"schemaCapabilities,omitempty"`

	// SelectionOptions: Selection field options.
	SelectionOptions *GoogleAppsDriveLabelsV2FieldSelectionOptions `json:"selectionOptions,omitempty"`

	// TextOptions: Text field options.
	TextOptions *GoogleAppsDriveLabelsV2FieldTextOptions `json:"textOptions,omitempty"`

	// UpdateTime: Output only. The time this field was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// Updater: Output only. The user who modified this field.
	Updater *GoogleAppsDriveLabelsV2UserInfo `json:"updater,omitempty"`

	// UserOptions: User field options.
	UserOptions *GoogleAppsDriveLabelsV2FieldUserOptions `json:"userOptions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AppliedCapabilities")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppliedCapabilities") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2Field) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2Field
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2FieldAppliedCapabilities: The capabilities
// related to this field on applied metadata.
type GoogleAppsDriveLabelsV2FieldAppliedCapabilities struct {
	// CanRead: Whether the user can read related applied metadata on items.
	CanRead bool `json:"canRead,omitempty"`

	// CanSearch: Whether the user can search for Drive items referencing
	// this field.
	CanSearch bool `json:"canSearch,omitempty"`

	// CanWrite: Whether the user can set this field on Drive items.
	CanWrite bool `json:"canWrite,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CanRead") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CanRead") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2FieldAppliedCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2FieldAppliedCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2FieldDateOptions: Options for the date field
// type.
type GoogleAppsDriveLabelsV2FieldDateOptions struct {
	// DateFormat: Output only. ICU date format.
	DateFormat string `json:"dateFormat,omitempty"`

	// DateFormatType: Localized date formatting option. Field values are
	// rendered in this format according to their locale.
	//
	// Possible values:
	//   "DATE_FORMAT_UNSPECIFIED" - Date format unspecified.
	//   "LONG_DATE" - Includes full month name. For example, January 12,
	// 1999 (MMMM d, y)
	//   "SHORT_DATE" - Short, numeric, representation. For example,
	// 12/13/99 (M/d/yy)
	DateFormatType string `json:"dateFormatType,omitempty"`

	// MaxValue: Output only. Maximum valid value (year, month, day).
	MaxValue *GoogleTypeDate `json:"maxValue,omitempty"`

	// MinValue: Output only. Minimum valid value (year, month, day).
	MinValue *GoogleTypeDate `json:"minValue,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DateFormat") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DateFormat") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2FieldDateOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2FieldDateOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2FieldDisplayHints: UI display hints for
// rendering a field.
type GoogleAppsDriveLabelsV2FieldDisplayHints struct {
	// Disabled: Whether the field should be shown in the UI as disabled.
	Disabled bool `json:"disabled,omitempty"`

	// HiddenInSearch: This field should be hidden in the search menu when
	// searching for Drive items.
	HiddenInSearch bool `json:"hiddenInSearch,omitempty"`

	// Required: Whether the field should be shown as required in the UI.
	Required bool `json:"required,omitempty"`

	// ShownInApply: This field should be shown in the apply menu when
	// applying values to a Drive item.
	ShownInApply bool `json:"shownInApply,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Disabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2FieldDisplayHints) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2FieldDisplayHints
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2FieldIntegerOptions: Options for the Integer
// field type.
type GoogleAppsDriveLabelsV2FieldIntegerOptions struct {
	// MaxValue: Output only. The maximum valid value for the integer field.
	MaxValue int64 `json:"maxValue,omitempty,string"`

	// MinValue: Output only. The minimum valid value for the integer field.
	MinValue int64 `json:"minValue,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "MaxValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MaxValue") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2FieldIntegerOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2FieldIntegerOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2FieldListOptions: Options for a multi-valued
// variant of an associated field type.
type GoogleAppsDriveLabelsV2FieldListOptions struct {
	// MaxEntries: Maximum number of entries permitted.
	MaxEntries int64 `json:"maxEntries,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MaxEntries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MaxEntries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2FieldListOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2FieldListOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2FieldProperties: The basic properties of the
// field.
type GoogleAppsDriveLabelsV2FieldProperties struct {
	// DisplayName: Required. The display text to show in the UI identifying
	// this field.
	DisplayName string `json:"displayName,omitempty"`

	// InsertBeforeField: Input only. Insert or move this field before the
	// indicated field. If empty, the field is placed at the end of the
	// list.
	InsertBeforeField string `json:"insertBeforeField,omitempty"`

	// Required: Whether the field should be marked as required.
	Required bool `json:"required,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2FieldProperties) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2FieldProperties
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2FieldSchemaCapabilities: The capabilities
// related to this field when editing the field.
type GoogleAppsDriveLabelsV2FieldSchemaCapabilities struct {
	// CanDelete: Whether the user can delete this field. The user must have
	// permission and the field must be deprecated.
	CanDelete bool `json:"canDelete,omitempty"`

	// CanDisable: Whether the user can disable this field. The user must
	// have permission and this field must not already be disabled.
	CanDisable bool `json:"canDisable,omitempty"`

	// CanEnable: Whether the user can enable this field. The user must have
	// permission and this field must be disabled.
	CanEnable bool `json:"canEnable,omitempty"`

	// CanUpdate: Whether the user can change this field.
	CanUpdate bool `json:"canUpdate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CanDelete") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CanDelete") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2FieldSchemaCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2FieldSchemaCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2FieldSelectionOptions: Options for the
// selection field type.
type GoogleAppsDriveLabelsV2FieldSelectionOptions struct {
	// Choices: The options available for this selection field. The list
	// order is consistent, and modified with `insert_before_choice`.
	Choices []*GoogleAppsDriveLabelsV2FieldSelectionOptionsChoice `json:"choices,omitempty"`

	// ListOptions: When specified, indicates this field supports a list of
	// values. Once the field is published, this cannot be changed.
	ListOptions *GoogleAppsDriveLabelsV2FieldListOptions `json:"listOptions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Choices") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Choices") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2FieldSelectionOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2FieldSelectionOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2FieldSelectionOptionsChoice: Selection field
// choice.
type GoogleAppsDriveLabelsV2FieldSelectionOptionsChoice struct {
	// AppliedCapabilities: Output only. The capabilities related to this
	// choice on applied metadata.
	AppliedCapabilities *GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceAppliedCapabilities `json:"appliedCapabilities,omitempty"`

	// CreateTime: Output only. The time this choice was created.
	CreateTime string `json:"createTime,omitempty"`

	// Creator: Output only. The user who created this choice.
	Creator *GoogleAppsDriveLabelsV2UserInfo `json:"creator,omitempty"`

	// DisableTime: Output only. The time this choice was disabled. This
	// value has no meaning when the choice is not disabled.
	DisableTime string `json:"disableTime,omitempty"`

	// Disabler: Output only. The user who disabled this choice. This value
	// has no meaning when the option is not disabled.
	Disabler *GoogleAppsDriveLabelsV2UserInfo `json:"disabler,omitempty"`

	// DisplayHints: Output only. UI display hints for rendering a choice.
	DisplayHints *GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceDisplayHints `json:"displayHints,omitempty"`

	// Id: The unique value of the choice. This ID is autogenerated. Matches
	// the regex: `([a-zA-Z0-9_])+`.
	Id string `json:"id,omitempty"`

	// Lifecycle: Output only. Lifecycle of the choice.
	Lifecycle *GoogleAppsDriveLabelsV2Lifecycle `json:"lifecycle,omitempty"`

	// LockStatus: Output only. The LockStatus of this choice.
	LockStatus *GoogleAppsDriveLabelsV2LockStatus `json:"lockStatus,omitempty"`

	// Properties: Basic properties of the choice.
	Properties *GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceProperties `json:"properties,omitempty"`

	// PublishTime: Output only. The time this choice was published. This
	// value has no meaning when the choice is not published.
	PublishTime string `json:"publishTime,omitempty"`

	// Publisher: Output only. The user who published this choice. This
	// value has no meaning when the choice is not published.
	Publisher *GoogleAppsDriveLabelsV2UserInfo `json:"publisher,omitempty"`

	// SchemaCapabilities: Output only. The capabilities related to this
	// option when editing the option.
	SchemaCapabilities *GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceSchemaCapabilities `json:"schemaCapabilities,omitempty"`

	// UpdateTime: Output only. The time this choice was updated last.
	UpdateTime string `json:"updateTime,omitempty"`

	// Updater: Output only. The user who updated this choice last.
	Updater *GoogleAppsDriveLabelsV2UserInfo `json:"updater,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AppliedCapabilities")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppliedCapabilities") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2FieldSelectionOptionsChoice) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2FieldSelectionOptionsChoice
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceAppliedCapabilities:
//
//	The capabilities related to this choice on applied metadata.
type GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceAppliedCapabilities struct {
	// CanRead: Whether the user can read related applied metadata on items.
	CanRead bool `json:"canRead,omitempty"`

	// CanSearch: Whether the user can use this choice in search queries.
	CanSearch bool `json:"canSearch,omitempty"`

	// CanSelect: Whether the user can select this choice on an item.
	CanSelect bool `json:"canSelect,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CanRead") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CanRead") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceAppliedCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceAppliedCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceDisplayHints: UI
// display hints for rendering an option.
type GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceDisplayHints struct {
	// BadgeColors: The colors to use for the badge. Changed to Google
	// Material colors based on the chosen `properties.badge_config.color`.
	BadgeColors *GoogleAppsDriveLabelsV2BadgeColors `json:"badgeColors,omitempty"`

	// BadgePriority: The priority of this badge. Used to compare and sort
	// between multiple badges. A lower number means the badge should be
	// shown first. When a badging configuration is not present, this will
	// be 0. Otherwise, this will be set to `BadgeConfig.priority_override`
	// or the default heuristic which prefers creation date of the label,
	// and field and option priority.
	BadgePriority int64 `json:"badgePriority,omitempty,string"`

	// DarkBadgeColors: The dark-mode color to use for the badge. Changed to
	// Google Material colors based on the chosen
	// `properties.badge_config.color`.
	DarkBadgeColors *GoogleAppsDriveLabelsV2BadgeColors `json:"darkBadgeColors,omitempty"`

	// Disabled: Whether the option should be shown in the UI as disabled.
	Disabled bool `json:"disabled,omitempty"`

	// HiddenInSearch: This option should be hidden in the search menu when
	// searching for Drive items.
	HiddenInSearch bool `json:"hiddenInSearch,omitempty"`

	// ShownInApply: This option should be shown in the apply menu when
	// applying values to a Drive item.
	ShownInApply bool `json:"shownInApply,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BadgeColors") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BadgeColors") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceDisplayHints) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceDisplayHints
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceProperties: Basic
// properties of the choice.
type GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceProperties struct {
	// BadgeConfig: The badge configuration for this choice. When set, the
	// label that owns this choice is considered a "badged label".
	BadgeConfig *GoogleAppsDriveLabelsV2BadgeConfig `json:"badgeConfig,omitempty"`

	// Description: The description of this label.
	Description string `json:"description,omitempty"`

	// DisplayName: Required. The display text to show in the UI identifying
	// this field.
	DisplayName string `json:"displayName,omitempty"`

	// InsertBeforeChoice: Input only. Insert or move this choice before the
	// indicated choice. If empty, the choice is placed at the end of the
	// list.
	InsertBeforeChoice string `json:"insertBeforeChoice,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BadgeConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BadgeConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceProperties) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceProperties
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceSchemaCapabilities:
// The capabilities related to this choice when editing the choice.
type GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceSchemaCapabilities struct {
	// CanDelete: Whether the user can delete this choice.
	CanDelete bool `json:"canDelete,omitempty"`

	// CanDisable: Whether the user can disable this choice.
	CanDisable bool `json:"canDisable,omitempty"`

	// CanEnable: Whether the user can enable this choice.
	CanEnable bool `json:"canEnable,omitempty"`

	// CanUpdate: Whether the user can update this choice.
	CanUpdate bool `json:"canUpdate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CanDelete") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CanDelete") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceSchemaCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceSchemaCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2FieldTextOptions: Options for the Text field
// type.
type GoogleAppsDriveLabelsV2FieldTextOptions struct {
	// MaxLength: Output only. The maximum valid length of values for the
	// text field.
	MaxLength int64 `json:"maxLength,omitempty"`

	// MinLength: Output only. The minimum valid length of values for the
	// text field.
	MinLength int64 `json:"minLength,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MaxLength") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MaxLength") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2FieldTextOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2FieldTextOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2FieldUserOptions: Options for the user field
// type.
type GoogleAppsDriveLabelsV2FieldUserOptions struct {
	// ListOptions: When specified, indicates that this field supports a
	// list of values. Once the field is published, this cannot be changed.
	ListOptions *GoogleAppsDriveLabelsV2FieldListOptions `json:"listOptions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ListOptions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ListOptions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2FieldUserOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2FieldUserOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2Label: A label defines a taxonomy that can be
// applied to Drive items in order to organize and search across items.
// Labels can be simple strings, or can contain fields that describe
// additional metadata that can be further used to organize and search
// Drive items.
type GoogleAppsDriveLabelsV2Label struct {
	// AppliedCapabilities: Output only. The capabilities related to this
	// label on applied metadata.
	AppliedCapabilities *GoogleAppsDriveLabelsV2LabelAppliedCapabilities `json:"appliedCapabilities,omitempty"`

	// AppliedLabelPolicy: Output only. Behavior of this label when it's
	// applied to Drive items.
	AppliedLabelPolicy *GoogleAppsDriveLabelsV2LabelAppliedLabelPolicy `json:"appliedLabelPolicy,omitempty"`

	// CreateTime: Output only. The time this label was created.
	CreateTime string `json:"createTime,omitempty"`

	// Creator: Output only. The user who created this label.
	Creator *GoogleAppsDriveLabelsV2UserInfo `json:"creator,omitempty"`

	// DisableTime: Output only. The time this label was disabled. This
	// value has no meaning when the label is not disabled.
	DisableTime string `json:"disableTime,omitempty"`

	// Disabler: Output only. The user who disabled this label. This value
	// has no meaning when the label is not disabled.
	Disabler *GoogleAppsDriveLabelsV2UserInfo `json:"disabler,omitempty"`

	// DisplayHints: Output only. UI display hints for rendering the label.
	DisplayHints *GoogleAppsDriveLabelsV2LabelDisplayHints `json:"displayHints,omitempty"`

	// Fields: List of fields in descending priority order.
	Fields []*GoogleAppsDriveLabelsV2Field `json:"fields,omitempty"`

	// Id: Output only. Globally unique identifier of this label. ID makes
	// up part of the label `name`, but unlike `name`, ID is consistent
	// between revisions. Matches the regex: `([a-zA-Z0-9])+`
	Id string `json:"id,omitempty"`

	// LabelType: Required. The type of label.
	//
	// Possible values:
	//   "LABEL_TYPE_UNSPECIFIED" - Unknown label type.
	//   "SHARED" - Shared labels may be shared with users to apply to Drive
	// items.
	//   "ADMIN" - Admin-owned label. Only creatable and editable by admins.
	// Supports some additional admin-only features.
	LabelType string `json:"labelType,omitempty"`

	// LearnMoreUri: Custom URL to present to users to allow them to learn
	// more about this label and how it should be used.
	LearnMoreUri string `json:"learnMoreUri,omitempty"`

	// Lifecycle: Output only. The lifecycle state of the label including
	// whether it's published, deprecated, and has draft changes.
	Lifecycle *GoogleAppsDriveLabelsV2Lifecycle `json:"lifecycle,omitempty"`

	// LockStatus: Output only. The LockStatus of this label.
	LockStatus *GoogleAppsDriveLabelsV2LockStatus `json:"lockStatus,omitempty"`

	// Name: Output only. Resource name of the label. Will be in the form of
	// either: `labels/{id}` or `labels/{id}@{revision_id}` depending on the
	// request. See `id` and `revision_id` below.
	Name string `json:"name,omitempty"`

	// Properties: Required. The basic properties of the label.
	Properties *GoogleAppsDriveLabelsV2LabelProperties `json:"properties,omitempty"`

	// PublishTime: Output only. The time this label was published. This
	// value has no meaning when the label is not published.
	PublishTime string `json:"publishTime,omitempty"`

	// Publisher: Output only. The user who published this label. This value
	// has no meaning when the label is not published.
	Publisher *GoogleAppsDriveLabelsV2UserInfo `json:"publisher,omitempty"`

	// RevisionCreateTime: Output only. The time this label revision was
	// created.
	RevisionCreateTime string `json:"revisionCreateTime,omitempty"`

	// RevisionCreator: Output only. The user who created this label
	// revision.
	RevisionCreator *GoogleAppsDriveLabelsV2UserInfo `json:"revisionCreator,omitempty"`

	// RevisionId: Output only. Revision ID of the label. Revision ID might
	// be part of the label `name` depending on the request issued. A new
	// revision is created whenever revisioned properties of a label are
	// changed. Matches the regex: `([a-zA-Z0-9])+`
	RevisionId string `json:"revisionId,omitempty"`

	// SchemaCapabilities: Output only. The capabilities the user has on
	// this label.
	SchemaCapabilities *GoogleAppsDriveLabelsV2LabelSchemaCapabilities `json:"schemaCapabilities,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AppliedCapabilities")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppliedCapabilities") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2Label) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2Label
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2LabelAppliedCapabilities: The capabilities a
// user has on this label's applied metadata.
type GoogleAppsDriveLabelsV2LabelAppliedCapabilities struct {
	// CanApply: Whether the user can apply this label to items.
	CanApply bool `json:"canApply,omitempty"`

	// CanRead: Whether the user can read applied metadata related to this
	// label.
	CanRead bool `json:"canRead,omitempty"`

	// CanRemove: Whether the user can remove this label from items.
	CanRemove bool `json:"canRemove,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CanApply") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CanApply") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2LabelAppliedCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2LabelAppliedCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2LabelAppliedLabelPolicy: Behavior of this
// label when it's applied to Drive items.
type GoogleAppsDriveLabelsV2LabelAppliedLabelPolicy struct {
	// CopyMode: Indicates how the applied label and field values should be
	// copied when a Drive item is copied.
	//
	// Possible values:
	//   "COPY_MODE_UNSPECIFIED" - Copy mode unspecified.
	//   "DO_NOT_COPY" - The applied label and field values are not copied
	// by default when the Drive item it's applied to is copied.
	//   "ALWAYS_COPY" - The applied label and field values are always
	// copied when the Drive item it's applied to is copied. Only admins can
	// use this mode.
	//   "COPY_APPLIABLE" - The applied label and field values are copied if
	// the label is appliable by the user making the copy.
	CopyMode string `json:"copyMode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CopyMode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CopyMode") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2LabelAppliedLabelPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2LabelAppliedLabelPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2LabelDisplayHints: UI display hints for
// rendering the label.
type GoogleAppsDriveLabelsV2LabelDisplayHints struct {
	// Disabled: Whether the label should be shown in the UI as disabled.
	Disabled bool `json:"disabled,omitempty"`

	// HiddenInSearch: This label should be hidden in the search menu when
	// searching for Drive items.
	HiddenInSearch bool `json:"hiddenInSearch,omitempty"`

	// Priority: Order to display label in a list.
	Priority int64 `json:"priority,omitempty,string"`

	// ShownInApply: This label should be shown in the apply menu when
	// applying values to a Drive item.
	ShownInApply bool `json:"shownInApply,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Disabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2LabelDisplayHints) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2LabelDisplayHints
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2LabelProperties: Basic properties of the
// label.
type GoogleAppsDriveLabelsV2LabelProperties struct {
	// Description: The description of the label.
	Description string `json:"description,omitempty"`

	// Title: Required. Title of the label.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2LabelProperties) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2LabelProperties
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2LabelSchemaCapabilities: The capabilities
// related to this label when editing the label.
type GoogleAppsDriveLabelsV2LabelSchemaCapabilities struct {
	// CanDelete: Whether the user can delete this label. The user must have
	// permission and the label must be disabled.
	CanDelete bool `json:"canDelete,omitempty"`

	// CanDisable: Whether the user can disable this label. The user must
	// have permission and this label must not already be disabled.
	CanDisable bool `json:"canDisable,omitempty"`

	// CanEnable: Whether the user can enable this label. The user must have
	// permission and this label must be disabled.
	CanEnable bool `json:"canEnable,omitempty"`

	// CanUpdate: Whether the user can change this label.
	CanUpdate bool `json:"canUpdate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CanDelete") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CanDelete") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2LabelSchemaCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2LabelSchemaCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2Lifecycle: The lifecycle state of an object,
// such as label, field, or choice. The lifecycle enforces the following
// transitions: * `UNPUBLISHED_DRAFT` (starting state) *
// `UNPUBLISHED_DRAFT` -> `PUBLISHED` * `UNPUBLISHED_DRAFT` -> (Deleted)
// * `PUBLISHED` -> `DISABLED` * `DISABLED` -> `PUBLISHED` * `DISABLED`
// -> (Deleted) The published and disabled states have some distinct
// characteristics: * Published—Some kinds of changes might be made to
// an object in this state, in which case `has_unpublished_changes` will
// be true. Also, some kinds of changes are not permitted. Generally,
// any change that would invalidate or cause new restrictions on
// existing metadata related to the label are rejected. *
// Disabled—When disabled, the configured `DisabledPolicy` takes
// effect.
type GoogleAppsDriveLabelsV2Lifecycle struct {
	// DisabledPolicy: The policy that governs how to show a disabled label,
	// field, or selection choice.
	DisabledPolicy *GoogleAppsDriveLabelsV2LifecycleDisabledPolicy `json:"disabledPolicy,omitempty"`

	// HasUnpublishedChanges: Output only. Whether the object associated
	// with this lifecycle has unpublished changes.
	HasUnpublishedChanges bool `json:"hasUnpublishedChanges,omitempty"`

	// State: Output only. The state of the object associated with this
	// lifecycle.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unknown State.
	//   "UNPUBLISHED_DRAFT" - The initial state of an object. Once
	// published, the object can never return to this state. Once an object
	// is published, certain kinds of changes are no longer permitted.
	//   "PUBLISHED" - The object has been published. The object might have
	// unpublished draft changes as indicated by `has_unpublished_changes`.
	//   "DISABLED" - The object has been published and has since been
	// disabled. The object might have unpublished draft changes as
	// indicated by `has_unpublished_changes`.
	//   "DELETED" - The object has been deleted.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisabledPolicy") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisabledPolicy") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2Lifecycle) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2Lifecycle
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2LifecycleDisabledPolicy: The policy that
// governs how to treat a disabled label, field, or selection choice in
// different contexts.
type GoogleAppsDriveLabelsV2LifecycleDisabledPolicy struct {
	// HideInSearch: Whether to hide this disabled object in the search menu
	// for Drive items. * When `false`, the object is generally shown in the
	// UI as disabled but it appears in the search results when searching
	// for Drive items. * When `true`, the object is generally hidden in the
	// UI when searching for Drive items.
	HideInSearch bool `json:"hideInSearch,omitempty"`

	// ShowInApply: Whether to show this disabled object in the apply menu
	// on Drive items. * When `true`, the object is generally shown in the
	// UI as disabled and is unselectable. * When `false`, the object is
	// generally hidden in the UI.
	ShowInApply bool `json:"showInApply,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HideInSearch") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HideInSearch") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2LifecycleDisabledPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2LifecycleDisabledPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2ListLabelsResponse: Response for listing
// Labels.
type GoogleAppsDriveLabelsV2ListLabelsResponse struct {
	// Labels: Labels.
	Labels []*GoogleAppsDriveLabelsV2Label `json:"labels,omitempty"`

	// NextPageToken: The token of the next page in the response.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Labels") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2ListLabelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2ListLabelsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2LockStatus: Contains information about whether
// a label component should be considered locked.
type GoogleAppsDriveLabelsV2LockStatus struct {
	// Locked: Output only. Indicates whether this label component is the
	// (direct) target of a LabelLock. A label component can be implicitly
	// locked even if it's not the direct target of a LabelLock, in which
	// case this field is set to false.
	Locked bool `json:"locked,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Locked") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Locked") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2LockStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2LockStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsDriveLabelsV2UserInfo: Information about a user.
type GoogleAppsDriveLabelsV2UserInfo struct {
	// Person: The identifier for this user that can be used with the People
	// API to get more information. For example, people/12345678.
	Person string `json:"person,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Person") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Person") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsDriveLabelsV2UserInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsDriveLabelsV2UserInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeColor: Represents a color in the RGBA color space. This
// representation is designed for simplicity of conversion to/from color
// representations in various languages over compactness. For example,
// the fields of this representation can be trivially provided to the
// constructor of `java.awt.Color` in Java; it can also be trivially
// provided to UIColor's `+colorWithRed:green:blue:alpha` method in iOS;
// and, with just a little work, it can be easily formatted into a CSS
// `rgba()` string in JavaScript. This reference page doesn't carry
// information about the absolute color space that should be used to
// interpret the RGB value (e.g. sRGB, Adobe RGB, DCI-P3, BT.2020,
// etc.). By default, applications should assume the sRGB color space.
// When color equality needs to be decided, implementations, unless
// documented otherwise, treat two colors as equal if all their red,
// green, blue, and alpha values each differ by at most 1e-5. Example
// (Java): import com.google.type.Color; // ... public static
// java.awt.Color fromProto(Color protocolor) { float alpha =
// protocolor.hasAlpha() ? protocolor.getAlpha().getValue() : 1.0;
// return new java.awt.Color( protocolor.getRed(),
// protocolor.getGreen(), protocolor.getBlue(), alpha); } public static
// Color toProto(java.awt.Color color) { float red = (float)
// color.getRed(); float green = (float) color.getGreen(); float blue =
// (float) color.getBlue(); float denominator = 255.0; Color.Builder
// resultBuilder = Color .newBuilder() .setRed(red / denominator)
// .setGreen(green / denominator) .setBlue(blue / denominator); int
// alpha = color.getAlpha(); if (alpha != 255) { result.setAlpha(
// FloatValue .newBuilder() .setValue(((float) alpha) / denominator)
// .build()); } return resultBuilder.build(); } // ... Example (iOS /
// Obj-C): // ... static UIColor* fromProto(Color* protocolor) { float
// red = [protocolor red]; float green = [protocolor green]; float blue
// = [protocolor blue]; FloatValue* alpha_wrapper = [protocolor alpha];
// float alpha = 1.0; if (alpha_wrapper != nil) { alpha = [alpha_wrapper
// value]; } return [UIColor colorWithRed:red green:green blue:blue
// alpha:alpha]; } static Color* toProto(UIColor* color) { CGFloat red,
// green, blue, alpha; if (![color getRed:&red green:&green blue:&blue
// alpha:&alpha]) { return nil; } Color* result = [[Color alloc] init];
// [result setRed:red]; [result setGreen:green]; [result setBlue:blue];
// if (alpha <= 0.9999) { [result
// setAlpha:floatWrapperWithValue(alpha)]; } [result autorelease];
// return result; } // ... Example (JavaScript): // ... var
// protoToCssColor = function(rgb_color) { var redFrac = rgb_color.red
// || 0.0; var greenFrac = rgb_color.green || 0.0; var blueFrac =
// rgb_color.blue || 0.0; var red = Math.floor(redFrac * 255); var green
// = Math.floor(greenFrac * 255); var blue = Math.floor(blueFrac * 255);
// if (!('alpha' in rgb_color)) { return rgbToCssColor(red, green,
// blue); } var alphaFrac = rgb_color.alpha.value || 0.0; var rgbParams
// = [red, green, blue].join(','); return ['rgba(', rgbParams, ',',
// alphaFrac, ')'].join(”); }; var rgbToCssColor = function(red, green,
// blue) { var rgbNumber = new Number((red << 16) | (green << 8) |
// blue); var hexString = rgbNumber.toString(16); var missingZeros = 6 -
// hexString.length; var resultBuilder = ['#']; for (var i = 0; i <
// missingZeros; i++) { resultBuilder.push('0'); }
// resultBuilder.push(hexString); return resultBuilder.join(”); }; //
// ...
type GoogleTypeColor struct {
	// Alpha: The fraction of this color that should be applied to the
	// pixel. That is, the final pixel color is defined by the equation:
	// `pixel color = alpha * (this color) + (1.0 - alpha) * (background
	// color)` This means that a value of 1.0 corresponds to a solid color,
	// whereas a value of 0.0 corresponds to a completely transparent color.
	// This uses a wrapper message rather than a simple float scalar so that
	// it is possible to distinguish between a default value and the value
	// being unset. If omitted, this color object is rendered as a solid
	// color (as if the alpha value had been explicitly given a value of
	// 1.0).
	Alpha float64 `json:"alpha,omitempty"`

	// Blue: The amount of blue in the color as a value in the interval [0,
	// 1].
	Blue float64 `json:"blue,omitempty"`

	// Green: The amount of green in the color as a value in the interval
	// [0, 1].
	Green float64 `json:"green,omitempty"`

	// Red: The amount of red in the color as a value in the interval [0,
	// 1].
	Red float64 `json:"red,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Alpha") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Alpha") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeColor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeColor
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleTypeColor) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleTypeColor
	var s1 struct {
		Alpha gensupport.JSONFloat64 `json:"alpha"`
		Blue  gensupport.JSONFloat64 `json:"blue"`
		Green gensupport.JSONFloat64 `json:"green"`
		Red   gensupport.JSONFloat64 `json:"red"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Alpha = float64(s1.Alpha)
	s.Blue = float64(s1.Blue)
	s.Green = float64(s1.Green)
	s.Red = float64(s1.Red)
	return nil
}

// GoogleTypeDate: Represents a whole or partial calendar date, such as
// a birthday. The time of day and time zone are either specified
// elsewhere or are insignificant. The date is relative to the Gregorian
// Calendar. This can represent one of the following: * A full date,
// with non-zero year, month, and day values. * A month and day, with a
// zero year (for example, an anniversary). * A year on its own, with a
// zero month and a zero day. * A year and month, with a zero day (for
// example, a credit card expiration date). Related types: *
// google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type GoogleTypeDate struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and
	// month, or 0 to specify a year by itself or a year and month where the
	// day isn't significant.
	Day int64 `json:"day,omitempty"`

	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year
	// without a month and day.
	Month int64 `json:"month,omitempty"`

	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a
	// date without a year.
	Year int64 `json:"year,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Day") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Day") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeDate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "drivelabels.labels.get":

type LabelsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a label by its resource name. Resource name may be any of: *
// `labels/{id}` - See `labels/{id}@latest` * `labels/{id}@latest` -
// Gets the latest revision of the label. * `labels/{id}@published` -
// Gets the current published revision of the label. *
// `labels/{id}@{revision_id}` - Gets the label at the specified
// revision ID.
//
//   - name: Label resource name. May be any of: * `labels/{id}`
//     (equivalent to labels/{id}@latest) * `labels/{id}@latest` *
//     `labels/{id}@published` * `labels/{id}@{revision_id}`.
func (r *LabelsService) Get(name string) *LabelsGetCall {
	c := &LabelsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// LanguageCode sets the optional parameter "languageCode": The BCP-47
// language code to use for evaluating localized field labels. When not
// specified, values in the default configured language are used.
func (c *LabelsGetCall) LanguageCode(languageCode string) *LabelsGetCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// UseAdminAccess sets the optional parameter "useAdminAccess": Set to
// `true` in order to use the user's admin credentials. The server
// verifies that the user is an admin for the label before allowing
// access.
func (c *LabelsGetCall) UseAdminAccess(useAdminAccess bool) *LabelsGetCall {
	c.urlParams_.Set("useAdminAccess", fmt.Sprint(useAdminAccess))
	return c
}

// View sets the optional parameter "view": When specified, only certain
// fields belonging to the indicated view are returned.
//
// Possible values:
//
//	"LABEL_VIEW_BASIC" - Implies the field mask:
//
// `name,id,revision_id,label_type,properties.*`
//
//	"LABEL_VIEW_FULL" - All possible fields.
func (c *LabelsGetCall) View(view string) *LabelsGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *LabelsGetCall) Fields(s ...googleapi.Field) *LabelsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *LabelsGetCall) IfNoneMatch(entityTag string) *LabelsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *LabelsGetCall) Context(ctx context.Context) *LabelsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *LabelsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LabelsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "drivelabels.labels.get" call.
// Exactly one of *GoogleAppsDriveLabelsV2Label or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAppsDriveLabelsV2Label.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *LabelsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAppsDriveLabelsV2Label, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAppsDriveLabelsV2Label{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get a label by its resource name. Resource name may be any of: * `labels/{id}` - See `labels/{id}@latest` * `labels/{id}@latest` - Gets the latest revision of the label. * `labels/{id}@published` - Gets the current published revision of the label. * `labels/{id}@{revision_id}` - Gets the label at the specified revision ID.",
	//   "flatPath": "v2/labels/{labelsId}",
	//   "httpMethod": "GET",
	//   "id": "drivelabels.labels.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "languageCode": {
	//       "description": "The BCP-47 language code to use for evaluating localized field labels. When not specified, values in the default configured language are used.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Required. Label resource name. May be any of: * `labels/{id}` (equivalent to labels/{id}@latest) * `labels/{id}@latest` * `labels/{id}@published` * `labels/{id}@{revision_id}`",
	//       "location": "path",
	//       "pattern": "^labels/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "useAdminAccess": {
	//       "description": "Set to `true` in order to use the user's admin credentials. The server verifies that the user is an admin for the label before allowing access.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "view": {
	//       "description": "When specified, only certain fields belonging to the indicated view are returned.",
	//       "enum": [
	//         "LABEL_VIEW_BASIC",
	//         "LABEL_VIEW_FULL"
	//       ],
	//       "enumDescriptions": [
	//         "Implies the field mask: `name,id,revision_id,label_type,properties.*`",
	//         "All possible fields."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+name}",
	//   "response": {
	//     "$ref": "GoogleAppsDriveLabelsV2Label"
	//   }
	// }

}

// method id "drivelabels.labels.list":

type LabelsListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List labels.
func (r *LabelsService) List() *LabelsListCall {
	c := &LabelsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// LanguageCode sets the optional parameter "languageCode": The BCP-47
// language code to use for evaluating localized field labels. When not
// specified, values in the default configured language are used.
func (c *LabelsListCall) LanguageCode(languageCode string) *LabelsListCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// MinimumRole sets the optional parameter "minimumRole": Specifies the
// level of access the user must have on the returned Labels. The
// minimum role a user must have on a label. Defaults to `READER`.
//
// Possible values:
//
//	"LABEL_ROLE_UNSPECIFIED" - Unknown role.
//	"READER" - A reader can read the label and associated metadata
//
// applied to Drive items.
//
//	"APPLIER" - An applier can write associated metadata on Drive items
//
// in which they also have write access to. Implies `READER`.
//
//	"ORGANIZER" - An organizer can pin this label in shared drives they
//
// manage and add new appliers to the label.
//
//	"EDITOR" - Editors can make any update including deleting the label
//
// which also deletes the associated Drive item metadata. Implies
// `APPLIER`.
func (c *LabelsListCall) MinimumRole(minimumRole string) *LabelsListCall {
	c.urlParams_.Set("minimumRole", minimumRole)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// labels to return per page. Default: 50. Max: 200.
func (c *LabelsListCall) PageSize(pageSize int64) *LabelsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The token of the
// page to return.
func (c *LabelsListCall) PageToken(pageToken string) *LabelsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// PublishedOnly sets the optional parameter "publishedOnly": Whether to
// include only published labels in the results. * When `true`, only the
// current published label revisions are returned. Disabled labels are
// included. Returned label resource names reference the published
// revision (`labels/{id}/{revision_id}`). * When `false`, the current
// label revisions are returned, which might not be published. Returned
// label resource names don't reference a specific revision
// (`labels/{id}`).
func (c *LabelsListCall) PublishedOnly(publishedOnly bool) *LabelsListCall {
	c.urlParams_.Set("publishedOnly", fmt.Sprint(publishedOnly))
	return c
}

// UseAdminAccess sets the optional parameter "useAdminAccess": Set to
// `true` in order to use the user's admin credentials. This will return
// all Labels within the customer.
func (c *LabelsListCall) UseAdminAccess(useAdminAccess bool) *LabelsListCall {
	c.urlParams_.Set("useAdminAccess", fmt.Sprint(useAdminAccess))
	return c
}

// View sets the optional parameter "view": When specified, only certain
// fields belonging to the indicated view are returned.
//
// Possible values:
//
//	"LABEL_VIEW_BASIC" - Implies the field mask:
//
// `name,id,revision_id,label_type,properties.*`
//
//	"LABEL_VIEW_FULL" - All possible fields.
func (c *LabelsListCall) View(view string) *LabelsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *LabelsListCall) Fields(s ...googleapi.Field) *LabelsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *LabelsListCall) IfNoneMatch(entityTag string) *LabelsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *LabelsListCall) Context(ctx context.Context) *LabelsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *LabelsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LabelsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/labels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "drivelabels.labels.list" call.
// Exactly one of *GoogleAppsDriveLabelsV2ListLabelsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAppsDriveLabelsV2ListLabelsResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *LabelsListCall) Do(opts ...googleapi.CallOption) (*GoogleAppsDriveLabelsV2ListLabelsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAppsDriveLabelsV2ListLabelsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "List labels.",
	//   "flatPath": "v2/labels",
	//   "httpMethod": "GET",
	//   "id": "drivelabels.labels.list",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "languageCode": {
	//       "description": "The BCP-47 language code to use for evaluating localized field labels. When not specified, values in the default configured language are used.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "minimumRole": {
	//       "description": "Specifies the level of access the user must have on the returned Labels. The minimum role a user must have on a label. Defaults to `READER`.",
	//       "enum": [
	//         "LABEL_ROLE_UNSPECIFIED",
	//         "READER",
	//         "APPLIER",
	//         "ORGANIZER",
	//         "EDITOR"
	//       ],
	//       "enumDescriptions": [
	//         "Unknown role.",
	//         "A reader can read the label and associated metadata applied to Drive items.",
	//         "An applier can write associated metadata on Drive items in which they also have write access to. Implies `READER`.",
	//         "An organizer can pin this label in shared drives they manage and add new appliers to the label.",
	//         "Editors can make any update including deleting the label which also deletes the associated Drive item metadata. Implies `APPLIER`."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Maximum number of labels to return per page. Default: 50. Max: 200.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The token of the page to return.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "publishedOnly": {
	//       "description": "Whether to include only published labels in the results. * When `true`, only the current published label revisions are returned. Disabled labels are included. Returned label resource names reference the published revision (`labels/{id}/{revision_id}`). * When `false`, the current label revisions are returned, which might not be published. Returned label resource names don't reference a specific revision (`labels/{id}`).",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "useAdminAccess": {
	//       "description": "Set to `true` in order to use the user's admin credentials. This will return all Labels within the customer.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "view": {
	//       "description": "When specified, only certain fields belonging to the indicated view are returned.",
	//       "enum": [
	//         "LABEL_VIEW_BASIC",
	//         "LABEL_VIEW_FULL"
	//       ],
	//       "enumDescriptions": [
	//         "Implies the field mask: `name,id,revision_id,label_type,properties.*`",
	//         "All possible fields."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/labels",
	//   "response": {
	//     "$ref": "GoogleAppsDriveLabelsV2ListLabelsResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *LabelsListCall) Pages(ctx context.Context, f func(*GoogleAppsDriveLabelsV2ListLabelsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
