/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtpserver;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import net.sf.gogui.utils.Options;
import net.sf.gogui.utils.ProcessUtils;
import net.sf.gogui.utils.StreamCopy;
import net.sf.gogui.utils.StringUtils;
import net.sf.gogui.version.Version;

public final class GtpServer {
    public GtpServer(boolean bl, boolean bl2, String string, String string2, int n, String string3) throws Exception {
        Runtime runtime = Runtime.getRuntime();
        ServerSocket serverSocket = null;
        if (string2 == null) {
            serverSocket = new ServerSocket(n, 1);
        }
        do {
            Socket socket;
            Process process = runtime.exec(StringUtils.splitArguments(string));
            ProcessUtils.StdErrThread stdErrThread = new ProcessUtils.StdErrThread(process);
            stdErrThread.start();
            if (serverSocket == null) {
                socket = GtpServer.connectToRemote(string2, n, string3);
            } else {
                if (bl) {
                    System.err.println("Waiting for connection...");
                }
                socket = serverSocket.accept();
            }
            if (bl) {
                System.err.println("gtpserver: Connected with " + socket.getInetAddress());
            }
            Thread thread = new Thread(new StreamCopy(bl, socket.getInputStream(), process.getOutputStream(), true));
            Thread thread2 = new Thread(new StreamCopy(bl, process.getInputStream(), socket.getOutputStream(), false));
            thread.start();
            thread2.start();
            thread2.join();
            socket.shutdownOutput();
            thread.join();
            socket.close();
            process.waitFor();
        } while (string2 == null && bl2);
        if (serverSocket != null) {
            serverSocket.close();
        }
    }

    public static void main(String[] stringArray) {
        try {
            ArrayList arrayList;
            String[] stringArray2 = new String[]{"config:", "help", "loop", "port:", "remote:", "user:", "verbose", "version"};
            Options options = Options.parse(stringArray, stringArray2);
            boolean bl = options.isSet("verbose");
            boolean bl2 = options.isSet("loop");
            if (bl2 && options.isSet("remote")) {
                System.err.println("Option -loop can't be used with -remote");
                System.exit(-1);
            }
            if (options.isSet("help")) {
                GtpServer.printUsage(System.out);
                return;
            }
            if (options.isSet("version")) {
                System.out.println("GtpServer " + Version.get());
                return;
            }
            if (!options.isSet("port")) {
                System.err.println("Please specify port with option -port");
                System.exit(-1);
            }
            int n = options.getInteger("port");
            String string = options.getString("remote", null);
            String string2 = options.getString("user", null);
            if (string2 != null && string == null) {
                System.err.println("Option -user only valid with -remote");
                System.exit(-1);
            }
            if ((arrayList = options.getArguments()).size() != 1) {
                GtpServer.printUsage(System.err);
                System.exit(-1);
            }
            String string3 = (String)arrayList.get(0);
            new GtpServer(bl, bl2, string3, string, n, string2);
        }
        catch (Throwable throwable) {
            StringUtils.printException(throwable);
            System.exit(-1);
        }
    }

    private static Socket connectToRemote(String string, int n, String string2) throws Exception {
        System.err.println("Connecting to " + string + " " + n);
        Socket socket = new Socket(string, n);
        if (string2 != null) {
            int n2;
            System.err.println("Sending login information from file " + string2);
            FileInputStream fileInputStream = new FileInputStream(new File(string2));
            OutputStream outputStream = socket.getOutputStream();
            byte[] byArray = new byte[1024];
            while ((n2 = ((InputStream)fileInputStream).read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n2);
            }
            ((InputStream)fileInputStream).close();
        }
        System.err.println("Connected");
        return socket;
    }

    private static void printUsage(PrintStream printStream) {
        printStream.print("Usage: java -jar gtpserver.jar [options] program\n\n-config  config file\n-help    display this help and exit\n-loop    restart after connection finished\n-port    port of network connection\n-remote  connect to remote host\n-user    login information for remote host\n-verbose print debugging messages\n-version print version and exit\n");
    }
}

