package uniseg

// Code generated via go generate from gen_properties.go. DO NOT EDIT.

// sentenceBreakCodePoints are taken from
// https://www.unicode.org/Public/14.0.0/ucd/auxiliary/SentenceBreakProperty.txt
// on July 25, 2022. See https://www.unicode.org/license.html for the Unicode
// license agreement.
var sentenceBreakCodePoints = [][3]int{
	{0x0009, 0x0009, prSp},        // Cc       <control-0009>
	{0x000A, 0x000A, prLF},        // Cc       <control-000A>
	{0x000B, 0x000C, prSp},        // Cc   [2] <control-000B>..<control-000C>
	{0x000D, 0x000D, prCR},        // Cc       <control-000D>
	{0x0020, 0x0020, prSp},        // Zs       SPACE
	{0x0021, 0x0021, prSTerm},     // Po       EXCLAMATION MARK
	{0x0022, 0x0022, prClose},     // Po       QUOTATION MARK
	{0x0027, 0x0027, prClose},     // Po       APOSTROPHE
	{0x0028, 0x0028, prClose},     // Ps       LEFT PARENTHESIS
	{0x0029, 0x0029, prClose},     // Pe       RIGHT PARENTHESIS
	{0x002C, 0x002C, prSContinue}, // Po       COMMA
	{0x002D, 0x002D, prSContinue}, // Pd       HYPHEN-MINUS
	{0x002E, 0x002E, prATerm},     // Po       FULL STOP
	{0x0030, 0x0039, prNumeric},   // Nd  [10] DIGIT ZERO..DIGIT NINE
	{0x003A, 0x003A, prSContinue}, // Po       COLON
	{0x003F, 0x003F, prSTerm},     // Po       QUESTION MARK
	{0x0041, 0x005A, prUpper},     // L&  [26] LATIN CAPITAL LETTER A..LATIN CAPITAL LETTER Z
	{0x005B, 0x005B, prClose},     // Ps       LEFT SQUARE BRACKET
	{0x005D, 0x005D, prClose},     // Pe       RIGHT SQUARE BRACKET
	{0x0061, 0x007A, prLower},     // L&  [26] LATIN SMALL LETTER A..LATIN SMALL LETTER Z
	{0x007B, 0x007B, prClose},     // Ps       LEFT CURLY BRACKET
	{0x007D, 0x007D, prClose},     // Pe       RIGHT CURLY BRACKET
	{0x0085, 0x0085, prSep},       // Cc       <control-0085>
	{0x00A0, 0x00A0, prSp},        // Zs       NO-BREAK SPACE
	{0x00AA, 0x00AA, prLower},     // Lo       FEMININE ORDINAL INDICATOR
	{0x00AB, 0x00AB, prClose},     // Pi       LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
	{0x00AD, 0x00AD, prFormat},    // Cf       SOFT HYPHEN
	{0x00B5, 0x00B5, prLower},     // L&       MICRO SIGN
	{0x00BA, 0x00BA, prLower},     // Lo       MASCULINE ORDINAL INDICATOR
	{0x00BB, 0x00BB, prClose},     // Pf       RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
	{0x00C0, 0x00D6, prUpper},     // L&  [23] LATIN CAPITAL LETTER A WITH GRAVE..LATIN CAPITAL LETTER O WITH DIAERESIS
	{0x00D8, 0x00DE, prUpper},     // L&   [7] LATIN CAPITAL LETTER O WITH STROKE..LATIN CAPITAL LETTER THORN
	{0x00DF, 0x00F6, prLower},     // L&  [24] LATIN SMALL LETTER SHARP S..LATIN SMALL LETTER O WITH DIAERESIS
	{0x00F8, 0x00FF, prLower},     // L&   [8] LATIN SMALL LETTER O WITH STROKE..LATIN SMALL LETTER Y WITH DIAERESIS
	{0x0100, 0x0100, prUpper},     // L&       LATIN CAPITAL LETTER A WITH MACRON
	{0x0101, 0x0101, prLower},     // L&       LATIN SMALL LETTER A WITH MACRON
	{0x0102, 0x0102, prUpper},     // L&       LATIN CAPITAL LETTER A WITH BREVE
	{0x0103, 0x0103, prLower},     // L&       LATIN SMALL LETTER A WITH BREVE
	{0x0104, 0x0104, prUpper},     // L&       LATIN CAPITAL LETTER A WITH OGONEK
	{0x0105, 0x0105, prLower},     // L&       LATIN SMALL LETTER A WITH OGONEK
	{0x0106, 0x0106, prUpper},     // L&       LATIN CAPITAL LETTER C WITH ACUTE
	{0x0107, 0x0107, prLower},     // L&       LATIN SMALL LETTER C WITH ACUTE
	{0x0108, 0x0108, prUpper},     // L&       LATIN CAPITAL LETTER C WITH CIRCUMFLEX
	{0x0109, 0x0109, prLower},     // L&       LATIN SMALL LETTER C WITH CIRCUMFLEX
	{0x010A, 0x010A, prUpper},     // L&       LATIN CAPITAL LETTER C WITH DOT ABOVE
	{0x010B, 0x010B, prLower},     // L&       LATIN SMALL LETTER C WITH DOT ABOVE
	{0x010C, 0x010C, prUpper},     // L&       LATIN CAPITAL LETTER C WITH CARON
	{0x010D, 0x010D, prLower},     // L&       LATIN SMALL LETTER C WITH CARON
	{0x010E, 0x010E, prUpper},     // L&       LATIN CAPITAL LETTER D WITH CARON
	{0x010F, 0x010F, prLower},     // L&       LATIN SMALL LETTER D WITH CARON
	{0x0110, 0x0110, prUpper},     // L&       LATIN CAPITAL LETTER D WITH STROKE
	{0x0111, 0x0111, prLower},     // L&       LATIN SMALL LETTER D WITH STROKE
	{0x0112, 0x0112, prUpper},     // L&       LATIN CAPITAL LETTER E WITH MACRON
	{0x0113, 0x0113, prLower},     // L&       LATIN SMALL LETTER E WITH MACRON
	{0x0114, 0x0114, prUpper},     // L&       LATIN CAPITAL LETTER E WITH BREVE
	{0x0115, 0x0115, prLower},     // L&       LATIN SMALL LETTER E WITH BREVE
	{0x0116, 0x0116, prUpper},     // L&       LATIN CAPITAL LETTER E WITH DOT ABOVE
	{0x0117, 0x0117, prLower},     // L&       LATIN SMALL LETTER E WITH DOT ABOVE
	{0x0118, 0x0118, prUpper},     // L&       LATIN CAPITAL LETTER E WITH OGONEK
	{0x0119, 0x0119, prLower},     // L&       LATIN SMALL LETTER E WITH OGONEK
	{0x011A, 0x011A, prUpper},     // L&       LATIN CAPITAL LETTER E WITH CARON
	{0x011B, 0x011B, prLower},     // L&       LATIN SMALL LETTER E WITH CARON
	{0x011C, 0x011C, prUpper},     // L&       LATIN CAPITAL LETTER G WITH CIRCUMFLEX
	{0x011D, 0x011D, prLower},     // L&       LATIN SMALL LETTER G WITH CIRCUMFLEX
	{0x011E, 0x011E, prUpper},     // L&       LATIN CAPITAL LETTER G WITH BREVE
	{0x011F, 0x011F, prLower},     // L&       LATIN SMALL LETTER G WITH BREVE
	{0x0120, 0x0120, prUpper},     // L&       LATIN CAPITAL LETTER G WITH DOT ABOVE
	{0x0121, 0x0121, prLower},     // L&       LATIN SMALL LETTER G WITH DOT ABOVE
	{0x0122, 0x0122, prUpper},     // L&       LATIN CAPITAL LETTER G WITH CEDILLA
	{0x0123, 0x0123, prLower},     // L&       LATIN SMALL LETTER G WITH CEDILLA
	{0x0124, 0x0124, prUpper},     // L&       LATIN CAPITAL LETTER H WITH CIRCUMFLEX
	{0x0125, 0x0125, prLower},     // L&       LATIN SMALL LETTER H WITH CIRCUMFLEX
	{0x0126, 0x0126, prUpper},     // L&       LATIN CAPITAL LETTER H WITH STROKE
	{0x0127, 0x0127, prLower},     // L&       LATIN SMALL LETTER H WITH STROKE
	{0x0128, 0x0128, prUpper},     // L&       LATIN CAPITAL LETTER I WITH TILDE
	{0x0129, 0x0129, prLower},     // L&       LATIN SMALL LETTER I WITH TILDE
	{0x012A, 0x012A, prUpper},     // L&       LATIN CAPITAL LETTER I WITH MACRON
	{0x012B, 0x012B, prLower},     // L&       LATIN SMALL LETTER I WITH MACRON
	{0x012C, 0x012C, prUpper},     // L&       LATIN CAPITAL LETTER I WITH BREVE
	{0x012D, 0x012D, prLower},     // L&       LATIN SMALL LETTER I WITH BREVE
	{0x012E, 0x012E, prUpper},     // L&       LATIN CAPITAL LETTER I WITH OGONEK
	{0x012F, 0x012F, prLower},     // L&       LATIN SMALL LETTER I WITH OGONEK
	{0x0130, 0x0130, prUpper},     // L&       LATIN CAPITAL LETTER I WITH DOT ABOVE
	{0x0131, 0x0131, prLower},     // L&       LATIN SMALL LETTER DOTLESS I
	{0x0132, 0x0132, prUpper},     // L&       LATIN CAPITAL LIGATURE IJ
	{0x0133, 0x0133, prLower},     // L&       LATIN SMALL LIGATURE IJ
	{0x0134, 0x0134, prUpper},     // L&       LATIN CAPITAL LETTER J WITH CIRCUMFLEX
	{0x0135, 0x0135, prLower},     // L&       LATIN SMALL LETTER J WITH CIRCUMFLEX
	{0x0136, 0x0136, prUpper},     // L&       LATIN CAPITAL LETTER K WITH CEDILLA
	{0x0137, 0x0138, prLower},     // L&   [2] LATIN SMALL LETTER K WITH CEDILLA..LATIN SMALL LETTER KRA
	{0x0139, 0x0139, prUpper},     // L&       LATIN CAPITAL LETTER L WITH ACUTE
	{0x013A, 0x013A, prLower},     // L&       LATIN SMALL LETTER L WITH ACUTE
	{0x013B, 0x013B, prUpper},     // L&       LATIN CAPITAL LETTER L WITH CEDILLA
	{0x013C, 0x013C, prLower},     // L&       LATIN SMALL LETTER L WITH CEDILLA
	{0x013D, 0x013D, prUpper},     // L&       LATIN CAPITAL LETTER L WITH CARON
	{0x013E, 0x013E, prLower},     // L&       LATIN SMALL LETTER L WITH CARON
	{0x013F, 0x013F, prUpper},     // L&       LATIN CAPITAL LETTER L WITH MIDDLE DOT
	{0x0140, 0x0140, prLower},     // L&       LATIN SMALL LETTER L WITH MIDDLE DOT
	{0x0141, 0x0141, prUpper},     // L&       LATIN CAPITAL LETTER L WITH STROKE
	{0x0142, 0x0142, prLower},     // L&       LATIN SMALL LETTER L WITH STROKE
	{0x0143, 0x0143, prUpper},     // L&       LATIN CAPITAL LETTER N WITH ACUTE
	{0x0144, 0x0144, prLower},     // L&       LATIN SMALL LETTER N WITH ACUTE
	{0x0145, 0x0145, prUpper},     // L&       LATIN CAPITAL LETTER N WITH CEDILLA
	{0x0146, 0x0146, prLower},     // L&       LATIN SMALL LETTER N WITH CEDILLA
	{0x0147, 0x0147, prUpper},     // L&       LATIN CAPITAL LETTER N WITH CARON
	{0x0148, 0x0149, prLower},     // L&   [2] LATIN SMALL LETTER N WITH CARON..LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
	{0x014A, 0x014A, prUpper},     // L&       LATIN CAPITAL LETTER ENG
	{0x014B, 0x014B, prLower},     // L&       LATIN SMALL LETTER ENG
	{0x014C, 0x014C, prUpper},     // L&       LATIN CAPITAL LETTER O WITH MACRON
	{0x014D, 0x014D, prLower},     // L&       LATIN SMALL LETTER O WITH MACRON
	{0x014E, 0x014E, prUpper},     // L&       LATIN CAPITAL LETTER O WITH BREVE
	{0x014F, 0x014F, prLower},     // L&       LATIN SMALL LETTER O WITH BREVE
	{0x0150, 0x0150, prUpper},     // L&       LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
	{0x0151, 0x0151, prLower},     // L&       LATIN SMALL LETTER O WITH DOUBLE ACUTE
	{0x0152, 0x0152, prUpper},     // L&       LATIN CAPITAL LIGATURE OE
	{0x0153, 0x0153, prLower},     // L&       LATIN SMALL LIGATURE OE
	{0x0154, 0x0154, prUpper},     // L&       LATIN CAPITAL LETTER R WITH ACUTE
	{0x0155, 0x0155, prLower},     // L&       LATIN SMALL LETTER R WITH ACUTE
	{0x0156, 0x0156, prUpper},     // L&       LATIN CAPITAL LETTER R WITH CEDILLA
	{0x0157, 0x0157, prLower},     // L&       LATIN SMALL LETTER R WITH CEDILLA
	{0x0158, 0x0158, prUpper},     // L&       LATIN CAPITAL LETTER R WITH CARON
	{0x0159, 0x0159, prLower},     // L&       LATIN SMALL LETTER R WITH CARON
	{0x015A, 0x015A, prUpper},     // L&       LATIN CAPITAL LETTER S WITH ACUTE
	{0x015B, 0x015B, prLower},     // L&       LATIN SMALL LETTER S WITH ACUTE
	{0x015C, 0x015C, prUpper},     // L&       LATIN CAPITAL LETTER S WITH CIRCUMFLEX
	{0x015D, 0x015D, prLower},     // L&       LATIN SMALL LETTER S WITH CIRCUMFLEX
	{0x015E, 0x015E, prUpper},     // L&       LATIN CAPITAL LETTER S WITH CEDILLA
	{0x015F, 0x015F, prLower},     // L&       LATIN SMALL LETTER S WITH CEDILLA
	{0x0160, 0x0160, prUpper},     // L&       LATIN CAPITAL LETTER S WITH CARON
	{0x0161, 0x0161, prLower},     // L&       LATIN SMALL LETTER S WITH CARON
	{0x0162, 0x0162, prUpper},     // L&       LATIN CAPITAL LETTER T WITH CEDILLA
	{0x0163, 0x0163, prLower},     // L&       LATIN SMALL LETTER T WITH CEDILLA
	{0x0164, 0x0164, prUpper},     // L&       LATIN CAPITAL LETTER T WITH CARON
	{0x0165, 0x0165, prLower},     // L&       LATIN SMALL LETTER T WITH CARON
	{0x0166, 0x0166, prUpper},     // L&       LATIN CAPITAL LETTER T WITH STROKE
	{0x0167, 0x0167, prLower},     // L&       LATIN SMALL LETTER T WITH STROKE
	{0x0168, 0x0168, prUpper},     // L&       LATIN CAPITAL LETTER U WITH TILDE
	{0x0169, 0x0169, prLower},     // L&       LATIN SMALL LETTER U WITH TILDE
	{0x016A, 0x016A, prUpper},     // L&       LATIN CAPITAL LETTER U WITH MACRON
	{0x016B, 0x016B, prLower},     // L&       LATIN SMALL LETTER U WITH MACRON
	{0x016C, 0x016C, prUpper},     // L&       LATIN CAPITAL LETTER U WITH BREVE
	{0x016D, 0x016D, prLower},     // L&       LATIN SMALL LETTER U WITH BREVE
	{0x016E, 0x016E, prUpper},     // L&       LATIN CAPITAL LETTER U WITH RING ABOVE
	{0x016F, 0x016F, prLower},     // L&       LATIN SMALL LETTER U WITH RING ABOVE
	{0x0170, 0x0170, prUpper},     // L&       LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
	{0x0171, 0x0171, prLower},     // L&       LATIN SMALL LETTER U WITH DOUBLE ACUTE
	{0x0172, 0x0172, prUpper},     // L&       LATIN CAPITAL LETTER U WITH OGONEK
	{0x0173, 0x0173, prLower},     // L&       LATIN SMALL LETTER U WITH OGONEK
	{0x0174, 0x0174, prUpper},     // L&       LATIN CAPITAL LETTER W WITH CIRCUMFLEX
	{0x0175, 0x0175, prLower},     // L&       LATIN SMALL LETTER W WITH CIRCUMFLEX
	{0x0176, 0x0176, prUpper},     // L&       LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
	{0x0177, 0x0177, prLower},     // L&       LATIN SMALL LETTER Y WITH CIRCUMFLEX
	{0x0178, 0x0179, prUpper},     // L&   [2] LATIN CAPITAL LETTER Y WITH DIAERESIS..LATIN CAPITAL LETTER Z WITH ACUTE
	{0x017A, 0x017A, prLower},     // L&       LATIN SMALL LETTER Z WITH ACUTE
	{0x017B, 0x017B, prUpper},     // L&       LATIN CAPITAL LETTER Z WITH DOT ABOVE
	{0x017C, 0x017C, prLower},     // L&       LATIN SMALL LETTER Z WITH DOT ABOVE
	{0x017D, 0x017D, prUpper},     // L&       LATIN CAPITAL LETTER Z WITH CARON
	{0x017E, 0x0180, prLower},     // L&   [3] LATIN SMALL LETTER Z WITH CARON..LATIN SMALL LETTER B WITH STROKE
	{0x0181, 0x0182, prUpper},     // L&   [2] LATIN CAPITAL LETTER B WITH HOOK..LATIN CAPITAL LETTER B WITH TOPBAR
	{0x0183, 0x0183, prLower},     // L&       LATIN SMALL LETTER B WITH TOPBAR
	{0x0184, 0x0184, prUpper},     // L&       LATIN CAPITAL LETTER TONE SIX
	{0x0185, 0x0185, prLower},     // L&       LATIN SMALL LETTER TONE SIX
	{0x0186, 0x0187, prUpper},     // L&   [2] LATIN CAPITAL LETTER OPEN O..LATIN CAPITAL LETTER C WITH HOOK
	{0x0188, 0x0188, prLower},     // L&       LATIN SMALL LETTER C WITH HOOK
	{0x0189, 0x018B, prUpper},     // L&   [3] LATIN CAPITAL LETTER AFRICAN D..LATIN CAPITAL LETTER D WITH TOPBAR
	{0x018C, 0x018D, prLower},     // L&   [2] LATIN SMALL LETTER D WITH TOPBAR..LATIN SMALL LETTER TURNED DELTA
	{0x018E, 0x0191, prUpper},     // L&   [4] LATIN CAPITAL LETTER REVERSED E..LATIN CAPITAL LETTER F WITH HOOK
	{0x0192, 0x0192, prLower},     // L&       LATIN SMALL LETTER F WITH HOOK
	{0x0193, 0x0194, prUpper},     // L&   [2] LATIN CAPITAL LETTER G WITH HOOK..LATIN CAPITAL LETTER GAMMA
	{0x0195, 0x0195, prLower},     // L&       LATIN SMALL LETTER HV
	{0x0196, 0x0198, prUpper},     // L&   [3] LATIN CAPITAL LETTER IOTA..LATIN CAPITAL LETTER K WITH HOOK
	{0x0199, 0x019B, prLower},     // L&   [3] LATIN SMALL LETTER K WITH HOOK..LATIN SMALL LETTER LAMBDA WITH STROKE
	{0x019C, 0x019D, prUpper},     // L&   [2] LATIN CAPITAL LETTER TURNED M..LATIN CAPITAL LETTER N WITH LEFT HOOK
	{0x019E, 0x019E, prLower},     // L&       LATIN SMALL LETTER N WITH LONG RIGHT LEG
	{0x019F, 0x01A0, prUpper},     // L&   [2] LATIN CAPITAL LETTER O WITH MIDDLE TILDE..LATIN CAPITAL LETTER O WITH HORN
	{0x01A1, 0x01A1, prLower},     // L&       LATIN SMALL LETTER O WITH HORN
	{0x01A2, 0x01A2, prUpper},     // L&       LATIN CAPITAL LETTER OI
	{0x01A3, 0x01A3, prLower},     // L&       LATIN SMALL LETTER OI
	{0x01A4, 0x01A4, prUpper},     // L&       LATIN CAPITAL LETTER P WITH HOOK
	{0x01A5, 0x01A5, prLower},     // L&       LATIN SMALL LETTER P WITH HOOK
	{0x01A6, 0x01A7, prUpper},     // L&   [2] LATIN LETTER YR..LATIN CAPITAL LETTER TONE TWO
	{0x01A8, 0x01A8, prLower},     // L&       LATIN SMALL LETTER TONE TWO
	{0x01A9, 0x01A9, prUpper},     // L&       LATIN CAPITAL LETTER ESH
	{0x01AA, 0x01AB, prLower},     // L&   [2] LATIN LETTER REVERSED ESH LOOP..LATIN SMALL LETTER T WITH PALATAL HOOK
	{0x01AC, 0x01AC, prUpper},     // L&       LATIN CAPITAL LETTER T WITH HOOK
	{0x01AD, 0x01AD, prLower},     // L&       LATIN SMALL LETTER T WITH HOOK
	{0x01AE, 0x01AF, prUpper},     // L&   [2] LATIN CAPITAL LETTER T WITH RETROFLEX HOOK..LATIN CAPITAL LETTER U WITH HORN
	{0x01B0, 0x01B0, prLower},     // L&       LATIN SMALL LETTER U WITH HORN
	{0x01B1, 0x01B3, prUpper},     // L&   [3] LATIN CAPITAL LETTER UPSILON..LATIN CAPITAL LETTER Y WITH HOOK
	{0x01B4, 0x01B4, prLower},     // L&       LATIN SMALL LETTER Y WITH HOOK
	{0x01B5, 0x01B5, prUpper},     // L&       LATIN CAPITAL LETTER Z WITH STROKE
	{0x01B6, 0x01B6, prLower},     // L&       LATIN SMALL LETTER Z WITH STROKE
	{0x01B7, 0x01B8, prUpper},     // L&   [2] LATIN CAPITAL LETTER EZH..LATIN CAPITAL LETTER EZH REVERSED
	{0x01B9, 0x01BA, prLower},     // L&   [2] LATIN SMALL LETTER EZH REVERSED..LATIN SMALL LETTER EZH WITH TAIL
	{0x01BB, 0x01BB, prOLetter},   // Lo       LATIN LETTER TWO WITH STROKE
	{0x01BC, 0x01BC, prUpper},     // L&       LATIN CAPITAL LETTER TONE FIVE
	{0x01BD, 0x01BF, prLower},     // L&   [3] LATIN SMALL LETTER TONE FIVE..LATIN LETTER WYNN
	{0x01C0, 0x01C3, prOLetter},   // Lo   [4] LATIN LETTER DENTAL CLICK..LATIN LETTER RETROFLEX CLICK
	{0x01C4, 0x01C5, prUpper},     // L&   [2] LATIN CAPITAL LETTER DZ WITH CARON..LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
	{0x01C6, 0x01C6, prLower},     // L&       LATIN SMALL LETTER DZ WITH CARON
	{0x01C7, 0x01C8, prUpper},     // L&   [2] LATIN CAPITAL LETTER LJ..LATIN CAPITAL LETTER L WITH SMALL LETTER J
	{0x01C9, 0x01C9, prLower},     // L&       LATIN SMALL LETTER LJ
	{0x01CA, 0x01CB, prUpper},     // L&   [2] LATIN CAPITAL LETTER NJ..LATIN CAPITAL LETTER N WITH SMALL LETTER J
	{0x01CC, 0x01CC, prLower},     // L&       LATIN SMALL LETTER NJ
	{0x01CD, 0x01CD, prUpper},     // L&       LATIN CAPITAL LETTER A WITH CARON
	{0x01CE, 0x01CE, prLower},     // L&       LATIN SMALL LETTER A WITH CARON
	{0x01CF, 0x01CF, prUpper},     // L&       LATIN CAPITAL LETTER I WITH CARON
	{0x01D0, 0x01D0, prLower},     // L&       LATIN SMALL LETTER I WITH CARON
	{0x01D1, 0x01D1, prUpper},     // L&       LATIN CAPITAL LETTER O WITH CARON
	{0x01D2, 0x01D2, prLower},     // L&       LATIN SMALL LETTER O WITH CARON
	{0x01D3, 0x01D3, prUpper},     // L&       LATIN CAPITAL LETTER U WITH CARON
	{0x01D4, 0x01D4, prLower},     // L&       LATIN SMALL LETTER U WITH CARON
	{0x01D5, 0x01D5, prUpper},     // L&       LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
	{0x01D6, 0x01D6, prLower},     // L&       LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
	{0x01D7, 0x01D7, prUpper},     // L&       LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
	{0x01D8, 0x01D8, prLower},     // L&       LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
	{0x01D9, 0x01D9, prUpper},     // L&       LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
	{0x01DA, 0x01DA, prLower},     // L&       LATIN SMALL LETTER U WITH DIAERESIS AND CARON
	{0x01DB, 0x01DB, prUpper},     // L&       LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
	{0x01DC, 0x01DD, prLower},     // L&   [2] LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE..LATIN SMALL LETTER TURNED E
	{0x01DE, 0x01DE, prUpper},     // L&       LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
	{0x01DF, 0x01DF, prLower},     // L&       LATIN SMALL LETTER A WITH DIAERESIS AND MACRON
	{0x01E0, 0x01E0, prUpper},     // L&       LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
	{0x01E1, 0x01E1, prLower},     // L&       LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON
	{0x01E2, 0x01E2, prUpper},     // L&       LATIN CAPITAL LETTER AE WITH MACRON
	{0x01E3, 0x01E3, prLower},     // L&       LATIN SMALL LETTER AE WITH MACRON
	{0x01E4, 0x01E4, prUpper},     // L&       LATIN CAPITAL LETTER G WITH STROKE
	{0x01E5, 0x01E5, prLower},     // L&       LATIN SMALL LETTER G WITH STROKE
	{0x01E6, 0x01E6, prUpper},     // L&       LATIN CAPITAL LETTER G WITH CARON
	{0x01E7, 0x01E7, prLower},     // L&       LATIN SMALL LETTER G WITH CARON
	{0x01E8, 0x01E8, prUpper},     // L&       LATIN CAPITAL LETTER K WITH CARON
	{0x01E9, 0x01E9, prLower},     // L&       LATIN SMALL LETTER K WITH CARON
	{0x01EA, 0x01EA, prUpper},     // L&       LATIN CAPITAL LETTER O WITH OGONEK
	{0x01EB, 0x01EB, prLower},     // L&       LATIN SMALL LETTER O WITH OGONEK
	{0x01EC, 0x01EC, prUpper},     // L&       LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
	{0x01ED, 0x01ED, prLower},     // L&       LATIN SMALL LETTER O WITH OGONEK AND MACRON
	{0x01EE, 0x01EE, prUpper},     // L&       LATIN CAPITAL LETTER EZH WITH CARON
	{0x01EF, 0x01F0, prLower},     // L&   [2] LATIN SMALL LETTER EZH WITH CARON..LATIN SMALL LETTER J WITH CARON
	{0x01F1, 0x01F2, prUpper},     // L&   [2] LATIN CAPITAL LETTER DZ..LATIN CAPITAL LETTER D WITH SMALL LETTER Z
	{0x01F3, 0x01F3, prLower},     // L&       LATIN SMALL LETTER DZ
	{0x01F4, 0x01F4, prUpper},     // L&       LATIN CAPITAL LETTER G WITH ACUTE
	{0x01F5, 0x01F5, prLower},     // L&       LATIN SMALL LETTER G WITH ACUTE
	{0x01F6, 0x01F8, prUpper},     // L&   [3] LATIN CAPITAL LETTER HWAIR..LATIN CAPITAL LETTER N WITH GRAVE
	{0x01F9, 0x01F9, prLower},     // L&       LATIN SMALL LETTER N WITH GRAVE
	{0x01FA, 0x01FA, prUpper},     // L&       LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
	{0x01FB, 0x01FB, prLower},     // L&       LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
	{0x01FC, 0x01FC, prUpper},     // L&       LATIN CAPITAL LETTER AE WITH ACUTE
	{0x01FD, 0x01FD, prLower},     // L&       LATIN SMALL LETTER AE WITH ACUTE
	{0x01FE, 0x01FE, prUpper},     // L&       LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
	{0x01FF, 0x01FF, prLower},     // L&       LATIN SMALL LETTER O WITH STROKE AND ACUTE
	{0x0200, 0x0200, prUpper},     // L&       LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
	{0x0201, 0x0201, prLower},     // L&       LATIN SMALL LETTER A WITH DOUBLE GRAVE
	{0x0202, 0x0202, prUpper},     // L&       LATIN CAPITAL LETTER A WITH INVERTED BREVE
	{0x0203, 0x0203, prLower},     // L&       LATIN SMALL LETTER A WITH INVERTED BREVE
	{0x0204, 0x0204, prUpper},     // L&       LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
	{0x0205, 0x0205, prLower},     // L&       LATIN SMALL LETTER E WITH DOUBLE GRAVE
	{0x0206, 0x0206, prUpper},     // L&       LATIN CAPITAL LETTER E WITH INVERTED BREVE
	{0x0207, 0x0207, prLower},     // L&       LATIN SMALL LETTER E WITH INVERTED BREVE
	{0x0208, 0x0208, prUpper},     // L&       LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
	{0x0209, 0x0209, prLower},     // L&       LATIN SMALL LETTER I WITH DOUBLE GRAVE
	{0x020A, 0x020A, prUpper},     // L&       LATIN CAPITAL LETTER I WITH INVERTED BREVE
	{0x020B, 0x020B, prLower},     // L&       LATIN SMALL LETTER I WITH INVERTED BREVE
	{0x020C, 0x020C, prUpper},     // L&       LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
	{0x020D, 0x020D, prLower},     // L&       LATIN SMALL LETTER O WITH DOUBLE GRAVE
	{0x020E, 0x020E, prUpper},     // L&       LATIN CAPITAL LETTER O WITH INVERTED BREVE
	{0x020F, 0x020F, prLower},     // L&       LATIN SMALL LETTER O WITH INVERTED BREVE
	{0x0210, 0x0210, prUpper},     // L&       LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
	{0x0211, 0x0211, prLower},     // L&       LATIN SMALL LETTER R WITH DOUBLE GRAVE
	{0x0212, 0x0212, prUpper},     // L&       LATIN CAPITAL LETTER R WITH INVERTED BREVE
	{0x0213, 0x0213, prLower},     // L&       LATIN SMALL LETTER R WITH INVERTED BREVE
	{0x0214, 0x0214, prUpper},     // L&       LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
	{0x0215, 0x0215, prLower},     // L&       LATIN SMALL LETTER U WITH DOUBLE GRAVE
	{0x0216, 0x0216, prUpper},     // L&       LATIN CAPITAL LETTER U WITH INVERTED BREVE
	{0x0217, 0x0217, prLower},     // L&       LATIN SMALL LETTER U WITH INVERTED BREVE
	{0x0218, 0x0218, prUpper},     // L&       LATIN CAPITAL LETTER S WITH COMMA BELOW
	{0x0219, 0x0219, prLower},     // L&       LATIN SMALL LETTER S WITH COMMA BELOW
	{0x021A, 0x021A, prUpper},     // L&       LATIN CAPITAL LETTER T WITH COMMA BELOW
	{0x021B, 0x021B, prLower},     // L&       LATIN SMALL LETTER T WITH COMMA BELOW
	{0x021C, 0x021C, prUpper},     // L&       LATIN CAPITAL LETTER YOGH
	{0x021D, 0x021D, prLower},     // L&       LATIN SMALL LETTER YOGH
	{0x021E, 0x021E, prUpper},     // L&       LATIN CAPITAL LETTER H WITH CARON
	{0x021F, 0x021F, prLower},     // L&       LATIN SMALL LETTER H WITH CARON
	{0x0220, 0x0220, prUpper},     // L&       LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
	{0x0221, 0x0221, prLower},     // L&       LATIN SMALL LETTER D WITH CURL
	{0x0222, 0x0222, prUpper},     // L&       LATIN CAPITAL LETTER OU
	{0x0223, 0x0223, prLower},     // L&       LATIN SMALL LETTER OU
	{0x0224, 0x0224, prUpper},     // L&       LATIN CAPITAL LETTER Z WITH HOOK
	{0x0225, 0x0225, prLower},     // L&       LATIN SMALL LETTER Z WITH HOOK
	{0x0226, 0x0226, prUpper},     // L&       LATIN CAPITAL LETTER A WITH DOT ABOVE
	{0x0227, 0x0227, prLower},     // L&       LATIN SMALL LETTER A WITH DOT ABOVE
	{0x0228, 0x0228, prUpper},     // L&       LATIN CAPITAL LETTER E WITH CEDILLA
	{0x0229, 0x0229, prLower},     // L&       LATIN SMALL LETTER E WITH CEDILLA
	{0x022A, 0x022A, prUpper},     // L&       LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
	{0x022B, 0x022B, prLower},     // L&       LATIN SMALL LETTER O WITH DIAERESIS AND MACRON
	{0x022C, 0x022C, prUpper},     // L&       LATIN CAPITAL LETTER O WITH TILDE AND MACRON
	{0x022D, 0x022D, prLower},     // L&       LATIN SMALL LETTER O WITH TILDE AND MACRON
	{0x022E, 0x022E, prUpper},     // L&       LATIN CAPITAL LETTER O WITH DOT ABOVE
	{0x022F, 0x022F, prLower},     // L&       LATIN SMALL LETTER O WITH DOT ABOVE
	{0x0230, 0x0230, prUpper},     // L&       LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
	{0x0231, 0x0231, prLower},     // L&       LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON
	{0x0232, 0x0232, prUpper},     // L&       LATIN CAPITAL LETTER Y WITH MACRON
	{0x0233, 0x0239, prLower},     // L&   [7] LATIN SMALL LETTER Y WITH MACRON..LATIN SMALL LETTER QP DIGRAPH
	{0x023A, 0x023B, prUpper},     // L&   [2] LATIN CAPITAL LETTER A WITH STROKE..LATIN CAPITAL LETTER C WITH STROKE
	{0x023C, 0x023C, prLower},     // L&       LATIN SMALL LETTER C WITH STROKE
	{0x023D, 0x023E, prUpper},     // L&   [2] LATIN CAPITAL LETTER L WITH BAR..LATIN CAPITAL LETTER T WITH DIAGONAL STROKE
	{0x023F, 0x0240, prLower},     // L&   [2] LATIN SMALL LETTER S WITH SWASH TAIL..LATIN SMALL LETTER Z WITH SWASH TAIL
	{0x0241, 0x0241, prUpper},     // L&       LATIN CAPITAL LETTER GLOTTAL STOP
	{0x0242, 0x0242, prLower},     // L&       LATIN SMALL LETTER GLOTTAL STOP
	{0x0243, 0x0246, prUpper},     // L&   [4] LATIN CAPITAL LETTER B WITH STROKE..LATIN CAPITAL LETTER E WITH STROKE
	{0x0247, 0x0247, prLower},     // L&       LATIN SMALL LETTER E WITH STROKE
	{0x0248, 0x0248, prUpper},     // L&       LATIN CAPITAL LETTER J WITH STROKE
	{0x0249, 0x0249, prLower},     // L&       LATIN SMALL LETTER J WITH STROKE
	{0x024A, 0x024A, prUpper},     // L&       LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL
	{0x024B, 0x024B, prLower},     // L&       LATIN SMALL LETTER Q WITH HOOK TAIL
	{0x024C, 0x024C, prUpper},     // L&       LATIN CAPITAL LETTER R WITH STROKE
	{0x024D, 0x024D, prLower},     // L&       LATIN SMALL LETTER R WITH STROKE
	{0x024E, 0x024E, prUpper},     // L&       LATIN CAPITAL LETTER Y WITH STROKE
	{0x024F, 0x0293, prLower},     // L&  [69] LATIN SMALL LETTER Y WITH STROKE..LATIN SMALL LETTER EZH WITH CURL
	{0x0294, 0x0294, prOLetter},   // Lo       LATIN LETTER GLOTTAL STOP
	{0x0295, 0x02AF, prLower},     // L&  [27] LATIN LETTER PHARYNGEAL VOICED FRICATIVE..LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
	{0x02B0, 0x02B8, prLower},     // Lm   [9] MODIFIER LETTER SMALL H..MODIFIER LETTER SMALL Y
	{0x02B9, 0x02BF, prOLetter},   // Lm   [7] MODIFIER LETTER PRIME..MODIFIER LETTER LEFT HALF RING
	{0x02C0, 0x02C1, prLower},     // Lm   [2] MODIFIER LETTER GLOTTAL STOP..MODIFIER LETTER REVERSED GLOTTAL STOP
	{0x02C6, 0x02D1, prOLetter},   // Lm  [12] MODIFIER LETTER CIRCUMFLEX ACCENT..MODIFIER LETTER HALF TRIANGULAR COLON
	{0x02E0, 0x02E4, prLower},     // Lm   [5] MODIFIER LETTER SMALL GAMMA..MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
	{0x02EC, 0x02EC, prOLetter},   // Lm       MODIFIER LETTER VOICING
	{0x02EE, 0x02EE, prOLetter},   // Lm       MODIFIER LETTER DOUBLE APOSTROPHE
	{0x0300, 0x036F, prExtend},    // Mn [112] COMBINING GRAVE ACCENT..COMBINING LATIN SMALL LETTER X
	{0x0370, 0x0370, prUpper},     // L&       GREEK CAPITAL LETTER HETA
	{0x0371, 0x0371, prLower},     // L&       GREEK SMALL LETTER HETA
	{0x0372, 0x0372, prUpper},     // L&       GREEK CAPITAL LETTER ARCHAIC SAMPI
	{0x0373, 0x0373, prLower},     // L&       GREEK SMALL LETTER ARCHAIC SAMPI
	{0x0374, 0x0374, prOLetter},   // Lm       GREEK NUMERAL SIGN
	{0x0376, 0x0376, prUpper},     // L&       GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA
	{0x0377, 0x0377, prLower},     // L&       GREEK SMALL LETTER PAMPHYLIAN DIGAMMA
	{0x037A, 0x037A, prLower},     // Lm       GREEK YPOGEGRAMMENI
	{0x037B, 0x037D, prLower},     // L&   [3] GREEK SMALL REVERSED LUNATE SIGMA SYMBOL..GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL
	{0x037F, 0x037F, prUpper},     // L&       GREEK CAPITAL LETTER YOT
	{0x0386, 0x0386, prUpper},     // L&       GREEK CAPITAL LETTER ALPHA WITH TONOS
	{0x0388, 0x038A, prUpper},     // L&   [3] GREEK CAPITAL LETTER EPSILON WITH TONOS..GREEK CAPITAL LETTER IOTA WITH TONOS
	{0x038C, 0x038C, prUpper},     // L&       GREEK CAPITAL LETTER OMICRON WITH TONOS
	{0x038E, 0x038F, prUpper},     // L&   [2] GREEK CAPITAL LETTER UPSILON WITH TONOS..GREEK CAPITAL LETTER OMEGA WITH TONOS
	{0x0390, 0x0390, prLower},     // L&       GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
	{0x0391, 0x03A1, prUpper},     // L&  [17] GREEK CAPITAL LETTER ALPHA..GREEK CAPITAL LETTER RHO
	{0x03A3, 0x03AB, prUpper},     // L&   [9] GREEK CAPITAL LETTER SIGMA..GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
	{0x03AC, 0x03CE, prLower},     // L&  [35] GREEK SMALL LETTER ALPHA WITH TONOS..GREEK SMALL LETTER OMEGA WITH TONOS
	{0x03CF, 0x03CF, prUpper},     // L&       GREEK CAPITAL KAI SYMBOL
	{0x03D0, 0x03D1, prLower},     // L&   [2] GREEK BETA SYMBOL..GREEK THETA SYMBOL
	{0x03D2, 0x03D4, prUpper},     // L&   [3] GREEK UPSILON WITH HOOK SYMBOL..GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL
	{0x03D5, 0x03D7, prLower},     // L&   [3] GREEK PHI SYMBOL..GREEK KAI SYMBOL
	{0x03D8, 0x03D8, prUpper},     // L&       GREEK LETTER ARCHAIC KOPPA
	{0x03D9, 0x03D9, prLower},     // L&       GREEK SMALL LETTER ARCHAIC KOPPA
	{0x03DA, 0x03DA, prUpper},     // L&       GREEK LETTER STIGMA
	{0x03DB, 0x03DB, prLower},     // L&       GREEK SMALL LETTER STIGMA
	{0x03DC, 0x03DC, prUpper},     // L&       GREEK LETTER DIGAMMA
	{0x03DD, 0x03DD, prLower},     // L&       GREEK SMALL LETTER DIGAMMA
	{0x03DE, 0x03DE, prUpper},     // L&       GREEK LETTER KOPPA
	{0x03DF, 0x03DF, prLower},     // L&       GREEK SMALL LETTER KOPPA
	{0x03E0, 0x03E0, prUpper},     // L&       GREEK LETTER SAMPI
	{0x03E1, 0x03E1, prLower},     // L&       GREEK SMALL LETTER SAMPI
	{0x03E2, 0x03E2, prUpper},     // L&       COPTIC CAPITAL LETTER SHEI
	{0x03E3, 0x03E3, prLower},     // L&       COPTIC SMALL LETTER SHEI
	{0x03E4, 0x03E4, prUpper},     // L&       COPTIC CAPITAL LETTER FEI
	{0x03E5, 0x03E5, prLower},     // L&       COPTIC SMALL LETTER FEI
	{0x03E6, 0x03E6, prUpper},     // L&       COPTIC CAPITAL LETTER KHEI
	{0x03E7, 0x03E7, prLower},     // L&       COPTIC SMALL LETTER KHEI
	{0x03E8, 0x03E8, prUpper},     // L&       COPTIC CAPITAL LETTER HORI
	{0x03E9, 0x03E9, prLower},     // L&       COPTIC SMALL LETTER HORI
	{0x03EA, 0x03EA, prUpper},     // L&       COPTIC CAPITAL LETTER GANGIA
	{0x03EB, 0x03EB, prLower},     // L&       COPTIC SMALL LETTER GANGIA
	{0x03EC, 0x03EC, prUpper},     // L&       COPTIC CAPITAL LETTER SHIMA
	{0x03ED, 0x03ED, prLower},     // L&       COPTIC SMALL LETTER SHIMA
	{0x03EE, 0x03EE, prUpper},     // L&       COPTIC CAPITAL LETTER DEI
	{0x03EF, 0x03F3, prLower},     // L&   [5] COPTIC SMALL LETTER DEI..GREEK LETTER YOT
	{0x03F4, 0x03F4, prUpper},     // L&       GREEK CAPITAL THETA SYMBOL
	{0x03F5, 0x03F5, prLower},     // L&       GREEK LUNATE EPSILON SYMBOL
	{0x03F7, 0x03F7, prUpper},     // L&       GREEK CAPITAL LETTER SHO
	{0x03F8, 0x03F8, prLower},     // L&       GREEK SMALL LETTER SHO
	{0x03F9, 0x03FA, prUpper},     // L&   [2] GREEK CAPITAL LUNATE SIGMA SYMBOL..GREEK CAPITAL LETTER SAN
	{0x03FB, 0x03FC, prLower},     // L&   [2] GREEK SMALL LETTER SAN..GREEK RHO WITH STROKE SYMBOL
	{0x03FD, 0x042F, prUpper},     // L&  [51] GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL..CYRILLIC CAPITAL LETTER YA
	{0x0430, 0x045F, prLower},     // L&  [48] CYRILLIC SMALL LETTER A..CYRILLIC SMALL LETTER DZHE
	{0x0460, 0x0460, prUpper},     // L&       CYRILLIC CAPITAL LETTER OMEGA
	{0x0461, 0x0461, prLower},     // L&       CYRILLIC SMALL LETTER OMEGA
	{0x0462, 0x0462, prUpper},     // L&       CYRILLIC CAPITAL LETTER YAT
	{0x0463, 0x0463, prLower},     // L&       CYRILLIC SMALL LETTER YAT
	{0x0464, 0x0464, prUpper},     // L&       CYRILLIC CAPITAL LETTER IOTIFIED E
	{0x0465, 0x0465, prLower},     // L&       CYRILLIC SMALL LETTER IOTIFIED E
	{0x0466, 0x0466, prUpper},     // L&       CYRILLIC CAPITAL LETTER LITTLE YUS
	{0x0467, 0x0467, prLower},     // L&       CYRILLIC SMALL LETTER LITTLE YUS
	{0x0468, 0x0468, prUpper},     // L&       CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS
	{0x0469, 0x0469, prLower},     // L&       CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS
	{0x046A, 0x046A, prUpper},     // L&       CYRILLIC CAPITAL LETTER BIG YUS
	{0x046B, 0x046B, prLower},     // L&       CYRILLIC SMALL LETTER BIG YUS
	{0x046C, 0x046C, prUpper},     // L&       CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS
	{0x046D, 0x046D, prLower},     // L&       CYRILLIC SMALL LETTER IOTIFIED BIG YUS
	{0x046E, 0x046E, prUpper},     // L&       CYRILLIC CAPITAL LETTER KSI
	{0x046F, 0x046F, prLower},     // L&       CYRILLIC SMALL LETTER KSI
	{0x0470, 0x0470, prUpper},     // L&       CYRILLIC CAPITAL LETTER PSI
	{0x0471, 0x0471, prLower},     // L&       CYRILLIC SMALL LETTER PSI
	{0x0472, 0x0472, prUpper},     // L&       CYRILLIC CAPITAL LETTER FITA
	{0x0473, 0x0473, prLower},     // L&       CYRILLIC SMALL LETTER FITA
	{0x0474, 0x0474, prUpper},     // L&       CYRILLIC CAPITAL LETTER IZHITSA
	{0x0475, 0x0475, prLower},     // L&       CYRILLIC SMALL LETTER IZHITSA
	{0x0476, 0x0476, prUpper},     // L&       CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
	{0x0477, 0x0477, prLower},     // L&       CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
	{0x0478, 0x0478, prUpper},     // L&       CYRILLIC CAPITAL LETTER UK
	{0x0479, 0x0479, prLower},     // L&       CYRILLIC SMALL LETTER UK
	{0x047A, 0x047A, prUpper},     // L&       CYRILLIC CAPITAL LETTER ROUND OMEGA
	{0x047B, 0x047B, prLower},     // L&       CYRILLIC SMALL LETTER ROUND OMEGA
	{0x047C, 0x047C, prUpper},     // L&       CYRILLIC CAPITAL LETTER OMEGA WITH TITLO
	{0x047D, 0x047D, prLower},     // L&       CYRILLIC SMALL LETTER OMEGA WITH TITLO
	{0x047E, 0x047E, prUpper},     // L&       CYRILLIC CAPITAL LETTER OT
	{0x047F, 0x047F, prLower},     // L&       CYRILLIC SMALL LETTER OT
	{0x0480, 0x0480, prUpper},     // L&       CYRILLIC CAPITAL LETTER KOPPA
	{0x0481, 0x0481, prLower},     // L&       CYRILLIC SMALL LETTER KOPPA
	{0x0483, 0x0487, prExtend},    // Mn   [5] COMBINING CYRILLIC TITLO..COMBINING CYRILLIC POKRYTIE
	{0x0488, 0x0489, prExtend},    // Me   [2] COMBINING CYRILLIC HUNDRED THOUSANDS SIGN..COMBINING CYRILLIC MILLIONS SIGN
	{0x048A, 0x048A, prUpper},     // L&       CYRILLIC CAPITAL LETTER SHORT I WITH TAIL
	{0x048B, 0x048B, prLower},     // L&       CYRILLIC SMALL LETTER SHORT I WITH TAIL
	{0x048C, 0x048C, prUpper},     // L&       CYRILLIC CAPITAL LETTER SEMISOFT SIGN
	{0x048D, 0x048D, prLower},     // L&       CYRILLIC SMALL LETTER SEMISOFT SIGN
	{0x048E, 0x048E, prUpper},     // L&       CYRILLIC CAPITAL LETTER ER WITH TICK
	{0x048F, 0x048F, prLower},     // L&       CYRILLIC SMALL LETTER ER WITH TICK
	{0x0490, 0x0490, prUpper},     // L&       CYRILLIC CAPITAL LETTER GHE WITH UPTURN
	{0x0491, 0x0491, prLower},     // L&       CYRILLIC SMALL LETTER GHE WITH UPTURN
	{0x0492, 0x0492, prUpper},     // L&       CYRILLIC CAPITAL LETTER GHE WITH STROKE
	{0x0493, 0x0493, prLower},     // L&       CYRILLIC SMALL LETTER GHE WITH STROKE
	{0x0494, 0x0494, prUpper},     // L&       CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK
	{0x0495, 0x0495, prLower},     // L&       CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK
	{0x0496, 0x0496, prUpper},     // L&       CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER
	{0x0497, 0x0497, prLower},     // L&       CYRILLIC SMALL LETTER ZHE WITH DESCENDER
	{0x0498, 0x0498, prUpper},     // L&       CYRILLIC CAPITAL LETTER ZE WITH DESCENDER
	{0x0499, 0x0499, prLower},     // L&       CYRILLIC SMALL LETTER ZE WITH DESCENDER
	{0x049A, 0x049A, prUpper},     // L&       CYRILLIC CAPITAL LETTER KA WITH DESCENDER
	{0x049B, 0x049B, prLower},     // L&       CYRILLIC SMALL LETTER KA WITH DESCENDER
	{0x049C, 0x049C, prUpper},     // L&       CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE
	{0x049D, 0x049D, prLower},     // L&       CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE
	{0x049E, 0x049E, prUpper},     // L&       CYRILLIC CAPITAL LETTER KA WITH STROKE
	{0x049F, 0x049F, prLower},     // L&       CYRILLIC SMALL LETTER KA WITH STROKE
	{0x04A0, 0x04A0, prUpper},     // L&       CYRILLIC CAPITAL LETTER BASHKIR KA
	{0x04A1, 0x04A1, prLower},     // L&       CYRILLIC SMALL LETTER BASHKIR KA
	{0x04A2, 0x04A2, prUpper},     // L&       CYRILLIC CAPITAL LETTER EN WITH DESCENDER
	{0x04A3, 0x04A3, prLower},     // L&       CYRILLIC SMALL LETTER EN WITH DESCENDER
	{0x04A4, 0x04A4, prUpper},     // L&       CYRILLIC CAPITAL LIGATURE EN GHE
	{0x04A5, 0x04A5, prLower},     // L&       CYRILLIC SMALL LIGATURE EN GHE
	{0x04A6, 0x04A6, prUpper},     // L&       CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK
	{0x04A7, 0x04A7, prLower},     // L&       CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK
	{0x04A8, 0x04A8, prUpper},     // L&       CYRILLIC CAPITAL LETTER ABKHASIAN HA
	{0x04A9, 0x04A9, prLower},     // L&       CYRILLIC SMALL LETTER ABKHASIAN HA
	{0x04AA, 0x04AA, prUpper},     // L&       CYRILLIC CAPITAL LETTER ES WITH DESCENDER
	{0x04AB, 0x04AB, prLower},     // L&       CYRILLIC SMALL LETTER ES WITH DESCENDER
	{0x04AC, 0x04AC, prUpper},     // L&       CYRILLIC CAPITAL LETTER TE WITH DESCENDER
	{0x04AD, 0x04AD, prLower},     // L&       CYRILLIC SMALL LETTER TE WITH DESCENDER
	{0x04AE, 0x04AE, prUpper},     // L&       CYRILLIC CAPITAL LETTER STRAIGHT U
	{0x04AF, 0x04AF, prLower},     // L&       CYRILLIC SMALL LETTER STRAIGHT U
	{0x04B0, 0x04B0, prUpper},     // L&       CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE
	{0x04B1, 0x04B1, prLower},     // L&       CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE
	{0x04B2, 0x04B2, prUpper},     // L&       CYRILLIC CAPITAL LETTER HA WITH DESCENDER
	{0x04B3, 0x04B3, prLower},     // L&       CYRILLIC SMALL LETTER HA WITH DESCENDER
	{0x04B4, 0x04B4, prUpper},     // L&       CYRILLIC CAPITAL LIGATURE TE TSE
	{0x04B5, 0x04B5, prLower},     // L&       CYRILLIC SMALL LIGATURE TE TSE
	{0x04B6, 0x04B6, prUpper},     // L&       CYRILLIC CAPITAL LETTER CHE WITH DESCENDER
	{0x04B7, 0x04B7, prLower},     // L&       CYRILLIC SMALL LETTER CHE WITH DESCENDER
	{0x04B8, 0x04B8, prUpper},     // L&       CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE
	{0x04B9, 0x04B9, prLower},     // L&       CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE
	{0x04BA, 0x04BA, prUpper},     // L&       CYRILLIC CAPITAL LETTER SHHA
	{0x04BB, 0x04BB, prLower},     // L&       CYRILLIC SMALL LETTER SHHA
	{0x04BC, 0x04BC, prUpper},     // L&       CYRILLIC CAPITAL LETTER ABKHASIAN CHE
	{0x04BD, 0x04BD, prLower},     // L&       CYRILLIC SMALL LETTER ABKHASIAN CHE
	{0x04BE, 0x04BE, prUpper},     // L&       CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER
	{0x04BF, 0x04BF, prLower},     // L&       CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER
	{0x04C0, 0x04C1, prUpper},     // L&   [2] CYRILLIC LETTER PALOCHKA..CYRILLIC CAPITAL LETTER ZHE WITH BREVE
	{0x04C2, 0x04C2, prLower},     // L&       CYRILLIC SMALL LETTER ZHE WITH BREVE
	{0x04C3, 0x04C3, prUpper},     // L&       CYRILLIC CAPITAL LETTER KA WITH HOOK
	{0x04C4, 0x04C4, prLower},     // L&       CYRILLIC SMALL LETTER KA WITH HOOK
	{0x04C5, 0x04C5, prUpper},     // L&       CYRILLIC CAPITAL LETTER EL WITH TAIL
	{0x04C6, 0x04C6, prLower},     // L&       CYRILLIC SMALL LETTER EL WITH TAIL
	{0x04C7, 0x04C7, prUpper},     // L&       CYRILLIC CAPITAL LETTER EN WITH HOOK
	{0x04C8, 0x04C8, prLower},     // L&       CYRILLIC SMALL LETTER EN WITH HOOK
	{0x04C9, 0x04C9, prUpper},     // L&       CYRILLIC CAPITAL LETTER EN WITH TAIL
	{0x04CA, 0x04CA, prLower},     // L&       CYRILLIC SMALL LETTER EN WITH TAIL
	{0x04CB, 0x04CB, prUpper},     // L&       CYRILLIC CAPITAL LETTER KHAKASSIAN CHE
	{0x04CC, 0x04CC, prLower},     // L&       CYRILLIC SMALL LETTER KHAKASSIAN CHE
	{0x04CD, 0x04CD, prUpper},     // L&       CYRILLIC CAPITAL LETTER EM WITH TAIL
	{0x04CE, 0x04CF, prLower},     // L&   [2] CYRILLIC SMALL LETTER EM WITH TAIL..CYRILLIC SMALL LETTER PALOCHKA
	{0x04D0, 0x04D0, prUpper},     // L&       CYRILLIC CAPITAL LETTER A WITH BREVE
	{0x04D1, 0x04D1, prLower},     // L&       CYRILLIC SMALL LETTER A WITH BREVE
	{0x04D2, 0x04D2, prUpper},     // L&       CYRILLIC CAPITAL LETTER A WITH DIAERESIS
	{0x04D3, 0x04D3, prLower},     // L&       CYRILLIC SMALL LETTER A WITH DIAERESIS
	{0x04D4, 0x04D4, prUpper},     // L&       CYRILLIC CAPITAL LIGATURE A IE
	{0x04D5, 0x04D5, prLower},     // L&       CYRILLIC SMALL LIGATURE A IE
	{0x04D6, 0x04D6, prUpper},     // L&       CYRILLIC CAPITAL LETTER IE WITH BREVE
	{0x04D7, 0x04D7, prLower},     // L&       CYRILLIC SMALL LETTER IE WITH BREVE
	{0x04D8, 0x04D8, prUpper},     // L&       CYRILLIC CAPITAL LETTER SCHWA
	{0x04D9, 0x04D9, prLower},     // L&       CYRILLIC SMALL LETTER SCHWA
	{0x04DA, 0x04DA, prUpper},     // L&       CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS
	{0x04DB, 0x04DB, prLower},     // L&       CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS
	{0x04DC, 0x04DC, prUpper},     // L&       CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS
	{0x04DD, 0x04DD, prLower},     // L&       CYRILLIC SMALL LETTER ZHE WITH DIAERESIS
	{0x04DE, 0x04DE, prUpper},     // L&       CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS
	{0x04DF, 0x04DF, prLower},     // L&       CYRILLIC SMALL LETTER ZE WITH DIAERESIS
	{0x04E0, 0x04E0, prUpper},     // L&       CYRILLIC CAPITAL LETTER ABKHASIAN DZE
	{0x04E1, 0x04E1, prLower},     // L&       CYRILLIC SMALL LETTER ABKHASIAN DZE
	{0x04E2, 0x04E2, prUpper},     // L&       CYRILLIC CAPITAL LETTER I WITH MACRON
	{0x04E3, 0x04E3, prLower},     // L&       CYRILLIC SMALL LETTER I WITH MACRON
	{0x04E4, 0x04E4, prUpper},     // L&       CYRILLIC CAPITAL LETTER I WITH DIAERESIS
	{0x04E5, 0x04E5, prLower},     // L&       CYRILLIC SMALL LETTER I WITH DIAERESIS
	{0x04E6, 0x04E6, prUpper},     // L&       CYRILLIC CAPITAL LETTER O WITH DIAERESIS
	{0x04E7, 0x04E7, prLower},     // L&       CYRILLIC SMALL LETTER O WITH DIAERESIS
	{0x04E8, 0x04E8, prUpper},     // L&       CYRILLIC CAPITAL LETTER BARRED O
	{0x04E9, 0x04E9, prLower},     // L&       CYRILLIC SMALL LETTER BARRED O
	{0x04EA, 0x04EA, prUpper},     // L&       CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS
	{0x04EB, 0x04EB, prLower},     // L&       CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS
	{0x04EC, 0x04EC, prUpper},     // L&       CYRILLIC CAPITAL LETTER E WITH DIAERESIS
	{0x04ED, 0x04ED, prLower},     // L&       CYRILLIC SMALL LETTER E WITH DIAERESIS
	{0x04EE, 0x04EE, prUpper},     // L&       CYRILLIC CAPITAL LETTER U WITH MACRON
	{0x04EF, 0x04EF, prLower},     // L&       CYRILLIC SMALL LETTER U WITH MACRON
	{0x04F0, 0x04F0, prUpper},     // L&       CYRILLIC CAPITAL LETTER U WITH DIAERESIS
	{0x04F1, 0x04F1, prLower},     // L&       CYRILLIC SMALL LETTER U WITH DIAERESIS
	{0x04F2, 0x04F2, prUpper},     // L&       CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
	{0x04F3, 0x04F3, prLower},     // L&       CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE
	{0x04F4, 0x04F4, prUpper},     // L&       CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
	{0x04F5, 0x04F5, prLower},     // L&       CYRILLIC SMALL LETTER CHE WITH DIAERESIS
	{0x04F6, 0x04F6, prUpper},     // L&       CYRILLIC CAPITAL LETTER GHE WITH DESCENDER
	{0x04F7, 0x04F7, prLower},     // L&       CYRILLIC SMALL LETTER GHE WITH DESCENDER
	{0x04F8, 0x04F8, prUpper},     // L&       CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS
	{0x04F9, 0x04F9, prLower},     // L&       CYRILLIC SMALL LETTER YERU WITH DIAERESIS
	{0x04FA, 0x04FA, prUpper},     // L&       CYRILLIC CAPITAL LETTER GHE WITH STROKE AND HOOK
	{0x04FB, 0x04FB, prLower},     // L&       CYRILLIC SMALL LETTER GHE WITH STROKE AND HOOK
	{0x04FC, 0x04FC, prUpper},     // L&       CYRILLIC CAPITAL LETTER HA WITH HOOK
	{0x04FD, 0x04FD, prLower},     // L&       CYRILLIC SMALL LETTER HA WITH HOOK
	{0x04FE, 0x04FE, prUpper},     // L&       CYRILLIC CAPITAL LETTER HA WITH STROKE
	{0x04FF, 0x04FF, prLower},     // L&       CYRILLIC SMALL LETTER HA WITH STROKE
	{0x0500, 0x0500, prUpper},     // L&       CYRILLIC CAPITAL LETTER KOMI DE
	{0x0501, 0x0501, prLower},     // L&       CYRILLIC SMALL LETTER KOMI DE
	{0x0502, 0x0502, prUpper},     // L&       CYRILLIC CAPITAL LETTER KOMI DJE
	{0x0503, 0x0503, prLower},     // L&       CYRILLIC SMALL LETTER KOMI DJE
	{0x0504, 0x0504, prUpper},     // L&       CYRILLIC CAPITAL LETTER KOMI ZJE
	{0x0505, 0x0505, prLower},     // L&       CYRILLIC SMALL LETTER KOMI ZJE
	{0x0506, 0x0506, prUpper},     // L&       CYRILLIC CAPITAL LETTER KOMI DZJE
	{0x0507, 0x0507, prLower},     // L&       CYRILLIC SMALL LETTER KOMI DZJE
	{0x0508, 0x0508, prUpper},     // L&       CYRILLIC CAPITAL LETTER KOMI LJE
	{0x0509, 0x0509, prLower},     // L&       CYRILLIC SMALL LETTER KOMI LJE
	{0x050A, 0x050A, prUpper},     // L&       CYRILLIC CAPITAL LETTER KOMI NJE
	{0x050B, 0x050B, prLower},     // L&       CYRILLIC SMALL LETTER KOMI NJE
	{0x050C, 0x050C, prUpper},     // L&       CYRILLIC CAPITAL LETTER KOMI SJE
	{0x050D, 0x050D, prLower},     // L&       CYRILLIC SMALL LETTER KOMI SJE
	{0x050E, 0x050E, prUpper},     // L&       CYRILLIC CAPITAL LETTER KOMI TJE
	{0x050F, 0x050F, prLower},     // L&       CYRILLIC SMALL LETTER KOMI TJE
	{0x0510, 0x0510, prUpper},     // L&       CYRILLIC CAPITAL LETTER REVERSED ZE
	{0x0511, 0x0511, prLower},     // L&       CYRILLIC SMALL LETTER REVERSED ZE
	{0x0512, 0x0512, prUpper},     // L&       CYRILLIC CAPITAL LETTER EL WITH HOOK
	{0x0513, 0x0513, prLower},     // L&       CYRILLIC SMALL LETTER EL WITH HOOK
	{0x0514, 0x0514, prUpper},     // L&       CYRILLIC CAPITAL LETTER LHA
	{0x0515, 0x0515, prLower},     // L&       CYRILLIC SMALL LETTER LHA
	{0x0516, 0x0516, prUpper},     // L&       CYRILLIC CAPITAL LETTER RHA
	{0x0517, 0x0517, prLower},     // L&       CYRILLIC SMALL LETTER RHA
	{0x0518, 0x0518, prUpper},     // L&       CYRILLIC CAPITAL LETTER YAE
	{0x0519, 0x0519, prLower},     // L&       CYRILLIC SMALL LETTER YAE
	{0x051A, 0x051A, prUpper},     // L&       CYRILLIC CAPITAL LETTER QA
	{0x051B, 0x051B, prLower},     // L&       CYRILLIC SMALL LETTER QA
	{0x051C, 0x051C, prUpper},     // L&       CYRILLIC CAPITAL LETTER WE
	{0x051D, 0x051D, prLower},     // L&       CYRILLIC SMALL LETTER WE
	{0x051E, 0x051E, prUpper},     // L&       CYRILLIC CAPITAL LETTER ALEUT KA
	{0x051F, 0x051F, prLower},     // L&       CYRILLIC SMALL LETTER ALEUT KA
	{0x0520, 0x0520, prUpper},     // L&       CYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOK
	{0x0521, 0x0521, prLower},     // L&       CYRILLIC SMALL LETTER EL WITH MIDDLE HOOK
	{0x0522, 0x0522, prUpper},     // L&       CYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOK
	{0x0523, 0x0523, prLower},     // L&       CYRILLIC SMALL LETTER EN WITH MIDDLE HOOK
	{0x0524, 0x0524, prUpper},     // L&       CYRILLIC CAPITAL LETTER PE WITH DESCENDER
	{0x0525, 0x0525, prLower},     // L&       CYRILLIC SMALL LETTER PE WITH DESCENDER
	{0x0526, 0x0526, prUpper},     // L&       CYRILLIC CAPITAL LETTER SHHA WITH DESCENDER
	{0x0527, 0x0527, prLower},     // L&       CYRILLIC SMALL LETTER SHHA WITH DESCENDER
	{0x0528, 0x0528, prUpper},     // L&       CYRILLIC CAPITAL LETTER EN WITH LEFT HOOK
	{0x0529, 0x0529, prLower},     // L&       CYRILLIC SMALL LETTER EN WITH LEFT HOOK
	{0x052A, 0x052A, prUpper},     // L&       CYRILLIC CAPITAL LETTER DZZHE
	{0x052B, 0x052B, prLower},     // L&       CYRILLIC SMALL LETTER DZZHE
	{0x052C, 0x052C, prUpper},     // L&       CYRILLIC CAPITAL LETTER DCHE
	{0x052D, 0x052D, prLower},     // L&       CYRILLIC SMALL LETTER DCHE
	{0x052E, 0x052E, prUpper},     // L&       CYRILLIC CAPITAL LETTER EL WITH DESCENDER
	{0x052F, 0x052F, prLower},     // L&       CYRILLIC SMALL LETTER EL WITH DESCENDER
	{0x0531, 0x0556, prUpper},     // L&  [38] ARMENIAN CAPITAL LETTER AYB..ARMENIAN CAPITAL LETTER FEH
	{0x0559, 0x0559, prOLetter},   // Lm       ARMENIAN MODIFIER LETTER LEFT HALF RING
	{0x055D, 0x055D, prSContinue}, // Po       ARMENIAN COMMA
	{0x0560, 0x0588, prLower},     // L&  [41] ARMENIAN SMALL LETTER TURNED AYB..ARMENIAN SMALL LETTER YI WITH STROKE
	{0x0589, 0x0589, prSTerm},     // Po       ARMENIAN FULL STOP
	{0x0591, 0x05BD, prExtend},    // Mn  [45] HEBREW ACCENT ETNAHTA..HEBREW POINT METEG
	{0x05BF, 0x05BF, prExtend},    // Mn       HEBREW POINT RAFE
	{0x05C1, 0x05C2, prExtend},    // Mn   [2] HEBREW POINT SHIN DOT..HEBREW POINT SIN DOT
	{0x05C4, 0x05C5, prExtend},    // Mn   [2] HEBREW MARK UPPER DOT..HEBREW MARK LOWER DOT
	{0x05C7, 0x05C7, prExtend},    // Mn       HEBREW POINT QAMATS QATAN
	{0x05D0, 0x05EA, prOLetter},   // Lo  [27] HEBREW LETTER ALEF..HEBREW LETTER TAV
	{0x05EF, 0x05F2, prOLetter},   // Lo   [4] HEBREW YOD TRIANGLE..HEBREW LIGATURE YIDDISH DOUBLE YOD
	{0x05F3, 0x05F3, prOLetter},   // Po       HEBREW PUNCTUATION GERESH
	{0x0600, 0x0605, prFormat},    // Cf   [6] ARABIC NUMBER SIGN..ARABIC NUMBER MARK ABOVE
	{0x060C, 0x060D, prSContinue}, // Po   [2] ARABIC COMMA..ARABIC DATE SEPARATOR
	{0x0610, 0x061A, prExtend},    // Mn  [11] ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM..ARABIC SMALL KASRA
	{0x061C, 0x061C, prFormat},    // Cf       ARABIC LETTER MARK
	{0x061D, 0x061F, prSTerm},     // Po   [3] ARABIC END OF TEXT MARK..ARABIC QUESTION MARK
	{0x0620, 0x063F, prOLetter},   // Lo  [32] ARABIC LETTER KASHMIRI YEH..ARABIC LETTER FARSI YEH WITH THREE DOTS ABOVE
	{0x0640, 0x0640, prOLetter},   // Lm       ARABIC TATWEEL
	{0x0641, 0x064A, prOLetter},   // Lo  [10] ARABIC LETTER FEH..ARABIC LETTER YEH
	{0x064B, 0x065F, prExtend},    // Mn  [21] ARABIC FATHATAN..ARABIC WAVY HAMZA BELOW
	{0x0660, 0x0669, prNumeric},   // Nd  [10] ARABIC-INDIC DIGIT ZERO..ARABIC-INDIC DIGIT NINE
	{0x066B, 0x066C, prNumeric},   // Po   [2] ARABIC DECIMAL SEPARATOR..ARABIC THOUSANDS SEPARATOR
	{0x066E, 0x066F, prOLetter},   // Lo   [2] ARABIC LETTER DOTLESS BEH..ARABIC LETTER DOTLESS QAF
	{0x0670, 0x0670, prExtend},    // Mn       ARABIC LETTER SUPERSCRIPT ALEF
	{0x0671, 0x06D3, prOLetter},   // Lo  [99] ARABIC LETTER ALEF WASLA..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE
	{0x06D4, 0x06D4, prSTerm},     // Po       ARABIC FULL STOP
	{0x06D5, 0x06D5, prOLetter},   // Lo       ARABIC LETTER AE
	{0x06D6, 0x06DC, prExtend},    // Mn   [7] ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA..ARABIC SMALL HIGH SEEN
	{0x06DD, 0x06DD, prFormat},    // Cf       ARABIC END OF AYAH
	{0x06DF, 0x06E4, prExtend},    // Mn   [6] ARABIC SMALL HIGH ROUNDED ZERO..ARABIC SMALL HIGH MADDA
	{0x06E5, 0x06E6, prOLetter},   // Lm   [2] ARABIC SMALL WAW..ARABIC SMALL YEH
	{0x06E7, 0x06E8, prExtend},    // Mn   [2] ARABIC SMALL HIGH YEH..ARABIC SMALL HIGH NOON
	{0x06EA, 0x06ED, prExtend},    // Mn   [4] ARABIC EMPTY CENTRE LOW STOP..ARABIC SMALL LOW MEEM
	{0x06EE, 0x06EF, prOLetter},   // Lo   [2] ARABIC LETTER DAL WITH INVERTED V..ARABIC LETTER REH WITH INVERTED V
	{0x06F0, 0x06F9, prNumeric},   // Nd  [10] EXTENDED ARABIC-INDIC DIGIT ZERO..EXTENDED ARABIC-INDIC DIGIT NINE
	{0x06FA, 0x06FC, prOLetter},   // Lo   [3] ARABIC LETTER SHEEN WITH DOT BELOW..ARABIC LETTER GHAIN WITH DOT BELOW
	{0x06FF, 0x06FF, prOLetter},   // Lo       ARABIC LETTER HEH WITH INVERTED V
	{0x0700, 0x0702, prSTerm},     // Po   [3] SYRIAC END OF PARAGRAPH..SYRIAC SUBLINEAR FULL STOP
	{0x070F, 0x070F, prFormat},    // Cf       SYRIAC ABBREVIATION MARK
	{0x0710, 0x0710, prOLetter},   // Lo       SYRIAC LETTER ALAPH
	{0x0711, 0x0711, prExtend},    // Mn       SYRIAC LETTER SUPERSCRIPT ALAPH
	{0x0712, 0x072F, prOLetter},   // Lo  [30] SYRIAC LETTER BETH..SYRIAC LETTER PERSIAN DHALATH
	{0x0730, 0x074A, prExtend},    // Mn  [27] SYRIAC PTHAHA ABOVE..SYRIAC BARREKH
	{0x074D, 0x07A5, prOLetter},   // Lo  [89] SYRIAC LETTER SOGDIAN ZHAIN..THAANA LETTER WAAVU
	{0x07A6, 0x07B0, prExtend},    // Mn  [11] THAANA ABAFILI..THAANA SUKUN
	{0x07B1, 0x07B1, prOLetter},   // Lo       THAANA LETTER NAA
	{0x07C0, 0x07C9, prNumeric},   // Nd  [10] NKO DIGIT ZERO..NKO DIGIT NINE
	{0x07CA, 0x07EA, prOLetter},   // Lo  [33] NKO LETTER A..NKO LETTER JONA RA
	{0x07EB, 0x07F3, prExtend},    // Mn   [9] NKO COMBINING SHORT HIGH TONE..NKO COMBINING DOUBLE DOT ABOVE
	{0x07F4, 0x07F5, prOLetter},   // Lm   [2] NKO HIGH TONE APOSTROPHE..NKO LOW TONE APOSTROPHE
	{0x07F8, 0x07F8, prSContinue}, // Po       NKO COMMA
	{0x07F9, 0x07F9, prSTerm},     // Po       NKO EXCLAMATION MARK
	{0x07FA, 0x07FA, prOLetter},   // Lm       NKO LAJANYALAN
	{0x07FD, 0x07FD, prExtend},    // Mn       NKO DANTAYALAN
	{0x0800, 0x0815, prOLetter},   // Lo  [22] SAMARITAN LETTER ALAF..SAMARITAN LETTER TAAF
	{0x0816, 0x0819, prExtend},    // Mn   [4] SAMARITAN MARK IN..SAMARITAN MARK DAGESH
	{0x081A, 0x081A, prOLetter},   // Lm       SAMARITAN MODIFIER LETTER EPENTHETIC YUT
	{0x081B, 0x0823, prExtend},    // Mn   [9] SAMARITAN MARK EPENTHETIC YUT..SAMARITAN VOWEL SIGN A
	{0x0824, 0x0824, prOLetter},   // Lm       SAMARITAN MODIFIER LETTER SHORT A
	{0x0825, 0x0827, prExtend},    // Mn   [3] SAMARITAN VOWEL SIGN SHORT A..SAMARITAN VOWEL SIGN U
	{0x0828, 0x0828, prOLetter},   // Lm       SAMARITAN MODIFIER LETTER I
	{0x0829, 0x082D, prExtend},    // Mn   [5] SAMARITAN VOWEL SIGN LONG I..SAMARITAN MARK NEQUDAA
	{0x0837, 0x0837, prSTerm},     // Po       SAMARITAN PUNCTUATION MELODIC QITSA
	{0x0839, 0x0839, prSTerm},     // Po       SAMARITAN PUNCTUATION QITSA
	{0x083D, 0x083E, prSTerm},     // Po   [2] SAMARITAN PUNCTUATION SOF MASHFAAT..SAMARITAN PUNCTUATION ANNAAU
	{0x0840, 0x0858, prOLetter},   // Lo  [25] MANDAIC LETTER HALQA..MANDAIC LETTER AIN
	{0x0859, 0x085B, prExtend},    // Mn   [3] MANDAIC AFFRICATION MARK..MANDAIC GEMINATION MARK
	{0x0860, 0x086A, prOLetter},   // Lo  [11] SYRIAC LETTER MALAYALAM NGA..SYRIAC LETTER MALAYALAM SSA
	{0x0870, 0x0887, prOLetter},   // Lo  [24] ARABIC LETTER ALEF WITH ATTACHED FATHA..ARABIC BASELINE ROUND DOT
	{0x0889, 0x088E, prOLetter},   // Lo   [6] ARABIC LETTER NOON WITH INVERTED SMALL V..ARABIC VERTICAL TAIL
	{0x0890, 0x0891, prFormat},    // Cf   [2] ARABIC POUND MARK ABOVE..ARABIC PIASTRE MARK ABOVE
	{0x0898, 0x089F, prExtend},    // Mn   [8] ARABIC SMALL HIGH WORD AL-JUZ..ARABIC HALF MADDA OVER MADDA
	{0x08A0, 0x08C8, prOLetter},   // Lo  [41] ARABIC LETTER BEH WITH SMALL V BELOW..ARABIC LETTER GRAF
	{0x08C9, 0x08C9, prOLetter},   // Lm       ARABIC SMALL FARSI YEH
	{0x08CA, 0x08E1, prExtend},    // Mn  [24] ARABIC SMALL HIGH FARSI YEH..ARABIC SMALL HIGH SIGN SAFHA
	{0x08E2, 0x08E2, prFormat},    // Cf       ARABIC DISPUTED END OF AYAH
	{0x08E3, 0x0902, prExtend},    // Mn  [32] ARABIC TURNED DAMMA BELOW..DEVANAGARI SIGN ANUSVARA
	{0x0903, 0x0903, prExtend},    // Mc       DEVANAGARI SIGN VISARGA
	{0x0904, 0x0939, prOLetter},   // Lo  [54] DEVANAGARI LETTER SHORT A..DEVANAGARI LETTER HA
	{0x093A, 0x093A, prExtend},    // Mn       DEVANAGARI VOWEL SIGN OE
	{0x093B, 0x093B, prExtend},    // Mc       DEVANAGARI VOWEL SIGN OOE
	{0x093C, 0x093C, prExtend},    // Mn       DEVANAGARI SIGN NUKTA
	{0x093D, 0x093D, prOLetter},   // Lo       DEVANAGARI SIGN AVAGRAHA
	{0x093E, 0x0940, prExtend},    // Mc   [3] DEVANAGARI VOWEL SIGN AA..DEVANAGARI VOWEL SIGN II
	{0x0941, 0x0948, prExtend},    // Mn   [8] DEVANAGARI VOWEL SIGN U..DEVANAGARI VOWEL SIGN AI
	{0x0949, 0x094C, prExtend},    // Mc   [4] DEVANAGARI VOWEL SIGN CANDRA O..DEVANAGARI VOWEL SIGN AU
	{0x094D, 0x094D, prExtend},    // Mn       DEVANAGARI SIGN VIRAMA
	{0x094E, 0x094F, prExtend},    // Mc   [2] DEVANAGARI VOWEL SIGN PRISHTHAMATRA E..DEVANAGARI VOWEL SIGN AW
	{0x0950, 0x0950, prOLetter},   // Lo       DEVANAGARI OM
	{0x0951, 0x0957, prExtend},    // Mn   [7] DEVANAGARI STRESS SIGN UDATTA..DEVANAGARI VOWEL SIGN UUE
	{0x0958, 0x0961, prOLetter},   // Lo  [10] DEVANAGARI LETTER QA..DEVANAGARI LETTER VOCALIC LL
	{0x0962, 0x0963, prExtend},    // Mn   [2] DEVANAGARI VOWEL SIGN VOCALIC L..DEVANAGARI VOWEL SIGN VOCALIC LL
	{0x0964, 0x0965, prSTerm},     // Po   [2] DEVANAGARI DANDA..DEVANAGARI DOUBLE DANDA
	{0x0966, 0x096F, prNumeric},   // Nd  [10] DEVANAGARI DIGIT ZERO..DEVANAGARI DIGIT NINE
	{0x0971, 0x0971, prOLetter},   // Lm       DEVANAGARI SIGN HIGH SPACING DOT
	{0x0972, 0x0980, prOLetter},   // Lo  [15] DEVANAGARI LETTER CANDRA A..BENGALI ANJI
	{0x0981, 0x0981, prExtend},    // Mn       BENGALI SIGN CANDRABINDU
	{0x0982, 0x0983, prExtend},    // Mc   [2] BENGALI SIGN ANUSVARA..BENGALI SIGN VISARGA
	{0x0985, 0x098C, prOLetter},   // Lo   [8] BENGALI LETTER A..BENGALI LETTER VOCALIC L
	{0x098F, 0x0990, prOLetter},   // Lo   [2] BENGALI LETTER E..BENGALI LETTER AI
	{0x0993, 0x09A8, prOLetter},   // Lo  [22] BENGALI LETTER O..BENGALI LETTER NA
	{0x09AA, 0x09B0, prOLetter},   // Lo   [7] BENGALI LETTER PA..BENGALI LETTER RA
	{0x09B2, 0x09B2, prOLetter},   // Lo       BENGALI LETTER LA
	{0x09B6, 0x09B9, prOLetter},   // Lo   [4] BENGALI LETTER SHA..BENGALI LETTER HA
	{0x09BC, 0x09BC, prExtend},    // Mn       BENGALI SIGN NUKTA
	{0x09BD, 0x09BD, prOLetter},   // Lo       BENGALI SIGN AVAGRAHA
	{0x09BE, 0x09C0, prExtend},    // Mc   [3] BENGALI VOWEL SIGN AA..BENGALI VOWEL SIGN II
	{0x09C1, 0x09C4, prExtend},    // Mn   [4] BENGALI VOWEL SIGN U..BENGALI VOWEL SIGN VOCALIC RR
	{0x09C7, 0x09C8, prExtend},    // Mc   [2] BENGALI VOWEL SIGN E..BENGALI VOWEL SIGN AI
	{0x09CB, 0x09CC, prExtend},    // Mc   [2] BENGALI VOWEL SIGN O..BENGALI VOWEL SIGN AU
	{0x09CD, 0x09CD, prExtend},    // Mn       BENGALI SIGN VIRAMA
	{0x09CE, 0x09CE, prOLetter},   // Lo       BENGALI LETTER KHANDA TA
	{0x09D7, 0x09D7, prExtend},    // Mc       BENGALI AU LENGTH MARK
	{0x09DC, 0x09DD, prOLetter},   // Lo   [2] BENGALI LETTER RRA..BENGALI LETTER RHA
	{0x09DF, 0x09E1, prOLetter},   // Lo   [3] BENGALI LETTER YYA..BENGALI LETTER VOCALIC LL
	{0x09E2, 0x09E3, prExtend},    // Mn   [2] BENGALI VOWEL SIGN VOCALIC L..BENGALI VOWEL SIGN VOCALIC LL
	{0x09E6, 0x09EF, prNumeric},   // Nd  [10] BENGALI DIGIT ZERO..BENGALI DIGIT NINE
	{0x09F0, 0x09F1, prOLetter},   // Lo   [2] BENGALI LETTER RA WITH MIDDLE DIAGONAL..BENGALI LETTER RA WITH LOWER DIAGONAL
	{0x09FC, 0x09FC, prOLetter},   // Lo       BENGALI LETTER VEDIC ANUSVARA
	{0x09FE, 0x09FE, prExtend},    // Mn       BENGALI SANDHI MARK
	{0x0A01, 0x0A02, prExtend},    // Mn   [2] GURMUKHI SIGN ADAK BINDI..GURMUKHI SIGN BINDI
	{0x0A03, 0x0A03, prExtend},    // Mc       GURMUKHI SIGN VISARGA
	{0x0A05, 0x0A0A, prOLetter},   // Lo   [6] GURMUKHI LETTER A..GURMUKHI LETTER UU
	{0x0A0F, 0x0A10, prOLetter},   // Lo   [2] GURMUKHI LETTER EE..GURMUKHI LETTER AI
	{0x0A13, 0x0A28, prOLetter},   // Lo  [22] GURMUKHI LETTER OO..GURMUKHI LETTER NA
	{0x0A2A, 0x0A30, prOLetter},   // Lo   [7] GURMUKHI LETTER PA..GURMUKHI LETTER RA
	{0x0A32, 0x0A33, prOLetter},   // Lo   [2] GURMUKHI LETTER LA..GURMUKHI LETTER LLA
	{0x0A35, 0x0A36, prOLetter},   // Lo   [2] GURMUKHI LETTER VA..GURMUKHI LETTER SHA
	{0x0A38, 0x0A39, prOLetter},   // Lo   [2] GURMUKHI LETTER SA..GURMUKHI LETTER HA
	{0x0A3C, 0x0A3C, prExtend},    // Mn       GURMUKHI SIGN NUKTA
	{0x0A3E, 0x0A40, prExtend},    // Mc   [3] GURMUKHI VOWEL SIGN AA..GURMUKHI VOWEL SIGN II
	{0x0A41, 0x0A42, prExtend},    // Mn   [2] GURMUKHI VOWEL SIGN U..GURMUKHI VOWEL SIGN UU
	{0x0A47, 0x0A48, prExtend},    // Mn   [2] GURMUKHI VOWEL SIGN EE..GURMUKHI VOWEL SIGN AI
	{0x0A4B, 0x0A4D, prExtend},    // Mn   [3] GURMUKHI VOWEL SIGN OO..GURMUKHI SIGN VIRAMA
	{0x0A51, 0x0A51, prExtend},    // Mn       GURMUKHI SIGN UDAAT
	{0x0A59, 0x0A5C, prOLetter},   // Lo   [4] GURMUKHI LETTER KHHA..GURMUKHI LETTER RRA
	{0x0A5E, 0x0A5E, prOLetter},   // Lo       GURMUKHI LETTER FA
	{0x0A66, 0x0A6F, prNumeric},   // Nd  [10] GURMUKHI DIGIT ZERO..GURMUKHI DIGIT NINE
	{0x0A70, 0x0A71, prExtend},    // Mn   [2] GURMUKHI TIPPI..GURMUKHI ADDAK
	{0x0A72, 0x0A74, prOLetter},   // Lo   [3] GURMUKHI IRI..GURMUKHI EK ONKAR
	{0x0A75, 0x0A75, prExtend},    // Mn       GURMUKHI SIGN YAKASH
	{0x0A81, 0x0A82, prExtend},    // Mn   [2] GUJARATI SIGN CANDRABINDU..GUJARATI SIGN ANUSVARA
	{0x0A83, 0x0A83, prExtend},    // Mc       GUJARATI SIGN VISARGA
	{0x0A85, 0x0A8D, prOLetter},   // Lo   [9] GUJARATI LETTER A..GUJARATI VOWEL CANDRA E
	{0x0A8F, 0x0A91, prOLetter},   // Lo   [3] GUJARATI LETTER E..GUJARATI VOWEL CANDRA O
	{0x0A93, 0x0AA8, prOLetter},   // Lo  [22] GUJARATI LETTER O..GUJARATI LETTER NA
	{0x0AAA, 0x0AB0, prOLetter},   // Lo   [7] GUJARATI LETTER PA..GUJARATI LETTER RA
	{0x0AB2, 0x0AB3, prOLetter},   // Lo   [2] GUJARATI LETTER LA..GUJARATI LETTER LLA
	{0x0AB5, 0x0AB9, prOLetter},   // Lo   [5] GUJARATI LETTER VA..GUJARATI LETTER HA
	{0x0ABC, 0x0ABC, prExtend},    // Mn       GUJARATI SIGN NUKTA
	{0x0ABD, 0x0ABD, prOLetter},   // Lo       GUJARATI SIGN AVAGRAHA
	{0x0ABE, 0x0AC0, prExtend},    // Mc   [3] GUJARATI VOWEL SIGN AA..GUJARATI VOWEL SIGN II
	{0x0AC1, 0x0AC5, prExtend},    // Mn   [5] GUJARATI VOWEL SIGN U..GUJARATI VOWEL SIGN CANDRA E
	{0x0AC7, 0x0AC8, prExtend},    // Mn   [2] GUJARATI VOWEL SIGN E..GUJARATI VOWEL SIGN AI
	{0x0AC9, 0x0AC9, prExtend},    // Mc       GUJARATI VOWEL SIGN CANDRA O
	{0x0ACB, 0x0ACC, prExtend},    // Mc   [2] GUJARATI VOWEL SIGN O..GUJARATI VOWEL SIGN AU
	{0x0ACD, 0x0ACD, prExtend},    // Mn       GUJARATI SIGN VIRAMA
	{0x0AD0, 0x0AD0, prOLetter},   // Lo       GUJARATI OM
	{0x0AE0, 0x0AE1, prOLetter},   // Lo   [2] GUJARATI LETTER VOCALIC RR..GUJARATI LETTER VOCALIC LL
	{0x0AE2, 0x0AE3, prExtend},    // Mn   [2] GUJARATI VOWEL SIGN VOCALIC L..GUJARATI VOWEL SIGN VOCALIC LL
	{0x0AE6, 0x0AEF, prNumeric},   // Nd  [10] GUJARATI DIGIT ZERO..GUJARATI DIGIT NINE
	{0x0AF9, 0x0AF9, prOLetter},   // Lo       GUJARATI LETTER ZHA
	{0x0AFA, 0x0AFF, prExtend},    // Mn   [6] GUJARATI SIGN SUKUN..GUJARATI SIGN TWO-CIRCLE NUKTA ABOVE
	{0x0B01, 0x0B01, prExtend},    // Mn       ORIYA SIGN CANDRABINDU
	{0x0B02, 0x0B03, prExtend},    // Mc   [2] ORIYA SIGN ANUSVARA..ORIYA SIGN VISARGA
	{0x0B05, 0x0B0C, prOLetter},   // Lo   [8] ORIYA LETTER A..ORIYA LETTER VOCALIC L
	{0x0B0F, 0x0B10, prOLetter},   // Lo   [2] ORIYA LETTER E..ORIYA LETTER AI
	{0x0B13, 0x0B28, prOLetter},   // Lo  [22] ORIYA LETTER O..ORIYA LETTER NA
	{0x0B2A, 0x0B30, prOLetter},   // Lo   [7] ORIYA LETTER PA..ORIYA LETTER RA
	{0x0B32, 0x0B33, prOLetter},   // Lo   [2] ORIYA LETTER LA..ORIYA LETTER LLA
	{0x0B35, 0x0B39, prOLetter},   // Lo   [5] ORIYA LETTER VA..ORIYA LETTER HA
	{0x0B3C, 0x0B3C, prExtend},    // Mn       ORIYA SIGN NUKTA
	{0x0B3D, 0x0B3D, prOLetter},   // Lo       ORIYA SIGN AVAGRAHA
	{0x0B3E, 0x0B3E, prExtend},    // Mc       ORIYA VOWEL SIGN AA
	{0x0B3F, 0x0B3F, prExtend},    // Mn       ORIYA VOWEL SIGN I
	{0x0B40, 0x0B40, prExtend},    // Mc       ORIYA VOWEL SIGN II
	{0x0B41, 0x0B44, prExtend},    // Mn   [4] ORIYA VOWEL SIGN U..ORIYA VOWEL SIGN VOCALIC RR
	{0x0B47, 0x0B48, prExtend},    // Mc   [2] ORIYA VOWEL SIGN E..ORIYA VOWEL SIGN AI
	{0x0B4B, 0x0B4C, prExtend},    // Mc   [2] ORIYA VOWEL SIGN O..ORIYA VOWEL SIGN AU
	{0x0B4D, 0x0B4D, prExtend},    // Mn       ORIYA SIGN VIRAMA
	{0x0B55, 0x0B56, prExtend},    // Mn   [2] ORIYA SIGN OVERLINE..ORIYA AI LENGTH MARK
	{0x0B57, 0x0B57, prExtend},    // Mc       ORIYA AU LENGTH MARK
	{0x0B5C, 0x0B5D, prOLetter},   // Lo   [2] ORIYA LETTER RRA..ORIYA LETTER RHA
	{0x0B5F, 0x0B61, prOLetter},   // Lo   [3] ORIYA LETTER YYA..ORIYA LETTER VOCALIC LL
	{0x0B62, 0x0B63, prExtend},    // Mn   [2] ORIYA VOWEL SIGN VOCALIC L..ORIYA VOWEL SIGN VOCALIC LL
	{0x0B66, 0x0B6F, prNumeric},   // Nd  [10] ORIYA DIGIT ZERO..ORIYA DIGIT NINE
	{0x0B71, 0x0B71, prOLetter},   // Lo       ORIYA LETTER WA
	{0x0B82, 0x0B82, prExtend},    // Mn       TAMIL SIGN ANUSVARA
	{0x0B83, 0x0B83, prOLetter},   // Lo       TAMIL SIGN VISARGA
	{0x0B85, 0x0B8A, prOLetter},   // Lo   [6] TAMIL LETTER A..TAMIL LETTER UU
	{0x0B8E, 0x0B90, prOLetter},   // Lo   [3] TAMIL LETTER E..TAMIL LETTER AI
	{0x0B92, 0x0B95, prOLetter},   // Lo   [4] TAMIL LETTER O..TAMIL LETTER KA
	{0x0B99, 0x0B9A, prOLetter},   // Lo   [2] TAMIL LETTER NGA..TAMIL LETTER CA
	{0x0B9C, 0x0B9C, prOLetter},   // Lo       TAMIL LETTER JA
	{0x0B9E, 0x0B9F, prOLetter},   // Lo   [2] TAMIL LETTER NYA..TAMIL LETTER TTA
	{0x0BA3, 0x0BA4, prOLetter},   // Lo   [2] TAMIL LETTER NNA..TAMIL LETTER TA
	{0x0BA8, 0x0BAA, prOLetter},   // Lo   [3] TAMIL LETTER NA..TAMIL LETTER PA
	{0x0BAE, 0x0BB9, prOLetter},   // Lo  [12] TAMIL LETTER MA..TAMIL LETTER HA
	{0x0BBE, 0x0BBF, prExtend},    // Mc   [2] TAMIL VOWEL SIGN AA..TAMIL VOWEL SIGN I
	{0x0BC0, 0x0BC0, prExtend},    // Mn       TAMIL VOWEL SIGN II
	{0x0BC1, 0x0BC2, prExtend},    // Mc   [2] TAMIL VOWEL SIGN U..TAMIL VOWEL SIGN UU
	{0x0BC6, 0x0BC8, prExtend},    // Mc   [3] TAMIL VOWEL SIGN E..TAMIL VOWEL SIGN AI
	{0x0BCA, 0x0BCC, prExtend},    // Mc   [3] TAMIL VOWEL SIGN O..TAMIL VOWEL SIGN AU
	{0x0BCD, 0x0BCD, prExtend},    // Mn       TAMIL SIGN VIRAMA
	{0x0BD0, 0x0BD0, prOLetter},   // Lo       TAMIL OM
	{0x0BD7, 0x0BD7, prExtend},    // Mc       TAMIL AU LENGTH MARK
	{0x0BE6, 0x0BEF, prNumeric},   // Nd  [10] TAMIL DIGIT ZERO..TAMIL DIGIT NINE
	{0x0C00, 0x0C00, prExtend},    // Mn       TELUGU SIGN COMBINING CANDRABINDU ABOVE
	{0x0C01, 0x0C03, prExtend},    // Mc   [3] TELUGU SIGN CANDRABINDU..TELUGU SIGN VISARGA
	{0x0C04, 0x0C04, prExtend},    // Mn       TELUGU SIGN COMBINING ANUSVARA ABOVE
	{0x0C05, 0x0C0C, prOLetter},   // Lo   [8] TELUGU LETTER A..TELUGU LETTER VOCALIC L
	{0x0C0E, 0x0C10, prOLetter},   // Lo   [3] TELUGU LETTER E..TELUGU LETTER AI
	{0x0C12, 0x0C28, prOLetter},   // Lo  [23] TELUGU LETTER O..TELUGU LETTER NA
	{0x0C2A, 0x0C39, prOLetter},   // Lo  [16] TELUGU LETTER PA..TELUGU LETTER HA
	{0x0C3C, 0x0C3C, prExtend},    // Mn       TELUGU SIGN NUKTA
	{0x0C3D, 0x0C3D, prOLetter},   // Lo       TELUGU SIGN AVAGRAHA
	{0x0C3E, 0x0C40, prExtend},    // Mn   [3] TELUGU VOWEL SIGN AA..TELUGU VOWEL SIGN II
	{0x0C41, 0x0C44, prExtend},    // Mc   [4] TELUGU VOWEL SIGN U..TELUGU VOWEL SIGN VOCALIC RR
	{0x0C46, 0x0C48, prExtend},    // Mn   [3] TELUGU VOWEL SIGN E..TELUGU VOWEL SIGN AI
	{0x0C4A, 0x0C4D, prExtend},    // Mn   [4] TELUGU VOWEL SIGN O..TELUGU SIGN VIRAMA
	{0x0C55, 0x0C56, prExtend},    // Mn   [2] TELUGU LENGTH MARK..TELUGU AI LENGTH MARK
	{0x0C58, 0x0C5A, prOLetter},   // Lo   [3] TELUGU LETTER TSA..TELUGU LETTER RRRA
	{0x0C5D, 0x0C5D, prOLetter},   // Lo       TELUGU LETTER NAKAARA POLLU
	{0x0C60, 0x0C61, prOLetter},   // Lo   [2] TELUGU LETTER VOCALIC RR..TELUGU LETTER VOCALIC LL
	{0x0C62, 0x0C63, prExtend},    // Mn   [2] TELUGU VOWEL SIGN VOCALIC L..TELUGU VOWEL SIGN VOCALIC LL
	{0x0C66, 0x0C6F, prNumeric},   // Nd  [10] TELUGU DIGIT ZERO..TELUGU DIGIT NINE
	{0x0C80, 0x0C80, prOLetter},   // Lo       KANNADA SIGN SPACING CANDRABINDU
	{0x0C81, 0x0C81, prExtend},    // Mn       KANNADA SIGN CANDRABINDU
	{0x0C82, 0x0C83, prExtend},    // Mc   [2] KANNADA SIGN ANUSVARA..KANNADA SIGN VISARGA
	{0x0C85, 0x0C8C, prOLetter},   // Lo   [8] KANNADA LETTER A..KANNADA LETTER VOCALIC L
	{0x0C8E, 0x0C90, prOLetter},   // Lo   [3] KANNADA LETTER E..KANNADA LETTER AI
	{0x0C92, 0x0CA8, prOLetter},   // Lo  [23] KANNADA LETTER O..KANNADA LETTER NA
	{0x0CAA, 0x0CB3, prOLetter},   // Lo  [10] KANNADA LETTER PA..KANNADA LETTER LLA
	{0x0CB5, 0x0CB9, prOLetter},   // Lo   [5] KANNADA LETTER VA..KANNADA LETTER HA
	{0x0CBC, 0x0CBC, prExtend},    // Mn       KANNADA SIGN NUKTA
	{0x0CBD, 0x0CBD, prOLetter},   // Lo       KANNADA SIGN AVAGRAHA
	{0x0CBE, 0x0CBE, prExtend},    // Mc       KANNADA VOWEL SIGN AA
	{0x0CBF, 0x0CBF, prExtend},    // Mn       KANNADA VOWEL SIGN I
	{0x0CC0, 0x0CC4, prExtend},    // Mc   [5] KANNADA VOWEL SIGN II..KANNADA VOWEL SIGN VOCALIC RR
	{0x0CC6, 0x0CC6, prExtend},    // Mn       KANNADA VOWEL SIGN E
	{0x0CC7, 0x0CC8, prExtend},    // Mc   [2] KANNADA VOWEL SIGN EE..KANNADA VOWEL SIGN AI
	{0x0CCA, 0x0CCB, prExtend},    // Mc   [2] KANNADA VOWEL SIGN O..KANNADA VOWEL SIGN OO
	{0x0CCC, 0x0CCD, prExtend},    // Mn   [2] KANNADA VOWEL SIGN AU..KANNADA SIGN VIRAMA
	{0x0CD5, 0x0CD6, prExtend},    // Mc   [2] KANNADA LENGTH MARK..KANNADA AI LENGTH MARK
	{0x0CDD, 0x0CDE, prOLetter},   // Lo   [2] KANNADA LETTER NAKAARA POLLU..KANNADA LETTER FA
	{0x0CE0, 0x0CE1, prOLetter},   // Lo   [2] KANNADA LETTER VOCALIC RR..KANNADA LETTER VOCALIC LL
	{0x0CE2, 0x0CE3, prExtend},    // Mn   [2] KANNADA VOWEL SIGN VOCALIC L..KANNADA VOWEL SIGN VOCALIC LL
	{0x0CE6, 0x0CEF, prNumeric},   // Nd  [10] KANNADA DIGIT ZERO..KANNADA DIGIT NINE
	{0x0CF1, 0x0CF2, prOLetter},   // Lo   [2] KANNADA SIGN JIHVAMULIYA..KANNADA SIGN UPADHMANIYA
	{0x0D00, 0x0D01, prExtend},    // Mn   [2] MALAYALAM SIGN COMBINING ANUSVARA ABOVE..MALAYALAM SIGN CANDRABINDU
	{0x0D02, 0x0D03, prExtend},    // Mc   [2] MALAYALAM SIGN ANUSVARA..MALAYALAM SIGN VISARGA
	{0x0D04, 0x0D0C, prOLetter},   // Lo   [9] MALAYALAM LETTER VEDIC ANUSVARA..MALAYALAM LETTER VOCALIC L
	{0x0D0E, 0x0D10, prOLetter},   // Lo   [3] MALAYALAM LETTER E..MALAYALAM LETTER AI
	{0x0D12, 0x0D3A, prOLetter},   // Lo  [41] MALAYALAM LETTER O..MALAYALAM LETTER TTTA
	{0x0D3B, 0x0D3C, prExtend},    // Mn   [2] MALAYALAM SIGN VERTICAL BAR VIRAMA..MALAYALAM SIGN CIRCULAR VIRAMA
	{0x0D3D, 0x0D3D, prOLetter},   // Lo       MALAYALAM SIGN AVAGRAHA
	{0x0D3E, 0x0D40, prExtend},    // Mc   [3] MALAYALAM VOWEL SIGN AA..MALAYALAM VOWEL SIGN II
	{0x0D41, 0x0D44, prExtend},    // Mn   [4] MALAYALAM VOWEL SIGN U..MALAYALAM VOWEL SIGN VOCALIC RR
	{0x0D46, 0x0D48, prExtend},    // Mc   [3] MALAYALAM VOWEL SIGN E..MALAYALAM VOWEL SIGN AI
	{0x0D4A, 0x0D4C, prExtend},    // Mc   [3] MALAYALAM VOWEL SIGN O..MALAYALAM VOWEL SIGN AU
	{0x0D4D, 0x0D4D, prExtend},    // Mn       MALAYALAM SIGN VIRAMA
	{0x0D4E, 0x0D4E, prOLetter},   // Lo       MALAYALAM LETTER DOT REPH
	{0x0D54, 0x0D56, prOLetter},   // Lo   [3] MALAYALAM LETTER CHILLU M..MALAYALAM LETTER CHILLU LLL
	{0x0D57, 0x0D57, prExtend},    // Mc       MALAYALAM AU LENGTH MARK
	{0x0D5F, 0x0D61, prOLetter},   // Lo   [3] MALAYALAM LETTER ARCHAIC II..MALAYALAM LETTER VOCALIC LL
	{0x0D62, 0x0D63, prExtend},    // Mn   [2] MALAYALAM VOWEL SIGN VOCALIC L..MALAYALAM VOWEL SIGN VOCALIC LL
	{0x0D66, 0x0D6F, prNumeric},   // Nd  [10] MALAYALAM DIGIT ZERO..MALAYALAM DIGIT NINE
	{0x0D7A, 0x0D7F, prOLetter},   // Lo   [6] MALAYALAM LETTER CHILLU NN..MALAYALAM LETTER CHILLU K
	{0x0D81, 0x0D81, prExtend},    // Mn       SINHALA SIGN CANDRABINDU
	{0x0D82, 0x0D83, prExtend},    // Mc   [2] SINHALA SIGN ANUSVARAYA..SINHALA SIGN VISARGAYA
	{0x0D85, 0x0D96, prOLetter},   // Lo  [18] SINHALA LETTER AYANNA..SINHALA LETTER AUYANNA
	{0x0D9A, 0x0DB1, prOLetter},   // Lo  [24] SINHALA LETTER ALPAPRAANA KAYANNA..SINHALA LETTER DANTAJA NAYANNA
	{0x0DB3, 0x0DBB, prOLetter},   // Lo   [9] SINHALA LETTER SANYAKA DAYANNA..SINHALA LETTER RAYANNA
	{0x0DBD, 0x0DBD, prOLetter},   // Lo       SINHALA LETTER DANTAJA LAYANNA
	{0x0DC0, 0x0DC6, prOLetter},   // Lo   [7] SINHALA LETTER VAYANNA..SINHALA LETTER FAYANNA
	{0x0DCA, 0x0DCA, prExtend},    // Mn       SINHALA SIGN AL-LAKUNA
	{0x0DCF, 0x0DD1, prExtend},    // Mc   [3] SINHALA VOWEL SIGN AELA-PILLA..SINHALA VOWEL SIGN DIGA AEDA-PILLA
	{0x0DD2, 0x0DD4, prExtend},    // Mn   [3] SINHALA VOWEL SIGN KETTI IS-PILLA..SINHALA VOWEL SIGN KETTI PAA-PILLA
	{0x0DD6, 0x0DD6, prExtend},    // Mn       SINHALA VOWEL SIGN DIGA PAA-PILLA
	{0x0DD8, 0x0DDF, prExtend},    // Mc   [8] SINHALA VOWEL SIGN GAETTA-PILLA..SINHALA VOWEL SIGN GAYANUKITTA
	{0x0DE6, 0x0DEF, prNumeric},   // Nd  [10] SINHALA LITH DIGIT ZERO..SINHALA LITH DIGIT NINE
	{0x0DF2, 0x0DF3, prExtend},    // Mc   [2] SINHALA VOWEL SIGN DIGA GAETTA-PILLA..SINHALA VOWEL SIGN DIGA GAYANUKITTA
	{0x0E01, 0x0E30, prOLetter},   // Lo  [48] THAI CHARACTER KO KAI..THAI CHARACTER SARA A
	{0x0E31, 0x0E31, prExtend},    // Mn       THAI CHARACTER MAI HAN-AKAT
	{0x0E32, 0x0E33, prOLetter},   // Lo   [2] THAI CHARACTER SARA AA..THAI CHARACTER SARA AM
	{0x0E34, 0x0E3A, prExtend},    // Mn   [7] THAI CHARACTER SARA I..THAI CHARACTER PHINTHU
	{0x0E40, 0x0E45, prOLetter},   // Lo   [6] THAI CHARACTER SARA E..THAI CHARACTER LAKKHANGYAO
	{0x0E46, 0x0E46, prOLetter},   // Lm       THAI CHARACTER MAIYAMOK
	{0x0E47, 0x0E4E, prExtend},    // Mn   [8] THAI CHARACTER MAITAIKHU..THAI CHARACTER YAMAKKAN
	{0x0E50, 0x0E59, prNumeric},   // Nd  [10] THAI DIGIT ZERO..THAI DIGIT NINE
	{0x0E81, 0x0E82, prOLetter},   // Lo   [2] LAO LETTER KO..LAO LETTER KHO SUNG
	{0x0E84, 0x0E84, prOLetter},   // Lo       LAO LETTER KHO TAM
	{0x0E86, 0x0E8A, prOLetter},   // Lo   [5] LAO LETTER PALI GHA..LAO LETTER SO TAM
	{0x0E8C, 0x0EA3, prOLetter},   // Lo  [24] LAO LETTER PALI JHA..LAO LETTER LO LING
	{0x0EA5, 0x0EA5, prOLetter},   // Lo       LAO LETTER LO LOOT
	{0x0EA7, 0x0EB0, prOLetter},   // Lo  [10] LAO LETTER WO..LAO VOWEL SIGN A
	{0x0EB1, 0x0EB1, prExtend},    // Mn       LAO VOWEL SIGN MAI KAN
	{0x0EB2, 0x0EB3, prOLetter},   // Lo   [2] LAO VOWEL SIGN AA..LAO VOWEL SIGN AM
	{0x0EB4, 0x0EBC, prExtend},    // Mn   [9] LAO VOWEL SIGN I..LAO SEMIVOWEL SIGN LO
	{0x0EBD, 0x0EBD, prOLetter},   // Lo       LAO SEMIVOWEL SIGN NYO
	{0x0EC0, 0x0EC4, prOLetter},   // Lo   [5] LAO VOWEL SIGN E..LAO VOWEL SIGN AI
	{0x0EC6, 0x0EC6, prOLetter},   // Lm       LAO KO LA
	{0x0EC8, 0x0ECD, prExtend},    // Mn   [6] LAO TONE MAI EK..LAO NIGGAHITA
	{0x0ED0, 0x0ED9, prNumeric},   // Nd  [10] LAO DIGIT ZERO..LAO DIGIT NINE
	{0x0EDC, 0x0EDF, prOLetter},   // Lo   [4] LAO HO NO..LAO LETTER KHMU NYO
	{0x0F00, 0x0F00, prOLetter},   // Lo       TIBETAN SYLLABLE OM
	{0x0F18, 0x0F19, prExtend},    // Mn   [2] TIBETAN ASTROLOGICAL SIGN -KHYUD PA..TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS
	{0x0F20, 0x0F29, prNumeric},   // Nd  [10] TIBETAN DIGIT ZERO..TIBETAN DIGIT NINE
	{0x0F35, 0x0F35, prExtend},    // Mn       TIBETAN MARK NGAS BZUNG NYI ZLA
	{0x0F37, 0x0F37, prExtend},    // Mn       TIBETAN MARK NGAS BZUNG SGOR RTAGS
	{0x0F39, 0x0F39, prExtend},    // Mn       TIBETAN MARK TSA -PHRU
	{0x0F3A, 0x0F3A, prClose},     // Ps       TIBETAN MARK GUG RTAGS GYON
	{0x0F3B, 0x0F3B, prClose},     // Pe       TIBETAN MARK GUG RTAGS GYAS
	{0x0F3C, 0x0F3C, prClose},     // Ps       TIBETAN MARK ANG KHANG GYON
	{0x0F3D, 0x0F3D, prClose},     // Pe       TIBETAN MARK ANG KHANG GYAS
	{0x0F3E, 0x0F3F, prExtend},    // Mc   [2] TIBETAN SIGN YAR TSHES..TIBETAN SIGN MAR TSHES
	{0x0F40, 0x0F47, prOLetter},   // Lo   [8] TIBETAN LETTER KA..TIBETAN LETTER JA
	{0x0F49, 0x0F6C, prOLetter},   // Lo  [36] TIBETAN LETTER NYA..TIBETAN LETTER RRA
	{0x0F71, 0x0F7E, prExtend},    // Mn  [14] TIBETAN VOWEL SIGN AA..TIBETAN SIGN RJES SU NGA RO
	{0x0F7F, 0x0F7F, prExtend},    // Mc       TIBETAN SIGN RNAM BCAD
	{0x0F80, 0x0F84, prExtend},    // Mn   [5] TIBETAN VOWEL SIGN REVERSED I..TIBETAN MARK HALANTA
	{0x0F86, 0x0F87, prExtend},    // Mn   [2] TIBETAN SIGN LCI RTAGS..TIBETAN SIGN YANG RTAGS
	{0x0F88, 0x0F8C, prOLetter},   // Lo   [5] TIBETAN SIGN LCE TSA CAN..TIBETAN SIGN INVERTED MCHU CAN
	{0x0F8D, 0x0F97, prExtend},    // Mn  [11] TIBETAN SUBJOINED SIGN LCE TSA CAN..TIBETAN SUBJOINED LETTER JA
	{0x0F99, 0x0FBC, prExtend},    // Mn  [36] TIBETAN SUBJOINED LETTER NYA..TIBETAN SUBJOINED LETTER FIXED-FORM RA
	{0x0FC6, 0x0FC6, prExtend},    // Mn       TIBETAN SYMBOL PADMA GDAN
	{0x1000, 0x102A, prOLetter},   // Lo  [43] MYANMAR LETTER KA..MYANMAR LETTER AU
	{0x102B, 0x102C, prExtend},    // Mc   [2] MYANMAR VOWEL SIGN TALL AA..MYANMAR VOWEL SIGN AA
	{0x102D, 0x1030, prExtend},    // Mn   [4] MYANMAR VOWEL SIGN I..MYANMAR VOWEL SIGN UU
	{0x1031, 0x1031, prExtend},    // Mc       MYANMAR VOWEL SIGN E
	{0x1032, 0x1037, prExtend},    // Mn   [6] MYANMAR VOWEL SIGN AI..MYANMAR SIGN DOT BELOW
	{0x1038, 0x1038, prExtend},    // Mc       MYANMAR SIGN VISARGA
	{0x1039, 0x103A, prExtend},    // Mn   [2] MYANMAR SIGN VIRAMA..MYANMAR SIGN ASAT
	{0x103B, 0x103C, prExtend},    // Mc   [2] MYANMAR CONSONANT SIGN MEDIAL YA..MYANMAR CONSONANT SIGN MEDIAL RA
	{0x103D, 0x103E, prExtend},    // Mn   [2] MYANMAR CONSONANT SIGN MEDIAL WA..MYANMAR CONSONANT SIGN MEDIAL HA
	{0x103F, 0x103F, prOLetter},   // Lo       MYANMAR LETTER GREAT SA
	{0x1040, 0x1049, prNumeric},   // Nd  [10] MYANMAR DIGIT ZERO..MYANMAR DIGIT NINE
	{0x104A, 0x104B, prSTerm},     // Po   [2] MYANMAR SIGN LITTLE SECTION..MYANMAR SIGN SECTION
	{0x1050, 0x1055, prOLetter},   // Lo   [6] MYANMAR LETTER SHA..MYANMAR LETTER VOCALIC LL
	{0x1056, 0x1057, prExtend},    // Mc   [2] MYANMAR VOWEL SIGN VOCALIC R..MYANMAR VOWEL SIGN VOCALIC RR
	{0x1058, 0x1059, prExtend},    // Mn   [2] MYANMAR VOWEL SIGN VOCALIC L..MYANMAR VOWEL SIGN VOCALIC LL
	{0x105A, 0x105D, prOLetter},   // Lo   [4] MYANMAR LETTER MON NGA..MYANMAR LETTER MON BBE
	{0x105E, 0x1060, prExtend},    // Mn   [3] MYANMAR CONSONANT SIGN MON MEDIAL NA..MYANMAR CONSONANT SIGN MON MEDIAL LA
	{0x1061, 0x1061, prOLetter},   // Lo       MYANMAR LETTER SGAW KAREN SHA
	{0x1062, 0x1064, prExtend},    // Mc   [3] MYANMAR VOWEL SIGN SGAW KAREN EU..MYANMAR TONE MARK SGAW KAREN KE PHO
	{0x1065, 0x1066, prOLetter},   // Lo   [2] MYANMAR LETTER WESTERN PWO KAREN THA..MYANMAR LETTER WESTERN PWO KAREN PWA
	{0x1067, 0x106D, prExtend},    // Mc   [7] MYANMAR VOWEL SIGN WESTERN PWO KAREN EU..MYANMAR SIGN WESTERN PWO KAREN TONE-5
	{0x106E, 0x1070, prOLetter},   // Lo   [3] MYANMAR LETTER EASTERN PWO KAREN NNA..MYANMAR LETTER EASTERN PWO KAREN GHWA
	{0x1071, 0x1074, prExtend},    // Mn   [4] MYANMAR VOWEL SIGN GEBA KAREN I..MYANMAR VOWEL SIGN KAYAH EE
	{0x1075, 0x1081, prOLetter},   // Lo  [13] MYANMAR LETTER SHAN KA..MYANMAR LETTER SHAN HA
	{0x1082, 0x1082, prExtend},    // Mn       MYANMAR CONSONANT SIGN SHAN MEDIAL WA
	{0x1083, 0x1084, prExtend},    // Mc   [2] MYANMAR VOWEL SIGN SHAN AA..MYANMAR VOWEL SIGN SHAN E
	{0x1085, 0x1086, prExtend},    // Mn   [2] MYANMAR VOWEL SIGN SHAN E ABOVE..MYANMAR VOWEL SIGN SHAN FINAL Y
	{0x1087, 0x108C, prExtend},    // Mc   [6] MYANMAR SIGN SHAN TONE-2..MYANMAR SIGN SHAN COUNCIL TONE-3
	{0x108D, 0x108D, prExtend},    // Mn       MYANMAR SIGN SHAN COUNCIL EMPHATIC TONE
	{0x108E, 0x108E, prOLetter},   // Lo       MYANMAR LETTER RUMAI PALAUNG FA
	{0x108F, 0x108F, prExtend},    // Mc       MYANMAR SIGN RUMAI PALAUNG TONE-5
	{0x1090, 0x1099, prNumeric},   // Nd  [10] MYANMAR SHAN DIGIT ZERO..MYANMAR SHAN DIGIT NINE
	{0x109A, 0x109C, prExtend},    // Mc   [3] MYANMAR SIGN KHAMTI TONE-1..MYANMAR VOWEL SIGN AITON A
	{0x109D, 0x109D, prExtend},    // Mn       MYANMAR VOWEL SIGN AITON AI
	{0x10A0, 0x10C5, prUpper},     // L&  [38] GEORGIAN CAPITAL LETTER AN..GEORGIAN CAPITAL LETTER HOE
	{0x10C7, 0x10C7, prUpper},     // L&       GEORGIAN CAPITAL LETTER YN
	{0x10CD, 0x10CD, prUpper},     // L&       GEORGIAN CAPITAL LETTER AEN
	{0x10D0, 0x10FA, prOLetter},   // L&  [43] GEORGIAN LETTER AN..GEORGIAN LETTER AIN
	{0x10FC, 0x10FC, prOLetter},   // Lm       MODIFIER LETTER GEORGIAN NAR
	{0x10FD, 0x10FF, prOLetter},   // L&   [3] GEORGIAN LETTER AEN..GEORGIAN LETTER LABIAL SIGN
	{0x1100, 0x1248, prOLetter},   // Lo [329] HANGUL CHOSEONG KIYEOK..ETHIOPIC SYLLABLE QWA
	{0x124A, 0x124D, prOLetter},   // Lo   [4] ETHIOPIC SYLLABLE QWI..ETHIOPIC SYLLABLE QWE
	{0x1250, 0x1256, prOLetter},   // Lo   [7] ETHIOPIC SYLLABLE QHA..ETHIOPIC SYLLABLE QHO
	{0x1258, 0x1258, prOLetter},   // Lo       ETHIOPIC SYLLABLE QHWA
	{0x125A, 0x125D, prOLetter},   // Lo   [4] ETHIOPIC SYLLABLE QHWI..ETHIOPIC SYLLABLE QHWE
	{0x1260, 0x1288, prOLetter},   // Lo  [41] ETHIOPIC SYLLABLE BA..ETHIOPIC SYLLABLE XWA
	{0x128A, 0x128D, prOLetter},   // Lo   [4] ETHIOPIC SYLLABLE XWI..ETHIOPIC SYLLABLE XWE
	{0x1290, 0x12B0, prOLetter},   // Lo  [33] ETHIOPIC SYLLABLE NA..ETHIOPIC SYLLABLE KWA
	{0x12B2, 0x12B5, prOLetter},   // Lo   [4] ETHIOPIC SYLLABLE KWI..ETHIOPIC SYLLABLE KWE
	{0x12B8, 0x12BE, prOLetter},   // Lo   [7] ETHIOPIC SYLLABLE KXA..ETHIOPIC SYLLABLE KXO
	{0x12C0, 0x12C0, prOLetter},   // Lo       ETHIOPIC SYLLABLE KXWA
	{0x12C2, 0x12C5, prOLetter},   // Lo   [4] ETHIOPIC SYLLABLE KXWI..ETHIOPIC SYLLABLE KXWE
	{0x12C8, 0x12D6, prOLetter},   // Lo  [15] ETHIOPIC SYLLABLE WA..ETHIOPIC SYLLABLE PHARYNGEAL O
	{0x12D8, 0x1310, prOLetter},   // Lo  [57] ETHIOPIC SYLLABLE ZA..ETHIOPIC SYLLABLE GWA
	{0x1312, 0x1315, prOLetter},   // Lo   [4] ETHIOPIC SYLLABLE GWI..ETHIOPIC SYLLABLE GWE
	{0x1318, 0x135A, prOLetter},   // Lo  [67] ETHIOPIC SYLLABLE GGA..ETHIOPIC SYLLABLE FYA
	{0x135D, 0x135F, prExtend},    // Mn   [3] ETHIOPIC COMBINING GEMINATION AND VOWEL LENGTH MARK..ETHIOPIC COMBINING GEMINATION MARK
	{0x1362, 0x1362, prSTerm},     // Po       ETHIOPIC FULL STOP
	{0x1367, 0x1368, prSTerm},     // Po   [2] ETHIOPIC QUESTION MARK..ETHIOPIC PARAGRAPH SEPARATOR
	{0x1380, 0x138F, prOLetter},   // Lo  [16] ETHIOPIC SYLLABLE SEBATBEIT MWA..ETHIOPIC SYLLABLE PWE
	{0x13A0, 0x13F5, prUpper},     // L&  [86] CHEROKEE LETTER A..CHEROKEE LETTER MV
	{0x13F8, 0x13FD, prLower},     // L&   [6] CHEROKEE SMALL LETTER YE..CHEROKEE SMALL LETTER MV
	{0x1401, 0x166C, prOLetter},   // Lo [620] CANADIAN SYLLABICS E..CANADIAN SYLLABICS CARRIER TTSA
	{0x166E, 0x166E, prSTerm},     // Po       CANADIAN SYLLABICS FULL STOP
	{0x166F, 0x167F, prOLetter},   // Lo  [17] CANADIAN SYLLABICS QAI..CANADIAN SYLLABICS BLACKFOOT W
	{0x1680, 0x1680, prSp},        // Zs       OGHAM SPACE MARK
	{0x1681, 0x169A, prOLetter},   // Lo  [26] OGHAM LETTER BEITH..OGHAM LETTER PEITH
	{0x169B, 0x169B, prClose},     // Ps       OGHAM FEATHER MARK
	{0x169C, 0x169C, prClose},     // Pe       OGHAM REVERSED FEATHER MARK
	{0x16A0, 0x16EA, prOLetter},   // Lo  [75] RUNIC LETTER FEHU FEOH FE F..RUNIC LETTER X
	{0x16EE, 0x16F0, prOLetter},   // Nl   [3] RUNIC ARLAUG SYMBOL..RUNIC BELGTHOR SYMBOL
	{0x16F1, 0x16F8, prOLetter},   // Lo   [8] RUNIC LETTER K..RUNIC LETTER FRANKS CASKET AESC
	{0x1700, 0x1711, prOLetter},   // Lo  [18] TAGALOG LETTER A..TAGALOG LETTER HA
	{0x1712, 0x1714, prExtend},    // Mn   [3] TAGALOG VOWEL SIGN I..TAGALOG SIGN VIRAMA
	{0x1715, 0x1715, prExtend},    // Mc       TAGALOG SIGN PAMUDPOD
	{0x171F, 0x1731, prOLetter},   // Lo  [19] TAGALOG LETTER ARCHAIC RA..HANUNOO LETTER HA
	{0x1732, 0x1733, prExtend},    // Mn   [2] HANUNOO VOWEL SIGN I..HANUNOO VOWEL SIGN U
	{0x1734, 0x1734, prExtend},    // Mc       HANUNOO SIGN PAMUDPOD
	{0x1735, 0x1736, prSTerm},     // Po   [2] PHILIPPINE SINGLE PUNCTUATION..PHILIPPINE DOUBLE PUNCTUATION
	{0x1740, 0x1751, prOLetter},   // Lo  [18] BUHID LETTER A..BUHID LETTER HA
	{0x1752, 0x1753, prExtend},    // Mn   [2] BUHID VOWEL SIGN I..BUHID VOWEL SIGN U
	{0x1760, 0x176C, prOLetter},   // Lo  [13] TAGBANWA LETTER A..TAGBANWA LETTER YA
	{0x176E, 0x1770, prOLetter},   // Lo   [3] TAGBANWA LETTER LA..TAGBANWA LETTER SA
	{0x1772, 0x1773, prExtend},    // Mn   [2] TAGBANWA VOWEL SIGN I..TAGBANWA VOWEL SIGN U
	{0x1780, 0x17B3, prOLetter},   // Lo  [52] KHMER LETTER KA..KHMER INDEPENDENT VOWEL QAU
	{0x17B4, 0x17B5, prExtend},    // Mn   [2] KHMER VOWEL INHERENT AQ..KHMER VOWEL INHERENT AA
	{0x17B6, 0x17B6, prExtend},    // Mc       KHMER VOWEL SIGN AA
	{0x17B7, 0x17BD, prExtend},    // Mn   [7] KHMER VOWEL SIGN I..KHMER VOWEL SIGN UA
	{0x17BE, 0x17C5, prExtend},    // Mc   [8] KHMER VOWEL SIGN OE..KHMER VOWEL SIGN AU
	{0x17C6, 0x17C6, prExtend},    // Mn       KHMER SIGN NIKAHIT
	{0x17C7, 0x17C8, prExtend},    // Mc   [2] KHMER SIGN REAHMUK..KHMER SIGN YUUKALEAPINTU
	{0x17C9, 0x17D3, prExtend},    // Mn  [11] KHMER SIGN MUUSIKATOAN..KHMER SIGN BATHAMASAT
	{0x17D7, 0x17D7, prOLetter},   // Lm       KHMER SIGN LEK TOO
	{0x17DC, 0x17DC, prOLetter},   // Lo       KHMER SIGN AVAKRAHASANYA
	{0x17DD, 0x17DD, prExtend},    // Mn       KHMER SIGN ATTHACAN
	{0x17E0, 0x17E9, prNumeric},   // Nd  [10] KHMER DIGIT ZERO..KHMER DIGIT NINE
	{0x1802, 0x1802, prSContinue}, // Po       MONGOLIAN COMMA
	{0x1803, 0x1803, prSTerm},     // Po       MONGOLIAN FULL STOP
	{0x1808, 0x1808, prSContinue}, // Po       MONGOLIAN MANCHU COMMA
	{0x1809, 0x1809, prSTerm},     // Po       MONGOLIAN MANCHU FULL STOP
	{0x180B, 0x180D, prExtend},    // Mn   [3] MONGOLIAN FREE VARIATION SELECTOR ONE..MONGOLIAN FREE VARIATION SELECTOR THREE
	{0x180E, 0x180E, prFormat},    // Cf       MONGOLIAN VOWEL SEPARATOR
	{0x180F, 0x180F, prExtend},    // Mn       MONGOLIAN FREE VARIATION SELECTOR FOUR
	{0x1810, 0x1819, prNumeric},   // Nd  [10] MONGOLIAN DIGIT ZERO..MONGOLIAN DIGIT NINE
	{0x1820, 0x1842, prOLetter},   // Lo  [35] MONGOLIAN LETTER A..MONGOLIAN LETTER CHI
	{0x1843, 0x1843, prOLetter},   // Lm       MONGOLIAN LETTER TODO LONG VOWEL SIGN
	{0x1844, 0x1878, prOLetter},   // Lo  [53] MONGOLIAN LETTER TODO E..MONGOLIAN LETTER CHA WITH TWO DOTS
	{0x1880, 0x1884, prOLetter},   // Lo   [5] MONGOLIAN LETTER ALI GALI ANUSVARA ONE..MONGOLIAN LETTER ALI GALI INVERTED UBADAMA
	{0x1885, 0x1886, prExtend},    // Mn   [2] MONGOLIAN LETTER ALI GALI BALUDA..MONGOLIAN LETTER ALI GALI THREE BALUDA
	{0x1887, 0x18A8, prOLetter},   // Lo  [34] MONGOLIAN LETTER ALI GALI A..MONGOLIAN LETTER MANCHU ALI GALI BHA
	{0x18A9, 0x18A9, prExtend},    // Mn       MONGOLIAN LETTER ALI GALI DAGALGA
	{0x18AA, 0x18AA, prOLetter},   // Lo       MONGOLIAN LETTER MANCHU ALI GALI LHA
	{0x18B0, 0x18F5, prOLetter},   // Lo  [70] CANADIAN SYLLABICS OY..CANADIAN SYLLABICS CARRIER DENTAL S
	{0x1900, 0x191E, prOLetter},   // Lo  [31] LIMBU VOWEL-CARRIER LETTER..LIMBU LETTER TRA
	{0x1920, 0x1922, prExtend},    // Mn   [3] LIMBU VOWEL SIGN A..LIMBU VOWEL SIGN U
	{0x1923, 0x1926, prExtend},    // Mc   [4] LIMBU VOWEL SIGN EE..LIMBU VOWEL SIGN AU
	{0x1927, 0x1928, prExtend},    // Mn   [2] LIMBU VOWEL SIGN E..LIMBU VOWEL SIGN O
	{0x1929, 0x192B, prExtend},    // Mc   [3] LIMBU SUBJOINED LETTER YA..LIMBU SUBJOINED LETTER WA
	{0x1930, 0x1931, prExtend},    // Mc   [2] LIMBU SMALL LETTER KA..LIMBU SMALL LETTER NGA
	{0x1932, 0x1932, prExtend},    // Mn       LIMBU SMALL LETTER ANUSVARA
	{0x1933, 0x1938, prExtend},    // Mc   [6] LIMBU SMALL LETTER TA..LIMBU SMALL LETTER LA
	{0x1939, 0x193B, prExtend},    // Mn   [3] LIMBU SIGN MUKPHRENG..LIMBU SIGN SA-I
	{0x1944, 0x1945, prSTerm},     // Po   [2] LIMBU EXCLAMATION MARK..LIMBU QUESTION MARK
	{0x1946, 0x194F, prNumeric},   // Nd  [10] LIMBU DIGIT ZERO..LIMBU DIGIT NINE
	{0x1950, 0x196D, prOLetter},   // Lo  [30] TAI LE LETTER KA..TAI LE LETTER AI
	{0x1970, 0x1974, prOLetter},   // Lo   [5] TAI LE LETTER TONE-2..TAI LE LETTER TONE-6
	{0x1980, 0x19AB, prOLetter},   // Lo  [44] NEW TAI LUE LETTER HIGH QA..NEW TAI LUE LETTER LOW SUA
	{0x19B0, 0x19C9, prOLetter},   // Lo  [26] NEW TAI LUE VOWEL SIGN VOWEL SHORTENER..NEW TAI LUE TONE MARK-2
	{0x19D0, 0x19D9, prNumeric},   // Nd  [10] NEW TAI LUE DIGIT ZERO..NEW TAI LUE DIGIT NINE
	{0x1A00, 0x1A16, prOLetter},   // Lo  [23] BUGINESE LETTER KA..BUGINESE LETTER HA
	{0x1A17, 0x1A18, prExtend},    // Mn   [2] BUGINESE VOWEL SIGN I..BUGINESE VOWEL SIGN U
	{0x1A19, 0x1A1A, prExtend},    // Mc   [2] BUGINESE VOWEL SIGN E..BUGINESE VOWEL SIGN O
	{0x1A1B, 0x1A1B, prExtend},    // Mn       BUGINESE VOWEL SIGN AE
	{0x1A20, 0x1A54, prOLetter},   // Lo  [53] TAI THAM LETTER HIGH KA..TAI THAM LETTER GREAT SA
	{0x1A55, 0x1A55, prExtend},    // Mc       TAI THAM CONSONANT SIGN MEDIAL RA
	{0x1A56, 0x1A56, prExtend},    // Mn       TAI THAM CONSONANT SIGN MEDIAL LA
	{0x1A57, 0x1A57, prExtend},    // Mc       TAI THAM CONSONANT SIGN LA TANG LAI
	{0x1A58, 0x1A5E, prExtend},    // Mn   [7] TAI THAM SIGN MAI KANG LAI..TAI THAM CONSONANT SIGN SA
	{0x1A60, 0x1A60, prExtend},    // Mn       TAI THAM SIGN SAKOT
	{0x1A61, 0x1A61, prExtend},    // Mc       TAI THAM VOWEL SIGN A
	{0x1A62, 0x1A62, prExtend},    // Mn       TAI THAM VOWEL SIGN MAI SAT
	{0x1A63, 0x1A64, prExtend},    // Mc   [2] TAI THAM VOWEL SIGN AA..TAI THAM VOWEL SIGN TALL AA
	{0x1A65, 0x1A6C, prExtend},    // Mn   [8] TAI THAM VOWEL SIGN I..TAI THAM VOWEL SIGN OA BELOW
	{0x1A6D, 0x1A72, prExtend},    // Mc   [6] TAI THAM VOWEL SIGN OY..TAI THAM VOWEL SIGN THAM AI
	{0x1A73, 0x1A7C, prExtend},    // Mn  [10] TAI THAM VOWEL SIGN OA ABOVE..TAI THAM SIGN KHUEN-LUE KARAN
	{0x1A7F, 0x1A7F, prExtend},    // Mn       TAI THAM COMBINING CRYPTOGRAMMIC DOT
	{0x1A80, 0x1A89, prNumeric},   // Nd  [10] TAI THAM HORA DIGIT ZERO..TAI THAM HORA DIGIT NINE
	{0x1A90, 0x1A99, prNumeric},   // Nd  [10] TAI THAM THAM DIGIT ZERO..TAI THAM THAM DIGIT NINE
	{0x1AA7, 0x1AA7, prOLetter},   // Lm       TAI THAM SIGN MAI YAMOK
	{0x1AA8, 0x1AAB, prSTerm},     // Po   [4] TAI THAM SIGN KAAN..TAI THAM SIGN SATKAANKUU
	{0x1AB0, 0x1ABD, prExtend},    // Mn  [14] COMBINING DOUBLED CIRCUMFLEX ACCENT..COMBINING PARENTHESES BELOW
	{0x1ABE, 0x1ABE, prExtend},    // Me       COMBINING PARENTHESES OVERLAY
	{0x1ABF, 0x1ACE, prExtend},    // Mn  [16] COMBINING LATIN SMALL LETTER W BELOW..COMBINING LATIN SMALL LETTER INSULAR T
	{0x1B00, 0x1B03, prExtend},    // Mn   [4] BALINESE SIGN ULU RICEM..BALINESE SIGN SURANG
	{0x1B04, 0x1B04, prExtend},    // Mc       BALINESE SIGN BISAH
	{0x1B05, 0x1B33, prOLetter},   // Lo  [47] BALINESE LETTER AKARA..BALINESE LETTER HA
	{0x1B34, 0x1B34, prExtend},    // Mn       BALINESE SIGN REREKAN
	{0x1B35, 0x1B35, prExtend},    // Mc       BALINESE VOWEL SIGN TEDUNG
	{0x1B36, 0x1B3A, prExtend},    // Mn   [5] BALINESE VOWEL SIGN ULU..BALINESE VOWEL SIGN RA REPA
	{0x1B3B, 0x1B3B, prExtend},    // Mc       BALINESE VOWEL SIGN RA REPA TEDUNG
	{0x1B3C, 0x1B3C, prExtend},    // Mn       BALINESE VOWEL SIGN LA LENGA
	{0x1B3D, 0x1B41, prExtend},    // Mc   [5] BALINESE VOWEL SIGN LA LENGA TEDUNG..BALINESE VOWEL SIGN TALING REPA TEDUNG
	{0x1B42, 0x1B42, prExtend},    // Mn       BALINESE VOWEL SIGN PEPET
	{0x1B43, 0x1B44, prExtend},    // Mc   [2] BALINESE VOWEL SIGN PEPET TEDUNG..BALINESE ADEG ADEG
	{0x1B45, 0x1B4C, prOLetter},   // Lo   [8] BALINESE LETTER KAF SASAK..BALINESE LETTER ARCHAIC JNYA
	{0x1B50, 0x1B59, prNumeric},   // Nd  [10] BALINESE DIGIT ZERO..BALINESE DIGIT NINE
	{0x1B5A, 0x1B5B, prSTerm},     // Po   [2] BALINESE PANTI..BALINESE PAMADA
	{0x1B5E, 0x1B5F, prSTerm},     // Po   [2] BALINESE CARIK SIKI..BALINESE CARIK PAREREN
	{0x1B6B, 0x1B73, prExtend},    // Mn   [9] BALINESE MUSICAL SYMBOL COMBINING TEGEH..BALINESE MUSICAL SYMBOL COMBINING GONG
	{0x1B7D, 0x1B7E, prSTerm},     // Po   [2] BALINESE PANTI LANTANG..BALINESE PAMADA LANTANG
	{0x1B80, 0x1B81, prExtend},    // Mn   [2] SUNDANESE SIGN PANYECEK..SUNDANESE SIGN PANGLAYAR
	{0x1B82, 0x1B82, prExtend},    // Mc       SUNDANESE SIGN PANGWISAD
	{0x1B83, 0x1BA0, prOLetter},   // Lo  [30] SUNDANESE LETTER A..SUNDANESE LETTER HA
	{0x1BA1, 0x1BA1, prExtend},    // Mc       SUNDANESE CONSONANT SIGN PAMINGKAL
	{0x1BA2, 0x1BA5, prExtend},    // Mn   [4] SUNDANESE CONSONANT SIGN PANYAKRA..SUNDANESE VOWEL SIGN PANYUKU
	{0x1BA6, 0x1BA7, prExtend},    // Mc   [2] SUNDANESE VOWEL SIGN PANAELAENG..SUNDANESE VOWEL SIGN PANOLONG
	{0x1BA8, 0x1BA9, prExtend},    // Mn   [2] SUNDANESE VOWEL SIGN PAMEPET..SUNDANESE VOWEL SIGN PANEULEUNG
	{0x1BAA, 0x1BAA, prExtend},    // Mc       SUNDANESE SIGN PAMAAEH
	{0x1BAB, 0x1BAD, prExtend},    // Mn   [3] SUNDANESE SIGN VIRAMA..SUNDANESE CONSONANT SIGN PASANGAN WA
	{0x1BAE, 0x1BAF, prOLetter},   // Lo   [2] SUNDANESE LETTER KHA..SUNDANESE LETTER SYA
	{0x1BB0, 0x1BB9, prNumeric},   // Nd  [10] SUNDANESE DIGIT ZERO..SUNDANESE DIGIT NINE
	{0x1BBA, 0x1BE5, prOLetter},   // Lo  [44] SUNDANESE AVAGRAHA..BATAK LETTER U
	{0x1BE6, 0x1BE6, prExtend},    // Mn       BATAK SIGN TOMPI
	{0x1BE7, 0x1BE7, prExtend},    // Mc       BATAK VOWEL SIGN E
	{0x1BE8, 0x1BE9, prExtend},    // Mn   [2] BATAK VOWEL SIGN PAKPAK E..BATAK VOWEL SIGN EE
	{0x1BEA, 0x1BEC, prExtend},    // Mc   [3] BATAK VOWEL SIGN I..BATAK VOWEL SIGN O
	{0x1BED, 0x1BED, prExtend},    // Mn       BATAK VOWEL SIGN KARO O
	{0x1BEE, 0x1BEE, prExtend},    // Mc       BATAK VOWEL SIGN U
	{0x1BEF, 0x1BF1, prExtend},    // Mn   [3] BATAK VOWEL SIGN U FOR SIMALUNGUN SA..BATAK CONSONANT SIGN H
	{0x1BF2, 0x1BF3, prExtend},    // Mc   [2] BATAK PANGOLAT..BATAK PANONGONAN
	{0x1C00, 0x1C23, prOLetter},   // Lo  [36] LEPCHA LETTER KA..LEPCHA LETTER A
	{0x1C24, 0x1C2B, prExtend},    // Mc   [8] LEPCHA SUBJOINED LETTER YA..LEPCHA VOWEL SIGN UU
	{0x1C2C, 0x1C33, prExtend},    // Mn   [8] LEPCHA VOWEL SIGN E..LEPCHA CONSONANT SIGN T
	{0x1C34, 0x1C35, prExtend},    // Mc   [2] LEPCHA CONSONANT SIGN NYIN-DO..LEPCHA CONSONANT SIGN KANG
	{0x1C36, 0x1C37, prExtend},    // Mn   [2] LEPCHA SIGN RAN..LEPCHA SIGN NUKTA
	{0x1C3B, 0x1C3C, prSTerm},     // Po   [2] LEPCHA PUNCTUATION TA-ROL..LEPCHA PUNCTUATION NYET THYOOM TA-ROL
	{0x1C40, 0x1C49, prNumeric},   // Nd  [10] LEPCHA DIGIT ZERO..LEPCHA DIGIT NINE
	{0x1C4D, 0x1C4F, prOLetter},   // Lo   [3] LEPCHA LETTER TTA..LEPCHA LETTER DDA
	{0x1C50, 0x1C59, prNumeric},   // Nd  [10] OL CHIKI DIGIT ZERO..OL CHIKI DIGIT NINE
	{0x1C5A, 0x1C77, prOLetter},   // Lo  [30] OL CHIKI LETTER LA..OL CHIKI LETTER OH
	{0x1C78, 0x1C7D, prOLetter},   // Lm   [6] OL CHIKI MU TTUDDAG..OL CHIKI AHAD
	{0x1C7E, 0x1C7F, prSTerm},     // Po   [2] OL CHIKI PUNCTUATION MUCAAD..OL CHIKI PUNCTUATION DOUBLE MUCAAD
	{0x1C80, 0x1C88, prLower},     // L&   [9] CYRILLIC SMALL LETTER ROUNDED VE..CYRILLIC SMALL LETTER UNBLENDED UK
	{0x1C90, 0x1CBA, prOLetter},   // L&  [43] GEORGIAN MTAVRULI CAPITAL LETTER AN..GEORGIAN MTAVRULI CAPITAL LETTER AIN
	{0x1CBD, 0x1CBF, prOLetter},   // L&   [3] GEORGIAN MTAVRULI CAPITAL LETTER AEN..GEORGIAN MTAVRULI CAPITAL LETTER LABIAL SIGN
	{0x1CD0, 0x1CD2, prExtend},    // Mn   [3] VEDIC TONE KARSHANA..VEDIC TONE PRENKHA
	{0x1CD4, 0x1CE0, prExtend},    // Mn  [13] VEDIC SIGN YAJURVEDIC MIDLINE SVARITA..VEDIC TONE RIGVEDIC KASHMIRI INDEPENDENT SVARITA
	{0x1CE1, 0x1CE1, prExtend},    // Mc       VEDIC TONE ATHARVAVEDIC INDEPENDENT SVARITA
	{0x1CE2, 0x1CE8, prExtend},    // Mn   [7] VEDIC SIGN VISARGA SVARITA..VEDIC SIGN VISARGA ANUDATTA WITH TAIL
	{0x1CE9, 0x1CEC, prOLetter},   // Lo   [4] VEDIC SIGN ANUSVARA ANTARGOMUKHA..VEDIC SIGN ANUSVARA VAMAGOMUKHA WITH TAIL
	{0x1CED, 0x1CED, prExtend},    // Mn       VEDIC SIGN TIRYAK
	{0x1CEE, 0x1CF3, prOLetter},   // Lo   [6] VEDIC SIGN HEXIFORM LONG ANUSVARA..VEDIC SIGN ROTATED ARDHAVISARGA
	{0x1CF4, 0x1CF4, prExtend},    // Mn       VEDIC TONE CANDRA ABOVE
	{0x1CF5, 0x1CF6, prOLetter},   // Lo   [2] VEDIC SIGN JIHVAMULIYA..VEDIC SIGN UPADHMANIYA
	{0x1CF7, 0x1CF7, prExtend},    // Mc       VEDIC SIGN ATIKRAMA
	{0x1CF8, 0x1CF9, prExtend},    // Mn   [2] VEDIC TONE RING ABOVE..VEDIC TONE DOUBLE RING ABOVE
	{0x1CFA, 0x1CFA, prOLetter},   // Lo       VEDIC SIGN DOUBLE ANUSVARA ANTARGOMUKHA
	{0x1D00, 0x1D2B, prLower},     // L&  [44] LATIN LETTER SMALL CAPITAL A..CYRILLIC LETTER SMALL CAPITAL EL
	{0x1D2C, 0x1D6A, prLower},     // Lm  [63] MODIFIER LETTER CAPITAL A..GREEK SUBSCRIPT SMALL LETTER CHI
	{0x1D6B, 0x1D77, prLower},     // L&  [13] LATIN SMALL LETTER UE..LATIN SMALL LETTER TURNED G
	{0x1D78, 0x1D78, prLower},     // Lm       MODIFIER LETTER CYRILLIC EN
	{0x1D79, 0x1D9A, prLower},     // L&  [34] LATIN SMALL LETTER INSULAR G..LATIN SMALL LETTER EZH WITH RETROFLEX HOOK
	{0x1D9B, 0x1DBF, prLower},     // Lm  [37] MODIFIER LETTER SMALL TURNED ALPHA..MODIFIER LETTER SMALL THETA
	{0x1DC0, 0x1DFF, prExtend},    // Mn  [64] COMBINING DOTTED GRAVE ACCENT..COMBINING RIGHT ARROWHEAD AND DOWN ARROWHEAD BELOW
	{0x1E00, 0x1E00, prUpper},     // L&       LATIN CAPITAL LETTER A WITH RING BELOW
	{0x1E01, 0x1E01, prLower},     // L&       LATIN SMALL LETTER A WITH RING BELOW
	{0x1E02, 0x1E02, prUpper},     // L&       LATIN CAPITAL LETTER B WITH DOT ABOVE
	{0x1E03, 0x1E03, prLower},     // L&       LATIN SMALL LETTER B WITH DOT ABOVE
	{0x1E04, 0x1E04, prUpper},     // L&       LATIN CAPITAL LETTER B WITH DOT BELOW
	{0x1E05, 0x1E05, prLower},     // L&       LATIN SMALL LETTER B WITH DOT BELOW
	{0x1E06, 0x1E06, prUpper},     // L&       LATIN CAPITAL LETTER B WITH LINE BELOW
	{0x1E07, 0x1E07, prLower},     // L&       LATIN SMALL LETTER B WITH LINE BELOW
	{0x1E08, 0x1E08, prUpper},     // L&       LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
	{0x1E09, 0x1E09, prLower},     // L&       LATIN SMALL LETTER C WITH CEDILLA AND ACUTE
	{0x1E0A, 0x1E0A, prUpper},     // L&       LATIN CAPITAL LETTER D WITH DOT ABOVE
	{0x1E0B, 0x1E0B, prLower},     // L&       LATIN SMALL LETTER D WITH DOT ABOVE
	{0x1E0C, 0x1E0C, prUpper},     // L&       LATIN CAPITAL LETTER D WITH DOT BELOW
	{0x1E0D, 0x1E0D, prLower},     // L&       LATIN SMALL LETTER D WITH DOT BELOW
	{0x1E0E, 0x1E0E, prUpper},     // L&       LATIN CAPITAL LETTER D WITH LINE BELOW
	{0x1E0F, 0x1E0F, prLower},     // L&       LATIN SMALL LETTER D WITH LINE BELOW
	{0x1E10, 0x1E10, prUpper},     // L&       LATIN CAPITAL LETTER D WITH CEDILLA
	{0x1E11, 0x1E11, prLower},     // L&       LATIN SMALL LETTER D WITH CEDILLA
	{0x1E12, 0x1E12, prUpper},     // L&       LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
	{0x1E13, 0x1E13, prLower},     // L&       LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW
	{0x1E14, 0x1E14, prUpper},     // L&       LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
	{0x1E15, 0x1E15, prLower},     // L&       LATIN SMALL LETTER E WITH MACRON AND GRAVE
	{0x1E16, 0x1E16, prUpper},     // L&       LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
	{0x1E17, 0x1E17, prLower},     // L&       LATIN SMALL LETTER E WITH MACRON AND ACUTE
	{0x1E18, 0x1E18, prUpper},     // L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
	{0x1E19, 0x1E19, prLower},     // L&       LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW
	{0x1E1A, 0x1E1A, prUpper},     // L&       LATIN CAPITAL LETTER E WITH TILDE BELOW
	{0x1E1B, 0x1E1B, prLower},     // L&       LATIN SMALL LETTER E WITH TILDE BELOW
	{0x1E1C, 0x1E1C, prUpper},     // L&       LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
	{0x1E1D, 0x1E1D, prLower},     // L&       LATIN SMALL LETTER E WITH CEDILLA AND BREVE
	{0x1E1E, 0x1E1E, prUpper},     // L&       LATIN CAPITAL LETTER F WITH DOT ABOVE
	{0x1E1F, 0x1E1F, prLower},     // L&       LATIN SMALL LETTER F WITH DOT ABOVE
	{0x1E20, 0x1E20, prUpper},     // L&       LATIN CAPITAL LETTER G WITH MACRON
	{0x1E21, 0x1E21, prLower},     // L&       LATIN SMALL LETTER G WITH MACRON
	{0x1E22, 0x1E22, prUpper},     // L&       LATIN CAPITAL LETTER H WITH DOT ABOVE
	{0x1E23, 0x1E23, prLower},     // L&       LATIN SMALL LETTER H WITH DOT ABOVE
	{0x1E24, 0x1E24, prUpper},     // L&       LATIN CAPITAL LETTER H WITH DOT BELOW
	{0x1E25, 0x1E25, prLower},     // L&       LATIN SMALL LETTER H WITH DOT BELOW
	{0x1E26, 0x1E26, prUpper},     // L&       LATIN CAPITAL LETTER H WITH DIAERESIS
	{0x1E27, 0x1E27, prLower},     // L&       LATIN SMALL LETTER H WITH DIAERESIS
	{0x1E28, 0x1E28, prUpper},     // L&       LATIN CAPITAL LETTER H WITH CEDILLA
	{0x1E29, 0x1E29, prLower},     // L&       LATIN SMALL LETTER H WITH CEDILLA
	{0x1E2A, 0x1E2A, prUpper},     // L&       LATIN CAPITAL LETTER H WITH BREVE BELOW
	{0x1E2B, 0x1E2B, prLower},     // L&       LATIN SMALL LETTER H WITH BREVE BELOW
	{0x1E2C, 0x1E2C, prUpper},     // L&       LATIN CAPITAL LETTER I WITH TILDE BELOW
	{0x1E2D, 0x1E2D, prLower},     // L&       LATIN SMALL LETTER I WITH TILDE BELOW
	{0x1E2E, 0x1E2E, prUpper},     // L&       LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
	{0x1E2F, 0x1E2F, prLower},     // L&       LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE
	{0x1E30, 0x1E30, prUpper},     // L&       LATIN CAPITAL LETTER K WITH ACUTE
	{0x1E31, 0x1E31, prLower},     // L&       LATIN SMALL LETTER K WITH ACUTE
	{0x1E32, 0x1E32, prUpper},     // L&       LATIN CAPITAL LETTER K WITH DOT BELOW
	{0x1E33, 0x1E33, prLower},     // L&       LATIN SMALL LETTER K WITH DOT BELOW
	{0x1E34, 0x1E34, prUpper},     // L&       LATIN CAPITAL LETTER K WITH LINE BELOW
	{0x1E35, 0x1E35, prLower},     // L&       LATIN SMALL LETTER K WITH LINE BELOW
	{0x1E36, 0x1E36, prUpper},     // L&       LATIN CAPITAL LETTER L WITH DOT BELOW
	{0x1E37, 0x1E37, prLower},     // L&       LATIN SMALL LETTER L WITH DOT BELOW
	{0x1E38, 0x1E38, prUpper},     // L&       LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
	{0x1E39, 0x1E39, prLower},     // L&       LATIN SMALL LETTER L WITH DOT BELOW AND MACRON
	{0x1E3A, 0x1E3A, prUpper},     // L&       LATIN CAPITAL LETTER L WITH LINE BELOW
	{0x1E3B, 0x1E3B, prLower},     // L&       LATIN SMALL LETTER L WITH LINE BELOW
	{0x1E3C, 0x1E3C, prUpper},     // L&       LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
	{0x1E3D, 0x1E3D, prLower},     // L&       LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW
	{0x1E3E, 0x1E3E, prUpper},     // L&       LATIN CAPITAL LETTER M WITH ACUTE
	{0x1E3F, 0x1E3F, prLower},     // L&       LATIN SMALL LETTER M WITH ACUTE
	{0x1E40, 0x1E40, prUpper},     // L&       LATIN CAPITAL LETTER M WITH DOT ABOVE
	{0x1E41, 0x1E41, prLower},     // L&       LATIN SMALL LETTER M WITH DOT ABOVE
	{0x1E42, 0x1E42, prUpper},     // L&       LATIN CAPITAL LETTER M WITH DOT BELOW
	{0x1E43, 0x1E43, prLower},     // L&       LATIN SMALL LETTER M WITH DOT BELOW
	{0x1E44, 0x1E44, prUpper},     // L&       LATIN CAPITAL LETTER N WITH DOT ABOVE
	{0x1E45, 0x1E45, prLower},     // L&       LATIN SMALL LETTER N WITH DOT ABOVE
	{0x1E46, 0x1E46, prUpper},     // L&       LATIN CAPITAL LETTER N WITH DOT BELOW
	{0x1E47, 0x1E47, prLower},     // L&       LATIN SMALL LETTER N WITH DOT BELOW
	{0x1E48, 0x1E48, prUpper},     // L&       LATIN CAPITAL LETTER N WITH LINE BELOW
	{0x1E49, 0x1E49, prLower},     // L&       LATIN SMALL LETTER N WITH LINE BELOW
	{0x1E4A, 0x1E4A, prUpper},     // L&       LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
	{0x1E4B, 0x1E4B, prLower},     // L&       LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW
	{0x1E4C, 0x1E4C, prUpper},     // L&       LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
	{0x1E4D, 0x1E4D, prLower},     // L&       LATIN SMALL LETTER O WITH TILDE AND ACUTE
	{0x1E4E, 0x1E4E, prUpper},     // L&       LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
	{0x1E4F, 0x1E4F, prLower},     // L&       LATIN SMALL LETTER O WITH TILDE AND DIAERESIS
	{0x1E50, 0x1E50, prUpper},     // L&       LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
	{0x1E51, 0x1E51, prLower},     // L&       LATIN SMALL LETTER O WITH MACRON AND GRAVE
	{0x1E52, 0x1E52, prUpper},     // L&       LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
	{0x1E53, 0x1E53, prLower},     // L&       LATIN SMALL LETTER O WITH MACRON AND ACUTE
	{0x1E54, 0x1E54, prUpper},     // L&       LATIN CAPITAL LETTER P WITH ACUTE
	{0x1E55, 0x1E55, prLower},     // L&       LATIN SMALL LETTER P WITH ACUTE
	{0x1E56, 0x1E56, prUpper},     // L&       LATIN CAPITAL LETTER P WITH DOT ABOVE
	{0x1E57, 0x1E57, prLower},     // L&       LATIN SMALL LETTER P WITH DOT ABOVE
	{0x1E58, 0x1E58, prUpper},     // L&       LATIN CAPITAL LETTER R WITH DOT ABOVE
	{0x1E59, 0x1E59, prLower},     // L&       LATIN SMALL LETTER R WITH DOT ABOVE
	{0x1E5A, 0x1E5A, prUpper},     // L&       LATIN CAPITAL LETTER R WITH DOT BELOW
	{0x1E5B, 0x1E5B, prLower},     // L&       LATIN SMALL LETTER R WITH DOT BELOW
	{0x1E5C, 0x1E5C, prUpper},     // L&       LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
	{0x1E5D, 0x1E5D, prLower},     // L&       LATIN SMALL LETTER R WITH DOT BELOW AND MACRON
	{0x1E5E, 0x1E5E, prUpper},     // L&       LATIN CAPITAL LETTER R WITH LINE BELOW
	{0x1E5F, 0x1E5F, prLower},     // L&       LATIN SMALL LETTER R WITH LINE BELOW
	{0x1E60, 0x1E60, prUpper},     // L&       LATIN CAPITAL LETTER S WITH DOT ABOVE
	{0x1E61, 0x1E61, prLower},     // L&       LATIN SMALL LETTER S WITH DOT ABOVE
	{0x1E62, 0x1E62, prUpper},     // L&       LATIN CAPITAL LETTER S WITH DOT BELOW
	{0x1E63, 0x1E63, prLower},     // L&       LATIN SMALL LETTER S WITH DOT BELOW
	{0x1E64, 0x1E64, prUpper},     // L&       LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
	{0x1E65, 0x1E65, prLower},     // L&       LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE
	{0x1E66, 0x1E66, prUpper},     // L&       LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
	{0x1E67, 0x1E67, prLower},     // L&       LATIN SMALL LETTER S WITH CARON AND DOT ABOVE
	{0x1E68, 0x1E68, prUpper},     // L&       LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
	{0x1E69, 0x1E69, prLower},     // L&       LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE
	{0x1E6A, 0x1E6A, prUpper},     // L&       LATIN CAPITAL LETTER T WITH DOT ABOVE
	{0x1E6B, 0x1E6B, prLower},     // L&       LATIN SMALL LETTER T WITH DOT ABOVE
	{0x1E6C, 0x1E6C, prUpper},     // L&       LATIN CAPITAL LETTER T WITH DOT BELOW
	{0x1E6D, 0x1E6D, prLower},     // L&       LATIN SMALL LETTER T WITH DOT BELOW
	{0x1E6E, 0x1E6E, prUpper},     // L&       LATIN CAPITAL LETTER T WITH LINE BELOW
	{0x1E6F, 0x1E6F, prLower},     // L&       LATIN SMALL LETTER T WITH LINE BELOW
	{0x1E70, 0x1E70, prUpper},     // L&       LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
	{0x1E71, 0x1E71, prLower},     // L&       LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW
	{0x1E72, 0x1E72, prUpper},     // L&       LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
	{0x1E73, 0x1E73, prLower},     // L&       LATIN SMALL LETTER U WITH DIAERESIS BELOW
	{0x1E74, 0x1E74, prUpper},     // L&       LATIN CAPITAL LETTER U WITH TILDE BELOW
	{0x1E75, 0x1E75, prLower},     // L&       LATIN SMALL LETTER U WITH TILDE BELOW
	{0x1E76, 0x1E76, prUpper},     // L&       LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
	{0x1E77, 0x1E77, prLower},     // L&       LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW
	{0x1E78, 0x1E78, prUpper},     // L&       LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
	{0x1E79, 0x1E79, prLower},     // L&       LATIN SMALL LETTER U WITH TILDE AND ACUTE
	{0x1E7A, 0x1E7A, prUpper},     // L&       LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
	{0x1E7B, 0x1E7B, prLower},     // L&       LATIN SMALL LETTER U WITH MACRON AND DIAERESIS
	{0x1E7C, 0x1E7C, prUpper},     // L&       LATIN CAPITAL LETTER V WITH TILDE
	{0x1E7D, 0x1E7D, prLower},     // L&       LATIN SMALL LETTER V WITH TILDE
	{0x1E7E, 0x1E7E, prUpper},     // L&       LATIN CAPITAL LETTER V WITH DOT BELOW
	{0x1E7F, 0x1E7F, prLower},     // L&       LATIN SMALL LETTER V WITH DOT BELOW
	{0x1E80, 0x1E80, prUpper},     // L&       LATIN CAPITAL LETTER W WITH GRAVE
	{0x1E81, 0x1E81, prLower},     // L&       LATIN SMALL LETTER W WITH GRAVE
	{0x1E82, 0x1E82, prUpper},     // L&       LATIN CAPITAL LETTER W WITH ACUTE
	{0x1E83, 0x1E83, prLower},     // L&       LATIN SMALL LETTER W WITH ACUTE
	{0x1E84, 0x1E84, prUpper},     // L&       LATIN CAPITAL LETTER W WITH DIAERESIS
	{0x1E85, 0x1E85, prLower},     // L&       LATIN SMALL LETTER W WITH DIAERESIS
	{0x1E86, 0x1E86, prUpper},     // L&       LATIN CAPITAL LETTER W WITH DOT ABOVE
	{0x1E87, 0x1E87, prLower},     // L&       LATIN SMALL LETTER W WITH DOT ABOVE
	{0x1E88, 0x1E88, prUpper},     // L&       LATIN CAPITAL LETTER W WITH DOT BELOW
	{0x1E89, 0x1E89, prLower},     // L&       LATIN SMALL LETTER W WITH DOT BELOW
	{0x1E8A, 0x1E8A, prUpper},     // L&       LATIN CAPITAL LETTER X WITH DOT ABOVE
	{0x1E8B, 0x1E8B, prLower},     // L&       LATIN SMALL LETTER X WITH DOT ABOVE
	{0x1E8C, 0x1E8C, prUpper},     // L&       LATIN CAPITAL LETTER X WITH DIAERESIS
	{0x1E8D, 0x1E8D, prLower},     // L&       LATIN SMALL LETTER X WITH DIAERESIS
	{0x1E8E, 0x1E8E, prUpper},     // L&       LATIN CAPITAL LETTER Y WITH DOT ABOVE
	{0x1E8F, 0x1E8F, prLower},     // L&       LATIN SMALL LETTER Y WITH DOT ABOVE
	{0x1E90, 0x1E90, prUpper},     // L&       LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
	{0x1E91, 0x1E91, prLower},     // L&       LATIN SMALL LETTER Z WITH CIRCUMFLEX
	{0x1E92, 0x1E92, prUpper},     // L&       LATIN CAPITAL LETTER Z WITH DOT BELOW
	{0x1E93, 0x1E93, prLower},     // L&       LATIN SMALL LETTER Z WITH DOT BELOW
	{0x1E94, 0x1E94, prUpper},     // L&       LATIN CAPITAL LETTER Z WITH LINE BELOW
	{0x1E95, 0x1E9D, prLower},     // L&   [9] LATIN SMALL LETTER Z WITH LINE BELOW..LATIN SMALL LETTER LONG S WITH HIGH STROKE
	{0x1E9E, 0x1E9E, prUpper},     // L&       LATIN CAPITAL LETTER SHARP S
	{0x1E9F, 0x1E9F, prLower},     // L&       LATIN SMALL LETTER DELTA
	{0x1EA0, 0x1EA0, prUpper},     // L&       LATIN CAPITAL LETTER A WITH DOT BELOW
	{0x1EA1, 0x1EA1, prLower},     // L&       LATIN SMALL LETTER A WITH DOT BELOW
	{0x1EA2, 0x1EA2, prUpper},     // L&       LATIN CAPITAL LETTER A WITH HOOK ABOVE
	{0x1EA3, 0x1EA3, prLower},     // L&       LATIN SMALL LETTER A WITH HOOK ABOVE
	{0x1EA4, 0x1EA4, prUpper},     // L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
	{0x1EA5, 0x1EA5, prLower},     // L&       LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE
	{0x1EA6, 0x1EA6, prUpper},     // L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
	{0x1EA7, 0x1EA7, prLower},     // L&       LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE
	{0x1EA8, 0x1EA8, prUpper},     // L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
	{0x1EA9, 0x1EA9, prLower},     // L&       LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
	{0x1EAA, 0x1EAA, prUpper},     // L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
	{0x1EAB, 0x1EAB, prLower},     // L&       LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE
	{0x1EAC, 0x1EAC, prUpper},     // L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
	{0x1EAD, 0x1EAD, prLower},     // L&       LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW
	{0x1EAE, 0x1EAE, prUpper},     // L&       LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
	{0x1EAF, 0x1EAF, prLower},     // L&       LATIN SMALL LETTER A WITH BREVE AND ACUTE
	{0x1EB0, 0x1EB0, prUpper},     // L&       LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
	{0x1EB1, 0x1EB1, prLower},     // L&       LATIN SMALL LETTER A WITH BREVE AND GRAVE
	{0x1EB2, 0x1EB2, prUpper},     // L&       LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
	{0x1EB3, 0x1EB3, prLower},     // L&       LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE
	{0x1EB4, 0x1EB4, prUpper},     // L&       LATIN CAPITAL LETTER A WITH BREVE AND TILDE
	{0x1EB5, 0x1EB5, prLower},     // L&       LATIN SMALL LETTER A WITH BREVE AND TILDE
	{0x1EB6, 0x1EB6, prUpper},     // L&       LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
	{0x1EB7, 0x1EB7, prLower},     // L&       LATIN SMALL LETTER A WITH BREVE AND DOT BELOW
	{0x1EB8, 0x1EB8, prUpper},     // L&       LATIN CAPITAL LETTER E WITH DOT BELOW
	{0x1EB9, 0x1EB9, prLower},     // L&       LATIN SMALL LETTER E WITH DOT BELOW
	{0x1EBA, 0x1EBA, prUpper},     // L&       LATIN CAPITAL LETTER E WITH HOOK ABOVE
	{0x1EBB, 0x1EBB, prLower},     // L&       LATIN SMALL LETTER E WITH HOOK ABOVE
	{0x1EBC, 0x1EBC, prUpper},     // L&       LATIN CAPITAL LETTER E WITH TILDE
	{0x1EBD, 0x1EBD, prLower},     // L&       LATIN SMALL LETTER E WITH TILDE
	{0x1EBE, 0x1EBE, prUpper},     // L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
	{0x1EBF, 0x1EBF, prLower},     // L&       LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
	{0x1EC0, 0x1EC0, prUpper},     // L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
	{0x1EC1, 0x1EC1, prLower},     // L&       LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
	{0x1EC2, 0x1EC2, prUpper},     // L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
	{0x1EC3, 0x1EC3, prLower},     // L&       LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
	{0x1EC4, 0x1EC4, prUpper},     // L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
	{0x1EC5, 0x1EC5, prLower},     // L&       LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
	{0x1EC6, 0x1EC6, prUpper},     // L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
	{0x1EC7, 0x1EC7, prLower},     // L&       LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
	{0x1EC8, 0x1EC8, prUpper},     // L&       LATIN CAPITAL LETTER I WITH HOOK ABOVE
	{0x1EC9, 0x1EC9, prLower},     // L&       LATIN SMALL LETTER I WITH HOOK ABOVE
	{0x1ECA, 0x1ECA, prUpper},     // L&       LATIN CAPITAL LETTER I WITH DOT BELOW
	{0x1ECB, 0x1ECB, prLower},     // L&       LATIN SMALL LETTER I WITH DOT BELOW
	{0x1ECC, 0x1ECC, prUpper},     // L&       LATIN CAPITAL LETTER O WITH DOT BELOW
	{0x1ECD, 0x1ECD, prLower},     // L&       LATIN SMALL LETTER O WITH DOT BELOW
	{0x1ECE, 0x1ECE, prUpper},     // L&       LATIN CAPITAL LETTER O WITH HOOK ABOVE
	{0x1ECF, 0x1ECF, prLower},     // L&       LATIN SMALL LETTER O WITH HOOK ABOVE
	{0x1ED0, 0x1ED0, prUpper},     // L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
	{0x1ED1, 0x1ED1, prLower},     // L&       LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE
	{0x1ED2, 0x1ED2, prUpper},     // L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
	{0x1ED3, 0x1ED3, prLower},     // L&       LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE
	{0x1ED4, 0x1ED4, prUpper},     // L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
	{0x1ED5, 0x1ED5, prLower},     // L&       LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
	{0x1ED6, 0x1ED6, prUpper},     // L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
	{0x1ED7, 0x1ED7, prLower},     // L&       LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE
	{0x1ED8, 0x1ED8, prUpper},     // L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
	{0x1ED9, 0x1ED9, prLower},     // L&       LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW
	{0x1EDA, 0x1EDA, prUpper},     // L&       LATIN CAPITAL LETTER O WITH HORN AND ACUTE
	{0x1EDB, 0x1EDB, prLower},     // L&       LATIN SMALL LETTER O WITH HORN AND ACUTE
	{0x1EDC, 0x1EDC, prUpper},     // L&       LATIN CAPITAL LETTER O WITH HORN AND GRAVE
	{0x1EDD, 0x1EDD, prLower},     // L&       LATIN SMALL LETTER O WITH HORN AND GRAVE
	{0x1EDE, 0x1EDE, prUpper},     // L&       LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
	{0x1EDF, 0x1EDF, prLower},     // L&       LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE
	{0x1EE0, 0x1EE0, prUpper},     // L&       LATIN CAPITAL LETTER O WITH HORN AND TILDE
	{0x1EE1, 0x1EE1, prLower},     // L&       LATIN SMALL LETTER O WITH HORN AND TILDE
	{0x1EE2, 0x1EE2, prUpper},     // L&       LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
	{0x1EE3, 0x1EE3, prLower},     // L&       LATIN SMALL LETTER O WITH HORN AND DOT BELOW
	{0x1EE4, 0x1EE4, prUpper},     // L&       LATIN CAPITAL LETTER U WITH DOT BELOW
	{0x1EE5, 0x1EE5, prLower},     // L&       LATIN SMALL LETTER U WITH DOT BELOW
	{0x1EE6, 0x1EE6, prUpper},     // L&       LATIN CAPITAL LETTER U WITH HOOK ABOVE
	{0x1EE7, 0x1EE7, prLower},     // L&       LATIN SMALL LETTER U WITH HOOK ABOVE
	{0x1EE8, 0x1EE8, prUpper},     // L&       LATIN CAPITAL LETTER U WITH HORN AND ACUTE
	{0x1EE9, 0x1EE9, prLower},     // L&       LATIN SMALL LETTER U WITH HORN AND ACUTE
	{0x1EEA, 0x1EEA, prUpper},     // L&       LATIN CAPITAL LETTER U WITH HORN AND GRAVE
	{0x1EEB, 0x1EEB, prLower},     // L&       LATIN SMALL LETTER U WITH HORN AND GRAVE
	{0x1EEC, 0x1EEC, prUpper},     // L&       LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
	{0x1EED, 0x1EED, prLower},     // L&       LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE
	{0x1EEE, 0x1EEE, prUpper},     // L&       LATIN CAPITAL LETTER U WITH HORN AND TILDE
	{0x1EEF, 0x1EEF, prLower},     // L&       LATIN SMALL LETTER U WITH HORN AND TILDE
	{0x1EF0, 0x1EF0, prUpper},     // L&       LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
	{0x1EF1, 0x1EF1, prLower},     // L&       LATIN SMALL LETTER U WITH HORN AND DOT BELOW
	{0x1EF2, 0x1EF2, prUpper},     // L&       LATIN CAPITAL LETTER Y WITH GRAVE
	{0x1EF3, 0x1EF3, prLower},     // L&       LATIN SMALL LETTER Y WITH GRAVE
	{0x1EF4, 0x1EF4, prUpper},     // L&       LATIN CAPITAL LETTER Y WITH DOT BELOW
	{0x1EF5, 0x1EF5, prLower},     // L&       LATIN SMALL LETTER Y WITH DOT BELOW
	{0x1EF6, 0x1EF6, prUpper},     // L&       LATIN CAPITAL LETTER Y WITH HOOK ABOVE
	{0x1EF7, 0x1EF7, prLower},     // L&       LATIN SMALL LETTER Y WITH HOOK ABOVE
	{0x1EF8, 0x1EF8, prUpper},     // L&       LATIN CAPITAL LETTER Y WITH TILDE
	{0x1EF9, 0x1EF9, prLower},     // L&       LATIN SMALL LETTER Y WITH TILDE
	{0x1EFA, 0x1EFA, prUpper},     // L&       LATIN CAPITAL LETTER MIDDLE-WELSH LL
	{0x1EFB, 0x1EFB, prLower},     // L&       LATIN SMALL LETTER MIDDLE-WELSH LL
	{0x1EFC, 0x1EFC, prUpper},     // L&       LATIN CAPITAL LETTER MIDDLE-WELSH V
	{0x1EFD, 0x1EFD, prLower},     // L&       LATIN SMALL LETTER MIDDLE-WELSH V
	{0x1EFE, 0x1EFE, prUpper},     // L&       LATIN CAPITAL LETTER Y WITH LOOP
	{0x1EFF, 0x1F07, prLower},     // L&   [9] LATIN SMALL LETTER Y WITH LOOP..GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI
	{0x1F08, 0x1F0F, prUpper},     // L&   [8] GREEK CAPITAL LETTER ALPHA WITH PSILI..GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
	{0x1F10, 0x1F15, prLower},     // L&   [6] GREEK SMALL LETTER EPSILON WITH PSILI..GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
	{0x1F18, 0x1F1D, prUpper},     // L&   [6] GREEK CAPITAL LETTER EPSILON WITH PSILI..GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
	{0x1F20, 0x1F27, prLower},     // L&   [8] GREEK SMALL LETTER ETA WITH PSILI..GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI
	{0x1F28, 0x1F2F, prUpper},     // L&   [8] GREEK CAPITAL LETTER ETA WITH PSILI..GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
	{0x1F30, 0x1F37, prLower},     // L&   [8] GREEK SMALL LETTER IOTA WITH PSILI..GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI
	{0x1F38, 0x1F3F, prUpper},     // L&   [8] GREEK CAPITAL LETTER IOTA WITH PSILI..GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI
	{0x1F40, 0x1F45, prLower},     // L&   [6] GREEK SMALL LETTER OMICRON WITH PSILI..GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
	{0x1F48, 0x1F4D, prUpper},     // L&   [6] GREEK CAPITAL LETTER OMICRON WITH PSILI..GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
	{0x1F50, 0x1F57, prLower},     // L&   [8] GREEK SMALL LETTER UPSILON WITH PSILI..GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
	{0x1F59, 0x1F59, prUpper},     // L&       GREEK CAPITAL LETTER UPSILON WITH DASIA
	{0x1F5B, 0x1F5B, prUpper},     // L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
	{0x1F5D, 0x1F5D, prUpper},     // L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
	{0x1F5F, 0x1F5F, prUpper},     // L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI
	{0x1F60, 0x1F67, prLower},     // L&   [8] GREEK SMALL LETTER OMEGA WITH PSILI..GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI
	{0x1F68, 0x1F6F, prUpper},     // L&   [8] GREEK CAPITAL LETTER OMEGA WITH PSILI..GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
	{0x1F70, 0x1F7D, prLower},     // L&  [14] GREEK SMALL LETTER ALPHA WITH VARIA..GREEK SMALL LETTER OMEGA WITH OXIA
	{0x1F80, 0x1F87, prLower},     // L&   [8] GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
	{0x1F88, 0x1F8F, prUpper},     // L&   [8] GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI..GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
	{0x1F90, 0x1F97, prLower},     // L&   [8] GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
	{0x1F98, 0x1F9F, prUpper},     // L&   [8] GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI..GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
	{0x1FA0, 0x1FA7, prLower},     // L&   [8] GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
	{0x1FA8, 0x1FAF, prUpper},     // L&   [8] GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI..GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
	{0x1FB0, 0x1FB4, prLower},     // L&   [5] GREEK SMALL LETTER ALPHA WITH VRACHY..GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
	{0x1FB6, 0x1FB7, prLower},     // L&   [2] GREEK SMALL LETTER ALPHA WITH PERISPOMENI..GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI
	{0x1FB8, 0x1FBC, prUpper},     // L&   [5] GREEK CAPITAL LETTER ALPHA WITH VRACHY..GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
	{0x1FBE, 0x1FBE, prLower},     // L&       GREEK PROSGEGRAMMENI
	{0x1FC2, 0x1FC4, prLower},     // L&   [3] GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
	{0x1FC6, 0x1FC7, prLower},     // L&   [2] GREEK SMALL LETTER ETA WITH PERISPOMENI..GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI
	{0x1FC8, 0x1FCC, prUpper},     // L&   [5] GREEK CAPITAL LETTER EPSILON WITH VARIA..GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
	{0x1FD0, 0x1FD3, prLower},     // L&   [4] GREEK SMALL LETTER IOTA WITH VRACHY..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
	{0x1FD6, 0x1FD7, prLower},     // L&   [2] GREEK SMALL LETTER IOTA WITH PERISPOMENI..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI
	{0x1FD8, 0x1FDB, prUpper},     // L&   [4] GREEK CAPITAL LETTER IOTA WITH VRACHY..GREEK CAPITAL LETTER IOTA WITH OXIA
	{0x1FE0, 0x1FE7, prLower},     // L&   [8] GREEK SMALL LETTER UPSILON WITH VRACHY..GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI
	{0x1FE8, 0x1FEC, prUpper},     // L&   [5] GREEK CAPITAL LETTER UPSILON WITH VRACHY..GREEK CAPITAL LETTER RHO WITH DASIA
	{0x1FF2, 0x1FF4, prLower},     // L&   [3] GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
	{0x1FF6, 0x1FF7, prLower},     // L&   [2] GREEK SMALL LETTER OMEGA WITH PERISPOMENI..GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI
	{0x1FF8, 0x1FFC, prUpper},     // L&   [5] GREEK CAPITAL LETTER OMICRON WITH VARIA..GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
	{0x2000, 0x200A, prSp},        // Zs  [11] EN QUAD..HAIR SPACE
	{0x200B, 0x200B, prFormat},    // Cf       ZERO WIDTH SPACE
	{0x200C, 0x200D, prExtend},    // Cf   [2] ZERO WIDTH NON-JOINER..ZERO WIDTH JOINER
	{0x200E, 0x200F, prFormat},    // Cf   [2] LEFT-TO-RIGHT MARK..RIGHT-TO-LEFT MARK
	{0x2013, 0x2014, prSContinue}, // Pd   [2] EN DASH..EM DASH
	{0x2018, 0x2018, prClose},     // Pi       LEFT SINGLE QUOTATION MARK
	{0x2019, 0x2019, prClose},     // Pf       RIGHT SINGLE QUOTATION MARK
	{0x201A, 0x201A, prClose},     // Ps       SINGLE LOW-9 QUOTATION MARK
	{0x201B, 0x201C, prClose},     // Pi   [2] SINGLE HIGH-REVERSED-9 QUOTATION MARK..LEFT DOUBLE QUOTATION MARK
	{0x201D, 0x201D, prClose},     // Pf       RIGHT DOUBLE QUOTATION MARK
	{0x201E, 0x201E, prClose},     // Ps       DOUBLE LOW-9 QUOTATION MARK
	{0x201F, 0x201F, prClose},     // Pi       DOUBLE HIGH-REVERSED-9 QUOTATION MARK
	{0x2024, 0x2024, prATerm},     // Po       ONE DOT LEADER
	{0x2028, 0x2028, prSep},       // Zl       LINE SEPARATOR
	{0x2029, 0x2029, prSep},       // Zp       PARAGRAPH SEPARATOR
	{0x202A, 0x202E, prFormat},    // Cf   [5] LEFT-TO-RIGHT EMBEDDING..RIGHT-TO-LEFT OVERRIDE
	{0x202F, 0x202F, prSp},        // Zs       NARROW NO-BREAK SPACE
	{0x2039, 0x2039, prClose},     // Pi       SINGLE LEFT-POINTING ANGLE QUOTATION MARK
	{0x203A, 0x203A, prClose},     // Pf       SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
	{0x203C, 0x203D, prSTerm},     // Po   [2] DOUBLE EXCLAMATION MARK..INTERROBANG
	{0x2045, 0x2045, prClose},     // Ps       LEFT SQUARE BRACKET WITH QUILL
	{0x2046, 0x2046, prClose},     // Pe       RIGHT SQUARE BRACKET WITH QUILL
	{0x2047, 0x2049, prSTerm},     // Po   [3] DOUBLE QUESTION MARK..EXCLAMATION QUESTION MARK
	{0x205F, 0x205F, prSp},        // Zs       MEDIUM MATHEMATICAL SPACE
	{0x2060, 0x2064, prFormat},    // Cf   [5] WORD JOINER..INVISIBLE PLUS
	{0x2066, 0x206F, prFormat},    // Cf  [10] LEFT-TO-RIGHT ISOLATE..NOMINAL DIGIT SHAPES
	{0x2071, 0x2071, prLower},     // Lm       SUPERSCRIPT LATIN SMALL LETTER I
	{0x207D, 0x207D, prClose},     // Ps       SUPERSCRIPT LEFT PARENTHESIS
	{0x207E, 0x207E, prClose},     // Pe       SUPERSCRIPT RIGHT PARENTHESIS
	{0x207F, 0x207F, prLower},     // Lm       SUPERSCRIPT LATIN SMALL LETTER N
	{0x208D, 0x208D, prClose},     // Ps       SUBSCRIPT LEFT PARENTHESIS
	{0x208E, 0x208E, prClose},     // Pe       SUBSCRIPT RIGHT PARENTHESIS
	{0x2090, 0x209C, prLower},     // Lm  [13] LATIN SUBSCRIPT SMALL LETTER A..LATIN SUBSCRIPT SMALL LETTER T
	{0x20D0, 0x20DC, prExtend},    // Mn  [13] COMBINING LEFT HARPOON ABOVE..COMBINING FOUR DOTS ABOVE
	{0x20DD, 0x20E0, prExtend},    // Me   [4] COMBINING ENCLOSING CIRCLE..COMBINING ENCLOSING CIRCLE BACKSLASH
	{0x20E1, 0x20E1, prExtend},    // Mn       COMBINING LEFT RIGHT ARROW ABOVE
	{0x20E2, 0x20E4, prExtend},    // Me   [3] COMBINING ENCLOSING SCREEN..COMBINING ENCLOSING UPWARD POINTING TRIANGLE
	{0x20E5, 0x20F0, prExtend},    // Mn  [12] COMBINING REVERSE SOLIDUS OVERLAY..COMBINING ASTERISK ABOVE
	{0x2102, 0x2102, prUpper},     // L&       DOUBLE-STRUCK CAPITAL C
	{0x2107, 0x2107, prUpper},     // L&       EULER CONSTANT
	{0x210A, 0x210A, prLower},     // L&       SCRIPT SMALL G
	{0x210B, 0x210D, prUpper},     // L&   [3] SCRIPT CAPITAL H..DOUBLE-STRUCK CAPITAL H
	{0x210E, 0x210F, prLower},     // L&   [2] PLANCK CONSTANT..PLANCK CONSTANT OVER TWO PI
	{0x2110, 0x2112, prUpper},     // L&   [3] SCRIPT CAPITAL I..SCRIPT CAPITAL L
	{0x2113, 0x2113, prLower},     // L&       SCRIPT SMALL L
	{0x2115, 0x2115, prUpper},     // L&       DOUBLE-STRUCK CAPITAL N
	{0x2119, 0x211D, prUpper},     // L&   [5] DOUBLE-STRUCK CAPITAL P..DOUBLE-STRUCK CAPITAL R
	{0x2124, 0x2124, prUpper},     // L&       DOUBLE-STRUCK CAPITAL Z
	{0x2126, 0x2126, prUpper},     // L&       OHM SIGN
	{0x2128, 0x2128, prUpper},     // L&       BLACK-LETTER CAPITAL Z
	{0x212A, 0x212D, prUpper},     // L&   [4] KELVIN SIGN..BLACK-LETTER CAPITAL C
	{0x212F, 0x212F, prLower},     // L&       SCRIPT SMALL E
	{0x2130, 0x2133, prUpper},     // L&   [4] SCRIPT CAPITAL E..SCRIPT CAPITAL M
	{0x2134, 0x2134, prLower},     // L&       SCRIPT SMALL O
	{0x2135, 0x2138, prOLetter},   // Lo   [4] ALEF SYMBOL..DALET SYMBOL
	{0x2139, 0x2139, prLower},     // L&       INFORMATION SOURCE
	{0x213C, 0x213D, prLower},     // L&   [2] DOUBLE-STRUCK SMALL PI..DOUBLE-STRUCK SMALL GAMMA
	{0x213E, 0x213F, prUpper},     // L&   [2] DOUBLE-STRUCK CAPITAL GAMMA..DOUBLE-STRUCK CAPITAL PI
	{0x2145, 0x2145, prUpper},     // L&       DOUBLE-STRUCK ITALIC CAPITAL D
	{0x2146, 0x2149, prLower},     // L&   [4] DOUBLE-STRUCK ITALIC SMALL D..DOUBLE-STRUCK ITALIC SMALL J
	{0x214E, 0x214E, prLower},     // L&       TURNED SMALL F
	{0x2160, 0x216F, prUpper},     // Nl  [16] ROMAN NUMERAL ONE..ROMAN NUMERAL ONE THOUSAND
	{0x2170, 0x217F, prLower},     // Nl  [16] SMALL ROMAN NUMERAL ONE..SMALL ROMAN NUMERAL ONE THOUSAND
	{0x2180, 0x2182, prOLetter},   // Nl   [3] ROMAN NUMERAL ONE THOUSAND C D..ROMAN NUMERAL TEN THOUSAND
	{0x2183, 0x2183, prUpper},     // L&       ROMAN NUMERAL REVERSED ONE HUNDRED
	{0x2184, 0x2184, prLower},     // L&       LATIN SMALL LETTER REVERSED C
	{0x2185, 0x2188, prOLetter},   // Nl   [4] ROMAN NUMERAL SIX LATE FORM..ROMAN NUMERAL ONE HUNDRED THOUSAND
	{0x2308, 0x2308, prClose},     // Ps       LEFT CEILING
	{0x2309, 0x2309, prClose},     // Pe       RIGHT CEILING
	{0x230A, 0x230A, prClose},     // Ps       LEFT FLOOR
	{0x230B, 0x230B, prClose},     // Pe       RIGHT FLOOR
	{0x2329, 0x2329, prClose},     // Ps       LEFT-POINTING ANGLE BRACKET
	{0x232A, 0x232A, prClose},     // Pe       RIGHT-POINTING ANGLE BRACKET
	{0x24B6, 0x24CF, prUpper},     // So  [26] CIRCLED LATIN CAPITAL LETTER A..CIRCLED LATIN CAPITAL LETTER Z
	{0x24D0, 0x24E9, prLower},     // So  [26] CIRCLED LATIN SMALL LETTER A..CIRCLED LATIN SMALL LETTER Z
	{0x275B, 0x2760, prClose},     // So   [6] HEAVY SINGLE TURNED COMMA QUOTATION MARK ORNAMENT..HEAVY LOW DOUBLE COMMA QUOTATION MARK ORNAMENT
	{0x2768, 0x2768, prClose},     // Ps       MEDIUM LEFT PARENTHESIS ORNAMENT
	{0x2769, 0x2769, prClose},     // Pe       MEDIUM RIGHT PARENTHESIS ORNAMENT
	{0x276A, 0x276A, prClose},     // Ps       MEDIUM FLATTENED LEFT PARENTHESIS ORNAMENT
	{0x276B, 0x276B, prClose},     // Pe       MEDIUM FLATTENED RIGHT PARENTHESIS ORNAMENT
	{0x276C, 0x276C, prClose},     // Ps       MEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENT
	{0x276D, 0x276D, prClose},     // Pe       MEDIUM RIGHT-POINTING ANGLE BRACKET ORNAMENT
	{0x276E, 0x276E, prClose},     // Ps       HEAVY LEFT-POINTING ANGLE QUOTATION MARK ORNAMENT
	{0x276F, 0x276F, prClose},     // Pe       HEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENT
	{0x2770, 0x2770, prClose},     // Ps       HEAVY LEFT-POINTING ANGLE BRACKET ORNAMENT
	{0x2771, 0x2771, prClose},     // Pe       HEAVY RIGHT-POINTING ANGLE BRACKET ORNAMENT
	{0x2772, 0x2772, prClose},     // Ps       LIGHT LEFT TORTOISE SHELL BRACKET ORNAMENT
	{0x2773, 0x2773, prClose},     // Pe       LIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENT
	{0x2774, 0x2774, prClose},     // Ps       MEDIUM LEFT CURLY BRACKET ORNAMENT
	{0x2775, 0x2775, prClose},     // Pe       MEDIUM RIGHT CURLY BRACKET ORNAMENT
	{0x27C5, 0x27C5, prClose},     // Ps       LEFT S-SHAPED BAG DELIMITER
	{0x27C6, 0x27C6, prClose},     // Pe       RIGHT S-SHAPED BAG DELIMITER
	{0x27E6, 0x27E6, prClose},     // Ps       MATHEMATICAL LEFT WHITE SQUARE BRACKET
	{0x27E7, 0x27E7, prClose},     // Pe       MATHEMATICAL RIGHT WHITE SQUARE BRACKET
	{0x27E8, 0x27E8, prClose},     // Ps       MATHEMATICAL LEFT ANGLE BRACKET
	{0x27E9, 0x27E9, prClose},     // Pe       MATHEMATICAL RIGHT ANGLE BRACKET
	{0x27EA, 0x27EA, prClose},     // Ps       MATHEMATICAL LEFT DOUBLE ANGLE BRACKET
	{0x27EB, 0x27EB, prClose},     // Pe       MATHEMATICAL RIGHT DOUBLE ANGLE BRACKET
	{0x27EC, 0x27EC, prClose},     // Ps       MATHEMATICAL LEFT WHITE TORTOISE SHELL BRACKET
	{0x27ED, 0x27ED, prClose},     // Pe       MATHEMATICAL RIGHT WHITE TORTOISE SHELL BRACKET
	{0x27EE, 0x27EE, prClose},     // Ps       MATHEMATICAL LEFT FLATTENED PARENTHESIS
	{0x27EF, 0x27EF, prClose},     // Pe       MATHEMATICAL RIGHT FLATTENED PARENTHESIS
	{0x2983, 0x2983, prClose},     // Ps       LEFT WHITE CURLY BRACKET
	{0x2984, 0x2984, prClose},     // Pe       RIGHT WHITE CURLY BRACKET
	{0x2985, 0x2985, prClose},     // Ps       LEFT WHITE PARENTHESIS
	{0x2986, 0x2986, prClose},     // Pe       RIGHT WHITE PARENTHESIS
	{0x2987, 0x2987, prClose},     // Ps       Z NOTATION LEFT IMAGE BRACKET
	{0x2988, 0x2988, prClose},     // Pe       Z NOTATION RIGHT IMAGE BRACKET
	{0x2989, 0x2989, prClose},     // Ps       Z NOTATION LEFT BINDING BRACKET
	{0x298A, 0x298A, prClose},     // Pe       Z NOTATION RIGHT BINDING BRACKET
	{0x298B, 0x298B, prClose},     // Ps       LEFT SQUARE BRACKET WITH UNDERBAR
	{0x298C, 0x298C, prClose},     // Pe       RIGHT SQUARE BRACKET WITH UNDERBAR
	{0x298D, 0x298D, prClose},     // Ps       LEFT SQUARE BRACKET WITH TICK IN TOP CORNER
	{0x298E, 0x298E, prClose},     // Pe       RIGHT SQUARE BRACKET WITH TICK IN BOTTOM CORNER
	{0x298F, 0x298F, prClose},     // Ps       LEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNER
	{0x2990, 0x2990, prClose},     // Pe       RIGHT SQUARE BRACKET WITH TICK IN TOP CORNER
	{0x2991, 0x2991, prClose},     // Ps       LEFT ANGLE BRACKET WITH DOT
	{0x2992, 0x2992, prClose},     // Pe       RIGHT ANGLE BRACKET WITH DOT
	{0x2993, 0x2993, prClose},     // Ps       LEFT ARC LESS-THAN BRACKET
	{0x2994, 0x2994, prClose},     // Pe       RIGHT ARC GREATER-THAN BRACKET
	{0x2995, 0x2995, prClose},     // Ps       DOUBLE LEFT ARC GREATER-THAN BRACKET
	{0x2996, 0x2996, prClose},     // Pe       DOUBLE RIGHT ARC LESS-THAN BRACKET
	{0x2997, 0x2997, prClose},     // Ps       LEFT BLACK TORTOISE SHELL BRACKET
	{0x2998, 0x2998, prClose},     // Pe       RIGHT BLACK TORTOISE SHELL BRACKET
	{0x29D8, 0x29D8, prClose},     // Ps       LEFT WIGGLY FENCE
	{0x29D9, 0x29D9, prClose},     // Pe       RIGHT WIGGLY FENCE
	{0x29DA, 0x29DA, prClose},     // Ps       LEFT DOUBLE WIGGLY FENCE
	{0x29DB, 0x29DB, prClose},     // Pe       RIGHT DOUBLE WIGGLY FENCE
	{0x29FC, 0x29FC, prClose},     // Ps       LEFT-POINTING CURVED ANGLE BRACKET
	{0x29FD, 0x29FD, prClose},     // Pe       RIGHT-POINTING CURVED ANGLE BRACKET
	{0x2C00, 0x2C2F, prUpper},     // L&  [48] GLAGOLITIC CAPITAL LETTER AZU..GLAGOLITIC CAPITAL LETTER CAUDATE CHRIVI
	{0x2C30, 0x2C5F, prLower},     // L&  [48] GLAGOLITIC SMALL LETTER AZU..GLAGOLITIC SMALL LETTER CAUDATE CHRIVI
	{0x2C60, 0x2C60, prUpper},     // L&       LATIN CAPITAL LETTER L WITH DOUBLE BAR
	{0x2C61, 0x2C61, prLower},     // L&       LATIN SMALL LETTER L WITH DOUBLE BAR
	{0x2C62, 0x2C64, prUpper},     // L&   [3] LATIN CAPITAL LETTER L WITH MIDDLE TILDE..LATIN CAPITAL LETTER R WITH TAIL
	{0x2C65, 0x2C66, prLower},     // L&   [2] LATIN SMALL LETTER A WITH STROKE..LATIN SMALL LETTER T WITH DIAGONAL STROKE
	{0x2C67, 0x2C67, prUpper},     // L&       LATIN CAPITAL LETTER H WITH DESCENDER
	{0x2C68, 0x2C68, prLower},     // L&       LATIN SMALL LETTER H WITH DESCENDER
	{0x2C69, 0x2C69, prUpper},     // L&       LATIN CAPITAL LETTER K WITH DESCENDER
	{0x2C6A, 0x2C6A, prLower},     // L&       LATIN SMALL LETTER K WITH DESCENDER
	{0x2C6B, 0x2C6B, prUpper},     // L&       LATIN CAPITAL LETTER Z WITH DESCENDER
	{0x2C6C, 0x2C6C, prLower},     // L&       LATIN SMALL LETTER Z WITH DESCENDER
	{0x2C6D, 0x2C70, prUpper},     // L&   [4] LATIN CAPITAL LETTER ALPHA..LATIN CAPITAL LETTER TURNED ALPHA
	{0x2C71, 0x2C71, prLower},     // L&       LATIN SMALL LETTER V WITH RIGHT HOOK
	{0x2C72, 0x2C72, prUpper},     // L&       LATIN CAPITAL LETTER W WITH HOOK
	{0x2C73, 0x2C74, prLower},     // L&   [2] LATIN SMALL LETTER W WITH HOOK..LATIN SMALL LETTER V WITH CURL
	{0x2C75, 0x2C75, prUpper},     // L&       LATIN CAPITAL LETTER HALF H
	{0x2C76, 0x2C7B, prLower},     // L&   [6] LATIN SMALL LETTER HALF H..LATIN LETTER SMALL CAPITAL TURNED E
	{0x2C7C, 0x2C7D, prLower},     // Lm   [2] LATIN SUBSCRIPT SMALL LETTER J..MODIFIER LETTER CAPITAL V
	{0x2C7E, 0x2C80, prUpper},     // L&   [3] LATIN CAPITAL LETTER S WITH SWASH TAIL..COPTIC CAPITAL LETTER ALFA
	{0x2C81, 0x2C81, prLower},     // L&       COPTIC SMALL LETTER ALFA
	{0x2C82, 0x2C82, prUpper},     // L&       COPTIC CAPITAL LETTER VIDA
	{0x2C83, 0x2C83, prLower},     // L&       COPTIC SMALL LETTER VIDA
	{0x2C84, 0x2C84, prUpper},     // L&       COPTIC CAPITAL LETTER GAMMA
	{0x2C85, 0x2C85, prLower},     // L&       COPTIC SMALL LETTER GAMMA
	{0x2C86, 0x2C86, prUpper},     // L&       COPTIC CAPITAL LETTER DALDA
	{0x2C87, 0x2C87, prLower},     // L&       COPTIC SMALL LETTER DALDA
	{0x2C88, 0x2C88, prUpper},     // L&       COPTIC CAPITAL LETTER EIE
	{0x2C89, 0x2C89, prLower},     // L&       COPTIC SMALL LETTER EIE
	{0x2C8A, 0x2C8A, prUpper},     // L&       COPTIC CAPITAL LETTER SOU
	{0x2C8B, 0x2C8B, prLower},     // L&       COPTIC SMALL LETTER SOU
	{0x2C8C, 0x2C8C, prUpper},     // L&       COPTIC CAPITAL LETTER ZATA
	{0x2C8D, 0x2C8D, prLower},     // L&       COPTIC SMALL LETTER ZATA
	{0x2C8E, 0x2C8E, prUpper},     // L&       COPTIC CAPITAL LETTER HATE
	{0x2C8F, 0x2C8F, prLower},     // L&       COPTIC SMALL LETTER HATE
	{0x2C90, 0x2C90, prUpper},     // L&       COPTIC CAPITAL LETTER THETHE
	{0x2C91, 0x2C91, prLower},     // L&       COPTIC SMALL LETTER THETHE
	{0x2C92, 0x2C92, prUpper},     // L&       COPTIC CAPITAL LETTER IAUDA
	{0x2C93, 0x2C93, prLower},     // L&       COPTIC SMALL LETTER IAUDA
	{0x2C94, 0x2C94, prUpper},     // L&       COPTIC CAPITAL LETTER KAPA
	{0x2C95, 0x2C95, prLower},     // L&       COPTIC SMALL LETTER KAPA
	{0x2C96, 0x2C96, prUpper},     // L&       COPTIC CAPITAL LETTER LAULA
	{0x2C97, 0x2C97, prLower},     // L&       COPTIC SMALL LETTER LAULA
	{0x2C98, 0x2C98, prUpper},     // L&       COPTIC CAPITAL LETTER MI
	{0x2C99, 0x2C99, prLower},     // L&       COPTIC SMALL LETTER MI
	{0x2C9A, 0x2C9A, prUpper},     // L&       COPTIC CAPITAL LETTER NI
	{0x2C9B, 0x2C9B, prLower},     // L&       COPTIC SMALL LETTER NI
	{0x2C9C, 0x2C9C, prUpper},     // L&       COPTIC CAPITAL LETTER KSI
	{0x2C9D, 0x2C9D, prLower},     // L&       COPTIC SMALL LETTER KSI
	{0x2C9E, 0x2C9E, prUpper},     // L&       COPTIC CAPITAL LETTER O
	{0x2C9F, 0x2C9F, prLower},     // L&       COPTIC SMALL LETTER O
	{0x2CA0, 0x2CA0, prUpper},     // L&       COPTIC CAPITAL LETTER PI
	{0x2CA1, 0x2CA1, prLower},     // L&       COPTIC SMALL LETTER PI
	{0x2CA2, 0x2CA2, prUpper},     // L&       COPTIC CAPITAL LETTER RO
	{0x2CA3, 0x2CA3, prLower},     // L&       COPTIC SMALL LETTER RO
	{0x2CA4, 0x2CA4, prUpper},     // L&       COPTIC CAPITAL LETTER SIMA
	{0x2CA5, 0x2CA5, prLower},     // L&       COPTIC SMALL LETTER SIMA
	{0x2CA6, 0x2CA6, prUpper},     // L&       COPTIC CAPITAL LETTER TAU
	{0x2CA7, 0x2CA7, prLower},     // L&       COPTIC SMALL LETTER TAU
	{0x2CA8, 0x2CA8, prUpper},     // L&       COPTIC CAPITAL LETTER UA
	{0x2CA9, 0x2CA9, prLower},     // L&       COPTIC SMALL LETTER UA
	{0x2CAA, 0x2CAA, prUpper},     // L&       COPTIC CAPITAL LETTER FI
	{0x2CAB, 0x2CAB, prLower},     // L&       COPTIC SMALL LETTER FI
	{0x2CAC, 0x2CAC, prUpper},     // L&       COPTIC CAPITAL LETTER KHI
	{0x2CAD, 0x2CAD, prLower},     // L&       COPTIC SMALL LETTER KHI
	{0x2CAE, 0x2CAE, prUpper},     // L&       COPTIC CAPITAL LETTER PSI
	{0x2CAF, 0x2CAF, prLower},     // L&       COPTIC SMALL LETTER PSI
	{0x2CB0, 0x2CB0, prUpper},     // L&       COPTIC CAPITAL LETTER OOU
	{0x2CB1, 0x2CB1, prLower},     // L&       COPTIC SMALL LETTER OOU
	{0x2CB2, 0x2CB2, prUpper},     // L&       COPTIC CAPITAL LETTER DIALECT-P ALEF
	{0x2CB3, 0x2CB3, prLower},     // L&       COPTIC SMALL LETTER DIALECT-P ALEF
	{0x2CB4, 0x2CB4, prUpper},     // L&       COPTIC CAPITAL LETTER OLD COPTIC AIN
	{0x2CB5, 0x2CB5, prLower},     // L&       COPTIC SMALL LETTER OLD COPTIC AIN
	{0x2CB6, 0x2CB6, prUpper},     // L&       COPTIC CAPITAL LETTER CRYPTOGRAMMIC EIE
	{0x2CB7, 0x2CB7, prLower},     // L&       COPTIC SMALL LETTER CRYPTOGRAMMIC EIE
	{0x2CB8, 0x2CB8, prUpper},     // L&       COPTIC CAPITAL LETTER DIALECT-P KAPA
	{0x2CB9, 0x2CB9, prLower},     // L&       COPTIC SMALL LETTER DIALECT-P KAPA
	{0x2CBA, 0x2CBA, prUpper},     // L&       COPTIC CAPITAL LETTER DIALECT-P NI
	{0x2CBB, 0x2CBB, prLower},     // L&       COPTIC SMALL LETTER DIALECT-P NI
	{0x2CBC, 0x2CBC, prUpper},     // L&       COPTIC CAPITAL LETTER CRYPTOGRAMMIC NI
	{0x2CBD, 0x2CBD, prLower},     // L&       COPTIC SMALL LETTER CRYPTOGRAMMIC NI
	{0x2CBE, 0x2CBE, prUpper},     // L&       COPTIC CAPITAL LETTER OLD COPTIC OOU
	{0x2CBF, 0x2CBF, prLower},     // L&       COPTIC SMALL LETTER OLD COPTIC OOU
	{0x2CC0, 0x2CC0, prUpper},     // L&       COPTIC CAPITAL LETTER SAMPI
	{0x2CC1, 0x2CC1, prLower},     // L&       COPTIC SMALL LETTER SAMPI
	{0x2CC2, 0x2CC2, prUpper},     // L&       COPTIC CAPITAL LETTER CROSSED SHEI
	{0x2CC3, 0x2CC3, prLower},     // L&       COPTIC SMALL LETTER CROSSED SHEI
	{0x2CC4, 0x2CC4, prUpper},     // L&       COPTIC CAPITAL LETTER OLD COPTIC SHEI
	{0x2CC5, 0x2CC5, prLower},     // L&       COPTIC SMALL LETTER OLD COPTIC SHEI
	{0x2CC6, 0x2CC6, prUpper},     // L&       COPTIC CAPITAL LETTER OLD COPTIC ESH
	{0x2CC7, 0x2CC7, prLower},     // L&       COPTIC SMALL LETTER OLD COPTIC ESH
	{0x2CC8, 0x2CC8, prUpper},     // L&       COPTIC CAPITAL LETTER AKHMIMIC KHEI
	{0x2CC9, 0x2CC9, prLower},     // L&       COPTIC SMALL LETTER AKHMIMIC KHEI
	{0x2CCA, 0x2CCA, prUpper},     // L&       COPTIC CAPITAL LETTER DIALECT-P HORI
	{0x2CCB, 0x2CCB, prLower},     // L&       COPTIC SMALL LETTER DIALECT-P HORI
	{0x2CCC, 0x2CCC, prUpper},     // L&       COPTIC CAPITAL LETTER OLD COPTIC HORI
	{0x2CCD, 0x2CCD, prLower},     // L&       COPTIC SMALL LETTER OLD COPTIC HORI
	{0x2CCE, 0x2CCE, prUpper},     // L&       COPTIC CAPITAL LETTER OLD COPTIC HA
	{0x2CCF, 0x2CCF, prLower},     // L&       COPTIC SMALL LETTER OLD COPTIC HA
	{0x2CD0, 0x2CD0, prUpper},     // L&       COPTIC CAPITAL LETTER L-SHAPED HA
	{0x2CD1, 0x2CD1, prLower},     // L&       COPTIC SMALL LETTER L-SHAPED HA
	{0x2CD2, 0x2CD2, prUpper},     // L&       COPTIC CAPITAL LETTER OLD COPTIC HEI
	{0x2CD3, 0x2CD3, prLower},     // L&       COPTIC SMALL LETTER OLD COPTIC HEI
	{0x2CD4, 0x2CD4, prUpper},     // L&       COPTIC CAPITAL LETTER OLD COPTIC HAT
	{0x2CD5, 0x2CD5, prLower},     // L&       COPTIC SMALL LETTER OLD COPTIC HAT
	{0x2CD6, 0x2CD6, prUpper},     // L&       COPTIC CAPITAL LETTER OLD COPTIC GANGIA
	{0x2CD7, 0x2CD7, prLower},     // L&       COPTIC SMALL LETTER OLD COPTIC GANGIA
	{0x2CD8, 0x2CD8, prUpper},     // L&       COPTIC CAPITAL LETTER OLD COPTIC DJA
	{0x2CD9, 0x2CD9, prLower},     // L&       COPTIC SMALL LETTER OLD COPTIC DJA
	{0x2CDA, 0x2CDA, prUpper},     // L&       COPTIC CAPITAL LETTER OLD COPTIC SHIMA
	{0x2CDB, 0x2CDB, prLower},     // L&       COPTIC SMALL LETTER OLD COPTIC SHIMA
	{0x2CDC, 0x2CDC, prUpper},     // L&       COPTIC CAPITAL LETTER OLD NUBIAN SHIMA
	{0x2CDD, 0x2CDD, prLower},     // L&       COPTIC SMALL LETTER OLD NUBIAN SHIMA
	{0x2CDE, 0x2CDE, prUpper},     // L&       COPTIC CAPITAL LETTER OLD NUBIAN NGI
	{0x2CDF, 0x2CDF, prLower},     // L&       COPTIC SMALL LETTER OLD NUBIAN NGI
	{0x2CE0, 0x2CE0, prUpper},     // L&       COPTIC CAPITAL LETTER OLD NUBIAN NYI
	{0x2CE1, 0x2CE1, prLower},     // L&       COPTIC SMALL LETTER OLD NUBIAN NYI
	{0x2CE2, 0x2CE2, prUpper},     // L&       COPTIC CAPITAL LETTER OLD NUBIAN WAU
	{0x2CE3, 0x2CE4, prLower},     // L&   [2] COPTIC SMALL LETTER OLD NUBIAN WAU..COPTIC SYMBOL KAI
	{0x2CEB, 0x2CEB, prUpper},     // L&       COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI
	{0x2CEC, 0x2CEC, prLower},     // L&       COPTIC SMALL LETTER CRYPTOGRAMMIC SHEI
	{0x2CED, 0x2CED, prUpper},     // L&       COPTIC CAPITAL LETTER CRYPTOGRAMMIC GANGIA
	{0x2CEE, 0x2CEE, prLower},     // L&       COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA
	{0x2CEF, 0x2CF1, prExtend},    // Mn   [3] COPTIC COMBINING NI ABOVE..COPTIC COMBINING SPIRITUS LENIS
	{0x2CF2, 0x2CF2, prUpper},     // L&       COPTIC CAPITAL LETTER BOHAIRIC KHEI
	{0x2CF3, 0x2CF3, prLower},     // L&       COPTIC SMALL LETTER BOHAIRIC KHEI
	{0x2D00, 0x2D25, prLower},     // L&  [38] GEORGIAN SMALL LETTER AN..GEORGIAN SMALL LETTER HOE
	{0x2D27, 0x2D27, prLower},     // L&       GEORGIAN SMALL LETTER YN
	{0x2D2D, 0x2D2D, prLower},     // L&       GEORGIAN SMALL LETTER AEN
	{0x2D30, 0x2D67, prOLetter},   // Lo  [56] TIFINAGH LETTER YA..TIFINAGH LETTER YO
	{0x2D6F, 0x2D6F, prOLetter},   // Lm       TIFINAGH MODIFIER LETTER LABIALIZATION MARK
	{0x2D7F, 0x2D7F, prExtend},    // Mn       TIFINAGH CONSONANT JOINER
	{0x2D80, 0x2D96, prOLetter},   // Lo  [23] ETHIOPIC SYLLABLE LOA..ETHIOPIC SYLLABLE GGWE
	{0x2DA0, 0x2DA6, prOLetter},   // Lo   [7] ETHIOPIC SYLLABLE SSA..ETHIOPIC SYLLABLE SSO
	{0x2DA8, 0x2DAE, prOLetter},   // Lo   [7] ETHIOPIC SYLLABLE CCA..ETHIOPIC SYLLABLE CCO
	{0x2DB0, 0x2DB6, prOLetter},   // Lo   [7] ETHIOPIC SYLLABLE ZZA..ETHIOPIC SYLLABLE ZZO
	{0x2DB8, 0x2DBE, prOLetter},   // Lo   [7] ETHIOPIC SYLLABLE CCHA..ETHIOPIC SYLLABLE CCHO
	{0x2DC0, 0x2DC6, prOLetter},   // Lo   [7] ETHIOPIC SYLLABLE QYA..ETHIOPIC SYLLABLE QYO
	{0x2DC8, 0x2DCE, prOLetter},   // Lo   [7] ETHIOPIC SYLLABLE KYA..ETHIOPIC SYLLABLE KYO
	{0x2DD0, 0x2DD6, prOLetter},   // Lo   [7] ETHIOPIC SYLLABLE XYA..ETHIOPIC SYLLABLE XYO
	{0x2DD8, 0x2DDE, prOLetter},   // Lo   [7] ETHIOPIC SYLLABLE GYA..ETHIOPIC SYLLABLE GYO
	{0x2DE0, 0x2DFF, prExtend},    // Mn  [32] COMBINING CYRILLIC LETTER BE..COMBINING CYRILLIC LETTER IOTIFIED BIG YUS
	{0x2E00, 0x2E01, prClose},     // Po   [2] RIGHT ANGLE SUBSTITUTION MARKER..RIGHT ANGLE DOTTED SUBSTITUTION MARKER
	{0x2E02, 0x2E02, prClose},     // Pi       LEFT SUBSTITUTION BRACKET
	{0x2E03, 0x2E03, prClose},     // Pf       RIGHT SUBSTITUTION BRACKET
	{0x2E04, 0x2E04, prClose},     // Pi       LEFT DOTTED SUBSTITUTION BRACKET
	{0x2E05, 0x2E05, prClose},     // Pf       RIGHT DOTTED SUBSTITUTION BRACKET
	{0x2E06, 0x2E08, prClose},     // Po   [3] RAISED INTERPOLATION MARKER..DOTTED TRANSPOSITION MARKER
	{0x2E09, 0x2E09, prClose},     // Pi       LEFT TRANSPOSITION BRACKET
	{0x2E0A, 0x2E0A, prClose},     // Pf       RIGHT TRANSPOSITION BRACKET
	{0x2E0B, 0x2E0B, prClose},     // Po       RAISED SQUARE
	{0x2E0C, 0x2E0C, prClose},     // Pi       LEFT RAISED OMISSION BRACKET
	{0x2E0D, 0x2E0D, prClose},     // Pf       RIGHT RAISED OMISSION BRACKET
	{0x2E1C, 0x2E1C, prClose},     // Pi       LEFT LOW PARAPHRASE BRACKET
	{0x2E1D, 0x2E1D, prClose},     // Pf       RIGHT LOW PARAPHRASE BRACKET
	{0x2E20, 0x2E20, prClose},     // Pi       LEFT VERTICAL BAR WITH QUILL
	{0x2E21, 0x2E21, prClose},     // Pf       RIGHT VERTICAL BAR WITH QUILL
	{0x2E22, 0x2E22, prClose},     // Ps       TOP LEFT HALF BRACKET
	{0x2E23, 0x2E23, prClose},     // Pe       TOP RIGHT HALF BRACKET
	{0x2E24, 0x2E24, prClose},     // Ps       BOTTOM LEFT HALF BRACKET
	{0x2E25, 0x2E25, prClose},     // Pe       BOTTOM RIGHT HALF BRACKET
	{0x2E26, 0x2E26, prClose},     // Ps       LEFT SIDEWAYS U BRACKET
	{0x2E27, 0x2E27, prClose},     // Pe       RIGHT SIDEWAYS U BRACKET
	{0x2E28, 0x2E28, prClose},     // Ps       LEFT DOUBLE PARENTHESIS
	{0x2E29, 0x2E29, prClose},     // Pe       RIGHT DOUBLE PARENTHESIS
	{0x2E2E, 0x2E2E, prSTerm},     // Po       REVERSED QUESTION MARK
	{0x2E2F, 0x2E2F, prOLetter},   // Lm       VERTICAL TILDE
	{0x2E3C, 0x2E3C, prSTerm},     // Po       STENOGRAPHIC FULL STOP
	{0x2E42, 0x2E42, prClose},     // Ps       DOUBLE LOW-REVERSED-9 QUOTATION MARK
	{0x2E53, 0x2E54, prSTerm},     // Po   [2] MEDIEVAL EXCLAMATION MARK..MEDIEVAL QUESTION MARK
	{0x2E55, 0x2E55, prClose},     // Ps       LEFT SQUARE BRACKET WITH STROKE
	{0x2E56, 0x2E56, prClose},     // Pe       RIGHT SQUARE BRACKET WITH STROKE
	{0x2E57, 0x2E57, prClose},     // Ps       LEFT SQUARE BRACKET WITH DOUBLE STROKE
	{0x2E58, 0x2E58, prClose},     // Pe       RIGHT SQUARE BRACKET WITH DOUBLE STROKE
	{0x2E59, 0x2E59, prClose},     // Ps       TOP HALF LEFT PARENTHESIS
	{0x2E5A, 0x2E5A, prClose},     // Pe       TOP HALF RIGHT PARENTHESIS
	{0x2E5B, 0x2E5B, prClose},     // Ps       BOTTOM HALF LEFT PARENTHESIS
	{0x2E5C, 0x2E5C, prClose},     // Pe       BOTTOM HALF RIGHT PARENTHESIS
	{0x3000, 0x3000, prSp},        // Zs       IDEOGRAPHIC SPACE
	{0x3001, 0x3001, prSContinue}, // Po       IDEOGRAPHIC COMMA
	{0x3002, 0x3002, prSTerm},     // Po       IDEOGRAPHIC FULL STOP
	{0x3005, 0x3005, prOLetter},   // Lm       IDEOGRAPHIC ITERATION MARK
	{0x3006, 0x3006, prOLetter},   // Lo       IDEOGRAPHIC CLOSING MARK
	{0x3007, 0x3007, prOLetter},   // Nl       IDEOGRAPHIC NUMBER ZERO
	{0x3008, 0x3008, prClose},     // Ps       LEFT ANGLE BRACKET
	{0x3009, 0x3009, prClose},     // Pe       RIGHT ANGLE BRACKET
	{0x300A, 0x300A, prClose},     // Ps       LEFT DOUBLE ANGLE BRACKET
	{0x300B, 0x300B, prClose},     // Pe       RIGHT DOUBLE ANGLE BRACKET
	{0x300C, 0x300C, prClose},     // Ps       LEFT CORNER BRACKET
	{0x300D, 0x300D, prClose},     // Pe       RIGHT CORNER BRACKET
	{0x300E, 0x300E, prClose},     // Ps       LEFT WHITE CORNER BRACKET
	{0x300F, 0x300F, prClose},     // Pe       RIGHT WHITE CORNER BRACKET
	{0x3010, 0x3010, prClose},     // Ps       LEFT BLACK LENTICULAR BRACKET
	{0x3011, 0x3011, prClose},     // Pe       RIGHT BLACK LENTICULAR BRACKET
	{0x3014, 0x3014, prClose},     // Ps       LEFT TORTOISE SHELL BRACKET
	{0x3015, 0x3015, prClose},     // Pe       RIGHT TORTOISE SHELL BRACKET
	{0x3016, 0x3016, prClose},     // Ps       LEFT WHITE LENTICULAR BRACKET
	{0x3017, 0x3017, prClose},     // Pe       RIGHT WHITE LENTICULAR BRACKET
	{0x3018, 0x3018, prClose},     // Ps       LEFT WHITE TORTOISE SHELL BRACKET
	{0x3019, 0x3019, prClose},     // Pe       RIGHT WHITE TORTOISE SHELL BRACKET
	{0x301A, 0x301A, prClose},     // Ps       LEFT WHITE SQUARE BRACKET
	{0x301B, 0x301B, prClose},     // Pe       RIGHT WHITE SQUARE BRACKET
	{0x301D, 0x301D, prClose},     // Ps       REVERSED DOUBLE PRIME QUOTATION MARK
	{0x301E, 0x301F, prClose},     // Pe   [2] DOUBLE PRIME QUOTATION MARK..LOW DOUBLE PRIME QUOTATION MARK
	{0x3021, 0x3029, prOLetter},   // Nl   [9] HANGZHOU NUMERAL ONE..HANGZHOU NUMERAL NINE
	{0x302A, 0x302D, prExtend},    // Mn   [4] IDEOGRAPHIC LEVEL TONE MARK..IDEOGRAPHIC ENTERING TONE MARK
	{0x302E, 0x302F, prExtend},    // Mc   [2] HANGUL SINGLE DOT TONE MARK..HANGUL DOUBLE DOT TONE MARK
	{0x3031, 0x3035, prOLetter},   // Lm   [5] VERTICAL KANA REPEAT MARK..VERTICAL KANA REPEAT MARK LOWER HALF
	{0x3038, 0x303A, prOLetter},   // Nl   [3] HANGZHOU NUMERAL TEN..HANGZHOU NUMERAL THIRTY
	{0x303B, 0x303B, prOLetter},   // Lm       VERTICAL IDEOGRAPHIC ITERATION MARK
	{0x303C, 0x303C, prOLetter},   // Lo       MASU MARK
	{0x3041, 0x3096, prOLetter},   // Lo  [86] HIRAGANA LETTER SMALL A..HIRAGANA LETTER SMALL KE
	{0x3099, 0x309A, prExtend},    // Mn   [2] COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK..COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{0x309D, 0x309E, prOLetter},   // Lm   [2] HIRAGANA ITERATION MARK..HIRAGANA VOICED ITERATION MARK
	{0x309F, 0x309F, prOLetter},   // Lo       HIRAGANA DIGRAPH YORI
	{0x30A1, 0x30FA, prOLetter},   // Lo  [90] KATAKANA LETTER SMALL A..KATAKANA LETTER VO
	{0x30FC, 0x30FE, prOLetter},   // Lm   [3] KATAKANA-HIRAGANA PROLONGED SOUND MARK..KATAKANA VOICED ITERATION MARK
	{0x30FF, 0x30FF, prOLetter},   // Lo       KATAKANA DIGRAPH KOTO
	{0x3105, 0x312F, prOLetter},   // Lo  [43] BOPOMOFO LETTER B..BOPOMOFO LETTER NN
	{0x3131, 0x318E, prOLetter},   // Lo  [94] HANGUL LETTER KIYEOK..HANGUL LETTER ARAEAE
	{0x31A0, 0x31BF, prOLetter},   // Lo  [32] BOPOMOFO LETTER BU..BOPOMOFO LETTER AH
	{0x31F0, 0x31FF, prOLetter},   // Lo  [16] KATAKANA LETTER SMALL KU..KATAKANA LETTER SMALL RO
	{0x3400, 0x4DBF, prOLetter},   // Lo [6592] CJK UNIFIED IDEOGRAPH-3400..CJK UNIFIED IDEOGRAPH-4DBF
	{0x4E00, 0xA014, prOLetter},   // Lo [21013] CJK UNIFIED IDEOGRAPH-4E00..YI SYLLABLE E
	{0xA015, 0xA015, prOLetter},   // Lm       YI SYLLABLE WU
	{0xA016, 0xA48C, prOLetter},   // Lo [1143] YI SYLLABLE BIT..YI SYLLABLE YYR
	{0xA4D0, 0xA4F7, prOLetter},   // Lo  [40] LISU LETTER BA..LISU LETTER OE
	{0xA4F8, 0xA4FD, prOLetter},   // Lm   [6] LISU LETTER TONE MYA TI..LISU LETTER TONE MYA JEU
	{0xA4FF, 0xA4FF, prSTerm},     // Po       LISU PUNCTUATION FULL STOP
	{0xA500, 0xA60B, prOLetter},   // Lo [268] VAI SYLLABLE EE..VAI SYLLABLE NG
	{0xA60C, 0xA60C, prOLetter},   // Lm       VAI SYLLABLE LENGTHENER
	{0xA60E, 0xA60F, prSTerm},     // Po   [2] VAI FULL STOP..VAI QUESTION MARK
	{0xA610, 0xA61F, prOLetter},   // Lo  [16] VAI SYLLABLE NDOLE FA..VAI SYMBOL JONG
	{0xA620, 0xA629, prNumeric},   // Nd  [10] VAI DIGIT ZERO..VAI DIGIT NINE
	{0xA62A, 0xA62B, prOLetter},   // Lo   [2] VAI SYLLABLE NDOLE MA..VAI SYLLABLE NDOLE DO
	{0xA640, 0xA640, prUpper},     // L&       CYRILLIC CAPITAL LETTER ZEMLYA
	{0xA641, 0xA641, prLower},     // L&       CYRILLIC SMALL LETTER ZEMLYA
	{0xA642, 0xA642, prUpper},     // L&       CYRILLIC CAPITAL LETTER DZELO
	{0xA643, 0xA643, prLower},     // L&       CYRILLIC SMALL LETTER DZELO
	{0xA644, 0xA644, prUpper},     // L&       CYRILLIC CAPITAL LETTER REVERSED DZE
	{0xA645, 0xA645, prLower},     // L&       CYRILLIC SMALL LETTER REVERSED DZE
	{0xA646, 0xA646, prUpper},     // L&       CYRILLIC CAPITAL LETTER IOTA
	{0xA647, 0xA647, prLower},     // L&       CYRILLIC SMALL LETTER IOTA
	{0xA648, 0xA648, prUpper},     // L&       CYRILLIC CAPITAL LETTER DJERV
	{0xA649, 0xA649, prLower},     // L&       CYRILLIC SMALL LETTER DJERV
	{0xA64A, 0xA64A, prUpper},     // L&       CYRILLIC CAPITAL LETTER MONOGRAPH UK
	{0xA64B, 0xA64B, prLower},     // L&       CYRILLIC SMALL LETTER MONOGRAPH UK
	{0xA64C, 0xA64C, prUpper},     // L&       CYRILLIC CAPITAL LETTER BROAD OMEGA
	{0xA64D, 0xA64D, prLower},     // L&       CYRILLIC SMALL LETTER BROAD OMEGA
	{0xA64E, 0xA64E, prUpper},     // L&       CYRILLIC CAPITAL LETTER NEUTRAL YER
	{0xA64F, 0xA64F, prLower},     // L&       CYRILLIC SMALL LETTER NEUTRAL YER
	{0xA650, 0xA650, prUpper},     // L&       CYRILLIC CAPITAL LETTER YERU WITH BACK YER
	{0xA651, 0xA651, prLower},     // L&       CYRILLIC SMALL LETTER YERU WITH BACK YER
	{0xA652, 0xA652, prUpper},     // L&       CYRILLIC CAPITAL LETTER IOTIFIED YAT
	{0xA653, 0xA653, prLower},     // L&       CYRILLIC SMALL LETTER IOTIFIED YAT
	{0xA654, 0xA654, prUpper},     // L&       CYRILLIC CAPITAL LETTER REVERSED YU
	{0xA655, 0xA655, prLower},     // L&       CYRILLIC SMALL LETTER REVERSED YU
	{0xA656, 0xA656, prUpper},     // L&       CYRILLIC CAPITAL LETTER IOTIFIED A
	{0xA657, 0xA657, prLower},     // L&       CYRILLIC SMALL LETTER IOTIFIED A
	{0xA658, 0xA658, prUpper},     // L&       CYRILLIC CAPITAL LETTER CLOSED LITTLE YUS
	{0xA659, 0xA659, prLower},     // L&       CYRILLIC SMALL LETTER CLOSED LITTLE YUS
	{0xA65A, 0xA65A, prUpper},     // L&       CYRILLIC CAPITAL LETTER BLENDED YUS
	{0xA65B, 0xA65B, prLower},     // L&       CYRILLIC SMALL LETTER BLENDED YUS
	{0xA65C, 0xA65C, prUpper},     // L&       CYRILLIC CAPITAL LETTER IOTIFIED CLOSED LITTLE YUS
	{0xA65D, 0xA65D, prLower},     // L&       CYRILLIC SMALL LETTER IOTIFIED CLOSED LITTLE YUS
	{0xA65E, 0xA65E, prUpper},     // L&       CYRILLIC CAPITAL LETTER YN
	{0xA65F, 0xA65F, prLower},     // L&       CYRILLIC SMALL LETTER YN
	{0xA660, 0xA660, prUpper},     // L&       CYRILLIC CAPITAL LETTER REVERSED TSE
	{0xA661, 0xA661, prLower},     // L&       CYRILLIC SMALL LETTER REVERSED TSE
	{0xA662, 0xA662, prUpper},     // L&       CYRILLIC CAPITAL LETTER SOFT DE
	{0xA663, 0xA663, prLower},     // L&       CYRILLIC SMALL LETTER SOFT DE
	{0xA664, 0xA664, prUpper},     // L&       CYRILLIC CAPITAL LETTER SOFT EL
	{0xA665, 0xA665, prLower},     // L&       CYRILLIC SMALL LETTER SOFT EL
	{0xA666, 0xA666, prUpper},     // L&       CYRILLIC CAPITAL LETTER SOFT EM
	{0xA667, 0xA667, prLower},     // L&       CYRILLIC SMALL LETTER SOFT EM
	{0xA668, 0xA668, prUpper},     // L&       CYRILLIC CAPITAL LETTER MONOCULAR O
	{0xA669, 0xA669, prLower},     // L&       CYRILLIC SMALL LETTER MONOCULAR O
	{0xA66A, 0xA66A, prUpper},     // L&       CYRILLIC CAPITAL LETTER BINOCULAR O
	{0xA66B, 0xA66B, prLower},     // L&       CYRILLIC SMALL LETTER BINOCULAR O
	{0xA66C, 0xA66C, prUpper},     // L&       CYRILLIC CAPITAL LETTER DOUBLE MONOCULAR O
	{0xA66D, 0xA66D, prLower},     // L&       CYRILLIC SMALL LETTER DOUBLE MONOCULAR O
	{0xA66E, 0xA66E, prOLetter},   // Lo       CYRILLIC LETTER MULTIOCULAR O
	{0xA66F, 0xA66F, prExtend},    // Mn       COMBINING CYRILLIC VZMET
	{0xA670, 0xA672, prExtend},    // Me   [3] COMBINING CYRILLIC TEN MILLIONS SIGN..COMBINING CYRILLIC THOUSAND MILLIONS SIGN
	{0xA674, 0xA67D, prExtend},    // Mn  [10] COMBINING CYRILLIC LETTER UKRAINIAN IE..COMBINING CYRILLIC PAYEROK
	{0xA67F, 0xA67F, prOLetter},   // Lm       CYRILLIC PAYEROK
	{0xA680, 0xA680, prUpper},     // L&       CYRILLIC CAPITAL LETTER DWE
	{0xA681, 0xA681, prLower},     // L&       CYRILLIC SMALL LETTER DWE
	{0xA682, 0xA682, prUpper},     // L&       CYRILLIC CAPITAL LETTER DZWE
	{0xA683, 0xA683, prLower},     // L&       CYRILLIC SMALL LETTER DZWE
	{0xA684, 0xA684, prUpper},     // L&       CYRILLIC CAPITAL LETTER ZHWE
	{0xA685, 0xA685, prLower},     // L&       CYRILLIC SMALL LETTER ZHWE
	{0xA686, 0xA686, prUpper},     // L&       CYRILLIC CAPITAL LETTER CCHE
	{0xA687, 0xA687, prLower},     // L&       CYRILLIC SMALL LETTER CCHE
	{0xA688, 0xA688, prUpper},     // L&       CYRILLIC CAPITAL LETTER DZZE
	{0xA689, 0xA689, prLower},     // L&       CYRILLIC SMALL LETTER DZZE
	{0xA68A, 0xA68A, prUpper},     // L&       CYRILLIC CAPITAL LETTER TE WITH MIDDLE HOOK
	{0xA68B, 0xA68B, prLower},     // L&       CYRILLIC SMALL LETTER TE WITH MIDDLE HOOK
	{0xA68C, 0xA68C, prUpper},     // L&       CYRILLIC CAPITAL LETTER TWE
	{0xA68D, 0xA68D, prLower},     // L&       CYRILLIC SMALL LETTER TWE
	{0xA68E, 0xA68E, prUpper},     // L&       CYRILLIC CAPITAL LETTER TSWE
	{0xA68F, 0xA68F, prLower},     // L&       CYRILLIC SMALL LETTER TSWE
	{0xA690, 0xA690, prUpper},     // L&       CYRILLIC CAPITAL LETTER TSSE
	{0xA691, 0xA691, prLower},     // L&       CYRILLIC SMALL LETTER TSSE
	{0xA692, 0xA692, prUpper},     // L&       CYRILLIC CAPITAL LETTER TCHE
	{0xA693, 0xA693, prLower},     // L&       CYRILLIC SMALL LETTER TCHE
	{0xA694, 0xA694, prUpper},     // L&       CYRILLIC CAPITAL LETTER HWE
	{0xA695, 0xA695, prLower},     // L&       CYRILLIC SMALL LETTER HWE
	{0xA696, 0xA696, prUpper},     // L&       CYRILLIC CAPITAL LETTER SHWE
	{0xA697, 0xA697, prLower},     // L&       CYRILLIC SMALL LETTER SHWE
	{0xA698, 0xA698, prUpper},     // L&       CYRILLIC CAPITAL LETTER DOUBLE O
	{0xA699, 0xA699, prLower},     // L&       CYRILLIC SMALL LETTER DOUBLE O
	{0xA69A, 0xA69A, prUpper},     // L&       CYRILLIC CAPITAL LETTER CROSSED O
	{0xA69B, 0xA69B, prLower},     // L&       CYRILLIC SMALL LETTER CROSSED O
	{0xA69C, 0xA69D, prLower},     // Lm   [2] MODIFIER LETTER CYRILLIC HARD SIGN..MODIFIER LETTER CYRILLIC SOFT SIGN
	{0xA69E, 0xA69F, prExtend},    // Mn   [2] COMBINING CYRILLIC LETTER EF..COMBINING CYRILLIC LETTER IOTIFIED E
	{0xA6A0, 0xA6E5, prOLetter},   // Lo  [70] BAMUM LETTER A..BAMUM LETTER KI
	{0xA6E6, 0xA6EF, prOLetter},   // Nl  [10] BAMUM LETTER MO..BAMUM LETTER KOGHOM
	{0xA6F0, 0xA6F1, prExtend},    // Mn   [2] BAMUM COMBINING MARK KOQNDON..BAMUM COMBINING MARK TUKWENTIS
	{0xA6F3, 0xA6F3, prSTerm},     // Po       BAMUM FULL STOP
	{0xA6F7, 0xA6F7, prSTerm},     // Po       BAMUM QUESTION MARK
	{0xA717, 0xA71F, prOLetter},   // Lm   [9] MODIFIER LETTER DOT VERTICAL BAR..MODIFIER LETTER LOW INVERTED EXCLAMATION MARK
	{0xA722, 0xA722, prUpper},     // L&       LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF
	{0xA723, 0xA723, prLower},     // L&       LATIN SMALL LETTER EGYPTOLOGICAL ALEF
	{0xA724, 0xA724, prUpper},     // L&       LATIN CAPITAL LETTER EGYPTOLOGICAL AIN
	{0xA725, 0xA725, prLower},     // L&       LATIN SMALL LETTER EGYPTOLOGICAL AIN
	{0xA726, 0xA726, prUpper},     // L&       LATIN CAPITAL LETTER HENG
	{0xA727, 0xA727, prLower},     // L&       LATIN SMALL LETTER HENG
	{0xA728, 0xA728, prUpper},     // L&       LATIN CAPITAL LETTER TZ
	{0xA729, 0xA729, prLower},     // L&       LATIN SMALL LETTER TZ
	{0xA72A, 0xA72A, prUpper},     // L&       LATIN CAPITAL LETTER TRESILLO
	{0xA72B, 0xA72B, prLower},     // L&       LATIN SMALL LETTER TRESILLO
	{0xA72C, 0xA72C, prUpper},     // L&       LATIN CAPITAL LETTER CUATRILLO
	{0xA72D, 0xA72D, prLower},     // L&       LATIN SMALL LETTER CUATRILLO
	{0xA72E, 0xA72E, prUpper},     // L&       LATIN CAPITAL LETTER CUATRILLO WITH COMMA
	{0xA72F, 0xA731, prLower},     // L&   [3] LATIN SMALL LETTER CUATRILLO WITH COMMA..LATIN LETTER SMALL CAPITAL S
	{0xA732, 0xA732, prUpper},     // L&       LATIN CAPITAL LETTER AA
	{0xA733, 0xA733, prLower},     // L&       LATIN SMALL LETTER AA
	{0xA734, 0xA734, prUpper},     // L&       LATIN CAPITAL LETTER AO
	{0xA735, 0xA735, prLower},     // L&       LATIN SMALL LETTER AO
	{0xA736, 0xA736, prUpper},     // L&       LATIN CAPITAL LETTER AU
	{0xA737, 0xA737, prLower},     // L&       LATIN SMALL LETTER AU
	{0xA738, 0xA738, prUpper},     // L&       LATIN CAPITAL LETTER AV
	{0xA739, 0xA739, prLower},     // L&       LATIN SMALL LETTER AV
	{0xA73A, 0xA73A, prUpper},     // L&       LATIN CAPITAL LETTER AV WITH HORIZONTAL BAR
	{0xA73B, 0xA73B, prLower},     // L&       LATIN SMALL LETTER AV WITH HORIZONTAL BAR
	{0xA73C, 0xA73C, prUpper},     // L&       LATIN CAPITAL LETTER AY
	{0xA73D, 0xA73D, prLower},     // L&       LATIN SMALL LETTER AY
	{0xA73E, 0xA73E, prUpper},     // L&       LATIN CAPITAL LETTER REVERSED C WITH DOT
	{0xA73F, 0xA73F, prLower},     // L&       LATIN SMALL LETTER REVERSED C WITH DOT
	{0xA740, 0xA740, prUpper},     // L&       LATIN CAPITAL LETTER K WITH STROKE
	{0xA741, 0xA741, prLower},     // L&       LATIN SMALL LETTER K WITH STROKE
	{0xA742, 0xA742, prUpper},     // L&       LATIN CAPITAL LETTER K WITH DIAGONAL STROKE
	{0xA743, 0xA743, prLower},     // L&       LATIN SMALL LETTER K WITH DIAGONAL STROKE
	{0xA744, 0xA744, prUpper},     // L&       LATIN CAPITAL LETTER K WITH STROKE AND DIAGONAL STROKE
	{0xA745, 0xA745, prLower},     // L&       LATIN SMALL LETTER K WITH STROKE AND DIAGONAL STROKE
	{0xA746, 0xA746, prUpper},     // L&       LATIN CAPITAL LETTER BROKEN L
	{0xA747, 0xA747, prLower},     // L&       LATIN SMALL LETTER BROKEN L
	{0xA748, 0xA748, prUpper},     // L&       LATIN CAPITAL LETTER L WITH HIGH STROKE
	{0xA749, 0xA749, prLower},     // L&       LATIN SMALL LETTER L WITH HIGH STROKE
	{0xA74A, 0xA74A, prUpper},     // L&       LATIN CAPITAL LETTER O WITH LONG STROKE OVERLAY
	{0xA74B, 0xA74B, prLower},     // L&       LATIN SMALL LETTER O WITH LONG STROKE OVERLAY
	{0xA74C, 0xA74C, prUpper},     // L&       LATIN CAPITAL LETTER O WITH LOOP
	{0xA74D, 0xA74D, prLower},     // L&       LATIN SMALL LETTER O WITH LOOP
	{0xA74E, 0xA74E, prUpper},     // L&       LATIN CAPITAL LETTER OO
	{0xA74F, 0xA74F, prLower},     // L&       LATIN SMALL LETTER OO
	{0xA750, 0xA750, prUpper},     // L&       LATIN CAPITAL LETTER P WITH STROKE THROUGH DESCENDER
	{0xA751, 0xA751, prLower},     // L&       LATIN SMALL LETTER P WITH STROKE THROUGH DESCENDER
	{0xA752, 0xA752, prUpper},     // L&       LATIN CAPITAL LETTER P WITH FLOURISH
	{0xA753, 0xA753, prLower},     // L&       LATIN SMALL LETTER P WITH FLOURISH
	{0xA754, 0xA754, prUpper},     // L&       LATIN CAPITAL LETTER P WITH SQUIRREL TAIL
	{0xA755, 0xA755, prLower},     // L&       LATIN SMALL LETTER P WITH SQUIRREL TAIL
	{0xA756, 0xA756, prUpper},     // L&       LATIN CAPITAL LETTER Q WITH STROKE THROUGH DESCENDER
	{0xA757, 0xA757, prLower},     // L&       LATIN SMALL LETTER Q WITH STROKE THROUGH DESCENDER
	{0xA758, 0xA758, prUpper},     // L&       LATIN CAPITAL LETTER Q WITH DIAGONAL STROKE
	{0xA759, 0xA759, prLower},     // L&       LATIN SMALL LETTER Q WITH DIAGONAL STROKE
	{0xA75A, 0xA75A, prUpper},     // L&       LATIN CAPITAL LETTER R ROTUNDA
	{0xA75B, 0xA75B, prLower},     // L&       LATIN SMALL LETTER R ROTUNDA
	{0xA75C, 0xA75C, prUpper},     // L&       LATIN CAPITAL LETTER RUM ROTUNDA
	{0xA75D, 0xA75D, prLower},     // L&       LATIN SMALL LETTER RUM ROTUNDA
	{0xA75E, 0xA75E, prUpper},     // L&       LATIN CAPITAL LETTER V WITH DIAGONAL STROKE
	{0xA75F, 0xA75F, prLower},     // L&       LATIN SMALL LETTER V WITH DIAGONAL STROKE
	{0xA760, 0xA760, prUpper},     // L&       LATIN CAPITAL LETTER VY
	{0xA761, 0xA761, prLower},     // L&       LATIN SMALL LETTER VY
	{0xA762, 0xA762, prUpper},     // L&       LATIN CAPITAL LETTER VISIGOTHIC Z
	{0xA763, 0xA763, prLower},     // L&       LATIN SMALL LETTER VISIGOTHIC Z
	{0xA764, 0xA764, prUpper},     // L&       LATIN CAPITAL LETTER THORN WITH STROKE
	{0xA765, 0xA765, prLower},     // L&       LATIN SMALL LETTER THORN WITH STROKE
	{0xA766, 0xA766, prUpper},     // L&       LATIN CAPITAL LETTER THORN WITH STROKE THROUGH DESCENDER
	{0xA767, 0xA767, prLower},     // L&       LATIN SMALL LETTER THORN WITH STROKE THROUGH DESCENDER
	{0xA768, 0xA768, prUpper},     // L&       LATIN CAPITAL LETTER VEND
	{0xA769, 0xA769, prLower},     // L&       LATIN SMALL LETTER VEND
	{0xA76A, 0xA76A, prUpper},     // L&       LATIN CAPITAL LETTER ET
	{0xA76B, 0xA76B, prLower},     // L&       LATIN SMALL LETTER ET
	{0xA76C, 0xA76C, prUpper},     // L&       LATIN CAPITAL LETTER IS
	{0xA76D, 0xA76D, prLower},     // L&       LATIN SMALL LETTER IS
	{0xA76E, 0xA76E, prUpper},     // L&       LATIN CAPITAL LETTER CON
	{0xA76F, 0xA76F, prLower},     // L&       LATIN SMALL LETTER CON
	{0xA770, 0xA770, prLower},     // Lm       MODIFIER LETTER US
	{0xA771, 0xA778, prLower},     // L&   [8] LATIN SMALL LETTER DUM..LATIN SMALL LETTER UM
	{0xA779, 0xA779, prUpper},     // L&       LATIN CAPITAL LETTER INSULAR D
	{0xA77A, 0xA77A, prLower},     // L&       LATIN SMALL LETTER INSULAR D
	{0xA77B, 0xA77B, prUpper},     // L&       LATIN CAPITAL LETTER INSULAR F
	{0xA77C, 0xA77C, prLower},     // L&       LATIN SMALL LETTER INSULAR F
	{0xA77D, 0xA77E, prUpper},     // L&   [2] LATIN CAPITAL LETTER INSULAR G..LATIN CAPITAL LETTER TURNED INSULAR G
	{0xA77F, 0xA77F, prLower},     // L&       LATIN SMALL LETTER TURNED INSULAR G
	{0xA780, 0xA780, prUpper},     // L&       LATIN CAPITAL LETTER TURNED L
	{0xA781, 0xA781, prLower},     // L&       LATIN SMALL LETTER TURNED L
	{0xA782, 0xA782, prUpper},     // L&       LATIN CAPITAL LETTER INSULAR R
	{0xA783, 0xA783, prLower},     // L&       LATIN SMALL LETTER INSULAR R
	{0xA784, 0xA784, prUpper},     // L&       LATIN CAPITAL LETTER INSULAR S
	{0xA785, 0xA785, prLower},     // L&       LATIN SMALL LETTER INSULAR S
	{0xA786, 0xA786, prUpper},     // L&       LATIN CAPITAL LETTER INSULAR T
	{0xA787, 0xA787, prLower},     // L&       LATIN SMALL LETTER INSULAR T
	{0xA788, 0xA788, prOLetter},   // Lm       MODIFIER LETTER LOW CIRCUMFLEX ACCENT
	{0xA78B, 0xA78B, prUpper},     // L&       LATIN CAPITAL LETTER SALTILLO
	{0xA78C, 0xA78C, prLower},     // L&       LATIN SMALL LETTER SALTILLO
	{0xA78D, 0xA78D, prUpper},     // L&       LATIN CAPITAL LETTER TURNED H
	{0xA78E, 0xA78E, prLower},     // L&       LATIN SMALL LETTER L WITH RETROFLEX HOOK AND BELT
	{0xA78F, 0xA78F, prOLetter},   // Lo       LATIN LETTER SINOLOGICAL DOT
	{0xA790, 0xA790, prUpper},     // L&       LATIN CAPITAL LETTER N WITH DESCENDER
	{0xA791, 0xA791, prLower},     // L&       LATIN SMALL LETTER N WITH DESCENDER
	{0xA792, 0xA792, prUpper},     // L&       LATIN CAPITAL LETTER C WITH BAR
	{0xA793, 0xA795, prLower},     // L&   [3] LATIN SMALL LETTER C WITH BAR..LATIN SMALL LETTER H WITH PALATAL HOOK
	{0xA796, 0xA796, prUpper},     // L&       LATIN CAPITAL LETTER B WITH FLOURISH
	{0xA797, 0xA797, prLower},     // L&       LATIN SMALL LETTER B WITH FLOURISH
	{0xA798, 0xA798, prUpper},     // L&       LATIN CAPITAL LETTER F WITH STROKE
	{0xA799, 0xA799, prLower},     // L&       LATIN SMALL LETTER F WITH STROKE
	{0xA79A, 0xA79A, prUpper},     // L&       LATIN CAPITAL LETTER VOLAPUK AE
	{0xA79B, 0xA79B, prLower},     // L&       LATIN SMALL LETTER VOLAPUK AE
	{0xA79C, 0xA79C, prUpper},     // L&       LATIN CAPITAL LETTER VOLAPUK OE
	{0xA79D, 0xA79D, prLower},     // L&       LATIN SMALL LETTER VOLAPUK OE
	{0xA79E, 0xA79E, prUpper},     // L&       LATIN CAPITAL LETTER VOLAPUK UE
	{0xA79F, 0xA79F, prLower},     // L&       LATIN SMALL LETTER VOLAPUK UE
	{0xA7A0, 0xA7A0, prUpper},     // L&       LATIN CAPITAL LETTER G WITH OBLIQUE STROKE
	{0xA7A1, 0xA7A1, prLower},     // L&       LATIN SMALL LETTER G WITH OBLIQUE STROKE
	{0xA7A2, 0xA7A2, prUpper},     // L&       LATIN CAPITAL LETTER K WITH OBLIQUE STROKE
	{0xA7A3, 0xA7A3, prLower},     // L&       LATIN SMALL LETTER K WITH OBLIQUE STROKE
	{0xA7A4, 0xA7A4, prUpper},     // L&       LATIN CAPITAL LETTER N WITH OBLIQUE STROKE
	{0xA7A5, 0xA7A5, prLower},     // L&       LATIN SMALL LETTER N WITH OBLIQUE STROKE
	{0xA7A6, 0xA7A6, prUpper},     // L&       LATIN CAPITAL LETTER R WITH OBLIQUE STROKE
	{0xA7A7, 0xA7A7, prLower},     // L&       LATIN SMALL LETTER R WITH OBLIQUE STROKE
	{0xA7A8, 0xA7A8, prUpper},     // L&       LATIN CAPITAL LETTER S WITH OBLIQUE STROKE
	{0xA7A9, 0xA7A9, prLower},     // L&       LATIN SMALL LETTER S WITH OBLIQUE STROKE
	{0xA7AA, 0xA7AE, prUpper},     // L&   [5] LATIN CAPITAL LETTER H WITH HOOK..LATIN CAPITAL LETTER SMALL CAPITAL I
	{0xA7AF, 0xA7AF, prLower},     // L&       LATIN LETTER SMALL CAPITAL Q
	{0xA7B0, 0xA7B4, prUpper},     // L&   [5] LATIN CAPITAL LETTER TURNED K..LATIN CAPITAL LETTER BETA
	{0xA7B5, 0xA7B5, prLower},     // L&       LATIN SMALL LETTER BETA
	{0xA7B6, 0xA7B6, prUpper},     // L&       LATIN CAPITAL LETTER OMEGA
	{0xA7B7, 0xA7B7, prLower},     // L&       LATIN SMALL LETTER OMEGA
	{0xA7B8, 0xA7B8, prUpper},     // L&       LATIN CAPITAL LETTER U WITH STROKE
	{0xA7B9, 0xA7B9, prLower},     // L&       LATIN SMALL LETTER U WITH STROKE
	{0xA7BA, 0xA7BA, prUpper},     // L&       LATIN CAPITAL LETTER GLOTTAL A
	{0xA7BB, 0xA7BB, prLower},     // L&       LATIN SMALL LETTER GLOTTAL A
	{0xA7BC, 0xA7BC, prUpper},     // L&       LATIN CAPITAL LETTER GLOTTAL I
	{0xA7BD, 0xA7BD, prLower},     // L&       LATIN SMALL LETTER GLOTTAL I
	{0xA7BE, 0xA7BE, prUpper},     // L&       LATIN CAPITAL LETTER GLOTTAL U
	{0xA7BF, 0xA7BF, prLower},     // L&       LATIN SMALL LETTER GLOTTAL U
	{0xA7C0, 0xA7C0, prUpper},     // L&       LATIN CAPITAL LETTER OLD POLISH O
	{0xA7C1, 0xA7C1, prLower},     // L&       LATIN SMALL LETTER OLD POLISH O
	{0xA7C2, 0xA7C2, prUpper},     // L&       LATIN CAPITAL LETTER ANGLICANA W
	{0xA7C3, 0xA7C3, prLower},     // L&       LATIN SMALL LETTER ANGLICANA W
	{0xA7C4, 0xA7C7, prUpper},     // L&   [4] LATIN CAPITAL LETTER C WITH PALATAL HOOK..LATIN CAPITAL LETTER D WITH SHORT STROKE OVERLAY
	{0xA7C8, 0xA7C8, prLower},     // L&       LATIN SMALL LETTER D WITH SHORT STROKE OVERLAY
	{0xA7C9, 0xA7C9, prUpper},     // L&       LATIN CAPITAL LETTER S WITH SHORT STROKE OVERLAY
	{0xA7CA, 0xA7CA, prLower},     // L&       LATIN SMALL LETTER S WITH SHORT STROKE OVERLAY
	{0xA7D0, 0xA7D0, prUpper},     // L&       LATIN CAPITAL LETTER CLOSED INSULAR G
	{0xA7D1, 0xA7D1, prLower},     // L&       LATIN SMALL LETTER CLOSED INSULAR G
	{0xA7D3, 0xA7D3, prLower},     // L&       LATIN SMALL LETTER DOUBLE THORN
	{0xA7D5, 0xA7D5, prLower},     // L&       LATIN SMALL LETTER DOUBLE WYNN
	{0xA7D6, 0xA7D6, prUpper},     // L&       LATIN CAPITAL LETTER MIDDLE SCOTS S
	{0xA7D7, 0xA7D7, prLower},     // L&       LATIN SMALL LETTER MIDDLE SCOTS S
	{0xA7D8, 0xA7D8, prUpper},     // L&       LATIN CAPITAL LETTER SIGMOID S
	{0xA7D9, 0xA7D9, prLower},     // L&       LATIN SMALL LETTER SIGMOID S
	{0xA7F2, 0xA7F4, prOLetter},   // Lm   [3] MODIFIER LETTER CAPITAL C..MODIFIER LETTER CAPITAL Q
	{0xA7F5, 0xA7F5, prUpper},     // L&       LATIN CAPITAL LETTER REVERSED HALF H
	{0xA7F6, 0xA7F6, prLower},     // L&       LATIN SMALL LETTER REVERSED HALF H
	{0xA7F7, 0xA7F7, prOLetter},   // Lo       LATIN EPIGRAPHIC LETTER SIDEWAYS I
	{0xA7F8, 0xA7F9, prLower},     // Lm   [2] MODIFIER LETTER CAPITAL H WITH STROKE..MODIFIER LETTER SMALL LIGATURE OE
	{0xA7FA, 0xA7FA, prLower},     // L&       LATIN LETTER SMALL CAPITAL TURNED M
	{0xA7FB, 0xA801, prOLetter},   // Lo   [7] LATIN EPIGRAPHIC LETTER REVERSED F..SYLOTI NAGRI LETTER I
	{0xA802, 0xA802, prExtend},    // Mn       SYLOTI NAGRI SIGN DVISVARA
	{0xA803, 0xA805, prOLetter},   // Lo   [3] SYLOTI NAGRI LETTER U..SYLOTI NAGRI LETTER O
	{0xA806, 0xA806, prExtend},    // Mn       SYLOTI NAGRI SIGN HASANTA
	{0xA807, 0xA80A, prOLetter},   // Lo   [4] SYLOTI NAGRI LETTER KO..SYLOTI NAGRI LETTER GHO
	{0xA80B, 0xA80B, prExtend},    // Mn       SYLOTI NAGRI SIGN ANUSVARA
	{0xA80C, 0xA822, prOLetter},   // Lo  [23] SYLOTI NAGRI LETTER CO..SYLOTI NAGRI LETTER HO
	{0xA823, 0xA824, prExtend},    // Mc   [2] SYLOTI NAGRI VOWEL SIGN A..SYLOTI NAGRI VOWEL SIGN I
	{0xA825, 0xA826, prExtend},    // Mn   [2] SYLOTI NAGRI VOWEL SIGN U..SYLOTI NAGRI VOWEL SIGN E
	{0xA827, 0xA827, prExtend},    // Mc       SYLOTI NAGRI VOWEL SIGN OO
	{0xA82C, 0xA82C, prExtend},    // Mn       SYLOTI NAGRI SIGN ALTERNATE HASANTA
	{0xA840, 0xA873, prOLetter},   // Lo  [52] PHAGS-PA LETTER KA..PHAGS-PA LETTER CANDRABINDU
	{0xA876, 0xA877, prSTerm},     // Po   [2] PHAGS-PA MARK SHAD..PHAGS-PA MARK DOUBLE SHAD
	{0xA880, 0xA881, prExtend},    // Mc   [2] SAURASHTRA SIGN ANUSVARA..SAURASHTRA SIGN VISARGA
	{0xA882, 0xA8B3, prOLetter},   // Lo  [50] SAURASHTRA LETTER A..SAURASHTRA LETTER LLA
	{0xA8B4, 0xA8C3, prExtend},    // Mc  [16] SAURASHTRA CONSONANT SIGN HAARU..SAURASHTRA VOWEL SIGN AU
	{0xA8C4, 0xA8C5, prExtend},    // Mn   [2] SAURASHTRA SIGN VIRAMA..SAURASHTRA SIGN CANDRABINDU
	{0xA8CE, 0xA8CF, prSTerm},     // Po   [2] SAURASHTRA DANDA..SAURASHTRA DOUBLE DANDA
	{0xA8D0, 0xA8D9, prNumeric},   // Nd  [10] SAURASHTRA DIGIT ZERO..SAURASHTRA DIGIT NINE
	{0xA8E0, 0xA8F1, prExtend},    // Mn  [18] COMBINING DEVANAGARI DIGIT ZERO..COMBINING DEVANAGARI SIGN AVAGRAHA
	{0xA8F2, 0xA8F7, prOLetter},   // Lo   [6] DEVANAGARI SIGN SPACING CANDRABINDU..DEVANAGARI SIGN CANDRABINDU AVAGRAHA
	{0xA8FB, 0xA8FB, prOLetter},   // Lo       DEVANAGARI HEADSTROKE
	{0xA8FD, 0xA8FE, prOLetter},   // Lo   [2] DEVANAGARI JAIN OM..DEVANAGARI LETTER AY
	{0xA8FF, 0xA8FF, prExtend},    // Mn       DEVANAGARI VOWEL SIGN AY
	{0xA900, 0xA909, prNumeric},   // Nd  [10] KAYAH LI DIGIT ZERO..KAYAH LI DIGIT NINE
	{0xA90A, 0xA925, prOLetter},   // Lo  [28] KAYAH LI LETTER KA..KAYAH LI LETTER OO
	{0xA926, 0xA92D, prExtend},    // Mn   [8] KAYAH LI VOWEL UE..KAYAH LI TONE CALYA PLOPHU
	{0xA92F, 0xA92F, prSTerm},     // Po       KAYAH LI SIGN SHYA
	{0xA930, 0xA946, prOLetter},   // Lo  [23] REJANG LETTER KA..REJANG LETTER A
	{0xA947, 0xA951, prExtend},    // Mn  [11] REJANG VOWEL SIGN I..REJANG CONSONANT SIGN R
	{0xA952, 0xA953, prExtend},    // Mc   [2] REJANG CONSONANT SIGN H..REJANG VIRAMA
	{0xA960, 0xA97C, prOLetter},   // Lo  [29] HANGUL CHOSEONG TIKEUT-MIEUM..HANGUL CHOSEONG SSANGYEORINHIEUH
	{0xA980, 0xA982, prExtend},    // Mn   [3] JAVANESE SIGN PANYANGGA..JAVANESE SIGN LAYAR
	{0xA983, 0xA983, prExtend},    // Mc       JAVANESE SIGN WIGNYAN
	{0xA984, 0xA9B2, prOLetter},   // Lo  [47] JAVANESE LETTER A..JAVANESE LETTER HA
	{0xA9B3, 0xA9B3, prExtend},    // Mn       JAVANESE SIGN CECAK TELU
	{0xA9B4, 0xA9B5, prExtend},    // Mc   [2] JAVANESE VOWEL SIGN TARUNG..JAVANESE VOWEL SIGN TOLONG
	{0xA9B6, 0xA9B9, prExtend},    // Mn   [4] JAVANESE VOWEL SIGN WULU..JAVANESE VOWEL SIGN SUKU MENDUT
	{0xA9BA, 0xA9BB, prExtend},    // Mc   [2] JAVANESE VOWEL SIGN TALING..JAVANESE VOWEL SIGN DIRGA MURE
	{0xA9BC, 0xA9BD, prExtend},    // Mn   [2] JAVANESE VOWEL SIGN PEPET..JAVANESE CONSONANT SIGN KERET
	{0xA9BE, 0xA9C0, prExtend},    // Mc   [3] JAVANESE CONSONANT SIGN PENGKAL..JAVANESE PANGKON
	{0xA9C8, 0xA9C9, prSTerm},     // Po   [2] JAVANESE PADA LINGSA..JAVANESE PADA LUNGSI
	{0xA9CF, 0xA9CF, prOLetter},   // Lm       JAVANESE PANGRANGKEP
	{0xA9D0, 0xA9D9, prNumeric},   // Nd  [10] JAVANESE DIGIT ZERO..JAVANESE DIGIT NINE
	{0xA9E0, 0xA9E4, prOLetter},   // Lo   [5] MYANMAR LETTER SHAN GHA..MYANMAR LETTER SHAN BHA
	{0xA9E5, 0xA9E5, prExtend},    // Mn       MYANMAR SIGN SHAN SAW
	{0xA9E6, 0xA9E6, prOLetter},   // Lm       MYANMAR MODIFIER LETTER SHAN REDUPLICATION
	{0xA9E7, 0xA9EF, prOLetter},   // Lo   [9] MYANMAR LETTER TAI LAING NYA..MYANMAR LETTER TAI LAING NNA
	{0xA9F0, 0xA9F9, prNumeric},   // Nd  [10] MYANMAR TAI LAING DIGIT ZERO..MYANMAR TAI LAING DIGIT NINE
	{0xA9FA, 0xA9FE, prOLetter},   // Lo   [5] MYANMAR LETTER TAI LAING LLA..MYANMAR LETTER TAI LAING BHA
	{0xAA00, 0xAA28, prOLetter},   // Lo  [41] CHAM LETTER A..CHAM LETTER HA
	{0xAA29, 0xAA2E, prExtend},    // Mn   [6] CHAM VOWEL SIGN AA..CHAM VOWEL SIGN OE
	{0xAA2F, 0xAA30, prExtend},    // Mc   [2] CHAM VOWEL SIGN O..CHAM VOWEL SIGN AI
	{0xAA31, 0xAA32, prExtend},    // Mn   [2] CHAM VOWEL SIGN AU..CHAM VOWEL SIGN UE
	{0xAA33, 0xAA34, prExtend},    // Mc   [2] CHAM CONSONANT SIGN YA..CHAM CONSONANT SIGN RA
	{0xAA35, 0xAA36, prExtend},    // Mn   [2] CHAM CONSONANT SIGN LA..CHAM CONSONANT SIGN WA
	{0xAA40, 0xAA42, prOLetter},   // Lo   [3] CHAM LETTER FINAL K..CHAM LETTER FINAL NG
	{0xAA43, 0xAA43, prExtend},    // Mn       CHAM CONSONANT SIGN FINAL NG
	{0xAA44, 0xAA4B, prOLetter},   // Lo   [8] CHAM LETTER FINAL CH..CHAM LETTER FINAL SS
	{0xAA4C, 0xAA4C, prExtend},    // Mn       CHAM CONSONANT SIGN FINAL M
	{0xAA4D, 0xAA4D, prExtend},    // Mc       CHAM CONSONANT SIGN FINAL H
	{0xAA50, 0xAA59, prNumeric},   // Nd  [10] CHAM DIGIT ZERO..CHAM DIGIT NINE
	{0xAA5D, 0xAA5F, prSTerm},     // Po   [3] CHAM PUNCTUATION DANDA..CHAM PUNCTUATION TRIPLE DANDA
	{0xAA60, 0xAA6F, prOLetter},   // Lo  [16] MYANMAR LETTER KHAMTI GA..MYANMAR LETTER KHAMTI FA
	{0xAA70, 0xAA70, prOLetter},   // Lm       MYANMAR MODIFIER LETTER KHAMTI REDUPLICATION
	{0xAA71, 0xAA76, prOLetter},   // Lo   [6] MYANMAR LETTER KHAMTI XA..MYANMAR LOGOGRAM KHAMTI HM
	{0xAA7A, 0xAA7A, prOLetter},   // Lo       MYANMAR LETTER AITON RA
	{0xAA7B, 0xAA7B, prExtend},    // Mc       MYANMAR SIGN PAO KAREN TONE
	{0xAA7C, 0xAA7C, prExtend},    // Mn       MYANMAR SIGN TAI LAING TONE-2
	{0xAA7D, 0xAA7D, prExtend},    // Mc       MYANMAR SIGN TAI LAING TONE-5
	{0xAA7E, 0xAAAF, prOLetter},   // Lo  [50] MYANMAR LETTER SHWE PALAUNG CHA..TAI VIET LETTER HIGH O
	{0xAAB0, 0xAAB0, prExtend},    // Mn       TAI VIET MAI KANG
	{0xAAB1, 0xAAB1, prOLetter},   // Lo       TAI VIET VOWEL AA
	{0xAAB2, 0xAAB4, prExtend},    // Mn   [3] TAI VIET VOWEL I..TAI VIET VOWEL U
	{0xAAB5, 0xAAB6, prOLetter},   // Lo   [2] TAI VIET VOWEL E..TAI VIET VOWEL O
	{0xAAB7, 0xAAB8, prExtend},    // Mn   [2] TAI VIET MAI KHIT..TAI VIET VOWEL IA
	{0xAAB9, 0xAABD, prOLetter},   // Lo   [5] TAI VIET VOWEL UEA..TAI VIET VOWEL AN
	{0xAABE, 0xAABF, prExtend},    // Mn   [2] TAI VIET VOWEL AM..TAI VIET TONE MAI EK
	{0xAAC0, 0xAAC0, prOLetter},   // Lo       TAI VIET TONE MAI NUENG
	{0xAAC1, 0xAAC1, prExtend},    // Mn       TAI VIET TONE MAI THO
	{0xAAC2, 0xAAC2, prOLetter},   // Lo       TAI VIET TONE MAI SONG
	{0xAADB, 0xAADC, prOLetter},   // Lo   [2] TAI VIET SYMBOL KON..TAI VIET SYMBOL NUENG
	{0xAADD, 0xAADD, prOLetter},   // Lm       TAI VIET SYMBOL SAM
	{0xAAE0, 0xAAEA, prOLetter},   // Lo  [11] MEETEI MAYEK LETTER E..MEETEI MAYEK LETTER SSA
	{0xAAEB, 0xAAEB, prExtend},    // Mc       MEETEI MAYEK VOWEL SIGN II
	{0xAAEC, 0xAAED, prExtend},    // Mn   [2] MEETEI MAYEK VOWEL SIGN UU..MEETEI MAYEK VOWEL SIGN AAI
	{0xAAEE, 0xAAEF, prExtend},    // Mc   [2] MEETEI MAYEK VOWEL SIGN AU..MEETEI MAYEK VOWEL SIGN AAU
	{0xAAF0, 0xAAF1, prSTerm},     // Po   [2] MEETEI MAYEK CHEIKHAN..MEETEI MAYEK AHANG KHUDAM
	{0xAAF2, 0xAAF2, prOLetter},   // Lo       MEETEI MAYEK ANJI
	{0xAAF3, 0xAAF4, prOLetter},   // Lm   [2] MEETEI MAYEK SYLLABLE REPETITION MARK..MEETEI MAYEK WORD REPETITION MARK
	{0xAAF5, 0xAAF5, prExtend},    // Mc       MEETEI MAYEK VOWEL SIGN VISARGA
	{0xAAF6, 0xAAF6, prExtend},    // Mn       MEETEI MAYEK VIRAMA
	{0xAB01, 0xAB06, prOLetter},   // Lo   [6] ETHIOPIC SYLLABLE TTHU..ETHIOPIC SYLLABLE TTHO
	{0xAB09, 0xAB0E, prOLetter},   // Lo   [6] ETHIOPIC SYLLABLE DDHU..ETHIOPIC SYLLABLE DDHO
	{0xAB11, 0xAB16, prOLetter},   // Lo   [6] ETHIOPIC SYLLABLE DZU..ETHIOPIC SYLLABLE DZO
	{0xAB20, 0xAB26, prOLetter},   // Lo   [7] ETHIOPIC SYLLABLE CCHHA..ETHIOPIC SYLLABLE CCHHO
	{0xAB28, 0xAB2E, prOLetter},   // Lo   [7] ETHIOPIC SYLLABLE BBA..ETHIOPIC SYLLABLE BBO
	{0xAB30, 0xAB5A, prLower},     // L&  [43] LATIN SMALL LETTER BARRED ALPHA..LATIN SMALL LETTER Y WITH SHORT RIGHT LEG
	{0xAB5C, 0xAB5F, prLower},     // Lm   [4] MODIFIER LETTER SMALL HENG..MODIFIER LETTER SMALL U WITH LEFT HOOK
	{0xAB60, 0xAB68, prLower},     // L&   [9] LATIN SMALL LETTER SAKHA YAT..LATIN SMALL LETTER TURNED R WITH MIDDLE TILDE
	{0xAB69, 0xAB69, prOLetter},   // Lm       MODIFIER LETTER SMALL TURNED W
	{0xAB70, 0xABBF, prLower},     // L&  [80] CHEROKEE SMALL LETTER A..CHEROKEE SMALL LETTER YA
	{0xABC0, 0xABE2, prOLetter},   // Lo  [35] MEETEI MAYEK LETTER KOK..MEETEI MAYEK LETTER I LONSUM
	{0xABE3, 0xABE4, prExtend},    // Mc   [2] MEETEI MAYEK VOWEL SIGN ONAP..MEETEI MAYEK VOWEL SIGN INAP
	{0xABE5, 0xABE5, prExtend},    // Mn       MEETEI MAYEK VOWEL SIGN ANAP
	{0xABE6, 0xABE7, prExtend},    // Mc   [2] MEETEI MAYEK VOWEL SIGN YENAP..MEETEI MAYEK VOWEL SIGN SOUNAP
	{0xABE8, 0xABE8, prExtend},    // Mn       MEETEI MAYEK VOWEL SIGN UNAP
	{0xABE9, 0xABEA, prExtend},    // Mc   [2] MEETEI MAYEK VOWEL SIGN CHEINAP..MEETEI MAYEK VOWEL SIGN NUNG
	{0xABEB, 0xABEB, prSTerm},     // Po       MEETEI MAYEK CHEIKHEI
	{0xABEC, 0xABEC, prExtend},    // Mc       MEETEI MAYEK LUM IYEK
	{0xABED, 0xABED, prExtend},    // Mn       MEETEI MAYEK APUN IYEK
	{0xABF0, 0xABF9, prNumeric},   // Nd  [10] MEETEI MAYEK DIGIT ZERO..MEETEI MAYEK DIGIT NINE
	{0xAC00, 0xD7A3, prOLetter},   // Lo [11172] HANGUL SYLLABLE GA..HANGUL SYLLABLE HIH
	{0xD7B0, 0xD7C6, prOLetter},   // Lo  [23] HANGUL JUNGSEONG O-YEO..HANGUL JUNGSEONG ARAEA-E
	{0xD7CB, 0xD7FB, prOLetter},   // Lo  [49] HANGUL JONGSEONG NIEUN-RIEUL..HANGUL JONGSEONG PHIEUPH-THIEUTH
	{0xF900, 0xFA6D, prOLetter},   // Lo [366] CJK COMPATIBILITY IDEOGRAPH-F900..CJK COMPATIBILITY IDEOGRAPH-FA6D
	{0xFA70, 0xFAD9, prOLetter},   // Lo [106] CJK COMPATIBILITY IDEOGRAPH-FA70..CJK COMPATIBILITY IDEOGRAPH-FAD9
	{0xFB00, 0xFB06, prLower},     // L&   [7] LATIN SMALL LIGATURE FF..LATIN SMALL LIGATURE ST
	{0xFB13, 0xFB17, prLower},     // L&   [5] ARMENIAN SMALL LIGATURE MEN NOW..ARMENIAN SMALL LIGATURE MEN XEH
	{0xFB1D, 0xFB1D, prOLetter},   // Lo       HEBREW LETTER YOD WITH HIRIQ
	{0xFB1E, 0xFB1E, prExtend},    // Mn       HEBREW POINT JUDEO-SPANISH VARIKA
	{0xFB1F, 0xFB28, prOLetter},   // Lo  [10] HEBREW LIGATURE YIDDISH YOD YOD PATAH..HEBREW LETTER WIDE TAV
	{0xFB2A, 0xFB36, prOLetter},   // Lo  [13] HEBREW LETTER SHIN WITH SHIN DOT..HEBREW LETTER ZAYIN WITH DAGESH
	{0xFB38, 0xFB3C, prOLetter},   // Lo   [5] HEBREW LETTER TET WITH DAGESH..HEBREW LETTER LAMED WITH DAGESH
	{0xFB3E, 0xFB3E, prOLetter},   // Lo       HEBREW LETTER MEM WITH DAGESH
	{0xFB40, 0xFB41, prOLetter},   // Lo   [2] HEBREW LETTER NUN WITH DAGESH..HEBREW LETTER SAMEKH WITH DAGESH
	{0xFB43, 0xFB44, prOLetter},   // Lo   [2] HEBREW LETTER FINAL PE WITH DAGESH..HEBREW LETTER PE WITH DAGESH
	{0xFB46, 0xFBB1, prOLetter},   // Lo [108] HEBREW LETTER TSADI WITH DAGESH..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM
	{0xFBD3, 0xFD3D, prOLetter},   // Lo [363] ARABIC LETTER NG ISOLATED FORM..ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM
	{0xFD3E, 0xFD3E, prClose},     // Pe       ORNATE LEFT PARENTHESIS
	{0xFD3F, 0xFD3F, prClose},     // Ps       ORNATE RIGHT PARENTHESIS
	{0xFD50, 0xFD8F, prOLetter},   // Lo  [64] ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM..ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM
	{0xFD92, 0xFDC7, prOLetter},   // Lo  [54] ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM..ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM
	{0xFDF0, 0xFDFB, prOLetter},   // Lo  [12] ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM..ARABIC LIGATURE JALLAJALALOUHOU
	{0xFE00, 0xFE0F, prExtend},    // Mn  [16] VARIATION SELECTOR-1..VARIATION SELECTOR-16
	{0xFE10, 0xFE11, prSContinue}, // Po   [2] PRESENTATION FORM FOR VERTICAL COMMA..PRESENTATION FORM FOR VERTICAL IDEOGRAPHIC COMMA
	{0xFE13, 0xFE13, prSContinue}, // Po       PRESENTATION FORM FOR VERTICAL COLON
	{0xFE17, 0xFE17, prClose},     // Ps       PRESENTATION FORM FOR VERTICAL LEFT WHITE LENTICULAR BRACKET
	{0xFE18, 0xFE18, prClose},     // Pe       PRESENTATION FORM FOR VERTICAL RIGHT WHITE LENTICULAR BRAKCET
	{0xFE20, 0xFE2F, prExtend},    // Mn  [16] COMBINING LIGATURE LEFT HALF..COMBINING CYRILLIC TITLO RIGHT HALF
	{0xFE31, 0xFE32, prSContinue}, // Pd   [2] PRESENTATION FORM FOR VERTICAL EM DASH..PRESENTATION FORM FOR VERTICAL EN DASH
	{0xFE35, 0xFE35, prClose},     // Ps       PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS
	{0xFE36, 0xFE36, prClose},     // Pe       PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS
	{0xFE37, 0xFE37, prClose},     // Ps       PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET
	{0xFE38, 0xFE38, prClose},     // Pe       PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET
	{0xFE39, 0xFE39, prClose},     // Ps       PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET
	{0xFE3A, 0xFE3A, prClose},     // Pe       PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET
	{0xFE3B, 0xFE3B, prClose},     // Ps       PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET
	{0xFE3C, 0xFE3C, prClose},     // Pe       PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET
	{0xFE3D, 0xFE3D, prClose},     // Ps       PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET
	{0xFE3E, 0xFE3E, prClose},     // Pe       PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET
	{0xFE3F, 0xFE3F, prClose},     // Ps       PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET
	{0xFE40, 0xFE40, prClose},     // Pe       PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET
	{0xFE41, 0xFE41, prClose},     // Ps       PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET
	{0xFE42, 0xFE42, prClose},     // Pe       PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET
	{0xFE43, 0xFE43, prClose},     // Ps       PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET
	{0xFE44, 0xFE44, prClose},     // Pe       PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET
	{0xFE47, 0xFE47, prClose},     // Ps       PRESENTATION FORM FOR VERTICAL LEFT SQUARE BRACKET
	{0xFE48, 0xFE48, prClose},     // Pe       PRESENTATION FORM FOR VERTICAL RIGHT SQUARE BRACKET
	{0xFE50, 0xFE51, prSContinue}, // Po   [2] SMALL COMMA..SMALL IDEOGRAPHIC COMMA
	{0xFE52, 0xFE52, prATerm},     // Po       SMALL FULL STOP
	{0xFE55, 0xFE55, prSContinue}, // Po       SMALL COLON
	{0xFE56, 0xFE57, prSTerm},     // Po   [2] SMALL QUESTION MARK..SMALL EXCLAMATION MARK
	{0xFE58, 0xFE58, prSContinue}, // Pd       SMALL EM DASH
	{0xFE59, 0xFE59, prClose},     // Ps       SMALL LEFT PARENTHESIS
	{0xFE5A, 0xFE5A, prClose},     // Pe       SMALL RIGHT PARENTHESIS
	{0xFE5B, 0xFE5B, prClose},     // Ps       SMALL LEFT CURLY BRACKET
	{0xFE5C, 0xFE5C, prClose},     // Pe       SMALL RIGHT CURLY BRACKET
	{0xFE5D, 0xFE5D, prClose},     // Ps       SMALL LEFT TORTOISE SHELL BRACKET
	{0xFE5E, 0xFE5E, prClose},     // Pe       SMALL RIGHT TORTOISE SHELL BRACKET
	{0xFE63, 0xFE63, prSContinue}, // Pd       SMALL HYPHEN-MINUS
	{0xFE70, 0xFE74, prOLetter},   // Lo   [5] ARABIC FATHATAN ISOLATED FORM..ARABIC KASRATAN ISOLATED FORM
	{0xFE76, 0xFEFC, prOLetter},   // Lo [135] ARABIC FATHA ISOLATED FORM..ARABIC LIGATURE LAM WITH ALEF FINAL FORM
	{0xFEFF, 0xFEFF, prFormat},    // Cf       ZERO WIDTH NO-BREAK SPACE
	{0xFF01, 0xFF01, prSTerm},     // Po       FULLWIDTH EXCLAMATION MARK
	{0xFF08, 0xFF08, prClose},     // Ps       FULLWIDTH LEFT PARENTHESIS
	{0xFF09, 0xFF09, prClose},     // Pe       FULLWIDTH RIGHT PARENTHESIS
	{0xFF0C, 0xFF0C, prSContinue}, // Po       FULLWIDTH COMMA
	{0xFF0D, 0xFF0D, prSContinue}, // Pd       FULLWIDTH HYPHEN-MINUS
	{0xFF0E, 0xFF0E, prATerm},     // Po       FULLWIDTH FULL STOP
	{0xFF10, 0xFF19, prNumeric},   // Nd  [10] FULLWIDTH DIGIT ZERO..FULLWIDTH DIGIT NINE
	{0xFF1A, 0xFF1A, prSContinue}, // Po       FULLWIDTH COLON
	{0xFF1F, 0xFF1F, prSTerm},     // Po       FULLWIDTH QUESTION MARK
	{0xFF21, 0xFF3A, prUpper},     // L&  [26] FULLWIDTH LATIN CAPITAL LETTER A..FULLWIDTH LATIN CAPITAL LETTER Z
	{0xFF3B, 0xFF3B, prClose},     // Ps       FULLWIDTH LEFT SQUARE BRACKET
	{0xFF3D, 0xFF3D, prClose},     // Pe       FULLWIDTH RIGHT SQUARE BRACKET
	{0xFF41, 0xFF5A, prLower},     // L&  [26] FULLWIDTH LATIN SMALL LETTER A..FULLWIDTH LATIN SMALL LETTER Z
	{0xFF5B, 0xFF5B, prClose},     // Ps       FULLWIDTH LEFT CURLY BRACKET
	{0xFF5D, 0xFF5D, prClose},     // Pe       FULLWIDTH RIGHT CURLY BRACKET
	{0xFF5F, 0xFF5F, prClose},     // Ps       FULLWIDTH LEFT WHITE PARENTHESIS
	{0xFF60, 0xFF60, prClose},     // Pe       FULLWIDTH RIGHT WHITE PARENTHESIS
	{0xFF61, 0xFF61, prSTerm},     // Po       HALFWIDTH IDEOGRAPHIC FULL STOP
	{0xFF62, 0xFF62, prClose},     // Ps       HALFWIDTH LEFT CORNER BRACKET
	{0xFF63, 0xFF63, prClose},     // Pe       HALFWIDTH RIGHT CORNER BRACKET
	{0xFF64, 0xFF64, prSContinue}, // Po       HALFWIDTH IDEOGRAPHIC COMMA
	{0xFF66, 0xFF6F, prOLetter},   // Lo  [10] HALFWIDTH KATAKANA LETTER WO..HALFWIDTH KATAKANA LETTER SMALL TU
	{0xFF70, 0xFF70, prOLetter},   // Lm       HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
	{0xFF71, 0xFF9D, prOLetter},   // Lo  [45] HALFWIDTH KATAKANA LETTER A..HALFWIDTH KATAKANA LETTER N
	{0xFF9E, 0xFF9F, prExtend},    // Lm   [2] HALFWIDTH KATAKANA VOICED SOUND MARK..HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
	{0xFFA0, 0xFFBE, prOLetter},   // Lo  [31] HALFWIDTH HANGUL FILLER..HALFWIDTH HANGUL LETTER HIEUH
	{0xFFC2, 0xFFC7, prOLetter},   // Lo   [6] HALFWIDTH HANGUL LETTER A..HALFWIDTH HANGUL LETTER E
	{0xFFCA, 0xFFCF, prOLetter},   // Lo   [6] HALFWIDTH HANGUL LETTER YEO..HALFWIDTH HANGUL LETTER OE
	{0xFFD2, 0xFFD7, prOLetter},   // Lo   [6] HALFWIDTH HANGUL LETTER YO..HALFWIDTH HANGUL LETTER YU
	{0xFFDA, 0xFFDC, prOLetter},   // Lo   [3] HALFWIDTH HANGUL LETTER EU..HALFWIDTH HANGUL LETTER I
	{0xFFF9, 0xFFFB, prFormat},    // Cf   [3] INTERLINEAR ANNOTATION ANCHOR..INTERLINEAR ANNOTATION TERMINATOR
	{0x10000, 0x1000B, prOLetter}, // Lo  [12] LINEAR B SYLLABLE B008 A..LINEAR B SYLLABLE B046 JE
	{0x1000D, 0x10026, prOLetter}, // Lo  [26] LINEAR B SYLLABLE B036 JO..LINEAR B SYLLABLE B032 QO
	{0x10028, 0x1003A, prOLetter}, // Lo  [19] LINEAR B SYLLABLE B060 RA..LINEAR B SYLLABLE B042 WO
	{0x1003C, 0x1003D, prOLetter}, // Lo   [2] LINEAR B SYLLABLE B017 ZA..LINEAR B SYLLABLE B074 ZE
	{0x1003F, 0x1004D, prOLetter}, // Lo  [15] LINEAR B SYLLABLE B020 ZO..LINEAR B SYLLABLE B091 TWO
	{0x10050, 0x1005D, prOLetter}, // Lo  [14] LINEAR B SYMBOL B018..LINEAR B SYMBOL B089
	{0x10080, 0x100FA, prOLetter}, // Lo [123] LINEAR B IDEOGRAM B100 MAN..LINEAR B IDEOGRAM VESSEL B305
	{0x10140, 0x10174, prOLetter}, // Nl  [53] GREEK ACROPHONIC ATTIC ONE QUARTER..GREEK ACROPHONIC STRATIAN FIFTY MNAS
	{0x101FD, 0x101FD, prExtend},  // Mn       PHAISTOS DISC SIGN COMBINING OBLIQUE STROKE
	{0x10280, 0x1029C, prOLetter}, // Lo  [29] LYCIAN LETTER A..LYCIAN LETTER X
	{0x102A0, 0x102D0, prOLetter}, // Lo  [49] CARIAN LETTER A..CARIAN LETTER UUU3
	{0x102E0, 0x102E0, prExtend},  // Mn       COPTIC EPACT THOUSANDS MARK
	{0x10300, 0x1031F, prOLetter}, // Lo  [32] OLD ITALIC LETTER A..OLD ITALIC LETTER ESS
	{0x1032D, 0x10340, prOLetter}, // Lo  [20] OLD ITALIC LETTER YE..GOTHIC LETTER PAIRTHRA
	{0x10341, 0x10341, prOLetter}, // Nl       GOTHIC LETTER NINETY
	{0x10342, 0x10349, prOLetter}, // Lo   [8] GOTHIC LETTER RAIDA..GOTHIC LETTER OTHAL
	{0x1034A, 0x1034A, prOLetter}, // Nl       GOTHIC LETTER NINE HUNDRED
	{0x10350, 0x10375, prOLetter}, // Lo  [38] OLD PERMIC LETTER AN..OLD PERMIC LETTER IA
	{0x10376, 0x1037A, prExtend},  // Mn   [5] COMBINING OLD PERMIC LETTER AN..COMBINING OLD PERMIC LETTER SII
	{0x10380, 0x1039D, prOLetter}, // Lo  [30] UGARITIC LETTER ALPA..UGARITIC LETTER SSU
	{0x103A0, 0x103C3, prOLetter}, // Lo  [36] OLD PERSIAN SIGN A..OLD PERSIAN SIGN HA
	{0x103C8, 0x103CF, prOLetter}, // Lo   [8] OLD PERSIAN SIGN AURAMAZDAA..OLD PERSIAN SIGN BUUMISH
	{0x103D1, 0x103D5, prOLetter}, // Nl   [5] OLD PERSIAN NUMBER ONE..OLD PERSIAN NUMBER HUNDRED
	{0x10400, 0x10427, prUpper},   // L&  [40] DESERET CAPITAL LETTER LONG I..DESERET CAPITAL LETTER EW
	{0x10428, 0x1044F, prLower},   // L&  [40] DESERET SMALL LETTER LONG I..DESERET SMALL LETTER EW
	{0x10450, 0x1049D, prOLetter}, // Lo  [78] SHAVIAN LETTER PEEP..OSMANYA LETTER OO
	{0x104A0, 0x104A9, prNumeric}, // Nd  [10] OSMANYA DIGIT ZERO..OSMANYA DIGIT NINE
	{0x104B0, 0x104D3, prUpper},   // L&  [36] OSAGE CAPITAL LETTER A..OSAGE CAPITAL LETTER ZHA
	{0x104D8, 0x104FB, prLower},   // L&  [36] OSAGE SMALL LETTER A..OSAGE SMALL LETTER ZHA
	{0x10500, 0x10527, prOLetter}, // Lo  [40] ELBASAN LETTER A..ELBASAN LETTER KHE
	{0x10530, 0x10563, prOLetter}, // Lo  [52] CAUCASIAN ALBANIAN LETTER ALT..CAUCASIAN ALBANIAN LETTER KIW
	{0x10570, 0x1057A, prUpper},   // L&  [11] VITHKUQI CAPITAL LETTER A..VITHKUQI CAPITAL LETTER GA
	{0x1057C, 0x1058A, prUpper},   // L&  [15] VITHKUQI CAPITAL LETTER HA..VITHKUQI CAPITAL LETTER RE
	{0x1058C, 0x10592, prUpper},   // L&   [7] VITHKUQI CAPITAL LETTER SE..VITHKUQI CAPITAL LETTER XE
	{0x10594, 0x10595, prUpper},   // L&   [2] VITHKUQI CAPITAL LETTER Y..VITHKUQI CAPITAL LETTER ZE
	{0x10597, 0x105A1, prLower},   // L&  [11] VITHKUQI SMALL LETTER A..VITHKUQI SMALL LETTER GA
	{0x105A3, 0x105B1, prLower},   // L&  [15] VITHKUQI SMALL LETTER HA..VITHKUQI SMALL LETTER RE
	{0x105B3, 0x105B9, prLower},   // L&   [7] VITHKUQI SMALL LETTER SE..VITHKUQI SMALL LETTER XE
	{0x105BB, 0x105BC, prLower},   // L&   [2] VITHKUQI SMALL LETTER Y..VITHKUQI SMALL LETTER ZE
	{0x10600, 0x10736, prOLetter}, // Lo [311] LINEAR A SIGN AB001..LINEAR A SIGN A664
	{0x10740, 0x10755, prOLetter}, // Lo  [22] LINEAR A SIGN A701 A..LINEAR A SIGN A732 JE
	{0x10760, 0x10767, prOLetter}, // Lo   [8] LINEAR A SIGN A800..LINEAR A SIGN A807
	{0x10780, 0x10780, prLower},   // Lm       MODIFIER LETTER SMALL CAPITAL AA
	{0x10781, 0x10782, prOLetter}, // Lm   [2] MODIFIER LETTER SUPERSCRIPT TRIANGULAR COLON..MODIFIER LETTER SUPERSCRIPT HALF TRIANGULAR COLON
	{0x10783, 0x10785, prLower},   // Lm   [3] MODIFIER LETTER SMALL AE..MODIFIER LETTER SMALL B WITH HOOK
	{0x10787, 0x107B0, prLower},   // Lm  [42] MODIFIER LETTER SMALL DZ DIGRAPH..MODIFIER LETTER SMALL V WITH RIGHT HOOK
	{0x107B2, 0x107BA, prLower},   // Lm   [9] MODIFIER LETTER SMALL CAPITAL Y..MODIFIER LETTER SMALL S WITH CURL
	{0x10800, 0x10805, prOLetter}, // Lo   [6] CYPRIOT SYLLABLE A..CYPRIOT SYLLABLE JA
	{0x10808, 0x10808, prOLetter}, // Lo       CYPRIOT SYLLABLE JO
	{0x1080A, 0x10835, prOLetter}, // Lo  [44] CYPRIOT SYLLABLE KA..CYPRIOT SYLLABLE WO
	{0x10837, 0x10838, prOLetter}, // Lo   [2] CYPRIOT SYLLABLE XA..CYPRIOT SYLLABLE XE
	{0x1083C, 0x1083C, prOLetter}, // Lo       CYPRIOT SYLLABLE ZA
	{0x1083F, 0x10855, prOLetter}, // Lo  [23] CYPRIOT SYLLABLE ZO..IMPERIAL ARAMAIC LETTER TAW
	{0x10860, 0x10876, prOLetter}, // Lo  [23] PALMYRENE LETTER ALEPH..PALMYRENE LETTER TAW
	{0x10880, 0x1089E, prOLetter}, // Lo  [31] NABATAEAN LETTER FINAL ALEPH..NABATAEAN LETTER TAW
	{0x108E0, 0x108F2, prOLetter}, // Lo  [19] HATRAN LETTER ALEPH..HATRAN LETTER QOPH
	{0x108F4, 0x108F5, prOLetter}, // Lo   [2] HATRAN LETTER SHIN..HATRAN LETTER TAW
	{0x10900, 0x10915, prOLetter}, // Lo  [22] PHOENICIAN LETTER ALF..PHOENICIAN LETTER TAU
	{0x10920, 0x10939, prOLetter}, // Lo  [26] LYDIAN LETTER A..LYDIAN LETTER C
	{0x10980, 0x109B7, prOLetter}, // Lo  [56] MEROITIC HIEROGLYPHIC LETTER A..MEROITIC CURSIVE LETTER DA
	{0x109BE, 0x109BF, prOLetter}, // Lo   [2] MEROITIC CURSIVE LOGOGRAM RMT..MEROITIC CURSIVE LOGOGRAM IMN
	{0x10A00, 0x10A00, prOLetter}, // Lo       KHAROSHTHI LETTER A
	{0x10A01, 0x10A03, prExtend},  // Mn   [3] KHAROSHTHI VOWEL SIGN I..KHAROSHTHI VOWEL SIGN VOCALIC R
	{0x10A05, 0x10A06, prExtend},  // Mn   [2] KHAROSHTHI VOWEL SIGN E..KHAROSHTHI VOWEL SIGN O
	{0x10A0C, 0x10A0F, prExtend},  // Mn   [4] KHAROSHTHI VOWEL LENGTH MARK..KHAROSHTHI SIGN VISARGA
	{0x10A10, 0x10A13, prOLetter}, // Lo   [4] KHAROSHTHI LETTER KA..KHAROSHTHI LETTER GHA
	{0x10A15, 0x10A17, prOLetter}, // Lo   [3] KHAROSHTHI LETTER CA..KHAROSHTHI LETTER JA
	{0x10A19, 0x10A35, prOLetter}, // Lo  [29] KHAROSHTHI LETTER NYA..KHAROSHTHI LETTER VHA
	{0x10A38, 0x10A3A, prExtend},  // Mn   [3] KHAROSHTHI SIGN BAR ABOVE..KHAROSHTHI SIGN DOT BELOW
	{0x10A3F, 0x10A3F, prExtend},  // Mn       KHAROSHTHI VIRAMA
	{0x10A56, 0x10A57, prSTerm},   // Po   [2] KHAROSHTHI PUNCTUATION DANDA..KHAROSHTHI PUNCTUATION DOUBLE DANDA
	{0x10A60, 0x10A7C, prOLetter}, // Lo  [29] OLD SOUTH ARABIAN LETTER HE..OLD SOUTH ARABIAN LETTER THETH
	{0x10A80, 0x10A9C, prOLetter}, // Lo  [29] OLD NORTH ARABIAN LETTER HEH..OLD NORTH ARABIAN LETTER ZAH
	{0x10AC0, 0x10AC7, prOLetter}, // Lo   [8] MANICHAEAN LETTER ALEPH..MANICHAEAN LETTER WAW
	{0x10AC9, 0x10AE4, prOLetter}, // Lo  [28] MANICHAEAN LETTER ZAYIN..MANICHAEAN LETTER TAW
	{0x10AE5, 0x10AE6, prExtend},  // Mn   [2] MANICHAEAN ABBREVIATION MARK ABOVE..MANICHAEAN ABBREVIATION MARK BELOW
	{0x10B00, 0x10B35, prOLetter}, // Lo  [54] AVESTAN LETTER A..AVESTAN LETTER HE
	{0x10B40, 0x10B55, prOLetter}, // Lo  [22] INSCRIPTIONAL PARTHIAN LETTER ALEPH..INSCRIPTIONAL PARTHIAN LETTER TAW
	{0x10B60, 0x10B72, prOLetter}, // Lo  [19] INSCRIPTIONAL PAHLAVI LETTER ALEPH..INSCRIPTIONAL PAHLAVI LETTER TAW
	{0x10B80, 0x10B91, prOLetter}, // Lo  [18] PSALTER PAHLAVI LETTER ALEPH..PSALTER PAHLAVI LETTER TAW
	{0x10C00, 0x10C48, prOLetter}, // Lo  [73] OLD TURKIC LETTER ORKHON A..OLD TURKIC LETTER ORKHON BASH
	{0x10C80, 0x10CB2, prUpper},   // L&  [51] OLD HUNGARIAN CAPITAL LETTER A..OLD HUNGARIAN CAPITAL LETTER US
	{0x10CC0, 0x10CF2, prLower},   // L&  [51] OLD HUNGARIAN SMALL LETTER A..OLD HUNGARIAN SMALL LETTER US
	{0x10D00, 0x10D23, prOLetter}, // Lo  [36] HANIFI ROHINGYA LETTER A..HANIFI ROHINGYA MARK NA KHONNA
	{0x10D24, 0x10D27, prExtend},  // Mn   [4] HANIFI ROHINGYA SIGN HARBAHAY..HANIFI ROHINGYA SIGN TASSI
	{0x10D30, 0x10D39, prNumeric}, // Nd  [10] HANIFI ROHINGYA DIGIT ZERO..HANIFI ROHINGYA DIGIT NINE
	{0x10E80, 0x10EA9, prOLetter}, // Lo  [42] YEZIDI LETTER ELIF..YEZIDI LETTER ET
	{0x10EAB, 0x10EAC, prExtend},  // Mn   [2] YEZIDI COMBINING HAMZA MARK..YEZIDI COMBINING MADDA MARK
	{0x10EB0, 0x10EB1, prOLetter}, // Lo   [2] YEZIDI LETTER LAM WITH DOT ABOVE..YEZIDI LETTER YOT WITH CIRCUMFLEX ABOVE
	{0x10F00, 0x10F1C, prOLetter}, // Lo  [29] OLD SOGDIAN LETTER ALEPH..OLD SOGDIAN LETTER FINAL TAW WITH VERTICAL TAIL
	{0x10F27, 0x10F27, prOLetter}, // Lo       OLD SOGDIAN LIGATURE AYIN-DALETH
	{0x10F30, 0x10F45, prOLetter}, // Lo  [22] SOGDIAN LETTER ALEPH..SOGDIAN INDEPENDENT SHIN
	{0x10F46, 0x10F50, prExtend},  // Mn  [11] SOGDIAN COMBINING DOT BELOW..SOGDIAN COMBINING STROKE BELOW
	{0x10F55, 0x10F59, prSTerm},   // Po   [5] SOGDIAN PUNCTUATION TWO VERTICAL BARS..SOGDIAN PUNCTUATION HALF CIRCLE WITH DOT
	{0x10F70, 0x10F81, prOLetter}, // Lo  [18] OLD UYGHUR LETTER ALEPH..OLD UYGHUR LETTER LESH
	{0x10F82, 0x10F85, prExtend},  // Mn   [4] OLD UYGHUR COMBINING DOT ABOVE..OLD UYGHUR COMBINING TWO DOTS BELOW
	{0x10F86, 0x10F89, prSTerm},   // Po   [4] OLD UYGHUR PUNCTUATION BAR..OLD UYGHUR PUNCTUATION FOUR DOTS
	{0x10FB0, 0x10FC4, prOLetter}, // Lo  [21] CHORASMIAN LETTER ALEPH..CHORASMIAN LETTER TAW
	{0x10FE0, 0x10FF6, prOLetter}, // Lo  [23] ELYMAIC LETTER ALEPH..ELYMAIC LIGATURE ZAYIN-YODH
	{0x11000, 0x11000, prExtend},  // Mc       BRAHMI SIGN CANDRABINDU
	{0x11001, 0x11001, prExtend},  // Mn       BRAHMI SIGN ANUSVARA
	{0x11002, 0x11002, prExtend},  // Mc       BRAHMI SIGN VISARGA
	{0x11003, 0x11037, prOLetter}, // Lo  [53] BRAHMI SIGN JIHVAMULIYA..BRAHMI LETTER OLD TAMIL NNNA
	{0x11038, 0x11046, prExtend},  // Mn  [15] BRAHMI VOWEL SIGN AA..BRAHMI VIRAMA
	{0x11047, 0x11048, prSTerm},   // Po   [2] BRAHMI DANDA..BRAHMI DOUBLE DANDA
	{0x11066, 0x1106F, prNumeric}, // Nd  [10] BRAHMI DIGIT ZERO..BRAHMI DIGIT NINE
	{0x11070, 0x11070, prExtend},  // Mn       BRAHMI SIGN OLD TAMIL VIRAMA
	{0x11071, 0x11072, prOLetter}, // Lo   [2] BRAHMI LETTER OLD TAMIL SHORT E..BRAHMI LETTER OLD TAMIL SHORT O
	{0x11073, 0x11074, prExtend},  // Mn   [2] BRAHMI VOWEL SIGN OLD TAMIL SHORT E..BRAHMI VOWEL SIGN OLD TAMIL SHORT O
	{0x11075, 0x11075, prOLetter}, // Lo       BRAHMI LETTER OLD TAMIL LLA
	{0x1107F, 0x11081, prExtend},  // Mn   [3] BRAHMI NUMBER JOINER..KAITHI SIGN ANUSVARA
	{0x11082, 0x11082, prExtend},  // Mc       KAITHI SIGN VISARGA
	{0x11083, 0x110AF, prOLetter}, // Lo  [45] KAITHI LETTER A..KAITHI LETTER HA
	{0x110B0, 0x110B2, prExtend},  // Mc   [3] KAITHI VOWEL SIGN AA..KAITHI VOWEL SIGN II
	{0x110B3, 0x110B6, prExtend},  // Mn   [4] KAITHI VOWEL SIGN U..KAITHI VOWEL SIGN AI
	{0x110B7, 0x110B8, prExtend},  // Mc   [2] KAITHI VOWEL SIGN O..KAITHI VOWEL SIGN AU
	{0x110B9, 0x110BA, prExtend},  // Mn   [2] KAITHI SIGN VIRAMA..KAITHI SIGN NUKTA
	{0x110BD, 0x110BD, prFormat},  // Cf       KAITHI NUMBER SIGN
	{0x110BE, 0x110C1, prSTerm},   // Po   [4] KAITHI SECTION MARK..KAITHI DOUBLE DANDA
	{0x110C2, 0x110C2, prExtend},  // Mn       KAITHI VOWEL SIGN VOCALIC R
	{0x110CD, 0x110CD, prFormat},  // Cf       KAITHI NUMBER SIGN ABOVE
	{0x110D0, 0x110E8, prOLetter}, // Lo  [25] SORA SOMPENG LETTER SAH..SORA SOMPENG LETTER MAE
	{0x110F0, 0x110F9, prNumeric}, // Nd  [10] SORA SOMPENG DIGIT ZERO..SORA SOMPENG DIGIT NINE
	{0x11100, 0x11102, prExtend},  // Mn   [3] CHAKMA SIGN CANDRABINDU..CHAKMA SIGN VISARGA
	{0x11103, 0x11126, prOLetter}, // Lo  [36] CHAKMA LETTER AA..CHAKMA LETTER HAA
	{0x11127, 0x1112B, prExtend},  // Mn   [5] CHAKMA VOWEL SIGN A..CHAKMA VOWEL SIGN UU
	{0x1112C, 0x1112C, prExtend},  // Mc       CHAKMA VOWEL SIGN E
	{0x1112D, 0x11134, prExtend},  // Mn   [8] CHAKMA VOWEL SIGN AI..CHAKMA MAAYYAA
	{0x11136, 0x1113F, prNumeric}, // Nd  [10] CHAKMA DIGIT ZERO..CHAKMA DIGIT NINE
	{0x11141, 0x11143, prSTerm},   // Po   [3] CHAKMA DANDA..CHAKMA QUESTION MARK
	{0x11144, 0x11144, prOLetter}, // Lo       CHAKMA LETTER LHAA
	{0x11145, 0x11146, prExtend},  // Mc   [2] CHAKMA VOWEL SIGN AA..CHAKMA VOWEL SIGN EI
	{0x11147, 0x11147, prOLetter}, // Lo       CHAKMA LETTER VAA
	{0x11150, 0x11172, prOLetter}, // Lo  [35] MAHAJANI LETTER A..MAHAJANI LETTER RRA
	{0x11173, 0x11173, prExtend},  // Mn       MAHAJANI SIGN NUKTA
	{0x11176, 0x11176, prOLetter}, // Lo       MAHAJANI LIGATURE SHRI
	{0x11180, 0x11181, prExtend},  // Mn   [2] SHARADA SIGN CANDRABINDU..SHARADA SIGN ANUSVARA
	{0x11182, 0x11182, prExtend},  // Mc       SHARADA SIGN VISARGA
	{0x11183, 0x111B2, prOLetter}, // Lo  [48] SHARADA LETTER A..SHARADA LETTER HA
	{0x111B3, 0x111B5, prExtend},  // Mc   [3] SHARADA VOWEL SIGN AA..SHARADA VOWEL SIGN II
	{0x111B6, 0x111BE, prExtend},  // Mn   [9] SHARADA VOWEL SIGN U..SHARADA VOWEL SIGN O
	{0x111BF, 0x111C0, prExtend},  // Mc   [2] SHARADA VOWEL SIGN AU..SHARADA SIGN VIRAMA
	{0x111C1, 0x111C4, prOLetter}, // Lo   [4] SHARADA SIGN AVAGRAHA..SHARADA OM
	{0x111C5, 0x111C6, prSTerm},   // Po   [2] SHARADA DANDA..SHARADA DOUBLE DANDA
	{0x111C9, 0x111CC, prExtend},  // Mn   [4] SHARADA SANDHI MARK..SHARADA EXTRA SHORT VOWEL MARK
	{0x111CD, 0x111CD, prSTerm},   // Po       SHARADA SUTRA MARK
	{0x111CE, 0x111CE, prExtend},  // Mc       SHARADA VOWEL SIGN PRISHTHAMATRA E
	{0x111CF, 0x111CF, prExtend},  // Mn       SHARADA SIGN INVERTED CANDRABINDU
	{0x111D0, 0x111D9, prNumeric}, // Nd  [10] SHARADA DIGIT ZERO..SHARADA DIGIT NINE
	{0x111DA, 0x111DA, prOLetter}, // Lo       SHARADA EKAM
	{0x111DC, 0x111DC, prOLetter}, // Lo       SHARADA HEADSTROKE
	{0x111DE, 0x111DF, prSTerm},   // Po   [2] SHARADA SECTION MARK-1..SHARADA SECTION MARK-2
	{0x11200, 0x11211, prOLetter}, // Lo  [18] KHOJKI LETTER A..KHOJKI LETTER JJA
	{0x11213, 0x1122B, prOLetter}, // Lo  [25] KHOJKI LETTER NYA..KHOJKI LETTER LLA
	{0x1122C, 0x1122E, prExtend},  // Mc   [3] KHOJKI VOWEL SIGN AA..KHOJKI VOWEL SIGN II
	{0x1122F, 0x11231, prExtend},  // Mn   [3] KHOJKI VOWEL SIGN U..KHOJKI VOWEL SIGN AI
	{0x11232, 0x11233, prExtend},  // Mc   [2] KHOJKI VOWEL SIGN O..KHOJKI VOWEL SIGN AU
	{0x11234, 0x11234, prExtend},  // Mn       KHOJKI SIGN ANUSVARA
	{0x11235, 0x11235, prExtend},  // Mc       KHOJKI SIGN VIRAMA
	{0x11236, 0x11237, prExtend},  // Mn   [2] KHOJKI SIGN NUKTA..KHOJKI SIGN SHADDA
	{0x11238, 0x11239, prSTerm},   // Po   [2] KHOJKI DANDA..KHOJKI DOUBLE DANDA
	{0x1123B, 0x1123C, prSTerm},   // Po   [2] KHOJKI SECTION MARK..KHOJKI DOUBLE SECTION MARK
	{0x1123E, 0x1123E, prExtend},  // Mn       KHOJKI SIGN SUKUN
	{0x11280, 0x11286, prOLetter}, // Lo   [7] MULTANI LETTER A..MULTANI LETTER GA
	{0x11288, 0x11288, prOLetter}, // Lo       MULTANI LETTER GHA
	{0x1128A, 0x1128D, prOLetter}, // Lo   [4] MULTANI LETTER CA..MULTANI LETTER JJA
	{0x1128F, 0x1129D, prOLetter}, // Lo  [15] MULTANI LETTER NYA..MULTANI LETTER BA
	{0x1129F, 0x112A8, prOLetter}, // Lo  [10] MULTANI LETTER BHA..MULTANI LETTER RHA
	{0x112A9, 0x112A9, prSTerm},   // Po       MULTANI SECTION MARK
	{0x112B0, 0x112DE, prOLetter}, // Lo  [47] KHUDAWADI LETTER A..KHUDAWADI LETTER HA
	{0x112DF, 0x112DF, prExtend},  // Mn       KHUDAWADI SIGN ANUSVARA
	{0x112E0, 0x112E2, prExtend},  // Mc   [3] KHUDAWADI VOWEL SIGN AA..KHUDAWADI VOWEL SIGN II
	{0x112E3, 0x112EA, prExtend},  // Mn   [8] KHUDAWADI VOWEL SIGN U..KHUDAWADI SIGN VIRAMA
	{0x112F0, 0x112F9, prNumeric}, // Nd  [10] KHUDAWADI DIGIT ZERO..KHUDAWADI DIGIT NINE
	{0x11300, 0x11301, prExtend},  // Mn   [2] GRANTHA SIGN COMBINING ANUSVARA ABOVE..GRANTHA SIGN CANDRABINDU
	{0x11302, 0x11303, prExtend},  // Mc   [2] GRANTHA SIGN ANUSVARA..GRANTHA SIGN VISARGA
	{0x11305, 0x1130C, prOLetter}, // Lo   [8] GRANTHA LETTER A..GRANTHA LETTER VOCALIC L
	{0x1130F, 0x11310, prOLetter}, // Lo   [2] GRANTHA LETTER EE..GRANTHA LETTER AI
	{0x11313, 0x11328, prOLetter}, // Lo  [22] GRANTHA LETTER OO..GRANTHA LETTER NA
	{0x1132A, 0x11330, prOLetter}, // Lo   [7] GRANTHA LETTER PA..GRANTHA LETTER RA
	{0x11332, 0x11333, prOLetter}, // Lo   [2] GRANTHA LETTER LA..GRANTHA LETTER LLA
	{0x11335, 0x11339, prOLetter}, // Lo   [5] GRANTHA LETTER VA..GRANTHA LETTER HA
	{0x1133B, 0x1133C, prExtend},  // Mn   [2] COMBINING BINDU BELOW..GRANTHA SIGN NUKTA
	{0x1133D, 0x1133D, prOLetter}, // Lo       GRANTHA SIGN AVAGRAHA
	{0x1133E, 0x1133F, prExtend},  // Mc   [2] GRANTHA VOWEL SIGN AA..GRANTHA VOWEL SIGN I
	{0x11340, 0x11340, prExtend},  // Mn       GRANTHA VOWEL SIGN II
	{0x11341, 0x11344, prExtend},  // Mc   [4] GRANTHA VOWEL SIGN U..GRANTHA VOWEL SIGN VOCALIC RR
	{0x11347, 0x11348, prExtend},  // Mc   [2] GRANTHA VOWEL SIGN EE..GRANTHA VOWEL SIGN AI
	{0x1134B, 0x1134D, prExtend},  // Mc   [3] GRANTHA VOWEL SIGN OO..GRANTHA SIGN VIRAMA
	{0x11350, 0x11350, prOLetter}, // Lo       GRANTHA OM
	{0x11357, 0x11357, prExtend},  // Mc       GRANTHA AU LENGTH MARK
	{0x1135D, 0x11361, prOLetter}, // Lo   [5] GRANTHA SIGN PLUTA..GRANTHA LETTER VOCALIC LL
	{0x11362, 0x11363, prExtend},  // Mc   [2] GRANTHA VOWEL SIGN VOCALIC L..GRANTHA VOWEL SIGN VOCALIC LL
	{0x11366, 0x1136C, prExtend},  // Mn   [7] COMBINING GRANTHA DIGIT ZERO..COMBINING GRANTHA DIGIT SIX
	{0x11370, 0x11374, prExtend},  // Mn   [5] COMBINING GRANTHA LETTER A..COMBINING GRANTHA LETTER PA
	{0x11400, 0x11434, prOLetter}, // Lo  [53] NEWA LETTER A..NEWA LETTER HA
	{0x11435, 0x11437, prExtend},  // Mc   [3] NEWA VOWEL SIGN AA..NEWA VOWEL SIGN II
	{0x11438, 0x1143F, prExtend},  // Mn   [8] NEWA VOWEL SIGN U..NEWA VOWEL SIGN AI
	{0x11440, 0x11441, prExtend},  // Mc   [2] NEWA VOWEL SIGN O..NEWA VOWEL SIGN AU
	{0x11442, 0x11444, prExtend},  // Mn   [3] NEWA SIGN VIRAMA..NEWA SIGN ANUSVARA
	{0x11445, 0x11445, prExtend},  // Mc       NEWA SIGN VISARGA
	{0x11446, 0x11446, prExtend},  // Mn       NEWA SIGN NUKTA
	{0x11447, 0x1144A, prOLetter}, // Lo   [4] NEWA SIGN AVAGRAHA..NEWA SIDDHI
	{0x1144B, 0x1144C, prSTerm},   // Po   [2] NEWA DANDA..NEWA DOUBLE DANDA
	{0x11450, 0x11459, prNumeric}, // Nd  [10] NEWA DIGIT ZERO..NEWA DIGIT NINE
	{0x1145E, 0x1145E, prExtend},  // Mn       NEWA SANDHI MARK
	{0x1145F, 0x11461, prOLetter}, // Lo   [3] NEWA LETTER VEDIC ANUSVARA..NEWA SIGN UPADHMANIYA
	{0x11480, 0x114AF, prOLetter}, // Lo  [48] TIRHUTA ANJI..TIRHUTA LETTER HA
	{0x114B0, 0x114B2, prExtend},  // Mc   [3] TIRHUTA VOWEL SIGN AA..TIRHUTA VOWEL SIGN II
	{0x114B3, 0x114B8, prExtend},  // Mn   [6] TIRHUTA VOWEL SIGN U..TIRHUTA VOWEL SIGN VOCALIC LL
	{0x114B9, 0x114B9, prExtend},  // Mc       TIRHUTA VOWEL SIGN E
	{0x114BA, 0x114BA, prExtend},  // Mn       TIRHUTA VOWEL SIGN SHORT E
	{0x114BB, 0x114BE, prExtend},  // Mc   [4] TIRHUTA VOWEL SIGN AI..TIRHUTA VOWEL SIGN AU
	{0x114BF, 0x114C0, prExtend},  // Mn   [2] TIRHUTA SIGN CANDRABINDU..TIRHUTA SIGN ANUSVARA
	{0x114C1, 0x114C1, prExtend},  // Mc       TIRHUTA SIGN VISARGA
	{0x114C2, 0x114C3, prExtend},  // Mn   [2] TIRHUTA SIGN VIRAMA..TIRHUTA SIGN NUKTA
	{0x114C4, 0x114C5, prOLetter}, // Lo   [2] TIRHUTA SIGN AVAGRAHA..TIRHUTA GVANG
	{0x114C7, 0x114C7, prOLetter}, // Lo       TIRHUTA OM
	{0x114D0, 0x114D9, prNumeric}, // Nd  [10] TIRHUTA DIGIT ZERO..TIRHUTA DIGIT NINE
	{0x11580, 0x115AE, prOLetter}, // Lo  [47] SIDDHAM LETTER A..SIDDHAM LETTER HA
	{0x115AF, 0x115B1, prExtend},  // Mc   [3] SIDDHAM VOWEL SIGN AA..SIDDHAM VOWEL SIGN II
	{0x115B2, 0x115B5, prExtend},  // Mn   [4] SIDDHAM VOWEL SIGN U..SIDDHAM VOWEL SIGN VOCALIC RR
	{0x115B8, 0x115BB, prExtend},  // Mc   [4] SIDDHAM VOWEL SIGN E..SIDDHAM VOWEL SIGN AU
	{0x115BC, 0x115BD, prExtend},  // Mn   [2] SIDDHAM SIGN CANDRABINDU..SIDDHAM SIGN ANUSVARA
	{0x115BE, 0x115BE, prExtend},  // Mc       SIDDHAM SIGN VISARGA
	{0x115BF, 0x115C0, prExtend},  // Mn   [2] SIDDHAM SIGN VIRAMA..SIDDHAM SIGN NUKTA
	{0x115C2, 0x115C3, prSTerm},   // Po   [2] SIDDHAM DANDA..SIDDHAM DOUBLE DANDA
	{0x115C9, 0x115D7, prSTerm},   // Po  [15] SIDDHAM END OF TEXT MARK..SIDDHAM SECTION MARK WITH CIRCLES AND FOUR ENCLOSURES
	{0x115D8, 0x115DB, prOLetter}, // Lo   [4] SIDDHAM LETTER THREE-CIRCLE ALTERNATE I..SIDDHAM LETTER ALTERNATE U
	{0x115DC, 0x115DD, prExtend},  // Mn   [2] SIDDHAM VOWEL SIGN ALTERNATE U..SIDDHAM VOWEL SIGN ALTERNATE UU
	{0x11600, 0x1162F, prOLetter}, // Lo  [48] MODI LETTER A..MODI LETTER LLA
	{0x11630, 0x11632, prExtend},  // Mc   [3] MODI VOWEL SIGN AA..MODI VOWEL SIGN II
	{0x11633, 0x1163A, prExtend},  // Mn   [8] MODI VOWEL SIGN U..MODI VOWEL SIGN AI
	{0x1163B, 0x1163C, prExtend},  // Mc   [2] MODI VOWEL SIGN O..MODI VOWEL SIGN AU
	{0x1163D, 0x1163D, prExtend},  // Mn       MODI SIGN ANUSVARA
	{0x1163E, 0x1163E, prExtend},  // Mc       MODI SIGN VISARGA
	{0x1163F, 0x11640, prExtend},  // Mn   [2] MODI SIGN VIRAMA..MODI SIGN ARDHACANDRA
	{0x11641, 0x11642, prSTerm},   // Po   [2] MODI DANDA..MODI DOUBLE DANDA
	{0x11644, 0x11644, prOLetter}, // Lo       MODI SIGN HUVA
	{0x11650, 0x11659, prNumeric}, // Nd  [10] MODI DIGIT ZERO..MODI DIGIT NINE
	{0x11680, 0x116AA, prOLetter}, // Lo  [43] TAKRI LETTER A..TAKRI LETTER RRA
	{0x116AB, 0x116AB, prExtend},  // Mn       TAKRI SIGN ANUSVARA
	{0x116AC, 0x116AC, prExtend},  // Mc       TAKRI SIGN VISARGA
	{0x116AD, 0x116AD, prExtend},  // Mn       TAKRI VOWEL SIGN AA
	{0x116AE, 0x116AF, prExtend},  // Mc   [2] TAKRI VOWEL SIGN I..TAKRI VOWEL SIGN II
	{0x116B0, 0x116B5, prExtend},  // Mn   [6] TAKRI VOWEL SIGN U..TAKRI VOWEL SIGN AU
	{0x116B6, 0x116B6, prExtend},  // Mc       TAKRI SIGN VIRAMA
	{0x116B7, 0x116B7, prExtend},  // Mn       TAKRI SIGN NUKTA
	{0x116B8, 0x116B8, prOLetter}, // Lo       TAKRI LETTER ARCHAIC KHA
	{0x116C0, 0x116C9, prNumeric}, // Nd  [10] TAKRI DIGIT ZERO..TAKRI DIGIT NINE
	{0x11700, 0x1171A, prOLetter}, // Lo  [27] AHOM LETTER KA..AHOM LETTER ALTERNATE BA
	{0x1171D, 0x1171F, prExtend},  // Mn   [3] AHOM CONSONANT SIGN MEDIAL LA..AHOM CONSONANT SIGN MEDIAL LIGATING RA
	{0x11720, 0x11721, prExtend},  // Mc   [2] AHOM VOWEL SIGN A..AHOM VOWEL SIGN AA
	{0x11722, 0x11725, prExtend},  // Mn   [4] AHOM VOWEL SIGN I..AHOM VOWEL SIGN UU
	{0x11726, 0x11726, prExtend},  // Mc       AHOM VOWEL SIGN E
	{0x11727, 0x1172B, prExtend},  // Mn   [5] AHOM VOWEL SIGN AW..AHOM SIGN KILLER
	{0x11730, 0x11739, prNumeric}, // Nd  [10] AHOM DIGIT ZERO..AHOM DIGIT NINE
	{0x1173C, 0x1173E, prSTerm},   // Po   [3] AHOM SIGN SMALL SECTION..AHOM SIGN RULAI
	{0x11740, 0x11746, prOLetter}, // Lo   [7] AHOM LETTER CA..AHOM LETTER LLA
	{0x11800, 0x1182B, prOLetter}, // Lo  [44] DOGRA LETTER A..DOGRA LETTER RRA
	{0x1182C, 0x1182E, prExtend},  // Mc   [3] DOGRA VOWEL SIGN AA..DOGRA VOWEL SIGN II
	{0x1182F, 0x11837, prExtend},  // Mn   [9] DOGRA VOWEL SIGN U..DOGRA SIGN ANUSVARA
	{0x11838, 0x11838, prExtend},  // Mc       DOGRA SIGN VISARGA
	{0x11839, 0x1183A, prExtend},  // Mn   [2] DOGRA SIGN VIRAMA..DOGRA SIGN NUKTA
	{0x118A0, 0x118BF, prUpper},   // L&  [32] WARANG CITI CAPITAL LETTER NGAA..WARANG CITI CAPITAL LETTER VIYO
	{0x118C0, 0x118DF, prLower},   // L&  [32] WARANG CITI SMALL LETTER NGAA..WARANG CITI SMALL LETTER VIYO
	{0x118E0, 0x118E9, prNumeric}, // Nd  [10] WARANG CITI DIGIT ZERO..WARANG CITI DIGIT NINE
	{0x118FF, 0x11906, prOLetter}, // Lo   [8] WARANG CITI OM..DIVES AKURU LETTER E
	{0x11909, 0x11909, prOLetter}, // Lo       DIVES AKURU LETTER O
	{0x1190C, 0x11913, prOLetter}, // Lo   [8] DIVES AKURU LETTER KA..DIVES AKURU LETTER JA
	{0x11915, 0x11916, prOLetter}, // Lo   [2] DIVES AKURU LETTER NYA..DIVES AKURU LETTER TTA
	{0x11918, 0x1192F, prOLetter}, // Lo  [24] DIVES AKURU LETTER DDA..DIVES AKURU LETTER ZA
	{0x11930, 0x11935, prExtend},  // Mc   [6] DIVES AKURU VOWEL SIGN AA..DIVES AKURU VOWEL SIGN E
	{0x11937, 0x11938, prExtend},  // Mc   [2] DIVES AKURU VOWEL SIGN AI..DIVES AKURU VOWEL SIGN O
	{0x1193B, 0x1193C, prExtend},  // Mn   [2] DIVES AKURU SIGN ANUSVARA..DIVES AKURU SIGN CANDRABINDU
	{0x1193D, 0x1193D, prExtend},  // Mc       DIVES AKURU SIGN HALANTA
	{0x1193E, 0x1193E, prExtend},  // Mn       DIVES AKURU VIRAMA
	{0x1193F, 0x1193F, prOLetter}, // Lo       DIVES AKURU PREFIXED NASAL SIGN
	{0x11940, 0x11940, prExtend},  // Mc       DIVES AKURU MEDIAL YA
	{0x11941, 0x11941, prOLetter}, // Lo       DIVES AKURU INITIAL RA
	{0x11942, 0x11942, prExtend},  // Mc       DIVES AKURU MEDIAL RA
	{0x11943, 0x11943, prExtend},  // Mn       DIVES AKURU SIGN NUKTA
	{0x11944, 0x11944, prSTerm},   // Po       DIVES AKURU DOUBLE DANDA
	{0x11946, 0x11946, prSTerm},   // Po       DIVES AKURU END OF TEXT MARK
	{0x11950, 0x11959, prNumeric}, // Nd  [10] DIVES AKURU DIGIT ZERO..DIVES AKURU DIGIT NINE
	{0x119A0, 0x119A7, prOLetter}, // Lo   [8] NANDINAGARI LETTER A..NANDINAGARI LETTER VOCALIC RR
	{0x119AA, 0x119D0, prOLetter}, // Lo  [39] NANDINAGARI LETTER E..NANDINAGARI LETTER RRA
	{0x119D1, 0x119D3, prExtend},  // Mc   [3] NANDINAGARI VOWEL SIGN AA..NANDINAGARI VOWEL SIGN II
	{0x119D4, 0x119D7, prExtend},  // Mn   [4] NANDINAGARI VOWEL SIGN U..NANDINAGARI VOWEL SIGN VOCALIC RR
	{0x119DA, 0x119DB, prExtend},  // Mn   [2] NANDINAGARI VOWEL SIGN E..NANDINAGARI VOWEL SIGN AI
	{0x119DC, 0x119DF, prExtend},  // Mc   [4] NANDINAGARI VOWEL SIGN O..NANDINAGARI SIGN VISARGA
	{0x119E0, 0x119E0, prExtend},  // Mn       NANDINAGARI SIGN VIRAMA
	{0x119E1, 0x119E1, prOLetter}, // Lo       NANDINAGARI SIGN AVAGRAHA
	{0x119E3, 0x119E3, prOLetter}, // Lo       NANDINAGARI HEADSTROKE
	{0x119E4, 0x119E4, prExtend},  // Mc       NANDINAGARI VOWEL SIGN PRISHTHAMATRA E
	{0x11A00, 0x11A00, prOLetter}, // Lo       ZANABAZAR SQUARE LETTER A
	{0x11A01, 0x11A0A, prExtend},  // Mn  [10] ZANABAZAR SQUARE VOWEL SIGN I..ZANABAZAR SQUARE VOWEL LENGTH MARK
	{0x11A0B, 0x11A32, prOLetter}, // Lo  [40] ZANABAZAR SQUARE LETTER KA..ZANABAZAR SQUARE LETTER KSSA
	{0x11A33, 0x11A38, prExtend},  // Mn   [6] ZANABAZAR SQUARE FINAL CONSONANT MARK..ZANABAZAR SQUARE SIGN ANUSVARA
	{0x11A39, 0x11A39, prExtend},  // Mc       ZANABAZAR SQUARE SIGN VISARGA
	{0x11A3A, 0x11A3A, prOLetter}, // Lo       ZANABAZAR SQUARE CLUSTER-INITIAL LETTER RA
	{0x11A3B, 0x11A3E, prExtend},  // Mn   [4] ZANABAZAR SQUARE CLUSTER-FINAL LETTER YA..ZANABAZAR SQUARE CLUSTER-FINAL LETTER VA
	{0x11A42, 0x11A43, prSTerm},   // Po   [2] ZANABAZAR SQUARE MARK SHAD..ZANABAZAR SQUARE MARK DOUBLE SHAD
	{0x11A47, 0x11A47, prExtend},  // Mn       ZANABAZAR SQUARE SUBJOINER
	{0x11A50, 0x11A50, prOLetter}, // Lo       SOYOMBO LETTER A
	{0x11A51, 0x11A56, prExtend},  // Mn   [6] SOYOMBO VOWEL SIGN I..SOYOMBO VOWEL SIGN OE
	{0x11A57, 0x11A58, prExtend},  // Mc   [2] SOYOMBO VOWEL SIGN AI..SOYOMBO VOWEL SIGN AU
	{0x11A59, 0x11A5B, prExtend},  // Mn   [3] SOYOMBO VOWEL SIGN VOCALIC R..SOYOMBO VOWEL LENGTH MARK
	{0x11A5C, 0x11A89, prOLetter}, // Lo  [46] SOYOMBO LETTER KA..SOYOMBO CLUSTER-INITIAL LETTER SA
	{0x11A8A, 0x11A96, prExtend},  // Mn  [13] SOYOMBO FINAL CONSONANT SIGN G..SOYOMBO SIGN ANUSVARA
	{0x11A97, 0x11A97, prExtend},  // Mc       SOYOMBO SIGN VISARGA
	{0x11A98, 0x11A99, prExtend},  // Mn   [2] SOYOMBO GEMINATION MARK..SOYOMBO SUBJOINER
	{0x11A9B, 0x11A9C, prSTerm},   // Po   [2] SOYOMBO MARK SHAD..SOYOMBO MARK DOUBLE SHAD
	{0x11A9D, 0x11A9D, prOLetter}, // Lo       SOYOMBO MARK PLUTA
	{0x11AB0, 0x11AF8, prOLetter}, // Lo  [73] CANADIAN SYLLABICS NATTILIK HI..PAU CIN HAU GLOTTAL STOP FINAL
	{0x11C00, 0x11C08, prOLetter}, // Lo   [9] BHAIKSUKI LETTER A..BHAIKSUKI LETTER VOCALIC L
	{0x11C0A, 0x11C2E, prOLetter}, // Lo  [37] BHAIKSUKI LETTER E..BHAIKSUKI LETTER HA
	{0x11C2F, 0x11C2F, prExtend},  // Mc       BHAIKSUKI VOWEL SIGN AA
	{0x11C30, 0x11C36, prExtend},  // Mn   [7] BHAIKSUKI VOWEL SIGN I..BHAIKSUKI VOWEL SIGN VOCALIC L
	{0x11C38, 0x11C3D, prExtend},  // Mn   [6] BHAIKSUKI VOWEL SIGN E..BHAIKSUKI SIGN ANUSVARA
	{0x11C3E, 0x11C3E, prExtend},  // Mc       BHAIKSUKI SIGN VISARGA
	{0x11C3F, 0x11C3F, prExtend},  // Mn       BHAIKSUKI SIGN VIRAMA
	{0x11C40, 0x11C40, prOLetter}, // Lo       BHAIKSUKI SIGN AVAGRAHA
	{0x11C41, 0x11C42, prSTerm},   // Po   [2] BHAIKSUKI DANDA..BHAIKSUKI DOUBLE DANDA
	{0x11C50, 0x11C59, prNumeric}, // Nd  [10] BHAIKSUKI DIGIT ZERO..BHAIKSUKI DIGIT NINE
	{0x11C72, 0x11C8F, prOLetter}, // Lo  [30] MARCHEN LETTER KA..MARCHEN LETTER A
	{0x11C92, 0x11CA7, prExtend},  // Mn  [22] MARCHEN SUBJOINED LETTER KA..MARCHEN SUBJOINED LETTER ZA
	{0x11CA9, 0x11CA9, prExtend},  // Mc       MARCHEN SUBJOINED LETTER YA
	{0x11CAA, 0x11CB0, prExtend},  // Mn   [7] MARCHEN SUBJOINED LETTER RA..MARCHEN VOWEL SIGN AA
	{0x11CB1, 0x11CB1, prExtend},  // Mc       MARCHEN VOWEL SIGN I
	{0x11CB2, 0x11CB3, prExtend},  // Mn   [2] MARCHEN VOWEL SIGN U..MARCHEN VOWEL SIGN E
	{0x11CB4, 0x11CB4, prExtend},  // Mc       MARCHEN VOWEL SIGN O
	{0x11CB5, 0x11CB6, prExtend},  // Mn   [2] MARCHEN SIGN ANUSVARA..MARCHEN SIGN CANDRABINDU
	{0x11D00, 0x11D06, prOLetter}, // Lo   [7] MASARAM GONDI LETTER A..MASARAM GONDI LETTER E
	{0x11D08, 0x11D09, prOLetter}, // Lo   [2] MASARAM GONDI LETTER AI..MASARAM GONDI LETTER O
	{0x11D0B, 0x11D30, prOLetter}, // Lo  [38] MASARAM GONDI LETTER AU..MASARAM GONDI LETTER TRA
	{0x11D31, 0x11D36, prExtend},  // Mn   [6] MASARAM GONDI VOWEL SIGN AA..MASARAM GONDI VOWEL SIGN VOCALIC R
	{0x11D3A, 0x11D3A, prExtend},  // Mn       MASARAM GONDI VOWEL SIGN E
	{0x11D3C, 0x11D3D, prExtend},  // Mn   [2] MASARAM GONDI VOWEL SIGN AI..MASARAM GONDI VOWEL SIGN O
	{0x11D3F, 0x11D45, prExtend},  // Mn   [7] MASARAM GONDI VOWEL SIGN AU..MASARAM GONDI VIRAMA
	{0x11D46, 0x11D46, prOLetter}, // Lo       MASARAM GONDI REPHA
	{0x11D47, 0x11D47, prExtend},  // Mn       MASARAM GONDI RA-KARA
	{0x11D50, 0x11D59, prNumeric}, // Nd  [10] MASARAM GONDI DIGIT ZERO..MASARAM GONDI DIGIT NINE
	{0x11D60, 0x11D65, prOLetter}, // Lo   [6] GUNJALA GONDI LETTER A..GUNJALA GONDI LETTER UU
	{0x11D67, 0x11D68, prOLetter}, // Lo   [2] GUNJALA GONDI LETTER EE..GUNJALA GONDI LETTER AI
	{0x11D6A, 0x11D89, prOLetter}, // Lo  [32] GUNJALA GONDI LETTER OO..GUNJALA GONDI LETTER SA
	{0x11D8A, 0x11D8E, prExtend},  // Mc   [5] GUNJALA GONDI VOWEL SIGN AA..GUNJALA GONDI VOWEL SIGN UU
	{0x11D90, 0x11D91, prExtend},  // Mn   [2] GUNJALA GONDI VOWEL SIGN EE..GUNJALA GONDI VOWEL SIGN AI
	{0x11D93, 0x11D94, prExtend},  // Mc   [2] GUNJALA GONDI VOWEL SIGN OO..GUNJALA GONDI VOWEL SIGN AU
	{0x11D95, 0x11D95, prExtend},  // Mn       GUNJALA GONDI SIGN ANUSVARA
	{0x11D96, 0x11D96, prExtend},  // Mc       GUNJALA GONDI SIGN VISARGA
	{0x11D97, 0x11D97, prExtend},  // Mn       GUNJALA GONDI VIRAMA
	{0x11D98, 0x11D98, prOLetter}, // Lo       GUNJALA GONDI OM
	{0x11DA0, 0x11DA9, prNumeric}, // Nd  [10] GUNJALA GONDI DIGIT ZERO..GUNJALA GONDI DIGIT NINE
	{0x11EE0, 0x11EF2, prOLetter}, // Lo  [19] MAKASAR LETTER KA..MAKASAR ANGKA
	{0x11EF3, 0x11EF4, prExtend},  // Mn   [2] MAKASAR VOWEL SIGN I..MAKASAR VOWEL SIGN U
	{0x11EF5, 0x11EF6, prExtend},  // Mc   [2] MAKASAR VOWEL SIGN E..MAKASAR VOWEL SIGN O
	{0x11EF7, 0x11EF8, prSTerm},   // Po   [2] MAKASAR PASSIMBANG..MAKASAR END OF SECTION
	{0x11FB0, 0x11FB0, prOLetter}, // Lo       LISU LETTER YHA
	{0x12000, 0x12399, prOLetter}, // Lo [922] CUNEIFORM SIGN A..CUNEIFORM SIGN U U
	{0x12400, 0x1246E, prOLetter}, // Nl [111] CUNEIFORM NUMERIC SIGN TWO ASH..CUNEIFORM NUMERIC SIGN NINE U VARIANT FORM
	{0x12480, 0x12543, prOLetter}, // Lo [196] CUNEIFORM SIGN AB TIMES NUN TENU..CUNEIFORM SIGN ZU5 TIMES THREE DISH TENU
	{0x12F90, 0x12FF0, prOLetter}, // Lo  [97] CYPRO-MINOAN SIGN CM001..CYPRO-MINOAN SIGN CM114
	{0x13000, 0x1342E, prOLetter}, // Lo [1071] EGYPTIAN HIEROGLYPH A001..EGYPTIAN HIEROGLYPH AA032
	{0x13430, 0x13438, prFormat},  // Cf   [9] EGYPTIAN HIEROGLYPH VERTICAL JOINER..EGYPTIAN HIEROGLYPH END SEGMENT
	{0x14400, 0x14646, prOLetter}, // Lo [583] ANATOLIAN HIEROGLYPH A001..ANATOLIAN HIEROGLYPH A530
	{0x16800, 0x16A38, prOLetter}, // Lo [569] BAMUM LETTER PHASE-A NGKUE MFON..BAMUM LETTER PHASE-F VUEQ
	{0x16A40, 0x16A5E, prOLetter}, // Lo  [31] MRO LETTER TA..MRO LETTER TEK
	{0x16A60, 0x16A69, prNumeric}, // Nd  [10] MRO DIGIT ZERO..MRO DIGIT NINE
	{0x16A6E, 0x16A6F, prSTerm},   // Po   [2] MRO DANDA..MRO DOUBLE DANDA
	{0x16A70, 0x16ABE, prOLetter}, // Lo  [79] TANGSA LETTER OZ..TANGSA LETTER ZA
	{0x16AC0, 0x16AC9, prNumeric}, // Nd  [10] TANGSA DIGIT ZERO..TANGSA DIGIT NINE
	{0x16AD0, 0x16AED, prOLetter}, // Lo  [30] BASSA VAH LETTER ENNI..BASSA VAH LETTER I
	{0x16AF0, 0x16AF4, prExtend},  // Mn   [5] BASSA VAH COMBINING HIGH TONE..BASSA VAH COMBINING HIGH-LOW TONE
	{0x16AF5, 0x16AF5, prSTerm},   // Po       BASSA VAH FULL STOP
	{0x16B00, 0x16B2F, prOLetter}, // Lo  [48] PAHAWH HMONG VOWEL KEEB..PAHAWH HMONG CONSONANT CAU
	{0x16B30, 0x16B36, prExtend},  // Mn   [7] PAHAWH HMONG MARK CIM TUB..PAHAWH HMONG MARK CIM TAUM
	{0x16B37, 0x16B38, prSTerm},   // Po   [2] PAHAWH HMONG SIGN VOS THOM..PAHAWH HMONG SIGN VOS TSHAB CEEB
	{0x16B40, 0x16B43, prOLetter}, // Lm   [4] PAHAWH HMONG SIGN VOS SEEV..PAHAWH HMONG SIGN IB YAM
	{0x16B44, 0x16B44, prSTerm},   // Po       PAHAWH HMONG SIGN XAUS
	{0x16B50, 0x16B59, prNumeric}, // Nd  [10] PAHAWH HMONG DIGIT ZERO..PAHAWH HMONG DIGIT NINE
	{0x16B63, 0x16B77, prOLetter}, // Lo  [21] PAHAWH HMONG SIGN VOS LUB..PAHAWH HMONG SIGN CIM NRES TOS
	{0x16B7D, 0x16B8F, prOLetter}, // Lo  [19] PAHAWH HMONG CLAN SIGN TSHEEJ..PAHAWH HMONG CLAN SIGN VWJ
	{0x16E40, 0x16E5F, prUpper},   // L&  [32] MEDEFAIDRIN CAPITAL LETTER M..MEDEFAIDRIN CAPITAL LETTER Y
	{0x16E60, 0x16E7F, prLower},   // L&  [32] MEDEFAIDRIN SMALL LETTER M..MEDEFAIDRIN SMALL LETTER Y
	{0x16E98, 0x16E98, prSTerm},   // Po       MEDEFAIDRIN FULL STOP
	{0x16F00, 0x16F4A, prOLetter}, // Lo  [75] MIAO LETTER PA..MIAO LETTER RTE
	{0x16F4F, 0x16F4F, prExtend},  // Mn       MIAO SIGN CONSONANT MODIFIER BAR
	{0x16F50, 0x16F50, prOLetter}, // Lo       MIAO LETTER NASALIZATION
	{0x16F51, 0x16F87, prExtend},  // Mc  [55] MIAO SIGN ASPIRATION..MIAO VOWEL SIGN UI
	{0x16F8F, 0x16F92, prExtend},  // Mn   [4] MIAO TONE RIGHT..MIAO TONE BELOW
	{0x16F93, 0x16F9F, prOLetter}, // Lm  [13] MIAO LETTER TONE-2..MIAO LETTER REFORMED TONE-8
	{0x16FE0, 0x16FE1, prOLetter}, // Lm   [2] TANGUT ITERATION MARK..NUSHU ITERATION MARK
	{0x16FE3, 0x16FE3, prOLetter}, // Lm       OLD CHINESE ITERATION MARK
	{0x16FE4, 0x16FE4, prExtend},  // Mn       KHITAN SMALL SCRIPT FILLER
	{0x16FF0, 0x16FF1, prExtend},  // Mc   [2] VIETNAMESE ALTERNATE READING MARK CA..VIETNAMESE ALTERNATE READING MARK NHAY
	{0x17000, 0x187F7, prOLetter}, // Lo [6136] TANGUT IDEOGRAPH-17000..TANGUT IDEOGRAPH-187F7
	{0x18800, 0x18CD5, prOLetter}, // Lo [1238] TANGUT COMPONENT-001..KHITAN SMALL SCRIPT CHARACTER-18CD5
	{0x18D00, 0x18D08, prOLetter}, // Lo   [9] TANGUT IDEOGRAPH-18D00..TANGUT IDEOGRAPH-18D08
	{0x1AFF0, 0x1AFF3, prOLetter}, // Lm   [4] KATAKANA LETTER MINNAN TONE-2..KATAKANA LETTER MINNAN TONE-5
	{0x1AFF5, 0x1AFFB, prOLetter}, // Lm   [7] KATAKANA LETTER MINNAN TONE-7..KATAKANA LETTER MINNAN NASALIZED TONE-5
	{0x1AFFD, 0x1AFFE, prOLetter}, // Lm   [2] KATAKANA LETTER MINNAN NASALIZED TONE-7..KATAKANA LETTER MINNAN NASALIZED TONE-8
	{0x1B000, 0x1B122, prOLetter}, // Lo [291] KATAKANA LETTER ARCHAIC E..KATAKANA LETTER ARCHAIC WU
	{0x1B150, 0x1B152, prOLetter}, // Lo   [3] HIRAGANA LETTER SMALL WI..HIRAGANA LETTER SMALL WO
	{0x1B164, 0x1B167, prOLetter}, // Lo   [4] KATAKANA LETTER SMALL WI..KATAKANA LETTER SMALL N
	{0x1B170, 0x1B2FB, prOLetter}, // Lo [396] NUSHU CHARACTER-1B170..NUSHU CHARACTER-1B2FB
	{0x1BC00, 0x1BC6A, prOLetter}, // Lo [107] DUPLOYAN LETTER H..DUPLOYAN LETTER VOCALIC M
	{0x1BC70, 0x1BC7C, prOLetter}, // Lo  [13] DUPLOYAN AFFIX LEFT HORIZONTAL SECANT..DUPLOYAN AFFIX ATTACHED TANGENT HOOK
	{0x1BC80, 0x1BC88, prOLetter}, // Lo   [9] DUPLOYAN AFFIX HIGH ACUTE..DUPLOYAN AFFIX HIGH VERTICAL
	{0x1BC90, 0x1BC99, prOLetter}, // Lo  [10] DUPLOYAN AFFIX LOW ACUTE..DUPLOYAN AFFIX LOW ARROW
	{0x1BC9D, 0x1BC9E, prExtend},  // Mn   [2] DUPLOYAN THICK LETTER SELECTOR..DUPLOYAN DOUBLE MARK
	{0x1BC9F, 0x1BC9F, prSTerm},   // Po       DUPLOYAN PUNCTUATION CHINOOK FULL STOP
	{0x1BCA0, 0x1BCA3, prFormat},  // Cf   [4] SHORTHAND FORMAT LETTER OVERLAP..SHORTHAND FORMAT UP STEP
	{0x1CF00, 0x1CF2D, prExtend},  // Mn  [46] ZNAMENNY COMBINING MARK GORAZDO NIZKO S KRYZHEM ON LEFT..ZNAMENNY COMBINING MARK KRYZH ON LEFT
	{0x1CF30, 0x1CF46, prExtend},  // Mn  [23] ZNAMENNY COMBINING TONAL RANGE MARK MRACHNO..ZNAMENNY PRIZNAK MODIFIER ROG
	{0x1D165, 0x1D166, prExtend},  // Mc   [2] MUSICAL SYMBOL COMBINING STEM..MUSICAL SYMBOL COMBINING SPRECHGESANG STEM
	{0x1D167, 0x1D169, prExtend},  // Mn   [3] MUSICAL SYMBOL COMBINING TREMOLO-1..MUSICAL SYMBOL COMBINING TREMOLO-3
	{0x1D16D, 0x1D172, prExtend},  // Mc   [6] MUSICAL SYMBOL COMBINING AUGMENTATION DOT..MUSICAL SYMBOL COMBINING FLAG-5
	{0x1D173, 0x1D17A, prFormat},  // Cf   [8] MUSICAL SYMBOL BEGIN BEAM..MUSICAL SYMBOL END PHRASE
	{0x1D17B, 0x1D182, prExtend},  // Mn   [8] MUSICAL SYMBOL COMBINING ACCENT..MUSICAL SYMBOL COMBINING LOURE
	{0x1D185, 0x1D18B, prExtend},  // Mn   [7] MUSICAL SYMBOL COMBINING DOIT..MUSICAL SYMBOL COMBINING TRIPLE TONGUE
	{0x1D1AA, 0x1D1AD, prExtend},  // Mn   [4] MUSICAL SYMBOL COMBINING DOWN BOW..MUSICAL SYMBOL COMBINING SNAP PIZZICATO
	{0x1D242, 0x1D244, prExtend},  // Mn   [3] COMBINING GREEK MUSICAL TRISEME..COMBINING GREEK MUSICAL PENTASEME
	{0x1D400, 0x1D419, prUpper},   // L&  [26] MATHEMATICAL BOLD CAPITAL A..MATHEMATICAL BOLD CAPITAL Z
	{0x1D41A, 0x1D433, prLower},   // L&  [26] MATHEMATICAL BOLD SMALL A..MATHEMATICAL BOLD SMALL Z
	{0x1D434, 0x1D44D, prUpper},   // L&  [26] MATHEMATICAL ITALIC CAPITAL A..MATHEMATICAL ITALIC CAPITAL Z
	{0x1D44E, 0x1D454, prLower},   // L&   [7] MATHEMATICAL ITALIC SMALL A..MATHEMATICAL ITALIC SMALL G
	{0x1D456, 0x1D467, prLower},   // L&  [18] MATHEMATICAL ITALIC SMALL I..MATHEMATICAL ITALIC SMALL Z
	{0x1D468, 0x1D481, prUpper},   // L&  [26] MATHEMATICAL BOLD ITALIC CAPITAL A..MATHEMATICAL BOLD ITALIC CAPITAL Z
	{0x1D482, 0x1D49B, prLower},   // L&  [26] MATHEMATICAL BOLD ITALIC SMALL A..MATHEMATICAL BOLD ITALIC SMALL Z
	{0x1D49C, 0x1D49C, prUpper},   // L&       MATHEMATICAL SCRIPT CAPITAL A
	{0x1D49E, 0x1D49F, prUpper},   // L&   [2] MATHEMATICAL SCRIPT CAPITAL C..MATHEMATICAL SCRIPT CAPITAL D
	{0x1D4A2, 0x1D4A2, prUpper},   // L&       MATHEMATICAL SCRIPT CAPITAL G
	{0x1D4A5, 0x1D4A6, prUpper},   // L&   [2] MATHEMATICAL SCRIPT CAPITAL J..MATHEMATICAL SCRIPT CAPITAL K
	{0x1D4A9, 0x1D4AC, prUpper},   // L&   [4] MATHEMATICAL SCRIPT CAPITAL N..MATHEMATICAL SCRIPT CAPITAL Q
	{0x1D4AE, 0x1D4B5, prUpper},   // L&   [8] MATHEMATICAL SCRIPT CAPITAL S..MATHEMATICAL SCRIPT CAPITAL Z
	{0x1D4B6, 0x1D4B9, prLower},   // L&   [4] MATHEMATICAL SCRIPT SMALL A..MATHEMATICAL SCRIPT SMALL D
	{0x1D4BB, 0x1D4BB, prLower},   // L&       MATHEMATICAL SCRIPT SMALL F
	{0x1D4BD, 0x1D4C3, prLower},   // L&   [7] MATHEMATICAL SCRIPT SMALL H..MATHEMATICAL SCRIPT SMALL N
	{0x1D4C5, 0x1D4CF, prLower},   // L&  [11] MATHEMATICAL SCRIPT SMALL P..MATHEMATICAL SCRIPT SMALL Z
	{0x1D4D0, 0x1D4E9, prUpper},   // L&  [26] MATHEMATICAL BOLD SCRIPT CAPITAL A..MATHEMATICAL BOLD SCRIPT CAPITAL Z
	{0x1D4EA, 0x1D503, prLower},   // L&  [26] MATHEMATICAL BOLD SCRIPT SMALL A..MATHEMATICAL BOLD SCRIPT SMALL Z
	{0x1D504, 0x1D505, prUpper},   // L&   [2] MATHEMATICAL FRAKTUR CAPITAL A..MATHEMATICAL FRAKTUR CAPITAL B
	{0x1D507, 0x1D50A, prUpper},   // L&   [4] MATHEMATICAL FRAKTUR CAPITAL D..MATHEMATICAL FRAKTUR CAPITAL G
	{0x1D50D, 0x1D514, prUpper},   // L&   [8] MATHEMATICAL FRAKTUR CAPITAL J..MATHEMATICAL FRAKTUR CAPITAL Q
	{0x1D516, 0x1D51C, prUpper},   // L&   [7] MATHEMATICAL FRAKTUR CAPITAL S..MATHEMATICAL FRAKTUR CAPITAL Y
	{0x1D51E, 0x1D537, prLower},   // L&  [26] MATHEMATICAL FRAKTUR SMALL A..MATHEMATICAL FRAKTUR SMALL Z
	{0x1D538, 0x1D539, prUpper},   // L&   [2] MATHEMATICAL DOUBLE-STRUCK CAPITAL A..MATHEMATICAL DOUBLE-STRUCK CAPITAL B
	{0x1D53B, 0x1D53E, prUpper},   // L&   [4] MATHEMATICAL DOUBLE-STRUCK CAPITAL D..MATHEMATICAL DOUBLE-STRUCK CAPITAL G
	{0x1D540, 0x1D544, prUpper},   // L&   [5] MATHEMATICAL DOUBLE-STRUCK CAPITAL I..MATHEMATICAL DOUBLE-STRUCK CAPITAL M
	{0x1D546, 0x1D546, prUpper},   // L&       MATHEMATICAL DOUBLE-STRUCK CAPITAL O
	{0x1D54A, 0x1D550, prUpper},   // L&   [7] MATHEMATICAL DOUBLE-STRUCK CAPITAL S..MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
	{0x1D552, 0x1D56B, prLower},   // L&  [26] MATHEMATICAL DOUBLE-STRUCK SMALL A..MATHEMATICAL DOUBLE-STRUCK SMALL Z
	{0x1D56C, 0x1D585, prUpper},   // L&  [26] MATHEMATICAL BOLD FRAKTUR CAPITAL A..MATHEMATICAL BOLD FRAKTUR CAPITAL Z
	{0x1D586, 0x1D59F, prLower},   // L&  [26] MATHEMATICAL BOLD FRAKTUR SMALL A..MATHEMATICAL BOLD FRAKTUR SMALL Z
	{0x1D5A0, 0x1D5B9, prUpper},   // L&  [26] MATHEMATICAL SANS-SERIF CAPITAL A..MATHEMATICAL SANS-SERIF CAPITAL Z
	{0x1D5BA, 0x1D5D3, prLower},   // L&  [26] MATHEMATICAL SANS-SERIF SMALL A..MATHEMATICAL SANS-SERIF SMALL Z
	{0x1D5D4, 0x1D5ED, prUpper},   // L&  [26] MATHEMATICAL SANS-SERIF BOLD CAPITAL A..MATHEMATICAL SANS-SERIF BOLD CAPITAL Z
	{0x1D5EE, 0x1D607, prLower},   // L&  [26] MATHEMATICAL SANS-SERIF BOLD SMALL A..MATHEMATICAL SANS-SERIF BOLD SMALL Z
	{0x1D608, 0x1D621, prUpper},   // L&  [26] MATHEMATICAL SANS-SERIF ITALIC CAPITAL A..MATHEMATICAL SANS-SERIF ITALIC CAPITAL Z
	{0x1D622, 0x1D63B, prLower},   // L&  [26] MATHEMATICAL SANS-SERIF ITALIC SMALL A..MATHEMATICAL SANS-SERIF ITALIC SMALL Z
	{0x1D63C, 0x1D655, prUpper},   // L&  [26] MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL A..MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Z
	{0x1D656, 0x1D66F, prLower},   // L&  [26] MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL A..MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Z
	{0x1D670, 0x1D689, prUpper},   // L&  [26] MATHEMATICAL MONOSPACE CAPITAL A..MATHEMATICAL MONOSPACE CAPITAL Z
	{0x1D68A, 0x1D6A5, prLower},   // L&  [28] MATHEMATICAL MONOSPACE SMALL A..MATHEMATICAL ITALIC SMALL DOTLESS J
	{0x1D6A8, 0x1D6C0, prUpper},   // L&  [25] MATHEMATICAL BOLD CAPITAL ALPHA..MATHEMATICAL BOLD CAPITAL OMEGA
	{0x1D6C2, 0x1D6DA, prLower},   // L&  [25] MATHEMATICAL BOLD SMALL ALPHA..MATHEMATICAL BOLD SMALL OMEGA
	{0x1D6DC, 0x1D6E1, prLower},   // L&   [6] MATHEMATICAL BOLD EPSILON SYMBOL..MATHEMATICAL BOLD PI SYMBOL
	{0x1D6E2, 0x1D6FA, prUpper},   // L&  [25] MATHEMATICAL ITALIC CAPITAL ALPHA..MATHEMATICAL ITALIC CAPITAL OMEGA
	{0x1D6FC, 0x1D714, prLower},   // L&  [25] MATHEMATICAL ITALIC SMALL ALPHA..MATHEMATICAL ITALIC SMALL OMEGA
	{0x1D716, 0x1D71B, prLower},   // L&   [6] MATHEMATICAL ITALIC EPSILON SYMBOL..MATHEMATICAL ITALIC PI SYMBOL
	{0x1D71C, 0x1D734, prUpper},   // L&  [25] MATHEMATICAL BOLD ITALIC CAPITAL ALPHA..MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
	{0x1D736, 0x1D74E, prLower},   // L&  [25] MATHEMATICAL BOLD ITALIC SMALL ALPHA..MATHEMATICAL BOLD ITALIC SMALL OMEGA
	{0x1D750, 0x1D755, prLower},   // L&   [6] MATHEMATICAL BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD ITALIC PI SYMBOL
	{0x1D756, 0x1D76E, prUpper},   // L&  [25] MATHEMATICAL SANS-SERIF BOLD CAPITAL ALPHA..MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
	{0x1D770, 0x1D788, prLower},   // L&  [25] MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
	{0x1D78A, 0x1D78F, prLower},   // L&   [6] MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD PI SYMBOL
	{0x1D790, 0x1D7A8, prUpper},   // L&  [25] MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ALPHA..MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
	{0x1D7AA, 0x1D7C2, prLower},   // L&  [25] MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
	{0x1D7C4, 0x1D7C9, prLower},   // L&   [6] MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD ITALIC PI SYMBOL
	{0x1D7CA, 0x1D7CA, prUpper},   // L&       MATHEMATICAL BOLD CAPITAL DIGAMMA
	{0x1D7CB, 0x1D7CB, prLower},   // L&       MATHEMATICAL BOLD SMALL DIGAMMA
	{0x1D7CE, 0x1D7FF, prNumeric}, // Nd  [50] MATHEMATICAL BOLD DIGIT ZERO..MATHEMATICAL MONOSPACE DIGIT NINE
	{0x1DA00, 0x1DA36, prExtend},  // Mn  [55] SIGNWRITING HEAD RIM..SIGNWRITING AIR SUCKING IN
	{0x1DA3B, 0x1DA6C, prExtend},  // Mn  [50] SIGNWRITING MOUTH CLOSED NEUTRAL..SIGNWRITING EXCITEMENT
	{0x1DA75, 0x1DA75, prExtend},  // Mn       SIGNWRITING UPPER BODY TILTING FROM HIP JOINTS
	{0x1DA84, 0x1DA84, prExtend},  // Mn       SIGNWRITING LOCATION HEAD NECK
	{0x1DA88, 0x1DA88, prSTerm},   // Po       SIGNWRITING FULL STOP
	{0x1DA9B, 0x1DA9F, prExtend},  // Mn   [5] SIGNWRITING FILL MODIFIER-2..SIGNWRITING FILL MODIFIER-6
	{0x1DAA1, 0x1DAAF, prExtend},  // Mn  [15] SIGNWRITING ROTATION MODIFIER-2..SIGNWRITING ROTATION MODIFIER-16
	{0x1DF00, 0x1DF09, prLower},   // L&  [10] LATIN SMALL LETTER FENG DIGRAPH WITH TRILL..LATIN SMALL LETTER T WITH HOOK AND RETROFLEX HOOK
	{0x1DF0A, 0x1DF0A, prOLetter}, // Lo       LATIN LETTER RETROFLEX CLICK WITH RETROFLEX HOOK
	{0x1DF0B, 0x1DF1E, prLower},   // L&  [20] LATIN SMALL LETTER ESH WITH DOUBLE BAR..LATIN SMALL LETTER S WITH CURL
	{0x1E000, 0x1E006, prExtend},  // Mn   [7] COMBINING GLAGOLITIC LETTER AZU..COMBINING GLAGOLITIC LETTER ZHIVETE
	{0x1E008, 0x1E018, prExtend},  // Mn  [17] COMBINING GLAGOLITIC LETTER ZEMLJA..COMBINING GLAGOLITIC LETTER HERU
	{0x1E01B, 0x1E021, prExtend},  // Mn   [7] COMBINING GLAGOLITIC LETTER SHTA..COMBINING GLAGOLITIC LETTER YATI
	{0x1E023, 0x1E024, prExtend},  // Mn   [2] COMBINING GLAGOLITIC LETTER YU..COMBINING GLAGOLITIC LETTER SMALL YUS
	{0x1E026, 0x1E02A, prExtend},  // Mn   [5] COMBINING GLAGOLITIC LETTER YO..COMBINING GLAGOLITIC LETTER FITA
	{0x1E100, 0x1E12C, prOLetter}, // Lo  [45] NYIAKENG PUACHUE HMONG LETTER MA..NYIAKENG PUACHUE HMONG LETTER W
	{0x1E130, 0x1E136, prExtend},  // Mn   [7] NYIAKENG PUACHUE HMONG TONE-B..NYIAKENG PUACHUE HMONG TONE-D
	{0x1E137, 0x1E13D, prOLetter}, // Lm   [7] NYIAKENG PUACHUE HMONG SIGN FOR PERSON..NYIAKENG PUACHUE HMONG SYLLABLE LENGTHENER
	{0x1E140, 0x1E149, prNumeric}, // Nd  [10] NYIAKENG PUACHUE HMONG DIGIT ZERO..NYIAKENG PUACHUE HMONG DIGIT NINE
	{0x1E14E, 0x1E14E, prOLetter}, // Lo       NYIAKENG PUACHUE HMONG LOGOGRAM NYAJ
	{0x1E290, 0x1E2AD, prOLetter}, // Lo  [30] TOTO LETTER PA..TOTO LETTER A
	{0x1E2AE, 0x1E2AE, prExtend},  // Mn       TOTO SIGN RISING TONE
	{0x1E2C0, 0x1E2EB, prOLetter}, // Lo  [44] WANCHO LETTER AA..WANCHO LETTER YIH
	{0x1E2EC, 0x1E2EF, prExtend},  // Mn   [4] WANCHO TONE TUP..WANCHO TONE KOINI
	{0x1E2F0, 0x1E2F9, prNumeric}, // Nd  [10] WANCHO DIGIT ZERO..WANCHO DIGIT NINE
	{0x1E7E0, 0x1E7E6, prOLetter}, // Lo   [7] ETHIOPIC SYLLABLE HHYA..ETHIOPIC SYLLABLE HHYO
	{0x1E7E8, 0x1E7EB, prOLetter}, // Lo   [4] ETHIOPIC SYLLABLE GURAGE HHWA..ETHIOPIC SYLLABLE HHWE
	{0x1E7ED, 0x1E7EE, prOLetter}, // Lo   [2] ETHIOPIC SYLLABLE GURAGE MWI..ETHIOPIC SYLLABLE GURAGE MWEE
	{0x1E7F0, 0x1E7FE, prOLetter}, // Lo  [15] ETHIOPIC SYLLABLE GURAGE QWI..ETHIOPIC SYLLABLE GURAGE PWEE
	{0x1E800, 0x1E8C4, prOLetter}, // Lo [197] MENDE KIKAKUI SYLLABLE M001 KI..MENDE KIKAKUI SYLLABLE M060 NYON
	{0x1E8D0, 0x1E8D6, prExtend},  // Mn   [7] MENDE KIKAKUI COMBINING NUMBER TEENS..MENDE KIKAKUI COMBINING NUMBER MILLIONS
	{0x1E900, 0x1E921, prUpper},   // L&  [34] ADLAM CAPITAL LETTER ALIF..ADLAM CAPITAL LETTER SHA
	{0x1E922, 0x1E943, prLower},   // L&  [34] ADLAM SMALL LETTER ALIF..ADLAM SMALL LETTER SHA
	{0x1E944, 0x1E94A, prExtend},  // Mn   [7] ADLAM ALIF LENGTHENER..ADLAM NUKTA
	{0x1E94B, 0x1E94B, prOLetter}, // Lm       ADLAM NASALIZATION MARK
	{0x1E950, 0x1E959, prNumeric}, // Nd  [10] ADLAM DIGIT ZERO..ADLAM DIGIT NINE
	{0x1EE00, 0x1EE03, prOLetter}, // Lo   [4] ARABIC MATHEMATICAL ALEF..ARABIC MATHEMATICAL DAL
	{0x1EE05, 0x1EE1F, prOLetter}, // Lo  [27] ARABIC MATHEMATICAL WAW..ARABIC MATHEMATICAL DOTLESS QAF
	{0x1EE21, 0x1EE22, prOLetter}, // Lo   [2] ARABIC MATHEMATICAL INITIAL BEH..ARABIC MATHEMATICAL INITIAL JEEM
	{0x1EE24, 0x1EE24, prOLetter}, // Lo       ARABIC MATHEMATICAL INITIAL HEH
	{0x1EE27, 0x1EE27, prOLetter}, // Lo       ARABIC MATHEMATICAL INITIAL HAH
	{0x1EE29, 0x1EE32, prOLetter}, // Lo  [10] ARABIC MATHEMATICAL INITIAL YEH..ARABIC MATHEMATICAL INITIAL QAF
	{0x1EE34, 0x1EE37, prOLetter}, // Lo   [4] ARABIC MATHEMATICAL INITIAL SHEEN..ARABIC MATHEMATICAL INITIAL KHAH
	{0x1EE39, 0x1EE39, prOLetter}, // Lo       ARABIC MATHEMATICAL INITIAL DAD
	{0x1EE3B, 0x1EE3B, prOLetter}, // Lo       ARABIC MATHEMATICAL INITIAL GHAIN
	{0x1EE42, 0x1EE42, prOLetter}, // Lo       ARABIC MATHEMATICAL TAILED JEEM
	{0x1EE47, 0x1EE47, prOLetter}, // Lo       ARABIC MATHEMATICAL TAILED HAH
	{0x1EE49, 0x1EE49, prOLetter}, // Lo       ARABIC MATHEMATICAL TAILED YEH
	{0x1EE4B, 0x1EE4B, prOLetter}, // Lo       ARABIC MATHEMATICAL TAILED LAM
	{0x1EE4D, 0x1EE4F, prOLetter}, // Lo   [3] ARABIC MATHEMATICAL TAILED NOON..ARABIC MATHEMATICAL TAILED AIN
	{0x1EE51, 0x1EE52, prOLetter}, // Lo   [2] ARABIC MATHEMATICAL TAILED SAD..ARABIC MATHEMATICAL TAILED QAF
	{0x1EE54, 0x1EE54, prOLetter}, // Lo       ARABIC MATHEMATICAL TAILED SHEEN
	{0x1EE57, 0x1EE57, prOLetter}, // Lo       ARABIC MATHEMATICAL TAILED KHAH
	{0x1EE59, 0x1EE59, prOLetter}, // Lo       ARABIC MATHEMATICAL TAILED DAD
	{0x1EE5B, 0x1EE5B, prOLetter}, // Lo       ARABIC MATHEMATICAL TAILED GHAIN
	{0x1EE5D, 0x1EE5D, prOLetter}, // Lo       ARABIC MATHEMATICAL TAILED DOTLESS NOON
	{0x1EE5F, 0x1EE5F, prOLetter}, // Lo       ARABIC MATHEMATICAL TAILED DOTLESS QAF
	{0x1EE61, 0x1EE62, prOLetter}, // Lo   [2] ARABIC MATHEMATICAL STRETCHED BEH..ARABIC MATHEMATICAL STRETCHED JEEM
	{0x1EE64, 0x1EE64, prOLetter}, // Lo       ARABIC MATHEMATICAL STRETCHED HEH
	{0x1EE67, 0x1EE6A, prOLetter}, // Lo   [4] ARABIC MATHEMATICAL STRETCHED HAH..ARABIC MATHEMATICAL STRETCHED KAF
	{0x1EE6C, 0x1EE72, prOLetter}, // Lo   [7] ARABIC MATHEMATICAL STRETCHED MEEM..ARABIC MATHEMATICAL STRETCHED QAF
	{0x1EE74, 0x1EE77, prOLetter}, // Lo   [4] ARABIC MATHEMATICAL STRETCHED SHEEN..ARABIC MATHEMATICAL STRETCHED KHAH
	{0x1EE79, 0x1EE7C, prOLetter}, // Lo   [4] ARABIC MATHEMATICAL STRETCHED DAD..ARABIC MATHEMATICAL STRETCHED DOTLESS BEH
	{0x1EE7E, 0x1EE7E, prOLetter}, // Lo       ARABIC MATHEMATICAL STRETCHED DOTLESS FEH
	{0x1EE80, 0x1EE89, prOLetter}, // Lo  [10] ARABIC MATHEMATICAL LOOPED ALEF..ARABIC MATHEMATICAL LOOPED YEH
	{0x1EE8B, 0x1EE9B, prOLetter}, // Lo  [17] ARABIC MATHEMATICAL LOOPED LAM..ARABIC MATHEMATICAL LOOPED GHAIN
	{0x1EEA1, 0x1EEA3, prOLetter}, // Lo   [3] ARABIC MATHEMATICAL DOUBLE-STRUCK BEH..ARABIC MATHEMATICAL DOUBLE-STRUCK DAL
	{0x1EEA5, 0x1EEA9, prOLetter}, // Lo   [5] ARABIC MATHEMATICAL DOUBLE-STRUCK WAW..ARABIC MATHEMATICAL DOUBLE-STRUCK YEH
	{0x1EEAB, 0x1EEBB, prOLetter}, // Lo  [17] ARABIC MATHEMATICAL DOUBLE-STRUCK LAM..ARABIC MATHEMATICAL DOUBLE-STRUCK GHAIN
	{0x1F130, 0x1F149, prUpper},   // So  [26] SQUARED LATIN CAPITAL LETTER A..SQUARED LATIN CAPITAL LETTER Z
	{0x1F150, 0x1F169, prUpper},   // So  [26] NEGATIVE CIRCLED LATIN CAPITAL LETTER A..NEGATIVE CIRCLED LATIN CAPITAL LETTER Z
	{0x1F170, 0x1F189, prUpper},   // So  [26] NEGATIVE SQUARED LATIN CAPITAL LETTER A..NEGATIVE SQUARED LATIN CAPITAL LETTER Z
	{0x1F676, 0x1F678, prClose},   // So   [3] SANS-SERIF HEAVY DOUBLE TURNED COMMA QUOTATION MARK ORNAMENT..SANS-SERIF HEAVY LOW DOUBLE COMMA QUOTATION MARK ORNAMENT
	{0x1FBF0, 0x1FBF9, prNumeric}, // Nd  [10] SEGMENTED DIGIT ZERO..SEGMENTED DIGIT NINE
	{0x20000, 0x2A6DF, prOLetter}, // Lo [42720] CJK UNIFIED IDEOGRAPH-20000..CJK UNIFIED IDEOGRAPH-2A6DF
	{0x2A700, 0x2B738, prOLetter}, // Lo [4153] CJK UNIFIED IDEOGRAPH-2A700..CJK UNIFIED IDEOGRAPH-2B738
	{0x2B740, 0x2B81D, prOLetter}, // Lo [222] CJK UNIFIED IDEOGRAPH-2B740..CJK UNIFIED IDEOGRAPH-2B81D
	{0x2B820, 0x2CEA1, prOLetter}, // Lo [5762] CJK UNIFIED IDEOGRAPH-2B820..CJK UNIFIED IDEOGRAPH-2CEA1
	{0x2CEB0, 0x2EBE0, prOLetter}, // Lo [7473] CJK UNIFIED IDEOGRAPH-2CEB0..CJK UNIFIED IDEOGRAPH-2EBE0
	{0x2F800, 0x2FA1D, prOLetter}, // Lo [542] CJK COMPATIBILITY IDEOGRAPH-2F800..CJK COMPATIBILITY IDEOGRAPH-2FA1D
	{0x30000, 0x3134A, prOLetter}, // Lo [4939] CJK UNIFIED IDEOGRAPH-30000..CJK UNIFIED IDEOGRAPH-3134A
	{0xE0001, 0xE0001, prFormat},  // Cf       LANGUAGE TAG
	{0xE0020, 0xE007F, prExtend},  // Cf  [96] TAG SPACE..CANCEL TAG
	{0xE0100, 0xE01EF, prExtend},  // Mn [240] VARIATION SELECTOR-17..VARIATION SELECTOR-256
}
