// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// ApplicationScanSettings Agent scan settings for applicaiton scan
type ApplicationScanSettings struct {

	// Scan recurrences in RFC-5545 section 3.3.10 format.
	// Only supported input are weekly, biweekly, monthly listed below
	// FREQ=WEEKLY;WKST=<weekday>;INTERVAL=1 - This weekly scan on the specified weekday (e.g. Sunday)
	// FREQ=WEEKLY;WKST=<weekday>;INTERVAL=2 - This bi-weekly scan on the specified weekday (e.g. Sunday)
	// FREQ=MONTHLY;WKST=<weekday>;INTERVAL=1 - This monthly scan on the specified weekday (e.g. Sunday, starting from the next such weekday based on the time of setting creation)
	ApplicationScanRecurrence *string `mandatory:"true" json:"applicationScanRecurrence"`

	// Enable or disable application scan
	IsEnabled *bool `mandatory:"true" json:"isEnabled"`

	// List of folders selected for scanning
	FoldersToScan []FolderToScan `mandatory:"true" json:"foldersToScan"`
}

func (m ApplicationScanSettings) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m ApplicationScanSettings) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
