---
layout: default
title: Variable - Reference Manual - csvq
category: reference
---

# Variable

A variable has a value. 

Naming restriction: [Parsing - Statements]({{ '/reference/statement.html#parsing' | relative_url }})

* [Declare Variable](#declare)
* [Substitute](#substitution)
* [SELECT INTO Statement](#select-into)
* [Dispose Variable](#dispose)

## Declare Variable
{: #declare}

```sql
variable_declaration
  : DECLARE variable_assignment [, variable_assignment...];
  | VAR variable_assignment [, variable_assignment...];

variable_assignment
  : @varname
  | @varname := initial_value
```

_initial_value_
: [value]({{ '/reference/value.html' | relative_url }})


_VAR_ is an alias of _DECLARE_.

If the _initial_value_ is not specified, then a null is set to the variable. 

## Substitute
{: #substitution}

A variable subsitution expression returns the substituted value.

```sql
@varname := value
```

_value_
: [value]({{ '/reference/value.html' | relative_url }})


The variable substitution expression can be used in query statements such as update queries, select clauses in select queries. 
If this expression exists in the other than select clauses of a select query, then no error occurs, but the order of the operation is not guranteed.

## SELECT INTO Statement
{: #select-into}

SELECT INTO statement substitutes the result into the _variables_.
The result set of the query must be at most 1 record.

```
select_into_statement
  : [with_clause]
      select_clause
      INTO variable [, variable ...]
      [from_clause]
      [where_clause]
      [group_by_clause]
      [having_clause]
      [order_by_clause]
      [limit_clause]
      [offset_clause]
      [FOR UPDATE]
```

_with_clause_
: [With Clause]({{ '/reference/select-query.html#with_clause' | relative_url }})

_select_clause_
: [Select Clause]({{ '/reference/select-query.html#select_clause' | relative_url }})

_variable_
: [Variable]({{ '/reference/variable.html' | relative_url }})

_from_clause_
: [From Clause]({{ '/reference/select-query.html#from_clause' | relative_url }})

_where_clause_
: [Where Clause]({{ '/reference/select-query.html#where_clause' | relative_url }})

_group_by_clause_
: [Group By Clause]({{ '/reference/select-query.html#group_by_clause' | relative_url }})

_having_clause_
: [Having Clause]({{ '/reference/select-query.html#having_clause' | relative_url }})

_order_by_clause_
: [Order By Clause]({{ '/reference/select-query.html#order_by_clause' | relative_url }})

_limit_clause_
: [Limit Clause]({{ '/reference/select-query.html#limit_clause' | relative_url }})

_offset_clause_
: [Offset Clause]({{ '/reference/select-query.html#offset_clause' | relative_url }})

##  Dispose Variable
{: #dispose}

```sql
DISPOSE @varname;
```
