// Code generated by NodeGenerator. DO NOT EDIT.

// Package node is a generated by the generator.
package node

import (
	"sync/atomic"
	"unsafe"
)

// BS is a cache entry that provide the following features:
//
// 1. Base
//
// 2. Size
type BS[K comparable, V any] struct {
	key       K
	value     V
	prev      *BS[K, V]
	next      *BS[K, V]
	state     atomic.Uint32
	queueType uint8
}

// NewBS creates a new BS.
func NewBS[K comparable, V any](key K, value V, expiresAt, refreshableAt int64, weight uint32) Node[K, V] {
	n := &BS[K, V]{
		key:   key,
		value: value,
	}
	n.state.Store(aliveState)

	return n
}

// CastPointerToBS casts a pointer to BS.
func CastPointerToBS[K comparable, V any](ptr unsafe.Pointer) Node[K, V] {
	return (*BS[K, V])(ptr)
}

func (n *BS[K, V]) Key() K {
	return n.key
}

func (n *BS[K, V]) Value() V {
	return n.value
}

func (n *BS[K, V]) AsPointer() unsafe.Pointer {
	return unsafe.Pointer(n)
}

func (n *BS[K, V]) Prev() Node[K, V] {
	return n.prev
}

func (n *BS[K, V]) SetPrev(v Node[K, V]) {
	if v == nil {
		n.prev = nil
		return
	}
	n.prev = (*BS[K, V])(v.AsPointer())
}

func (n *BS[K, V]) Next() Node[K, V] {
	return n.next
}

func (n *BS[K, V]) SetNext(v Node[K, V]) {
	if v == nil {
		n.next = nil
		return
	}
	n.next = (*BS[K, V])(v.AsPointer())
}

func (n *BS[K, V]) PrevExp() Node[K, V] {
	panic("not implemented")
}

func (n *BS[K, V]) SetPrevExp(v Node[K, V]) {
	panic("not implemented")
}

func (n *BS[K, V]) NextExp() Node[K, V] {
	panic("not implemented")
}

func (n *BS[K, V]) SetNextExp(v Node[K, V]) {
	panic("not implemented")
}

func (n *BS[K, V]) HasExpired(now int64) bool {
	return false
}

func (n *BS[K, V]) ExpiresAt() int64 {
	panic("not implemented")
}

func (n *BS[K, V]) CASExpiresAt(old, new int64) bool {
	panic("not implemented")
}

func (n *BS[K, V]) SetExpiresAt(new int64) {
	panic("not implemented")
}

func (n *BS[K, V]) RefreshableAt() int64 {
	panic("not implemented")
}

func (n *BS[K, V]) CASRefreshableAt(old, new int64) bool {
	panic("not implemented")
}

func (n *BS[K, V]) SetRefreshableAt(new int64) {
	panic("not implemented")
}

func (n *BS[K, V]) IsFresh(now int64) bool {
	return true
}

func (n *BS[K, V]) Weight() uint32 {
	return 1
}

func (n *BS[K, V]) IsAlive() bool {
	return n.state.Load() == aliveState
}

func (n *BS[K, V]) IsRetired() bool {
	return n.state.Load() == retiredState
}

func (n *BS[K, V]) Retire() {
	n.state.Store(retiredState)
}

func (n *BS[K, V]) IsDead() bool {
	return n.state.Load() == deadState
}

func (n *BS[K, V]) Die() {
	n.state.Store(deadState)
}

func (n *BS[K, V]) GetQueueType() uint8 {
	return n.queueType
}

func (n *BS[K, V]) SetQueueType(queueType uint8) {
	n.queueType = queueType
}

func (n *BS[K, V]) InWindow() bool {
	return n.GetQueueType() == InWindowQueue
}

func (n *BS[K, V]) MakeWindow() {
	n.SetQueueType(InWindowQueue)
}

func (n *BS[K, V]) InMainProbation() bool {
	return n.GetQueueType() == InMainProbationQueue
}

func (n *BS[K, V]) MakeMainProbation() {
	n.SetQueueType(InMainProbationQueue)
}

func (n *BS[K, V]) InMainProtected() bool {
	return n.GetQueueType() == InMainProtectedQueue
}

func (n *BS[K, V]) MakeMainProtected() {
	n.SetQueueType(InMainProtectedQueue)
}
