// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-04-20/models"
)

// NewFetchAuditLogParams creates a new FetchAuditLogParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFetchAuditLogParams() *FetchAuditLogParams {
	return &FetchAuditLogParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFetchAuditLogParamsWithTimeout creates a new FetchAuditLogParams object
// with the ability to set a timeout on a request.
func NewFetchAuditLogParamsWithTimeout(timeout time.Duration) *FetchAuditLogParams {
	return &FetchAuditLogParams{
		timeout: timeout,
	}
}

// NewFetchAuditLogParamsWithContext creates a new FetchAuditLogParams object
// with the ability to set a context for a request.
func NewFetchAuditLogParamsWithContext(ctx context.Context) *FetchAuditLogParams {
	return &FetchAuditLogParams{
		Context: ctx,
	}
}

// NewFetchAuditLogParamsWithHTTPClient creates a new FetchAuditLogParams object
// with the ability to set a custom HTTPClient for a request.
func NewFetchAuditLogParamsWithHTTPClient(client *http.Client) *FetchAuditLogParams {
	return &FetchAuditLogParams{
		HTTPClient: client,
	}
}

/*
FetchAuditLogParams contains all the parameters to send to the API endpoint

	for the fetch audit log operation.

	Typically these are written to a http.Request.
*/
type FetchAuditLogParams struct {

	// Body.
	Body *models.HashicorpCloudVault20200420FetchAuditLogRequest

	// ClusterID.
	ClusterID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the fetch audit log params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FetchAuditLogParams) WithDefaults() *FetchAuditLogParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the fetch audit log params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FetchAuditLogParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the fetch audit log params
func (o *FetchAuditLogParams) WithTimeout(timeout time.Duration) *FetchAuditLogParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the fetch audit log params
func (o *FetchAuditLogParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the fetch audit log params
func (o *FetchAuditLogParams) WithContext(ctx context.Context) *FetchAuditLogParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the fetch audit log params
func (o *FetchAuditLogParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the fetch audit log params
func (o *FetchAuditLogParams) WithHTTPClient(client *http.Client) *FetchAuditLogParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the fetch audit log params
func (o *FetchAuditLogParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the fetch audit log params
func (o *FetchAuditLogParams) WithBody(body *models.HashicorpCloudVault20200420FetchAuditLogRequest) *FetchAuditLogParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the fetch audit log params
func (o *FetchAuditLogParams) SetBody(body *models.HashicorpCloudVault20200420FetchAuditLogRequest) {
	o.Body = body
}

// WithClusterID adds the clusterID to the fetch audit log params
func (o *FetchAuditLogParams) WithClusterID(clusterID string) *FetchAuditLogParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the fetch audit log params
func (o *FetchAuditLogParams) SetClusterID(clusterID string) {
	o.ClusterID = clusterID
}

// WithLocationOrganizationID adds the locationOrganizationID to the fetch audit log params
func (o *FetchAuditLogParams) WithLocationOrganizationID(locationOrganizationID string) *FetchAuditLogParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the fetch audit log params
func (o *FetchAuditLogParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the fetch audit log params
func (o *FetchAuditLogParams) WithLocationProjectID(locationProjectID string) *FetchAuditLogParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the fetch audit log params
func (o *FetchAuditLogParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *FetchAuditLogParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
