// Code generated by go-swagger; DO NOT EDIT.

package project_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-resource-manager/preview/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ProjectServiceListReader is a Reader for the ProjectServiceList structure.
type ProjectServiceListReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ProjectServiceListReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewProjectServiceListOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewProjectServiceListDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewProjectServiceListOK creates a ProjectServiceListOK with default headers values
func NewProjectServiceListOK() *ProjectServiceListOK {
	return &ProjectServiceListOK{}
}

/*
ProjectServiceListOK describes a response with status code 200, with default header values.

A successful response.
*/
type ProjectServiceListOK struct {
	Payload *models.HashicorpCloudResourcemanagerProjectListResponse
}

// IsSuccess returns true when this project service list o k response has a 2xx status code
func (o *ProjectServiceListOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this project service list o k response has a 3xx status code
func (o *ProjectServiceListOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this project service list o k response has a 4xx status code
func (o *ProjectServiceListOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this project service list o k response has a 5xx status code
func (o *ProjectServiceListOK) IsServerError() bool {
	return false
}

// IsCode returns true when this project service list o k response a status code equal to that given
func (o *ProjectServiceListOK) IsCode(code int) bool {
	return code == 200
}

func (o *ProjectServiceListOK) Error() string {
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/projects][%d] projectServiceListOK  %+v", 200, o.Payload)
}

func (o *ProjectServiceListOK) String() string {
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/projects][%d] projectServiceListOK  %+v", 200, o.Payload)
}

func (o *ProjectServiceListOK) GetPayload() *models.HashicorpCloudResourcemanagerProjectListResponse {
	return o.Payload
}

func (o *ProjectServiceListOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudResourcemanagerProjectListResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewProjectServiceListDefault creates a ProjectServiceListDefault with default headers values
func NewProjectServiceListDefault(code int) *ProjectServiceListDefault {
	return &ProjectServiceListDefault{
		_statusCode: code,
	}
}

/*
ProjectServiceListDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ProjectServiceListDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// Code gets the status code for the project service list default response
func (o *ProjectServiceListDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this project service list default response has a 2xx status code
func (o *ProjectServiceListDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this project service list default response has a 3xx status code
func (o *ProjectServiceListDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this project service list default response has a 4xx status code
func (o *ProjectServiceListDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this project service list default response has a 5xx status code
func (o *ProjectServiceListDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this project service list default response a status code equal to that given
func (o *ProjectServiceListDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *ProjectServiceListDefault) Error() string {
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/projects][%d] ProjectService_List default  %+v", o._statusCode, o.Payload)
}

func (o *ProjectServiceListDefault) String() string {
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/projects][%d] ProjectService_List default  %+v", o._statusCode, o.Payload)
}

func (o *ProjectServiceListDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *ProjectServiceListDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
