// Code generated by go-swagger; DO NOT EDIT.

package organization_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-resource-manager/preview/2019-12-10/models"
)

// NewOrganizationServiceCreateParams creates a new OrganizationServiceCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewOrganizationServiceCreateParams() *OrganizationServiceCreateParams {
	return &OrganizationServiceCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewOrganizationServiceCreateParamsWithTimeout creates a new OrganizationServiceCreateParams object
// with the ability to set a timeout on a request.
func NewOrganizationServiceCreateParamsWithTimeout(timeout time.Duration) *OrganizationServiceCreateParams {
	return &OrganizationServiceCreateParams{
		timeout: timeout,
	}
}

// NewOrganizationServiceCreateParamsWithContext creates a new OrganizationServiceCreateParams object
// with the ability to set a context for a request.
func NewOrganizationServiceCreateParamsWithContext(ctx context.Context) *OrganizationServiceCreateParams {
	return &OrganizationServiceCreateParams{
		Context: ctx,
	}
}

// NewOrganizationServiceCreateParamsWithHTTPClient creates a new OrganizationServiceCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewOrganizationServiceCreateParamsWithHTTPClient(client *http.Client) *OrganizationServiceCreateParams {
	return &OrganizationServiceCreateParams{
		HTTPClient: client,
	}
}

/*
OrganizationServiceCreateParams contains all the parameters to send to the API endpoint

	for the organization service create operation.

	Typically these are written to a http.Request.
*/
type OrganizationServiceCreateParams struct {

	// Body.
	Body *models.HashicorpCloudResourcemanagerOrganizationCreateRequest

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the organization service create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *OrganizationServiceCreateParams) WithDefaults() *OrganizationServiceCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the organization service create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *OrganizationServiceCreateParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the organization service create params
func (o *OrganizationServiceCreateParams) WithTimeout(timeout time.Duration) *OrganizationServiceCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the organization service create params
func (o *OrganizationServiceCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the organization service create params
func (o *OrganizationServiceCreateParams) WithContext(ctx context.Context) *OrganizationServiceCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the organization service create params
func (o *OrganizationServiceCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the organization service create params
func (o *OrganizationServiceCreateParams) WithHTTPClient(client *http.Client) *OrganizationServiceCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the organization service create params
func (o *OrganizationServiceCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the organization service create params
func (o *OrganizationServiceCreateParams) WithBody(body *models.HashicorpCloudResourcemanagerOrganizationCreateRequest) *OrganizationServiceCreateParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the organization service create params
func (o *OrganizationServiceCreateParams) SetBody(body *models.HashicorpCloudResourcemanagerOrganizationCreateRequest) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *OrganizationServiceCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
