// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudNetwork20200907NetworkTarget NetworkTarget is a Peering.Target based on another HVN.
//
// swagger:model hashicorp.cloud.network_20200907.NetworkTarget
type HashicorpCloudNetwork20200907NetworkTarget struct {

	// hvn is the managed HVN needing to be peered with.
	Hvn *cloud.HashicorpCloudLocationLink `json:"hvn,omitempty"`
}

// Validate validates this hashicorp cloud network 20200907 network target
func (m *HashicorpCloudNetwork20200907NetworkTarget) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateHvn(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudNetwork20200907NetworkTarget) validateHvn(formats strfmt.Registry) error {
	if swag.IsZero(m.Hvn) { // not required
		return nil
	}

	if m.Hvn != nil {
		if err := m.Hvn.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hvn")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("hvn")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud network 20200907 network target based on the context it is used
func (m *HashicorpCloudNetwork20200907NetworkTarget) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateHvn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudNetwork20200907NetworkTarget) contextValidateHvn(ctx context.Context, formats strfmt.Registry) error {

	if m.Hvn != nil {
		if err := m.Hvn.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hvn")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("hvn")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudNetwork20200907NetworkTarget) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudNetwork20200907NetworkTarget) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudNetwork20200907NetworkTarget
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
