// Code generated by go-swagger; DO NOT EDIT.

package signed_in_user

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetSignedInUserOrgListReader is a Reader for the GetSignedInUserOrgList structure.
type GetSignedInUserOrgListReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetSignedInUserOrgListReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetSignedInUserOrgListOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewGetSignedInUserOrgListUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetSignedInUserOrgListForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetSignedInUserOrgListInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /user/orgs] getSignedInUserOrgList", response, response.Code())
	}
}

// NewGetSignedInUserOrgListOK creates a GetSignedInUserOrgListOK with default headers values
func NewGetSignedInUserOrgListOK() *GetSignedInUserOrgListOK {
	return &GetSignedInUserOrgListOK{}
}

/*
GetSignedInUserOrgListOK describes a response with status code 200, with default header values.

(empty)
*/
type GetSignedInUserOrgListOK struct {
	Payload []*models.UserOrgDTO
}

// IsSuccess returns true when this get signed in user org list Ok response has a 2xx status code
func (o *GetSignedInUserOrgListOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get signed in user org list Ok response has a 3xx status code
func (o *GetSignedInUserOrgListOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get signed in user org list Ok response has a 4xx status code
func (o *GetSignedInUserOrgListOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get signed in user org list Ok response has a 5xx status code
func (o *GetSignedInUserOrgListOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get signed in user org list Ok response a status code equal to that given
func (o *GetSignedInUserOrgListOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get signed in user org list Ok response
func (o *GetSignedInUserOrgListOK) Code() int {
	return 200
}

func (o *GetSignedInUserOrgListOK) Error() string {
	return fmt.Sprintf("[GET /user/orgs][%d] getSignedInUserOrgListOk  %+v", 200, o.Payload)
}

func (o *GetSignedInUserOrgListOK) String() string {
	return fmt.Sprintf("[GET /user/orgs][%d] getSignedInUserOrgListOk  %+v", 200, o.Payload)
}

func (o *GetSignedInUserOrgListOK) GetPayload() []*models.UserOrgDTO {
	return o.Payload
}

func (o *GetSignedInUserOrgListOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSignedInUserOrgListUnauthorized creates a GetSignedInUserOrgListUnauthorized with default headers values
func NewGetSignedInUserOrgListUnauthorized() *GetSignedInUserOrgListUnauthorized {
	return &GetSignedInUserOrgListUnauthorized{}
}

/*
GetSignedInUserOrgListUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetSignedInUserOrgListUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get signed in user org list unauthorized response has a 2xx status code
func (o *GetSignedInUserOrgListUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get signed in user org list unauthorized response has a 3xx status code
func (o *GetSignedInUserOrgListUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get signed in user org list unauthorized response has a 4xx status code
func (o *GetSignedInUserOrgListUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get signed in user org list unauthorized response has a 5xx status code
func (o *GetSignedInUserOrgListUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get signed in user org list unauthorized response a status code equal to that given
func (o *GetSignedInUserOrgListUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get signed in user org list unauthorized response
func (o *GetSignedInUserOrgListUnauthorized) Code() int {
	return 401
}

func (o *GetSignedInUserOrgListUnauthorized) Error() string {
	return fmt.Sprintf("[GET /user/orgs][%d] getSignedInUserOrgListUnauthorized  %+v", 401, o.Payload)
}

func (o *GetSignedInUserOrgListUnauthorized) String() string {
	return fmt.Sprintf("[GET /user/orgs][%d] getSignedInUserOrgListUnauthorized  %+v", 401, o.Payload)
}

func (o *GetSignedInUserOrgListUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetSignedInUserOrgListUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSignedInUserOrgListForbidden creates a GetSignedInUserOrgListForbidden with default headers values
func NewGetSignedInUserOrgListForbidden() *GetSignedInUserOrgListForbidden {
	return &GetSignedInUserOrgListForbidden{}
}

/*
GetSignedInUserOrgListForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetSignedInUserOrgListForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get signed in user org list forbidden response has a 2xx status code
func (o *GetSignedInUserOrgListForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get signed in user org list forbidden response has a 3xx status code
func (o *GetSignedInUserOrgListForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get signed in user org list forbidden response has a 4xx status code
func (o *GetSignedInUserOrgListForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get signed in user org list forbidden response has a 5xx status code
func (o *GetSignedInUserOrgListForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get signed in user org list forbidden response a status code equal to that given
func (o *GetSignedInUserOrgListForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get signed in user org list forbidden response
func (o *GetSignedInUserOrgListForbidden) Code() int {
	return 403
}

func (o *GetSignedInUserOrgListForbidden) Error() string {
	return fmt.Sprintf("[GET /user/orgs][%d] getSignedInUserOrgListForbidden  %+v", 403, o.Payload)
}

func (o *GetSignedInUserOrgListForbidden) String() string {
	return fmt.Sprintf("[GET /user/orgs][%d] getSignedInUserOrgListForbidden  %+v", 403, o.Payload)
}

func (o *GetSignedInUserOrgListForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetSignedInUserOrgListForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSignedInUserOrgListInternalServerError creates a GetSignedInUserOrgListInternalServerError with default headers values
func NewGetSignedInUserOrgListInternalServerError() *GetSignedInUserOrgListInternalServerError {
	return &GetSignedInUserOrgListInternalServerError{}
}

/*
GetSignedInUserOrgListInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetSignedInUserOrgListInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get signed in user org list internal server error response has a 2xx status code
func (o *GetSignedInUserOrgListInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get signed in user org list internal server error response has a 3xx status code
func (o *GetSignedInUserOrgListInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get signed in user org list internal server error response has a 4xx status code
func (o *GetSignedInUserOrgListInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get signed in user org list internal server error response has a 5xx status code
func (o *GetSignedInUserOrgListInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get signed in user org list internal server error response a status code equal to that given
func (o *GetSignedInUserOrgListInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get signed in user org list internal server error response
func (o *GetSignedInUserOrgListInternalServerError) Code() int {
	return 500
}

func (o *GetSignedInUserOrgListInternalServerError) Error() string {
	return fmt.Sprintf("[GET /user/orgs][%d] getSignedInUserOrgListInternalServerError  %+v", 500, o.Payload)
}

func (o *GetSignedInUserOrgListInternalServerError) String() string {
	return fmt.Sprintf("[GET /user/orgs][%d] getSignedInUserOrgListInternalServerError  %+v", 500, o.Payload)
}

func (o *GetSignedInUserOrgListInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetSignedInUserOrgListInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
