// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lookoutequipment

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateDataset = "CreateDataset"

// CreateDatasetRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataset for more information on using the CreateDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDatasetRequest method.
//	req, resp := client.CreateDatasetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateDataset
func (c *LookoutEquipment) CreateDatasetRequest(input *CreateDatasetInput) (req *request.Request, output *CreateDatasetOutput) {
	op := &request.Operation{
		Name:       opCreateDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDatasetInput{}
	}

	output = &CreateDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataset API operation for Amazon Lookout for Equipment.
//
// Creates a container for a collection of data being ingested for analysis.
// The dataset contains the metadata describing where the data is and what the
// data actually looks like. In other words, it contains the location of the
// data source, the data schema, and other information. A dataset also contains
// any tags associated with the ingested data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation CreateDataset for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     Resource limitations have been exceeded.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateDataset
func (c *LookoutEquipment) CreateDataset(input *CreateDatasetInput) (*CreateDatasetOutput, error) {
	req, out := c.CreateDatasetRequest(input)
	return out, req.Send()
}

// CreateDatasetWithContext is the same as CreateDataset with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) CreateDatasetWithContext(ctx aws.Context, input *CreateDatasetInput, opts ...request.Option) (*CreateDatasetOutput, error) {
	req, out := c.CreateDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInferenceScheduler = "CreateInferenceScheduler"

// CreateInferenceSchedulerRequest generates a "aws/request.Request" representing the
// client's request for the CreateInferenceScheduler operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInferenceScheduler for more information on using the CreateInferenceScheduler
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateInferenceSchedulerRequest method.
//	req, resp := client.CreateInferenceSchedulerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateInferenceScheduler
func (c *LookoutEquipment) CreateInferenceSchedulerRequest(input *CreateInferenceSchedulerInput) (req *request.Request, output *CreateInferenceSchedulerOutput) {
	op := &request.Operation{
		Name:       opCreateInferenceScheduler,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInferenceSchedulerInput{}
	}

	output = &CreateInferenceSchedulerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInferenceScheduler API operation for Amazon Lookout for Equipment.
//
// Creates a scheduled inference. Scheduling an inference is setting up a continuous
// real-time inference plan to analyze new measurement data. When setting up
// the schedule, you provide an S3 bucket location for the input data, assign
// it a delimiter between separate entries in the data, set an offset delay
// if desired, and set the frequency of inferencing. You must also provide an
// S3 bucket location for the output data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation CreateInferenceScheduler for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ServiceQuotaExceededException
//     Resource limitations have been exceeded.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateInferenceScheduler
func (c *LookoutEquipment) CreateInferenceScheduler(input *CreateInferenceSchedulerInput) (*CreateInferenceSchedulerOutput, error) {
	req, out := c.CreateInferenceSchedulerRequest(input)
	return out, req.Send()
}

// CreateInferenceSchedulerWithContext is the same as CreateInferenceScheduler with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInferenceScheduler for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) CreateInferenceSchedulerWithContext(ctx aws.Context, input *CreateInferenceSchedulerInput, opts ...request.Option) (*CreateInferenceSchedulerOutput, error) {
	req, out := c.CreateInferenceSchedulerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLabel = "CreateLabel"

// CreateLabelRequest generates a "aws/request.Request" representing the
// client's request for the CreateLabel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLabel for more information on using the CreateLabel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLabelRequest method.
//	req, resp := client.CreateLabelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateLabel
func (c *LookoutEquipment) CreateLabelRequest(input *CreateLabelInput) (req *request.Request, output *CreateLabelOutput) {
	op := &request.Operation{
		Name:       opCreateLabel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLabelInput{}
	}

	output = &CreateLabelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLabel API operation for Amazon Lookout for Equipment.
//
// Creates a label for an event.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation CreateLabel for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     Resource limitations have been exceeded.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateLabel
func (c *LookoutEquipment) CreateLabel(input *CreateLabelInput) (*CreateLabelOutput, error) {
	req, out := c.CreateLabelRequest(input)
	return out, req.Send()
}

// CreateLabelWithContext is the same as CreateLabel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLabel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) CreateLabelWithContext(ctx aws.Context, input *CreateLabelInput, opts ...request.Option) (*CreateLabelOutput, error) {
	req, out := c.CreateLabelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLabelGroup = "CreateLabelGroup"

// CreateLabelGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateLabelGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLabelGroup for more information on using the CreateLabelGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLabelGroupRequest method.
//	req, resp := client.CreateLabelGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateLabelGroup
func (c *LookoutEquipment) CreateLabelGroupRequest(input *CreateLabelGroupInput) (req *request.Request, output *CreateLabelGroupOutput) {
	op := &request.Operation{
		Name:       opCreateLabelGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLabelGroupInput{}
	}

	output = &CreateLabelGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLabelGroup API operation for Amazon Lookout for Equipment.
//
// Creates a group of labels.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation CreateLabelGroup for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     Resource limitations have been exceeded.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateLabelGroup
func (c *LookoutEquipment) CreateLabelGroup(input *CreateLabelGroupInput) (*CreateLabelGroupOutput, error) {
	req, out := c.CreateLabelGroupRequest(input)
	return out, req.Send()
}

// CreateLabelGroupWithContext is the same as CreateLabelGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLabelGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) CreateLabelGroupWithContext(ctx aws.Context, input *CreateLabelGroupInput, opts ...request.Option) (*CreateLabelGroupOutput, error) {
	req, out := c.CreateLabelGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateModel = "CreateModel"

// CreateModelRequest generates a "aws/request.Request" representing the
// client's request for the CreateModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateModel for more information on using the CreateModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateModelRequest method.
//	req, resp := client.CreateModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateModel
func (c *LookoutEquipment) CreateModelRequest(input *CreateModelInput) (req *request.Request, output *CreateModelOutput) {
	op := &request.Operation{
		Name:       opCreateModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateModelInput{}
	}

	output = &CreateModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateModel API operation for Amazon Lookout for Equipment.
//
// Creates an ML model for data inference.
//
// A machine-learning (ML) model is a mathematical model that finds patterns
// in your data. In Amazon Lookout for Equipment, the model learns the patterns
// of normal behavior and detects abnormal behavior that could be potential
// equipment failure (or maintenance events). The models are made by analyzing
// normal data and abnormalities in machine behavior that have already occurred.
//
// Your model is trained using a portion of the data from your dataset and uses
// that data to learn patterns of normal behavior and abnormal patterns that
// lead to equipment failure. Another portion of the data is used to evaluate
// the model's accuracy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation CreateModel for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     Resource limitations have been exceeded.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/CreateModel
func (c *LookoutEquipment) CreateModel(input *CreateModelInput) (*CreateModelOutput, error) {
	req, out := c.CreateModelRequest(input)
	return out, req.Send()
}

// CreateModelWithContext is the same as CreateModel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) CreateModelWithContext(ctx aws.Context, input *CreateModelInput, opts ...request.Option) (*CreateModelOutput, error) {
	req, out := c.CreateModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataset = "DeleteDataset"

// DeleteDatasetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataset for more information on using the DeleteDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDatasetRequest method.
//	req, resp := client.DeleteDatasetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteDataset
func (c *LookoutEquipment) DeleteDatasetRequest(input *DeleteDatasetInput) (req *request.Request, output *DeleteDatasetOutput) {
	op := &request.Operation{
		Name:       opDeleteDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDatasetInput{}
	}

	output = &DeleteDatasetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDataset API operation for Amazon Lookout for Equipment.
//
// Deletes a dataset and associated artifacts. The operation will check to see
// if any inference scheduler or data ingestion job is currently using the dataset,
// and if there isn't, the dataset, its metadata, and any associated data stored
// in S3 will be deleted. This does not affect any models that used this dataset
// for training and evaluation, but does prevent it from being used in the future.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation DeleteDataset for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteDataset
func (c *LookoutEquipment) DeleteDataset(input *DeleteDatasetInput) (*DeleteDatasetOutput, error) {
	req, out := c.DeleteDatasetRequest(input)
	return out, req.Send()
}

// DeleteDatasetWithContext is the same as DeleteDataset with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) DeleteDatasetWithContext(ctx aws.Context, input *DeleteDatasetInput, opts ...request.Option) (*DeleteDatasetOutput, error) {
	req, out := c.DeleteDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInferenceScheduler = "DeleteInferenceScheduler"

// DeleteInferenceSchedulerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInferenceScheduler operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInferenceScheduler for more information on using the DeleteInferenceScheduler
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteInferenceSchedulerRequest method.
//	req, resp := client.DeleteInferenceSchedulerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteInferenceScheduler
func (c *LookoutEquipment) DeleteInferenceSchedulerRequest(input *DeleteInferenceSchedulerInput) (req *request.Request, output *DeleteInferenceSchedulerOutput) {
	op := &request.Operation{
		Name:       opDeleteInferenceScheduler,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInferenceSchedulerInput{}
	}

	output = &DeleteInferenceSchedulerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteInferenceScheduler API operation for Amazon Lookout for Equipment.
//
// Deletes an inference scheduler that has been set up. Already processed output
// results are not affected.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation DeleteInferenceScheduler for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteInferenceScheduler
func (c *LookoutEquipment) DeleteInferenceScheduler(input *DeleteInferenceSchedulerInput) (*DeleteInferenceSchedulerOutput, error) {
	req, out := c.DeleteInferenceSchedulerRequest(input)
	return out, req.Send()
}

// DeleteInferenceSchedulerWithContext is the same as DeleteInferenceScheduler with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInferenceScheduler for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) DeleteInferenceSchedulerWithContext(ctx aws.Context, input *DeleteInferenceSchedulerInput, opts ...request.Option) (*DeleteInferenceSchedulerOutput, error) {
	req, out := c.DeleteInferenceSchedulerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLabel = "DeleteLabel"

// DeleteLabelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLabel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLabel for more information on using the DeleteLabel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLabelRequest method.
//	req, resp := client.DeleteLabelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteLabel
func (c *LookoutEquipment) DeleteLabelRequest(input *DeleteLabelInput) (req *request.Request, output *DeleteLabelOutput) {
	op := &request.Operation{
		Name:       opDeleteLabel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLabelInput{}
	}

	output = &DeleteLabelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLabel API operation for Amazon Lookout for Equipment.
//
// Deletes a label.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation DeleteLabel for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteLabel
func (c *LookoutEquipment) DeleteLabel(input *DeleteLabelInput) (*DeleteLabelOutput, error) {
	req, out := c.DeleteLabelRequest(input)
	return out, req.Send()
}

// DeleteLabelWithContext is the same as DeleteLabel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLabel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) DeleteLabelWithContext(ctx aws.Context, input *DeleteLabelInput, opts ...request.Option) (*DeleteLabelOutput, error) {
	req, out := c.DeleteLabelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLabelGroup = "DeleteLabelGroup"

// DeleteLabelGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLabelGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLabelGroup for more information on using the DeleteLabelGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLabelGroupRequest method.
//	req, resp := client.DeleteLabelGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteLabelGroup
func (c *LookoutEquipment) DeleteLabelGroupRequest(input *DeleteLabelGroupInput) (req *request.Request, output *DeleteLabelGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteLabelGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLabelGroupInput{}
	}

	output = &DeleteLabelGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLabelGroup API operation for Amazon Lookout for Equipment.
//
// Deletes a group of labels.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation DeleteLabelGroup for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteLabelGroup
func (c *LookoutEquipment) DeleteLabelGroup(input *DeleteLabelGroupInput) (*DeleteLabelGroupOutput, error) {
	req, out := c.DeleteLabelGroupRequest(input)
	return out, req.Send()
}

// DeleteLabelGroupWithContext is the same as DeleteLabelGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLabelGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) DeleteLabelGroupWithContext(ctx aws.Context, input *DeleteLabelGroupInput, opts ...request.Option) (*DeleteLabelGroupOutput, error) {
	req, out := c.DeleteLabelGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteModel = "DeleteModel"

// DeleteModelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteModel for more information on using the DeleteModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteModelRequest method.
//	req, resp := client.DeleteModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteModel
func (c *LookoutEquipment) DeleteModelRequest(input *DeleteModelInput) (req *request.Request, output *DeleteModelOutput) {
	op := &request.Operation{
		Name:       opDeleteModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteModelInput{}
	}

	output = &DeleteModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteModel API operation for Amazon Lookout for Equipment.
//
// Deletes an ML model currently available for Amazon Lookout for Equipment.
// This will prevent it from being used with an inference scheduler, even one
// that is already set up.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation DeleteModel for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DeleteModel
func (c *LookoutEquipment) DeleteModel(input *DeleteModelInput) (*DeleteModelOutput, error) {
	req, out := c.DeleteModelRequest(input)
	return out, req.Send()
}

// DeleteModelWithContext is the same as DeleteModel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) DeleteModelWithContext(ctx aws.Context, input *DeleteModelInput, opts ...request.Option) (*DeleteModelOutput, error) {
	req, out := c.DeleteModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataIngestionJob = "DescribeDataIngestionJob"

// DescribeDataIngestionJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataIngestionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataIngestionJob for more information on using the DescribeDataIngestionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDataIngestionJobRequest method.
//	req, resp := client.DescribeDataIngestionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeDataIngestionJob
func (c *LookoutEquipment) DescribeDataIngestionJobRequest(input *DescribeDataIngestionJobInput) (req *request.Request, output *DescribeDataIngestionJobOutput) {
	op := &request.Operation{
		Name:       opDescribeDataIngestionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDataIngestionJobInput{}
	}

	output = &DescribeDataIngestionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataIngestionJob API operation for Amazon Lookout for Equipment.
//
// Provides information on a specific data ingestion job such as creation time,
// dataset ARN, and status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation DescribeDataIngestionJob for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeDataIngestionJob
func (c *LookoutEquipment) DescribeDataIngestionJob(input *DescribeDataIngestionJobInput) (*DescribeDataIngestionJobOutput, error) {
	req, out := c.DescribeDataIngestionJobRequest(input)
	return out, req.Send()
}

// DescribeDataIngestionJobWithContext is the same as DescribeDataIngestionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataIngestionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) DescribeDataIngestionJobWithContext(ctx aws.Context, input *DescribeDataIngestionJobInput, opts ...request.Option) (*DescribeDataIngestionJobOutput, error) {
	req, out := c.DescribeDataIngestionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataset = "DescribeDataset"

// DescribeDatasetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataset for more information on using the DescribeDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDatasetRequest method.
//	req, resp := client.DescribeDatasetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeDataset
func (c *LookoutEquipment) DescribeDatasetRequest(input *DescribeDatasetInput) (req *request.Request, output *DescribeDatasetOutput) {
	op := &request.Operation{
		Name:       opDescribeDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDatasetInput{}
	}

	output = &DescribeDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataset API operation for Amazon Lookout for Equipment.
//
// Provides a JSON description of the data in each time series dataset, including
// names, column names, and data types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation DescribeDataset for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeDataset
func (c *LookoutEquipment) DescribeDataset(input *DescribeDatasetInput) (*DescribeDatasetOutput, error) {
	req, out := c.DescribeDatasetRequest(input)
	return out, req.Send()
}

// DescribeDatasetWithContext is the same as DescribeDataset with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) DescribeDatasetWithContext(ctx aws.Context, input *DescribeDatasetInput, opts ...request.Option) (*DescribeDatasetOutput, error) {
	req, out := c.DescribeDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInferenceScheduler = "DescribeInferenceScheduler"

// DescribeInferenceSchedulerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInferenceScheduler operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInferenceScheduler for more information on using the DescribeInferenceScheduler
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInferenceSchedulerRequest method.
//	req, resp := client.DescribeInferenceSchedulerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeInferenceScheduler
func (c *LookoutEquipment) DescribeInferenceSchedulerRequest(input *DescribeInferenceSchedulerInput) (req *request.Request, output *DescribeInferenceSchedulerOutput) {
	op := &request.Operation{
		Name:       opDescribeInferenceScheduler,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInferenceSchedulerInput{}
	}

	output = &DescribeInferenceSchedulerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInferenceScheduler API operation for Amazon Lookout for Equipment.
//
// Specifies information about the inference scheduler being used, including
// name, model, status, and associated metadata
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation DescribeInferenceScheduler for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeInferenceScheduler
func (c *LookoutEquipment) DescribeInferenceScheduler(input *DescribeInferenceSchedulerInput) (*DescribeInferenceSchedulerOutput, error) {
	req, out := c.DescribeInferenceSchedulerRequest(input)
	return out, req.Send()
}

// DescribeInferenceSchedulerWithContext is the same as DescribeInferenceScheduler with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInferenceScheduler for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) DescribeInferenceSchedulerWithContext(ctx aws.Context, input *DescribeInferenceSchedulerInput, opts ...request.Option) (*DescribeInferenceSchedulerOutput, error) {
	req, out := c.DescribeInferenceSchedulerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLabel = "DescribeLabel"

// DescribeLabelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLabel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLabel for more information on using the DescribeLabel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeLabelRequest method.
//	req, resp := client.DescribeLabelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeLabel
func (c *LookoutEquipment) DescribeLabelRequest(input *DescribeLabelInput) (req *request.Request, output *DescribeLabelOutput) {
	op := &request.Operation{
		Name:       opDescribeLabel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLabelInput{}
	}

	output = &DescribeLabelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLabel API operation for Amazon Lookout for Equipment.
//
// Returns the name of the label.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation DescribeLabel for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeLabel
func (c *LookoutEquipment) DescribeLabel(input *DescribeLabelInput) (*DescribeLabelOutput, error) {
	req, out := c.DescribeLabelRequest(input)
	return out, req.Send()
}

// DescribeLabelWithContext is the same as DescribeLabel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLabel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) DescribeLabelWithContext(ctx aws.Context, input *DescribeLabelInput, opts ...request.Option) (*DescribeLabelOutput, error) {
	req, out := c.DescribeLabelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLabelGroup = "DescribeLabelGroup"

// DescribeLabelGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLabelGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLabelGroup for more information on using the DescribeLabelGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeLabelGroupRequest method.
//	req, resp := client.DescribeLabelGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeLabelGroup
func (c *LookoutEquipment) DescribeLabelGroupRequest(input *DescribeLabelGroupInput) (req *request.Request, output *DescribeLabelGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeLabelGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLabelGroupInput{}
	}

	output = &DescribeLabelGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLabelGroup API operation for Amazon Lookout for Equipment.
//
// Returns information about the label group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation DescribeLabelGroup for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeLabelGroup
func (c *LookoutEquipment) DescribeLabelGroup(input *DescribeLabelGroupInput) (*DescribeLabelGroupOutput, error) {
	req, out := c.DescribeLabelGroupRequest(input)
	return out, req.Send()
}

// DescribeLabelGroupWithContext is the same as DescribeLabelGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLabelGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) DescribeLabelGroupWithContext(ctx aws.Context, input *DescribeLabelGroupInput, opts ...request.Option) (*DescribeLabelGroupOutput, error) {
	req, out := c.DescribeLabelGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeModel = "DescribeModel"

// DescribeModelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeModel for more information on using the DescribeModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeModelRequest method.
//	req, resp := client.DescribeModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeModel
func (c *LookoutEquipment) DescribeModelRequest(input *DescribeModelInput) (req *request.Request, output *DescribeModelOutput) {
	op := &request.Operation{
		Name:       opDescribeModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeModelInput{}
	}

	output = &DescribeModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeModel API operation for Amazon Lookout for Equipment.
//
// Provides a JSON containing the overall information about a specific ML model,
// including model name and ARN, dataset, training and evaluation information,
// status, and so on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation DescribeModel for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeModel
func (c *LookoutEquipment) DescribeModel(input *DescribeModelInput) (*DescribeModelOutput, error) {
	req, out := c.DescribeModelRequest(input)
	return out, req.Send()
}

// DescribeModelWithContext is the same as DescribeModel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) DescribeModelWithContext(ctx aws.Context, input *DescribeModelInput, opts ...request.Option) (*DescribeModelOutput, error) {
	req, out := c.DescribeModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDataIngestionJobs = "ListDataIngestionJobs"

// ListDataIngestionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListDataIngestionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataIngestionJobs for more information on using the ListDataIngestionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDataIngestionJobsRequest method.
//	req, resp := client.ListDataIngestionJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListDataIngestionJobs
func (c *LookoutEquipment) ListDataIngestionJobsRequest(input *ListDataIngestionJobsInput) (req *request.Request, output *ListDataIngestionJobsOutput) {
	op := &request.Operation{
		Name:       opListDataIngestionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataIngestionJobsInput{}
	}

	output = &ListDataIngestionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataIngestionJobs API operation for Amazon Lookout for Equipment.
//
// Provides a list of all data ingestion jobs, including dataset name and ARN,
// S3 location of the input data, status, and so on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation ListDataIngestionJobs for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListDataIngestionJobs
func (c *LookoutEquipment) ListDataIngestionJobs(input *ListDataIngestionJobsInput) (*ListDataIngestionJobsOutput, error) {
	req, out := c.ListDataIngestionJobsRequest(input)
	return out, req.Send()
}

// ListDataIngestionJobsWithContext is the same as ListDataIngestionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataIngestionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) ListDataIngestionJobsWithContext(ctx aws.Context, input *ListDataIngestionJobsInput, opts ...request.Option) (*ListDataIngestionJobsOutput, error) {
	req, out := c.ListDataIngestionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataIngestionJobsPages iterates over the pages of a ListDataIngestionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataIngestionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDataIngestionJobs operation.
//	pageNum := 0
//	err := client.ListDataIngestionJobsPages(params,
//	    func(page *lookoutequipment.ListDataIngestionJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LookoutEquipment) ListDataIngestionJobsPages(input *ListDataIngestionJobsInput, fn func(*ListDataIngestionJobsOutput, bool) bool) error {
	return c.ListDataIngestionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataIngestionJobsPagesWithContext same as ListDataIngestionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) ListDataIngestionJobsPagesWithContext(ctx aws.Context, input *ListDataIngestionJobsInput, fn func(*ListDataIngestionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataIngestionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataIngestionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataIngestionJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDatasets = "ListDatasets"

// ListDatasetsRequest generates a "aws/request.Request" representing the
// client's request for the ListDatasets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatasets for more information on using the ListDatasets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDatasetsRequest method.
//	req, resp := client.ListDatasetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListDatasets
func (c *LookoutEquipment) ListDatasetsRequest(input *ListDatasetsInput) (req *request.Request, output *ListDatasetsOutput) {
	op := &request.Operation{
		Name:       opListDatasets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatasetsInput{}
	}

	output = &ListDatasetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatasets API operation for Amazon Lookout for Equipment.
//
// Lists all datasets currently available in your account, filtering on the
// dataset name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation ListDatasets for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListDatasets
func (c *LookoutEquipment) ListDatasets(input *ListDatasetsInput) (*ListDatasetsOutput, error) {
	req, out := c.ListDatasetsRequest(input)
	return out, req.Send()
}

// ListDatasetsWithContext is the same as ListDatasets with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatasets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) ListDatasetsWithContext(ctx aws.Context, input *ListDatasetsInput, opts ...request.Option) (*ListDatasetsOutput, error) {
	req, out := c.ListDatasetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatasetsPages iterates over the pages of a ListDatasets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatasets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDatasets operation.
//	pageNum := 0
//	err := client.ListDatasetsPages(params,
//	    func(page *lookoutequipment.ListDatasetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LookoutEquipment) ListDatasetsPages(input *ListDatasetsInput, fn func(*ListDatasetsOutput, bool) bool) error {
	return c.ListDatasetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatasetsPagesWithContext same as ListDatasetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) ListDatasetsPagesWithContext(ctx aws.Context, input *ListDatasetsInput, fn func(*ListDatasetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatasetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatasetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDatasetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInferenceEvents = "ListInferenceEvents"

// ListInferenceEventsRequest generates a "aws/request.Request" representing the
// client's request for the ListInferenceEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInferenceEvents for more information on using the ListInferenceEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListInferenceEventsRequest method.
//	req, resp := client.ListInferenceEventsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceEvents
func (c *LookoutEquipment) ListInferenceEventsRequest(input *ListInferenceEventsInput) (req *request.Request, output *ListInferenceEventsOutput) {
	op := &request.Operation{
		Name:       opListInferenceEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInferenceEventsInput{}
	}

	output = &ListInferenceEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInferenceEvents API operation for Amazon Lookout for Equipment.
//
// Lists all inference events that have been found for the specified inference
// scheduler.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation ListInferenceEvents for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceEvents
func (c *LookoutEquipment) ListInferenceEvents(input *ListInferenceEventsInput) (*ListInferenceEventsOutput, error) {
	req, out := c.ListInferenceEventsRequest(input)
	return out, req.Send()
}

// ListInferenceEventsWithContext is the same as ListInferenceEvents with the addition of
// the ability to pass a context and additional request options.
//
// See ListInferenceEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) ListInferenceEventsWithContext(ctx aws.Context, input *ListInferenceEventsInput, opts ...request.Option) (*ListInferenceEventsOutput, error) {
	req, out := c.ListInferenceEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInferenceEventsPages iterates over the pages of a ListInferenceEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInferenceEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListInferenceEvents operation.
//	pageNum := 0
//	err := client.ListInferenceEventsPages(params,
//	    func(page *lookoutequipment.ListInferenceEventsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LookoutEquipment) ListInferenceEventsPages(input *ListInferenceEventsInput, fn func(*ListInferenceEventsOutput, bool) bool) error {
	return c.ListInferenceEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInferenceEventsPagesWithContext same as ListInferenceEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) ListInferenceEventsPagesWithContext(ctx aws.Context, input *ListInferenceEventsInput, fn func(*ListInferenceEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInferenceEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInferenceEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInferenceEventsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInferenceExecutions = "ListInferenceExecutions"

// ListInferenceExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListInferenceExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInferenceExecutions for more information on using the ListInferenceExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListInferenceExecutionsRequest method.
//	req, resp := client.ListInferenceExecutionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceExecutions
func (c *LookoutEquipment) ListInferenceExecutionsRequest(input *ListInferenceExecutionsInput) (req *request.Request, output *ListInferenceExecutionsOutput) {
	op := &request.Operation{
		Name:       opListInferenceExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInferenceExecutionsInput{}
	}

	output = &ListInferenceExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInferenceExecutions API operation for Amazon Lookout for Equipment.
//
// Lists all inference executions that have been performed by the specified
// inference scheduler.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation ListInferenceExecutions for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceExecutions
func (c *LookoutEquipment) ListInferenceExecutions(input *ListInferenceExecutionsInput) (*ListInferenceExecutionsOutput, error) {
	req, out := c.ListInferenceExecutionsRequest(input)
	return out, req.Send()
}

// ListInferenceExecutionsWithContext is the same as ListInferenceExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListInferenceExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) ListInferenceExecutionsWithContext(ctx aws.Context, input *ListInferenceExecutionsInput, opts ...request.Option) (*ListInferenceExecutionsOutput, error) {
	req, out := c.ListInferenceExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInferenceExecutionsPages iterates over the pages of a ListInferenceExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInferenceExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListInferenceExecutions operation.
//	pageNum := 0
//	err := client.ListInferenceExecutionsPages(params,
//	    func(page *lookoutequipment.ListInferenceExecutionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LookoutEquipment) ListInferenceExecutionsPages(input *ListInferenceExecutionsInput, fn func(*ListInferenceExecutionsOutput, bool) bool) error {
	return c.ListInferenceExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInferenceExecutionsPagesWithContext same as ListInferenceExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) ListInferenceExecutionsPagesWithContext(ctx aws.Context, input *ListInferenceExecutionsInput, fn func(*ListInferenceExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInferenceExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInferenceExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInferenceExecutionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInferenceSchedulers = "ListInferenceSchedulers"

// ListInferenceSchedulersRequest generates a "aws/request.Request" representing the
// client's request for the ListInferenceSchedulers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInferenceSchedulers for more information on using the ListInferenceSchedulers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListInferenceSchedulersRequest method.
//	req, resp := client.ListInferenceSchedulersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceSchedulers
func (c *LookoutEquipment) ListInferenceSchedulersRequest(input *ListInferenceSchedulersInput) (req *request.Request, output *ListInferenceSchedulersOutput) {
	op := &request.Operation{
		Name:       opListInferenceSchedulers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInferenceSchedulersInput{}
	}

	output = &ListInferenceSchedulersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInferenceSchedulers API operation for Amazon Lookout for Equipment.
//
// Retrieves a list of all inference schedulers currently available for your
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation ListInferenceSchedulers for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListInferenceSchedulers
func (c *LookoutEquipment) ListInferenceSchedulers(input *ListInferenceSchedulersInput) (*ListInferenceSchedulersOutput, error) {
	req, out := c.ListInferenceSchedulersRequest(input)
	return out, req.Send()
}

// ListInferenceSchedulersWithContext is the same as ListInferenceSchedulers with the addition of
// the ability to pass a context and additional request options.
//
// See ListInferenceSchedulers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) ListInferenceSchedulersWithContext(ctx aws.Context, input *ListInferenceSchedulersInput, opts ...request.Option) (*ListInferenceSchedulersOutput, error) {
	req, out := c.ListInferenceSchedulersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInferenceSchedulersPages iterates over the pages of a ListInferenceSchedulers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInferenceSchedulers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListInferenceSchedulers operation.
//	pageNum := 0
//	err := client.ListInferenceSchedulersPages(params,
//	    func(page *lookoutequipment.ListInferenceSchedulersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LookoutEquipment) ListInferenceSchedulersPages(input *ListInferenceSchedulersInput, fn func(*ListInferenceSchedulersOutput, bool) bool) error {
	return c.ListInferenceSchedulersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInferenceSchedulersPagesWithContext same as ListInferenceSchedulersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) ListInferenceSchedulersPagesWithContext(ctx aws.Context, input *ListInferenceSchedulersInput, fn func(*ListInferenceSchedulersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInferenceSchedulersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInferenceSchedulersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInferenceSchedulersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLabelGroups = "ListLabelGroups"

// ListLabelGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListLabelGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLabelGroups for more information on using the ListLabelGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLabelGroupsRequest method.
//	req, resp := client.ListLabelGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListLabelGroups
func (c *LookoutEquipment) ListLabelGroupsRequest(input *ListLabelGroupsInput) (req *request.Request, output *ListLabelGroupsOutput) {
	op := &request.Operation{
		Name:       opListLabelGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLabelGroupsInput{}
	}

	output = &ListLabelGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLabelGroups API operation for Amazon Lookout for Equipment.
//
// Returns a list of the label groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation ListLabelGroups for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListLabelGroups
func (c *LookoutEquipment) ListLabelGroups(input *ListLabelGroupsInput) (*ListLabelGroupsOutput, error) {
	req, out := c.ListLabelGroupsRequest(input)
	return out, req.Send()
}

// ListLabelGroupsWithContext is the same as ListLabelGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListLabelGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) ListLabelGroupsWithContext(ctx aws.Context, input *ListLabelGroupsInput, opts ...request.Option) (*ListLabelGroupsOutput, error) {
	req, out := c.ListLabelGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLabelGroupsPages iterates over the pages of a ListLabelGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLabelGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLabelGroups operation.
//	pageNum := 0
//	err := client.ListLabelGroupsPages(params,
//	    func(page *lookoutequipment.ListLabelGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LookoutEquipment) ListLabelGroupsPages(input *ListLabelGroupsInput, fn func(*ListLabelGroupsOutput, bool) bool) error {
	return c.ListLabelGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLabelGroupsPagesWithContext same as ListLabelGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) ListLabelGroupsPagesWithContext(ctx aws.Context, input *ListLabelGroupsInput, fn func(*ListLabelGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLabelGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLabelGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLabelGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLabels = "ListLabels"

// ListLabelsRequest generates a "aws/request.Request" representing the
// client's request for the ListLabels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLabels for more information on using the ListLabels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLabelsRequest method.
//	req, resp := client.ListLabelsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListLabels
func (c *LookoutEquipment) ListLabelsRequest(input *ListLabelsInput) (req *request.Request, output *ListLabelsOutput) {
	op := &request.Operation{
		Name:       opListLabels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLabelsInput{}
	}

	output = &ListLabelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLabels API operation for Amazon Lookout for Equipment.
//
// Provides a list of labels.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation ListLabels for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListLabels
func (c *LookoutEquipment) ListLabels(input *ListLabelsInput) (*ListLabelsOutput, error) {
	req, out := c.ListLabelsRequest(input)
	return out, req.Send()
}

// ListLabelsWithContext is the same as ListLabels with the addition of
// the ability to pass a context and additional request options.
//
// See ListLabels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) ListLabelsWithContext(ctx aws.Context, input *ListLabelsInput, opts ...request.Option) (*ListLabelsOutput, error) {
	req, out := c.ListLabelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLabelsPages iterates over the pages of a ListLabels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLabels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLabels operation.
//	pageNum := 0
//	err := client.ListLabelsPages(params,
//	    func(page *lookoutequipment.ListLabelsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LookoutEquipment) ListLabelsPages(input *ListLabelsInput, fn func(*ListLabelsOutput, bool) bool) error {
	return c.ListLabelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLabelsPagesWithContext same as ListLabelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) ListLabelsPagesWithContext(ctx aws.Context, input *ListLabelsInput, fn func(*ListLabelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLabelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLabelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLabelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListModels = "ListModels"

// ListModelsRequest generates a "aws/request.Request" representing the
// client's request for the ListModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListModels for more information on using the ListModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListModelsRequest method.
//	req, resp := client.ListModelsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListModels
func (c *LookoutEquipment) ListModelsRequest(input *ListModelsInput) (req *request.Request, output *ListModelsOutput) {
	op := &request.Operation{
		Name:       opListModels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListModelsInput{}
	}

	output = &ListModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListModels API operation for Amazon Lookout for Equipment.
//
// Generates a list of all models in the account, including model name and ARN,
// dataset, and status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation ListModels for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListModels
func (c *LookoutEquipment) ListModels(input *ListModelsInput) (*ListModelsOutput, error) {
	req, out := c.ListModelsRequest(input)
	return out, req.Send()
}

// ListModelsWithContext is the same as ListModels with the addition of
// the ability to pass a context and additional request options.
//
// See ListModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) ListModelsWithContext(ctx aws.Context, input *ListModelsInput, opts ...request.Option) (*ListModelsOutput, error) {
	req, out := c.ListModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListModelsPages iterates over the pages of a ListModels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListModels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListModels operation.
//	pageNum := 0
//	err := client.ListModelsPages(params,
//	    func(page *lookoutequipment.ListModelsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LookoutEquipment) ListModelsPages(input *ListModelsInput, fn func(*ListModelsOutput, bool) bool) error {
	return c.ListModelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListModelsPagesWithContext same as ListModelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) ListModelsPagesWithContext(ctx aws.Context, input *ListModelsInput, fn func(*ListModelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListModelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListModelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListModelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSensorStatistics = "ListSensorStatistics"

// ListSensorStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the ListSensorStatistics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSensorStatistics for more information on using the ListSensorStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSensorStatisticsRequest method.
//	req, resp := client.ListSensorStatisticsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListSensorStatistics
func (c *LookoutEquipment) ListSensorStatisticsRequest(input *ListSensorStatisticsInput) (req *request.Request, output *ListSensorStatisticsOutput) {
	op := &request.Operation{
		Name:       opListSensorStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSensorStatisticsInput{}
	}

	output = &ListSensorStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSensorStatistics API operation for Amazon Lookout for Equipment.
//
// Lists statistics about the data collected for each of the sensors that have
// been successfully ingested in the particular dataset. Can also be used to
// retreive Sensor Statistics for a previous ingestion job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation ListSensorStatistics for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListSensorStatistics
func (c *LookoutEquipment) ListSensorStatistics(input *ListSensorStatisticsInput) (*ListSensorStatisticsOutput, error) {
	req, out := c.ListSensorStatisticsRequest(input)
	return out, req.Send()
}

// ListSensorStatisticsWithContext is the same as ListSensorStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See ListSensorStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) ListSensorStatisticsWithContext(ctx aws.Context, input *ListSensorStatisticsInput, opts ...request.Option) (*ListSensorStatisticsOutput, error) {
	req, out := c.ListSensorStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSensorStatisticsPages iterates over the pages of a ListSensorStatistics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSensorStatistics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSensorStatistics operation.
//	pageNum := 0
//	err := client.ListSensorStatisticsPages(params,
//	    func(page *lookoutequipment.ListSensorStatisticsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LookoutEquipment) ListSensorStatisticsPages(input *ListSensorStatisticsInput, fn func(*ListSensorStatisticsOutput, bool) bool) error {
	return c.ListSensorStatisticsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSensorStatisticsPagesWithContext same as ListSensorStatisticsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) ListSensorStatisticsPagesWithContext(ctx aws.Context, input *ListSensorStatisticsInput, fn func(*ListSensorStatisticsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSensorStatisticsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSensorStatisticsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSensorStatisticsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListTagsForResource
func (c *LookoutEquipment) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Lookout for Equipment.
//
// Lists all the tags for a specified resource, including key and value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/ListTagsForResource
func (c *LookoutEquipment) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDataIngestionJob = "StartDataIngestionJob"

// StartDataIngestionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartDataIngestionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDataIngestionJob for more information on using the StartDataIngestionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartDataIngestionJobRequest method.
//	req, resp := client.StartDataIngestionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/StartDataIngestionJob
func (c *LookoutEquipment) StartDataIngestionJobRequest(input *StartDataIngestionJobInput) (req *request.Request, output *StartDataIngestionJobOutput) {
	op := &request.Operation{
		Name:       opStartDataIngestionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDataIngestionJobInput{}
	}

	output = &StartDataIngestionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDataIngestionJob API operation for Amazon Lookout for Equipment.
//
// Starts a data ingestion job. Amazon Lookout for Equipment returns the job
// status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation StartDataIngestionJob for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     Resource limitations have been exceeded.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/StartDataIngestionJob
func (c *LookoutEquipment) StartDataIngestionJob(input *StartDataIngestionJobInput) (*StartDataIngestionJobOutput, error) {
	req, out := c.StartDataIngestionJobRequest(input)
	return out, req.Send()
}

// StartDataIngestionJobWithContext is the same as StartDataIngestionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartDataIngestionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) StartDataIngestionJobWithContext(ctx aws.Context, input *StartDataIngestionJobInput, opts ...request.Option) (*StartDataIngestionJobOutput, error) {
	req, out := c.StartDataIngestionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartInferenceScheduler = "StartInferenceScheduler"

// StartInferenceSchedulerRequest generates a "aws/request.Request" representing the
// client's request for the StartInferenceScheduler operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartInferenceScheduler for more information on using the StartInferenceScheduler
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartInferenceSchedulerRequest method.
//	req, resp := client.StartInferenceSchedulerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/StartInferenceScheduler
func (c *LookoutEquipment) StartInferenceSchedulerRequest(input *StartInferenceSchedulerInput) (req *request.Request, output *StartInferenceSchedulerOutput) {
	op := &request.Operation{
		Name:       opStartInferenceScheduler,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartInferenceSchedulerInput{}
	}

	output = &StartInferenceSchedulerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartInferenceScheduler API operation for Amazon Lookout for Equipment.
//
// Starts an inference scheduler.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation StartInferenceScheduler for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/StartInferenceScheduler
func (c *LookoutEquipment) StartInferenceScheduler(input *StartInferenceSchedulerInput) (*StartInferenceSchedulerOutput, error) {
	req, out := c.StartInferenceSchedulerRequest(input)
	return out, req.Send()
}

// StartInferenceSchedulerWithContext is the same as StartInferenceScheduler with the addition of
// the ability to pass a context and additional request options.
//
// See StartInferenceScheduler for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) StartInferenceSchedulerWithContext(ctx aws.Context, input *StartInferenceSchedulerInput, opts ...request.Option) (*StartInferenceSchedulerOutput, error) {
	req, out := c.StartInferenceSchedulerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopInferenceScheduler = "StopInferenceScheduler"

// StopInferenceSchedulerRequest generates a "aws/request.Request" representing the
// client's request for the StopInferenceScheduler operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopInferenceScheduler for more information on using the StopInferenceScheduler
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopInferenceSchedulerRequest method.
//	req, resp := client.StopInferenceSchedulerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/StopInferenceScheduler
func (c *LookoutEquipment) StopInferenceSchedulerRequest(input *StopInferenceSchedulerInput) (req *request.Request, output *StopInferenceSchedulerOutput) {
	op := &request.Operation{
		Name:       opStopInferenceScheduler,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopInferenceSchedulerInput{}
	}

	output = &StopInferenceSchedulerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopInferenceScheduler API operation for Amazon Lookout for Equipment.
//
// Stops an inference scheduler.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation StopInferenceScheduler for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/StopInferenceScheduler
func (c *LookoutEquipment) StopInferenceScheduler(input *StopInferenceSchedulerInput) (*StopInferenceSchedulerOutput, error) {
	req, out := c.StopInferenceSchedulerRequest(input)
	return out, req.Send()
}

// StopInferenceSchedulerWithContext is the same as StopInferenceScheduler with the addition of
// the ability to pass a context and additional request options.
//
// See StopInferenceScheduler for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) StopInferenceSchedulerWithContext(ctx aws.Context, input *StopInferenceSchedulerInput, opts ...request.Option) (*StopInferenceSchedulerOutput, error) {
	req, out := c.StopInferenceSchedulerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/TagResource
func (c *LookoutEquipment) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Lookout for Equipment.
//
// Associates a given tag to a resource in your account. A tag is a key-value
// pair which can be added to an Amazon Lookout for Equipment resource as metadata.
// Tags can be used for organizing your resources as well as helping you to
// search and filter by tag. Multiple tags can be added to a resource, either
// when you create it, or later. Up to 50 tags can be associated with each resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - ServiceQuotaExceededException
//     Resource limitations have been exceeded.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/TagResource
func (c *LookoutEquipment) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UntagResource
func (c *LookoutEquipment) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Lookout for Equipment.
//
// Removes a specific tag from a given resource. The tag is specified by its
// key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UntagResource
func (c *LookoutEquipment) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInferenceScheduler = "UpdateInferenceScheduler"

// UpdateInferenceSchedulerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInferenceScheduler operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInferenceScheduler for more information on using the UpdateInferenceScheduler
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateInferenceSchedulerRequest method.
//	req, resp := client.UpdateInferenceSchedulerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UpdateInferenceScheduler
func (c *LookoutEquipment) UpdateInferenceSchedulerRequest(input *UpdateInferenceSchedulerInput) (req *request.Request, output *UpdateInferenceSchedulerOutput) {
	op := &request.Operation{
		Name:       opUpdateInferenceScheduler,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateInferenceSchedulerInput{}
	}

	output = &UpdateInferenceSchedulerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateInferenceScheduler API operation for Amazon Lookout for Equipment.
//
// Updates an inference scheduler.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation UpdateInferenceScheduler for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UpdateInferenceScheduler
func (c *LookoutEquipment) UpdateInferenceScheduler(input *UpdateInferenceSchedulerInput) (*UpdateInferenceSchedulerOutput, error) {
	req, out := c.UpdateInferenceSchedulerRequest(input)
	return out, req.Send()
}

// UpdateInferenceSchedulerWithContext is the same as UpdateInferenceScheduler with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInferenceScheduler for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) UpdateInferenceSchedulerWithContext(ctx aws.Context, input *UpdateInferenceSchedulerInput, opts ...request.Option) (*UpdateInferenceSchedulerOutput, error) {
	req, out := c.UpdateInferenceSchedulerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLabelGroup = "UpdateLabelGroup"

// UpdateLabelGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLabelGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLabelGroup for more information on using the UpdateLabelGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateLabelGroupRequest method.
//	req, resp := client.UpdateLabelGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UpdateLabelGroup
func (c *LookoutEquipment) UpdateLabelGroupRequest(input *UpdateLabelGroupInput) (req *request.Request, output *UpdateLabelGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateLabelGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateLabelGroupInput{}
	}

	output = &UpdateLabelGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateLabelGroup API operation for Amazon Lookout for Equipment.
//
// Updates the label group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Equipment's
// API operation UpdateLabelGroup for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     The request could not be completed due to a conflict with the current state
//     of the target resource.
//
//   - ResourceNotFoundException
//     The resource requested could not be found. Verify the resource ID and retry
//     your request.
//
//   - ValidationException
//     The input fails to satisfy constraints specified by Amazon Lookout for Equipment
//     or a related AWS service that's being utilized.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     The request could not be completed because you do not have access to the
//     resource.
//
//   - InternalServerException
//     Processing of the request has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/UpdateLabelGroup
func (c *LookoutEquipment) UpdateLabelGroup(input *UpdateLabelGroupInput) (*UpdateLabelGroupOutput, error) {
	req, out := c.UpdateLabelGroupRequest(input)
	return out, req.Send()
}

// UpdateLabelGroupWithContext is the same as UpdateLabelGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLabelGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutEquipment) UpdateLabelGroupWithContext(ctx aws.Context, input *UpdateLabelGroupInput, opts ...request.Option) (*UpdateLabelGroupOutput, error) {
	req, out := c.UpdateLabelGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The request could not be completed because you do not have access to the
// resource.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Entity that comprises information on categorical values in data.
type CategoricalValues struct {
	_ struct{} `type:"structure"`

	// Indicates the number of categories in the data.
	NumberOfCategory *int64 `type:"integer"`

	// Indicates whether there is a potential data issue related to categorical
	// values.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"StatisticalIssueStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CategoricalValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CategoricalValues) GoString() string {
	return s.String()
}

// SetNumberOfCategory sets the NumberOfCategory field's value.
func (s *CategoricalValues) SetNumberOfCategory(v int64) *CategoricalValues {
	s.NumberOfCategory = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CategoricalValues) SetStatus(v string) *CategoricalValues {
	s.Status = &v
	return s
}

// The request could not be completed due to a conflict with the current state
// of the target resource.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Entity that comprises information of count and percentage.
type CountPercent struct {
	_ struct{} `type:"structure"`

	// Indicates the count of occurences of the given statistic.
	//
	// Count is a required field
	Count *int64 `type:"integer" required:"true"`

	// Indicates the percentage of occurances of the given statistic.
	//
	// Percentage is a required field
	Percentage *float64 `type:"float" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CountPercent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CountPercent) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *CountPercent) SetCount(v int64) *CountPercent {
	s.Count = &v
	return s
}

// SetPercentage sets the Percentage field's value.
func (s *CountPercent) SetPercentage(v float64) *CountPercent {
	s.Percentage = &v
	return s
}

type CreateDatasetInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you do not set the client request
	// token, Amazon Lookout for Equipment generates one.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The name of the dataset being created.
	//
	// DatasetName is a required field
	DatasetName *string `min:"1" type:"string" required:"true"`

	// A JSON description of the data that is in each time series dataset, including
	// names, column names, and data types.
	DatasetSchema *DatasetSchema `type:"structure"`

	// Provides the identifier of the KMS key used to encrypt dataset data by Amazon
	// Lookout for Equipment.
	ServerSideKmsKeyId *string `min:"1" type:"string"`

	// Any tags associated with the ingested data described in the dataset.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatasetInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.ServerSideKmsKeyId != nil && len(*s.ServerSideKmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerSideKmsKeyId", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDatasetInput) SetClientToken(v string) *CreateDatasetInput {
	s.ClientToken = &v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *CreateDatasetInput) SetDatasetName(v string) *CreateDatasetInput {
	s.DatasetName = &v
	return s
}

// SetDatasetSchema sets the DatasetSchema field's value.
func (s *CreateDatasetInput) SetDatasetSchema(v *DatasetSchema) *CreateDatasetInput {
	s.DatasetSchema = v
	return s
}

// SetServerSideKmsKeyId sets the ServerSideKmsKeyId field's value.
func (s *CreateDatasetInput) SetServerSideKmsKeyId(v string) *CreateDatasetInput {
	s.ServerSideKmsKeyId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDatasetInput) SetTags(v []*Tag) *CreateDatasetInput {
	s.Tags = v
	return s
}

type CreateDatasetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset being created.
	DatasetArn *string `min:"20" type:"string"`

	// The name of the dataset being created.
	DatasetName *string `min:"1" type:"string"`

	// Indicates the status of the CreateDataset operation.
	Status *string `type:"string" enum:"DatasetStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetOutput) GoString() string {
	return s.String()
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *CreateDatasetOutput) SetDatasetArn(v string) *CreateDatasetOutput {
	s.DatasetArn = &v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *CreateDatasetOutput) SetDatasetName(v string) *CreateDatasetOutput {
	s.DatasetName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateDatasetOutput) SetStatus(v string) *CreateDatasetOutput {
	s.Status = &v
	return s
}

type CreateInferenceSchedulerInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you do not set the client request
	// token, Amazon Lookout for Equipment generates one.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The interval (in minutes) of planned delay at the start of each inference
	// segment. For example, if inference is set to run every ten minutes, the delay
	// is set to five minutes and the time is 09:08. The inference scheduler will
	// wake up at the configured interval (which, without a delay configured, would
	// be 09:10) plus the additional five minute delay time (so 09:15) to check
	// your Amazon S3 bucket. The delay provides a buffer for you to upload data
	// at the same frequency, so that you don't have to stop and restart the scheduler
	// when uploading new data.
	//
	// For more information, see Understanding the inference process (https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-inference-process.html).
	DataDelayOffsetInMinutes *int64 `type:"long"`

	// Specifies configuration information for the input data for the inference
	// scheduler, including delimiter, format, and dataset location.
	//
	// DataInputConfiguration is a required field
	DataInputConfiguration *InferenceInputConfiguration `type:"structure" required:"true"`

	// Specifies configuration information for the output results for the inference
	// scheduler, including the S3 location for the output.
	//
	// DataOutputConfiguration is a required field
	DataOutputConfiguration *InferenceOutputConfiguration `type:"structure" required:"true"`

	// How often data is uploaded to the source Amazon S3 bucket for the input data.
	// The value chosen is the length of time between data uploads. For instance,
	// if you select 5 minutes, Amazon Lookout for Equipment will upload the real-time
	// data to the source bucket once every 5 minutes. This frequency also determines
	// how often Amazon Lookout for Equipment runs inference on your data.
	//
	// For more information, see Understanding the inference process (https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-inference-process.html).
	//
	// DataUploadFrequency is a required field
	DataUploadFrequency *string `type:"string" required:"true" enum:"DataUploadFrequency"`

	// The name of the inference scheduler being created.
	//
	// InferenceSchedulerName is a required field
	InferenceSchedulerName *string `min:"1" type:"string" required:"true"`

	// The name of the previously trained ML model being used to create the inference
	// scheduler.
	//
	// ModelName is a required field
	ModelName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of a role with permission to access the data
	// source being used for the inference.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// Provides the identifier of the KMS key used to encrypt inference scheduler
	// data by Amazon Lookout for Equipment.
	ServerSideKmsKeyId *string `min:"1" type:"string"`

	// Any tags associated with the inference scheduler.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInferenceSchedulerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInferenceSchedulerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInferenceSchedulerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInferenceSchedulerInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DataInputConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("DataInputConfiguration"))
	}
	if s.DataOutputConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("DataOutputConfiguration"))
	}
	if s.DataUploadFrequency == nil {
		invalidParams.Add(request.NewErrParamRequired("DataUploadFrequency"))
	}
	if s.InferenceSchedulerName == nil {
		invalidParams.Add(request.NewErrParamRequired("InferenceSchedulerName"))
	}
	if s.InferenceSchedulerName != nil && len(*s.InferenceSchedulerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InferenceSchedulerName", 1))
	}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}
	if s.ModelName != nil && len(*s.ModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelName", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.ServerSideKmsKeyId != nil && len(*s.ServerSideKmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerSideKmsKeyId", 1))
	}
	if s.DataInputConfiguration != nil {
		if err := s.DataInputConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DataInputConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.DataOutputConfiguration != nil {
		if err := s.DataOutputConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DataOutputConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateInferenceSchedulerInput) SetClientToken(v string) *CreateInferenceSchedulerInput {
	s.ClientToken = &v
	return s
}

// SetDataDelayOffsetInMinutes sets the DataDelayOffsetInMinutes field's value.
func (s *CreateInferenceSchedulerInput) SetDataDelayOffsetInMinutes(v int64) *CreateInferenceSchedulerInput {
	s.DataDelayOffsetInMinutes = &v
	return s
}

// SetDataInputConfiguration sets the DataInputConfiguration field's value.
func (s *CreateInferenceSchedulerInput) SetDataInputConfiguration(v *InferenceInputConfiguration) *CreateInferenceSchedulerInput {
	s.DataInputConfiguration = v
	return s
}

// SetDataOutputConfiguration sets the DataOutputConfiguration field's value.
func (s *CreateInferenceSchedulerInput) SetDataOutputConfiguration(v *InferenceOutputConfiguration) *CreateInferenceSchedulerInput {
	s.DataOutputConfiguration = v
	return s
}

// SetDataUploadFrequency sets the DataUploadFrequency field's value.
func (s *CreateInferenceSchedulerInput) SetDataUploadFrequency(v string) *CreateInferenceSchedulerInput {
	s.DataUploadFrequency = &v
	return s
}

// SetInferenceSchedulerName sets the InferenceSchedulerName field's value.
func (s *CreateInferenceSchedulerInput) SetInferenceSchedulerName(v string) *CreateInferenceSchedulerInput {
	s.InferenceSchedulerName = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *CreateInferenceSchedulerInput) SetModelName(v string) *CreateInferenceSchedulerInput {
	s.ModelName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateInferenceSchedulerInput) SetRoleArn(v string) *CreateInferenceSchedulerInput {
	s.RoleArn = &v
	return s
}

// SetServerSideKmsKeyId sets the ServerSideKmsKeyId field's value.
func (s *CreateInferenceSchedulerInput) SetServerSideKmsKeyId(v string) *CreateInferenceSchedulerInput {
	s.ServerSideKmsKeyId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateInferenceSchedulerInput) SetTags(v []*Tag) *CreateInferenceSchedulerInput {
	s.Tags = v
	return s
}

type CreateInferenceSchedulerOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the inference scheduler being created.
	InferenceSchedulerArn *string `min:"20" type:"string"`

	// The name of inference scheduler being created.
	InferenceSchedulerName *string `min:"1" type:"string"`

	// Indicates the status of the CreateInferenceScheduler operation.
	Status *string `type:"string" enum:"InferenceSchedulerStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInferenceSchedulerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInferenceSchedulerOutput) GoString() string {
	return s.String()
}

// SetInferenceSchedulerArn sets the InferenceSchedulerArn field's value.
func (s *CreateInferenceSchedulerOutput) SetInferenceSchedulerArn(v string) *CreateInferenceSchedulerOutput {
	s.InferenceSchedulerArn = &v
	return s
}

// SetInferenceSchedulerName sets the InferenceSchedulerName field's value.
func (s *CreateInferenceSchedulerOutput) SetInferenceSchedulerName(v string) *CreateInferenceSchedulerOutput {
	s.InferenceSchedulerName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateInferenceSchedulerOutput) SetStatus(v string) *CreateInferenceSchedulerOutput {
	s.Status = &v
	return s
}

type CreateLabelGroupInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request to create a label group. If you do not
	// set the client request token, Lookout for Equipment generates one.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The acceptable fault codes (indicating the type of anomaly associated with
	// the label) that can be used with this label group.
	//
	// Data in this field will be retained for service usage. Follow best practices
	// for the security of your data.
	FaultCodes []*string `type:"list"`

	// Names a group of labels.
	//
	// Data in this field will be retained for service usage. Follow best practices
	// for the security of your data.
	//
	// LabelGroupName is a required field
	LabelGroupName *string `min:"1" type:"string" required:"true"`

	// Tags that provide metadata about the label group you are creating.
	//
	// Data in this field will be retained for service usage. Follow best practices
	// for the security of your data.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLabelGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLabelGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLabelGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLabelGroupInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.LabelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("LabelGroupName"))
	}
	if s.LabelGroupName != nil && len(*s.LabelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LabelGroupName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateLabelGroupInput) SetClientToken(v string) *CreateLabelGroupInput {
	s.ClientToken = &v
	return s
}

// SetFaultCodes sets the FaultCodes field's value.
func (s *CreateLabelGroupInput) SetFaultCodes(v []*string) *CreateLabelGroupInput {
	s.FaultCodes = v
	return s
}

// SetLabelGroupName sets the LabelGroupName field's value.
func (s *CreateLabelGroupInput) SetLabelGroupName(v string) *CreateLabelGroupInput {
	s.LabelGroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLabelGroupInput) SetTags(v []*Tag) *CreateLabelGroupInput {
	s.Tags = v
	return s
}

type CreateLabelGroupOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the label group that you have created.
	LabelGroupArn *string `min:"20" type:"string"`

	// The name of the label group that you have created. Data in this field will
	// be retained for service usage. Follow best practices for the security of
	// your data.
	LabelGroupName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLabelGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLabelGroupOutput) GoString() string {
	return s.String()
}

// SetLabelGroupArn sets the LabelGroupArn field's value.
func (s *CreateLabelGroupOutput) SetLabelGroupArn(v string) *CreateLabelGroupOutput {
	s.LabelGroupArn = &v
	return s
}

// SetLabelGroupName sets the LabelGroupName field's value.
func (s *CreateLabelGroupOutput) SetLabelGroupName(v string) *CreateLabelGroupOutput {
	s.LabelGroupName = &v
	return s
}

type CreateLabelInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request to create a label. If you do not set
	// the client request token, Lookout for Equipment generates one.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The end time of the labeled event.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// Indicates that a label pertains to a particular piece of equipment.
	//
	// Data in this field will be retained for service usage. Follow best practices
	// for the security of your data.
	Equipment *string `min:"1" type:"string"`

	// Provides additional information about the label. The fault code must be defined
	// in the FaultCodes attribute of the label group.
	//
	// Data in this field will be retained for service usage. Follow best practices
	// for the security of your data.
	FaultCode *string `min:"1" type:"string"`

	// The name of a group of labels.
	//
	// Data in this field will be retained for service usage. Follow best practices
	// for the security of your data.
	//
	// LabelGroupName is a required field
	LabelGroupName *string `min:"1" type:"string" required:"true"`

	// Metadata providing additional information about the label.
	//
	// Data in this field will be retained for service usage. Follow best practices
	// for the security of your data.
	Notes *string `min:"1" type:"string"`

	// Indicates whether a labeled event represents an anomaly.
	//
	// Rating is a required field
	Rating *string `type:"string" required:"true" enum:"LabelRating"`

	// The start time of the labeled event.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLabelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLabelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLabelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLabelInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.Equipment != nil && len(*s.Equipment) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Equipment", 1))
	}
	if s.FaultCode != nil && len(*s.FaultCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FaultCode", 1))
	}
	if s.LabelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("LabelGroupName"))
	}
	if s.LabelGroupName != nil && len(*s.LabelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LabelGroupName", 1))
	}
	if s.Notes != nil && len(*s.Notes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Notes", 1))
	}
	if s.Rating == nil {
		invalidParams.Add(request.NewErrParamRequired("Rating"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateLabelInput) SetClientToken(v string) *CreateLabelInput {
	s.ClientToken = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *CreateLabelInput) SetEndTime(v time.Time) *CreateLabelInput {
	s.EndTime = &v
	return s
}

// SetEquipment sets the Equipment field's value.
func (s *CreateLabelInput) SetEquipment(v string) *CreateLabelInput {
	s.Equipment = &v
	return s
}

// SetFaultCode sets the FaultCode field's value.
func (s *CreateLabelInput) SetFaultCode(v string) *CreateLabelInput {
	s.FaultCode = &v
	return s
}

// SetLabelGroupName sets the LabelGroupName field's value.
func (s *CreateLabelInput) SetLabelGroupName(v string) *CreateLabelInput {
	s.LabelGroupName = &v
	return s
}

// SetNotes sets the Notes field's value.
func (s *CreateLabelInput) SetNotes(v string) *CreateLabelInput {
	s.Notes = &v
	return s
}

// SetRating sets the Rating field's value.
func (s *CreateLabelInput) SetRating(v string) *CreateLabelInput {
	s.Rating = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CreateLabelInput) SetStartTime(v time.Time) *CreateLabelInput {
	s.StartTime = &v
	return s
}

type CreateLabelOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the label that you have created.
	LabelId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLabelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLabelOutput) GoString() string {
	return s.String()
}

// SetLabelId sets the LabelId field's value.
func (s *CreateLabelOutput) SetLabelId(v string) *CreateLabelOutput {
	s.LabelId = &v
	return s
}

type CreateModelInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you do not set the client request
	// token, Amazon Lookout for Equipment generates one.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The configuration is the TargetSamplingRate, which is the sampling rate of
	// the data after post processing by Amazon Lookout for Equipment. For example,
	// if you provide data that has been collected at a 1 second level and you want
	// the system to resample the data at a 1 minute rate before training, the TargetSamplingRate
	// is 1 minute.
	//
	// When providing a value for the TargetSamplingRate, you must attach the prefix
	// "PT" to the rate you want. The value for a 1 second rate is therefore PT1S,
	// the value for a 15 minute rate is PT15M, and the value for a 1 hour rate
	// is PT1H
	DataPreProcessingConfiguration *DataPreProcessingConfiguration `type:"structure"`

	// The name of the dataset for the ML model being created.
	//
	// DatasetName is a required field
	DatasetName *string `min:"1" type:"string" required:"true"`

	// The data schema for the ML model being created.
	DatasetSchema *DatasetSchema `type:"structure"`

	// Indicates the time reference in the dataset that should be used to end the
	// subset of evaluation data for the ML model.
	EvaluationDataEndTime *time.Time `type:"timestamp"`

	// Indicates the time reference in the dataset that should be used to begin
	// the subset of evaluation data for the ML model.
	EvaluationDataStartTime *time.Time `type:"timestamp"`

	// The input configuration for the labels being used for the ML model that's
	// being created.
	LabelsInputConfiguration *LabelsInputConfiguration `type:"structure"`

	// The name for the ML model to be created.
	//
	// ModelName is a required field
	ModelName *string `min:"1" type:"string" required:"true"`

	// Indicates that the asset associated with this sensor has been shut off. As
	// long as this condition is met, Lookout for Equipment will not use data from
	// this asset for training, evaluation, or inference.
	OffCondition *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of a role with permission to access the data
	// source being used to create the ML model.
	RoleArn *string `min:"20" type:"string"`

	// Provides the identifier of the KMS key used to encrypt model data by Amazon
	// Lookout for Equipment.
	ServerSideKmsKeyId *string `min:"1" type:"string"`

	// Any tags associated with the ML model being created.
	Tags []*Tag `type:"list"`

	// Indicates the time reference in the dataset that should be used to end the
	// subset of training data for the ML model.
	TrainingDataEndTime *time.Time `type:"timestamp"`

	// Indicates the time reference in the dataset that should be used to begin
	// the subset of training data for the ML model.
	TrainingDataStartTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateModelInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}
	if s.ModelName != nil && len(*s.ModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelName", 1))
	}
	if s.OffCondition != nil && len(*s.OffCondition) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OffCondition", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.ServerSideKmsKeyId != nil && len(*s.ServerSideKmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerSideKmsKeyId", 1))
	}
	if s.LabelsInputConfiguration != nil {
		if err := s.LabelsInputConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LabelsInputConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateModelInput) SetClientToken(v string) *CreateModelInput {
	s.ClientToken = &v
	return s
}

// SetDataPreProcessingConfiguration sets the DataPreProcessingConfiguration field's value.
func (s *CreateModelInput) SetDataPreProcessingConfiguration(v *DataPreProcessingConfiguration) *CreateModelInput {
	s.DataPreProcessingConfiguration = v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *CreateModelInput) SetDatasetName(v string) *CreateModelInput {
	s.DatasetName = &v
	return s
}

// SetDatasetSchema sets the DatasetSchema field's value.
func (s *CreateModelInput) SetDatasetSchema(v *DatasetSchema) *CreateModelInput {
	s.DatasetSchema = v
	return s
}

// SetEvaluationDataEndTime sets the EvaluationDataEndTime field's value.
func (s *CreateModelInput) SetEvaluationDataEndTime(v time.Time) *CreateModelInput {
	s.EvaluationDataEndTime = &v
	return s
}

// SetEvaluationDataStartTime sets the EvaluationDataStartTime field's value.
func (s *CreateModelInput) SetEvaluationDataStartTime(v time.Time) *CreateModelInput {
	s.EvaluationDataStartTime = &v
	return s
}

// SetLabelsInputConfiguration sets the LabelsInputConfiguration field's value.
func (s *CreateModelInput) SetLabelsInputConfiguration(v *LabelsInputConfiguration) *CreateModelInput {
	s.LabelsInputConfiguration = v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *CreateModelInput) SetModelName(v string) *CreateModelInput {
	s.ModelName = &v
	return s
}

// SetOffCondition sets the OffCondition field's value.
func (s *CreateModelInput) SetOffCondition(v string) *CreateModelInput {
	s.OffCondition = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateModelInput) SetRoleArn(v string) *CreateModelInput {
	s.RoleArn = &v
	return s
}

// SetServerSideKmsKeyId sets the ServerSideKmsKeyId field's value.
func (s *CreateModelInput) SetServerSideKmsKeyId(v string) *CreateModelInput {
	s.ServerSideKmsKeyId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateModelInput) SetTags(v []*Tag) *CreateModelInput {
	s.Tags = v
	return s
}

// SetTrainingDataEndTime sets the TrainingDataEndTime field's value.
func (s *CreateModelInput) SetTrainingDataEndTime(v time.Time) *CreateModelInput {
	s.TrainingDataEndTime = &v
	return s
}

// SetTrainingDataStartTime sets the TrainingDataStartTime field's value.
func (s *CreateModelInput) SetTrainingDataStartTime(v time.Time) *CreateModelInput {
	s.TrainingDataStartTime = &v
	return s
}

type CreateModelOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the model being created.
	ModelArn *string `min:"20" type:"string"`

	// Indicates the status of the CreateModel operation.
	Status *string `type:"string" enum:"ModelStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelOutput) GoString() string {
	return s.String()
}

// SetModelArn sets the ModelArn field's value.
func (s *CreateModelOutput) SetModelArn(v string) *CreateModelOutput {
	s.ModelArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateModelOutput) SetStatus(v string) *CreateModelOutput {
	s.Status = &v
	return s
}

// Provides information about a specified data ingestion job, including dataset
// information, data ingestion configuration, and status.
type DataIngestionJobSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset used in the data ingestion
	// job.
	DatasetArn *string `min:"20" type:"string"`

	// The name of the dataset used for the data ingestion job.
	DatasetName *string `min:"1" type:"string"`

	// Specifies information for the input data for the data inference job, including
	// data Amazon S3 location parameters.
	IngestionInputConfiguration *IngestionInputConfiguration `type:"structure"`

	// Indicates the job ID of the data ingestion job.
	JobId *string `type:"string"`

	// Indicates the status of the data ingestion job.
	Status *string `type:"string" enum:"IngestionJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataIngestionJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataIngestionJobSummary) GoString() string {
	return s.String()
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DataIngestionJobSummary) SetDatasetArn(v string) *DataIngestionJobSummary {
	s.DatasetArn = &v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *DataIngestionJobSummary) SetDatasetName(v string) *DataIngestionJobSummary {
	s.DatasetName = &v
	return s
}

// SetIngestionInputConfiguration sets the IngestionInputConfiguration field's value.
func (s *DataIngestionJobSummary) SetIngestionInputConfiguration(v *IngestionInputConfiguration) *DataIngestionJobSummary {
	s.IngestionInputConfiguration = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DataIngestionJobSummary) SetJobId(v string) *DataIngestionJobSummary {
	s.JobId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataIngestionJobSummary) SetStatus(v string) *DataIngestionJobSummary {
	s.Status = &v
	return s
}

// The configuration is the TargetSamplingRate, which is the sampling rate of
// the data after post processing by Amazon Lookout for Equipment. For example,
// if you provide data that has been collected at a 1 second level and you want
// the system to resample the data at a 1 minute rate before training, the TargetSamplingRate
// is 1 minute.
//
// When providing a value for the TargetSamplingRate, you must attach the prefix
// "PT" to the rate you want. The value for a 1 second rate is therefore PT1S,
// the value for a 15 minute rate is PT15M, and the value for a 1 hour rate
// is PT1H
type DataPreProcessingConfiguration struct {
	_ struct{} `type:"structure"`

	// The sampling rate of the data after post processing by Amazon Lookout for
	// Equipment. For example, if you provide data that has been collected at a
	// 1 second level and you want the system to resample the data at a 1 minute
	// rate before training, the TargetSamplingRate is 1 minute.
	//
	// When providing a value for the TargetSamplingRate, you must attach the prefix
	// "PT" to the rate you want. The value for a 1 second rate is therefore PT1S,
	// the value for a 15 minute rate is PT15M, and the value for a 1 hour rate
	// is PT1H
	TargetSamplingRate *string `type:"string" enum:"TargetSamplingRate"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataPreProcessingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataPreProcessingConfiguration) GoString() string {
	return s.String()
}

// SetTargetSamplingRate sets the TargetSamplingRate field's value.
func (s *DataPreProcessingConfiguration) SetTargetSamplingRate(v string) *DataPreProcessingConfiguration {
	s.TargetSamplingRate = &v
	return s
}

// DataQualitySummary gives aggregated statistics over all the sensors about
// a completed ingestion job. It primarily gives more information about statistics
// over different incorrect data like MissingCompleteSensorData, MissingSensorData,
// UnsupportedDateFormats, InsufficientSensorData, DuplicateTimeStamps.
type DataQualitySummary struct {
	_ struct{} `type:"structure"`

	// Parameter that gives information about duplicate timestamps in the input
	// data.
	//
	// DuplicateTimestamps is a required field
	DuplicateTimestamps *DuplicateTimestamps `type:"structure" required:"true"`

	// Parameter that gives information about insufficient data for sensors in the
	// dataset. This includes information about those sensors that have complete
	// data missing and those with a short date range.
	//
	// InsufficientSensorData is a required field
	InsufficientSensorData *InsufficientSensorData `type:"structure" required:"true"`

	// Parameter that gives information about data that is invalid over all the
	// sensors in the input data.
	//
	// InvalidSensorData is a required field
	InvalidSensorData *InvalidSensorData `type:"structure" required:"true"`

	// Parameter that gives information about data that is missing over all the
	// sensors in the input data.
	//
	// MissingSensorData is a required field
	MissingSensorData *MissingSensorData `type:"structure" required:"true"`

	// Parameter that gives information about unsupported timestamps in the input
	// data.
	//
	// UnsupportedTimestamps is a required field
	UnsupportedTimestamps *UnsupportedTimestamps `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataQualitySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataQualitySummary) GoString() string {
	return s.String()
}

// SetDuplicateTimestamps sets the DuplicateTimestamps field's value.
func (s *DataQualitySummary) SetDuplicateTimestamps(v *DuplicateTimestamps) *DataQualitySummary {
	s.DuplicateTimestamps = v
	return s
}

// SetInsufficientSensorData sets the InsufficientSensorData field's value.
func (s *DataQualitySummary) SetInsufficientSensorData(v *InsufficientSensorData) *DataQualitySummary {
	s.InsufficientSensorData = v
	return s
}

// SetInvalidSensorData sets the InvalidSensorData field's value.
func (s *DataQualitySummary) SetInvalidSensorData(v *InvalidSensorData) *DataQualitySummary {
	s.InvalidSensorData = v
	return s
}

// SetMissingSensorData sets the MissingSensorData field's value.
func (s *DataQualitySummary) SetMissingSensorData(v *MissingSensorData) *DataQualitySummary {
	s.MissingSensorData = v
	return s
}

// SetUnsupportedTimestamps sets the UnsupportedTimestamps field's value.
func (s *DataQualitySummary) SetUnsupportedTimestamps(v *UnsupportedTimestamps) *DataQualitySummary {
	s.UnsupportedTimestamps = v
	return s
}

// Provides information about the data schema used with the given dataset.
type DatasetSchema struct {
	_ struct{} `type:"structure"`

	InlineDataSchema aws.JSONValue `type:"jsonvalue"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetSchema) GoString() string {
	return s.String()
}

// SetInlineDataSchema sets the InlineDataSchema field's value.
func (s *DatasetSchema) SetInlineDataSchema(v aws.JSONValue) *DatasetSchema {
	s.InlineDataSchema = v
	return s
}

// Contains information about the specific data set, including name, ARN, and
// status.
type DatasetSummary struct {
	_ struct{} `type:"structure"`

	// The time at which the dataset was created in Amazon Lookout for Equipment.
	CreatedAt *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the specified dataset.
	DatasetArn *string `min:"20" type:"string"`

	// The name of the dataset.
	DatasetName *string `min:"1" type:"string"`

	// Indicates the status of the dataset.
	Status *string `type:"string" enum:"DatasetStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DatasetSummary) SetCreatedAt(v time.Time) *DatasetSummary {
	s.CreatedAt = &v
	return s
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DatasetSummary) SetDatasetArn(v string) *DatasetSummary {
	s.DatasetArn = &v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *DatasetSummary) SetDatasetName(v string) *DatasetSummary {
	s.DatasetName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DatasetSummary) SetStatus(v string) *DatasetSummary {
	s.Status = &v
	return s
}

type DeleteDatasetInput struct {
	_ struct{} `type:"structure"`

	// The name of the dataset to be deleted.
	//
	// DatasetName is a required field
	DatasetName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDatasetInput"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetName sets the DatasetName field's value.
func (s *DeleteDatasetInput) SetDatasetName(v string) *DeleteDatasetInput {
	s.DatasetName = &v
	return s
}

type DeleteDatasetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetOutput) GoString() string {
	return s.String()
}

type DeleteInferenceSchedulerInput struct {
	_ struct{} `type:"structure"`

	// The name of the inference scheduler to be deleted.
	//
	// InferenceSchedulerName is a required field
	InferenceSchedulerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInferenceSchedulerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInferenceSchedulerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInferenceSchedulerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInferenceSchedulerInput"}
	if s.InferenceSchedulerName == nil {
		invalidParams.Add(request.NewErrParamRequired("InferenceSchedulerName"))
	}
	if s.InferenceSchedulerName != nil && len(*s.InferenceSchedulerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InferenceSchedulerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInferenceSchedulerName sets the InferenceSchedulerName field's value.
func (s *DeleteInferenceSchedulerInput) SetInferenceSchedulerName(v string) *DeleteInferenceSchedulerInput {
	s.InferenceSchedulerName = &v
	return s
}

type DeleteInferenceSchedulerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInferenceSchedulerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInferenceSchedulerOutput) GoString() string {
	return s.String()
}

type DeleteLabelGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the label group that you want to delete. Data in this field will
	// be retained for service usage. Follow best practices for the security of
	// your data.
	//
	// LabelGroupName is a required field
	LabelGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLabelGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLabelGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLabelGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLabelGroupInput"}
	if s.LabelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("LabelGroupName"))
	}
	if s.LabelGroupName != nil && len(*s.LabelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LabelGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLabelGroupName sets the LabelGroupName field's value.
func (s *DeleteLabelGroupInput) SetLabelGroupName(v string) *DeleteLabelGroupInput {
	s.LabelGroupName = &v
	return s
}

type DeleteLabelGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLabelGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLabelGroupOutput) GoString() string {
	return s.String()
}

type DeleteLabelInput struct {
	_ struct{} `type:"structure"`

	// The name of the label group that contains the label that you want to delete.
	// Data in this field will be retained for service usage. Follow best practices
	// for the security of your data.
	//
	// LabelGroupName is a required field
	LabelGroupName *string `min:"1" type:"string" required:"true"`

	// The ID of the label that you want to delete.
	//
	// LabelId is a required field
	LabelId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLabelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLabelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLabelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLabelInput"}
	if s.LabelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("LabelGroupName"))
	}
	if s.LabelGroupName != nil && len(*s.LabelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LabelGroupName", 1))
	}
	if s.LabelId == nil {
		invalidParams.Add(request.NewErrParamRequired("LabelId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLabelGroupName sets the LabelGroupName field's value.
func (s *DeleteLabelInput) SetLabelGroupName(v string) *DeleteLabelInput {
	s.LabelGroupName = &v
	return s
}

// SetLabelId sets the LabelId field's value.
func (s *DeleteLabelInput) SetLabelId(v string) *DeleteLabelInput {
	s.LabelId = &v
	return s
}

type DeleteLabelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLabelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLabelOutput) GoString() string {
	return s.String()
}

type DeleteModelInput struct {
	_ struct{} `type:"structure"`

	// The name of the ML model to be deleted.
	//
	// ModelName is a required field
	ModelName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteModelInput"}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}
	if s.ModelName != nil && len(*s.ModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelName sets the ModelName field's value.
func (s *DeleteModelInput) SetModelName(v string) *DeleteModelInput {
	s.ModelName = &v
	return s
}

type DeleteModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelOutput) GoString() string {
	return s.String()
}

type DescribeDataIngestionJobInput struct {
	_ struct{} `type:"structure"`

	// The job ID of the data ingestion job.
	//
	// JobId is a required field
	JobId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataIngestionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataIngestionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDataIngestionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDataIngestionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeDataIngestionJobInput) SetJobId(v string) *DescribeDataIngestionJobInput {
	s.JobId = &v
	return s
}

type DescribeDataIngestionJobOutput struct {
	_ struct{} `type:"structure"`

	// The time at which the data ingestion job was created.
	CreatedAt *time.Time `type:"timestamp"`

	// Indicates the latest timestamp corresponding to data that was successfully
	// ingested during this specific ingestion job.
	DataEndTime *time.Time `type:"timestamp"`

	// Gives statistics about a completed ingestion job. These statistics primarily
	// relate to quantifying incorrect data such as MissingCompleteSensorData, MissingSensorData,
	// UnsupportedDateFormats, InsufficientSensorData, and DuplicateTimeStamps.
	DataQualitySummary *DataQualitySummary `type:"structure"`

	// Indicates the earliest timestamp corresponding to data that was successfully
	// ingested during this specific ingestion job.
	DataStartTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset being used in the data ingestion
	// job.
	DatasetArn *string `min:"20" type:"string"`

	// Specifies the reason for failure when a data ingestion job has failed.
	FailedReason *string `min:"1" type:"string"`

	// Indicates the size of the ingested dataset.
	IngestedDataSize *int64 `type:"long"`

	// Gives statistics about how many files have been ingested, and which files
	// have not been ingested, for a particular ingestion job.
	IngestedFilesSummary *IngestedFilesSummary `type:"structure"`

	// Specifies the S3 location configuration for the data input for the data ingestion
	// job.
	IngestionInputConfiguration *IngestionInputConfiguration `type:"structure"`

	// Indicates the job ID of the data ingestion job.
	JobId *string `type:"string"`

	// The Amazon Resource Name (ARN) of an IAM role with permission to access the
	// data source being ingested.
	RoleArn *string `min:"20" type:"string"`

	// Indicates the status of the DataIngestionJob operation.
	Status *string `type:"string" enum:"IngestionJobStatus"`

	// Provides details about status of the ingestion job that is currently in progress.
	StatusDetail *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataIngestionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataIngestionJobOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeDataIngestionJobOutput) SetCreatedAt(v time.Time) *DescribeDataIngestionJobOutput {
	s.CreatedAt = &v
	return s
}

// SetDataEndTime sets the DataEndTime field's value.
func (s *DescribeDataIngestionJobOutput) SetDataEndTime(v time.Time) *DescribeDataIngestionJobOutput {
	s.DataEndTime = &v
	return s
}

// SetDataQualitySummary sets the DataQualitySummary field's value.
func (s *DescribeDataIngestionJobOutput) SetDataQualitySummary(v *DataQualitySummary) *DescribeDataIngestionJobOutput {
	s.DataQualitySummary = v
	return s
}

// SetDataStartTime sets the DataStartTime field's value.
func (s *DescribeDataIngestionJobOutput) SetDataStartTime(v time.Time) *DescribeDataIngestionJobOutput {
	s.DataStartTime = &v
	return s
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DescribeDataIngestionJobOutput) SetDatasetArn(v string) *DescribeDataIngestionJobOutput {
	s.DatasetArn = &v
	return s
}

// SetFailedReason sets the FailedReason field's value.
func (s *DescribeDataIngestionJobOutput) SetFailedReason(v string) *DescribeDataIngestionJobOutput {
	s.FailedReason = &v
	return s
}

// SetIngestedDataSize sets the IngestedDataSize field's value.
func (s *DescribeDataIngestionJobOutput) SetIngestedDataSize(v int64) *DescribeDataIngestionJobOutput {
	s.IngestedDataSize = &v
	return s
}

// SetIngestedFilesSummary sets the IngestedFilesSummary field's value.
func (s *DescribeDataIngestionJobOutput) SetIngestedFilesSummary(v *IngestedFilesSummary) *DescribeDataIngestionJobOutput {
	s.IngestedFilesSummary = v
	return s
}

// SetIngestionInputConfiguration sets the IngestionInputConfiguration field's value.
func (s *DescribeDataIngestionJobOutput) SetIngestionInputConfiguration(v *IngestionInputConfiguration) *DescribeDataIngestionJobOutput {
	s.IngestionInputConfiguration = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DescribeDataIngestionJobOutput) SetJobId(v string) *DescribeDataIngestionJobOutput {
	s.JobId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeDataIngestionJobOutput) SetRoleArn(v string) *DescribeDataIngestionJobOutput {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDataIngestionJobOutput) SetStatus(v string) *DescribeDataIngestionJobOutput {
	s.Status = &v
	return s
}

// SetStatusDetail sets the StatusDetail field's value.
func (s *DescribeDataIngestionJobOutput) SetStatusDetail(v string) *DescribeDataIngestionJobOutput {
	s.StatusDetail = &v
	return s
}

type DescribeDatasetInput struct {
	_ struct{} `type:"structure"`

	// The name of the dataset to be described.
	//
	// DatasetName is a required field
	DatasetName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDatasetInput"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetName sets the DatasetName field's value.
func (s *DescribeDatasetInput) SetDatasetName(v string) *DescribeDatasetInput {
	s.DatasetName = &v
	return s
}

type DescribeDatasetOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the time the dataset was created in Lookout for Equipment.
	CreatedAt *time.Time `type:"timestamp"`

	// Indicates the latest timestamp corresponding to data that was successfully
	// ingested during the most recent ingestion of this particular dataset.
	DataEndTime *time.Time `type:"timestamp"`

	// Gives statistics associated with the given dataset for the latest successful
	// associated ingestion job id. These statistics primarily relate to quantifying
	// incorrect data such as MissingCompleteSensorData, MissingSensorData, UnsupportedDateFormats,
	// InsufficientSensorData, and DuplicateTimeStamps.
	DataQualitySummary *DataQualitySummary `type:"structure"`

	// Indicates the earliest timestamp corresponding to data that was successfully
	// ingested during the most recent ingestion of this particular dataset.
	DataStartTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset being described.
	DatasetArn *string `min:"20" type:"string"`

	// The name of the dataset being described.
	DatasetName *string `min:"1" type:"string"`

	// IngestedFilesSummary associated with the given dataset for the latest successful
	// associated ingestion job id.
	IngestedFilesSummary *IngestedFilesSummary `type:"structure"`

	// Specifies the S3 location configuration for the data input for the data ingestion
	// job.
	IngestionInputConfiguration *IngestionInputConfiguration `type:"structure"`

	// Specifies the time the dataset was last updated, if it was.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the IAM role that you are using for this
	// the data ingestion job.
	RoleArn *string `min:"20" type:"string"`

	// A JSON description of the data that is in each time series dataset, including
	// names, column names, and data types.
	Schema aws.JSONValue `type:"jsonvalue"`

	// Provides the identifier of the KMS key used to encrypt dataset data by Amazon
	// Lookout for Equipment.
	ServerSideKmsKeyId *string `min:"1" type:"string"`

	// Indicates the status of the dataset.
	Status *string `type:"string" enum:"DatasetStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeDatasetOutput) SetCreatedAt(v time.Time) *DescribeDatasetOutput {
	s.CreatedAt = &v
	return s
}

// SetDataEndTime sets the DataEndTime field's value.
func (s *DescribeDatasetOutput) SetDataEndTime(v time.Time) *DescribeDatasetOutput {
	s.DataEndTime = &v
	return s
}

// SetDataQualitySummary sets the DataQualitySummary field's value.
func (s *DescribeDatasetOutput) SetDataQualitySummary(v *DataQualitySummary) *DescribeDatasetOutput {
	s.DataQualitySummary = v
	return s
}

// SetDataStartTime sets the DataStartTime field's value.
func (s *DescribeDatasetOutput) SetDataStartTime(v time.Time) *DescribeDatasetOutput {
	s.DataStartTime = &v
	return s
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DescribeDatasetOutput) SetDatasetArn(v string) *DescribeDatasetOutput {
	s.DatasetArn = &v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *DescribeDatasetOutput) SetDatasetName(v string) *DescribeDatasetOutput {
	s.DatasetName = &v
	return s
}

// SetIngestedFilesSummary sets the IngestedFilesSummary field's value.
func (s *DescribeDatasetOutput) SetIngestedFilesSummary(v *IngestedFilesSummary) *DescribeDatasetOutput {
	s.IngestedFilesSummary = v
	return s
}

// SetIngestionInputConfiguration sets the IngestionInputConfiguration field's value.
func (s *DescribeDatasetOutput) SetIngestionInputConfiguration(v *IngestionInputConfiguration) *DescribeDatasetOutput {
	s.IngestionInputConfiguration = v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *DescribeDatasetOutput) SetLastUpdatedAt(v time.Time) *DescribeDatasetOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeDatasetOutput) SetRoleArn(v string) *DescribeDatasetOutput {
	s.RoleArn = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *DescribeDatasetOutput) SetSchema(v aws.JSONValue) *DescribeDatasetOutput {
	s.Schema = v
	return s
}

// SetServerSideKmsKeyId sets the ServerSideKmsKeyId field's value.
func (s *DescribeDatasetOutput) SetServerSideKmsKeyId(v string) *DescribeDatasetOutput {
	s.ServerSideKmsKeyId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDatasetOutput) SetStatus(v string) *DescribeDatasetOutput {
	s.Status = &v
	return s
}

type DescribeInferenceSchedulerInput struct {
	_ struct{} `type:"structure"`

	// The name of the inference scheduler being described.
	//
	// InferenceSchedulerName is a required field
	InferenceSchedulerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInferenceSchedulerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInferenceSchedulerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInferenceSchedulerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInferenceSchedulerInput"}
	if s.InferenceSchedulerName == nil {
		invalidParams.Add(request.NewErrParamRequired("InferenceSchedulerName"))
	}
	if s.InferenceSchedulerName != nil && len(*s.InferenceSchedulerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InferenceSchedulerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInferenceSchedulerName sets the InferenceSchedulerName field's value.
func (s *DescribeInferenceSchedulerInput) SetInferenceSchedulerName(v string) *DescribeInferenceSchedulerInput {
	s.InferenceSchedulerName = &v
	return s
}

type DescribeInferenceSchedulerOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the time at which the inference scheduler was created.
	CreatedAt *time.Time `type:"timestamp"`

	// A period of time (in minutes) by which inference on the data is delayed after
	// the data starts. For instance, if you select an offset delay time of five
	// minutes, inference will not begin on the data until the first data measurement
	// after the five minute mark. For example, if five minutes is selected, the
	// inference scheduler will wake up at the configured frequency with the additional
	// five minute delay time to check the customer S3 bucket. The customer can
	// upload data at the same frequency and they don't need to stop and restart
	// the scheduler when uploading new data.
	DataDelayOffsetInMinutes *int64 `type:"long"`

	// Specifies configuration information for the input data for the inference
	// scheduler, including delimiter, format, and dataset location.
	DataInputConfiguration *InferenceInputConfiguration `type:"structure"`

	// Specifies information for the output results for the inference scheduler,
	// including the output S3 location.
	DataOutputConfiguration *InferenceOutputConfiguration `type:"structure"`

	// Specifies how often data is uploaded to the source S3 bucket for the input
	// data. This value is the length of time between data uploads. For instance,
	// if you select 5 minutes, Amazon Lookout for Equipment will upload the real-time
	// data to the source bucket once every 5 minutes. This frequency also determines
	// how often Amazon Lookout for Equipment starts a scheduled inference on your
	// data. In this example, it starts once every 5 minutes.
	DataUploadFrequency *string `type:"string" enum:"DataUploadFrequency"`

	// The Amazon Resource Name (ARN) of the inference scheduler being described.
	InferenceSchedulerArn *string `min:"20" type:"string"`

	// The name of the inference scheduler being described.
	InferenceSchedulerName *string `min:"1" type:"string"`

	// Indicates whether the latest execution for the inference scheduler was Anomalous
	// (anomalous events found) or Normal (no anomalous events found).
	LatestInferenceResult *string `type:"string" enum:"LatestInferenceResult"`

	// The Amazon Resource Name (ARN) of the ML model of the inference scheduler
	// being described.
	ModelArn *string `min:"20" type:"string"`

	// The name of the ML model of the inference scheduler being described.
	ModelName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of a role with permission to access the data
	// source for the inference scheduler being described.
	RoleArn *string `min:"20" type:"string"`

	// Provides the identifier of the KMS key used to encrypt inference scheduler
	// data by Amazon Lookout for Equipment.
	ServerSideKmsKeyId *string `min:"1" type:"string"`

	// Indicates the status of the inference scheduler.
	Status *string `type:"string" enum:"InferenceSchedulerStatus"`

	// Specifies the time at which the inference scheduler was last updated, if
	// it was.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInferenceSchedulerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInferenceSchedulerOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeInferenceSchedulerOutput) SetCreatedAt(v time.Time) *DescribeInferenceSchedulerOutput {
	s.CreatedAt = &v
	return s
}

// SetDataDelayOffsetInMinutes sets the DataDelayOffsetInMinutes field's value.
func (s *DescribeInferenceSchedulerOutput) SetDataDelayOffsetInMinutes(v int64) *DescribeInferenceSchedulerOutput {
	s.DataDelayOffsetInMinutes = &v
	return s
}

// SetDataInputConfiguration sets the DataInputConfiguration field's value.
func (s *DescribeInferenceSchedulerOutput) SetDataInputConfiguration(v *InferenceInputConfiguration) *DescribeInferenceSchedulerOutput {
	s.DataInputConfiguration = v
	return s
}

// SetDataOutputConfiguration sets the DataOutputConfiguration field's value.
func (s *DescribeInferenceSchedulerOutput) SetDataOutputConfiguration(v *InferenceOutputConfiguration) *DescribeInferenceSchedulerOutput {
	s.DataOutputConfiguration = v
	return s
}

// SetDataUploadFrequency sets the DataUploadFrequency field's value.
func (s *DescribeInferenceSchedulerOutput) SetDataUploadFrequency(v string) *DescribeInferenceSchedulerOutput {
	s.DataUploadFrequency = &v
	return s
}

// SetInferenceSchedulerArn sets the InferenceSchedulerArn field's value.
func (s *DescribeInferenceSchedulerOutput) SetInferenceSchedulerArn(v string) *DescribeInferenceSchedulerOutput {
	s.InferenceSchedulerArn = &v
	return s
}

// SetInferenceSchedulerName sets the InferenceSchedulerName field's value.
func (s *DescribeInferenceSchedulerOutput) SetInferenceSchedulerName(v string) *DescribeInferenceSchedulerOutput {
	s.InferenceSchedulerName = &v
	return s
}

// SetLatestInferenceResult sets the LatestInferenceResult field's value.
func (s *DescribeInferenceSchedulerOutput) SetLatestInferenceResult(v string) *DescribeInferenceSchedulerOutput {
	s.LatestInferenceResult = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *DescribeInferenceSchedulerOutput) SetModelArn(v string) *DescribeInferenceSchedulerOutput {
	s.ModelArn = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *DescribeInferenceSchedulerOutput) SetModelName(v string) *DescribeInferenceSchedulerOutput {
	s.ModelName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeInferenceSchedulerOutput) SetRoleArn(v string) *DescribeInferenceSchedulerOutput {
	s.RoleArn = &v
	return s
}

// SetServerSideKmsKeyId sets the ServerSideKmsKeyId field's value.
func (s *DescribeInferenceSchedulerOutput) SetServerSideKmsKeyId(v string) *DescribeInferenceSchedulerOutput {
	s.ServerSideKmsKeyId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeInferenceSchedulerOutput) SetStatus(v string) *DescribeInferenceSchedulerOutput {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DescribeInferenceSchedulerOutput) SetUpdatedAt(v time.Time) *DescribeInferenceSchedulerOutput {
	s.UpdatedAt = &v
	return s
}

type DescribeLabelGroupInput struct {
	_ struct{} `type:"structure"`

	// Returns the name of the label group.
	//
	// LabelGroupName is a required field
	LabelGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLabelGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLabelGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLabelGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLabelGroupInput"}
	if s.LabelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("LabelGroupName"))
	}
	if s.LabelGroupName != nil && len(*s.LabelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LabelGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLabelGroupName sets the LabelGroupName field's value.
func (s *DescribeLabelGroupInput) SetLabelGroupName(v string) *DescribeLabelGroupInput {
	s.LabelGroupName = &v
	return s
}

type DescribeLabelGroupOutput struct {
	_ struct{} `type:"structure"`

	// The time at which the label group was created.
	CreatedAt *time.Time `type:"timestamp"`

	// Codes indicating the type of anomaly associated with the labels in the lagbel
	// group.
	FaultCodes []*string `type:"list"`

	// The ARN of the label group.
	LabelGroupArn *string `min:"20" type:"string"`

	// The name of the label group.
	LabelGroupName *string `min:"1" type:"string"`

	// The time at which the label group was updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLabelGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLabelGroupOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeLabelGroupOutput) SetCreatedAt(v time.Time) *DescribeLabelGroupOutput {
	s.CreatedAt = &v
	return s
}

// SetFaultCodes sets the FaultCodes field's value.
func (s *DescribeLabelGroupOutput) SetFaultCodes(v []*string) *DescribeLabelGroupOutput {
	s.FaultCodes = v
	return s
}

// SetLabelGroupArn sets the LabelGroupArn field's value.
func (s *DescribeLabelGroupOutput) SetLabelGroupArn(v string) *DescribeLabelGroupOutput {
	s.LabelGroupArn = &v
	return s
}

// SetLabelGroupName sets the LabelGroupName field's value.
func (s *DescribeLabelGroupOutput) SetLabelGroupName(v string) *DescribeLabelGroupOutput {
	s.LabelGroupName = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DescribeLabelGroupOutput) SetUpdatedAt(v time.Time) *DescribeLabelGroupOutput {
	s.UpdatedAt = &v
	return s
}

type DescribeLabelInput struct {
	_ struct{} `type:"structure"`

	// Returns the name of the group containing the label.
	//
	// LabelGroupName is a required field
	LabelGroupName *string `min:"1" type:"string" required:"true"`

	// Returns the ID of the label.
	//
	// LabelId is a required field
	LabelId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLabelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLabelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLabelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLabelInput"}
	if s.LabelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("LabelGroupName"))
	}
	if s.LabelGroupName != nil && len(*s.LabelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LabelGroupName", 1))
	}
	if s.LabelId == nil {
		invalidParams.Add(request.NewErrParamRequired("LabelId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLabelGroupName sets the LabelGroupName field's value.
func (s *DescribeLabelInput) SetLabelGroupName(v string) *DescribeLabelInput {
	s.LabelGroupName = &v
	return s
}

// SetLabelId sets the LabelId field's value.
func (s *DescribeLabelInput) SetLabelId(v string) *DescribeLabelInput {
	s.LabelId = &v
	return s
}

type DescribeLabelOutput struct {
	_ struct{} `type:"structure"`

	// The time at which the label was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The end time of the requested label.
	EndTime *time.Time `type:"timestamp"`

	// Indicates that a label pertains to a particular piece of equipment.
	Equipment *string `min:"1" type:"string"`

	// Indicates the type of anomaly associated with the label.
	//
	// Data in this field will be retained for service usage. Follow best practices
	// for the security of your data.
	FaultCode *string `min:"1" type:"string"`

	// The ARN of the requested label group.
	LabelGroupArn *string `min:"20" type:"string"`

	// The name of the requested label group.
	LabelGroupName *string `min:"1" type:"string"`

	// The ID of the requested label.
	LabelId *string `type:"string"`

	// Metadata providing additional information about the label.
	//
	// Data in this field will be retained for service usage. Follow best practices
	// for the security of your data.
	Notes *string `min:"1" type:"string"`

	// Indicates whether a labeled event represents an anomaly.
	Rating *string `type:"string" enum:"LabelRating"`

	// The start time of the requested label.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLabelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLabelOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeLabelOutput) SetCreatedAt(v time.Time) *DescribeLabelOutput {
	s.CreatedAt = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeLabelOutput) SetEndTime(v time.Time) *DescribeLabelOutput {
	s.EndTime = &v
	return s
}

// SetEquipment sets the Equipment field's value.
func (s *DescribeLabelOutput) SetEquipment(v string) *DescribeLabelOutput {
	s.Equipment = &v
	return s
}

// SetFaultCode sets the FaultCode field's value.
func (s *DescribeLabelOutput) SetFaultCode(v string) *DescribeLabelOutput {
	s.FaultCode = &v
	return s
}

// SetLabelGroupArn sets the LabelGroupArn field's value.
func (s *DescribeLabelOutput) SetLabelGroupArn(v string) *DescribeLabelOutput {
	s.LabelGroupArn = &v
	return s
}

// SetLabelGroupName sets the LabelGroupName field's value.
func (s *DescribeLabelOutput) SetLabelGroupName(v string) *DescribeLabelOutput {
	s.LabelGroupName = &v
	return s
}

// SetLabelId sets the LabelId field's value.
func (s *DescribeLabelOutput) SetLabelId(v string) *DescribeLabelOutput {
	s.LabelId = &v
	return s
}

// SetNotes sets the Notes field's value.
func (s *DescribeLabelOutput) SetNotes(v string) *DescribeLabelOutput {
	s.Notes = &v
	return s
}

// SetRating sets the Rating field's value.
func (s *DescribeLabelOutput) SetRating(v string) *DescribeLabelOutput {
	s.Rating = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeLabelOutput) SetStartTime(v time.Time) *DescribeLabelOutput {
	s.StartTime = &v
	return s
}

type DescribeModelInput struct {
	_ struct{} `type:"structure"`

	// The name of the ML model to be described.
	//
	// ModelName is a required field
	ModelName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeModelInput"}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}
	if s.ModelName != nil && len(*s.ModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelName sets the ModelName field's value.
func (s *DescribeModelInput) SetModelName(v string) *DescribeModelInput {
	s.ModelName = &v
	return s
}

type DescribeModelOutput struct {
	_ struct{} `type:"structure"`

	// Indicates the time and date at which the ML model was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The configuration is the TargetSamplingRate, which is the sampling rate of
	// the data after post processing by Amazon Lookout for Equipment. For example,
	// if you provide data that has been collected at a 1 second level and you want
	// the system to resample the data at a 1 minute rate before training, the TargetSamplingRate
	// is 1 minute.
	//
	// When providing a value for the TargetSamplingRate, you must attach the prefix
	// "PT" to the rate you want. The value for a 1 second rate is therefore PT1S,
	// the value for a 15 minute rate is PT15M, and the value for a 1 hour rate
	// is PT1H
	DataPreProcessingConfiguration *DataPreProcessingConfiguration `type:"structure"`

	// The Amazon Resouce Name (ARN) of the dataset used to create the ML model
	// being described.
	DatasetArn *string `min:"20" type:"string"`

	// The name of the dataset being used by the ML being described.
	DatasetName *string `min:"1" type:"string"`

	// Indicates the time reference in the dataset that was used to end the subset
	// of evaluation data for the ML model.
	EvaluationDataEndTime *time.Time `type:"timestamp"`

	// Indicates the time reference in the dataset that was used to begin the subset
	// of evaluation data for the ML model.
	EvaluationDataStartTime *time.Time `type:"timestamp"`

	// If the training of the ML model failed, this indicates the reason for that
	// failure.
	FailedReason *string `min:"1" type:"string"`

	// Specifies configuration information about the labels input, including its
	// S3 location.
	LabelsInputConfiguration *LabelsInputConfiguration `type:"structure"`

	// Indicates the last time the ML model was updated. The type of update is not
	// specified.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the ML model being described.
	ModelArn *string `min:"20" type:"string"`

	// The Model Metrics show an aggregated summary of the model's performance within
	// the evaluation time range. This is the JSON content of the metrics created
	// when evaluating the model.
	ModelMetrics aws.JSONValue `type:"jsonvalue"`

	// The name of the ML model being described.
	ModelName *string `min:"1" type:"string"`

	// Indicates that the asset associated with this sensor has been shut off. As
	// long as this condition is met, Lookout for Equipment will not use data from
	// this asset for training, evaluation, or inference.
	OffCondition *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of a role with permission to access the data
	// source for the ML model being described.
	RoleArn *string `min:"20" type:"string"`

	// A JSON description of the data that is in each time series dataset, including
	// names, column names, and data types.
	Schema aws.JSONValue `type:"jsonvalue"`

	// Provides the identifier of the KMS key used to encrypt model data by Amazon
	// Lookout for Equipment.
	ServerSideKmsKeyId *string `min:"1" type:"string"`

	// Specifies the current status of the model being described. Status describes
	// the status of the most recent action of the model.
	Status *string `type:"string" enum:"ModelStatus"`

	// Indicates the time reference in the dataset that was used to end the subset
	// of training data for the ML model.
	TrainingDataEndTime *time.Time `type:"timestamp"`

	// Indicates the time reference in the dataset that was used to begin the subset
	// of training data for the ML model.
	TrainingDataStartTime *time.Time `type:"timestamp"`

	// Indicates the time at which the training of the ML model was completed.
	TrainingExecutionEndTime *time.Time `type:"timestamp"`

	// Indicates the time at which the training of the ML model began.
	TrainingExecutionStartTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeModelOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeModelOutput) SetCreatedAt(v time.Time) *DescribeModelOutput {
	s.CreatedAt = &v
	return s
}

// SetDataPreProcessingConfiguration sets the DataPreProcessingConfiguration field's value.
func (s *DescribeModelOutput) SetDataPreProcessingConfiguration(v *DataPreProcessingConfiguration) *DescribeModelOutput {
	s.DataPreProcessingConfiguration = v
	return s
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DescribeModelOutput) SetDatasetArn(v string) *DescribeModelOutput {
	s.DatasetArn = &v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *DescribeModelOutput) SetDatasetName(v string) *DescribeModelOutput {
	s.DatasetName = &v
	return s
}

// SetEvaluationDataEndTime sets the EvaluationDataEndTime field's value.
func (s *DescribeModelOutput) SetEvaluationDataEndTime(v time.Time) *DescribeModelOutput {
	s.EvaluationDataEndTime = &v
	return s
}

// SetEvaluationDataStartTime sets the EvaluationDataStartTime field's value.
func (s *DescribeModelOutput) SetEvaluationDataStartTime(v time.Time) *DescribeModelOutput {
	s.EvaluationDataStartTime = &v
	return s
}

// SetFailedReason sets the FailedReason field's value.
func (s *DescribeModelOutput) SetFailedReason(v string) *DescribeModelOutput {
	s.FailedReason = &v
	return s
}

// SetLabelsInputConfiguration sets the LabelsInputConfiguration field's value.
func (s *DescribeModelOutput) SetLabelsInputConfiguration(v *LabelsInputConfiguration) *DescribeModelOutput {
	s.LabelsInputConfiguration = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DescribeModelOutput) SetLastUpdatedTime(v time.Time) *DescribeModelOutput {
	s.LastUpdatedTime = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *DescribeModelOutput) SetModelArn(v string) *DescribeModelOutput {
	s.ModelArn = &v
	return s
}

// SetModelMetrics sets the ModelMetrics field's value.
func (s *DescribeModelOutput) SetModelMetrics(v aws.JSONValue) *DescribeModelOutput {
	s.ModelMetrics = v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *DescribeModelOutput) SetModelName(v string) *DescribeModelOutput {
	s.ModelName = &v
	return s
}

// SetOffCondition sets the OffCondition field's value.
func (s *DescribeModelOutput) SetOffCondition(v string) *DescribeModelOutput {
	s.OffCondition = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeModelOutput) SetRoleArn(v string) *DescribeModelOutput {
	s.RoleArn = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *DescribeModelOutput) SetSchema(v aws.JSONValue) *DescribeModelOutput {
	s.Schema = v
	return s
}

// SetServerSideKmsKeyId sets the ServerSideKmsKeyId field's value.
func (s *DescribeModelOutput) SetServerSideKmsKeyId(v string) *DescribeModelOutput {
	s.ServerSideKmsKeyId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeModelOutput) SetStatus(v string) *DescribeModelOutput {
	s.Status = &v
	return s
}

// SetTrainingDataEndTime sets the TrainingDataEndTime field's value.
func (s *DescribeModelOutput) SetTrainingDataEndTime(v time.Time) *DescribeModelOutput {
	s.TrainingDataEndTime = &v
	return s
}

// SetTrainingDataStartTime sets the TrainingDataStartTime field's value.
func (s *DescribeModelOutput) SetTrainingDataStartTime(v time.Time) *DescribeModelOutput {
	s.TrainingDataStartTime = &v
	return s
}

// SetTrainingExecutionEndTime sets the TrainingExecutionEndTime field's value.
func (s *DescribeModelOutput) SetTrainingExecutionEndTime(v time.Time) *DescribeModelOutput {
	s.TrainingExecutionEndTime = &v
	return s
}

// SetTrainingExecutionStartTime sets the TrainingExecutionStartTime field's value.
func (s *DescribeModelOutput) SetTrainingExecutionStartTime(v time.Time) *DescribeModelOutput {
	s.TrainingExecutionStartTime = &v
	return s
}

// Entity that comprises information abount duplicate timestamps in the dataset.
type DuplicateTimestamps struct {
	_ struct{} `type:"structure"`

	// Indicates the total number of duplicate timestamps.
	//
	// TotalNumberOfDuplicateTimestamps is a required field
	TotalNumberOfDuplicateTimestamps *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DuplicateTimestamps) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DuplicateTimestamps) GoString() string {
	return s.String()
}

// SetTotalNumberOfDuplicateTimestamps sets the TotalNumberOfDuplicateTimestamps field's value.
func (s *DuplicateTimestamps) SetTotalNumberOfDuplicateTimestamps(v int64) *DuplicateTimestamps {
	s.TotalNumberOfDuplicateTimestamps = &v
	return s
}

// Contains information about the specific inference event, including start
// and end time, diagnostics information, event duration and so on.
type InferenceEventSummary struct {
	_ struct{} `type:"structure"`

	// An array which specifies the names and values of all sensors contributing
	// to an inference event.
	Diagnostics *string `min:"1" type:"string"`

	// Indicates the size of an inference event in seconds.
	EventDurationInSeconds *int64 `type:"long"`

	// Indicates the ending time of an inference event.
	EventEndTime *time.Time `type:"timestamp"`

	// Indicates the starting time of an inference event.
	EventStartTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the inference scheduler being used for
	// the inference event.
	InferenceSchedulerArn *string `min:"20" type:"string"`

	// The name of the inference scheduler being used for the inference events.
	InferenceSchedulerName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceEventSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceEventSummary) GoString() string {
	return s.String()
}

// SetDiagnostics sets the Diagnostics field's value.
func (s *InferenceEventSummary) SetDiagnostics(v string) *InferenceEventSummary {
	s.Diagnostics = &v
	return s
}

// SetEventDurationInSeconds sets the EventDurationInSeconds field's value.
func (s *InferenceEventSummary) SetEventDurationInSeconds(v int64) *InferenceEventSummary {
	s.EventDurationInSeconds = &v
	return s
}

// SetEventEndTime sets the EventEndTime field's value.
func (s *InferenceEventSummary) SetEventEndTime(v time.Time) *InferenceEventSummary {
	s.EventEndTime = &v
	return s
}

// SetEventStartTime sets the EventStartTime field's value.
func (s *InferenceEventSummary) SetEventStartTime(v time.Time) *InferenceEventSummary {
	s.EventStartTime = &v
	return s
}

// SetInferenceSchedulerArn sets the InferenceSchedulerArn field's value.
func (s *InferenceEventSummary) SetInferenceSchedulerArn(v string) *InferenceEventSummary {
	s.InferenceSchedulerArn = &v
	return s
}

// SetInferenceSchedulerName sets the InferenceSchedulerName field's value.
func (s *InferenceEventSummary) SetInferenceSchedulerName(v string) *InferenceEventSummary {
	s.InferenceSchedulerName = &v
	return s
}

// Contains information about the specific inference execution, including input
// and output data configuration, inference scheduling information, status,
// and so on.
type InferenceExecutionSummary struct {
	_ struct{} `type:"structure"`

	// Contains information about an S3 bucket.
	CustomerResultObject *S3Object `type:"structure"`

	// Indicates the time reference in the dataset at which the inference execution
	// stopped.
	DataEndTime *time.Time `type:"timestamp"`

	// Specifies configuration information for the input data for the inference
	// scheduler, including delimiter, format, and dataset location.
	DataInputConfiguration *InferenceInputConfiguration `type:"structure"`

	// Specifies configuration information for the output results from for the inference
	// execution, including the output Amazon S3 location.
	DataOutputConfiguration *InferenceOutputConfiguration `type:"structure"`

	// Indicates the time reference in the dataset at which the inference execution
	// began.
	DataStartTime *time.Time `type:"timestamp"`

	// Specifies the reason for failure when an inference execution has failed.
	FailedReason *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the inference scheduler being used for
	// the inference execution.
	InferenceSchedulerArn *string `min:"20" type:"string"`

	// The name of the inference scheduler being used for the inference execution.
	InferenceSchedulerName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the ML model used for the inference execution.
	ModelArn *string `min:"20" type:"string"`

	// The name of the ML model being used for the inference execution.
	ModelName *string `min:"1" type:"string"`

	// Indicates the start time at which the inference scheduler began the specific
	// inference execution.
	ScheduledStartTime *time.Time `type:"timestamp"`

	// Indicates the status of the inference execution.
	Status *string `type:"string" enum:"InferenceExecutionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceExecutionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceExecutionSummary) GoString() string {
	return s.String()
}

// SetCustomerResultObject sets the CustomerResultObject field's value.
func (s *InferenceExecutionSummary) SetCustomerResultObject(v *S3Object) *InferenceExecutionSummary {
	s.CustomerResultObject = v
	return s
}

// SetDataEndTime sets the DataEndTime field's value.
func (s *InferenceExecutionSummary) SetDataEndTime(v time.Time) *InferenceExecutionSummary {
	s.DataEndTime = &v
	return s
}

// SetDataInputConfiguration sets the DataInputConfiguration field's value.
func (s *InferenceExecutionSummary) SetDataInputConfiguration(v *InferenceInputConfiguration) *InferenceExecutionSummary {
	s.DataInputConfiguration = v
	return s
}

// SetDataOutputConfiguration sets the DataOutputConfiguration field's value.
func (s *InferenceExecutionSummary) SetDataOutputConfiguration(v *InferenceOutputConfiguration) *InferenceExecutionSummary {
	s.DataOutputConfiguration = v
	return s
}

// SetDataStartTime sets the DataStartTime field's value.
func (s *InferenceExecutionSummary) SetDataStartTime(v time.Time) *InferenceExecutionSummary {
	s.DataStartTime = &v
	return s
}

// SetFailedReason sets the FailedReason field's value.
func (s *InferenceExecutionSummary) SetFailedReason(v string) *InferenceExecutionSummary {
	s.FailedReason = &v
	return s
}

// SetInferenceSchedulerArn sets the InferenceSchedulerArn field's value.
func (s *InferenceExecutionSummary) SetInferenceSchedulerArn(v string) *InferenceExecutionSummary {
	s.InferenceSchedulerArn = &v
	return s
}

// SetInferenceSchedulerName sets the InferenceSchedulerName field's value.
func (s *InferenceExecutionSummary) SetInferenceSchedulerName(v string) *InferenceExecutionSummary {
	s.InferenceSchedulerName = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *InferenceExecutionSummary) SetModelArn(v string) *InferenceExecutionSummary {
	s.ModelArn = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *InferenceExecutionSummary) SetModelName(v string) *InferenceExecutionSummary {
	s.ModelName = &v
	return s
}

// SetScheduledStartTime sets the ScheduledStartTime field's value.
func (s *InferenceExecutionSummary) SetScheduledStartTime(v time.Time) *InferenceExecutionSummary {
	s.ScheduledStartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *InferenceExecutionSummary) SetStatus(v string) *InferenceExecutionSummary {
	s.Status = &v
	return s
}

// Specifies configuration information for the input data for the inference,
// including Amazon S3 location of input data..
type InferenceInputConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies configuration information for the input data for the inference,
	// including timestamp format and delimiter.
	InferenceInputNameConfiguration *InferenceInputNameConfiguration `type:"structure"`

	// Indicates the difference between your time zone and Coordinated Universal
	// Time (UTC).
	InputTimeZoneOffset *string `type:"string"`

	// Specifies configuration information for the input data for the inference,
	// including Amazon S3 location of input data.
	S3InputConfiguration *InferenceS3InputConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceInputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceInputConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InferenceInputConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InferenceInputConfiguration"}
	if s.S3InputConfiguration != nil {
		if err := s.S3InputConfiguration.Validate(); err != nil {
			invalidParams.AddNested("S3InputConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInferenceInputNameConfiguration sets the InferenceInputNameConfiguration field's value.
func (s *InferenceInputConfiguration) SetInferenceInputNameConfiguration(v *InferenceInputNameConfiguration) *InferenceInputConfiguration {
	s.InferenceInputNameConfiguration = v
	return s
}

// SetInputTimeZoneOffset sets the InputTimeZoneOffset field's value.
func (s *InferenceInputConfiguration) SetInputTimeZoneOffset(v string) *InferenceInputConfiguration {
	s.InputTimeZoneOffset = &v
	return s
}

// SetS3InputConfiguration sets the S3InputConfiguration field's value.
func (s *InferenceInputConfiguration) SetS3InputConfiguration(v *InferenceS3InputConfiguration) *InferenceInputConfiguration {
	s.S3InputConfiguration = v
	return s
}

// Specifies configuration information for the input data for the inference,
// including timestamp format and delimiter.
type InferenceInputNameConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates the delimiter character used between items in the data.
	ComponentTimestampDelimiter *string `type:"string"`

	// The format of the timestamp, whether Epoch time, or standard, with or without
	// hyphens (-).
	TimestampFormat *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceInputNameConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceInputNameConfiguration) GoString() string {
	return s.String()
}

// SetComponentTimestampDelimiter sets the ComponentTimestampDelimiter field's value.
func (s *InferenceInputNameConfiguration) SetComponentTimestampDelimiter(v string) *InferenceInputNameConfiguration {
	s.ComponentTimestampDelimiter = &v
	return s
}

// SetTimestampFormat sets the TimestampFormat field's value.
func (s *InferenceInputNameConfiguration) SetTimestampFormat(v string) *InferenceInputNameConfiguration {
	s.TimestampFormat = &v
	return s
}

// Specifies configuration information for the output results from for the inference,
// including KMS key ID and output S3 location.
type InferenceOutputConfiguration struct {
	_ struct{} `type:"structure"`

	// The ID number for the AWS KMS key used to encrypt the inference output.
	KmsKeyId *string `min:"1" type:"string"`

	// Specifies configuration information for the output results from for the inference,
	// output S3 location.
	//
	// S3OutputConfiguration is a required field
	S3OutputConfiguration *InferenceS3OutputConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceOutputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceOutputConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InferenceOutputConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InferenceOutputConfiguration"}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.S3OutputConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("S3OutputConfiguration"))
	}
	if s.S3OutputConfiguration != nil {
		if err := s.S3OutputConfiguration.Validate(); err != nil {
			invalidParams.AddNested("S3OutputConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *InferenceOutputConfiguration) SetKmsKeyId(v string) *InferenceOutputConfiguration {
	s.KmsKeyId = &v
	return s
}

// SetS3OutputConfiguration sets the S3OutputConfiguration field's value.
func (s *InferenceOutputConfiguration) SetS3OutputConfiguration(v *InferenceS3OutputConfiguration) *InferenceOutputConfiguration {
	s.S3OutputConfiguration = v
	return s
}

// Specifies configuration information for the input data for the inference,
// including input data S3 location.
type InferenceS3InputConfiguration struct {
	_ struct{} `type:"structure"`

	// The bucket containing the input dataset for the inference.
	//
	// Bucket is a required field
	Bucket *string `min:"3" type:"string" required:"true"`

	// The prefix for the S3 bucket used for the input data for the inference.
	Prefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceS3InputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceS3InputConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InferenceS3InputConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InferenceS3InputConfiguration"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *InferenceS3InputConfiguration) SetBucket(v string) *InferenceS3InputConfiguration {
	s.Bucket = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *InferenceS3InputConfiguration) SetPrefix(v string) *InferenceS3InputConfiguration {
	s.Prefix = &v
	return s
}

// Specifies configuration information for the output results from the inference,
// including output S3 location.
type InferenceS3OutputConfiguration struct {
	_ struct{} `type:"structure"`

	// The bucket containing the output results from the inference
	//
	// Bucket is a required field
	Bucket *string `min:"3" type:"string" required:"true"`

	// The prefix for the S3 bucket used for the output results from the inference.
	Prefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceS3OutputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceS3OutputConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InferenceS3OutputConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InferenceS3OutputConfiguration"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *InferenceS3OutputConfiguration) SetBucket(v string) *InferenceS3OutputConfiguration {
	s.Bucket = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *InferenceS3OutputConfiguration) SetPrefix(v string) *InferenceS3OutputConfiguration {
	s.Prefix = &v
	return s
}

// Contains information about the specific inference scheduler, including data
// delay offset, model name and ARN, status, and so on.
type InferenceSchedulerSummary struct {
	_ struct{} `type:"structure"`

	// A period of time (in minutes) by which inference on the data is delayed after
	// the data starts. For instance, if an offset delay time of five minutes was
	// selected, inference will not begin on the data until the first data measurement
	// after the five minute mark. For example, if five minutes is selected, the
	// inference scheduler will wake up at the configured frequency with the additional
	// five minute delay time to check the customer S3 bucket. The customer can
	// upload data at the same frequency and they don't need to stop and restart
	// the scheduler when uploading new data.
	DataDelayOffsetInMinutes *int64 `type:"long"`

	// How often data is uploaded to the source S3 bucket for the input data. This
	// value is the length of time between data uploads. For instance, if you select
	// 5 minutes, Amazon Lookout for Equipment will upload the real-time data to
	// the source bucket once every 5 minutes. This frequency also determines how
	// often Amazon Lookout for Equipment starts a scheduled inference on your data.
	// In this example, it starts once every 5 minutes.
	DataUploadFrequency *string `type:"string" enum:"DataUploadFrequency"`

	// The Amazon Resource Name (ARN) of the inference scheduler.
	InferenceSchedulerArn *string `min:"20" type:"string"`

	// The name of the inference scheduler.
	InferenceSchedulerName *string `min:"1" type:"string"`

	// Indicates whether the latest execution for the inference scheduler was Anomalous
	// (anomalous events found) or Normal (no anomalous events found).
	LatestInferenceResult *string `type:"string" enum:"LatestInferenceResult"`

	// The Amazon Resource Name (ARN) of the ML model used by the inference scheduler.
	ModelArn *string `min:"20" type:"string"`

	// The name of the ML model used for the inference scheduler.
	ModelName *string `min:"1" type:"string"`

	// Indicates the status of the inference scheduler.
	Status *string `type:"string" enum:"InferenceSchedulerStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceSchedulerSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceSchedulerSummary) GoString() string {
	return s.String()
}

// SetDataDelayOffsetInMinutes sets the DataDelayOffsetInMinutes field's value.
func (s *InferenceSchedulerSummary) SetDataDelayOffsetInMinutes(v int64) *InferenceSchedulerSummary {
	s.DataDelayOffsetInMinutes = &v
	return s
}

// SetDataUploadFrequency sets the DataUploadFrequency field's value.
func (s *InferenceSchedulerSummary) SetDataUploadFrequency(v string) *InferenceSchedulerSummary {
	s.DataUploadFrequency = &v
	return s
}

// SetInferenceSchedulerArn sets the InferenceSchedulerArn field's value.
func (s *InferenceSchedulerSummary) SetInferenceSchedulerArn(v string) *InferenceSchedulerSummary {
	s.InferenceSchedulerArn = &v
	return s
}

// SetInferenceSchedulerName sets the InferenceSchedulerName field's value.
func (s *InferenceSchedulerSummary) SetInferenceSchedulerName(v string) *InferenceSchedulerSummary {
	s.InferenceSchedulerName = &v
	return s
}

// SetLatestInferenceResult sets the LatestInferenceResult field's value.
func (s *InferenceSchedulerSummary) SetLatestInferenceResult(v string) *InferenceSchedulerSummary {
	s.LatestInferenceResult = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *InferenceSchedulerSummary) SetModelArn(v string) *InferenceSchedulerSummary {
	s.ModelArn = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *InferenceSchedulerSummary) SetModelName(v string) *InferenceSchedulerSummary {
	s.ModelName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *InferenceSchedulerSummary) SetStatus(v string) *InferenceSchedulerSummary {
	s.Status = &v
	return s
}

// Gives statistics about how many files have been ingested, and which files
// have not been ingested, for a particular ingestion job.
type IngestedFilesSummary struct {
	_ struct{} `type:"structure"`

	// Indicates the number of files that were discarded. A file could be discarded
	// because its format is invalid (for example, a jpg or pdf) or not readable.
	DiscardedFiles []*S3Object `type:"list"`

	// Indicates the number of files that were successfully ingested.
	//
	// IngestedNumberOfFiles is a required field
	IngestedNumberOfFiles *int64 `type:"integer" required:"true"`

	// Indicates the total number of files that were submitted for ingestion.
	//
	// TotalNumberOfFiles is a required field
	TotalNumberOfFiles *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestedFilesSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestedFilesSummary) GoString() string {
	return s.String()
}

// SetDiscardedFiles sets the DiscardedFiles field's value.
func (s *IngestedFilesSummary) SetDiscardedFiles(v []*S3Object) *IngestedFilesSummary {
	s.DiscardedFiles = v
	return s
}

// SetIngestedNumberOfFiles sets the IngestedNumberOfFiles field's value.
func (s *IngestedFilesSummary) SetIngestedNumberOfFiles(v int64) *IngestedFilesSummary {
	s.IngestedNumberOfFiles = &v
	return s
}

// SetTotalNumberOfFiles sets the TotalNumberOfFiles field's value.
func (s *IngestedFilesSummary) SetTotalNumberOfFiles(v int64) *IngestedFilesSummary {
	s.TotalNumberOfFiles = &v
	return s
}

// Specifies configuration information for the input data for the data ingestion
// job, including input data S3 location.
type IngestionInputConfiguration struct {
	_ struct{} `type:"structure"`

	// The location information for the S3 bucket used for input data for the data
	// ingestion.
	//
	// S3InputConfiguration is a required field
	S3InputConfiguration *IngestionS3InputConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionInputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionInputConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IngestionInputConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IngestionInputConfiguration"}
	if s.S3InputConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("S3InputConfiguration"))
	}
	if s.S3InputConfiguration != nil {
		if err := s.S3InputConfiguration.Validate(); err != nil {
			invalidParams.AddNested("S3InputConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3InputConfiguration sets the S3InputConfiguration field's value.
func (s *IngestionInputConfiguration) SetS3InputConfiguration(v *IngestionS3InputConfiguration) *IngestionInputConfiguration {
	s.S3InputConfiguration = v
	return s
}

// Specifies S3 configuration information for the input data for the data ingestion
// job.
type IngestionS3InputConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket used for the input data for the data ingestion.
	//
	// Bucket is a required field
	Bucket *string `min:"3" type:"string" required:"true"`

	// Pattern for matching the Amazon S3 files which will be used for ingestion.
	// If no KeyPattern is provided, we will use the default hierarchy file structure,
	// which is same as KeyPattern {prefix}/{component_name}/*
	KeyPattern *string `min:"1" type:"string"`

	// The prefix for the S3 location being used for the input data for the data
	// ingestion.
	Prefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionS3InputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionS3InputConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IngestionS3InputConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IngestionS3InputConfiguration"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.KeyPattern != nil && len(*s.KeyPattern) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyPattern", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *IngestionS3InputConfiguration) SetBucket(v string) *IngestionS3InputConfiguration {
	s.Bucket = &v
	return s
}

// SetKeyPattern sets the KeyPattern field's value.
func (s *IngestionS3InputConfiguration) SetKeyPattern(v string) *IngestionS3InputConfiguration {
	s.KeyPattern = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *IngestionS3InputConfiguration) SetPrefix(v string) *IngestionS3InputConfiguration {
	s.Prefix = &v
	return s
}

// Entity that comprises aggregated information on sensors having insufficient
// data.
type InsufficientSensorData struct {
	_ struct{} `type:"structure"`

	// Parameter that describes the total number of sensors that have data completely
	// missing for it.
	//
	// MissingCompleteSensorData is a required field
	MissingCompleteSensorData *MissingCompleteSensorData `type:"structure" required:"true"`

	// Parameter that describes the total number of sensors that have a short date
	// range of less than 90 days of data overall.
	//
	// SensorsWithShortDateRange is a required field
	SensorsWithShortDateRange *SensorsWithShortDateRange `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsufficientSensorData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsufficientSensorData) GoString() string {
	return s.String()
}

// SetMissingCompleteSensorData sets the MissingCompleteSensorData field's value.
func (s *InsufficientSensorData) SetMissingCompleteSensorData(v *MissingCompleteSensorData) *InsufficientSensorData {
	s.MissingCompleteSensorData = v
	return s
}

// SetSensorsWithShortDateRange sets the SensorsWithShortDateRange field's value.
func (s *InsufficientSensorData) SetSensorsWithShortDateRange(v *SensorsWithShortDateRange) *InsufficientSensorData {
	s.SensorsWithShortDateRange = v
	return s
}

// Processing of the request has failed because of an unknown error, exception
// or failure.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Entity that comprises aggregated information on sensors having insufficient
// data.
type InvalidSensorData struct {
	_ struct{} `type:"structure"`

	// Indicates the number of sensors that have at least some invalid values.
	//
	// AffectedSensorCount is a required field
	AffectedSensorCount *int64 `type:"integer" required:"true"`

	// Indicates the total number of invalid values across all the sensors.
	//
	// TotalNumberOfInvalidValues is a required field
	TotalNumberOfInvalidValues *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidSensorData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidSensorData) GoString() string {
	return s.String()
}

// SetAffectedSensorCount sets the AffectedSensorCount field's value.
func (s *InvalidSensorData) SetAffectedSensorCount(v int64) *InvalidSensorData {
	s.AffectedSensorCount = &v
	return s
}

// SetTotalNumberOfInvalidValues sets the TotalNumberOfInvalidValues field's value.
func (s *InvalidSensorData) SetTotalNumberOfInvalidValues(v int64) *InvalidSensorData {
	s.TotalNumberOfInvalidValues = &v
	return s
}

// Contains information about the label group.
type LabelGroupSummary struct {
	_ struct{} `type:"structure"`

	// The time at which the label group was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The ARN of the label group.
	LabelGroupArn *string `min:"20" type:"string"`

	// The name of the label group.
	LabelGroupName *string `min:"1" type:"string"`

	// The time at which the label group was updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LabelGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LabelGroupSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *LabelGroupSummary) SetCreatedAt(v time.Time) *LabelGroupSummary {
	s.CreatedAt = &v
	return s
}

// SetLabelGroupArn sets the LabelGroupArn field's value.
func (s *LabelGroupSummary) SetLabelGroupArn(v string) *LabelGroupSummary {
	s.LabelGroupArn = &v
	return s
}

// SetLabelGroupName sets the LabelGroupName field's value.
func (s *LabelGroupSummary) SetLabelGroupName(v string) *LabelGroupSummary {
	s.LabelGroupName = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *LabelGroupSummary) SetUpdatedAt(v time.Time) *LabelGroupSummary {
	s.UpdatedAt = &v
	return s
}

// Information about the label.
type LabelSummary struct {
	_ struct{} `type:"structure"`

	// The time at which the label was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The timestamp indicating the end of the label.
	EndTime *time.Time `type:"timestamp"`

	// Indicates that a label pertains to a particular piece of equipment.
	Equipment *string `min:"1" type:"string"`

	// Indicates the type of anomaly associated with the label.
	//
	// Data in this field will be retained for service usage. Follow best practices
	// for the security of your data.
	FaultCode *string `min:"1" type:"string"`

	// The ARN of the label group.
	LabelGroupArn *string `min:"20" type:"string"`

	// The name of the label group.
	LabelGroupName *string `min:"1" type:"string"`

	// The ID of the label.
	LabelId *string `type:"string"`

	// Indicates whether a labeled event represents an anomaly.
	Rating *string `type:"string" enum:"LabelRating"`

	// The timestamp indicating the start of the label.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LabelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LabelSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *LabelSummary) SetCreatedAt(v time.Time) *LabelSummary {
	s.CreatedAt = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *LabelSummary) SetEndTime(v time.Time) *LabelSummary {
	s.EndTime = &v
	return s
}

// SetEquipment sets the Equipment field's value.
func (s *LabelSummary) SetEquipment(v string) *LabelSummary {
	s.Equipment = &v
	return s
}

// SetFaultCode sets the FaultCode field's value.
func (s *LabelSummary) SetFaultCode(v string) *LabelSummary {
	s.FaultCode = &v
	return s
}

// SetLabelGroupArn sets the LabelGroupArn field's value.
func (s *LabelSummary) SetLabelGroupArn(v string) *LabelSummary {
	s.LabelGroupArn = &v
	return s
}

// SetLabelGroupName sets the LabelGroupName field's value.
func (s *LabelSummary) SetLabelGroupName(v string) *LabelSummary {
	s.LabelGroupName = &v
	return s
}

// SetLabelId sets the LabelId field's value.
func (s *LabelSummary) SetLabelId(v string) *LabelSummary {
	s.LabelId = &v
	return s
}

// SetRating sets the Rating field's value.
func (s *LabelSummary) SetRating(v string) *LabelSummary {
	s.Rating = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *LabelSummary) SetStartTime(v time.Time) *LabelSummary {
	s.StartTime = &v
	return s
}

// Contains the configuration information for the S3 location being used to
// hold label data.
type LabelsInputConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the label group to be used for label data.
	LabelGroupName *string `min:"1" type:"string"`

	// Contains location information for the S3 location being used for label data.
	S3InputConfiguration *LabelsS3InputConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LabelsInputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LabelsInputConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LabelsInputConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LabelsInputConfiguration"}
	if s.LabelGroupName != nil && len(*s.LabelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LabelGroupName", 1))
	}
	if s.S3InputConfiguration != nil {
		if err := s.S3InputConfiguration.Validate(); err != nil {
			invalidParams.AddNested("S3InputConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLabelGroupName sets the LabelGroupName field's value.
func (s *LabelsInputConfiguration) SetLabelGroupName(v string) *LabelsInputConfiguration {
	s.LabelGroupName = &v
	return s
}

// SetS3InputConfiguration sets the S3InputConfiguration field's value.
func (s *LabelsInputConfiguration) SetS3InputConfiguration(v *LabelsS3InputConfiguration) *LabelsInputConfiguration {
	s.S3InputConfiguration = v
	return s
}

// The location information (prefix and bucket name) for the s3 location being
// used for label data.
type LabelsS3InputConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket holding the label data.
	//
	// Bucket is a required field
	Bucket *string `min:"3" type:"string" required:"true"`

	// The prefix for the S3 bucket used for the label data.
	Prefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LabelsS3InputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LabelsS3InputConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LabelsS3InputConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LabelsS3InputConfiguration"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *LabelsS3InputConfiguration) SetBucket(v string) *LabelsS3InputConfiguration {
	s.Bucket = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *LabelsS3InputConfiguration) SetPrefix(v string) *LabelsS3InputConfiguration {
	s.Prefix = &v
	return s
}

// Entity that comprises information on large gaps between consecutive timestamps
// in data.
type LargeTimestampGaps struct {
	_ struct{} `type:"structure"`

	// Indicates the size of the largest timestamp gap, in days.
	MaxTimestampGapInDays *int64 `type:"integer"`

	// Indicates the number of large timestamp gaps, if there are any.
	NumberOfLargeTimestampGaps *int64 `type:"integer"`

	// Indicates whether there is a potential data issue related to large gaps in
	// timestamps.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"StatisticalIssueStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LargeTimestampGaps) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LargeTimestampGaps) GoString() string {
	return s.String()
}

// SetMaxTimestampGapInDays sets the MaxTimestampGapInDays field's value.
func (s *LargeTimestampGaps) SetMaxTimestampGapInDays(v int64) *LargeTimestampGaps {
	s.MaxTimestampGapInDays = &v
	return s
}

// SetNumberOfLargeTimestampGaps sets the NumberOfLargeTimestampGaps field's value.
func (s *LargeTimestampGaps) SetNumberOfLargeTimestampGaps(v int64) *LargeTimestampGaps {
	s.NumberOfLargeTimestampGaps = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *LargeTimestampGaps) SetStatus(v string) *LargeTimestampGaps {
	s.Status = &v
	return s
}

type ListDataIngestionJobsInput struct {
	_ struct{} `type:"structure"`

	// The name of the dataset being used for the data ingestion job.
	DatasetName *string `min:"1" type:"string"`

	// Specifies the maximum number of data ingestion jobs to list.
	MaxResults *int64 `min:"1" type:"integer"`

	// An opaque pagination token indicating where to continue the listing of data
	// ingestion jobs.
	NextToken *string `type:"string"`

	// Indicates the status of the data ingestion job.
	Status *string `type:"string" enum:"IngestionJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataIngestionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataIngestionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataIngestionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataIngestionJobsInput"}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetName sets the DatasetName field's value.
func (s *ListDataIngestionJobsInput) SetDatasetName(v string) *ListDataIngestionJobsInput {
	s.DatasetName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDataIngestionJobsInput) SetMaxResults(v int64) *ListDataIngestionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataIngestionJobsInput) SetNextToken(v string) *ListDataIngestionJobsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListDataIngestionJobsInput) SetStatus(v string) *ListDataIngestionJobsInput {
	s.Status = &v
	return s
}

type ListDataIngestionJobsOutput struct {
	_ struct{} `type:"structure"`

	// Specifies information about the specific data ingestion job, including dataset
	// name and status.
	DataIngestionJobSummaries []*DataIngestionJobSummary `type:"list"`

	// An opaque pagination token indicating where to continue the listing of data
	// ingestion jobs.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataIngestionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataIngestionJobsOutput) GoString() string {
	return s.String()
}

// SetDataIngestionJobSummaries sets the DataIngestionJobSummaries field's value.
func (s *ListDataIngestionJobsOutput) SetDataIngestionJobSummaries(v []*DataIngestionJobSummary) *ListDataIngestionJobsOutput {
	s.DataIngestionJobSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataIngestionJobsOutput) SetNextToken(v string) *ListDataIngestionJobsOutput {
	s.NextToken = &v
	return s
}

type ListDatasetsInput struct {
	_ struct{} `type:"structure"`

	// The beginning of the name of the datasets to be listed.
	DatasetNameBeginsWith *string `min:"1" type:"string"`

	// Specifies the maximum number of datasets to list.
	MaxResults *int64 `min:"1" type:"integer"`

	// An opaque pagination token indicating where to continue the listing of datasets.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatasetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatasetsInput"}
	if s.DatasetNameBeginsWith != nil && len(*s.DatasetNameBeginsWith) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetNameBeginsWith", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetNameBeginsWith sets the DatasetNameBeginsWith field's value.
func (s *ListDatasetsInput) SetDatasetNameBeginsWith(v string) *ListDatasetsInput {
	s.DatasetNameBeginsWith = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatasetsInput) SetMaxResults(v int64) *ListDatasetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetsInput) SetNextToken(v string) *ListDatasetsInput {
	s.NextToken = &v
	return s
}

type ListDatasetsOutput struct {
	_ struct{} `type:"structure"`

	// Provides information about the specified dataset, including creation time,
	// dataset ARN, and status.
	DatasetSummaries []*DatasetSummary `type:"list"`

	// An opaque pagination token indicating where to continue the listing of datasets.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetsOutput) GoString() string {
	return s.String()
}

// SetDatasetSummaries sets the DatasetSummaries field's value.
func (s *ListDatasetsOutput) SetDatasetSummaries(v []*DatasetSummary) *ListDatasetsOutput {
	s.DatasetSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetsOutput) SetNextToken(v string) *ListDatasetsOutput {
	s.NextToken = &v
	return s
}

type ListInferenceEventsInput struct {
	_ struct{} `type:"structure"`

	// The name of the inference scheduler for the inference events listed.
	//
	// InferenceSchedulerName is a required field
	InferenceSchedulerName *string `min:"1" type:"string" required:"true"`

	// Returns all the inference events with an end start time equal to or greater
	// than less than the end time given
	//
	// IntervalEndTime is a required field
	IntervalEndTime *time.Time `type:"timestamp" required:"true"`

	// Lookout for Equipment will return all the inference events with an end time
	// equal to or greater than the start time given.
	//
	// IntervalStartTime is a required field
	IntervalStartTime *time.Time `type:"timestamp" required:"true"`

	// Specifies the maximum number of inference events to list.
	MaxResults *int64 `min:"1" type:"integer"`

	// An opaque pagination token indicating where to continue the listing of inference
	// events.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInferenceEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInferenceEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInferenceEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInferenceEventsInput"}
	if s.InferenceSchedulerName == nil {
		invalidParams.Add(request.NewErrParamRequired("InferenceSchedulerName"))
	}
	if s.InferenceSchedulerName != nil && len(*s.InferenceSchedulerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InferenceSchedulerName", 1))
	}
	if s.IntervalEndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("IntervalEndTime"))
	}
	if s.IntervalStartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("IntervalStartTime"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInferenceSchedulerName sets the InferenceSchedulerName field's value.
func (s *ListInferenceEventsInput) SetInferenceSchedulerName(v string) *ListInferenceEventsInput {
	s.InferenceSchedulerName = &v
	return s
}

// SetIntervalEndTime sets the IntervalEndTime field's value.
func (s *ListInferenceEventsInput) SetIntervalEndTime(v time.Time) *ListInferenceEventsInput {
	s.IntervalEndTime = &v
	return s
}

// SetIntervalStartTime sets the IntervalStartTime field's value.
func (s *ListInferenceEventsInput) SetIntervalStartTime(v time.Time) *ListInferenceEventsInput {
	s.IntervalStartTime = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInferenceEventsInput) SetMaxResults(v int64) *ListInferenceEventsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInferenceEventsInput) SetNextToken(v string) *ListInferenceEventsInput {
	s.NextToken = &v
	return s
}

type ListInferenceEventsOutput struct {
	_ struct{} `type:"structure"`

	// Provides an array of information about the individual inference events returned
	// from the ListInferenceEvents operation, including scheduler used, event start
	// time, event end time, diagnostics, and so on.
	InferenceEventSummaries []*InferenceEventSummary `type:"list"`

	// An opaque pagination token indicating where to continue the listing of inference
	// executions.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInferenceEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInferenceEventsOutput) GoString() string {
	return s.String()
}

// SetInferenceEventSummaries sets the InferenceEventSummaries field's value.
func (s *ListInferenceEventsOutput) SetInferenceEventSummaries(v []*InferenceEventSummary) *ListInferenceEventsOutput {
	s.InferenceEventSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInferenceEventsOutput) SetNextToken(v string) *ListInferenceEventsOutput {
	s.NextToken = &v
	return s
}

type ListInferenceExecutionsInput struct {
	_ struct{} `type:"structure"`

	// The time reference in the inferenced dataset before which Amazon Lookout
	// for Equipment stopped the inference execution.
	DataEndTimeBefore *time.Time `type:"timestamp"`

	// The time reference in the inferenced dataset after which Amazon Lookout for
	// Equipment started the inference execution.
	DataStartTimeAfter *time.Time `type:"timestamp"`

	// The name of the inference scheduler for the inference execution listed.
	//
	// InferenceSchedulerName is a required field
	InferenceSchedulerName *string `min:"1" type:"string" required:"true"`

	// Specifies the maximum number of inference executions to list.
	MaxResults *int64 `min:"1" type:"integer"`

	// An opaque pagination token indicating where to continue the listing of inference
	// executions.
	NextToken *string `type:"string"`

	// The status of the inference execution.
	Status *string `type:"string" enum:"InferenceExecutionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInferenceExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInferenceExecutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInferenceExecutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInferenceExecutionsInput"}
	if s.InferenceSchedulerName == nil {
		invalidParams.Add(request.NewErrParamRequired("InferenceSchedulerName"))
	}
	if s.InferenceSchedulerName != nil && len(*s.InferenceSchedulerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InferenceSchedulerName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataEndTimeBefore sets the DataEndTimeBefore field's value.
func (s *ListInferenceExecutionsInput) SetDataEndTimeBefore(v time.Time) *ListInferenceExecutionsInput {
	s.DataEndTimeBefore = &v
	return s
}

// SetDataStartTimeAfter sets the DataStartTimeAfter field's value.
func (s *ListInferenceExecutionsInput) SetDataStartTimeAfter(v time.Time) *ListInferenceExecutionsInput {
	s.DataStartTimeAfter = &v
	return s
}

// SetInferenceSchedulerName sets the InferenceSchedulerName field's value.
func (s *ListInferenceExecutionsInput) SetInferenceSchedulerName(v string) *ListInferenceExecutionsInput {
	s.InferenceSchedulerName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInferenceExecutionsInput) SetMaxResults(v int64) *ListInferenceExecutionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInferenceExecutionsInput) SetNextToken(v string) *ListInferenceExecutionsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListInferenceExecutionsInput) SetStatus(v string) *ListInferenceExecutionsInput {
	s.Status = &v
	return s
}

type ListInferenceExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// Provides an array of information about the individual inference executions
	// returned from the ListInferenceExecutions operation, including model used,
	// inference scheduler, data configuration, and so on.
	InferenceExecutionSummaries []*InferenceExecutionSummary `type:"list"`

	// An opaque pagination token indicating where to continue the listing of inference
	// executions.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInferenceExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInferenceExecutionsOutput) GoString() string {
	return s.String()
}

// SetInferenceExecutionSummaries sets the InferenceExecutionSummaries field's value.
func (s *ListInferenceExecutionsOutput) SetInferenceExecutionSummaries(v []*InferenceExecutionSummary) *ListInferenceExecutionsOutput {
	s.InferenceExecutionSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInferenceExecutionsOutput) SetNextToken(v string) *ListInferenceExecutionsOutput {
	s.NextToken = &v
	return s
}

type ListInferenceSchedulersInput struct {
	_ struct{} `type:"structure"`

	// The beginning of the name of the inference schedulers to be listed.
	InferenceSchedulerNameBeginsWith *string `min:"1" type:"string"`

	// Specifies the maximum number of inference schedulers to list.
	MaxResults *int64 `min:"1" type:"integer"`

	// The name of the ML model used by the inference scheduler to be listed.
	ModelName *string `min:"1" type:"string"`

	// An opaque pagination token indicating where to continue the listing of inference
	// schedulers.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInferenceSchedulersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInferenceSchedulersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInferenceSchedulersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInferenceSchedulersInput"}
	if s.InferenceSchedulerNameBeginsWith != nil && len(*s.InferenceSchedulerNameBeginsWith) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InferenceSchedulerNameBeginsWith", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ModelName != nil && len(*s.ModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInferenceSchedulerNameBeginsWith sets the InferenceSchedulerNameBeginsWith field's value.
func (s *ListInferenceSchedulersInput) SetInferenceSchedulerNameBeginsWith(v string) *ListInferenceSchedulersInput {
	s.InferenceSchedulerNameBeginsWith = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInferenceSchedulersInput) SetMaxResults(v int64) *ListInferenceSchedulersInput {
	s.MaxResults = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *ListInferenceSchedulersInput) SetModelName(v string) *ListInferenceSchedulersInput {
	s.ModelName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInferenceSchedulersInput) SetNextToken(v string) *ListInferenceSchedulersInput {
	s.NextToken = &v
	return s
}

type ListInferenceSchedulersOutput struct {
	_ struct{} `type:"structure"`

	// Provides information about the specified inference scheduler, including data
	// upload frequency, model name and ARN, and status.
	InferenceSchedulerSummaries []*InferenceSchedulerSummary `type:"list"`

	// An opaque pagination token indicating where to continue the listing of inference
	// schedulers.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInferenceSchedulersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInferenceSchedulersOutput) GoString() string {
	return s.String()
}

// SetInferenceSchedulerSummaries sets the InferenceSchedulerSummaries field's value.
func (s *ListInferenceSchedulersOutput) SetInferenceSchedulerSummaries(v []*InferenceSchedulerSummary) *ListInferenceSchedulersOutput {
	s.InferenceSchedulerSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInferenceSchedulersOutput) SetNextToken(v string) *ListInferenceSchedulersOutput {
	s.NextToken = &v
	return s
}

type ListLabelGroupsInput struct {
	_ struct{} `type:"structure"`

	// The beginning of the name of the label groups to be listed.
	LabelGroupNameBeginsWith *string `min:"1" type:"string"`

	// Specifies the maximum number of label groups to list.
	MaxResults *int64 `min:"1" type:"integer"`

	// An opaque pagination token indicating where to continue the listing of label
	// groups.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLabelGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLabelGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLabelGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLabelGroupsInput"}
	if s.LabelGroupNameBeginsWith != nil && len(*s.LabelGroupNameBeginsWith) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LabelGroupNameBeginsWith", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLabelGroupNameBeginsWith sets the LabelGroupNameBeginsWith field's value.
func (s *ListLabelGroupsInput) SetLabelGroupNameBeginsWith(v string) *ListLabelGroupsInput {
	s.LabelGroupNameBeginsWith = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLabelGroupsInput) SetMaxResults(v int64) *ListLabelGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLabelGroupsInput) SetNextToken(v string) *ListLabelGroupsInput {
	s.NextToken = &v
	return s
}

type ListLabelGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A summary of the label groups.
	LabelGroupSummaries []*LabelGroupSummary `type:"list"`

	// An opaque pagination token indicating where to continue the listing of label
	// groups.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLabelGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLabelGroupsOutput) GoString() string {
	return s.String()
}

// SetLabelGroupSummaries sets the LabelGroupSummaries field's value.
func (s *ListLabelGroupsOutput) SetLabelGroupSummaries(v []*LabelGroupSummary) *ListLabelGroupsOutput {
	s.LabelGroupSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLabelGroupsOutput) SetNextToken(v string) *ListLabelGroupsOutput {
	s.NextToken = &v
	return s
}

type ListLabelsInput struct {
	_ struct{} `type:"structure"`

	// Lists the labels that pertain to a particular piece of equipment.
	Equipment *string `min:"1" type:"string"`

	// Returns labels with a particular fault code.
	FaultCode *string `min:"1" type:"string"`

	// Returns all labels with a start time earlier than the end time given.
	IntervalEndTime *time.Time `type:"timestamp"`

	// Returns all the labels with a end time equal to or later than the start time
	// given.
	IntervalStartTime *time.Time `type:"timestamp"`

	// Retruns the name of the label group.
	//
	// LabelGroupName is a required field
	LabelGroupName *string `min:"1" type:"string" required:"true"`

	// Specifies the maximum number of labels to list.
	MaxResults *int64 `min:"1" type:"integer"`

	// An opaque pagination token indicating where to continue the listing of label
	// groups.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLabelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLabelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLabelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLabelsInput"}
	if s.Equipment != nil && len(*s.Equipment) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Equipment", 1))
	}
	if s.FaultCode != nil && len(*s.FaultCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FaultCode", 1))
	}
	if s.LabelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("LabelGroupName"))
	}
	if s.LabelGroupName != nil && len(*s.LabelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LabelGroupName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEquipment sets the Equipment field's value.
func (s *ListLabelsInput) SetEquipment(v string) *ListLabelsInput {
	s.Equipment = &v
	return s
}

// SetFaultCode sets the FaultCode field's value.
func (s *ListLabelsInput) SetFaultCode(v string) *ListLabelsInput {
	s.FaultCode = &v
	return s
}

// SetIntervalEndTime sets the IntervalEndTime field's value.
func (s *ListLabelsInput) SetIntervalEndTime(v time.Time) *ListLabelsInput {
	s.IntervalEndTime = &v
	return s
}

// SetIntervalStartTime sets the IntervalStartTime field's value.
func (s *ListLabelsInput) SetIntervalStartTime(v time.Time) *ListLabelsInput {
	s.IntervalStartTime = &v
	return s
}

// SetLabelGroupName sets the LabelGroupName field's value.
func (s *ListLabelsInput) SetLabelGroupName(v string) *ListLabelsInput {
	s.LabelGroupName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLabelsInput) SetMaxResults(v int64) *ListLabelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLabelsInput) SetNextToken(v string) *ListLabelsInput {
	s.NextToken = &v
	return s
}

type ListLabelsOutput struct {
	_ struct{} `type:"structure"`

	// A summary of the items in the label group.
	LabelSummaries []*LabelSummary `type:"list"`

	// An opaque pagination token indicating where to continue the listing of datasets.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLabelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLabelsOutput) GoString() string {
	return s.String()
}

// SetLabelSummaries sets the LabelSummaries field's value.
func (s *ListLabelsOutput) SetLabelSummaries(v []*LabelSummary) *ListLabelsOutput {
	s.LabelSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLabelsOutput) SetNextToken(v string) *ListLabelsOutput {
	s.NextToken = &v
	return s
}

type ListModelsInput struct {
	_ struct{} `type:"structure"`

	// The beginning of the name of the dataset of the ML models to be listed.
	DatasetNameBeginsWith *string `min:"1" type:"string"`

	// Specifies the maximum number of ML models to list.
	MaxResults *int64 `min:"1" type:"integer"`

	// The beginning of the name of the ML models being listed.
	ModelNameBeginsWith *string `min:"1" type:"string"`

	// An opaque pagination token indicating where to continue the listing of ML
	// models.
	NextToken *string `type:"string"`

	// The status of the ML model.
	Status *string `type:"string" enum:"ModelStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListModelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListModelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListModelsInput"}
	if s.DatasetNameBeginsWith != nil && len(*s.DatasetNameBeginsWith) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetNameBeginsWith", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ModelNameBeginsWith != nil && len(*s.ModelNameBeginsWith) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelNameBeginsWith", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetNameBeginsWith sets the DatasetNameBeginsWith field's value.
func (s *ListModelsInput) SetDatasetNameBeginsWith(v string) *ListModelsInput {
	s.DatasetNameBeginsWith = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListModelsInput) SetMaxResults(v int64) *ListModelsInput {
	s.MaxResults = &v
	return s
}

// SetModelNameBeginsWith sets the ModelNameBeginsWith field's value.
func (s *ListModelsInput) SetModelNameBeginsWith(v string) *ListModelsInput {
	s.ModelNameBeginsWith = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListModelsInput) SetNextToken(v string) *ListModelsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListModelsInput) SetStatus(v string) *ListModelsInput {
	s.Status = &v
	return s
}

type ListModelsOutput struct {
	_ struct{} `type:"structure"`

	// Provides information on the specified model, including created time, model
	// and dataset ARNs, and status.
	ModelSummaries []*ModelSummary `type:"list"`

	// An opaque pagination token indicating where to continue the listing of ML
	// models.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListModelsOutput) GoString() string {
	return s.String()
}

// SetModelSummaries sets the ModelSummaries field's value.
func (s *ListModelsOutput) SetModelSummaries(v []*ModelSummary) *ListModelsOutput {
	s.ModelSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListModelsOutput) SetNextToken(v string) *ListModelsOutput {
	s.NextToken = &v
	return s
}

type ListSensorStatisticsInput struct {
	_ struct{} `type:"structure"`

	// The name of the dataset associated with the list of Sensor Statistics.
	//
	// DatasetName is a required field
	DatasetName *string `min:"1" type:"string" required:"true"`

	// The ingestion job id associated with the list of Sensor Statistics. To get
	// sensor statistics for a particular ingestion job id, both dataset name and
	// ingestion job id must be submitted as inputs.
	IngestionJobId *string `type:"string"`

	// Specifies the maximum number of sensors for which to retrieve statistics.
	MaxResults *int64 `min:"1" type:"integer"`

	// An opaque pagination token indicating where to continue the listing of sensor
	// statistics.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSensorStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSensorStatisticsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSensorStatisticsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSensorStatisticsInput"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetName sets the DatasetName field's value.
func (s *ListSensorStatisticsInput) SetDatasetName(v string) *ListSensorStatisticsInput {
	s.DatasetName = &v
	return s
}

// SetIngestionJobId sets the IngestionJobId field's value.
func (s *ListSensorStatisticsInput) SetIngestionJobId(v string) *ListSensorStatisticsInput {
	s.IngestionJobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSensorStatisticsInput) SetMaxResults(v int64) *ListSensorStatisticsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSensorStatisticsInput) SetNextToken(v string) *ListSensorStatisticsInput {
	s.NextToken = &v
	return s
}

type ListSensorStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// An opaque pagination token indicating where to continue the listing of sensor
	// statistics.
	NextToken *string `type:"string"`

	// Provides ingestion-based statistics regarding the specified sensor with respect
	// to various validation types, such as whether data exists, the number and
	// percentage of missing values, and the number and percentage of duplicate
	// timestamps.
	SensorStatisticsSummaries []*SensorStatisticsSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSensorStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSensorStatisticsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSensorStatisticsOutput) SetNextToken(v string) *ListSensorStatisticsOutput {
	s.NextToken = &v
	return s
}

// SetSensorStatisticsSummaries sets the SensorStatisticsSummaries field's value.
func (s *ListSensorStatisticsOutput) SetSensorStatisticsSummaries(v []*SensorStatisticsSummary) *ListSensorStatisticsOutput {
	s.SensorStatisticsSummaries = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource (such as the dataset or model)
	// that is the focus of the ListTagsForResource operation.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Any tags associated with the resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Entity that comprises information on sensors that have sensor data completely
// missing.
type MissingCompleteSensorData struct {
	_ struct{} `type:"structure"`

	// Indicates the number of sensors that have data missing completely.
	//
	// AffectedSensorCount is a required field
	AffectedSensorCount *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MissingCompleteSensorData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MissingCompleteSensorData) GoString() string {
	return s.String()
}

// SetAffectedSensorCount sets the AffectedSensorCount field's value.
func (s *MissingCompleteSensorData) SetAffectedSensorCount(v int64) *MissingCompleteSensorData {
	s.AffectedSensorCount = &v
	return s
}

// Entity that comprises aggregated information on sensors having missing data.
type MissingSensorData struct {
	_ struct{} `type:"structure"`

	// Indicates the number of sensors that have atleast some data missing.
	//
	// AffectedSensorCount is a required field
	AffectedSensorCount *int64 `type:"integer" required:"true"`

	// Indicates the total number of missing values across all the sensors.
	//
	// TotalNumberOfMissingValues is a required field
	TotalNumberOfMissingValues *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MissingSensorData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MissingSensorData) GoString() string {
	return s.String()
}

// SetAffectedSensorCount sets the AffectedSensorCount field's value.
func (s *MissingSensorData) SetAffectedSensorCount(v int64) *MissingSensorData {
	s.AffectedSensorCount = &v
	return s
}

// SetTotalNumberOfMissingValues sets the TotalNumberOfMissingValues field's value.
func (s *MissingSensorData) SetTotalNumberOfMissingValues(v int64) *MissingSensorData {
	s.TotalNumberOfMissingValues = &v
	return s
}

// Provides information about the specified ML model, including dataset and
// model names and ARNs, as well as status.
type ModelSummary struct {
	_ struct{} `type:"structure"`

	// The time at which the specific model was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset used to create the model.
	DatasetArn *string `min:"20" type:"string"`

	// The name of the dataset being used for the ML model.
	DatasetName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the ML model.
	ModelArn *string `min:"20" type:"string"`

	// The name of the ML model.
	ModelName *string `min:"1" type:"string"`

	// Indicates the status of the ML model.
	Status *string `type:"string" enum:"ModelStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ModelSummary) SetCreatedAt(v time.Time) *ModelSummary {
	s.CreatedAt = &v
	return s
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *ModelSummary) SetDatasetArn(v string) *ModelSummary {
	s.DatasetArn = &v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *ModelSummary) SetDatasetName(v string) *ModelSummary {
	s.DatasetName = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *ModelSummary) SetModelArn(v string) *ModelSummary {
	s.ModelArn = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *ModelSummary) SetModelName(v string) *ModelSummary {
	s.ModelName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ModelSummary) SetStatus(v string) *ModelSummary {
	s.Status = &v
	return s
}

// Entity that comprises information on monotonic values in the data.
type MonotonicValues struct {
	_ struct{} `type:"structure"`

	// Indicates the monotonicity of values. Can be INCREASING, DECREASING, or STATIC.
	Monotonicity *string `type:"string" enum:"Monotonicity"`

	// Indicates whether there is a potential data issue related to having monotonic
	// values.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"StatisticalIssueStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonotonicValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonotonicValues) GoString() string {
	return s.String()
}

// SetMonotonicity sets the Monotonicity field's value.
func (s *MonotonicValues) SetMonotonicity(v string) *MonotonicValues {
	s.Monotonicity = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *MonotonicValues) SetStatus(v string) *MonotonicValues {
	s.Status = &v
	return s
}

// Entity that comprises information on operating modes in data.
type MultipleOperatingModes struct {
	_ struct{} `type:"structure"`

	// Indicates whether there is a potential data issue related to having multiple
	// operating modes.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"StatisticalIssueStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultipleOperatingModes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultipleOperatingModes) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *MultipleOperatingModes) SetStatus(v string) *MultipleOperatingModes {
	s.Status = &v
	return s
}

// The resource requested could not be found. Verify the resource ID and retry
// your request.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about an S3 bucket.
type S3Object struct {
	_ struct{} `type:"structure"`

	// The name of the specific S3 bucket.
	//
	// Bucket is a required field
	Bucket *string `min:"3" type:"string" required:"true"`

	// The AWS Key Management Service (AWS KMS) key being used to encrypt the S3
	// object. Without this key, data in the bucket is not accessible.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Object) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Object) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *S3Object) SetBucket(v string) *S3Object {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *S3Object) SetKey(v string) *S3Object {
	s.Key = &v
	return s
}

// Summary of ingestion statistics like whether data exists, number of missing
// values, number of invalid values and so on related to the particular sensor.
type SensorStatisticsSummary struct {
	_ struct{} `type:"structure"`

	// Parameter that describes potential risk about whether data associated with
	// the sensor is categorical.
	CategoricalValues *CategoricalValues `type:"structure"`

	// Name of the component to which the particular sensor belongs for which the
	// statistics belong to.
	ComponentName *string `min:"1" type:"string"`

	// Indicates the time reference to indicate the end of valid data associated
	// with the sensor that the statistics belong to.
	DataEndTime *time.Time `type:"timestamp"`

	// Parameter that indicates whether data exists for the sensor that the statistics
	// belong to.
	DataExists *bool `type:"boolean"`

	// Indicates the time reference to indicate the beginning of valid data associated
	// with the sensor that the statistics belong to.
	DataStartTime *time.Time `type:"timestamp"`

	// Parameter that describes the total number of duplicate timestamp records
	// associated with the sensor that the statistics belong to.
	DuplicateTimestamps *CountPercent `type:"structure"`

	// Parameter that describes the total number of invalid date entries associated
	// with the sensor that the statistics belong to.
	InvalidDateEntries *CountPercent `type:"structure"`

	// Parameter that describes the total number of, and percentage of, values that
	// are invalid for the sensor that the statistics belong to.
	InvalidValues *CountPercent `type:"structure"`

	// Parameter that describes potential risk about whether data associated with
	// the sensor contains one or more large gaps between consecutive timestamps.
	LargeTimestampGaps *LargeTimestampGaps `type:"structure"`

	// Parameter that describes the total number of, and percentage of, values that
	// are missing for the sensor that the statistics belong to.
	MissingValues *CountPercent `type:"structure"`

	// Parameter that describes potential risk about whether data associated with
	// the sensor is mostly monotonic.
	MonotonicValues *MonotonicValues `type:"structure"`

	// Parameter that describes potential risk about whether data associated with
	// the sensor has more than one operating mode.
	MultipleOperatingModes *MultipleOperatingModes `type:"structure"`

	// Name of the sensor that the statistics belong to.
	SensorName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SensorStatisticsSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SensorStatisticsSummary) GoString() string {
	return s.String()
}

// SetCategoricalValues sets the CategoricalValues field's value.
func (s *SensorStatisticsSummary) SetCategoricalValues(v *CategoricalValues) *SensorStatisticsSummary {
	s.CategoricalValues = v
	return s
}

// SetComponentName sets the ComponentName field's value.
func (s *SensorStatisticsSummary) SetComponentName(v string) *SensorStatisticsSummary {
	s.ComponentName = &v
	return s
}

// SetDataEndTime sets the DataEndTime field's value.
func (s *SensorStatisticsSummary) SetDataEndTime(v time.Time) *SensorStatisticsSummary {
	s.DataEndTime = &v
	return s
}

// SetDataExists sets the DataExists field's value.
func (s *SensorStatisticsSummary) SetDataExists(v bool) *SensorStatisticsSummary {
	s.DataExists = &v
	return s
}

// SetDataStartTime sets the DataStartTime field's value.
func (s *SensorStatisticsSummary) SetDataStartTime(v time.Time) *SensorStatisticsSummary {
	s.DataStartTime = &v
	return s
}

// SetDuplicateTimestamps sets the DuplicateTimestamps field's value.
func (s *SensorStatisticsSummary) SetDuplicateTimestamps(v *CountPercent) *SensorStatisticsSummary {
	s.DuplicateTimestamps = v
	return s
}

// SetInvalidDateEntries sets the InvalidDateEntries field's value.
func (s *SensorStatisticsSummary) SetInvalidDateEntries(v *CountPercent) *SensorStatisticsSummary {
	s.InvalidDateEntries = v
	return s
}

// SetInvalidValues sets the InvalidValues field's value.
func (s *SensorStatisticsSummary) SetInvalidValues(v *CountPercent) *SensorStatisticsSummary {
	s.InvalidValues = v
	return s
}

// SetLargeTimestampGaps sets the LargeTimestampGaps field's value.
func (s *SensorStatisticsSummary) SetLargeTimestampGaps(v *LargeTimestampGaps) *SensorStatisticsSummary {
	s.LargeTimestampGaps = v
	return s
}

// SetMissingValues sets the MissingValues field's value.
func (s *SensorStatisticsSummary) SetMissingValues(v *CountPercent) *SensorStatisticsSummary {
	s.MissingValues = v
	return s
}

// SetMonotonicValues sets the MonotonicValues field's value.
func (s *SensorStatisticsSummary) SetMonotonicValues(v *MonotonicValues) *SensorStatisticsSummary {
	s.MonotonicValues = v
	return s
}

// SetMultipleOperatingModes sets the MultipleOperatingModes field's value.
func (s *SensorStatisticsSummary) SetMultipleOperatingModes(v *MultipleOperatingModes) *SensorStatisticsSummary {
	s.MultipleOperatingModes = v
	return s
}

// SetSensorName sets the SensorName field's value.
func (s *SensorStatisticsSummary) SetSensorName(v string) *SensorStatisticsSummary {
	s.SensorName = &v
	return s
}

// Entity that comprises information on sensors that have shorter date range.
type SensorsWithShortDateRange struct {
	_ struct{} `type:"structure"`

	// Indicates the number of sensors that have less than 90 days of data.
	//
	// AffectedSensorCount is a required field
	AffectedSensorCount *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SensorsWithShortDateRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SensorsWithShortDateRange) GoString() string {
	return s.String()
}

// SetAffectedSensorCount sets the AffectedSensorCount field's value.
func (s *SensorsWithShortDateRange) SetAffectedSensorCount(v int64) *SensorsWithShortDateRange {
	s.AffectedSensorCount = &v
	return s
}

// Resource limitations have been exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartDataIngestionJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you do not set the client request
	// token, Amazon Lookout for Equipment generates one.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The name of the dataset being used by the data ingestion job.
	//
	// DatasetName is a required field
	DatasetName *string `min:"1" type:"string" required:"true"`

	// Specifies information for the input data for the data ingestion job, including
	// dataset S3 location.
	//
	// IngestionInputConfiguration is a required field
	IngestionInputConfiguration *IngestionInputConfiguration `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of a role with permission to access the data
	// source for the data ingestion job.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDataIngestionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDataIngestionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDataIngestionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDataIngestionJobInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.IngestionInputConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionInputConfiguration"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.IngestionInputConfiguration != nil {
		if err := s.IngestionInputConfiguration.Validate(); err != nil {
			invalidParams.AddNested("IngestionInputConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartDataIngestionJobInput) SetClientToken(v string) *StartDataIngestionJobInput {
	s.ClientToken = &v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *StartDataIngestionJobInput) SetDatasetName(v string) *StartDataIngestionJobInput {
	s.DatasetName = &v
	return s
}

// SetIngestionInputConfiguration sets the IngestionInputConfiguration field's value.
func (s *StartDataIngestionJobInput) SetIngestionInputConfiguration(v *IngestionInputConfiguration) *StartDataIngestionJobInput {
	s.IngestionInputConfiguration = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *StartDataIngestionJobInput) SetRoleArn(v string) *StartDataIngestionJobInput {
	s.RoleArn = &v
	return s
}

type StartDataIngestionJobOutput struct {
	_ struct{} `type:"structure"`

	// Indicates the job ID of the data ingestion job.
	JobId *string `type:"string"`

	// Indicates the status of the StartDataIngestionJob operation.
	Status *string `type:"string" enum:"IngestionJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDataIngestionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDataIngestionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartDataIngestionJobOutput) SetJobId(v string) *StartDataIngestionJobOutput {
	s.JobId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StartDataIngestionJobOutput) SetStatus(v string) *StartDataIngestionJobOutput {
	s.Status = &v
	return s
}

type StartInferenceSchedulerInput struct {
	_ struct{} `type:"structure"`

	// The name of the inference scheduler to be started.
	//
	// InferenceSchedulerName is a required field
	InferenceSchedulerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartInferenceSchedulerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartInferenceSchedulerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartInferenceSchedulerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartInferenceSchedulerInput"}
	if s.InferenceSchedulerName == nil {
		invalidParams.Add(request.NewErrParamRequired("InferenceSchedulerName"))
	}
	if s.InferenceSchedulerName != nil && len(*s.InferenceSchedulerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InferenceSchedulerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInferenceSchedulerName sets the InferenceSchedulerName field's value.
func (s *StartInferenceSchedulerInput) SetInferenceSchedulerName(v string) *StartInferenceSchedulerInput {
	s.InferenceSchedulerName = &v
	return s
}

type StartInferenceSchedulerOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the inference scheduler being started.
	InferenceSchedulerArn *string `min:"20" type:"string"`

	// The name of the inference scheduler being started.
	InferenceSchedulerName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the ML model being used by the inference
	// scheduler.
	ModelArn *string `min:"20" type:"string"`

	// The name of the ML model being used by the inference scheduler.
	ModelName *string `min:"1" type:"string"`

	// Indicates the status of the inference scheduler.
	Status *string `type:"string" enum:"InferenceSchedulerStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartInferenceSchedulerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartInferenceSchedulerOutput) GoString() string {
	return s.String()
}

// SetInferenceSchedulerArn sets the InferenceSchedulerArn field's value.
func (s *StartInferenceSchedulerOutput) SetInferenceSchedulerArn(v string) *StartInferenceSchedulerOutput {
	s.InferenceSchedulerArn = &v
	return s
}

// SetInferenceSchedulerName sets the InferenceSchedulerName field's value.
func (s *StartInferenceSchedulerOutput) SetInferenceSchedulerName(v string) *StartInferenceSchedulerOutput {
	s.InferenceSchedulerName = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *StartInferenceSchedulerOutput) SetModelArn(v string) *StartInferenceSchedulerOutput {
	s.ModelArn = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *StartInferenceSchedulerOutput) SetModelName(v string) *StartInferenceSchedulerOutput {
	s.ModelName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StartInferenceSchedulerOutput) SetStatus(v string) *StartInferenceSchedulerOutput {
	s.Status = &v
	return s
}

type StopInferenceSchedulerInput struct {
	_ struct{} `type:"structure"`

	// The name of the inference scheduler to be stopped.
	//
	// InferenceSchedulerName is a required field
	InferenceSchedulerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopInferenceSchedulerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopInferenceSchedulerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopInferenceSchedulerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopInferenceSchedulerInput"}
	if s.InferenceSchedulerName == nil {
		invalidParams.Add(request.NewErrParamRequired("InferenceSchedulerName"))
	}
	if s.InferenceSchedulerName != nil && len(*s.InferenceSchedulerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InferenceSchedulerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInferenceSchedulerName sets the InferenceSchedulerName field's value.
func (s *StopInferenceSchedulerInput) SetInferenceSchedulerName(v string) *StopInferenceSchedulerInput {
	s.InferenceSchedulerName = &v
	return s
}

type StopInferenceSchedulerOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the inference schedule being stopped.
	InferenceSchedulerArn *string `min:"20" type:"string"`

	// The name of the inference scheduler being stopped.
	InferenceSchedulerName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the ML model used by the inference scheduler
	// being stopped.
	ModelArn *string `min:"20" type:"string"`

	// The name of the ML model used by the inference scheduler being stopped.
	ModelName *string `min:"1" type:"string"`

	// Indicates the status of the inference scheduler.
	Status *string `type:"string" enum:"InferenceSchedulerStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopInferenceSchedulerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopInferenceSchedulerOutput) GoString() string {
	return s.String()
}

// SetInferenceSchedulerArn sets the InferenceSchedulerArn field's value.
func (s *StopInferenceSchedulerOutput) SetInferenceSchedulerArn(v string) *StopInferenceSchedulerOutput {
	s.InferenceSchedulerArn = &v
	return s
}

// SetInferenceSchedulerName sets the InferenceSchedulerName field's value.
func (s *StopInferenceSchedulerOutput) SetInferenceSchedulerName(v string) *StopInferenceSchedulerOutput {
	s.InferenceSchedulerName = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *StopInferenceSchedulerOutput) SetModelArn(v string) *StopInferenceSchedulerOutput {
	s.ModelArn = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *StopInferenceSchedulerOutput) SetModelName(v string) *StopInferenceSchedulerOutput {
	s.ModelName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StopInferenceSchedulerOutput) SetStatus(v string) *StopInferenceSchedulerOutput {
	s.Status = &v
	return s
}

// A tag is a key-value pair that can be added to a resource as metadata.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key for the specified tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value for the specified tag.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the specific resource to which the tag
	// should be associated.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// The tag or tags to be associated with a specific resource. Both the tag key
	// and value are specified.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Entity that comprises information abount unsupported timestamps in the dataset.
type UnsupportedTimestamps struct {
	_ struct{} `type:"structure"`

	// Indicates the total number of unsupported timestamps across the ingested
	// data.
	//
	// TotalNumberOfUnsupportedTimestamps is a required field
	TotalNumberOfUnsupportedTimestamps *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedTimestamps) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedTimestamps) GoString() string {
	return s.String()
}

// SetTotalNumberOfUnsupportedTimestamps sets the TotalNumberOfUnsupportedTimestamps field's value.
func (s *UnsupportedTimestamps) SetTotalNumberOfUnsupportedTimestamps(v int64) *UnsupportedTimestamps {
	s.TotalNumberOfUnsupportedTimestamps = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to which the tag is currently
	// associated.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// Specifies the key of the tag to be removed from a specified resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateInferenceSchedulerInput struct {
	_ struct{} `type:"structure"`

	// A period of time (in minutes) by which inference on the data is delayed after
	// the data starts. For instance, if you select an offset delay time of five
	// minutes, inference will not begin on the data until the first data measurement
	// after the five minute mark. For example, if five minutes is selected, the
	// inference scheduler will wake up at the configured frequency with the additional
	// five minute delay time to check the customer S3 bucket. The customer can
	// upload data at the same frequency and they don't need to stop and restart
	// the scheduler when uploading new data.
	DataDelayOffsetInMinutes *int64 `type:"long"`

	// Specifies information for the input data for the inference scheduler, including
	// delimiter, format, and dataset location.
	DataInputConfiguration *InferenceInputConfiguration `type:"structure"`

	// Specifies information for the output results from the inference scheduler,
	// including the output S3 location.
	DataOutputConfiguration *InferenceOutputConfiguration `type:"structure"`

	// How often data is uploaded to the source S3 bucket for the input data. The
	// value chosen is the length of time between data uploads. For instance, if
	// you select 5 minutes, Amazon Lookout for Equipment will upload the real-time
	// data to the source bucket once every 5 minutes. This frequency also determines
	// how often Amazon Lookout for Equipment starts a scheduled inference on your
	// data. In this example, it starts once every 5 minutes.
	DataUploadFrequency *string `type:"string" enum:"DataUploadFrequency"`

	// The name of the inference scheduler to be updated.
	//
	// InferenceSchedulerName is a required field
	InferenceSchedulerName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of a role with permission to access the data
	// source for the inference scheduler.
	RoleArn *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInferenceSchedulerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInferenceSchedulerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateInferenceSchedulerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateInferenceSchedulerInput"}
	if s.InferenceSchedulerName == nil {
		invalidParams.Add(request.NewErrParamRequired("InferenceSchedulerName"))
	}
	if s.InferenceSchedulerName != nil && len(*s.InferenceSchedulerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InferenceSchedulerName", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.DataInputConfiguration != nil {
		if err := s.DataInputConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DataInputConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.DataOutputConfiguration != nil {
		if err := s.DataOutputConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DataOutputConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataDelayOffsetInMinutes sets the DataDelayOffsetInMinutes field's value.
func (s *UpdateInferenceSchedulerInput) SetDataDelayOffsetInMinutes(v int64) *UpdateInferenceSchedulerInput {
	s.DataDelayOffsetInMinutes = &v
	return s
}

// SetDataInputConfiguration sets the DataInputConfiguration field's value.
func (s *UpdateInferenceSchedulerInput) SetDataInputConfiguration(v *InferenceInputConfiguration) *UpdateInferenceSchedulerInput {
	s.DataInputConfiguration = v
	return s
}

// SetDataOutputConfiguration sets the DataOutputConfiguration field's value.
func (s *UpdateInferenceSchedulerInput) SetDataOutputConfiguration(v *InferenceOutputConfiguration) *UpdateInferenceSchedulerInput {
	s.DataOutputConfiguration = v
	return s
}

// SetDataUploadFrequency sets the DataUploadFrequency field's value.
func (s *UpdateInferenceSchedulerInput) SetDataUploadFrequency(v string) *UpdateInferenceSchedulerInput {
	s.DataUploadFrequency = &v
	return s
}

// SetInferenceSchedulerName sets the InferenceSchedulerName field's value.
func (s *UpdateInferenceSchedulerInput) SetInferenceSchedulerName(v string) *UpdateInferenceSchedulerInput {
	s.InferenceSchedulerName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateInferenceSchedulerInput) SetRoleArn(v string) *UpdateInferenceSchedulerInput {
	s.RoleArn = &v
	return s
}

type UpdateInferenceSchedulerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInferenceSchedulerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInferenceSchedulerOutput) GoString() string {
	return s.String()
}

type UpdateLabelGroupInput struct {
	_ struct{} `type:"structure"`

	// Updates the code indicating the type of anomaly associated with the label.
	//
	// Data in this field will be retained for service usage. Follow best practices
	// for the security of your data.
	FaultCodes []*string `type:"list"`

	// The name of the label group to be updated.
	//
	// LabelGroupName is a required field
	LabelGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLabelGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLabelGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLabelGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLabelGroupInput"}
	if s.LabelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("LabelGroupName"))
	}
	if s.LabelGroupName != nil && len(*s.LabelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LabelGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFaultCodes sets the FaultCodes field's value.
func (s *UpdateLabelGroupInput) SetFaultCodes(v []*string) *UpdateLabelGroupInput {
	s.FaultCodes = v
	return s
}

// SetLabelGroupName sets the LabelGroupName field's value.
func (s *UpdateLabelGroupInput) SetLabelGroupName(v string) *UpdateLabelGroupInput {
	s.LabelGroupName = &v
	return s
}

type UpdateLabelGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLabelGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLabelGroupOutput) GoString() string {
	return s.String()
}

// The input fails to satisfy constraints specified by Amazon Lookout for Equipment
// or a related AWS service that's being utilized.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// DataUploadFrequencyPt5m is a DataUploadFrequency enum value
	DataUploadFrequencyPt5m = "PT5M"

	// DataUploadFrequencyPt10m is a DataUploadFrequency enum value
	DataUploadFrequencyPt10m = "PT10M"

	// DataUploadFrequencyPt15m is a DataUploadFrequency enum value
	DataUploadFrequencyPt15m = "PT15M"

	// DataUploadFrequencyPt30m is a DataUploadFrequency enum value
	DataUploadFrequencyPt30m = "PT30M"

	// DataUploadFrequencyPt1h is a DataUploadFrequency enum value
	DataUploadFrequencyPt1h = "PT1H"
)

// DataUploadFrequency_Values returns all elements of the DataUploadFrequency enum
func DataUploadFrequency_Values() []string {
	return []string{
		DataUploadFrequencyPt5m,
		DataUploadFrequencyPt10m,
		DataUploadFrequencyPt15m,
		DataUploadFrequencyPt30m,
		DataUploadFrequencyPt1h,
	}
}

const (
	// DatasetStatusCreated is a DatasetStatus enum value
	DatasetStatusCreated = "CREATED"

	// DatasetStatusIngestionInProgress is a DatasetStatus enum value
	DatasetStatusIngestionInProgress = "INGESTION_IN_PROGRESS"

	// DatasetStatusActive is a DatasetStatus enum value
	DatasetStatusActive = "ACTIVE"
)

// DatasetStatus_Values returns all elements of the DatasetStatus enum
func DatasetStatus_Values() []string {
	return []string{
		DatasetStatusCreated,
		DatasetStatusIngestionInProgress,
		DatasetStatusActive,
	}
}

const (
	// InferenceExecutionStatusInProgress is a InferenceExecutionStatus enum value
	InferenceExecutionStatusInProgress = "IN_PROGRESS"

	// InferenceExecutionStatusSuccess is a InferenceExecutionStatus enum value
	InferenceExecutionStatusSuccess = "SUCCESS"

	// InferenceExecutionStatusFailed is a InferenceExecutionStatus enum value
	InferenceExecutionStatusFailed = "FAILED"
)

// InferenceExecutionStatus_Values returns all elements of the InferenceExecutionStatus enum
func InferenceExecutionStatus_Values() []string {
	return []string{
		InferenceExecutionStatusInProgress,
		InferenceExecutionStatusSuccess,
		InferenceExecutionStatusFailed,
	}
}

const (
	// InferenceSchedulerStatusPending is a InferenceSchedulerStatus enum value
	InferenceSchedulerStatusPending = "PENDING"

	// InferenceSchedulerStatusRunning is a InferenceSchedulerStatus enum value
	InferenceSchedulerStatusRunning = "RUNNING"

	// InferenceSchedulerStatusStopping is a InferenceSchedulerStatus enum value
	InferenceSchedulerStatusStopping = "STOPPING"

	// InferenceSchedulerStatusStopped is a InferenceSchedulerStatus enum value
	InferenceSchedulerStatusStopped = "STOPPED"
)

// InferenceSchedulerStatus_Values returns all elements of the InferenceSchedulerStatus enum
func InferenceSchedulerStatus_Values() []string {
	return []string{
		InferenceSchedulerStatusPending,
		InferenceSchedulerStatusRunning,
		InferenceSchedulerStatusStopping,
		InferenceSchedulerStatusStopped,
	}
}

const (
	// IngestionJobStatusInProgress is a IngestionJobStatus enum value
	IngestionJobStatusInProgress = "IN_PROGRESS"

	// IngestionJobStatusSuccess is a IngestionJobStatus enum value
	IngestionJobStatusSuccess = "SUCCESS"

	// IngestionJobStatusFailed is a IngestionJobStatus enum value
	IngestionJobStatusFailed = "FAILED"
)

// IngestionJobStatus_Values returns all elements of the IngestionJobStatus enum
func IngestionJobStatus_Values() []string {
	return []string{
		IngestionJobStatusInProgress,
		IngestionJobStatusSuccess,
		IngestionJobStatusFailed,
	}
}

const (
	// LabelRatingAnomaly is a LabelRating enum value
	LabelRatingAnomaly = "ANOMALY"

	// LabelRatingNoAnomaly is a LabelRating enum value
	LabelRatingNoAnomaly = "NO_ANOMALY"

	// LabelRatingNeutral is a LabelRating enum value
	LabelRatingNeutral = "NEUTRAL"
)

// LabelRating_Values returns all elements of the LabelRating enum
func LabelRating_Values() []string {
	return []string{
		LabelRatingAnomaly,
		LabelRatingNoAnomaly,
		LabelRatingNeutral,
	}
}

const (
	// LatestInferenceResultAnomalous is a LatestInferenceResult enum value
	LatestInferenceResultAnomalous = "ANOMALOUS"

	// LatestInferenceResultNormal is a LatestInferenceResult enum value
	LatestInferenceResultNormal = "NORMAL"
)

// LatestInferenceResult_Values returns all elements of the LatestInferenceResult enum
func LatestInferenceResult_Values() []string {
	return []string{
		LatestInferenceResultAnomalous,
		LatestInferenceResultNormal,
	}
}

const (
	// ModelStatusInProgress is a ModelStatus enum value
	ModelStatusInProgress = "IN_PROGRESS"

	// ModelStatusSuccess is a ModelStatus enum value
	ModelStatusSuccess = "SUCCESS"

	// ModelStatusFailed is a ModelStatus enum value
	ModelStatusFailed = "FAILED"
)

// ModelStatus_Values returns all elements of the ModelStatus enum
func ModelStatus_Values() []string {
	return []string{
		ModelStatusInProgress,
		ModelStatusSuccess,
		ModelStatusFailed,
	}
}

const (
	// MonotonicityDecreasing is a Monotonicity enum value
	MonotonicityDecreasing = "DECREASING"

	// MonotonicityIncreasing is a Monotonicity enum value
	MonotonicityIncreasing = "INCREASING"

	// MonotonicityStatic is a Monotonicity enum value
	MonotonicityStatic = "STATIC"
)

// Monotonicity_Values returns all elements of the Monotonicity enum
func Monotonicity_Values() []string {
	return []string{
		MonotonicityDecreasing,
		MonotonicityIncreasing,
		MonotonicityStatic,
	}
}

const (
	// StatisticalIssueStatusPotentialIssueDetected is a StatisticalIssueStatus enum value
	StatisticalIssueStatusPotentialIssueDetected = "POTENTIAL_ISSUE_DETECTED"

	// StatisticalIssueStatusNoIssueDetected is a StatisticalIssueStatus enum value
	StatisticalIssueStatusNoIssueDetected = "NO_ISSUE_DETECTED"
)

// StatisticalIssueStatus_Values returns all elements of the StatisticalIssueStatus enum
func StatisticalIssueStatus_Values() []string {
	return []string{
		StatisticalIssueStatusPotentialIssueDetected,
		StatisticalIssueStatusNoIssueDetected,
	}
}

const (
	// TargetSamplingRatePt1s is a TargetSamplingRate enum value
	TargetSamplingRatePt1s = "PT1S"

	// TargetSamplingRatePt5s is a TargetSamplingRate enum value
	TargetSamplingRatePt5s = "PT5S"

	// TargetSamplingRatePt10s is a TargetSamplingRate enum value
	TargetSamplingRatePt10s = "PT10S"

	// TargetSamplingRatePt15s is a TargetSamplingRate enum value
	TargetSamplingRatePt15s = "PT15S"

	// TargetSamplingRatePt30s is a TargetSamplingRate enum value
	TargetSamplingRatePt30s = "PT30S"

	// TargetSamplingRatePt1m is a TargetSamplingRate enum value
	TargetSamplingRatePt1m = "PT1M"

	// TargetSamplingRatePt5m is a TargetSamplingRate enum value
	TargetSamplingRatePt5m = "PT5M"

	// TargetSamplingRatePt10m is a TargetSamplingRate enum value
	TargetSamplingRatePt10m = "PT10M"

	// TargetSamplingRatePt15m is a TargetSamplingRate enum value
	TargetSamplingRatePt15m = "PT15M"

	// TargetSamplingRatePt30m is a TargetSamplingRate enum value
	TargetSamplingRatePt30m = "PT30M"

	// TargetSamplingRatePt1h is a TargetSamplingRate enum value
	TargetSamplingRatePt1h = "PT1H"
)

// TargetSamplingRate_Values returns all elements of the TargetSamplingRate enum
func TargetSamplingRate_Values() []string {
	return []string{
		TargetSamplingRatePt1s,
		TargetSamplingRatePt5s,
		TargetSamplingRatePt10s,
		TargetSamplingRatePt15s,
		TargetSamplingRatePt30s,
		TargetSamplingRatePt1m,
		TargetSamplingRatePt5m,
		TargetSamplingRatePt10m,
		TargetSamplingRatePt15m,
		TargetSamplingRatePt30m,
		TargetSamplingRatePt1h,
	}
}
