// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudfront

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudfront/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists distributions by connection function.
func (c *Client) ListDistributionsByConnectionFunction(ctx context.Context, params *ListDistributionsByConnectionFunctionInput, optFns ...func(*Options)) (*ListDistributionsByConnectionFunctionOutput, error) {
	if params == nil {
		params = &ListDistributionsByConnectionFunctionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDistributionsByConnectionFunction", params, optFns, c.addOperationListDistributionsByConnectionFunctionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDistributionsByConnectionFunctionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDistributionsByConnectionFunctionInput struct {

	// The distributions by connection function identifier.
	//
	// This member is required.
	ConnectionFunctionIdentifier *string

	// Use this field when paginating results to indicate where to begin in your list.
	// The response includes items in the list that occur after the marker. To get the
	// next page of the list, set this field's value to the value of NextMarker from
	// the current page's response.
	Marker *string

	// The maximum number of distributions that you want returned in the response.
	MaxItems *int32

	noSmithyDocumentSerde
}

type ListDistributionsByConnectionFunctionOutput struct {

	// A distribution list.
	DistributionList *types.DistributionList

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDistributionsByConnectionFunctionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpListDistributionsByConnectionFunction{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpListDistributionsByConnectionFunction{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDistributionsByConnectionFunction"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListDistributionsByConnectionFunctionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDistributionsByConnectionFunction(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListDistributionsByConnectionFunctionPaginatorOptions is the paginator options
// for ListDistributionsByConnectionFunction
type ListDistributionsByConnectionFunctionPaginatorOptions struct {
	// The maximum number of distributions that you want returned in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDistributionsByConnectionFunctionPaginator is a paginator for
// ListDistributionsByConnectionFunction
type ListDistributionsByConnectionFunctionPaginator struct {
	options   ListDistributionsByConnectionFunctionPaginatorOptions
	client    ListDistributionsByConnectionFunctionAPIClient
	params    *ListDistributionsByConnectionFunctionInput
	nextToken *string
	firstPage bool
}

// NewListDistributionsByConnectionFunctionPaginator returns a new
// ListDistributionsByConnectionFunctionPaginator
func NewListDistributionsByConnectionFunctionPaginator(client ListDistributionsByConnectionFunctionAPIClient, params *ListDistributionsByConnectionFunctionInput, optFns ...func(*ListDistributionsByConnectionFunctionPaginatorOptions)) *ListDistributionsByConnectionFunctionPaginator {
	if params == nil {
		params = &ListDistributionsByConnectionFunctionInput{}
	}

	options := ListDistributionsByConnectionFunctionPaginatorOptions{}
	if params.MaxItems != nil {
		options.Limit = *params.MaxItems
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDistributionsByConnectionFunctionPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDistributionsByConnectionFunctionPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDistributionsByConnectionFunction page.
func (p *ListDistributionsByConnectionFunctionPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDistributionsByConnectionFunctionOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxItems = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDistributionsByConnectionFunction(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = nil
	if result.DistributionList != nil {
		p.nextToken = result.DistributionList.NextMarker
	}

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDistributionsByConnectionFunctionAPIClient is a client that implements the
// ListDistributionsByConnectionFunction operation.
type ListDistributionsByConnectionFunctionAPIClient interface {
	ListDistributionsByConnectionFunction(context.Context, *ListDistributionsByConnectionFunctionInput, ...func(*Options)) (*ListDistributionsByConnectionFunctionOutput, error)
}

var _ ListDistributionsByConnectionFunctionAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDistributionsByConnectionFunction(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDistributionsByConnectionFunction",
	}
}
