package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryUnionChannel invokes the unimkt.QueryUnionChannel API synchronously
func (client *Client) QueryUnionChannel(request *QueryUnionChannelRequest) (response *QueryUnionChannelResponse, err error) {
	response = CreateQueryUnionChannelResponse()
	err = client.DoAction(request, response)
	return
}

// QueryUnionChannelWithChan invokes the unimkt.QueryUnionChannel API asynchronously
func (client *Client) QueryUnionChannelWithChan(request *QueryUnionChannelRequest) (<-chan *QueryUnionChannelResponse, <-chan error) {
	responseChan := make(chan *QueryUnionChannelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryUnionChannel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryUnionChannelWithCallback invokes the unimkt.QueryUnionChannel API asynchronously
func (client *Client) QueryUnionChannelWithCallback(request *QueryUnionChannelRequest, callback func(response *QueryUnionChannelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryUnionChannelResponse
		var err error
		defer close(result)
		response, err = client.QueryUnionChannel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryUnionChannelRequest is the request struct for api QueryUnionChannel
type QueryUnionChannelRequest struct {
	*requests.RpcRequest
	ChannelId string `position:"Query" name:"ChannelId"`
}

// QueryUnionChannelResponse is the response struct for api QueryUnionChannel
type QueryUnionChannelResponse struct {
	*responses.BaseResponse
	Code      int                      `json:"Code" xml:"Code"`
	Success   bool                     `json:"Success" xml:"Success"`
	ErrorMsg  string                   `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Data      []map[string]interface{} `json:"Data" xml:"Data"`
}

// CreateQueryUnionChannelRequest creates a request to invoke QueryUnionChannel API
func CreateQueryUnionChannelRequest() (request *QueryUnionChannelRequest) {
	request = &QueryUnionChannelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "QueryUnionChannel", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryUnionChannelResponse creates a response to parse from QueryUnionChannel response
func CreateQueryUnionChannelResponse() (response *QueryUnionChannelResponse) {
	response = &QueryUnionChannelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
