package ram

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreatePolicy invokes the ram.CreatePolicy API synchronously
// api document: https://help.aliyun.com/api/ram/createpolicy.html
func (client *Client) CreatePolicy(request *CreatePolicyRequest) (response *CreatePolicyResponse, err error) {
	response = CreateCreatePolicyResponse()
	err = client.DoAction(request, response)
	return
}

// CreatePolicyWithChan invokes the ram.CreatePolicy API asynchronously
// api document: https://help.aliyun.com/api/ram/createpolicy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreatePolicyWithChan(request *CreatePolicyRequest) (<-chan *CreatePolicyResponse, <-chan error) {
	responseChan := make(chan *CreatePolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreatePolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreatePolicyWithCallback invokes the ram.CreatePolicy API asynchronously
// api document: https://help.aliyun.com/api/ram/createpolicy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreatePolicyWithCallback(request *CreatePolicyRequest, callback func(response *CreatePolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreatePolicyResponse
		var err error
		defer close(result)
		response, err = client.CreatePolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreatePolicyRequest is the request struct for api CreatePolicy
type CreatePolicyRequest struct {
	*requests.RpcRequest
	Description    string `position:"Query" name:"Description"`
	PolicyName     string `position:"Query" name:"PolicyName"`
	PolicyDocument string `position:"Query" name:"PolicyDocument"`
}

// CreatePolicyResponse is the response struct for api CreatePolicy
type CreatePolicyResponse struct {
	*responses.BaseResponse
	RequestId string               `json:"RequestId" xml:"RequestId"`
	Policy    PolicyInCreatePolicy `json:"Policy" xml:"Policy"`
}

// CreateCreatePolicyRequest creates a request to invoke CreatePolicy API
func CreateCreatePolicyRequest() (request *CreatePolicyRequest) {
	request = &CreatePolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ram", "2015-05-01", "CreatePolicy", "Ram", "openAPI")
	return
}

// CreateCreatePolicyResponse creates a response to parse from CreatePolicy response
func CreateCreatePolicyResponse() (response *CreatePolicyResponse) {
	response = &CreatePolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
