package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySmarttagJobList invokes the mts.QuerySmarttagJobList API synchronously
func (client *Client) QuerySmarttagJobList(request *QuerySmarttagJobListRequest) (response *QuerySmarttagJobListResponse, err error) {
	response = CreateQuerySmarttagJobListResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySmarttagJobListWithChan invokes the mts.QuerySmarttagJobList API asynchronously
func (client *Client) QuerySmarttagJobListWithChan(request *QuerySmarttagJobListRequest) (<-chan *QuerySmarttagJobListResponse, <-chan error) {
	responseChan := make(chan *QuerySmarttagJobListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySmarttagJobList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySmarttagJobListWithCallback invokes the mts.QuerySmarttagJobList API asynchronously
func (client *Client) QuerySmarttagJobListWithCallback(request *QuerySmarttagJobListRequest, callback func(response *QuerySmarttagJobListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySmarttagJobListResponse
		var err error
		defer close(result)
		response, err = client.QuerySmarttagJobList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySmarttagJobListRequest is the request struct for api QuerySmarttagJobList
type QuerySmarttagJobListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId            requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NextPageToken              string           `position:"Query" name:"NextPageToken"`
	StartOfJobCreatedTimeRange string           `position:"Query" name:"StartOfJobCreatedTimeRange"`
	EndOfJobCreatedTimeRange   string           `position:"Query" name:"EndOfJobCreatedTimeRange"`
	ResourceOwnerAccount       string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount               string           `position:"Query" name:"OwnerAccount"`
	MaximumPageSize            requests.Integer `position:"Query" name:"MaximumPageSize"`
	OwnerId                    requests.Integer `position:"Query" name:"OwnerId"`
	PipelineId                 string           `position:"Query" name:"PipelineId"`
	JobIds                     string           `position:"Query" name:"JobIds"`
}

// QuerySmarttagJobListResponse is the response struct for api QuerySmarttagJobList
type QuerySmarttagJobListResponse struct {
	*responses.BaseResponse
	NextPageToken  string                               `json:"NextPageToken" xml:"NextPageToken"`
	RequestId      string                               `json:"RequestId" xml:"RequestId"`
	NonExistJobIds NonExistJobIdsInQuerySmarttagJobList `json:"NonExistJobIds" xml:"NonExistJobIds"`
	SmarttagJobs   SmarttagJobs                         `json:"SmarttagJobs" xml:"SmarttagJobs"`
}

// CreateQuerySmarttagJobListRequest creates a request to invoke QuerySmarttagJobList API
func CreateQuerySmarttagJobListRequest() (request *QuerySmarttagJobListRequest) {
	request = &QuerySmarttagJobListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "QuerySmarttagJobList", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQuerySmarttagJobListResponse creates a response to parse from QuerySmarttagJobList response
func CreateQuerySmarttagJobListResponse() (response *QuerySmarttagJobListResponse) {
	response = &QuerySmarttagJobListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
