package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCasterSyncGroup invokes the live.DescribeCasterSyncGroup API synchronously
func (client *Client) DescribeCasterSyncGroup(request *DescribeCasterSyncGroupRequest) (response *DescribeCasterSyncGroupResponse, err error) {
	response = CreateDescribeCasterSyncGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCasterSyncGroupWithChan invokes the live.DescribeCasterSyncGroup API asynchronously
func (client *Client) DescribeCasterSyncGroupWithChan(request *DescribeCasterSyncGroupRequest) (<-chan *DescribeCasterSyncGroupResponse, <-chan error) {
	responseChan := make(chan *DescribeCasterSyncGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCasterSyncGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCasterSyncGroupWithCallback invokes the live.DescribeCasterSyncGroup API asynchronously
func (client *Client) DescribeCasterSyncGroupWithCallback(request *DescribeCasterSyncGroupRequest, callback func(response *DescribeCasterSyncGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCasterSyncGroupResponse
		var err error
		defer close(result)
		response, err = client.DescribeCasterSyncGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCasterSyncGroupRequest is the request struct for api DescribeCasterSyncGroup
type DescribeCasterSyncGroupRequest struct {
	*requests.RpcRequest
	CasterId string           `position:"Query" name:"CasterId"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeCasterSyncGroupResponse is the response struct for api DescribeCasterSyncGroup
type DescribeCasterSyncGroupResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	CasterId   string     `json:"CasterId" xml:"CasterId"`
	SyncGroups SyncGroups `json:"SyncGroups" xml:"SyncGroups"`
}

// CreateDescribeCasterSyncGroupRequest creates a request to invoke DescribeCasterSyncGroup API
func CreateDescribeCasterSyncGroupRequest() (request *DescribeCasterSyncGroupRequest) {
	request = &DescribeCasterSyncGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeCasterSyncGroup", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCasterSyncGroupResponse creates a response to parse from DescribeCasterSyncGroup response
func CreateDescribeCasterSyncGroupResponse() (response *DescribeCasterSyncGroupResponse) {
	response = &DescribeCasterSyncGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
