package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListResourceInstanceWorker invokes the eas.ListResourceInstanceWorker API synchronously
func (client *Client) ListResourceInstanceWorker(request *ListResourceInstanceWorkerRequest) (response *ListResourceInstanceWorkerResponse, err error) {
	response = CreateListResourceInstanceWorkerResponse()
	err = client.DoAction(request, response)
	return
}

// ListResourceInstanceWorkerWithChan invokes the eas.ListResourceInstanceWorker API asynchronously
func (client *Client) ListResourceInstanceWorkerWithChan(request *ListResourceInstanceWorkerRequest) (<-chan *ListResourceInstanceWorkerResponse, <-chan error) {
	responseChan := make(chan *ListResourceInstanceWorkerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListResourceInstanceWorker(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListResourceInstanceWorkerWithCallback invokes the eas.ListResourceInstanceWorker API asynchronously
func (client *Client) ListResourceInstanceWorkerWithCallback(request *ListResourceInstanceWorkerRequest, callback func(response *ListResourceInstanceWorkerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListResourceInstanceWorkerResponse
		var err error
		defer close(result)
		response, err = client.ListResourceInstanceWorker(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListResourceInstanceWorkerRequest is the request struct for api ListResourceInstanceWorker
type ListResourceInstanceWorkerRequest struct {
	*requests.RoaRequest
	ResourceId   string           `position:"Path" name:"ResourceId"`
	InstanceName string           `position:"Path" name:"InstanceName"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	ClusterId    string           `position:"Path" name:"ClusterId"`
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
}

// ListResourceInstanceWorkerResponse is the response struct for api ListResourceInstanceWorker
type ListResourceInstanceWorkerResponse struct {
	*responses.BaseResponse
}

// CreateListResourceInstanceWorkerRequest creates a request to invoke ListResourceInstanceWorker API
func CreateListResourceInstanceWorkerRequest() (request *ListResourceInstanceWorkerRequest) {
	request = &ListResourceInstanceWorkerRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2021-07-01", "ListResourceInstanceWorker", "/api/v2/resources/[ClusterId]/[ResourceId]/instance/[InstanceName]/workers", "eas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListResourceInstanceWorkerResponse creates a response to parse from ListResourceInstanceWorker response
func CreateListResourceInstanceWorkerResponse() (response *ListResourceInstanceWorkerResponse) {
	response = &ListResourceInstanceWorkerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
