package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDag invokes the dataworks_public.GetDag API synchronously
func (client *Client) GetDag(request *GetDagRequest) (response *GetDagResponse, err error) {
	response = CreateGetDagResponse()
	err = client.DoAction(request, response)
	return
}

// GetDagWithChan invokes the dataworks_public.GetDag API asynchronously
func (client *Client) GetDagWithChan(request *GetDagRequest) (<-chan *GetDagResponse, <-chan error) {
	responseChan := make(chan *GetDagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDagWithCallback invokes the dataworks_public.GetDag API asynchronously
func (client *Client) GetDagWithCallback(request *GetDagRequest, callback func(response *GetDagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDagResponse
		var err error
		defer close(result)
		response, err = client.GetDag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDagRequest is the request struct for api GetDag
type GetDagRequest struct {
	*requests.RpcRequest
	ProjectEnv string           `position:"Body" name:"ProjectEnv"`
	DagId      requests.Integer `position:"Body" name:"DagId"`
}

// GetDagResponse is the response struct for api GetDag
type GetDagResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetDagRequest creates a request to invoke GetDag API
func CreateGetDagRequest() (request *GetDagRequest) {
	request = &GetDagRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetDag", "", "")
	request.Method = requests.POST
	return
}

// CreateGetDagResponse creates a response to parse from GetDag response
func CreateGetDagResponse() (response *GetDagResponse) {
	response = &GetDagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
