package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCacheAnalysisJobs invokes the das.DescribeCacheAnalysisJobs API synchronously
func (client *Client) DescribeCacheAnalysisJobs(request *DescribeCacheAnalysisJobsRequest) (response *DescribeCacheAnalysisJobsResponse, err error) {
	response = CreateDescribeCacheAnalysisJobsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCacheAnalysisJobsWithChan invokes the das.DescribeCacheAnalysisJobs API asynchronously
func (client *Client) DescribeCacheAnalysisJobsWithChan(request *DescribeCacheAnalysisJobsRequest) (<-chan *DescribeCacheAnalysisJobsResponse, <-chan error) {
	responseChan := make(chan *DescribeCacheAnalysisJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCacheAnalysisJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCacheAnalysisJobsWithCallback invokes the das.DescribeCacheAnalysisJobs API asynchronously
func (client *Client) DescribeCacheAnalysisJobsWithCallback(request *DescribeCacheAnalysisJobsRequest, callback func(response *DescribeCacheAnalysisJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCacheAnalysisJobsResponse
		var err error
		defer close(result)
		response, err = client.DescribeCacheAnalysisJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCacheAnalysisJobsRequest is the request struct for api DescribeCacheAnalysisJobs
type DescribeCacheAnalysisJobsRequest struct {
	*requests.RpcRequest
	EndTime    string `position:"Query" name:"EndTime"`
	StartTime  string `position:"Query" name:"StartTime"`
	InstanceId string `position:"Query" name:"InstanceId"`
	PageNo     string `position:"Query" name:"PageNo"`
	PageSize   string `position:"Query" name:"PageSize"`
}

// DescribeCacheAnalysisJobsResponse is the response struct for api DescribeCacheAnalysisJobs
type DescribeCacheAnalysisJobsResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   string `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeCacheAnalysisJobsRequest creates a request to invoke DescribeCacheAnalysisJobs API
func CreateDescribeCacheAnalysisJobsRequest() (request *DescribeCacheAnalysisJobsRequest) {
	request = &DescribeCacheAnalysisJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "DescribeCacheAnalysisJobs", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeCacheAnalysisJobsResponse creates a response to parse from DescribeCacheAnalysisJobs response
func CreateDescribeCacheAnalysisJobsResponse() (response *DescribeCacheAnalysisJobsResponse) {
	response = &DescribeCacheAnalysisJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
