//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package sqlvirtualmachine

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/sqlvirtualmachine/mgmt/2021-11-01-preview/sqlvirtualmachine"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BackupScheduleType = original.BackupScheduleType

const (
	BackupScheduleTypeAutomated BackupScheduleType = original.BackupScheduleTypeAutomated
	BackupScheduleTypeManual    BackupScheduleType = original.BackupScheduleTypeManual
)

type ClusterConfiguration = original.ClusterConfiguration

const (
	ClusterConfigurationDomainful ClusterConfiguration = original.ClusterConfigurationDomainful
)

type ClusterManagerType = original.ClusterManagerType

const (
	ClusterManagerTypeWSFC ClusterManagerType = original.ClusterManagerTypeWSFC
)

type Commit = original.Commit

const (
	CommitASYNCHRONOUSCOMMIT Commit = original.CommitASYNCHRONOUSCOMMIT
	CommitSYNCHRONOUSCOMMIT  Commit = original.CommitSYNCHRONOUSCOMMIT
)

type ConnectivityType = original.ConnectivityType

const (
	ConnectivityTypeLOCAL   ConnectivityType = original.ConnectivityTypeLOCAL
	ConnectivityTypePRIVATE ConnectivityType = original.ConnectivityTypePRIVATE
	ConnectivityTypePUBLIC  ConnectivityType = original.ConnectivityTypePUBLIC
)

type CreatedByType = original.CreatedByType

const (
	CreatedByTypeApplication     CreatedByType = original.CreatedByTypeApplication
	CreatedByTypeKey             CreatedByType = original.CreatedByTypeKey
	CreatedByTypeManagedIdentity CreatedByType = original.CreatedByTypeManagedIdentity
	CreatedByTypeUser            CreatedByType = original.CreatedByTypeUser
)

type DayOfWeek = original.DayOfWeek

const (
	DayOfWeekFriday    DayOfWeek = original.DayOfWeekFriday
	DayOfWeekMonday    DayOfWeek = original.DayOfWeekMonday
	DayOfWeekSaturday  DayOfWeek = original.DayOfWeekSaturday
	DayOfWeekSunday    DayOfWeek = original.DayOfWeekSunday
	DayOfWeekThursday  DayOfWeek = original.DayOfWeekThursday
	DayOfWeekTuesday   DayOfWeek = original.DayOfWeekTuesday
	DayOfWeekWednesday DayOfWeek = original.DayOfWeekWednesday
)

type DaysOfWeek = original.DaysOfWeek

const (
	DaysOfWeekFriday    DaysOfWeek = original.DaysOfWeekFriday
	DaysOfWeekMonday    DaysOfWeek = original.DaysOfWeekMonday
	DaysOfWeekSaturday  DaysOfWeek = original.DaysOfWeekSaturday
	DaysOfWeekSunday    DaysOfWeek = original.DaysOfWeekSunday
	DaysOfWeekThursday  DaysOfWeek = original.DaysOfWeekThursday
	DaysOfWeekTuesday   DaysOfWeek = original.DaysOfWeekTuesday
	DaysOfWeekWednesday DaysOfWeek = original.DaysOfWeekWednesday
)

type DiskConfigurationType = original.DiskConfigurationType

const (
	DiskConfigurationTypeADD    DiskConfigurationType = original.DiskConfigurationTypeADD
	DiskConfigurationTypeEXTEND DiskConfigurationType = original.DiskConfigurationTypeEXTEND
	DiskConfigurationTypeNEW    DiskConfigurationType = original.DiskConfigurationTypeNEW
)

type Failover = original.Failover

const (
	FailoverAUTOMATIC Failover = original.FailoverAUTOMATIC
	FailoverMANUAL    Failover = original.FailoverMANUAL
)

type FullBackupFrequencyType = original.FullBackupFrequencyType

const (
	FullBackupFrequencyTypeDaily  FullBackupFrequencyType = original.FullBackupFrequencyTypeDaily
	FullBackupFrequencyTypeWeekly FullBackupFrequencyType = original.FullBackupFrequencyTypeWeekly
)

type IdentityType = original.IdentityType

const (
	IdentityTypeNone           IdentityType = original.IdentityTypeNone
	IdentityTypeSystemAssigned IdentityType = original.IdentityTypeSystemAssigned
)

type OperationOrigin = original.OperationOrigin

const (
	OperationOriginSystem OperationOrigin = original.OperationOriginSystem
	OperationOriginUser   OperationOrigin = original.OperationOriginUser
)

type ReadableSecondary = original.ReadableSecondary

const (
	ReadableSecondaryALL      ReadableSecondary = original.ReadableSecondaryALL
	ReadableSecondaryNO       ReadableSecondary = original.ReadableSecondaryNO
	ReadableSecondaryREADONLY ReadableSecondary = original.ReadableSecondaryREADONLY
)

type Role = original.Role

const (
	RolePRIMARY   Role = original.RolePRIMARY
	RoleSECONDARY Role = original.RoleSECONDARY
)

type SQLImageSku = original.SQLImageSku

const (
	SQLImageSkuDeveloper  SQLImageSku = original.SQLImageSkuDeveloper
	SQLImageSkuEnterprise SQLImageSku = original.SQLImageSkuEnterprise
	SQLImageSkuExpress    SQLImageSku = original.SQLImageSkuExpress
	SQLImageSkuStandard   SQLImageSku = original.SQLImageSkuStandard
	SQLImageSkuWeb        SQLImageSku = original.SQLImageSkuWeb
)

type SQLManagementMode = original.SQLManagementMode

const (
	SQLManagementModeFull        SQLManagementMode = original.SQLManagementModeFull
	SQLManagementModeLightWeight SQLManagementMode = original.SQLManagementModeLightWeight
	SQLManagementModeNoAgent     SQLManagementMode = original.SQLManagementModeNoAgent
)

type SQLServerLicenseType = original.SQLServerLicenseType

const (
	SQLServerLicenseTypeAHUB SQLServerLicenseType = original.SQLServerLicenseTypeAHUB
	SQLServerLicenseTypeDR   SQLServerLicenseType = original.SQLServerLicenseTypeDR
	SQLServerLicenseTypePAYG SQLServerLicenseType = original.SQLServerLicenseTypePAYG
)

type SQLVMGroupImageSku = original.SQLVMGroupImageSku

const (
	SQLVMGroupImageSkuDeveloper  SQLVMGroupImageSku = original.SQLVMGroupImageSkuDeveloper
	SQLVMGroupImageSkuEnterprise SQLVMGroupImageSku = original.SQLVMGroupImageSkuEnterprise
)

type SQLWorkloadType = original.SQLWorkloadType

const (
	SQLWorkloadTypeDW      SQLWorkloadType = original.SQLWorkloadTypeDW
	SQLWorkloadTypeGENERAL SQLWorkloadType = original.SQLWorkloadTypeGENERAL
	SQLWorkloadTypeOLTP    SQLWorkloadType = original.SQLWorkloadTypeOLTP
)

type ScaleType = original.ScaleType

const (
	ScaleTypeHA ScaleType = original.ScaleTypeHA
)

type StorageWorkloadType = original.StorageWorkloadType

const (
	StorageWorkloadTypeDW      StorageWorkloadType = original.StorageWorkloadTypeDW
	StorageWorkloadTypeGENERAL StorageWorkloadType = original.StorageWorkloadTypeGENERAL
	StorageWorkloadTypeOLTP    StorageWorkloadType = original.StorageWorkloadTypeOLTP
)

type AdditionalFeaturesServerConfigurations = original.AdditionalFeaturesServerConfigurations
type AgConfiguration = original.AgConfiguration
type AgReplica = original.AgReplica
type AssessmentSettings = original.AssessmentSettings
type AutoBackupSettings = original.AutoBackupSettings
type AutoPatchingSettings = original.AutoPatchingSettings
type AvailabilityGroupListener = original.AvailabilityGroupListener
type AvailabilityGroupListenerListResult = original.AvailabilityGroupListenerListResult
type AvailabilityGroupListenerListResultIterator = original.AvailabilityGroupListenerListResultIterator
type AvailabilityGroupListenerListResultPage = original.AvailabilityGroupListenerListResultPage
type AvailabilityGroupListenerProperties = original.AvailabilityGroupListenerProperties
type AvailabilityGroupListenersClient = original.AvailabilityGroupListenersClient
type AvailabilityGroupListenersCreateOrUpdateFuture = original.AvailabilityGroupListenersCreateOrUpdateFuture
type AvailabilityGroupListenersDeleteFuture = original.AvailabilityGroupListenersDeleteFuture
type BaseClient = original.BaseClient
type Group = original.Group
type GroupListResult = original.GroupListResult
type GroupListResultIterator = original.GroupListResultIterator
type GroupListResultPage = original.GroupListResultPage
type GroupProperties = original.GroupProperties
type GroupUpdate = original.GroupUpdate
type GroupsClient = original.GroupsClient
type GroupsCreateOrUpdateFuture = original.GroupsCreateOrUpdateFuture
type GroupsDeleteFuture = original.GroupsDeleteFuture
type GroupsUpdateFuture = original.GroupsUpdateFuture
type KeyVaultCredentialSettings = original.KeyVaultCredentialSettings
type ListResult = original.ListResult
type ListResultIterator = original.ListResultIterator
type ListResultPage = original.ListResultPage
type LoadBalancerConfiguration = original.LoadBalancerConfiguration
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationsClient = original.OperationsClient
type PrivateIPAddress = original.PrivateIPAddress
type Properties = original.Properties
type ProxyResource = original.ProxyResource
type Resource = original.Resource
type ResourceIdentity = original.ResourceIdentity
type SQLConnectivityUpdateSettings = original.SQLConnectivityUpdateSettings
type SQLInstanceSettings = original.SQLInstanceSettings
type SQLStorageSettings = original.SQLStorageSettings
type SQLStorageUpdateSettings = original.SQLStorageUpdateSettings
type SQLTempDbSettings = original.SQLTempDbSettings
type SQLVirtualMachine = original.SQLVirtualMachine
type SQLVirtualMachinesClient = original.SQLVirtualMachinesClient
type SQLVirtualMachinesCreateOrUpdateFutureType = original.SQLVirtualMachinesCreateOrUpdateFutureType
type SQLVirtualMachinesDeleteFutureType = original.SQLVirtualMachinesDeleteFutureType
type SQLVirtualMachinesRedeployFutureType = original.SQLVirtualMachinesRedeployFutureType
type SQLVirtualMachinesStartAssessmentFutureType = original.SQLVirtualMachinesStartAssessmentFutureType
type SQLVirtualMachinesUpdateFutureType = original.SQLVirtualMachinesUpdateFutureType
type SQLWorkloadTypeUpdateSettings = original.SQLWorkloadTypeUpdateSettings
type Schedule = original.Schedule
type ServerConfigurationsManagementSettings = original.ServerConfigurationsManagementSettings
type StorageConfigurationSettings = original.StorageConfigurationSettings
type SystemData = original.SystemData
type TrackedResource = original.TrackedResource
type Update = original.Update
type WsfcDomainCredentials = original.WsfcDomainCredentials
type WsfcDomainProfile = original.WsfcDomainProfile

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAvailabilityGroupListenerListResultIterator(page AvailabilityGroupListenerListResultPage) AvailabilityGroupListenerListResultIterator {
	return original.NewAvailabilityGroupListenerListResultIterator(page)
}
func NewAvailabilityGroupListenerListResultPage(cur AvailabilityGroupListenerListResult, getNextPage func(context.Context, AvailabilityGroupListenerListResult) (AvailabilityGroupListenerListResult, error)) AvailabilityGroupListenerListResultPage {
	return original.NewAvailabilityGroupListenerListResultPage(cur, getNextPage)
}
func NewAvailabilityGroupListenersClient(subscriptionID string) AvailabilityGroupListenersClient {
	return original.NewAvailabilityGroupListenersClient(subscriptionID)
}
func NewAvailabilityGroupListenersClientWithBaseURI(baseURI string, subscriptionID string) AvailabilityGroupListenersClient {
	return original.NewAvailabilityGroupListenersClientWithBaseURI(baseURI, subscriptionID)
}
func NewGroupListResultIterator(page GroupListResultPage) GroupListResultIterator {
	return original.NewGroupListResultIterator(page)
}
func NewGroupListResultPage(cur GroupListResult, getNextPage func(context.Context, GroupListResult) (GroupListResult, error)) GroupListResultPage {
	return original.NewGroupListResultPage(cur, getNextPage)
}
func NewGroupsClient(subscriptionID string) GroupsClient {
	return original.NewGroupsClient(subscriptionID)
}
func NewGroupsClientWithBaseURI(baseURI string, subscriptionID string) GroupsClient {
	return original.NewGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewListResultIterator(page ListResultPage) ListResultIterator {
	return original.NewListResultIterator(page)
}
func NewListResultPage(cur ListResult, getNextPage func(context.Context, ListResult) (ListResult, error)) ListResultPage {
	return original.NewListResultPage(cur, getNextPage)
}
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return original.NewOperationListResultIterator(page)
}
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return original.NewOperationListResultPage(cur, getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLVirtualMachinesClient(subscriptionID string) SQLVirtualMachinesClient {
	return original.NewSQLVirtualMachinesClient(subscriptionID)
}
func NewSQLVirtualMachinesClientWithBaseURI(baseURI string, subscriptionID string) SQLVirtualMachinesClient {
	return original.NewSQLVirtualMachinesClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleBackupScheduleTypeValues() []BackupScheduleType {
	return original.PossibleBackupScheduleTypeValues()
}
func PossibleClusterConfigurationValues() []ClusterConfiguration {
	return original.PossibleClusterConfigurationValues()
}
func PossibleClusterManagerTypeValues() []ClusterManagerType {
	return original.PossibleClusterManagerTypeValues()
}
func PossibleCommitValues() []Commit {
	return original.PossibleCommitValues()
}
func PossibleConnectivityTypeValues() []ConnectivityType {
	return original.PossibleConnectivityTypeValues()
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleDayOfWeekValues() []DayOfWeek {
	return original.PossibleDayOfWeekValues()
}
func PossibleDaysOfWeekValues() []DaysOfWeek {
	return original.PossibleDaysOfWeekValues()
}
func PossibleDiskConfigurationTypeValues() []DiskConfigurationType {
	return original.PossibleDiskConfigurationTypeValues()
}
func PossibleFailoverValues() []Failover {
	return original.PossibleFailoverValues()
}
func PossibleFullBackupFrequencyTypeValues() []FullBackupFrequencyType {
	return original.PossibleFullBackupFrequencyTypeValues()
}
func PossibleIdentityTypeValues() []IdentityType {
	return original.PossibleIdentityTypeValues()
}
func PossibleOperationOriginValues() []OperationOrigin {
	return original.PossibleOperationOriginValues()
}
func PossibleReadableSecondaryValues() []ReadableSecondary {
	return original.PossibleReadableSecondaryValues()
}
func PossibleRoleValues() []Role {
	return original.PossibleRoleValues()
}
func PossibleSQLImageSkuValues() []SQLImageSku {
	return original.PossibleSQLImageSkuValues()
}
func PossibleSQLManagementModeValues() []SQLManagementMode {
	return original.PossibleSQLManagementModeValues()
}
func PossibleSQLServerLicenseTypeValues() []SQLServerLicenseType {
	return original.PossibleSQLServerLicenseTypeValues()
}
func PossibleSQLVMGroupImageSkuValues() []SQLVMGroupImageSku {
	return original.PossibleSQLVMGroupImageSkuValues()
}
func PossibleSQLWorkloadTypeValues() []SQLWorkloadType {
	return original.PossibleSQLWorkloadTypeValues()
}
func PossibleScaleTypeValues() []ScaleType {
	return original.PossibleScaleTypeValues()
}
func PossibleStorageWorkloadTypeValues() []StorageWorkloadType {
	return original.PossibleStorageWorkloadTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
