package monitorlegacy

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/monitor/mgmt/2016-03-01-preview/monitorlegacy"

// AlertRule an alert rule.
type AlertRule struct {
	// Name - the name of the alert rule.
	Name *string `json:"name,omitempty"`
	// Description - the description of the alert rule that will be included in the alert email.
	Description *string `json:"description,omitempty"`
	// ProvisioningState - the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// IsEnabled - the flag that indicates whether the alert rule is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// Condition - the condition that results in the alert rule being activated.
	Condition BasicRuleCondition `json:"condition,omitempty"`
	// Action - action that is performed when the alert rule becomes active, and when an alert condition is resolved.
	Action BasicRuleAction `json:"action,omitempty"`
	// Actions - the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
	Actions *[]BasicRuleAction `json:"actions,omitempty"`
	// LastUpdatedTime - READ-ONLY; Last time the rule was updated in ISO8601 format.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertRule.
func (ar AlertRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.Name != nil {
		objectMap["name"] = ar.Name
	}
	if ar.Description != nil {
		objectMap["description"] = ar.Description
	}
	if ar.ProvisioningState != nil {
		objectMap["provisioningState"] = ar.ProvisioningState
	}
	if ar.IsEnabled != nil {
		objectMap["isEnabled"] = ar.IsEnabled
	}
	objectMap["condition"] = ar.Condition
	objectMap["action"] = ar.Action
	if ar.Actions != nil {
		objectMap["actions"] = ar.Actions
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertRule struct.
func (ar *AlertRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ar.Name = &name
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ar.Description = &description
			}
		case "provisioningState":
			if v != nil {
				var provisioningState string
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				ar.ProvisioningState = &provisioningState
			}
		case "isEnabled":
			if v != nil {
				var isEnabled bool
				err = json.Unmarshal(*v, &isEnabled)
				if err != nil {
					return err
				}
				ar.IsEnabled = &isEnabled
			}
		case "condition":
			if v != nil {
				condition, err := unmarshalBasicRuleCondition(*v)
				if err != nil {
					return err
				}
				ar.Condition = condition
			}
		case "action":
			if v != nil {
				action, err := unmarshalBasicRuleAction(*v)
				if err != nil {
					return err
				}
				ar.Action = action
			}
		case "actions":
			if v != nil {
				actions, err := unmarshalBasicRuleActionArray(*v)
				if err != nil {
					return err
				}
				ar.Actions = &actions
			}
		case "lastUpdatedTime":
			if v != nil {
				var lastUpdatedTime date.Time
				err = json.Unmarshal(*v, &lastUpdatedTime)
				if err != nil {
					return err
				}
				ar.LastUpdatedTime = &lastUpdatedTime
			}
		}
	}

	return nil
}

// AlertRuleResource the alert rule resource.
type AlertRuleResource struct {
	autorest.Response `json:"-"`
	// AlertRule - The alert rule properties of the resource.
	*AlertRule `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AlertRuleResource.
func (arr AlertRuleResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arr.AlertRule != nil {
		objectMap["properties"] = arr.AlertRule
	}
	if arr.Location != nil {
		objectMap["location"] = arr.Location
	}
	if arr.Tags != nil {
		objectMap["tags"] = arr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertRuleResource struct.
func (arr *AlertRuleResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var alertRule AlertRule
				err = json.Unmarshal(*v, &alertRule)
				if err != nil {
					return err
				}
				arr.AlertRule = &alertRule
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				arr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				arr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				arr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				arr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				arr.Tags = tags
			}
		}
	}

	return nil
}

// AlertRuleResourceCollection represents a collection of alert rule resources.
type AlertRuleResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - the values for the alert rule resources.
	Value *[]AlertRuleResource `json:"value,omitempty"`
}

// AlertRuleResourcePatch the alert rule object for patch operations.
type AlertRuleResourcePatch struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// AlertRule - The properties of an alert rule.
	*AlertRule `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertRuleResourcePatch.
func (arrp AlertRuleResourcePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arrp.Tags != nil {
		objectMap["tags"] = arrp.Tags
	}
	if arrp.AlertRule != nil {
		objectMap["properties"] = arrp.AlertRule
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertRuleResourcePatch struct.
func (arrp *AlertRuleResourcePatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				arrp.Tags = tags
			}
		case "properties":
			if v != nil {
				var alertRule AlertRule
				err = json.Unmarshal(*v, &alertRule)
				if err != nil {
					return err
				}
				arrp.AlertRule = &alertRule
			}
		}
	}

	return nil
}

// DataContainer information about a container with data for a given resource.
type DataContainer struct {
	// Workspace - Log Analytics workspace information.
	Workspace *WorkspaceInfo `json:"workspace,omitempty"`
}

// Error error details.
type Error struct {
	// Code - Error code identifying the specific error.
	Code *string `json:"code,omitempty"`
	// Message - Error message in the caller's locale.
	Message *string `json:"message,omitempty"`
}

// ErrorResponse describes the format of Error response.
type ErrorResponse struct {
	// Code - Error code
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// EventCategoryCollection a collection of event categories. Currently possible values are: Administrative,
// Security, ServiceHealth, Alert, Recommendation, Policy.
type EventCategoryCollection struct {
	autorest.Response `json:"-"`
	// Value - the list that includes the Azure event categories.
	Value *[]LocalizableString `json:"value,omitempty"`
}

// Incident an alert incident indicates the activation status of an alert rule.
type Incident struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; Incident name.
	Name *string `json:"name,omitempty"`
	// RuleName - READ-ONLY; Rule name that is associated with the incident.
	RuleName *string `json:"ruleName,omitempty"`
	// IsActive - READ-ONLY; A boolean to indicate whether the incident is active or resolved.
	IsActive *bool `json:"isActive,omitempty"`
	// ActivatedTime - READ-ONLY; The time at which the incident was activated in ISO8601 format.
	ActivatedTime *date.Time `json:"activatedTime,omitempty"`
	// ResolvedTime - READ-ONLY; The time at which the incident was resolved in ISO8601 format. If null, it means the incident is still active.
	ResolvedTime *date.Time `json:"resolvedTime,omitempty"`
}

// MarshalJSON is the custom marshaler for Incident.
func (i Incident) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// IncidentListResult the List incidents operation response.
type IncidentListResult struct {
	autorest.Response `json:"-"`
	// Value - the incident collection.
	Value *[]Incident `json:"value,omitempty"`
}

// LocalizableString the localizable string class.
type LocalizableString struct {
	// Value - the invariant value.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - the locale specific value.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// LocationThresholdRuleCondition a rule condition based on a certain number of locations failing.
type LocationThresholdRuleCondition struct {
	// WindowSize - the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
	WindowSize *string `json:"windowSize,omitempty"`
	// FailedLocationCount - the number of locations that must fail to activate the alert.
	FailedLocationCount *int32 `json:"failedLocationCount,omitempty"`
	// DataSource - the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
	DataSource BasicRuleDataSource `json:"dataSource,omitempty"`
	// OdataType - Possible values include: 'OdataTypeBasicRuleConditionOdataTypeRuleCondition', 'OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition', 'OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition', 'OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition'
	OdataType OdataTypeBasicRuleCondition `json:"odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for LocationThresholdRuleCondition.
func (ltrc LocationThresholdRuleCondition) MarshalJSON() ([]byte, error) {
	ltrc.OdataType = OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition
	objectMap := make(map[string]interface{})
	if ltrc.WindowSize != nil {
		objectMap["windowSize"] = ltrc.WindowSize
	}
	if ltrc.FailedLocationCount != nil {
		objectMap["failedLocationCount"] = ltrc.FailedLocationCount
	}
	objectMap["dataSource"] = ltrc.DataSource
	if ltrc.OdataType != "" {
		objectMap["odata.type"] = ltrc.OdataType
	}
	return json.Marshal(objectMap)
}

// AsThresholdRuleCondition is the BasicRuleCondition implementation for LocationThresholdRuleCondition.
func (ltrc LocationThresholdRuleCondition) AsThresholdRuleCondition() (*ThresholdRuleCondition, bool) {
	return nil, false
}

// AsLocationThresholdRuleCondition is the BasicRuleCondition implementation for LocationThresholdRuleCondition.
func (ltrc LocationThresholdRuleCondition) AsLocationThresholdRuleCondition() (*LocationThresholdRuleCondition, bool) {
	return &ltrc, true
}

// AsManagementEventRuleCondition is the BasicRuleCondition implementation for LocationThresholdRuleCondition.
func (ltrc LocationThresholdRuleCondition) AsManagementEventRuleCondition() (*ManagementEventRuleCondition, bool) {
	return nil, false
}

// AsRuleCondition is the BasicRuleCondition implementation for LocationThresholdRuleCondition.
func (ltrc LocationThresholdRuleCondition) AsRuleCondition() (*RuleCondition, bool) {
	return nil, false
}

// AsBasicRuleCondition is the BasicRuleCondition implementation for LocationThresholdRuleCondition.
func (ltrc LocationThresholdRuleCondition) AsBasicRuleCondition() (BasicRuleCondition, bool) {
	return &ltrc, true
}

// UnmarshalJSON is the custom unmarshaler for LocationThresholdRuleCondition struct.
func (ltrc *LocationThresholdRuleCondition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "windowSize":
			if v != nil {
				var windowSize string
				err = json.Unmarshal(*v, &windowSize)
				if err != nil {
					return err
				}
				ltrc.WindowSize = &windowSize
			}
		case "failedLocationCount":
			if v != nil {
				var failedLocationCount int32
				err = json.Unmarshal(*v, &failedLocationCount)
				if err != nil {
					return err
				}
				ltrc.FailedLocationCount = &failedLocationCount
			}
		case "dataSource":
			if v != nil {
				dataSource, err := unmarshalBasicRuleDataSource(*v)
				if err != nil {
					return err
				}
				ltrc.DataSource = dataSource
			}
		case "odata.type":
			if v != nil {
				var odataType OdataTypeBasicRuleCondition
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				ltrc.OdataType = odataType
			}
		}
	}

	return nil
}

// LogProfileCollection represents a collection of log profiles.
type LogProfileCollection struct {
	autorest.Response `json:"-"`
	// Value - the values of the log profiles.
	Value *[]LogProfileResource `json:"value,omitempty"`
}

// LogProfileProperties the log profile properties.
type LogProfileProperties struct {
	// StorageAccountID - the resource id of the storage account to which you would like to send the Activity Log.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
	// ServiceBusRuleID - The service bus rule ID of the service bus namespace in which you would like to have Event Hubs created for streaming the Activity Log. The rule ID is of the format: '{service bus resource ID}/authorizationrules/{key name}'.
	ServiceBusRuleID *string `json:"serviceBusRuleId,omitempty"`
	// Locations - List of regions for which Activity Log events should be stored or streamed. It is a comma separated list of valid ARM locations including the 'global' location.
	Locations *[]string `json:"locations,omitempty"`
	// Categories - the categories of the logs. These categories are created as is convenient to the user. Some values are: 'Write', 'Delete', and/or 'Action.'
	Categories *[]string `json:"categories,omitempty"`
	// RetentionPolicy - the retention policy for the events in the log.
	RetentionPolicy *RetentionPolicy `json:"retentionPolicy,omitempty"`
}

// LogProfileResource the log profile resource.
type LogProfileResource struct {
	autorest.Response `json:"-"`
	// LogProfileProperties - The log profile properties of the resource.
	*LogProfileProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LogProfileResource.
func (lpr LogProfileResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lpr.LogProfileProperties != nil {
		objectMap["properties"] = lpr.LogProfileProperties
	}
	if lpr.Location != nil {
		objectMap["location"] = lpr.Location
	}
	if lpr.Tags != nil {
		objectMap["tags"] = lpr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LogProfileResource struct.
func (lpr *LogProfileResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var logProfileProperties LogProfileProperties
				err = json.Unmarshal(*v, &logProfileProperties)
				if err != nil {
					return err
				}
				lpr.LogProfileProperties = &logProfileProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lpr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lpr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lpr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lpr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lpr.Tags = tags
			}
		}
	}

	return nil
}

// LogProfileResourcePatch the log profile resource for patch operations.
type LogProfileResourcePatch struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// LogProfileProperties - The log profile properties for an update operation.
	*LogProfileProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for LogProfileResourcePatch.
func (lprp LogProfileResourcePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lprp.Tags != nil {
		objectMap["tags"] = lprp.Tags
	}
	if lprp.LogProfileProperties != nil {
		objectMap["properties"] = lprp.LogProfileProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LogProfileResourcePatch struct.
func (lprp *LogProfileResourcePatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lprp.Tags = tags
			}
		case "properties":
			if v != nil {
				var logProfileProperties LogProfileProperties
				err = json.Unmarshal(*v, &logProfileProperties)
				if err != nil {
					return err
				}
				lprp.LogProfileProperties = &logProfileProperties
			}
		}
	}

	return nil
}

// ManagementEventAggregationCondition how the data that is collected should be combined over time.
type ManagementEventAggregationCondition struct {
	// Operator - the condition operator. Possible values include: 'ConditionOperatorGreaterThan', 'ConditionOperatorGreaterThanOrEqual', 'ConditionOperatorLessThan', 'ConditionOperatorLessThanOrEqual'
	Operator ConditionOperator `json:"operator,omitempty"`
	// Threshold - The threshold value that activates the alert.
	Threshold *float64 `json:"threshold,omitempty"`
	// WindowSize - the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
	WindowSize *string `json:"windowSize,omitempty"`
}

// ManagementEventRuleCondition a management event rule condition.
type ManagementEventRuleCondition struct {
	// Aggregation - How the data that is collected should be combined over time and when the alert is activated. Note that for management event alerts aggregation is optional – if it is not provided then any event will cause the alert to activate.
	Aggregation *ManagementEventAggregationCondition `json:"aggregation,omitempty"`
	// DataSource - the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
	DataSource BasicRuleDataSource `json:"dataSource,omitempty"`
	// OdataType - Possible values include: 'OdataTypeBasicRuleConditionOdataTypeRuleCondition', 'OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition', 'OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition', 'OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition'
	OdataType OdataTypeBasicRuleCondition `json:"odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagementEventRuleCondition.
func (merc ManagementEventRuleCondition) MarshalJSON() ([]byte, error) {
	merc.OdataType = OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition
	objectMap := make(map[string]interface{})
	if merc.Aggregation != nil {
		objectMap["aggregation"] = merc.Aggregation
	}
	objectMap["dataSource"] = merc.DataSource
	if merc.OdataType != "" {
		objectMap["odata.type"] = merc.OdataType
	}
	return json.Marshal(objectMap)
}

// AsThresholdRuleCondition is the BasicRuleCondition implementation for ManagementEventRuleCondition.
func (merc ManagementEventRuleCondition) AsThresholdRuleCondition() (*ThresholdRuleCondition, bool) {
	return nil, false
}

// AsLocationThresholdRuleCondition is the BasicRuleCondition implementation for ManagementEventRuleCondition.
func (merc ManagementEventRuleCondition) AsLocationThresholdRuleCondition() (*LocationThresholdRuleCondition, bool) {
	return nil, false
}

// AsManagementEventRuleCondition is the BasicRuleCondition implementation for ManagementEventRuleCondition.
func (merc ManagementEventRuleCondition) AsManagementEventRuleCondition() (*ManagementEventRuleCondition, bool) {
	return &merc, true
}

// AsRuleCondition is the BasicRuleCondition implementation for ManagementEventRuleCondition.
func (merc ManagementEventRuleCondition) AsRuleCondition() (*RuleCondition, bool) {
	return nil, false
}

// AsBasicRuleCondition is the BasicRuleCondition implementation for ManagementEventRuleCondition.
func (merc ManagementEventRuleCondition) AsBasicRuleCondition() (BasicRuleCondition, bool) {
	return &merc, true
}

// UnmarshalJSON is the custom unmarshaler for ManagementEventRuleCondition struct.
func (merc *ManagementEventRuleCondition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "aggregation":
			if v != nil {
				var aggregation ManagementEventAggregationCondition
				err = json.Unmarshal(*v, &aggregation)
				if err != nil {
					return err
				}
				merc.Aggregation = &aggregation
			}
		case "dataSource":
			if v != nil {
				dataSource, err := unmarshalBasicRuleDataSource(*v)
				if err != nil {
					return err
				}
				merc.DataSource = dataSource
			}
		case "odata.type":
			if v != nil {
				var odataType OdataTypeBasicRuleCondition
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				merc.OdataType = odataType
			}
		}
	}

	return nil
}

// ProxyResource an azure resource object
type ProxyResource struct {
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Resource an azure resource object
type Resource struct {
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ResponseWithError an error response from the API.
type ResponseWithError struct {
	// Error - Error information.
	Error *Error `json:"error,omitempty"`
}

// RetentionPolicy specifies the retention policy for the log.
type RetentionPolicy struct {
	// Enabled - a value indicating whether the retention policy is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// Days - the number of days for the retention in days. A value of 0 will retain the events indefinitely.
	Days *int32 `json:"days,omitempty"`
}

// BasicRuleAction the action that is performed when the alert rule becomes active, and when an alert condition is
// resolved.
type BasicRuleAction interface {
	AsRuleEmailAction() (*RuleEmailAction, bool)
	AsRuleWebhookAction() (*RuleWebhookAction, bool)
	AsRuleAction() (*RuleAction, bool)
}

// RuleAction the action that is performed when the alert rule becomes active, and when an alert condition is
// resolved.
type RuleAction struct {
	// OdataType - Possible values include: 'OdataTypeBasicRuleActionOdataTypeRuleAction', 'OdataTypeBasicRuleActionOdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction', 'OdataTypeBasicRuleActionOdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction'
	OdataType OdataTypeBasicRuleAction `json:"odata.type,omitempty"`
}

func unmarshalBasicRuleAction(body []byte) (BasicRuleAction, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["odata.type"] {
	case string(OdataTypeBasicRuleActionOdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction):
		var rea RuleEmailAction
		err := json.Unmarshal(body, &rea)
		return rea, err
	case string(OdataTypeBasicRuleActionOdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction):
		var rwa RuleWebhookAction
		err := json.Unmarshal(body, &rwa)
		return rwa, err
	default:
		var ra RuleAction
		err := json.Unmarshal(body, &ra)
		return ra, err
	}
}
func unmarshalBasicRuleActionArray(body []byte) ([]BasicRuleAction, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	raArray := make([]BasicRuleAction, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ra, err := unmarshalBasicRuleAction(*rawMessage)
		if err != nil {
			return nil, err
		}
		raArray[index] = ra
	}
	return raArray, nil
}

// MarshalJSON is the custom marshaler for RuleAction.
func (ra RuleAction) MarshalJSON() ([]byte, error) {
	ra.OdataType = OdataTypeBasicRuleActionOdataTypeRuleAction
	objectMap := make(map[string]interface{})
	if ra.OdataType != "" {
		objectMap["odata.type"] = ra.OdataType
	}
	return json.Marshal(objectMap)
}

// AsRuleEmailAction is the BasicRuleAction implementation for RuleAction.
func (ra RuleAction) AsRuleEmailAction() (*RuleEmailAction, bool) {
	return nil, false
}

// AsRuleWebhookAction is the BasicRuleAction implementation for RuleAction.
func (ra RuleAction) AsRuleWebhookAction() (*RuleWebhookAction, bool) {
	return nil, false
}

// AsRuleAction is the BasicRuleAction implementation for RuleAction.
func (ra RuleAction) AsRuleAction() (*RuleAction, bool) {
	return &ra, true
}

// AsBasicRuleAction is the BasicRuleAction implementation for RuleAction.
func (ra RuleAction) AsBasicRuleAction() (BasicRuleAction, bool) {
	return &ra, true
}

// BasicRuleCondition the condition that results in the alert rule being activated.
type BasicRuleCondition interface {
	AsThresholdRuleCondition() (*ThresholdRuleCondition, bool)
	AsLocationThresholdRuleCondition() (*LocationThresholdRuleCondition, bool)
	AsManagementEventRuleCondition() (*ManagementEventRuleCondition, bool)
	AsRuleCondition() (*RuleCondition, bool)
}

// RuleCondition the condition that results in the alert rule being activated.
type RuleCondition struct {
	// DataSource - the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
	DataSource BasicRuleDataSource `json:"dataSource,omitempty"`
	// OdataType - Possible values include: 'OdataTypeBasicRuleConditionOdataTypeRuleCondition', 'OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition', 'OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition', 'OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition'
	OdataType OdataTypeBasicRuleCondition `json:"odata.type,omitempty"`
}

func unmarshalBasicRuleCondition(body []byte) (BasicRuleCondition, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["odata.type"] {
	case string(OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition):
		var trc ThresholdRuleCondition
		err := json.Unmarshal(body, &trc)
		return trc, err
	case string(OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition):
		var ltrc LocationThresholdRuleCondition
		err := json.Unmarshal(body, &ltrc)
		return ltrc, err
	case string(OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition):
		var merc ManagementEventRuleCondition
		err := json.Unmarshal(body, &merc)
		return merc, err
	default:
		var rc RuleCondition
		err := json.Unmarshal(body, &rc)
		return rc, err
	}
}
func unmarshalBasicRuleConditionArray(body []byte) ([]BasicRuleCondition, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rcArray := make([]BasicRuleCondition, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rc, err := unmarshalBasicRuleCondition(*rawMessage)
		if err != nil {
			return nil, err
		}
		rcArray[index] = rc
	}
	return rcArray, nil
}

// MarshalJSON is the custom marshaler for RuleCondition.
func (rc RuleCondition) MarshalJSON() ([]byte, error) {
	rc.OdataType = OdataTypeBasicRuleConditionOdataTypeRuleCondition
	objectMap := make(map[string]interface{})
	objectMap["dataSource"] = rc.DataSource
	if rc.OdataType != "" {
		objectMap["odata.type"] = rc.OdataType
	}
	return json.Marshal(objectMap)
}

// AsThresholdRuleCondition is the BasicRuleCondition implementation for RuleCondition.
func (rc RuleCondition) AsThresholdRuleCondition() (*ThresholdRuleCondition, bool) {
	return nil, false
}

// AsLocationThresholdRuleCondition is the BasicRuleCondition implementation for RuleCondition.
func (rc RuleCondition) AsLocationThresholdRuleCondition() (*LocationThresholdRuleCondition, bool) {
	return nil, false
}

// AsManagementEventRuleCondition is the BasicRuleCondition implementation for RuleCondition.
func (rc RuleCondition) AsManagementEventRuleCondition() (*ManagementEventRuleCondition, bool) {
	return nil, false
}

// AsRuleCondition is the BasicRuleCondition implementation for RuleCondition.
func (rc RuleCondition) AsRuleCondition() (*RuleCondition, bool) {
	return &rc, true
}

// AsBasicRuleCondition is the BasicRuleCondition implementation for RuleCondition.
func (rc RuleCondition) AsBasicRuleCondition() (BasicRuleCondition, bool) {
	return &rc, true
}

// UnmarshalJSON is the custom unmarshaler for RuleCondition struct.
func (rc *RuleCondition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "dataSource":
			if v != nil {
				dataSource, err := unmarshalBasicRuleDataSource(*v)
				if err != nil {
					return err
				}
				rc.DataSource = dataSource
			}
		case "odata.type":
			if v != nil {
				var odataType OdataTypeBasicRuleCondition
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				rc.OdataType = odataType
			}
		}
	}

	return nil
}

// BasicRuleDataSource the resource from which the rule collects its data.
type BasicRuleDataSource interface {
	AsRuleMetricDataSource() (*RuleMetricDataSource, bool)
	AsRuleManagementEventDataSource() (*RuleManagementEventDataSource, bool)
	AsRuleDataSource() (*RuleDataSource, bool)
}

// RuleDataSource the resource from which the rule collects its data.
type RuleDataSource struct {
	// ResourceURI - the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// LegacyResourceID - the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
	LegacyResourceID *string `json:"legacyResourceId,omitempty"`
	// ResourceLocation - the location of the resource.
	ResourceLocation *string `json:"resourceLocation,omitempty"`
	// MetricNamespace - the namespace of the metric.
	MetricNamespace *string `json:"metricNamespace,omitempty"`
	// OdataType - Possible values include: 'OdataTypeRuleDataSource', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource'
	OdataType OdataType `json:"odata.type,omitempty"`
}

func unmarshalBasicRuleDataSource(body []byte) (BasicRuleDataSource, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["odata.type"] {
	case string(OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource):
		var rmds RuleMetricDataSource
		err := json.Unmarshal(body, &rmds)
		return rmds, err
	case string(OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource):
		var rmeds RuleManagementEventDataSource
		err := json.Unmarshal(body, &rmeds)
		return rmeds, err
	default:
		var rds RuleDataSource
		err := json.Unmarshal(body, &rds)
		return rds, err
	}
}
func unmarshalBasicRuleDataSourceArray(body []byte) ([]BasicRuleDataSource, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rdsArray := make([]BasicRuleDataSource, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rds, err := unmarshalBasicRuleDataSource(*rawMessage)
		if err != nil {
			return nil, err
		}
		rdsArray[index] = rds
	}
	return rdsArray, nil
}

// MarshalJSON is the custom marshaler for RuleDataSource.
func (rds RuleDataSource) MarshalJSON() ([]byte, error) {
	rds.OdataType = OdataTypeRuleDataSource
	objectMap := make(map[string]interface{})
	if rds.ResourceURI != nil {
		objectMap["resourceUri"] = rds.ResourceURI
	}
	if rds.LegacyResourceID != nil {
		objectMap["legacyResourceId"] = rds.LegacyResourceID
	}
	if rds.ResourceLocation != nil {
		objectMap["resourceLocation"] = rds.ResourceLocation
	}
	if rds.MetricNamespace != nil {
		objectMap["metricNamespace"] = rds.MetricNamespace
	}
	if rds.OdataType != "" {
		objectMap["odata.type"] = rds.OdataType
	}
	return json.Marshal(objectMap)
}

// AsRuleMetricDataSource is the BasicRuleDataSource implementation for RuleDataSource.
func (rds RuleDataSource) AsRuleMetricDataSource() (*RuleMetricDataSource, bool) {
	return nil, false
}

// AsRuleManagementEventDataSource is the BasicRuleDataSource implementation for RuleDataSource.
func (rds RuleDataSource) AsRuleManagementEventDataSource() (*RuleManagementEventDataSource, bool) {
	return nil, false
}

// AsRuleDataSource is the BasicRuleDataSource implementation for RuleDataSource.
func (rds RuleDataSource) AsRuleDataSource() (*RuleDataSource, bool) {
	return &rds, true
}

// AsBasicRuleDataSource is the BasicRuleDataSource implementation for RuleDataSource.
func (rds RuleDataSource) AsBasicRuleDataSource() (BasicRuleDataSource, bool) {
	return &rds, true
}

// RuleEmailAction specifies the action to send email when the rule condition is evaluated. The
// discriminator is always RuleEmailAction in this case.
type RuleEmailAction struct {
	// SendToServiceOwners - Whether the administrators (service and co-administrators) of the service should be notified when the alert is activated.
	SendToServiceOwners *bool `json:"sendToServiceOwners,omitempty"`
	// CustomEmails - the list of administrator's custom email addresses to notify of the activation of the alert.
	CustomEmails *[]string `json:"customEmails,omitempty"`
	// OdataType - Possible values include: 'OdataTypeBasicRuleActionOdataTypeRuleAction', 'OdataTypeBasicRuleActionOdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction', 'OdataTypeBasicRuleActionOdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction'
	OdataType OdataTypeBasicRuleAction `json:"odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleEmailAction.
func (rea RuleEmailAction) MarshalJSON() ([]byte, error) {
	rea.OdataType = OdataTypeBasicRuleActionOdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction
	objectMap := make(map[string]interface{})
	if rea.SendToServiceOwners != nil {
		objectMap["sendToServiceOwners"] = rea.SendToServiceOwners
	}
	if rea.CustomEmails != nil {
		objectMap["customEmails"] = rea.CustomEmails
	}
	if rea.OdataType != "" {
		objectMap["odata.type"] = rea.OdataType
	}
	return json.Marshal(objectMap)
}

// AsRuleEmailAction is the BasicRuleAction implementation for RuleEmailAction.
func (rea RuleEmailAction) AsRuleEmailAction() (*RuleEmailAction, bool) {
	return &rea, true
}

// AsRuleWebhookAction is the BasicRuleAction implementation for RuleEmailAction.
func (rea RuleEmailAction) AsRuleWebhookAction() (*RuleWebhookAction, bool) {
	return nil, false
}

// AsRuleAction is the BasicRuleAction implementation for RuleEmailAction.
func (rea RuleEmailAction) AsRuleAction() (*RuleAction, bool) {
	return nil, false
}

// AsBasicRuleAction is the BasicRuleAction implementation for RuleEmailAction.
func (rea RuleEmailAction) AsBasicRuleAction() (BasicRuleAction, bool) {
	return &rea, true
}

// RuleManagementEventClaimsDataSource the claims for a rule management event data source.
type RuleManagementEventClaimsDataSource struct {
	// EmailAddress - the email address.
	EmailAddress *string `json:"emailAddress,omitempty"`
}

// RuleManagementEventDataSource a rule management event data source. The discriminator fields is always
// RuleManagementEventDataSource in this case.
type RuleManagementEventDataSource struct {
	// EventName - the event name.
	EventName *string `json:"eventName,omitempty"`
	// EventSource - the event source.
	EventSource *string `json:"eventSource,omitempty"`
	// Level - the level.
	Level *string `json:"level,omitempty"`
	// OperationName - The name of the operation that should be checked for. If no name is provided, any operation will match.
	OperationName *string `json:"operationName,omitempty"`
	// ResourceGroupName - the resource group name.
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`
	// ResourceProviderName - the resource provider name.
	ResourceProviderName *string `json:"resourceProviderName,omitempty"`
	// Status - The status of the operation that should be checked for. If no status is provided, any status will match.
	Status *string `json:"status,omitempty"`
	// SubStatus - the substatus.
	SubStatus *string `json:"subStatus,omitempty"`
	// Claims - the claims.
	Claims *RuleManagementEventClaimsDataSource `json:"claims,omitempty"`
	// ResourceURI - the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// LegacyResourceID - the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
	LegacyResourceID *string `json:"legacyResourceId,omitempty"`
	// ResourceLocation - the location of the resource.
	ResourceLocation *string `json:"resourceLocation,omitempty"`
	// MetricNamespace - the namespace of the metric.
	MetricNamespace *string `json:"metricNamespace,omitempty"`
	// OdataType - Possible values include: 'OdataTypeRuleDataSource', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource'
	OdataType OdataType `json:"odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleManagementEventDataSource.
func (rmeds RuleManagementEventDataSource) MarshalJSON() ([]byte, error) {
	rmeds.OdataType = OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource
	objectMap := make(map[string]interface{})
	if rmeds.EventName != nil {
		objectMap["eventName"] = rmeds.EventName
	}
	if rmeds.EventSource != nil {
		objectMap["eventSource"] = rmeds.EventSource
	}
	if rmeds.Level != nil {
		objectMap["level"] = rmeds.Level
	}
	if rmeds.OperationName != nil {
		objectMap["operationName"] = rmeds.OperationName
	}
	if rmeds.ResourceGroupName != nil {
		objectMap["resourceGroupName"] = rmeds.ResourceGroupName
	}
	if rmeds.ResourceProviderName != nil {
		objectMap["resourceProviderName"] = rmeds.ResourceProviderName
	}
	if rmeds.Status != nil {
		objectMap["status"] = rmeds.Status
	}
	if rmeds.SubStatus != nil {
		objectMap["subStatus"] = rmeds.SubStatus
	}
	if rmeds.Claims != nil {
		objectMap["claims"] = rmeds.Claims
	}
	if rmeds.ResourceURI != nil {
		objectMap["resourceUri"] = rmeds.ResourceURI
	}
	if rmeds.LegacyResourceID != nil {
		objectMap["legacyResourceId"] = rmeds.LegacyResourceID
	}
	if rmeds.ResourceLocation != nil {
		objectMap["resourceLocation"] = rmeds.ResourceLocation
	}
	if rmeds.MetricNamespace != nil {
		objectMap["metricNamespace"] = rmeds.MetricNamespace
	}
	if rmeds.OdataType != "" {
		objectMap["odata.type"] = rmeds.OdataType
	}
	return json.Marshal(objectMap)
}

// AsRuleMetricDataSource is the BasicRuleDataSource implementation for RuleManagementEventDataSource.
func (rmeds RuleManagementEventDataSource) AsRuleMetricDataSource() (*RuleMetricDataSource, bool) {
	return nil, false
}

// AsRuleManagementEventDataSource is the BasicRuleDataSource implementation for RuleManagementEventDataSource.
func (rmeds RuleManagementEventDataSource) AsRuleManagementEventDataSource() (*RuleManagementEventDataSource, bool) {
	return &rmeds, true
}

// AsRuleDataSource is the BasicRuleDataSource implementation for RuleManagementEventDataSource.
func (rmeds RuleManagementEventDataSource) AsRuleDataSource() (*RuleDataSource, bool) {
	return nil, false
}

// AsBasicRuleDataSource is the BasicRuleDataSource implementation for RuleManagementEventDataSource.
func (rmeds RuleManagementEventDataSource) AsBasicRuleDataSource() (BasicRuleDataSource, bool) {
	return &rmeds, true
}

// RuleMetricDataSource a rule metric data source. The discriminator value is always RuleMetricDataSource
// in this case.
type RuleMetricDataSource struct {
	// MetricName - the name of the metric that defines what the rule monitors.
	MetricName *string `json:"metricName,omitempty"`
	// ResourceURI - the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// LegacyResourceID - the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
	LegacyResourceID *string `json:"legacyResourceId,omitempty"`
	// ResourceLocation - the location of the resource.
	ResourceLocation *string `json:"resourceLocation,omitempty"`
	// MetricNamespace - the namespace of the metric.
	MetricNamespace *string `json:"metricNamespace,omitempty"`
	// OdataType - Possible values include: 'OdataTypeRuleDataSource', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource'
	OdataType OdataType `json:"odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleMetricDataSource.
func (rmds RuleMetricDataSource) MarshalJSON() ([]byte, error) {
	rmds.OdataType = OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource
	objectMap := make(map[string]interface{})
	if rmds.MetricName != nil {
		objectMap["metricName"] = rmds.MetricName
	}
	if rmds.ResourceURI != nil {
		objectMap["resourceUri"] = rmds.ResourceURI
	}
	if rmds.LegacyResourceID != nil {
		objectMap["legacyResourceId"] = rmds.LegacyResourceID
	}
	if rmds.ResourceLocation != nil {
		objectMap["resourceLocation"] = rmds.ResourceLocation
	}
	if rmds.MetricNamespace != nil {
		objectMap["metricNamespace"] = rmds.MetricNamespace
	}
	if rmds.OdataType != "" {
		objectMap["odata.type"] = rmds.OdataType
	}
	return json.Marshal(objectMap)
}

// AsRuleMetricDataSource is the BasicRuleDataSource implementation for RuleMetricDataSource.
func (rmds RuleMetricDataSource) AsRuleMetricDataSource() (*RuleMetricDataSource, bool) {
	return &rmds, true
}

// AsRuleManagementEventDataSource is the BasicRuleDataSource implementation for RuleMetricDataSource.
func (rmds RuleMetricDataSource) AsRuleManagementEventDataSource() (*RuleManagementEventDataSource, bool) {
	return nil, false
}

// AsRuleDataSource is the BasicRuleDataSource implementation for RuleMetricDataSource.
func (rmds RuleMetricDataSource) AsRuleDataSource() (*RuleDataSource, bool) {
	return nil, false
}

// AsBasicRuleDataSource is the BasicRuleDataSource implementation for RuleMetricDataSource.
func (rmds RuleMetricDataSource) AsBasicRuleDataSource() (BasicRuleDataSource, bool) {
	return &rmds, true
}

// RuleWebhookAction specifies the action to post to service when the rule condition is evaluated. The
// discriminator is always RuleWebhookAction in this case.
type RuleWebhookAction struct {
	// ServiceURI - the service uri to Post the notification when the alert activates or resolves.
	ServiceURI *string `json:"serviceUri,omitempty"`
	// Properties - the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
	Properties map[string]*string `json:"properties"`
	// OdataType - Possible values include: 'OdataTypeBasicRuleActionOdataTypeRuleAction', 'OdataTypeBasicRuleActionOdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction', 'OdataTypeBasicRuleActionOdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction'
	OdataType OdataTypeBasicRuleAction `json:"odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleWebhookAction.
func (rwa RuleWebhookAction) MarshalJSON() ([]byte, error) {
	rwa.OdataType = OdataTypeBasicRuleActionOdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction
	objectMap := make(map[string]interface{})
	if rwa.ServiceURI != nil {
		objectMap["serviceUri"] = rwa.ServiceURI
	}
	if rwa.Properties != nil {
		objectMap["properties"] = rwa.Properties
	}
	if rwa.OdataType != "" {
		objectMap["odata.type"] = rwa.OdataType
	}
	return json.Marshal(objectMap)
}

// AsRuleEmailAction is the BasicRuleAction implementation for RuleWebhookAction.
func (rwa RuleWebhookAction) AsRuleEmailAction() (*RuleEmailAction, bool) {
	return nil, false
}

// AsRuleWebhookAction is the BasicRuleAction implementation for RuleWebhookAction.
func (rwa RuleWebhookAction) AsRuleWebhookAction() (*RuleWebhookAction, bool) {
	return &rwa, true
}

// AsRuleAction is the BasicRuleAction implementation for RuleWebhookAction.
func (rwa RuleWebhookAction) AsRuleAction() (*RuleAction, bool) {
	return nil, false
}

// AsBasicRuleAction is the BasicRuleAction implementation for RuleWebhookAction.
func (rwa RuleWebhookAction) AsBasicRuleAction() (BasicRuleAction, bool) {
	return &rwa, true
}

// ThresholdRuleCondition a rule condition based on a metric crossing a threshold.
type ThresholdRuleCondition struct {
	// Operator - the operator used to compare the data and the threshold. Possible values include: 'ConditionOperatorGreaterThan', 'ConditionOperatorGreaterThanOrEqual', 'ConditionOperatorLessThan', 'ConditionOperatorLessThanOrEqual'
	Operator ConditionOperator `json:"operator,omitempty"`
	// Threshold - the threshold value that activates the alert.
	Threshold *float64 `json:"threshold,omitempty"`
	// WindowSize - the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
	WindowSize *string `json:"windowSize,omitempty"`
	// TimeAggregation - the time aggregation operator. How the data that are collected should be combined over time. The default value is the PrimaryAggregationType of the Metric. Possible values include: 'TimeAggregationOperatorAverage', 'TimeAggregationOperatorMinimum', 'TimeAggregationOperatorMaximum', 'TimeAggregationOperatorTotal', 'TimeAggregationOperatorLast'
	TimeAggregation TimeAggregationOperator `json:"timeAggregation,omitempty"`
	// DataSource - the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
	DataSource BasicRuleDataSource `json:"dataSource,omitempty"`
	// OdataType - Possible values include: 'OdataTypeBasicRuleConditionOdataTypeRuleCondition', 'OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition', 'OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition', 'OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition'
	OdataType OdataTypeBasicRuleCondition `json:"odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for ThresholdRuleCondition.
func (trc ThresholdRuleCondition) MarshalJSON() ([]byte, error) {
	trc.OdataType = OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition
	objectMap := make(map[string]interface{})
	if trc.Operator != "" {
		objectMap["operator"] = trc.Operator
	}
	if trc.Threshold != nil {
		objectMap["threshold"] = trc.Threshold
	}
	if trc.WindowSize != nil {
		objectMap["windowSize"] = trc.WindowSize
	}
	if trc.TimeAggregation != "" {
		objectMap["timeAggregation"] = trc.TimeAggregation
	}
	objectMap["dataSource"] = trc.DataSource
	if trc.OdataType != "" {
		objectMap["odata.type"] = trc.OdataType
	}
	return json.Marshal(objectMap)
}

// AsThresholdRuleCondition is the BasicRuleCondition implementation for ThresholdRuleCondition.
func (trc ThresholdRuleCondition) AsThresholdRuleCondition() (*ThresholdRuleCondition, bool) {
	return &trc, true
}

// AsLocationThresholdRuleCondition is the BasicRuleCondition implementation for ThresholdRuleCondition.
func (trc ThresholdRuleCondition) AsLocationThresholdRuleCondition() (*LocationThresholdRuleCondition, bool) {
	return nil, false
}

// AsManagementEventRuleCondition is the BasicRuleCondition implementation for ThresholdRuleCondition.
func (trc ThresholdRuleCondition) AsManagementEventRuleCondition() (*ManagementEventRuleCondition, bool) {
	return nil, false
}

// AsRuleCondition is the BasicRuleCondition implementation for ThresholdRuleCondition.
func (trc ThresholdRuleCondition) AsRuleCondition() (*RuleCondition, bool) {
	return nil, false
}

// AsBasicRuleCondition is the BasicRuleCondition implementation for ThresholdRuleCondition.
func (trc ThresholdRuleCondition) AsBasicRuleCondition() (BasicRuleCondition, bool) {
	return &trc, true
}

// UnmarshalJSON is the custom unmarshaler for ThresholdRuleCondition struct.
func (trc *ThresholdRuleCondition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "operator":
			if v != nil {
				var operator ConditionOperator
				err = json.Unmarshal(*v, &operator)
				if err != nil {
					return err
				}
				trc.Operator = operator
			}
		case "threshold":
			if v != nil {
				var threshold float64
				err = json.Unmarshal(*v, &threshold)
				if err != nil {
					return err
				}
				trc.Threshold = &threshold
			}
		case "windowSize":
			if v != nil {
				var windowSize string
				err = json.Unmarshal(*v, &windowSize)
				if err != nil {
					return err
				}
				trc.WindowSize = &windowSize
			}
		case "timeAggregation":
			if v != nil {
				var timeAggregation TimeAggregationOperator
				err = json.Unmarshal(*v, &timeAggregation)
				if err != nil {
					return err
				}
				trc.TimeAggregation = timeAggregation
			}
		case "dataSource":
			if v != nil {
				dataSource, err := unmarshalBasicRuleDataSource(*v)
				if err != nil {
					return err
				}
				trc.DataSource = dataSource
			}
		case "odata.type":
			if v != nil {
				var odataType OdataTypeBasicRuleCondition
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				trc.OdataType = odataType
			}
		}
	}

	return nil
}

// VMInsightsOnboardingStatus VM Insights onboarding status for a resource.
type VMInsightsOnboardingStatus struct {
	autorest.Response `json:"-"`
	// VMInsightsOnboardingStatusProperties - Resource properties.
	*VMInsightsOnboardingStatusProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VMInsightsOnboardingStatus.
func (vios VMInsightsOnboardingStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vios.VMInsightsOnboardingStatusProperties != nil {
		objectMap["properties"] = vios.VMInsightsOnboardingStatusProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VMInsightsOnboardingStatus struct.
func (vios *VMInsightsOnboardingStatus) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var VMInsightsOnboardingStatusProperties VMInsightsOnboardingStatusProperties
				err = json.Unmarshal(*v, &VMInsightsOnboardingStatusProperties)
				if err != nil {
					return err
				}
				vios.VMInsightsOnboardingStatusProperties = &VMInsightsOnboardingStatusProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vios.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vios.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vios.Type = &typeVar
			}
		}
	}

	return nil
}

// VMInsightsOnboardingStatusProperties resource properties.
type VMInsightsOnboardingStatusProperties struct {
	// ResourceID - Azure Resource Manager identifier of the resource whose onboarding status is being represented.
	ResourceID *string `json:"resourceId,omitempty"`
	// OnboardingStatus - The onboarding status for the resource. Note that, a higher level scope, e.g., resource group or subscription, is considered onboarded if at least one resource under it is onboarded. Possible values include: 'OnboardingStatusOnboarded', 'OnboardingStatusNotOnboarded', 'OnboardingStatusUnknown'
	OnboardingStatus OnboardingStatus `json:"onboardingStatus,omitempty"`
	// DataStatus - The status of VM Insights data from the resource. When reported as `present` the data array will contain information about the data containers to which data for the specified resource is being routed. Possible values include: 'DataStatusPresent', 'DataStatusNotPresent'
	DataStatus DataStatus `json:"dataStatus,omitempty"`
	// Data - Containers that currently store VM Insights data for the specified resource.
	Data *[]DataContainer `json:"data,omitempty"`
}

// WorkspaceInfo information about a Log Analytics Workspace.
type WorkspaceInfo struct {
	// ID - Azure Resource Manager identifier of the Log Analytics Workspace.
	ID *string `json:"id,omitempty"`
	// Location - Location of the Log Analytics workspace.
	Location *string `json:"location,omitempty"`
	// WorkspaceInfoProperties - Resource properties.
	*WorkspaceInfoProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceInfo.
func (wi WorkspaceInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wi.ID != nil {
		objectMap["id"] = wi.ID
	}
	if wi.Location != nil {
		objectMap["location"] = wi.Location
	}
	if wi.WorkspaceInfoProperties != nil {
		objectMap["properties"] = wi.WorkspaceInfoProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkspaceInfo struct.
func (wi *WorkspaceInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wi.ID = &ID
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				wi.Location = &location
			}
		case "properties":
			if v != nil {
				var workspaceInfoProperties WorkspaceInfoProperties
				err = json.Unmarshal(*v, &workspaceInfoProperties)
				if err != nil {
					return err
				}
				wi.WorkspaceInfoProperties = &workspaceInfoProperties
			}
		}
	}

	return nil
}

// WorkspaceInfoProperties resource properties.
type WorkspaceInfoProperties struct {
	// CustomerID - Log Analytics workspace identifier.
	CustomerID *string `json:"customerId,omitempty"`
}
