package policyinsights

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// PolicyStatesClient is the client for the PolicyStates methods of the Policyinsights service.
type PolicyStatesClient struct {
	BaseClient
}

// NewPolicyStatesClient creates an instance of the PolicyStatesClient client.
func NewPolicyStatesClient() PolicyStatesClient {
	return NewPolicyStatesClientWithBaseURI(DefaultBaseURI)
}

// NewPolicyStatesClientWithBaseURI creates an instance of the PolicyStatesClient client using a custom endpoint.  Use
// this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewPolicyStatesClientWithBaseURI(baseURI string) PolicyStatesClient {
	return PolicyStatesClient{NewWithBaseURI(baseURI)}
}

// ListQueryResultsForManagementGroup queries policy states for the resources under the management group.
// Parameters:
// policyStatesResource - the virtual resource under PolicyStates resource type. In a given time range,
// 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s).
// managementGroupName - management group name.
// top - maximum number of records to return.
// orderBy - ordering expression using OData notation. One or more comma-separated column names with an
// optional "desc" (the default) or "asc", e.g. "$orderby=PolicyAssignmentId, ResourceId asc".
// selectParameter - select expression using OData notation. Limits the columns on each record to just those
// requested, e.g. "$select=PolicyAssignmentId, ResourceId".
// from - ISO 8601 formatted timestamp specifying the start time of the interval to query. When not specified,
// the service uses ($to - 1-day).
// toParameter - ISO 8601 formatted timestamp specifying the end time of the interval to query. When not
// specified, the service uses request time.
// filter - oData filter expression.
// apply - oData apply expression for aggregations.
// skipToken - skiptoken is only provided if a previous response returned a partial result as a part of
// nextLink element.
func (client PolicyStatesClient) ListQueryResultsForManagementGroup(ctx context.Context, policyStatesResource PolicyStatesResource, managementGroupName string, top *int32, orderBy string, selectParameter string, from *date.Time, toParameter *date.Time, filter string, apply string, skipToken string) (result PolicyStatesQueryResultsPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.ListQueryResultsForManagementGroup")
		defer func() {
			sc := -1
			if result.psqr.Response.Response != nil {
				sc = result.psqr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.PolicyStatesClient", "ListQueryResultsForManagementGroup", err.Error())
	}

	result.fn = client.listQueryResultsForManagementGroupNextResults
	req, err := client.ListQueryResultsForManagementGroupPreparer(ctx, policyStatesResource, managementGroupName, top, orderBy, selectParameter, from, toParameter, filter, apply, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "ListQueryResultsForManagementGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListQueryResultsForManagementGroupSender(req)
	if err != nil {
		result.psqr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "ListQueryResultsForManagementGroup", resp, "Failure sending request")
		return
	}

	result.psqr, err = client.ListQueryResultsForManagementGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "ListQueryResultsForManagementGroup", resp, "Failure responding to request")
		return
	}
	if result.psqr.hasNextLink() && result.psqr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListQueryResultsForManagementGroupPreparer prepares the ListQueryResultsForManagementGroup request.
func (client PolicyStatesClient) ListQueryResultsForManagementGroupPreparer(ctx context.Context, policyStatesResource PolicyStatesResource, managementGroupName string, top *int32, orderBy string, selectParameter string, from *date.Time, toParameter *date.Time, filter string, apply string, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managementGroupName":       autorest.Encode("path", managementGroupName),
		"managementGroupsNamespace": autorest.Encode("path", "Microsoft.Management"),
		"policyStatesResource":      autorest.Encode("path", policyStatesResource),
	}

	const APIVersion = "2019-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(orderBy) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderBy)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if from != nil {
		queryParameters["$from"] = autorest.Encode("query", *from)
	}
	if toParameter != nil {
		queryParameters["$to"] = autorest.Encode("query", *toParameter)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(apply) > 0 {
		queryParameters["$apply"] = autorest.Encode("query", apply)
	}
	if len(skipToken) > 0 {
		queryParameters["$skiptoken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/{managementGroupsNamespace}/managementGroups/{managementGroupName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListQueryResultsForManagementGroupSender sends the ListQueryResultsForManagementGroup request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyStatesClient) ListQueryResultsForManagementGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListQueryResultsForManagementGroupResponder handles the response to the ListQueryResultsForManagementGroup request. The method always
// closes the http.Response Body.
func (client PolicyStatesClient) ListQueryResultsForManagementGroupResponder(resp *http.Response) (result PolicyStatesQueryResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listQueryResultsForManagementGroupNextResults retrieves the next set of results, if any.
func (client PolicyStatesClient) listQueryResultsForManagementGroupNextResults(ctx context.Context, lastResults PolicyStatesQueryResults) (result PolicyStatesQueryResults, err error) {
	req, err := lastResults.policyStatesQueryResultsPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "listQueryResultsForManagementGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListQueryResultsForManagementGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "listQueryResultsForManagementGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListQueryResultsForManagementGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "listQueryResultsForManagementGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListQueryResultsForManagementGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client PolicyStatesClient) ListQueryResultsForManagementGroupComplete(ctx context.Context, policyStatesResource PolicyStatesResource, managementGroupName string, top *int32, orderBy string, selectParameter string, from *date.Time, toParameter *date.Time, filter string, apply string, skipToken string) (result PolicyStatesQueryResultsIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.ListQueryResultsForManagementGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListQueryResultsForManagementGroup(ctx, policyStatesResource, managementGroupName, top, orderBy, selectParameter, from, toParameter, filter, apply, skipToken)
	return
}

// ListQueryResultsForPolicyDefinition queries policy states for the subscription level policy definition.
// Parameters:
// policyStatesResource - the virtual resource under PolicyStates resource type. In a given time range,
// 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s).
// subscriptionID - microsoft Azure subscription ID.
// policyDefinitionName - policy definition name.
// top - maximum number of records to return.
// orderBy - ordering expression using OData notation. One or more comma-separated column names with an
// optional "desc" (the default) or "asc", e.g. "$orderby=PolicyAssignmentId, ResourceId asc".
// selectParameter - select expression using OData notation. Limits the columns on each record to just those
// requested, e.g. "$select=PolicyAssignmentId, ResourceId".
// from - ISO 8601 formatted timestamp specifying the start time of the interval to query. When not specified,
// the service uses ($to - 1-day).
// toParameter - ISO 8601 formatted timestamp specifying the end time of the interval to query. When not
// specified, the service uses request time.
// filter - oData filter expression.
// apply - oData apply expression for aggregations.
// skipToken - skiptoken is only provided if a previous response returned a partial result as a part of
// nextLink element.
func (client PolicyStatesClient) ListQueryResultsForPolicyDefinition(ctx context.Context, policyStatesResource PolicyStatesResource, subscriptionID string, policyDefinitionName string, top *int32, orderBy string, selectParameter string, from *date.Time, toParameter *date.Time, filter string, apply string, skipToken string) (result PolicyStatesQueryResultsPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.ListQueryResultsForPolicyDefinition")
		defer func() {
			sc := -1
			if result.psqr.Response.Response != nil {
				sc = result.psqr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.PolicyStatesClient", "ListQueryResultsForPolicyDefinition", err.Error())
	}

	result.fn = client.listQueryResultsForPolicyDefinitionNextResults
	req, err := client.ListQueryResultsForPolicyDefinitionPreparer(ctx, policyStatesResource, subscriptionID, policyDefinitionName, top, orderBy, selectParameter, from, toParameter, filter, apply, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "ListQueryResultsForPolicyDefinition", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListQueryResultsForPolicyDefinitionSender(req)
	if err != nil {
		result.psqr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "ListQueryResultsForPolicyDefinition", resp, "Failure sending request")
		return
	}

	result.psqr, err = client.ListQueryResultsForPolicyDefinitionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "ListQueryResultsForPolicyDefinition", resp, "Failure responding to request")
		return
	}
	if result.psqr.hasNextLink() && result.psqr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListQueryResultsForPolicyDefinitionPreparer prepares the ListQueryResultsForPolicyDefinition request.
func (client PolicyStatesClient) ListQueryResultsForPolicyDefinitionPreparer(ctx context.Context, policyStatesResource PolicyStatesResource, subscriptionID string, policyDefinitionName string, top *int32, orderBy string, selectParameter string, from *date.Time, toParameter *date.Time, filter string, apply string, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"authorizationNamespace": autorest.Encode("path", "Microsoft.Authorization"),
		"policyDefinitionName":   autorest.Encode("path", policyDefinitionName),
		"policyStatesResource":   autorest.Encode("path", policyStatesResource),
		"subscriptionId":         autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2019-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(orderBy) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderBy)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if from != nil {
		queryParameters["$from"] = autorest.Encode("query", *from)
	}
	if toParameter != nil {
		queryParameters["$to"] = autorest.Encode("query", *toParameter)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(apply) > 0 {
		queryParameters["$apply"] = autorest.Encode("query", apply)
	}
	if len(skipToken) > 0 {
		queryParameters["$skiptoken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyDefinitions/{policyDefinitionName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListQueryResultsForPolicyDefinitionSender sends the ListQueryResultsForPolicyDefinition request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyStatesClient) ListQueryResultsForPolicyDefinitionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListQueryResultsForPolicyDefinitionResponder handles the response to the ListQueryResultsForPolicyDefinition request. The method always
// closes the http.Response Body.
func (client PolicyStatesClient) ListQueryResultsForPolicyDefinitionResponder(resp *http.Response) (result PolicyStatesQueryResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listQueryResultsForPolicyDefinitionNextResults retrieves the next set of results, if any.
func (client PolicyStatesClient) listQueryResultsForPolicyDefinitionNextResults(ctx context.Context, lastResults PolicyStatesQueryResults) (result PolicyStatesQueryResults, err error) {
	req, err := lastResults.policyStatesQueryResultsPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "listQueryResultsForPolicyDefinitionNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListQueryResultsForPolicyDefinitionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "listQueryResultsForPolicyDefinitionNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListQueryResultsForPolicyDefinitionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "listQueryResultsForPolicyDefinitionNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListQueryResultsForPolicyDefinitionComplete enumerates all values, automatically crossing page boundaries as required.
func (client PolicyStatesClient) ListQueryResultsForPolicyDefinitionComplete(ctx context.Context, policyStatesResource PolicyStatesResource, subscriptionID string, policyDefinitionName string, top *int32, orderBy string, selectParameter string, from *date.Time, toParameter *date.Time, filter string, apply string, skipToken string) (result PolicyStatesQueryResultsIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.ListQueryResultsForPolicyDefinition")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListQueryResultsForPolicyDefinition(ctx, policyStatesResource, subscriptionID, policyDefinitionName, top, orderBy, selectParameter, from, toParameter, filter, apply, skipToken)
	return
}

// ListQueryResultsForPolicySetDefinition queries policy states for the subscription level policy set definition.
// Parameters:
// policyStatesResource - the virtual resource under PolicyStates resource type. In a given time range,
// 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s).
// subscriptionID - microsoft Azure subscription ID.
// policySetDefinitionName - policy set definition name.
// top - maximum number of records to return.
// orderBy - ordering expression using OData notation. One or more comma-separated column names with an
// optional "desc" (the default) or "asc", e.g. "$orderby=PolicyAssignmentId, ResourceId asc".
// selectParameter - select expression using OData notation. Limits the columns on each record to just those
// requested, e.g. "$select=PolicyAssignmentId, ResourceId".
// from - ISO 8601 formatted timestamp specifying the start time of the interval to query. When not specified,
// the service uses ($to - 1-day).
// toParameter - ISO 8601 formatted timestamp specifying the end time of the interval to query. When not
// specified, the service uses request time.
// filter - oData filter expression.
// apply - oData apply expression for aggregations.
// skipToken - skiptoken is only provided if a previous response returned a partial result as a part of
// nextLink element.
func (client PolicyStatesClient) ListQueryResultsForPolicySetDefinition(ctx context.Context, policyStatesResource PolicyStatesResource, subscriptionID string, policySetDefinitionName string, top *int32, orderBy string, selectParameter string, from *date.Time, toParameter *date.Time, filter string, apply string, skipToken string) (result PolicyStatesQueryResultsPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.ListQueryResultsForPolicySetDefinition")
		defer func() {
			sc := -1
			if result.psqr.Response.Response != nil {
				sc = result.psqr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.PolicyStatesClient", "ListQueryResultsForPolicySetDefinition", err.Error())
	}

	result.fn = client.listQueryResultsForPolicySetDefinitionNextResults
	req, err := client.ListQueryResultsForPolicySetDefinitionPreparer(ctx, policyStatesResource, subscriptionID, policySetDefinitionName, top, orderBy, selectParameter, from, toParameter, filter, apply, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "ListQueryResultsForPolicySetDefinition", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListQueryResultsForPolicySetDefinitionSender(req)
	if err != nil {
		result.psqr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "ListQueryResultsForPolicySetDefinition", resp, "Failure sending request")
		return
	}

	result.psqr, err = client.ListQueryResultsForPolicySetDefinitionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "ListQueryResultsForPolicySetDefinition", resp, "Failure responding to request")
		return
	}
	if result.psqr.hasNextLink() && result.psqr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListQueryResultsForPolicySetDefinitionPreparer prepares the ListQueryResultsForPolicySetDefinition request.
func (client PolicyStatesClient) ListQueryResultsForPolicySetDefinitionPreparer(ctx context.Context, policyStatesResource PolicyStatesResource, subscriptionID string, policySetDefinitionName string, top *int32, orderBy string, selectParameter string, from *date.Time, toParameter *date.Time, filter string, apply string, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"authorizationNamespace":  autorest.Encode("path", "Microsoft.Authorization"),
		"policySetDefinitionName": autorest.Encode("path", policySetDefinitionName),
		"policyStatesResource":    autorest.Encode("path", policyStatesResource),
		"subscriptionId":          autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2019-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(orderBy) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderBy)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if from != nil {
		queryParameters["$from"] = autorest.Encode("query", *from)
	}
	if toParameter != nil {
		queryParameters["$to"] = autorest.Encode("query", *toParameter)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(apply) > 0 {
		queryParameters["$apply"] = autorest.Encode("query", apply)
	}
	if len(skipToken) > 0 {
		queryParameters["$skiptoken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policySetDefinitions/{policySetDefinitionName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListQueryResultsForPolicySetDefinitionSender sends the ListQueryResultsForPolicySetDefinition request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyStatesClient) ListQueryResultsForPolicySetDefinitionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListQueryResultsForPolicySetDefinitionResponder handles the response to the ListQueryResultsForPolicySetDefinition request. The method always
// closes the http.Response Body.
func (client PolicyStatesClient) ListQueryResultsForPolicySetDefinitionResponder(resp *http.Response) (result PolicyStatesQueryResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listQueryResultsForPolicySetDefinitionNextResults retrieves the next set of results, if any.
func (client PolicyStatesClient) listQueryResultsForPolicySetDefinitionNextResults(ctx context.Context, lastResults PolicyStatesQueryResults) (result PolicyStatesQueryResults, err error) {
	req, err := lastResults.policyStatesQueryResultsPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "listQueryResultsForPolicySetDefinitionNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListQueryResultsForPolicySetDefinitionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "listQueryResultsForPolicySetDefinitionNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListQueryResultsForPolicySetDefinitionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "listQueryResultsForPolicySetDefinitionNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListQueryResultsForPolicySetDefinitionComplete enumerates all values, automatically crossing page boundaries as required.
func (client PolicyStatesClient) ListQueryResultsForPolicySetDefinitionComplete(ctx context.Context, policyStatesResource PolicyStatesResource, subscriptionID string, policySetDefinitionName string, top *int32, orderBy string, selectParameter string, from *date.Time, toParameter *date.Time, filter string, apply string, skipToken string) (result PolicyStatesQueryResultsIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.ListQueryResultsForPolicySetDefinition")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListQueryResultsForPolicySetDefinition(ctx, policyStatesResource, subscriptionID, policySetDefinitionName, top, orderBy, selectParameter, from, toParameter, filter, apply, skipToken)
	return
}

// ListQueryResultsForResource queries policy states for the resource.
// Parameters:
// policyStatesResource - the virtual resource under PolicyStates resource type. In a given time range,
// 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s).
// resourceID - resource ID.
// top - maximum number of records to return.
// orderBy - ordering expression using OData notation. One or more comma-separated column names with an
// optional "desc" (the default) or "asc", e.g. "$orderby=PolicyAssignmentId, ResourceId asc".
// selectParameter - select expression using OData notation. Limits the columns on each record to just those
// requested, e.g. "$select=PolicyAssignmentId, ResourceId".
// from - ISO 8601 formatted timestamp specifying the start time of the interval to query. When not specified,
// the service uses ($to - 1-day).
// toParameter - ISO 8601 formatted timestamp specifying the end time of the interval to query. When not
// specified, the service uses request time.
// filter - oData filter expression.
// apply - oData apply expression for aggregations.
// expand - the $expand query parameter. For example, to expand components use $expand=components
// skipToken - skiptoken is only provided if a previous response returned a partial result as a part of
// nextLink element.
func (client PolicyStatesClient) ListQueryResultsForResource(ctx context.Context, policyStatesResource PolicyStatesResource, resourceID string, top *int32, orderBy string, selectParameter string, from *date.Time, toParameter *date.Time, filter string, apply string, expand string, skipToken string) (result PolicyStatesQueryResultsPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.ListQueryResultsForResource")
		defer func() {
			sc := -1
			if result.psqr.Response.Response != nil {
				sc = result.psqr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.PolicyStatesClient", "ListQueryResultsForResource", err.Error())
	}

	result.fn = client.listQueryResultsForResourceNextResults
	req, err := client.ListQueryResultsForResourcePreparer(ctx, policyStatesResource, resourceID, top, orderBy, selectParameter, from, toParameter, filter, apply, expand, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "ListQueryResultsForResource", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListQueryResultsForResourceSender(req)
	if err != nil {
		result.psqr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "ListQueryResultsForResource", resp, "Failure sending request")
		return
	}

	result.psqr, err = client.ListQueryResultsForResourceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "ListQueryResultsForResource", resp, "Failure responding to request")
		return
	}
	if result.psqr.hasNextLink() && result.psqr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListQueryResultsForResourcePreparer prepares the ListQueryResultsForResource request.
func (client PolicyStatesClient) ListQueryResultsForResourcePreparer(ctx context.Context, policyStatesResource PolicyStatesResource, resourceID string, top *int32, orderBy string, selectParameter string, from *date.Time, toParameter *date.Time, filter string, apply string, expand string, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"policyStatesResource": autorest.Encode("path", policyStatesResource),
		"resourceId":           resourceID,
	}

	const APIVersion = "2019-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(orderBy) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderBy)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if from != nil {
		queryParameters["$from"] = autorest.Encode("query", *from)
	}
	if toParameter != nil {
		queryParameters["$to"] = autorest.Encode("query", *toParameter)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(apply) > 0 {
		queryParameters["$apply"] = autorest.Encode("query", apply)
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if len(skipToken) > 0 {
		queryParameters["$skiptoken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{resourceId}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListQueryResultsForResourceSender sends the ListQueryResultsForResource request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyStatesClient) ListQueryResultsForResourceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListQueryResultsForResourceResponder handles the response to the ListQueryResultsForResource request. The method always
// closes the http.Response Body.
func (client PolicyStatesClient) ListQueryResultsForResourceResponder(resp *http.Response) (result PolicyStatesQueryResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listQueryResultsForResourceNextResults retrieves the next set of results, if any.
func (client PolicyStatesClient) listQueryResultsForResourceNextResults(ctx context.Context, lastResults PolicyStatesQueryResults) (result PolicyStatesQueryResults, err error) {
	req, err := lastResults.policyStatesQueryResultsPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "listQueryResultsForResourceNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListQueryResultsForResourceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "listQueryResultsForResourceNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListQueryResultsForResourceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "listQueryResultsForResourceNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListQueryResultsForResourceComplete enumerates all values, automatically crossing page boundaries as required.
func (client PolicyStatesClient) ListQueryResultsForResourceComplete(ctx context.Context, policyStatesResource PolicyStatesResource, resourceID string, top *int32, orderBy string, selectParameter string, from *date.Time, toParameter *date.Time, filter string, apply string, expand string, skipToken string) (result PolicyStatesQueryResultsIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.ListQueryResultsForResource")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListQueryResultsForResource(ctx, policyStatesResource, resourceID, top, orderBy, selectParameter, from, toParameter, filter, apply, expand, skipToken)
	return
}

// ListQueryResultsForResourceGroup queries policy states for the resources under the resource group.
// Parameters:
// policyStatesResource - the virtual resource under PolicyStates resource type. In a given time range,
// 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s).
// subscriptionID - microsoft Azure subscription ID.
// resourceGroupName - resource group name.
// top - maximum number of records to return.
// orderBy - ordering expression using OData notation. One or more comma-separated column names with an
// optional "desc" (the default) or "asc", e.g. "$orderby=PolicyAssignmentId, ResourceId asc".
// selectParameter - select expression using OData notation. Limits the columns on each record to just those
// requested, e.g. "$select=PolicyAssignmentId, ResourceId".
// from - ISO 8601 formatted timestamp specifying the start time of the interval to query. When not specified,
// the service uses ($to - 1-day).
// toParameter - ISO 8601 formatted timestamp specifying the end time of the interval to query. When not
// specified, the service uses request time.
// filter - oData filter expression.
// apply - oData apply expression for aggregations.
// skipToken - skiptoken is only provided if a previous response returned a partial result as a part of
// nextLink element.
func (client PolicyStatesClient) ListQueryResultsForResourceGroup(ctx context.Context, policyStatesResource PolicyStatesResource, subscriptionID string, resourceGroupName string, top *int32, orderBy string, selectParameter string, from *date.Time, toParameter *date.Time, filter string, apply string, skipToken string) (result PolicyStatesQueryResultsPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.ListQueryResultsForResourceGroup")
		defer func() {
			sc := -1
			if result.psqr.Response.Response != nil {
				sc = result.psqr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.PolicyStatesClient", "ListQueryResultsForResourceGroup", err.Error())
	}

	result.fn = client.listQueryResultsForResourceGroupNextResults
	req, err := client.ListQueryResultsForResourceGroupPreparer(ctx, policyStatesResource, subscriptionID, resourceGroupName, top, orderBy, selectParameter, from, toParameter, filter, apply, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "ListQueryResultsForResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListQueryResultsForResourceGroupSender(req)
	if err != nil {
		result.psqr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "ListQueryResultsForResourceGroup", resp, "Failure sending request")
		return
	}

	result.psqr, err = client.ListQueryResultsForResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "ListQueryResultsForResourceGroup", resp, "Failure responding to request")
		return
	}
	if result.psqr.hasNextLink() && result.psqr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListQueryResultsForResourceGroupPreparer prepares the ListQueryResultsForResourceGroup request.
func (client PolicyStatesClient) ListQueryResultsForResourceGroupPreparer(ctx context.Context, policyStatesResource PolicyStatesResource, subscriptionID string, resourceGroupName string, top *int32, orderBy string, selectParameter string, from *date.Time, toParameter *date.Time, filter string, apply string, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"policyStatesResource": autorest.Encode("path", policyStatesResource),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2019-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(orderBy) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderBy)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if from != nil {
		queryParameters["$from"] = autorest.Encode("query", *from)
	}
	if toParameter != nil {
		queryParameters["$to"] = autorest.Encode("query", *toParameter)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(apply) > 0 {
		queryParameters["$apply"] = autorest.Encode("query", apply)
	}
	if len(skipToken) > 0 {
		queryParameters["$skiptoken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListQueryResultsForResourceGroupSender sends the ListQueryResultsForResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyStatesClient) ListQueryResultsForResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListQueryResultsForResourceGroupResponder handles the response to the ListQueryResultsForResourceGroup request. The method always
// closes the http.Response Body.
func (client PolicyStatesClient) ListQueryResultsForResourceGroupResponder(resp *http.Response) (result PolicyStatesQueryResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listQueryResultsForResourceGroupNextResults retrieves the next set of results, if any.
func (client PolicyStatesClient) listQueryResultsForResourceGroupNextResults(ctx context.Context, lastResults PolicyStatesQueryResults) (result PolicyStatesQueryResults, err error) {
	req, err := lastResults.policyStatesQueryResultsPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "listQueryResultsForResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListQueryResultsForResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "listQueryResultsForResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListQueryResultsForResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "listQueryResultsForResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListQueryResultsForResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client PolicyStatesClient) ListQueryResultsForResourceGroupComplete(ctx context.Context, policyStatesResource PolicyStatesResource, subscriptionID string, resourceGroupName string, top *int32, orderBy string, selectParameter string, from *date.Time, toParameter *date.Time, filter string, apply string, skipToken string) (result PolicyStatesQueryResultsIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.ListQueryResultsForResourceGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListQueryResultsForResourceGroup(ctx, policyStatesResource, subscriptionID, resourceGroupName, top, orderBy, selectParameter, from, toParameter, filter, apply, skipToken)
	return
}

// ListQueryResultsForResourceGroupLevelPolicyAssignment queries policy states for the resource group level policy
// assignment.
// Parameters:
// policyStatesResource - the virtual resource under PolicyStates resource type. In a given time range,
// 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s).
// subscriptionID - microsoft Azure subscription ID.
// resourceGroupName - resource group name.
// policyAssignmentName - policy assignment name.
// top - maximum number of records to return.
// orderBy - ordering expression using OData notation. One or more comma-separated column names with an
// optional "desc" (the default) or "asc", e.g. "$orderby=PolicyAssignmentId, ResourceId asc".
// selectParameter - select expression using OData notation. Limits the columns on each record to just those
// requested, e.g. "$select=PolicyAssignmentId, ResourceId".
// from - ISO 8601 formatted timestamp specifying the start time of the interval to query. When not specified,
// the service uses ($to - 1-day).
// toParameter - ISO 8601 formatted timestamp specifying the end time of the interval to query. When not
// specified, the service uses request time.
// filter - oData filter expression.
// apply - oData apply expression for aggregations.
// skipToken - skiptoken is only provided if a previous response returned a partial result as a part of
// nextLink element.
func (client PolicyStatesClient) ListQueryResultsForResourceGroupLevelPolicyAssignment(ctx context.Context, policyStatesResource PolicyStatesResource, subscriptionID string, resourceGroupName string, policyAssignmentName string, top *int32, orderBy string, selectParameter string, from *date.Time, toParameter *date.Time, filter string, apply string, skipToken string) (result PolicyStatesQueryResultsPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.ListQueryResultsForResourceGroupLevelPolicyAssignment")
		defer func() {
			sc := -1
			if result.psqr.Response.Response != nil {
				sc = result.psqr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.PolicyStatesClient", "ListQueryResultsForResourceGroupLevelPolicyAssignment", err.Error())
	}

	result.fn = client.listQueryResultsForResourceGroupLevelPolicyAssignmentNextResults
	req, err := client.ListQueryResultsForResourceGroupLevelPolicyAssignmentPreparer(ctx, policyStatesResource, subscriptionID, resourceGroupName, policyAssignmentName, top, orderBy, selectParameter, from, toParameter, filter, apply, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "ListQueryResultsForResourceGroupLevelPolicyAssignment", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListQueryResultsForResourceGroupLevelPolicyAssignmentSender(req)
	if err != nil {
		result.psqr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "ListQueryResultsForResourceGroupLevelPolicyAssignment", resp, "Failure sending request")
		return
	}

	result.psqr, err = client.ListQueryResultsForResourceGroupLevelPolicyAssignmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "ListQueryResultsForResourceGroupLevelPolicyAssignment", resp, "Failure responding to request")
		return
	}
	if result.psqr.hasNextLink() && result.psqr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListQueryResultsForResourceGroupLevelPolicyAssignmentPreparer prepares the ListQueryResultsForResourceGroupLevelPolicyAssignment request.
func (client PolicyStatesClient) ListQueryResultsForResourceGroupLevelPolicyAssignmentPreparer(ctx context.Context, policyStatesResource PolicyStatesResource, subscriptionID string, resourceGroupName string, policyAssignmentName string, top *int32, orderBy string, selectParameter string, from *date.Time, toParameter *date.Time, filter string, apply string, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"authorizationNamespace": autorest.Encode("path", "Microsoft.Authorization"),
		"policyAssignmentName":   autorest.Encode("path", policyAssignmentName),
		"policyStatesResource":   autorest.Encode("path", policyStatesResource),
		"resourceGroupName":      autorest.Encode("path", resourceGroupName),
		"subscriptionId":         autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2019-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(orderBy) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderBy)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if from != nil {
		queryParameters["$from"] = autorest.Encode("query", *from)
	}
	if toParameter != nil {
		queryParameters["$to"] = autorest.Encode("query", *toParameter)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(apply) > 0 {
		queryParameters["$apply"] = autorest.Encode("query", apply)
	}
	if len(skipToken) > 0 {
		queryParameters["$skiptoken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListQueryResultsForResourceGroupLevelPolicyAssignmentSender sends the ListQueryResultsForResourceGroupLevelPolicyAssignment request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyStatesClient) ListQueryResultsForResourceGroupLevelPolicyAssignmentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListQueryResultsForResourceGroupLevelPolicyAssignmentResponder handles the response to the ListQueryResultsForResourceGroupLevelPolicyAssignment request. The method always
// closes the http.Response Body.
func (client PolicyStatesClient) ListQueryResultsForResourceGroupLevelPolicyAssignmentResponder(resp *http.Response) (result PolicyStatesQueryResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listQueryResultsForResourceGroupLevelPolicyAssignmentNextResults retrieves the next set of results, if any.
func (client PolicyStatesClient) listQueryResultsForResourceGroupLevelPolicyAssignmentNextResults(ctx context.Context, lastResults PolicyStatesQueryResults) (result PolicyStatesQueryResults, err error) {
	req, err := lastResults.policyStatesQueryResultsPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "listQueryResultsForResourceGroupLevelPolicyAssignmentNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListQueryResultsForResourceGroupLevelPolicyAssignmentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "listQueryResultsForResourceGroupLevelPolicyAssignmentNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListQueryResultsForResourceGroupLevelPolicyAssignmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "listQueryResultsForResourceGroupLevelPolicyAssignmentNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListQueryResultsForResourceGroupLevelPolicyAssignmentComplete enumerates all values, automatically crossing page boundaries as required.
func (client PolicyStatesClient) ListQueryResultsForResourceGroupLevelPolicyAssignmentComplete(ctx context.Context, policyStatesResource PolicyStatesResource, subscriptionID string, resourceGroupName string, policyAssignmentName string, top *int32, orderBy string, selectParameter string, from *date.Time, toParameter *date.Time, filter string, apply string, skipToken string) (result PolicyStatesQueryResultsIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.ListQueryResultsForResourceGroupLevelPolicyAssignment")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListQueryResultsForResourceGroupLevelPolicyAssignment(ctx, policyStatesResource, subscriptionID, resourceGroupName, policyAssignmentName, top, orderBy, selectParameter, from, toParameter, filter, apply, skipToken)
	return
}

// ListQueryResultsForSubscription queries policy states for the resources under the subscription.
// Parameters:
// policyStatesResource - the virtual resource under PolicyStates resource type. In a given time range,
// 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s).
// subscriptionID - microsoft Azure subscription ID.
// top - maximum number of records to return.
// orderBy - ordering expression using OData notation. One or more comma-separated column names with an
// optional "desc" (the default) or "asc", e.g. "$orderby=PolicyAssignmentId, ResourceId asc".
// selectParameter - select expression using OData notation. Limits the columns on each record to just those
// requested, e.g. "$select=PolicyAssignmentId, ResourceId".
// from - ISO 8601 formatted timestamp specifying the start time of the interval to query. When not specified,
// the service uses ($to - 1-day).
// toParameter - ISO 8601 formatted timestamp specifying the end time of the interval to query. When not
// specified, the service uses request time.
// filter - oData filter expression.
// apply - oData apply expression for aggregations.
// skipToken - skiptoken is only provided if a previous response returned a partial result as a part of
// nextLink element.
func (client PolicyStatesClient) ListQueryResultsForSubscription(ctx context.Context, policyStatesResource PolicyStatesResource, subscriptionID string, top *int32, orderBy string, selectParameter string, from *date.Time, toParameter *date.Time, filter string, apply string, skipToken string) (result PolicyStatesQueryResultsPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.ListQueryResultsForSubscription")
		defer func() {
			sc := -1
			if result.psqr.Response.Response != nil {
				sc = result.psqr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.PolicyStatesClient", "ListQueryResultsForSubscription", err.Error())
	}

	result.fn = client.listQueryResultsForSubscriptionNextResults
	req, err := client.ListQueryResultsForSubscriptionPreparer(ctx, policyStatesResource, subscriptionID, top, orderBy, selectParameter, from, toParameter, filter, apply, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "ListQueryResultsForSubscription", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListQueryResultsForSubscriptionSender(req)
	if err != nil {
		result.psqr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "ListQueryResultsForSubscription", resp, "Failure sending request")
		return
	}

	result.psqr, err = client.ListQueryResultsForSubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "ListQueryResultsForSubscription", resp, "Failure responding to request")
		return
	}
	if result.psqr.hasNextLink() && result.psqr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListQueryResultsForSubscriptionPreparer prepares the ListQueryResultsForSubscription request.
func (client PolicyStatesClient) ListQueryResultsForSubscriptionPreparer(ctx context.Context, policyStatesResource PolicyStatesResource, subscriptionID string, top *int32, orderBy string, selectParameter string, from *date.Time, toParameter *date.Time, filter string, apply string, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"policyStatesResource": autorest.Encode("path", policyStatesResource),
		"subscriptionId":       autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2019-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(orderBy) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderBy)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if from != nil {
		queryParameters["$from"] = autorest.Encode("query", *from)
	}
	if toParameter != nil {
		queryParameters["$to"] = autorest.Encode("query", *toParameter)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(apply) > 0 {
		queryParameters["$apply"] = autorest.Encode("query", apply)
	}
	if len(skipToken) > 0 {
		queryParameters["$skiptoken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListQueryResultsForSubscriptionSender sends the ListQueryResultsForSubscription request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyStatesClient) ListQueryResultsForSubscriptionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListQueryResultsForSubscriptionResponder handles the response to the ListQueryResultsForSubscription request. The method always
// closes the http.Response Body.
func (client PolicyStatesClient) ListQueryResultsForSubscriptionResponder(resp *http.Response) (result PolicyStatesQueryResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listQueryResultsForSubscriptionNextResults retrieves the next set of results, if any.
func (client PolicyStatesClient) listQueryResultsForSubscriptionNextResults(ctx context.Context, lastResults PolicyStatesQueryResults) (result PolicyStatesQueryResults, err error) {
	req, err := lastResults.policyStatesQueryResultsPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "listQueryResultsForSubscriptionNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListQueryResultsForSubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "listQueryResultsForSubscriptionNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListQueryResultsForSubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "listQueryResultsForSubscriptionNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListQueryResultsForSubscriptionComplete enumerates all values, automatically crossing page boundaries as required.
func (client PolicyStatesClient) ListQueryResultsForSubscriptionComplete(ctx context.Context, policyStatesResource PolicyStatesResource, subscriptionID string, top *int32, orderBy string, selectParameter string, from *date.Time, toParameter *date.Time, filter string, apply string, skipToken string) (result PolicyStatesQueryResultsIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.ListQueryResultsForSubscription")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListQueryResultsForSubscription(ctx, policyStatesResource, subscriptionID, top, orderBy, selectParameter, from, toParameter, filter, apply, skipToken)
	return
}

// ListQueryResultsForSubscriptionLevelPolicyAssignment queries policy states for the subscription level policy
// assignment.
// Parameters:
// policyStatesResource - the virtual resource under PolicyStates resource type. In a given time range,
// 'latest' represents the latest policy state(s), whereas 'default' represents all policy state(s).
// subscriptionID - microsoft Azure subscription ID.
// policyAssignmentName - policy assignment name.
// top - maximum number of records to return.
// orderBy - ordering expression using OData notation. One or more comma-separated column names with an
// optional "desc" (the default) or "asc", e.g. "$orderby=PolicyAssignmentId, ResourceId asc".
// selectParameter - select expression using OData notation. Limits the columns on each record to just those
// requested, e.g. "$select=PolicyAssignmentId, ResourceId".
// from - ISO 8601 formatted timestamp specifying the start time of the interval to query. When not specified,
// the service uses ($to - 1-day).
// toParameter - ISO 8601 formatted timestamp specifying the end time of the interval to query. When not
// specified, the service uses request time.
// filter - oData filter expression.
// apply - oData apply expression for aggregations.
// skipToken - skiptoken is only provided if a previous response returned a partial result as a part of
// nextLink element.
func (client PolicyStatesClient) ListQueryResultsForSubscriptionLevelPolicyAssignment(ctx context.Context, policyStatesResource PolicyStatesResource, subscriptionID string, policyAssignmentName string, top *int32, orderBy string, selectParameter string, from *date.Time, toParameter *date.Time, filter string, apply string, skipToken string) (result PolicyStatesQueryResultsPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.ListQueryResultsForSubscriptionLevelPolicyAssignment")
		defer func() {
			sc := -1
			if result.psqr.Response.Response != nil {
				sc = result.psqr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.PolicyStatesClient", "ListQueryResultsForSubscriptionLevelPolicyAssignment", err.Error())
	}

	result.fn = client.listQueryResultsForSubscriptionLevelPolicyAssignmentNextResults
	req, err := client.ListQueryResultsForSubscriptionLevelPolicyAssignmentPreparer(ctx, policyStatesResource, subscriptionID, policyAssignmentName, top, orderBy, selectParameter, from, toParameter, filter, apply, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "ListQueryResultsForSubscriptionLevelPolicyAssignment", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListQueryResultsForSubscriptionLevelPolicyAssignmentSender(req)
	if err != nil {
		result.psqr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "ListQueryResultsForSubscriptionLevelPolicyAssignment", resp, "Failure sending request")
		return
	}

	result.psqr, err = client.ListQueryResultsForSubscriptionLevelPolicyAssignmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "ListQueryResultsForSubscriptionLevelPolicyAssignment", resp, "Failure responding to request")
		return
	}
	if result.psqr.hasNextLink() && result.psqr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListQueryResultsForSubscriptionLevelPolicyAssignmentPreparer prepares the ListQueryResultsForSubscriptionLevelPolicyAssignment request.
func (client PolicyStatesClient) ListQueryResultsForSubscriptionLevelPolicyAssignmentPreparer(ctx context.Context, policyStatesResource PolicyStatesResource, subscriptionID string, policyAssignmentName string, top *int32, orderBy string, selectParameter string, from *date.Time, toParameter *date.Time, filter string, apply string, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"authorizationNamespace": autorest.Encode("path", "Microsoft.Authorization"),
		"policyAssignmentName":   autorest.Encode("path", policyAssignmentName),
		"policyStatesResource":   autorest.Encode("path", policyStatesResource),
		"subscriptionId":         autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2019-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(orderBy) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderBy)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if from != nil {
		queryParameters["$from"] = autorest.Encode("query", *from)
	}
	if toParameter != nil {
		queryParameters["$to"] = autorest.Encode("query", *toParameter)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(apply) > 0 {
		queryParameters["$apply"] = autorest.Encode("query", apply)
	}
	if len(skipToken) > 0 {
		queryParameters["$skiptoken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListQueryResultsForSubscriptionLevelPolicyAssignmentSender sends the ListQueryResultsForSubscriptionLevelPolicyAssignment request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyStatesClient) ListQueryResultsForSubscriptionLevelPolicyAssignmentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListQueryResultsForSubscriptionLevelPolicyAssignmentResponder handles the response to the ListQueryResultsForSubscriptionLevelPolicyAssignment request. The method always
// closes the http.Response Body.
func (client PolicyStatesClient) ListQueryResultsForSubscriptionLevelPolicyAssignmentResponder(resp *http.Response) (result PolicyStatesQueryResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listQueryResultsForSubscriptionLevelPolicyAssignmentNextResults retrieves the next set of results, if any.
func (client PolicyStatesClient) listQueryResultsForSubscriptionLevelPolicyAssignmentNextResults(ctx context.Context, lastResults PolicyStatesQueryResults) (result PolicyStatesQueryResults, err error) {
	req, err := lastResults.policyStatesQueryResultsPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "listQueryResultsForSubscriptionLevelPolicyAssignmentNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListQueryResultsForSubscriptionLevelPolicyAssignmentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "listQueryResultsForSubscriptionLevelPolicyAssignmentNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListQueryResultsForSubscriptionLevelPolicyAssignmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "listQueryResultsForSubscriptionLevelPolicyAssignmentNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListQueryResultsForSubscriptionLevelPolicyAssignmentComplete enumerates all values, automatically crossing page boundaries as required.
func (client PolicyStatesClient) ListQueryResultsForSubscriptionLevelPolicyAssignmentComplete(ctx context.Context, policyStatesResource PolicyStatesResource, subscriptionID string, policyAssignmentName string, top *int32, orderBy string, selectParameter string, from *date.Time, toParameter *date.Time, filter string, apply string, skipToken string) (result PolicyStatesQueryResultsIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.ListQueryResultsForSubscriptionLevelPolicyAssignment")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListQueryResultsForSubscriptionLevelPolicyAssignment(ctx, policyStatesResource, subscriptionID, policyAssignmentName, top, orderBy, selectParameter, from, toParameter, filter, apply, skipToken)
	return
}

// SummarizeForManagementGroup summarizes policy states for the resources under the management group.
// Parameters:
// managementGroupName - management group name.
// top - maximum number of records to return.
// from - ISO 8601 formatted timestamp specifying the start time of the interval to query. When not specified,
// the service uses ($to - 1-day).
// toParameter - ISO 8601 formatted timestamp specifying the end time of the interval to query. When not
// specified, the service uses request time.
// filter - oData filter expression.
func (client PolicyStatesClient) SummarizeForManagementGroup(ctx context.Context, managementGroupName string, top *int32, from *date.Time, toParameter *date.Time, filter string) (result SummarizeResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.SummarizeForManagementGroup")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.PolicyStatesClient", "SummarizeForManagementGroup", err.Error())
	}

	req, err := client.SummarizeForManagementGroupPreparer(ctx, managementGroupName, top, from, toParameter, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "SummarizeForManagementGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.SummarizeForManagementGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "SummarizeForManagementGroup", resp, "Failure sending request")
		return
	}

	result, err = client.SummarizeForManagementGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "SummarizeForManagementGroup", resp, "Failure responding to request")
		return
	}

	return
}

// SummarizeForManagementGroupPreparer prepares the SummarizeForManagementGroup request.
func (client PolicyStatesClient) SummarizeForManagementGroupPreparer(ctx context.Context, managementGroupName string, top *int32, from *date.Time, toParameter *date.Time, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managementGroupName":         autorest.Encode("path", managementGroupName),
		"managementGroupsNamespace":   autorest.Encode("path", "Microsoft.Management"),
		"policyStatesSummaryResource": autorest.Encode("path", "latest"),
	}

	const APIVersion = "2019-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if from != nil {
		queryParameters["$from"] = autorest.Encode("query", *from)
	}
	if toParameter != nil {
		queryParameters["$to"] = autorest.Encode("query", *toParameter)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/{managementGroupsNamespace}/managementGroups/{managementGroupName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SummarizeForManagementGroupSender sends the SummarizeForManagementGroup request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyStatesClient) SummarizeForManagementGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// SummarizeForManagementGroupResponder handles the response to the SummarizeForManagementGroup request. The method always
// closes the http.Response Body.
func (client PolicyStatesClient) SummarizeForManagementGroupResponder(resp *http.Response) (result SummarizeResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SummarizeForPolicyDefinition summarizes policy states for the subscription level policy definition.
// Parameters:
// subscriptionID - microsoft Azure subscription ID.
// policyDefinitionName - policy definition name.
// top - maximum number of records to return.
// from - ISO 8601 formatted timestamp specifying the start time of the interval to query. When not specified,
// the service uses ($to - 1-day).
// toParameter - ISO 8601 formatted timestamp specifying the end time of the interval to query. When not
// specified, the service uses request time.
// filter - oData filter expression.
func (client PolicyStatesClient) SummarizeForPolicyDefinition(ctx context.Context, subscriptionID string, policyDefinitionName string, top *int32, from *date.Time, toParameter *date.Time, filter string) (result SummarizeResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.SummarizeForPolicyDefinition")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.PolicyStatesClient", "SummarizeForPolicyDefinition", err.Error())
	}

	req, err := client.SummarizeForPolicyDefinitionPreparer(ctx, subscriptionID, policyDefinitionName, top, from, toParameter, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "SummarizeForPolicyDefinition", nil, "Failure preparing request")
		return
	}

	resp, err := client.SummarizeForPolicyDefinitionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "SummarizeForPolicyDefinition", resp, "Failure sending request")
		return
	}

	result, err = client.SummarizeForPolicyDefinitionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "SummarizeForPolicyDefinition", resp, "Failure responding to request")
		return
	}

	return
}

// SummarizeForPolicyDefinitionPreparer prepares the SummarizeForPolicyDefinition request.
func (client PolicyStatesClient) SummarizeForPolicyDefinitionPreparer(ctx context.Context, subscriptionID string, policyDefinitionName string, top *int32, from *date.Time, toParameter *date.Time, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"authorizationNamespace":      autorest.Encode("path", "Microsoft.Authorization"),
		"policyDefinitionName":        autorest.Encode("path", policyDefinitionName),
		"policyStatesSummaryResource": autorest.Encode("path", "latest"),
		"subscriptionId":              autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2019-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if from != nil {
		queryParameters["$from"] = autorest.Encode("query", *from)
	}
	if toParameter != nil {
		queryParameters["$to"] = autorest.Encode("query", *toParameter)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyDefinitions/{policyDefinitionName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SummarizeForPolicyDefinitionSender sends the SummarizeForPolicyDefinition request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyStatesClient) SummarizeForPolicyDefinitionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// SummarizeForPolicyDefinitionResponder handles the response to the SummarizeForPolicyDefinition request. The method always
// closes the http.Response Body.
func (client PolicyStatesClient) SummarizeForPolicyDefinitionResponder(resp *http.Response) (result SummarizeResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SummarizeForPolicySetDefinition summarizes policy states for the subscription level policy set definition.
// Parameters:
// subscriptionID - microsoft Azure subscription ID.
// policySetDefinitionName - policy set definition name.
// top - maximum number of records to return.
// from - ISO 8601 formatted timestamp specifying the start time of the interval to query. When not specified,
// the service uses ($to - 1-day).
// toParameter - ISO 8601 formatted timestamp specifying the end time of the interval to query. When not
// specified, the service uses request time.
// filter - oData filter expression.
func (client PolicyStatesClient) SummarizeForPolicySetDefinition(ctx context.Context, subscriptionID string, policySetDefinitionName string, top *int32, from *date.Time, toParameter *date.Time, filter string) (result SummarizeResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.SummarizeForPolicySetDefinition")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.PolicyStatesClient", "SummarizeForPolicySetDefinition", err.Error())
	}

	req, err := client.SummarizeForPolicySetDefinitionPreparer(ctx, subscriptionID, policySetDefinitionName, top, from, toParameter, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "SummarizeForPolicySetDefinition", nil, "Failure preparing request")
		return
	}

	resp, err := client.SummarizeForPolicySetDefinitionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "SummarizeForPolicySetDefinition", resp, "Failure sending request")
		return
	}

	result, err = client.SummarizeForPolicySetDefinitionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "SummarizeForPolicySetDefinition", resp, "Failure responding to request")
		return
	}

	return
}

// SummarizeForPolicySetDefinitionPreparer prepares the SummarizeForPolicySetDefinition request.
func (client PolicyStatesClient) SummarizeForPolicySetDefinitionPreparer(ctx context.Context, subscriptionID string, policySetDefinitionName string, top *int32, from *date.Time, toParameter *date.Time, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"authorizationNamespace":      autorest.Encode("path", "Microsoft.Authorization"),
		"policySetDefinitionName":     autorest.Encode("path", policySetDefinitionName),
		"policyStatesSummaryResource": autorest.Encode("path", "latest"),
		"subscriptionId":              autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2019-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if from != nil {
		queryParameters["$from"] = autorest.Encode("query", *from)
	}
	if toParameter != nil {
		queryParameters["$to"] = autorest.Encode("query", *toParameter)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policySetDefinitions/{policySetDefinitionName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SummarizeForPolicySetDefinitionSender sends the SummarizeForPolicySetDefinition request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyStatesClient) SummarizeForPolicySetDefinitionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// SummarizeForPolicySetDefinitionResponder handles the response to the SummarizeForPolicySetDefinition request. The method always
// closes the http.Response Body.
func (client PolicyStatesClient) SummarizeForPolicySetDefinitionResponder(resp *http.Response) (result SummarizeResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SummarizeForResource summarizes policy states for the resource.
// Parameters:
// resourceID - resource ID.
// top - maximum number of records to return.
// from - ISO 8601 formatted timestamp specifying the start time of the interval to query. When not specified,
// the service uses ($to - 1-day).
// toParameter - ISO 8601 formatted timestamp specifying the end time of the interval to query. When not
// specified, the service uses request time.
// filter - oData filter expression.
func (client PolicyStatesClient) SummarizeForResource(ctx context.Context, resourceID string, top *int32, from *date.Time, toParameter *date.Time, filter string) (result SummarizeResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.SummarizeForResource")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.PolicyStatesClient", "SummarizeForResource", err.Error())
	}

	req, err := client.SummarizeForResourcePreparer(ctx, resourceID, top, from, toParameter, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "SummarizeForResource", nil, "Failure preparing request")
		return
	}

	resp, err := client.SummarizeForResourceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "SummarizeForResource", resp, "Failure sending request")
		return
	}

	result, err = client.SummarizeForResourceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "SummarizeForResource", resp, "Failure responding to request")
		return
	}

	return
}

// SummarizeForResourcePreparer prepares the SummarizeForResource request.
func (client PolicyStatesClient) SummarizeForResourcePreparer(ctx context.Context, resourceID string, top *int32, from *date.Time, toParameter *date.Time, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"policyStatesSummaryResource": autorest.Encode("path", "latest"),
		"resourceId":                  resourceID,
	}

	const APIVersion = "2019-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if from != nil {
		queryParameters["$from"] = autorest.Encode("query", *from)
	}
	if toParameter != nil {
		queryParameters["$to"] = autorest.Encode("query", *toParameter)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{resourceId}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SummarizeForResourceSender sends the SummarizeForResource request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyStatesClient) SummarizeForResourceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// SummarizeForResourceResponder handles the response to the SummarizeForResource request. The method always
// closes the http.Response Body.
func (client PolicyStatesClient) SummarizeForResourceResponder(resp *http.Response) (result SummarizeResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SummarizeForResourceGroup summarizes policy states for the resources under the resource group.
// Parameters:
// subscriptionID - microsoft Azure subscription ID.
// resourceGroupName - resource group name.
// top - maximum number of records to return.
// from - ISO 8601 formatted timestamp specifying the start time of the interval to query. When not specified,
// the service uses ($to - 1-day).
// toParameter - ISO 8601 formatted timestamp specifying the end time of the interval to query. When not
// specified, the service uses request time.
// filter - oData filter expression.
func (client PolicyStatesClient) SummarizeForResourceGroup(ctx context.Context, subscriptionID string, resourceGroupName string, top *int32, from *date.Time, toParameter *date.Time, filter string) (result SummarizeResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.SummarizeForResourceGroup")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.PolicyStatesClient", "SummarizeForResourceGroup", err.Error())
	}

	req, err := client.SummarizeForResourceGroupPreparer(ctx, subscriptionID, resourceGroupName, top, from, toParameter, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "SummarizeForResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.SummarizeForResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "SummarizeForResourceGroup", resp, "Failure sending request")
		return
	}

	result, err = client.SummarizeForResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "SummarizeForResourceGroup", resp, "Failure responding to request")
		return
	}

	return
}

// SummarizeForResourceGroupPreparer prepares the SummarizeForResourceGroup request.
func (client PolicyStatesClient) SummarizeForResourceGroupPreparer(ctx context.Context, subscriptionID string, resourceGroupName string, top *int32, from *date.Time, toParameter *date.Time, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"policyStatesSummaryResource": autorest.Encode("path", "latest"),
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"subscriptionId":              autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2019-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if from != nil {
		queryParameters["$from"] = autorest.Encode("query", *from)
	}
	if toParameter != nil {
		queryParameters["$to"] = autorest.Encode("query", *toParameter)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SummarizeForResourceGroupSender sends the SummarizeForResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyStatesClient) SummarizeForResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// SummarizeForResourceGroupResponder handles the response to the SummarizeForResourceGroup request. The method always
// closes the http.Response Body.
func (client PolicyStatesClient) SummarizeForResourceGroupResponder(resp *http.Response) (result SummarizeResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SummarizeForResourceGroupLevelPolicyAssignment summarizes policy states for the resource group level policy
// assignment.
// Parameters:
// subscriptionID - microsoft Azure subscription ID.
// resourceGroupName - resource group name.
// policyAssignmentName - policy assignment name.
// top - maximum number of records to return.
// from - ISO 8601 formatted timestamp specifying the start time of the interval to query. When not specified,
// the service uses ($to - 1-day).
// toParameter - ISO 8601 formatted timestamp specifying the end time of the interval to query. When not
// specified, the service uses request time.
// filter - oData filter expression.
func (client PolicyStatesClient) SummarizeForResourceGroupLevelPolicyAssignment(ctx context.Context, subscriptionID string, resourceGroupName string, policyAssignmentName string, top *int32, from *date.Time, toParameter *date.Time, filter string) (result SummarizeResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.SummarizeForResourceGroupLevelPolicyAssignment")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.PolicyStatesClient", "SummarizeForResourceGroupLevelPolicyAssignment", err.Error())
	}

	req, err := client.SummarizeForResourceGroupLevelPolicyAssignmentPreparer(ctx, subscriptionID, resourceGroupName, policyAssignmentName, top, from, toParameter, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "SummarizeForResourceGroupLevelPolicyAssignment", nil, "Failure preparing request")
		return
	}

	resp, err := client.SummarizeForResourceGroupLevelPolicyAssignmentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "SummarizeForResourceGroupLevelPolicyAssignment", resp, "Failure sending request")
		return
	}

	result, err = client.SummarizeForResourceGroupLevelPolicyAssignmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "SummarizeForResourceGroupLevelPolicyAssignment", resp, "Failure responding to request")
		return
	}

	return
}

// SummarizeForResourceGroupLevelPolicyAssignmentPreparer prepares the SummarizeForResourceGroupLevelPolicyAssignment request.
func (client PolicyStatesClient) SummarizeForResourceGroupLevelPolicyAssignmentPreparer(ctx context.Context, subscriptionID string, resourceGroupName string, policyAssignmentName string, top *int32, from *date.Time, toParameter *date.Time, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"authorizationNamespace":      autorest.Encode("path", "Microsoft.Authorization"),
		"policyAssignmentName":        autorest.Encode("path", policyAssignmentName),
		"policyStatesSummaryResource": autorest.Encode("path", "latest"),
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"subscriptionId":              autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2019-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if from != nil {
		queryParameters["$from"] = autorest.Encode("query", *from)
	}
	if toParameter != nil {
		queryParameters["$to"] = autorest.Encode("query", *toParameter)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SummarizeForResourceGroupLevelPolicyAssignmentSender sends the SummarizeForResourceGroupLevelPolicyAssignment request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyStatesClient) SummarizeForResourceGroupLevelPolicyAssignmentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// SummarizeForResourceGroupLevelPolicyAssignmentResponder handles the response to the SummarizeForResourceGroupLevelPolicyAssignment request. The method always
// closes the http.Response Body.
func (client PolicyStatesClient) SummarizeForResourceGroupLevelPolicyAssignmentResponder(resp *http.Response) (result SummarizeResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SummarizeForSubscription summarizes policy states for the resources under the subscription.
// Parameters:
// subscriptionID - microsoft Azure subscription ID.
// top - maximum number of records to return.
// from - ISO 8601 formatted timestamp specifying the start time of the interval to query. When not specified,
// the service uses ($to - 1-day).
// toParameter - ISO 8601 formatted timestamp specifying the end time of the interval to query. When not
// specified, the service uses request time.
// filter - oData filter expression.
func (client PolicyStatesClient) SummarizeForSubscription(ctx context.Context, subscriptionID string, top *int32, from *date.Time, toParameter *date.Time, filter string) (result SummarizeResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.SummarizeForSubscription")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.PolicyStatesClient", "SummarizeForSubscription", err.Error())
	}

	req, err := client.SummarizeForSubscriptionPreparer(ctx, subscriptionID, top, from, toParameter, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "SummarizeForSubscription", nil, "Failure preparing request")
		return
	}

	resp, err := client.SummarizeForSubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "SummarizeForSubscription", resp, "Failure sending request")
		return
	}

	result, err = client.SummarizeForSubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "SummarizeForSubscription", resp, "Failure responding to request")
		return
	}

	return
}

// SummarizeForSubscriptionPreparer prepares the SummarizeForSubscription request.
func (client PolicyStatesClient) SummarizeForSubscriptionPreparer(ctx context.Context, subscriptionID string, top *int32, from *date.Time, toParameter *date.Time, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"policyStatesSummaryResource": autorest.Encode("path", "latest"),
		"subscriptionId":              autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2019-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if from != nil {
		queryParameters["$from"] = autorest.Encode("query", *from)
	}
	if toParameter != nil {
		queryParameters["$to"] = autorest.Encode("query", *toParameter)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SummarizeForSubscriptionSender sends the SummarizeForSubscription request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyStatesClient) SummarizeForSubscriptionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// SummarizeForSubscriptionResponder handles the response to the SummarizeForSubscription request. The method always
// closes the http.Response Body.
func (client PolicyStatesClient) SummarizeForSubscriptionResponder(resp *http.Response) (result SummarizeResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SummarizeForSubscriptionLevelPolicyAssignment summarizes policy states for the subscription level policy assignment.
// Parameters:
// subscriptionID - microsoft Azure subscription ID.
// policyAssignmentName - policy assignment name.
// top - maximum number of records to return.
// from - ISO 8601 formatted timestamp specifying the start time of the interval to query. When not specified,
// the service uses ($to - 1-day).
// toParameter - ISO 8601 formatted timestamp specifying the end time of the interval to query. When not
// specified, the service uses request time.
// filter - oData filter expression.
func (client PolicyStatesClient) SummarizeForSubscriptionLevelPolicyAssignment(ctx context.Context, subscriptionID string, policyAssignmentName string, top *int32, from *date.Time, toParameter *date.Time, filter string) (result SummarizeResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.SummarizeForSubscriptionLevelPolicyAssignment")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.PolicyStatesClient", "SummarizeForSubscriptionLevelPolicyAssignment", err.Error())
	}

	req, err := client.SummarizeForSubscriptionLevelPolicyAssignmentPreparer(ctx, subscriptionID, policyAssignmentName, top, from, toParameter, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "SummarizeForSubscriptionLevelPolicyAssignment", nil, "Failure preparing request")
		return
	}

	resp, err := client.SummarizeForSubscriptionLevelPolicyAssignmentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "SummarizeForSubscriptionLevelPolicyAssignment", resp, "Failure sending request")
		return
	}

	result, err = client.SummarizeForSubscriptionLevelPolicyAssignmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "SummarizeForSubscriptionLevelPolicyAssignment", resp, "Failure responding to request")
		return
	}

	return
}

// SummarizeForSubscriptionLevelPolicyAssignmentPreparer prepares the SummarizeForSubscriptionLevelPolicyAssignment request.
func (client PolicyStatesClient) SummarizeForSubscriptionLevelPolicyAssignmentPreparer(ctx context.Context, subscriptionID string, policyAssignmentName string, top *int32, from *date.Time, toParameter *date.Time, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"authorizationNamespace":      autorest.Encode("path", "Microsoft.Authorization"),
		"policyAssignmentName":        autorest.Encode("path", policyAssignmentName),
		"policyStatesSummaryResource": autorest.Encode("path", "latest"),
		"subscriptionId":              autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2019-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if from != nil {
		queryParameters["$from"] = autorest.Encode("query", *from)
	}
	if toParameter != nil {
		queryParameters["$to"] = autorest.Encode("query", *toParameter)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SummarizeForSubscriptionLevelPolicyAssignmentSender sends the SummarizeForSubscriptionLevelPolicyAssignment request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyStatesClient) SummarizeForSubscriptionLevelPolicyAssignmentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// SummarizeForSubscriptionLevelPolicyAssignmentResponder handles the response to the SummarizeForSubscriptionLevelPolicyAssignment request. The method always
// closes the http.Response Body.
func (client PolicyStatesClient) SummarizeForSubscriptionLevelPolicyAssignmentResponder(resp *http.Response) (result SummarizeResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// TriggerResourceGroupEvaluation triggers a policy evaluation scan for all the resources under the resource group.
// Parameters:
// subscriptionID - microsoft Azure subscription ID.
// resourceGroupName - resource group name.
func (client PolicyStatesClient) TriggerResourceGroupEvaluation(ctx context.Context, subscriptionID string, resourceGroupName string) (result PolicyStatesTriggerResourceGroupEvaluationFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.TriggerResourceGroupEvaluation")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.TriggerResourceGroupEvaluationPreparer(ctx, subscriptionID, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "TriggerResourceGroupEvaluation", nil, "Failure preparing request")
		return
	}

	result, err = client.TriggerResourceGroupEvaluationSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "TriggerResourceGroupEvaluation", nil, "Failure sending request")
		return
	}

	return
}

// TriggerResourceGroupEvaluationPreparer prepares the TriggerResourceGroupEvaluation request.
func (client PolicyStatesClient) TriggerResourceGroupEvaluationPreparer(ctx context.Context, subscriptionID string, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2019-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/policyStates/latest/triggerEvaluation", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// TriggerResourceGroupEvaluationSender sends the TriggerResourceGroupEvaluation request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyStatesClient) TriggerResourceGroupEvaluationSender(req *http.Request) (future PolicyStatesTriggerResourceGroupEvaluationFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// TriggerResourceGroupEvaluationResponder handles the response to the TriggerResourceGroupEvaluation request. The method always
// closes the http.Response Body.
func (client PolicyStatesClient) TriggerResourceGroupEvaluationResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// TriggerSubscriptionEvaluation triggers a policy evaluation scan for all the resources under the subscription
// Parameters:
// subscriptionID - microsoft Azure subscription ID.
func (client PolicyStatesClient) TriggerSubscriptionEvaluation(ctx context.Context, subscriptionID string) (result PolicyStatesTriggerSubscriptionEvaluationFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyStatesClient.TriggerSubscriptionEvaluation")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.TriggerSubscriptionEvaluationPreparer(ctx, subscriptionID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "TriggerSubscriptionEvaluation", nil, "Failure preparing request")
		return
	}

	result, err = client.TriggerSubscriptionEvaluationSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyStatesClient", "TriggerSubscriptionEvaluation", nil, "Failure sending request")
		return
	}

	return
}

// TriggerSubscriptionEvaluationPreparer prepares the TriggerSubscriptionEvaluation request.
func (client PolicyStatesClient) TriggerSubscriptionEvaluationPreparer(ctx context.Context, subscriptionID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2019-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/policyStates/latest/triggerEvaluation", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// TriggerSubscriptionEvaluationSender sends the TriggerSubscriptionEvaluation request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyStatesClient) TriggerSubscriptionEvaluationSender(req *http.Request) (future PolicyStatesTriggerSubscriptionEvaluationFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// TriggerSubscriptionEvaluationResponder handles the response to the TriggerSubscriptionEvaluation request. The method always
// closes the http.Response Body.
func (client PolicyStatesClient) TriggerSubscriptionEvaluationResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}
