package io

import (
	"fmt"
	"io"

	"git.sr.ht/~charles/rq/util"
	"github.com/subosito/gotenv"
)

func init() {
	registerOutputHandler("sh", func() OutputHandler { return &ShOutputHandler{} })
	registerOutputHandler("dotenv", func() OutputHandler { return &ShOutputHandler{} })
}

// Declare conformance with OutputHandler interface.
var _ OutputHandler = &ShOutputHandler{}

// ShOutputHandler handles serializing Sh data.
type ShOutputHandler struct {
}

// Name implements OutputHandler.Name().
func (s *ShOutputHandler) Name() string {
	return "sh"
}

// SetOption implements OutputHandler.SetOption().
func (s *ShOutputHandler) SetOption(name string, value string) error {
	return nil
}

// Format implements OutputHandler.Format()
func (s *ShOutputHandler) Format(writer io.Writer, data interface{}) error {
	obj, ok := data.(map[string]interface{})

	if !ok {
		return fmt.Errorf("sh: expected a map[string]string, don't know how to marshal type %T", data)
	}

	env := make(gotenv.Env)
	for k, v := range obj {
		env[k] = util.ValueToString(v)
	}

	str, err := gotenv.Marshal(env)
	if err != nil {
		return err
	}

	_, err = writer.Write([]byte(str))
	if err != nil {
		return err
	}

	return nil
}
