// Copyright 2023-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: buf/registry/module/v1beta1/download_service.proto

package modulev1beta1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type DownloadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The references to get contents for.
	Values []*DownloadRequest_Value `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	// The DigestType to return for the Commits of the references.
	//
	// If this DigestType is not available, an error is returned.
	// Note that certain DigestTypes may be deprecated over time.
	//
	// If not set, the latest DigestType is used, currently B5.
	DigestType DigestType `protobuf:"varint,2,opt,name=digest_type,json=digestType,proto3,enum=buf.registry.module.v1beta1.DigestType" json:"digest_type,omitempty"`
}

func (x *DownloadRequest) Reset() {
	*x = DownloadRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1beta1_download_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DownloadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownloadRequest) ProtoMessage() {}

func (x *DownloadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_download_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownloadRequest.ProtoReflect.Descriptor instead.
func (*DownloadRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1beta1_download_service_proto_rawDescGZIP(), []int{0}
}

func (x *DownloadRequest) GetValues() []*DownloadRequest_Value {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *DownloadRequest) GetDigestType() DigestType {
	if x != nil {
		return x.DigestType
	}
	return DigestType_DIGEST_TYPE_UNSPECIFIED
}

type DownloadResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Contents of the references in the same order as requested.
	Contents []*DownloadResponse_Content `protobuf:"bytes,1,rep,name=contents,proto3" json:"contents,omitempty"`
}

func (x *DownloadResponse) Reset() {
	*x = DownloadResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1beta1_download_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DownloadResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownloadResponse) ProtoMessage() {}

func (x *DownloadResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_download_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownloadResponse.ProtoReflect.Descriptor instead.
func (*DownloadResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1beta1_download_service_proto_rawDescGZIP(), []int{1}
}

func (x *DownloadResponse) GetContents() []*DownloadResponse_Content {
	if x != nil {
		return x.Contents
	}
	return nil
}

// A request for content for a single reference.
type DownloadRequest_Value struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The reference to get content for.
	//
	// See the documentation on ResourceRef for resource resolution details.
	//
	// Once the resource is resolved, the following content is returned:
	//   - If a Module is referenced, the content of the Commit of the default Label is returned.
	//   - If a Label is referenced, the content of the Commit of this Label is returned.
	//   - If a Commit is referenced, the content for this Commit is returned.
	ResourceRef *ResourceRef `protobuf:"bytes,1,opt,name=resource_ref,json=resourceRef,proto3" json:"resource_ref,omitempty"`
	// Specific file types to request.
	//
	// If not set, all file types are returned.
	FileTypes []FileType `protobuf:"varint,2,rep,packed,name=file_types,json=fileTypes,proto3,enum=buf.registry.module.v1beta1.FileType" json:"file_types,omitempty"`
	// Specific file paths to retrieve.
	//
	// May be directories. For example, path "foo/bar" will result in files "foo/bar/baz.proto",
	// "foo/bar/LICENSE" being downloaded.
	//
	// If empty, all file paths for the given reference are retrieved.
	//
	// If no paths match, an empty Files list will be returned, however the call may still
	// be successful if paths_allow_not_exist is set (the dependency list may still be on
	// the response). If a directory "foo/bar" is specified but this directory has no files,
	// this is considered to be a non-match.
	//
	// This field also interacts with file_types - if file_types is set, a path only matches
	// if it is also of the file type, and if there are no matching paths for the given FileTypes,
	// an error is returned unless paths_not_allow_exist is set.
	//
	// The path must be relative, and cannot contain any "." or ".." components
	// The separator "/" must be used.
	Paths []string `protobuf:"bytes,3,rep,name=paths,proto3" json:"paths,omitempty"`
	// Whether to allow file paths not to exist within the given module.
	//
	// For example, one may want to retrieve the file paths "buf.md" and "README.md",
	// but only expect one to actually exist.
	//
	// If false, it is an error to specify non-existent file paths.
	PathsAllowNotExist bool `protobuf:"varint,4,opt,name=paths_allow_not_exist,json=pathsAllowNotExist,proto3" json:"paths_allow_not_exist,omitempty"`
}

func (x *DownloadRequest_Value) Reset() {
	*x = DownloadRequest_Value{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1beta1_download_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DownloadRequest_Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownloadRequest_Value) ProtoMessage() {}

func (x *DownloadRequest_Value) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_download_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownloadRequest_Value.ProtoReflect.Descriptor instead.
func (*DownloadRequest_Value) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1beta1_download_service_proto_rawDescGZIP(), []int{0, 0}
}

func (x *DownloadRequest_Value) GetResourceRef() *ResourceRef {
	if x != nil {
		return x.ResourceRef
	}
	return nil
}

func (x *DownloadRequest_Value) GetFileTypes() []FileType {
	if x != nil {
		return x.FileTypes
	}
	return nil
}

func (x *DownloadRequest_Value) GetPaths() []string {
	if x != nil {
		return x.Paths
	}
	return nil
}

func (x *DownloadRequest_Value) GetPathsAllowNotExist() bool {
	if x != nil {
		return x.PathsAllowNotExist
	}
	return false
}

// Content for a single Commit.
type DownloadResponse_Content struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Commit associated with the Content.
	//
	// The Commit associated with this ID will be present in the commits field.
	//
	// The Commit will use the DigestType specified in the request value.
	Commit *Commit `protobuf:"bytes,1,opt,name=commit,proto3" json:"commit,omitempty"`
	// The Files of the content.
	//
	// This will consist of the .proto files, license files, and documentation files.
	//
	// If no paths match and paths_allow_not_exist is set, this may be empty.
	Files []*File `protobuf:"bytes,2,rep,name=files,proto3" json:"files,omitempty"`
	// The original v1beta1 or v1 buf.yaml file that encapsulated this reference.
	//
	// If the reference was encapsulated by a v2 buf.yaml, this will be a synthesized v1 buf.yaml.
	//
	// This is used in deprecated digest calculations only. None of the structured
	// information within this File conveys further information about the reference.
	V1BufYamlFile *File `protobuf:"bytes,3,opt,name=v1_buf_yaml_file,json=v1BufYamlFile,proto3" json:"v1_buf_yaml_file,omitempty"`
	// The original buf.lock file that encapsulated this reference, if it existed.
	//
	// If the reference was encapsulated by a v2 buf.lock with dependencies, this will be a
	// synthesized v1 buf.lock.
	//
	// This is used in deprecated digest calculations only. None of the structured
	// information within this File conveys further information about the reference.
	//
	// Importantly, this file should *not* used to determine the dependencies of the
	// reference. To determine the dependencies, use the GraphService with the returned
	// Commit.
	V1BufLockFile *File `protobuf:"bytes,4,opt,name=v1_buf_lock_file,json=v1BufLockFile,proto3" json:"v1_buf_lock_file,omitempty"`
}

func (x *DownloadResponse_Content) Reset() {
	*x = DownloadResponse_Content{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1beta1_download_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DownloadResponse_Content) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownloadResponse_Content) ProtoMessage() {}

func (x *DownloadResponse_Content) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_download_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownloadResponse_Content.ProtoReflect.Descriptor instead.
func (*DownloadResponse_Content) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1beta1_download_service_proto_rawDescGZIP(), []int{1, 0}
}

func (x *DownloadResponse_Content) GetCommit() *Commit {
	if x != nil {
		return x.Commit
	}
	return nil
}

func (x *DownloadResponse_Content) GetFiles() []*File {
	if x != nil {
		return x.Files
	}
	return nil
}

func (x *DownloadResponse_Content) GetV1BufYamlFile() *File {
	if x != nil {
		return x.V1BufYamlFile
	}
	return nil
}

func (x *DownloadResponse_Content) GetV1BufLockFile() *File {
	if x != nil {
		return x.V1BufLockFile
	}
	return nil
}

var File_buf_registry_module_v1beta1_download_service_proto protoreflect.FileDescriptor

var file_buf_registry_module_v1beta1_download_service_proto_rawDesc = []byte{
	0x0a, 0x32, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x6f,
	0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x1a, 0x28, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x62, 0x75, 0x66,
	0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x62,
	0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x62, 0x75, 0x66, 0x2f, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x99, 0x04, 0x0a, 0x0f, 0x44, 0x6f, 0x77, 0x6e, 0x6c,
	0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x06, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61,
	0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x0b,
	0xba, 0x48, 0x08, 0x92, 0x01, 0x05, 0x08, 0x01, 0x10, 0xfa, 0x01, 0x52, 0x06, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x12, 0x52, 0x0a, 0x0b, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x08, 0xba, 0x48, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a, 0x64, 0x69, 0x67,
	0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x1a, 0xd8, 0x02, 0x0a, 0x05, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x53, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x65,
	0x66, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65,
	0x66, 0x42, 0x06, 0xba, 0x48, 0x03, 0xc8, 0x01, 0x01, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x12, 0x58, 0x0a, 0x0a, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x12, 0xba, 0x48, 0x0f, 0x92, 0x01, 0x0c, 0x18, 0x01, 0x22, 0x08, 0x82, 0x01, 0x05,
	0x10, 0x01, 0x22, 0x01, 0x00, 0x52, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x12, 0x6d, 0x0a, 0x05, 0x70, 0x61, 0x74, 0x68, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x57, 0xba, 0x48, 0x54, 0x92, 0x01, 0x51, 0x22, 0x4f, 0x72, 0x4d, 0x18, 0x80, 0x20, 0x32, 0x44,
	0x5e, 0x28, 0x5b, 0x5e, 0x2f, 0x2e, 0x5d, 0x5b, 0x5e, 0x2f, 0x5d, 0x3f, 0x7c, 0x5b, 0x5e, 0x2f,
	0x5d, 0x5b, 0x5e, 0x2f, 0x2e, 0x5d, 0x7c, 0x5b, 0x5e, 0x2f, 0x5d, 0x7b, 0x33, 0x2c, 0x7d, 0x29,
	0x28, 0x2f, 0x28, 0x5b, 0x5e, 0x2f, 0x2e, 0x5d, 0x5b, 0x5e, 0x2f, 0x5d, 0x3f, 0x7c, 0x5b, 0x5e,
	0x2f, 0x5d, 0x5b, 0x5e, 0x2f, 0x2e, 0x5d, 0x7c, 0x5b, 0x5e, 0x2f, 0x5d, 0x7b, 0x33, 0x2c, 0x7d,
	0x29, 0x29, 0x2a, 0x24, 0xba, 0x01, 0x01, 0x5c, 0x52, 0x05, 0x70, 0x61, 0x74, 0x68, 0x73, 0x12,
	0x31, 0x0a, 0x15, 0x70, 0x61, 0x74, 0x68, 0x73, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6e,
	0x6f, 0x74, 0x5f, 0x65, 0x78, 0x69, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12,
	0x70, 0x61, 0x74, 0x68, 0x73, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x4e, 0x6f, 0x74, 0x45, 0x78, 0x69,
	0x73, 0x74, 0x22, 0x91, 0x03, 0x0a, 0x10, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x42, 0x08, 0xba, 0x48, 0x05, 0x92, 0x01, 0x02, 0x08, 0x01, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x73, 0x1a, 0x9f, 0x02, 0x0a, 0x07, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x12, 0x43, 0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x42, 0x06, 0xba, 0x48, 0x03, 0xc8, 0x01, 0x01, 0x52, 0x06, 0x63,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x12, 0x37, 0x0a, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x4a,
	0x0a, 0x10, 0x76, 0x31, 0x5f, 0x62, 0x75, 0x66, 0x5f, 0x79, 0x61, 0x6d, 0x6c, 0x5f, 0x66, 0x69,
	0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x0d, 0x76, 0x31, 0x42,
	0x75, 0x66, 0x59, 0x61, 0x6d, 0x6c, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x4a, 0x0a, 0x10, 0x76, 0x31,
	0x5f, 0x62, 0x75, 0x66, 0x5f, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x0d, 0x76, 0x31, 0x42, 0x75, 0x66, 0x4c, 0x6f,
	0x63, 0x6b, 0x46, 0x69, 0x6c, 0x65, 0x32, 0x7f, 0x0a, 0x0f, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f,
	0x61, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x6c, 0x0a, 0x08, 0x44, 0x6f, 0x77,
	0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x2c, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x42, 0x61, 0x5a, 0x5f, 0x62, 0x75, 0x66, 0x2e, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x73, 0x2f, 0x67, 0x6f,
	0x2f, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_buf_registry_module_v1beta1_download_service_proto_rawDescOnce sync.Once
	file_buf_registry_module_v1beta1_download_service_proto_rawDescData = file_buf_registry_module_v1beta1_download_service_proto_rawDesc
)

func file_buf_registry_module_v1beta1_download_service_proto_rawDescGZIP() []byte {
	file_buf_registry_module_v1beta1_download_service_proto_rawDescOnce.Do(func() {
		file_buf_registry_module_v1beta1_download_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_buf_registry_module_v1beta1_download_service_proto_rawDescData)
	})
	return file_buf_registry_module_v1beta1_download_service_proto_rawDescData
}

var file_buf_registry_module_v1beta1_download_service_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_buf_registry_module_v1beta1_download_service_proto_goTypes = []any{
	(*DownloadRequest)(nil),          // 0: buf.registry.module.v1beta1.DownloadRequest
	(*DownloadResponse)(nil),         // 1: buf.registry.module.v1beta1.DownloadResponse
	(*DownloadRequest_Value)(nil),    // 2: buf.registry.module.v1beta1.DownloadRequest.Value
	(*DownloadResponse_Content)(nil), // 3: buf.registry.module.v1beta1.DownloadResponse.Content
	(DigestType)(0),                  // 4: buf.registry.module.v1beta1.DigestType
	(*ResourceRef)(nil),              // 5: buf.registry.module.v1beta1.ResourceRef
	(FileType)(0),                    // 6: buf.registry.module.v1beta1.FileType
	(*Commit)(nil),                   // 7: buf.registry.module.v1beta1.Commit
	(*File)(nil),                     // 8: buf.registry.module.v1beta1.File
}
var file_buf_registry_module_v1beta1_download_service_proto_depIdxs = []int32{
	2,  // 0: buf.registry.module.v1beta1.DownloadRequest.values:type_name -> buf.registry.module.v1beta1.DownloadRequest.Value
	4,  // 1: buf.registry.module.v1beta1.DownloadRequest.digest_type:type_name -> buf.registry.module.v1beta1.DigestType
	3,  // 2: buf.registry.module.v1beta1.DownloadResponse.contents:type_name -> buf.registry.module.v1beta1.DownloadResponse.Content
	5,  // 3: buf.registry.module.v1beta1.DownloadRequest.Value.resource_ref:type_name -> buf.registry.module.v1beta1.ResourceRef
	6,  // 4: buf.registry.module.v1beta1.DownloadRequest.Value.file_types:type_name -> buf.registry.module.v1beta1.FileType
	7,  // 5: buf.registry.module.v1beta1.DownloadResponse.Content.commit:type_name -> buf.registry.module.v1beta1.Commit
	8,  // 6: buf.registry.module.v1beta1.DownloadResponse.Content.files:type_name -> buf.registry.module.v1beta1.File
	8,  // 7: buf.registry.module.v1beta1.DownloadResponse.Content.v1_buf_yaml_file:type_name -> buf.registry.module.v1beta1.File
	8,  // 8: buf.registry.module.v1beta1.DownloadResponse.Content.v1_buf_lock_file:type_name -> buf.registry.module.v1beta1.File
	0,  // 9: buf.registry.module.v1beta1.DownloadService.Download:input_type -> buf.registry.module.v1beta1.DownloadRequest
	1,  // 10: buf.registry.module.v1beta1.DownloadService.Download:output_type -> buf.registry.module.v1beta1.DownloadResponse
	10, // [10:11] is the sub-list for method output_type
	9,  // [9:10] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_buf_registry_module_v1beta1_download_service_proto_init() }
func file_buf_registry_module_v1beta1_download_service_proto_init() {
	if File_buf_registry_module_v1beta1_download_service_proto != nil {
		return
	}
	file_buf_registry_module_v1beta1_commit_proto_init()
	file_buf_registry_module_v1beta1_digest_proto_init()
	file_buf_registry_module_v1beta1_file_proto_init()
	file_buf_registry_module_v1beta1_resource_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_buf_registry_module_v1beta1_download_service_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*DownloadRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1beta1_download_service_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*DownloadResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1beta1_download_service_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*DownloadRequest_Value); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1beta1_download_service_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*DownloadResponse_Content); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_buf_registry_module_v1beta1_download_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_registry_module_v1beta1_download_service_proto_goTypes,
		DependencyIndexes: file_buf_registry_module_v1beta1_download_service_proto_depIdxs,
		MessageInfos:      file_buf_registry_module_v1beta1_download_service_proto_msgTypes,
	}.Build()
	File_buf_registry_module_v1beta1_download_service_proto = out.File
	file_buf_registry_module_v1beta1_download_service_proto_rawDesc = nil
	file_buf_registry_module_v1beta1_download_service_proto_goTypes = nil
	file_buf_registry_module_v1beta1_download_service_proto_depIdxs = nil
}
