// Copyright 2023-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: buf/registry/module/v1/upload_service.proto

package modulev1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type UploadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Contents of all references.
	Contents []*UploadRequest_Content `protobuf:"bytes,1,rep,name=contents,proto3" json:"contents,omitempty"`
	// The dependencies of the references specified by Contents.
	//
	// Dependencies between Contents are implicit and do not need to be specified. The BSR will detect
	// dependencies between Contenta via .proto imports.
	//
	// This will include all transitive dependencies.
	//
	// Commits should be unique by Module, that is no two dep_commit_ids should have the same Module but
	// different Commit IDs.
	DepCommitIds []string `protobuf:"bytes,2,rep,name=dep_commit_ids,json=depCommitIds,proto3" json:"dep_commit_ids,omitempty"`
}

func (x *UploadRequest) Reset() {
	*x = UploadRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1_upload_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadRequest) ProtoMessage() {}

func (x *UploadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_upload_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadRequest.ProtoReflect.Descriptor instead.
func (*UploadRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_upload_service_proto_rawDescGZIP(), []int{0}
}

func (x *UploadRequest) GetContents() []*UploadRequest_Content {
	if x != nil {
		return x.Contents
	}
	return nil
}

func (x *UploadRequest) GetDepCommitIds() []string {
	if x != nil {
		return x.DepCommitIds
	}
	return nil
}

type UploadResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Commits for each reference in the same order as given on the request.
	//
	// A single Commit will be returned for each reference. These Commits may or may not be new.
	// If nothing changed for a given reference, the existing Commit will be returned.
	Commits []*Commit `protobuf:"bytes,1,rep,name=commits,proto3" json:"commits,omitempty"`
}

func (x *UploadResponse) Reset() {
	*x = UploadResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1_upload_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadResponse) ProtoMessage() {}

func (x *UploadResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_upload_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadResponse.ProtoReflect.Descriptor instead.
func (*UploadResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_upload_service_proto_rawDescGZIP(), []int{1}
}

func (x *UploadResponse) GetCommits() []*Commit {
	if x != nil {
		return x.Commits
	}
	return nil
}

// Content to upload for a given reference.
type UploadRequest_Content struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Module of the reference.
	ModuleRef *ModuleRef `protobuf:"bytes,1,opt,name=module_ref,json=moduleRef,proto3" json:"module_ref,omitempty"`
	// The Files of the Content.
	//
	// This will consist of the .proto files, license files, and documentation files.
	Files []*File `protobuf:"bytes,2,rep,name=files,proto3" json:"files,omitempty"`
	// The labels to associate with the Commit for the Content.
	//
	// If an id is set, this id must represent a Label that already exists and is
	// owned by the Module. The Label will point to the newly-created Commits for the References,
	// or will be updated to point to the pre-existing Commit for the Reference.
	//
	// If no labels are referenced, the default Label for the Module is used.
	//
	// If the Labels do not exist, they will be created.
	// If the Labels were archived, they will be unarchived.
	ScopedLabelRefs []*ScopedLabelRef `protobuf:"bytes,3,rep,name=scoped_label_refs,json=scopedLabelRefs,proto3" json:"scoped_label_refs,omitempty"`
	// The URL of the source control commit to associate with the Commit for this Content.
	//
	// BSR users can navigate to this link to find source control information that is relevant to this Commit
	// (e.g. commit description, PR discussion, authors, approvers, etc.).
	SourceControlUrl string `protobuf:"bytes,4,opt,name=source_control_url,json=sourceControlUrl,proto3" json:"source_control_url,omitempty"`
}

func (x *UploadRequest_Content) Reset() {
	*x = UploadRequest_Content{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1_upload_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadRequest_Content) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadRequest_Content) ProtoMessage() {}

func (x *UploadRequest_Content) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_upload_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadRequest_Content.ProtoReflect.Descriptor instead.
func (*UploadRequest_Content) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_upload_service_proto_rawDescGZIP(), []int{0, 0}
}

func (x *UploadRequest_Content) GetModuleRef() *ModuleRef {
	if x != nil {
		return x.ModuleRef
	}
	return nil
}

func (x *UploadRequest_Content) GetFiles() []*File {
	if x != nil {
		return x.Files
	}
	return nil
}

func (x *UploadRequest_Content) GetScopedLabelRefs() []*ScopedLabelRef {
	if x != nil {
		return x.ScopedLabelRefs
	}
	return nil
}

func (x *UploadRequest_Content) GetSourceControlUrl() string {
	if x != nil {
		return x.SourceControlUrl
	}
	return ""
}

var File_buf_registry_module_v1_upload_service_proto protoreflect.FileDescriptor

var file_buf_registry_module_v1_upload_service_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x62,
	0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x23, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x62, 0x75, 0x66, 0x2f,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2f,
	0x76, 0x31, 0x2f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x62,
	0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x23, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x62, 0x75, 0x66, 0x2f, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xbf, 0x03, 0x0a, 0x0d, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x08, 0xba, 0x48, 0x05, 0x92, 0x01, 0x02, 0x08, 0x01,
	0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x33, 0x0a, 0x0e, 0x64, 0x65,
	0x70, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x0d, 0xba, 0x48, 0x0a, 0x92, 0x01, 0x07, 0x22, 0x05, 0x72, 0x03, 0x88, 0x02,
	0x01, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x49, 0x64, 0x73, 0x1a,
	0xa3, 0x02, 0x0a, 0x07, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x48, 0x0a, 0x0a, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52,
	0x65, 0x66, 0x42, 0x06, 0xba, 0x48, 0x03, 0xc8, 0x01, 0x01, 0x52, 0x09, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x52, 0x65, 0x66, 0x12, 0x3c, 0x0a, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69,
	0x6c, 0x65, 0x42, 0x08, 0xba, 0x48, 0x05, 0x92, 0x01, 0x02, 0x08, 0x01, 0x52, 0x05, 0x66, 0x69,
	0x6c, 0x65, 0x73, 0x12, 0x52, 0x0a, 0x11, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x5f, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x5f, 0x72, 0x65, 0x66, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x52, 0x65, 0x66, 0x52, 0x0f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x52, 0x65, 0x66, 0x73, 0x12, 0x3c, 0x0a, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x0e, 0xba, 0x48, 0x0b, 0xd8, 0x01, 0x01, 0x72, 0x06, 0x18, 0xff, 0x01,
	0x88, 0x01, 0x01, 0x52, 0x10, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x55, 0x72, 0x6c, 0x22, 0x54, 0x0a, 0x0e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x42, 0x08, 0xba, 0x48, 0x05, 0x92, 0x01, 0x02,
	0x08, 0x01, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x32, 0x6a, 0x0a, 0x0d, 0x55,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x59, 0x0a, 0x06,
	0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x25, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x42, 0x57, 0x5a, 0x55, 0x62, 0x75, 0x66, 0x2e, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x73, 0x2f, 0x67, 0x6f,
	0x2f, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x3b, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x76, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_buf_registry_module_v1_upload_service_proto_rawDescOnce sync.Once
	file_buf_registry_module_v1_upload_service_proto_rawDescData = file_buf_registry_module_v1_upload_service_proto_rawDesc
)

func file_buf_registry_module_v1_upload_service_proto_rawDescGZIP() []byte {
	file_buf_registry_module_v1_upload_service_proto_rawDescOnce.Do(func() {
		file_buf_registry_module_v1_upload_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_buf_registry_module_v1_upload_service_proto_rawDescData)
	})
	return file_buf_registry_module_v1_upload_service_proto_rawDescData
}

var file_buf_registry_module_v1_upload_service_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_buf_registry_module_v1_upload_service_proto_goTypes = []any{
	(*UploadRequest)(nil),         // 0: buf.registry.module.v1.UploadRequest
	(*UploadResponse)(nil),        // 1: buf.registry.module.v1.UploadResponse
	(*UploadRequest_Content)(nil), // 2: buf.registry.module.v1.UploadRequest.Content
	(*Commit)(nil),                // 3: buf.registry.module.v1.Commit
	(*ModuleRef)(nil),             // 4: buf.registry.module.v1.ModuleRef
	(*File)(nil),                  // 5: buf.registry.module.v1.File
	(*ScopedLabelRef)(nil),        // 6: buf.registry.module.v1.ScopedLabelRef
}
var file_buf_registry_module_v1_upload_service_proto_depIdxs = []int32{
	2, // 0: buf.registry.module.v1.UploadRequest.contents:type_name -> buf.registry.module.v1.UploadRequest.Content
	3, // 1: buf.registry.module.v1.UploadResponse.commits:type_name -> buf.registry.module.v1.Commit
	4, // 2: buf.registry.module.v1.UploadRequest.Content.module_ref:type_name -> buf.registry.module.v1.ModuleRef
	5, // 3: buf.registry.module.v1.UploadRequest.Content.files:type_name -> buf.registry.module.v1.File
	6, // 4: buf.registry.module.v1.UploadRequest.Content.scoped_label_refs:type_name -> buf.registry.module.v1.ScopedLabelRef
	0, // 5: buf.registry.module.v1.UploadService.Upload:input_type -> buf.registry.module.v1.UploadRequest
	1, // 6: buf.registry.module.v1.UploadService.Upload:output_type -> buf.registry.module.v1.UploadResponse
	6, // [6:7] is the sub-list for method output_type
	5, // [5:6] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_buf_registry_module_v1_upload_service_proto_init() }
func file_buf_registry_module_v1_upload_service_proto_init() {
	if File_buf_registry_module_v1_upload_service_proto != nil {
		return
	}
	file_buf_registry_module_v1_commit_proto_init()
	file_buf_registry_module_v1_file_proto_init()
	file_buf_registry_module_v1_label_proto_init()
	file_buf_registry_module_v1_module_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_buf_registry_module_v1_upload_service_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*UploadRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1_upload_service_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*UploadResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1_upload_service_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*UploadRequest_Content); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_buf_registry_module_v1_upload_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_registry_module_v1_upload_service_proto_goTypes,
		DependencyIndexes: file_buf_registry_module_v1_upload_service_proto_depIdxs,
		MessageInfos:      file_buf_registry_module_v1_upload_service_proto_msgTypes,
	}.Build()
	File_buf_registry_module_v1_upload_service_proto = out.File
	file_buf_registry_module_v1_upload_service_proto_rawDesc = nil
	file_buf_registry_module_v1_upload_service_proto_goTypes = nil
	file_buf_registry_module_v1_upload_service_proto_depIdxs = nil
}
