/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.api.zzi;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.internal.zzoo;
import com.google.android.gms.internal.zzor;
import com.google.android.gms.internal.zzos;
import com.google.android.gms.nearby.connection.AppMetadata;
import com.google.android.gms.nearby.connection.Connections;

public final class zzop
extends zzi<zzos> {
    private final long zzaoX = this.hashCode();

    public zzop(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 54, connectionCallbacks, onConnectionFailedListener);
    }

    @Override
    protected String getStartServiceAction() {
        return "com.google.android.gms.nearby.connection.service.START";
    }

    @Override
    protected String getServiceDescriptor() {
        return "com.google.android.gms.nearby.internal.connection.INearbyConnectionService";
    }

    protected zzos zzda(IBinder iBinder) {
        return zzos.zza.zzdc(iBinder);
    }

    public String zzwR() {
        try {
            return ((zzos)this.zznM()).zzQ(this.zzaoX);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public String zzwS() {
        try {
            return ((zzos)this.zznM()).zzwS();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void zza(zza.zzb<Connections.StartAdvertisingResult> zzb2, String string2, AppMetadata appMetadata, long l, com.google.android.gms.common.api.zzi<Connections.ConnectionRequestListener> zzi2) throws RemoteException {
        ((zzos)this.zznM()).zza((zzor)new zzd(zzb2, zzi2), string2, appMetadata, l, this.zzaoX);
    }

    public void zzwT() {
        try {
            ((zzos)this.zznM()).zzN(this.zzaoX);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"NearbyConnectionsClient", (String)"Couldn't stop advertising", (Throwable)remoteException);
        }
    }

    public void zza(zza.zzb<Status> zzb2, String string2, long l, com.google.android.gms.common.api.zzi<Connections.EndpointDiscoveryListener> zzi2) throws RemoteException {
        ((zzos)this.zznM()).zza((zzor)new zzf(zzb2, zzi2), string2, l, this.zzaoX);
    }

    public void zzdQ(String string2) {
        try {
            ((zzos)this.zznM()).zzf(string2, this.zzaoX);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"NearbyConnectionsClient", (String)"Couldn't stop discovery", (Throwable)remoteException);
        }
    }

    public void zza(zza.zzb<Status> zzb2, String string2, String string3, byte[] byArray, com.google.android.gms.common.api.zzi<Connections.ConnectionResponseCallback> zzi2, com.google.android.gms.common.api.zzi<Connections.MessageListener> zzi3) throws RemoteException {
        ((zzos)this.zznM()).zza((zzor)new zzc(zzb2, zzi2, zzi3), string2, string3, byArray, this.zzaoX);
    }

    public void zza(zza.zzb<Status> zzb2, String string2, byte[] byArray, com.google.android.gms.common.api.zzi<Connections.MessageListener> zzi2) throws RemoteException {
        ((zzos)this.zznM()).zza((zzor)new zza(zzb2, zzi2), string2, byArray, this.zzaoX);
    }

    public void zzp(final zza.zzb<Status> zzb2, String string2) throws RemoteException {
        ((zzos)this.zznM()).zza(new zzoo(){

            @Override
            public void zzib(int n) throws RemoteException {
                zzb2.zzm(new Status(n));
            }
        }, string2, this.zzaoX);
    }

    public void zza(String[] stringArray, byte[] byArray) {
        try {
            ((zzos)this.zznM()).zza(stringArray, byArray, this.zzaoX);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"NearbyConnectionsClient", (String)"Couldn't send reliable message", (Throwable)remoteException);
        }
    }

    public void zzb(String[] stringArray, byte[] byArray) {
        try {
            ((zzos)this.zznM()).zzb(stringArray, byArray, this.zzaoX);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"NearbyConnectionsClient", (String)"Couldn't send unreliable message", (Throwable)remoteException);
        }
    }

    public void zzdR(String string2) {
        try {
            ((zzos)this.zznM()).zzg(string2, this.zzaoX);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"NearbyConnectionsClient", (String)"Couldn't disconnect from endpoint", (Throwable)remoteException);
        }
    }

    public void zzwU() {
        try {
            ((zzos)this.zznM()).zzP(this.zzaoX);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"NearbyConnectionsClient", (String)"Couldn't stop all endpoints", (Throwable)remoteException);
        }
    }

    @Override
    public void disconnect() {
        if (this.isConnected()) {
            try {
                zzos zzos2 = (zzos)this.zznM();
                zzos2.zzE(this.zzaoX);
            }
            catch (RemoteException remoteException) {
                Log.w((String)"NearbyConnectionsClient", (String)"Failed to notify client disconnect.", (Throwable)remoteException);
            }
        }
        super.disconnect();
    }

    @Override
    protected /* synthetic */ IInterface zzT(IBinder iBinder) {
        return this.zzda(iBinder);
    }

    private static final class zza
    extends zzb {
        private final zza.zzb<Status> zzOs;

        public zza(zza.zzb<Status> zzb2, com.google.android.gms.common.api.zzi<Connections.MessageListener> zzi2) {
            super(zzi2);
            this.zzOs = zzu.zzu(zzb2);
        }

        @Override
        public void zzia(int n) throws RemoteException {
            this.zzOs.zzm(new Status(n));
        }
    }

    private static final class zzc
    extends zzb {
        private final zza.zzb<Status> zzOs;
        private final com.google.android.gms.common.api.zzi<Connections.ConnectionResponseCallback> zzaFv;

        public zzc(zza.zzb<Status> zzb2, com.google.android.gms.common.api.zzi<Connections.ConnectionResponseCallback> zzi2, com.google.android.gms.common.api.zzi<Connections.MessageListener> zzi3) {
            super(zzi3);
            this.zzOs = zzu.zzu(zzb2);
            this.zzaFv = zzu.zzu(zzi2);
        }

        @Override
        public void zzhZ(int n) throws RemoteException {
            this.zzOs.zzm(new Status(n));
        }

        @Override
        public void zza(final String string2, final int n, final byte[] byArray) throws RemoteException {
            this.zzaFv.zza(new zzi.zzb<Connections.ConnectionResponseCallback>(){

                public void zza(Connections.ConnectionResponseCallback connectionResponseCallback) {
                    connectionResponseCallback.onConnectionResponse(string2, new Status(n), byArray);
                }

                @Override
                public void zzmw() {
                }

                @Override
                public /* synthetic */ void zzn(Object object) {
                    this.zza((Connections.ConnectionResponseCallback)object);
                }
            });
        }
    }

    private static class zzb
    extends zzoo {
        private final com.google.android.gms.common.api.zzi<Connections.MessageListener> zzaFr;

        zzb(com.google.android.gms.common.api.zzi<Connections.MessageListener> zzi2) {
            this.zzaFr = zzi2;
        }

        @Override
        public void onMessageReceived(final String remoteEndpointId, final byte[] payload, final boolean isReliable) throws RemoteException {
            this.zzaFr.zza(new zzi.zzb<Connections.MessageListener>(){

                public void zza(Connections.MessageListener messageListener) {
                    messageListener.onMessageReceived(remoteEndpointId, payload, isReliable);
                }

                @Override
                public void zzmw() {
                }

                @Override
                public /* synthetic */ void zzn(Object object) {
                    this.zza((Connections.MessageListener)object);
                }
            });
        }

        @Override
        public void onDisconnected(final String remoteEndpointId) throws RemoteException {
            this.zzaFr.zza(new zzi.zzb<Connections.MessageListener>(){

                public void zza(Connections.MessageListener messageListener) {
                    messageListener.onDisconnected(remoteEndpointId);
                }

                @Override
                public void zzmw() {
                }

                @Override
                public /* synthetic */ void zzn(Object object) {
                    this.zza((Connections.MessageListener)object);
                }
            });
        }
    }

    private static final class zzf
    extends zzoo {
        private final zza.zzb<Status> zzOs;
        private final com.google.android.gms.common.api.zzi<Connections.EndpointDiscoveryListener> zzaFx;

        zzf(zza.zzb<Status> zzb2, com.google.android.gms.common.api.zzi<Connections.EndpointDiscoveryListener> zzi2) {
            this.zzOs = zzu.zzu(zzb2);
            this.zzaFx = zzu.zzu(zzi2);
        }

        @Override
        public void zzhX(int n) throws RemoteException {
            this.zzOs.zzm(new Status(n));
        }

        @Override
        public void onEndpointFound(final String endpointId, final String deviceId, final String serviceId, final String name) throws RemoteException {
            this.zzaFx.zza(new zzi.zzb<Connections.EndpointDiscoveryListener>(){

                public void zza(Connections.EndpointDiscoveryListener endpointDiscoveryListener) {
                    endpointDiscoveryListener.onEndpointFound(endpointId, deviceId, serviceId, name);
                }

                @Override
                public void zzmw() {
                }

                @Override
                public /* synthetic */ void zzn(Object object) {
                    this.zza((Connections.EndpointDiscoveryListener)object);
                }
            });
        }

        @Override
        public void onEndpointLost(final String endpointId) throws RemoteException {
            this.zzaFx.zza(new zzi.zzb<Connections.EndpointDiscoveryListener>(){

                public void zza(Connections.EndpointDiscoveryListener endpointDiscoveryListener) {
                    endpointDiscoveryListener.onEndpointLost(endpointId);
                }

                @Override
                public void zzmw() {
                }

                @Override
                public /* synthetic */ void zzn(Object object) {
                    this.zza((Connections.EndpointDiscoveryListener)object);
                }
            });
        }
    }

    private static final class zzd
    extends zzoo {
        private final zza.zzb<Connections.StartAdvertisingResult> zzOs;
        private final com.google.android.gms.common.api.zzi<Connections.ConnectionRequestListener> zzaFx;

        zzd(zza.zzb<Connections.StartAdvertisingResult> zzb2, com.google.android.gms.common.api.zzi<Connections.ConnectionRequestListener> zzi2) {
            this.zzOs = zzu.zzu(zzb2);
            this.zzaFx = zzu.zzu(zzi2);
        }

        @Override
        public void zzj(int n, String string2) throws RemoteException {
            this.zzOs.zzm(new zze(new Status(n), string2));
        }

        @Override
        public void onConnectionRequest(final String remoteEndpointId, final String remoteDeviceId, final String remoteEndpointName, final byte[] payload) throws RemoteException {
            this.zzaFx.zza(new zzi.zzb<Connections.ConnectionRequestListener>(){

                public void zza(Connections.ConnectionRequestListener connectionRequestListener) {
                    connectionRequestListener.onConnectionRequest(remoteEndpointId, remoteDeviceId, remoteEndpointName, payload);
                }

                @Override
                public void zzmw() {
                }

                @Override
                public /* synthetic */ void zzn(Object object) {
                    this.zza((Connections.ConnectionRequestListener)object);
                }
            });
        }
    }

    private static final class zze
    implements Connections.StartAdvertisingResult {
        private final Status zzOt;
        private final String zzaFB;

        zze(Status status, String string2) {
            this.zzOt = status;
            this.zzaFB = string2;
        }

        @Override
        public Status getStatus() {
            return this.zzOt;
        }

        @Override
        public String getLocalEndpointName() {
            return this.zzaFB;
        }
    }
}

