/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.jcache.EntryProxy;
import com.github.benmanes.caffeine.jcache.Expirable;
import com.github.benmanes.caffeine.jcache.configuration.CaffeineConfiguration;
import com.github.benmanes.caffeine.jcache.copy.Copier;
import com.github.benmanes.caffeine.jcache.event.EventDispatcher;
import com.github.benmanes.caffeine.jcache.event.Registration;
import com.github.benmanes.caffeine.jcache.integration.DisabledCacheWriter;
import com.github.benmanes.caffeine.jcache.management.JCacheMXBean;
import com.github.benmanes.caffeine.jcache.management.JCacheStatisticsMXBean;
import com.github.benmanes.caffeine.jcache.management.JmxRegistration;
import com.github.benmanes.caffeine.jcache.processor.EntryProcessorEntry;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CacheWriterException;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CacheProxy<K, V>
implements javax.cache.Cache<K, V> {
    private static final Logger logger = Logger.getLogger(CacheProxy.class.getName());
    final Cache<K, Expirable<V>> cache;
    final CaffeineConfiguration<K, V> configuration;
    final CacheManager cacheManager;
    final CacheWriter<K, V> writer;
    final JCacheMXBean cacheMXBean;
    final Copier copier;
    final String name;
    protected final Optional<CacheLoader<K, V>> cacheLoader;
    protected final Set<CompletableFuture<?>> inFlight;
    protected final JCacheStatisticsMXBean statistics;
    protected final EventDispatcher<K, V> dispatcher;
    protected final ExpiryPolicy expiry;
    protected final Executor executor;
    protected final Ticker ticker;
    volatile boolean closed;

    public CacheProxy(String name, Executor executor, CacheManager cacheManager, CaffeineConfiguration<K, V> configuration, Cache<K, Expirable<V>> cache, EventDispatcher<K, V> dispatcher, Optional<CacheLoader<K, V>> cacheLoader, ExpiryPolicy expiry, Ticker ticker, JCacheStatisticsMXBean statistics) {
        this.configuration = Objects.requireNonNull(configuration);
        this.cacheManager = Objects.requireNonNull(cacheManager);
        this.cacheLoader = Objects.requireNonNull(cacheLoader);
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.statistics = Objects.requireNonNull(statistics);
        this.executor = Objects.requireNonNull(executor);
        this.expiry = Objects.requireNonNull(expiry);
        this.ticker = Objects.requireNonNull(ticker);
        this.cache = Objects.requireNonNull(cache);
        this.name = Objects.requireNonNull(name);
        this.copier = configuration.isStoreByValue() ? (Copier)configuration.getCopierFactory().create() : Copier.identity();
        this.writer = configuration.hasCacheWriter() ? configuration.getCacheWriter() : DisabledCacheWriter.get();
        this.cacheMXBean = new JCacheMXBean(this);
        this.inFlight = ConcurrentHashMap.newKeySet();
    }

    public boolean containsKey(K key) {
        this.requireNotClosed();
        Expirable expirable = (Expirable)this.cache.getIfPresent(key);
        if (expirable == null) {
            return false;
        }
        if (!expirable.isEternal() && expirable.hasExpired(this.currentTimeMillis())) {
            this.cache.asMap().computeIfPresent(key, (k, e) -> {
                if (e == expirable) {
                    this.dispatcher.publishExpired(this, key, expirable.get());
                    this.statistics.recordEvictions(1L);
                    return null;
                }
                return e;
            });
            this.dispatcher.awaitSynchronous();
            return false;
        }
        return true;
    }

    public @Nullable V get(K key) {
        long millis;
        long start;
        this.requireNotClosed();
        Expirable expirable = (Expirable)this.cache.getIfPresent(key);
        if (expirable == null) {
            this.statistics.recordMisses(1L);
            return null;
        }
        boolean statsEnabled = this.statistics.isEnabled();
        if (!expirable.isEternal()) {
            start = this.ticker.read();
            millis = CacheProxy.nanosToMillis(start);
            if (expirable.hasExpired(millis)) {
                this.cache.asMap().computeIfPresent(key, (k, e) -> {
                    if (e == expirable) {
                        this.dispatcher.publishExpired(this, key, expirable.get());
                        this.statistics.recordEvictions(1L);
                        return null;
                    }
                    return e;
                });
                this.dispatcher.awaitSynchronous();
                this.statistics.recordMisses(1L);
                return null;
            }
        } else if (statsEnabled) {
            start = this.ticker.read();
            millis = CacheProxy.nanosToMillis(start);
        } else {
            millis = 0L;
            start = 0L;
        }
        this.setAccessExpirationTime(key, expirable, millis);
        V value = this.copyValue(expirable);
        if (statsEnabled) {
            this.statistics.recordHits(1L);
            this.statistics.recordGetTime(this.ticker.read() - start);
        }
        return value;
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        this.requireNotClosed();
        boolean statsEnabled = this.statistics.isEnabled();
        long now = statsEnabled ? this.ticker.read() : 0L;
        Map<? extends K, Expirable<V>> result = this.getAndFilterExpiredEntries(keys, true);
        if (statsEnabled) {
            this.statistics.recordGetTime(this.ticker.read() - now);
        }
        return this.copyMap(result);
    }

    protected Map<K, Expirable<V>> getAndFilterExpiredEntries(Set<? extends K> keys, boolean updateAccessTime) {
        HashMap result = new HashMap(this.cache.getAllPresent(keys));
        int[] expired = new int[]{0};
        long[] millis = new long[]{0L};
        result.entrySet().removeIf(entry -> {
            if (!((Expirable)entry.getValue()).isEternal() && millis[0] == 0L) {
                millis[0] = this.currentTimeMillis();
            }
            if (((Expirable)entry.getValue()).hasExpired(millis[0])) {
                this.cache.asMap().computeIfPresent(entry.getKey(), (k, expirable) -> {
                    if (expirable == entry.getValue()) {
                        this.dispatcher.publishExpired(this, entry.getKey(), ((Expirable)entry.getValue()).get());
                        expired[0] = expired[0] + 1;
                        return null;
                    }
                    return expirable;
                });
                return true;
            }
            if (updateAccessTime) {
                this.setAccessExpirationTime(entry.getKey(), (Expirable)entry.getValue(), millis[0]);
            }
            return false;
        });
        this.statistics.recordHits(result.size());
        this.statistics.recordMisses(keys.size() - result.size());
        this.statistics.recordEvictions(expired[0]);
        return result;
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        NullCompletionListener listener;
        this.requireNotClosed();
        keys.forEach(Objects::requireNonNull);
        NullCompletionListener nullCompletionListener = listener = completionListener == null ? NullCompletionListener.INSTANCE : completionListener;
        if (!this.cacheLoader.isPresent()) {
            listener.onCompletion();
            return;
        }
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            try {
                if (replaceExistingValues) {
                    this.loadAllAndReplaceExisting(keys);
                } else {
                    this.loadAllAndKeepExisting(keys);
                }
                listener.onCompletion();
            }
            catch (CacheLoaderException e) {
                listener.onException((Exception)((Object)e));
            }
            catch (Exception e) {
                listener.onException((Exception)((Object)new CacheLoaderException((Throwable)e)));
            }
            finally {
                this.dispatcher.ignoreSynchronous();
            }
        }, this.executor);
        this.inFlight.add(future);
        future.whenComplete((r, e) -> this.inFlight.remove(future));
    }

    private void loadAllAndReplaceExisting(Set<? extends K> keys) {
        int[] ignored = new int[]{0};
        Map loaded = this.cacheLoader.get().loadAll(keys);
        for (Map.Entry entry : loaded.entrySet()) {
            this.putNoCopyOrAwait(entry.getKey(), entry.getValue(), false, ignored);
        }
    }

    private void loadAllAndKeepExisting(Set<? extends K> keys) {
        List keysToLoad = keys.stream().filter(key -> !this.cache.asMap().containsKey(key)).collect(Collectors.toList());
        Map result = this.cacheLoader.get().loadAll(keysToLoad);
        for (Map.Entry entry : result.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.putIfAbsentNoAwait(entry.getKey(), entry.getValue(), false);
        }
    }

    public void put(K key, V value) {
        this.requireNotClosed();
        boolean statsEnabled = this.statistics.isEnabled();
        long start = statsEnabled ? this.ticker.read() : 0L;
        int[] puts = new int[]{0};
        this.putNoCopyOrAwait(key, value, true, puts);
        this.dispatcher.awaitSynchronous();
        if (statsEnabled) {
            this.statistics.recordPuts(puts[0]);
            this.statistics.recordPutTime(this.ticker.read() - start);
        }
    }

    public @Nullable V getAndPut(K key, V value) {
        this.requireNotClosed();
        boolean statsEnabled = this.statistics.isEnabled();
        long start = statsEnabled ? this.ticker.read() : 0L;
        int[] puts = new int[]{0};
        V val = this.putNoCopyOrAwait(key, value, true, puts);
        this.dispatcher.awaitSynchronous();
        V copy = this.copyOf(val);
        if (statsEnabled) {
            if (val == null) {
                this.statistics.recordMisses(1L);
            } else {
                this.statistics.recordHits(1L);
            }
            long duration = this.ticker.read() - start;
            this.statistics.recordGetTime(duration);
            this.statistics.recordPutTime(duration);
            this.statistics.recordPuts(puts[0]);
        }
        return copy;
    }

    protected V putNoCopyOrAwait(K key, V value, boolean publishToWriter, int[] puts) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        Object[] replaced = new Object[1];
        this.cache.asMap().compute(this.copyOf(key), (k, expirable) -> {
            Object newValue = this.copyOf(value);
            if (publishToWriter && this.configuration.isWriteThrough()) {
                this.publishToCacheWriter(arg_0 -> this.writer.write(arg_0), () -> new EntryProxy<Object, Object>(key, value));
            }
            if (expirable != null && !expirable.isEternal() && expirable.hasExpired(this.currentTimeMillis())) {
                this.dispatcher.publishExpired(this, key, expirable.get());
                this.statistics.recordEvictions(1L);
                expirable = null;
            }
            long expireTimeMS = this.getWriteExpireTimeMS(expirable == null);
            if (expirable != null && expireTimeMS == Long.MIN_VALUE) {
                expireTimeMS = expirable.getExpireTimeMS();
            }
            if (expireTimeMS == 0L) {
                replaced[0] = expirable == null ? null : expirable.get();
                return null;
            }
            if (expirable == null) {
                this.dispatcher.publishCreated(this, key, newValue);
            } else {
                replaced[0] = expirable.get();
                this.dispatcher.publishUpdated(this, key, expirable.get(), newValue);
            }
            puts[0] = puts[0] + 1;
            return new Expirable<Object>(newValue, expireTimeMS);
        });
        return (V)replaced[0];
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.requireNotClosed();
        boolean statsEnabled = this.statistics.isEnabled();
        long start = statsEnabled ? this.ticker.read() : 0L;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Objects.requireNonNull(entry.getKey());
            Objects.requireNonNull(entry.getValue());
        }
        int[] puts = new int[]{0};
        CacheWriterException e = this.writeAllToCacheWriter(map);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.putNoCopyOrAwait(entry.getKey(), entry.getValue(), false, puts);
        }
        this.dispatcher.awaitSynchronous();
        if (statsEnabled) {
            this.statistics.recordPuts(puts[0]);
            this.statistics.recordPutTime(this.ticker.read() - start);
        }
        if (e != null) {
            throw e;
        }
    }

    public boolean putIfAbsent(K key, V value) {
        this.requireNotClosed();
        Objects.requireNonNull(value);
        boolean statsEnabled = this.statistics.isEnabled();
        long start = statsEnabled ? this.ticker.read() : 0L;
        boolean added = this.putIfAbsentNoAwait(key, value, true);
        this.dispatcher.awaitSynchronous();
        if (statsEnabled) {
            if (added) {
                this.statistics.recordPuts(1L);
                this.statistics.recordMisses(1L);
            } else {
                this.statistics.recordHits(1L);
            }
            this.statistics.recordPutTime(this.ticker.read() - start);
        }
        return added;
    }

    private boolean putIfAbsentNoAwait(K key, V value, boolean publishToWriter) {
        boolean[] absent = new boolean[]{false};
        this.cache.asMap().compute(this.copyOf(key), (k, expirable) -> {
            if (expirable != null && !expirable.isEternal() && expirable.hasExpired(this.currentTimeMillis())) {
                this.dispatcher.publishExpired(this, key, expirable.get());
                this.statistics.recordEvictions(1L);
                expirable = null;
            }
            if (expirable != null) {
                return expirable;
            }
            absent[0] = true;
            long expireTimeMS = this.getWriteExpireTimeMS(true);
            if (expireTimeMS == 0L) {
                return null;
            }
            if (publishToWriter) {
                this.publishToCacheWriter(arg_0 -> this.writer.write(arg_0), () -> new EntryProxy<Object, Object>(key, value));
            }
            Object copy = this.copyOf(value);
            this.dispatcher.publishCreated(this, key, copy);
            return new Expirable<Object>(copy, expireTimeMS);
        });
        return absent[0];
    }

    public boolean remove(K key) {
        this.requireNotClosed();
        Objects.requireNonNull(key);
        boolean statsEnabled = this.statistics.isEnabled();
        long start = statsEnabled ? this.ticker.read() : 0L;
        this.publishToCacheWriter(arg_0 -> this.writer.delete(arg_0), () -> key);
        V value = this.removeNoCopyOrAwait(key);
        this.dispatcher.awaitSynchronous();
        if (statsEnabled) {
            this.statistics.recordRemoveTime(this.ticker.read() - start);
        }
        if (value != null) {
            this.statistics.recordRemovals(1L);
            return true;
        }
        return false;
    }

    private V removeNoCopyOrAwait(K key) {
        Object[] removed = new Object[1];
        this.cache.asMap().computeIfPresent(key, (k, expirable) -> {
            if (!expirable.isEternal() && expirable.hasExpired(this.currentTimeMillis())) {
                this.dispatcher.publishExpired(this, key, expirable.get());
                this.statistics.recordEvictions(1L);
                return null;
            }
            this.dispatcher.publishRemoved(this, key, expirable.get());
            removed[0] = expirable.get();
            return null;
        });
        return (V)removed[0];
    }

    public boolean remove(K key, V oldValue) {
        this.requireNotClosed();
        Objects.requireNonNull(key);
        Objects.requireNonNull(oldValue);
        boolean statsEnabled = this.statistics.isEnabled();
        long start = statsEnabled ? this.ticker.read() : 0L;
        boolean[] removed = new boolean[]{false};
        this.cache.asMap().computeIfPresent(key, (k, expirable) -> {
            long millis;
            long l = expirable.isEternal() ? 0L : (millis = CacheProxy.nanosToMillis(start == 0L ? this.ticker.read() : start));
            if (expirable.hasExpired(millis)) {
                this.dispatcher.publishExpired(this, key, expirable.get());
                this.statistics.recordEvictions(1L);
                return null;
            }
            if (oldValue.equals(expirable.get())) {
                this.publishToCacheWriter(arg_0 -> this.writer.delete(arg_0), () -> key);
                this.dispatcher.publishRemoved(this, key, expirable.get());
                removed[0] = true;
                return null;
            }
            this.setAccessExpirationTime(key, (Expirable<?>)expirable, millis);
            return expirable;
        });
        this.dispatcher.awaitSynchronous();
        if (statsEnabled) {
            if (removed[0]) {
                this.statistics.recordRemovals(1L);
                this.statistics.recordHits(1L);
            } else {
                this.statistics.recordMisses(1L);
            }
            this.statistics.recordRemoveTime(this.ticker.read() - start);
        }
        return removed[0];
    }

    public V getAndRemove(K key) {
        this.requireNotClosed();
        Objects.requireNonNull(key);
        boolean statsEnabled = this.statistics.isEnabled();
        long start = statsEnabled ? this.ticker.read() : 0L;
        this.publishToCacheWriter(arg_0 -> this.writer.delete(arg_0), () -> key);
        V value = this.removeNoCopyOrAwait(key);
        this.dispatcher.awaitSynchronous();
        V copy = this.copyOf(value);
        if (statsEnabled) {
            if (value == null) {
                this.statistics.recordMisses(1L);
            } else {
                this.statistics.recordHits(1L);
                this.statistics.recordRemovals(1L);
            }
            long duration = this.ticker.read() - start;
            this.statistics.recordRemoveTime(duration);
            this.statistics.recordGetTime(duration);
        }
        return copy;
    }

    public boolean replace(K key, V oldValue, V newValue) {
        this.requireNotClosed();
        Objects.requireNonNull(oldValue);
        Objects.requireNonNull(newValue);
        boolean statsEnabled = this.statistics.isEnabled();
        long start = statsEnabled ? this.ticker.read() : 0L;
        boolean[] found = new boolean[]{false};
        boolean[] replaced = new boolean[]{false};
        this.cache.asMap().computeIfPresent(key, (k, expirable) -> {
            Expirable<Object> result;
            long millis;
            long l = expirable.isEternal() ? 0L : (millis = CacheProxy.nanosToMillis(start == 0L ? this.ticker.read() : start));
            if (expirable.hasExpired(millis)) {
                this.dispatcher.publishExpired(this, key, expirable.get());
                this.statistics.recordEvictions(1L);
                return null;
            }
            found[0] = true;
            if (oldValue.equals(expirable.get())) {
                this.publishToCacheWriter(arg_0 -> this.writer.write(arg_0), () -> new EntryProxy(key, expirable.get()));
                this.dispatcher.publishUpdated(this, key, expirable.get(), this.copyOf(newValue));
                long expireTimeMS = this.getWriteExpireTimeMS(false);
                if (expireTimeMS == Long.MIN_VALUE) {
                    expireTimeMS = expirable.getExpireTimeMS();
                }
                result = new Expirable<Object>(newValue, expireTimeMS);
                replaced[0] = true;
            } else {
                result = expirable;
                this.setAccessExpirationTime(key, (Expirable<?>)expirable, millis);
            }
            return result;
        });
        this.dispatcher.awaitSynchronous();
        if (statsEnabled) {
            this.statistics.recordPuts(replaced[0] ? 1L : 0L);
            this.statistics.recordMisses(found[0] ? 0L : 1L);
            this.statistics.recordHits(found[0] ? 1L : 0L);
            long duration = this.ticker.read() - start;
            this.statistics.recordGetTime(duration);
            this.statistics.recordPutTime(duration);
        }
        return replaced[0];
    }

    public boolean replace(K key, V value) {
        this.requireNotClosed();
        boolean statsEnabled = this.statistics.isEnabled();
        long start = statsEnabled ? this.ticker.read() : 0L;
        V oldValue = this.replaceNoCopyOrAwait(key, value);
        this.dispatcher.awaitSynchronous();
        if (oldValue == null) {
            this.statistics.recordMisses(1L);
            return false;
        }
        if (statsEnabled) {
            this.statistics.recordHits(1L);
            this.statistics.recordPuts(1L);
            this.statistics.recordPutTime(this.ticker.read() - start);
        }
        return true;
    }

    public V getAndReplace(K key, V value) {
        this.requireNotClosed();
        boolean statsEnabled = this.statistics.isEnabled();
        long start = statsEnabled ? this.ticker.read() : 0L;
        V oldValue = this.replaceNoCopyOrAwait(key, value);
        this.dispatcher.awaitSynchronous();
        V copy = this.copyOf(oldValue);
        if (statsEnabled) {
            if (oldValue == null) {
                this.statistics.recordMisses(1L);
            } else {
                this.statistics.recordHits(1L);
                this.statistics.recordPuts(1L);
            }
            long duration = this.ticker.read() - start;
            this.statistics.recordGetTime(duration);
            this.statistics.recordPutTime(duration);
        }
        return copy;
    }

    private V replaceNoCopyOrAwait(K key, V value) {
        Objects.requireNonNull(value);
        V copy = this.copyOf(value);
        Object[] replaced = new Object[1];
        this.cache.asMap().computeIfPresent(key, (k, expirable) -> {
            if (!expirable.isEternal() && expirable.hasExpired(this.currentTimeMillis())) {
                this.dispatcher.publishExpired(this, key, expirable.get());
                this.statistics.recordEvictions(1L);
                return null;
            }
            this.publishToCacheWriter(arg_0 -> this.writer.write(arg_0), () -> new EntryProxy<Object, Object>(key, value));
            long expireTimeMS = this.getWriteExpireTimeMS(false);
            if (expireTimeMS == Long.MIN_VALUE) {
                expireTimeMS = expirable.getExpireTimeMS();
            }
            this.dispatcher.publishUpdated(this, key, expirable.get(), copy);
            replaced[0] = expirable.get();
            return new Expirable<Object>(copy, expireTimeMS);
        });
        return (V)replaced[0];
    }

    public void removeAll(Set<? extends K> keys) {
        this.requireNotClosed();
        keys.forEach(Objects::requireNonNull);
        boolean statsEnabled = this.statistics.isEnabled();
        long start = statsEnabled ? this.ticker.read() : 0L;
        HashSet<K> keysToRemove = new HashSet<K>(keys);
        CacheWriterException e = this.deleteAllToCacheWriter(keysToRemove);
        long removed = keysToRemove.stream().map(this::removeNoCopyOrAwait).filter(Objects::nonNull).count();
        this.dispatcher.awaitSynchronous();
        if (statsEnabled) {
            this.statistics.recordRemovals(removed);
            this.statistics.recordRemoveTime(this.ticker.read() - start);
        }
        if (e != null) {
            throw e;
        }
    }

    public void removeAll() {
        this.removeAll(this.cache.asMap().keySet());
    }

    public void clear() {
        this.requireNotClosed();
        this.cache.invalidateAll();
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        if (clazz.isInstance(this.configuration)) {
            return (C)((Configuration)clazz.cast(this.configuration));
        }
        throw new IllegalArgumentException("The configuration class " + clazz + " is not supported by this implementation");
    }

    public CaffeineConfiguration<K, V> getConfiguration() {
        return this.configuration;
    }

    public <T> @Nullable T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        Objects.requireNonNull(entryProcessor);
        Objects.requireNonNull(arguments);
        this.requireNotClosed();
        Object[] result = new Object[1];
        BiFunction<Object, Expirable, Expirable> remappingFunction = (k, expirable) -> {
            Object value;
            long millis = 0L;
            if (expirable == null || !expirable.isEternal() && expirable.hasExpired(millis = this.currentTimeMillis())) {
                this.statistics.recordMisses(1L);
                value = null;
            } else {
                value = this.copyValue((Expirable<V>)expirable);
                this.statistics.recordHits(1L);
            }
            EntryProcessorEntry<Object, Object> entry = new EntryProcessorEntry<Object, Object>(key, value, (Optional<CacheLoader<Object, Object>>)(this.configuration.isReadThrough() ? this.cacheLoader : Optional.empty()));
            try {
                result[0] = entryProcessor.process(entry, arguments);
                return this.postProcess((Expirable<V>)expirable, entry, millis);
            }
            catch (EntryProcessorException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new EntryProcessorException((Throwable)e);
            }
        };
        try {
            this.cache.asMap().compute(this.copyOf(key), remappingFunction);
            this.dispatcher.awaitSynchronous();
        }
        catch (Throwable thr) {
            this.dispatcher.ignoreSynchronous();
            throw thr;
        }
        Object castedResult = result[0];
        return (T)castedResult;
    }

    private @Nullable Expirable<V> postProcess(Expirable<V> expirable, EntryProcessorEntry<K, V> entry, long currentTimeMS) {
        switch (entry.getAction()) {
            case NONE: {
                if (expirable == null) {
                    return null;
                }
                if (expirable.isEternal()) {
                    return expirable;
                }
                if (currentTimeMS == 0L) {
                    currentTimeMS = this.currentTimeMillis();
                }
                if (expirable.hasExpired(currentTimeMS)) {
                    this.dispatcher.publishExpired(this, entry.getKey(), expirable.get());
                    this.statistics.recordEvictions(1L);
                    return null;
                }
                return expirable;
            }
            case READ: {
                this.setAccessExpirationTime(entry.getKey(), expirable, 0L);
                return expirable;
            }
            case CREATED: {
                this.publishToCacheWriter(arg_0 -> this.writer.write(arg_0), () -> entry);
            }
            case LOADED: {
                this.statistics.recordPuts(1L);
                this.dispatcher.publishCreated(this, entry.getKey(), entry.getValue());
                return new Expirable<V>(entry.getValue(), this.getWriteExpireTimeMS(true));
            }
            case UPDATED: {
                this.statistics.recordPuts(1L);
                this.publishToCacheWriter(arg_0 -> this.writer.write(arg_0), () -> entry);
                Objects.requireNonNull(expirable, "Expected a previous value but was null");
                this.dispatcher.publishUpdated(this, entry.getKey(), expirable.get(), entry.getValue());
                long expireTimeMS = this.getWriteExpireTimeMS(false);
                if (expireTimeMS == Long.MIN_VALUE) {
                    expireTimeMS = expirable.getExpireTimeMS();
                }
                return new Expirable<V>(entry.getValue(), expireTimeMS);
            }
            case DELETED: {
                this.statistics.recordRemovals(1L);
                this.publishToCacheWriter(arg_0 -> this.writer.delete(arg_0), entry::getKey);
                if (expirable != null) {
                    this.dispatcher.publishRemoved(this, entry.getKey(), expirable.get());
                }
                return null;
            }
        }
        throw new IllegalStateException("Unknown state: " + (Object)((Object)entry.getAction()));
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        HashMap<K, EntryProcessorResult> results = new HashMap<K, EntryProcessorResult>(keys.size());
        for (K key : keys) {
            try {
                Object result = this.invoke(key, entryProcessor, arguments);
                if (result == null) continue;
                results.put(key, () -> result);
            }
            catch (EntryProcessorException e) {
                results.put(key, () -> {
                    throw e;
                });
            }
        }
        return results;
    }

    public String getName() {
        return this.name;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.isClosed()) {
            return;
        }
        CaffeineConfiguration<K, V> caffeineConfiguration = this.configuration;
        synchronized (caffeineConfiguration) {
            if (!this.isClosed()) {
                this.enableManagement(false);
                this.enableStatistics(false);
                this.cacheManager.destroyCache(this.name);
                this.closed = true;
                Throwable thrown = this.shutdownExecutor();
                thrown = CacheProxy.tryClose(this.expiry, thrown);
                thrown = CacheProxy.tryClose(this.writer, thrown);
                thrown = CacheProxy.tryClose(this.cacheLoader.orElse(null), thrown);
                for (Registration<K, V> registration : this.dispatcher.registrations()) {
                    thrown = CacheProxy.tryClose(registration.getCacheEntryListener(), thrown);
                }
                if (thrown != null) {
                    logger.log(Level.WARNING, "Failure when closing cache resources", thrown);
                }
            }
        }
        this.cache.invalidateAll();
    }

    private @Nullable Throwable shutdownExecutor() {
        Exception thrown = null;
        if (this.executor instanceof ExecutorService) {
            ExecutorService es = (ExecutorService)this.executor;
            es.shutdown();
        }
        try {
            CompletableFuture.allOf(this.inFlight.toArray(new CompletableFuture[0])).get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            thrown = e;
        }
        this.inFlight.clear();
        return thrown;
    }

    private static @Nullable Throwable tryClose(@Nullable Object o, @Nullable Throwable outer) {
        if (o instanceof Closeable) {
            try {
                ((Closeable)o).close();
            }
            catch (Throwable t) {
                if (outer == null) {
                    return t;
                }
                outer.addSuppressed(t);
                return outer;
            }
        }
        return null;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.cache.getClass())) {
            return clazz.cast(this.cache);
        }
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new IllegalArgumentException("Unwrapping to " + clazz + " is not supported by this implementation");
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.requireNotClosed();
        this.configuration.addCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
        this.dispatcher.register(cacheEntryListenerConfiguration);
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.requireNotClosed();
        this.configuration.removeCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
        this.dispatcher.deregister(cacheEntryListenerConfiguration);
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        this.requireNotClosed();
        return new EntryIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enableManagement(boolean enabled) {
        this.requireNotClosed();
        CaffeineConfiguration<K, V> caffeineConfiguration = this.configuration;
        synchronized (caffeineConfiguration) {
            if (enabled) {
                JmxRegistration.registerMXBean(this, this.cacheMXBean, JmxRegistration.MBeanType.Configuration);
            } else {
                JmxRegistration.unregisterMXBean(this, JmxRegistration.MBeanType.Configuration);
            }
            this.configuration.setManagementEnabled(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enableStatistics(boolean enabled) {
        this.requireNotClosed();
        CaffeineConfiguration<K, V> caffeineConfiguration = this.configuration;
        synchronized (caffeineConfiguration) {
            if (enabled) {
                JmxRegistration.registerMXBean(this, this.statistics, JmxRegistration.MBeanType.Statistics);
            } else {
                JmxRegistration.unregisterMXBean(this, JmxRegistration.MBeanType.Statistics);
            }
            this.statistics.enable(enabled);
            this.configuration.setStatisticsEnabled(enabled);
        }
    }

    private <T> void publishToCacheWriter(Consumer<T> action, Supplier<T> data) {
        if (!this.configuration.isWriteThrough()) {
            return;
        }
        try {
            action.accept(data.get());
        }
        catch (CacheWriterException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new CacheWriterException("Exception in CacheWriter", (Throwable)e);
        }
    }

    private @Nullable CacheWriterException writeAllToCacheWriter(Map<? extends K, ? extends V> map) {
        if (!this.configuration.isWriteThrough() || map.isEmpty()) {
            return null;
        }
        List<Cache.Entry> entries = map.entrySet().stream().map(entry -> new EntryProxy(entry.getKey(), entry.getValue())).collect(Collectors.toList());
        try {
            this.writer.writeAll(entries);
            return null;
        }
        catch (CacheWriterException e) {
            entries.forEach(entry -> map.remove(entry.getKey()));
            throw e;
        }
        catch (RuntimeException e) {
            entries.forEach(entry -> map.remove(entry.getKey()));
            return new CacheWriterException("Exception in CacheWriter", (Throwable)e);
        }
    }

    private @Nullable CacheWriterException deleteAllToCacheWriter(Set<? extends K> keys) {
        if (!this.configuration.isWriteThrough() || keys.isEmpty()) {
            return null;
        }
        ArrayList<? extends K> keysToDelete = new ArrayList<K>(keys);
        try {
            this.writer.deleteAll(keysToDelete);
            return null;
        }
        catch (CacheWriterException e) {
            keys.removeAll(keysToDelete);
            throw e;
        }
        catch (RuntimeException e) {
            keys.removeAll(keysToDelete);
            return new CacheWriterException("Exception in CacheWriter", (Throwable)e);
        }
    }

    protected final void requireNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
    }

    protected final <T> @NonNull T copyOf(@Nullable T object) {
        if (object == null) {
            return null;
        }
        T copy = this.copier.copy(object, this.cacheManager.getClassLoader());
        return Objects.requireNonNull(copy);
    }

    protected final @Nullable V copyValue(@Nullable Expirable<V> expirable) {
        if (expirable == null) {
            return null;
        }
        V copy = this.copier.copy(expirable.get(), this.cacheManager.getClassLoader());
        return Objects.requireNonNull(copy);
    }

    protected final Map<K, V> copyMap(Map<K, Expirable<V>> map) {
        ClassLoader classLoader = this.cacheManager.getClassLoader();
        return map.entrySet().stream().collect(Collectors.toMap(entry -> this.copier.copy(entry.getKey(), classLoader), entry -> this.copier.copy(((Expirable)entry.getValue()).get(), classLoader)));
    }

    protected final long currentTimeMillis() {
        return CacheProxy.nanosToMillis(this.ticker.read());
    }

    protected static long nanosToMillis(long nanos) {
        return TimeUnit.NANOSECONDS.toMillis(nanos);
    }

    protected final void setAccessExpirationTime(K key, Expirable<?> expirable, long currentTimeMS) {
        try {
            Duration duration = this.expiry.getExpiryForAccess();
            if (duration == null) {
                return;
            }
            if (duration.isZero()) {
                expirable.setExpireTimeMS(0L);
            } else if (duration.isEternal()) {
                expirable.setExpireTimeMS(Long.MAX_VALUE);
            } else {
                if (currentTimeMS == 0L) {
                    currentTimeMS = this.currentTimeMillis();
                }
                long expireTimeMS = duration.getAdjustedTime(currentTimeMS);
                expirable.setExpireTimeMS(expireTimeMS);
            }
            this.cache.policy().expireVariably().ifPresent(policy -> policy.setExpiresAfter(key, duration.getDurationAmount(), duration.getTimeUnit()));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to set the entry's expiration time", e);
        }
    }

    protected final long getWriteExpireTimeMS(boolean created) {
        try {
            Duration duration;
            Duration duration2 = duration = created ? this.expiry.getExpiryForCreation() : this.expiry.getExpiryForUpdate();
            if (duration == null) {
                return Long.MIN_VALUE;
            }
            if (duration.isZero()) {
                return 0L;
            }
            if (duration.isEternal()) {
                return Long.MAX_VALUE;
            }
            return duration.getAdjustedTime(this.currentTimeMillis());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to get the policy's expiration time", e);
            return Long.MIN_VALUE;
        }
    }

    static enum NullCompletionListener implements CompletionListener
    {
        INSTANCE;


        public void onCompletion() {
        }

        public void onException(Exception e) {
        }
    }

    final class EntryIterator
    implements Iterator<Cache.Entry<K, V>> {
        final Iterator<Map.Entry<K, Expirable<V>>> delegate;
        @Nullable Map.Entry<K, Expirable<V>> current;
        @Nullable Map.Entry<K, Expirable<V>> cursor;

        EntryIterator() {
            this.delegate = CacheProxy.this.cache.asMap().entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            while (this.cursor == null && this.delegate.hasNext()) {
                long millis;
                Map.Entry entry = this.delegate.next();
                long l = millis = entry.getValue().isEternal() ? 0L : CacheProxy.this.currentTimeMillis();
                if (entry.getValue().hasExpired(millis)) continue;
                CacheProxy.this.setAccessExpirationTime(entry.getKey(), entry.getValue(), millis);
                this.cursor = entry;
            }
            return this.cursor != null;
        }

        @Override
        public Cache.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = this.cursor;
            this.cursor = null;
            EntryProxy entry = new EntryProxy(CacheProxy.this.copyOf(this.current.getKey()), CacheProxy.this.copyValue(this.current.getValue()));
            return entry;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            CacheProxy.this.remove(this.current.getKey(), this.current.getValue().get());
            this.current = null;
        }
    }
}

