/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.media.content.playlist;

import java.awt.Component;
import java.awt.Dimension;
import org.dvb.media.VideoFormatControl;
import org.dvb.media.VideoFormatListener;
import org.dvb.media.VideoTransformation;
import org.havi.ui.HScreen;
import org.havi.ui.HVideoConfiguration;
import org.videolan.Logger;
import org.videolan.TIClip;
import org.videolan.media.content.playlist.Handler;

public class VideoFormatControlImpl
implements VideoFormatControl {
    private Handler player;
    private int dfc = 0;

    protected VideoFormatControlImpl(Handler player) {
        this.player = player;
    }

    @Override
    public Component getControlComponent() {
        return null;
    }

    @Override
    public int getAspectRatio() {
        TIClip ci = this.player.getCurrentClipInfo();
        if (ci == null || ci.getVideoStreamCount() <= 0) {
            return -1;
        }
        Dimension aspect = ci.getVideoStreams()[0].getVideoAspectRatio();
        if (aspect != null) {
            if (aspect.width == 4 && aspect.height == 3) {
                return 2;
            }
            if (aspect.width == 16 && aspect.height == 9) {
                return 3;
            }
        }
        return -1;
    }

    @Override
    public int getActiveFormatDefinition() {
        return -1;
    }

    @Override
    public int getDecoderFormatConversion() {
        return 0;
    }

    @Override
    public VideoTransformation getVideoTransformation(int dfc) {
        Logger.unimplemented("VideoFormatControlImpl", "getVideoTransformation");
        return null;
    }

    @Override
    public int getDisplayAspectRatio() {
        HVideoConfiguration hvc = HScreen.getDefaultHScreen().getDefaultHVideoDevice().getCurrentConfiguration();
        Dimension resolution = hvc.getPixelResolution();
        if (resolution.width == 720) {
            return 1;
        }
        return 2;
    }

    @Override
    public boolean isPlatform() {
        return this.dfc == 8;
    }

    @Override
    public void addVideoFormatListener(VideoFormatListener listener) {
        Logger.unimplemented("VideoFormatControlImpl", "addVideoFormatListener");
    }

    @Override
    public void removeVideoFormatListener(VideoFormatListener listener) {
    }
}

