/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.videolan.BDJLoader;
import org.videolan.BDJXletContext;
import org.videolan.Logger;

public class FileInputStream
extends InputStream {
    private FileDescriptor fd;
    private final Object closeLock = new Object();
    private volatile boolean closed = false;
    private static Logger logger = null;
    private int available = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public FileInputStream(File file) throws FileNotFoundException {
        String name = file != null ? file.getPath() : null;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(name);
        }
        if (name == null) {
            throw new NullPointerException();
        }
        this.fd = new FileDescriptor();
        this.fd.incrementAndGetUseCount();
        if (file.isAbsolute()) {
            String cachedName = BDJLoader.getCachedFile(name);
            if (cachedName != name) {
                Class<FileInputStream> clazz = FileInputStream.class;
                // MONITORENTER : java.io.FileInputStream.class
                if (logger == null) {
                    logger = Logger.getLogger(FileInputStream.class.getName());
                }
                // MONITOREXIT : clazz
                logger.info("Using cached " + cachedName + " for " + name);
                name = cachedName;
            }
            this.openImpl(name);
        } else {
            String home = BDJXletContext.getCurrentXletHome();
            if (home == null) {
                Class<FileInputStream> clazz = FileInputStream.class;
                // MONITORENTER : java.io.FileInputStream.class
                if (logger == null) {
                    logger = Logger.getLogger(FileInputStream.class.getName());
                }
                // MONITOREXIT : clazz
                logger.error("no home found for " + name + " at " + Logger.dumpStack());
                throw new FileNotFoundException(name);
            }
            this.openImpl(home + name);
        }
        this.available = 1024;
    }

    public FileInputStream(String name) throws FileNotFoundException {
        this(name != null ? new File(name) : null);
    }

    public FileInputStream(FileDescriptor fdObj) {
        SecurityManager security = System.getSecurityManager();
        if (fdObj == null) {
            throw new NullPointerException();
        }
        if (security != null) {
            security.checkRead(fdObj);
        }
        fdObj.incrementAndGetUseCount();
        this.fd = fdObj;
        this.available = 1024;
    }

    private void openImpl(String name) throws FileNotFoundException {
        try {
            this.open(name);
        }
        catch (UnsatisfiedLinkError e) {
            this.open0(name);
        }
    }

    private native int readBytes(byte[] var1, int var2, int var3) throws IOException;

    private native int close0();

    private native void open(String var1) throws FileNotFoundException;

    private native void open0(String var1) throws FileNotFoundException;

    @Override
    public int available() throws IOException {
        if (this.fd != null && this.fd.slave != null) {
            return this.fd.slave.available();
        }
        return this.available;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b) == 1) {
            return b[0];
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.fd != null && this.fd.slave != null) {
            return this.fd.slave.read(b, off, len);
        }
        int r = this.readBytes(b, off, len);
        if (r != len) {
            this.available = 0;
        }
        return r;
    }

    @Override
    public long skip(long n) throws IOException {
        return super.skip(n);
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean force) throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.available = 0;
        if (this.fd != null) {
            if (this.fd.slave != null) {
                this.fd.slave.close();
                return;
            }
            int n = this.fd.decrementAndGetUseCount();
            if (n > 0 && !force) {
                return;
            }
        }
        this.close0();
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd == null) {
            throw new IOException();
        }
        return this.fd;
    }

    private static native void initIDs();

    protected void finalize() throws IOException {
        if (this.fd != null && this.fd != FileDescriptor.in) {
            this.close(false);
        }
    }

    static {
        FileInputStream.initIDs();
    }
}

