/*
 * Decompiled with CFR 0.152.
 */
package javax.tv.service.navigation;

import javax.tv.service.SIElement;
import javax.tv.service.Service;
import javax.tv.service.navigation.FilterNotSupportedException;
import javax.tv.service.navigation.ServiceDetails;
import javax.tv.service.navigation.ServiceFilter;
import org.bluray.net.BDLocator;
import org.bluray.ti.PlayItem;
import org.bluray.ti.PlayItemImpl;
import org.bluray.ti.PlayList;
import org.bluray.ti.PlayListImpl;
import org.bluray.ti.TitleImpl;
import org.videolan.Logger;

public final class SIElementFilter
extends ServiceFilter {
    SIElement element;

    public SIElementFilter(SIElement element) throws FilterNotSupportedException {
        if (element == null) {
            System.err.println("null element");
            throw new NullPointerException();
        }
        try {
            new BDLocator(element.getLocator().toExternalForm());
        }
        catch (Exception e) {
            System.err.println("Invalid SI element: " + e + " at " + Logger.dumpStack(e));
            throw new FilterNotSupportedException();
        }
        this.element = element;
    }

    public SIElement getFilterValue() {
        return this.element;
    }

    public boolean accept(Service service) {
        if (service == null) {
            System.err.println("null service");
            throw new NullPointerException();
        }
        if (!(service instanceof TitleImpl)) {
            return false;
        }
        TitleImpl title = (TitleImpl)service;
        if (this.element instanceof PlayListImpl) {
            int id = ((PlayListImpl)this.element).getId();
            PlayList[] pls = title.getPlayLists();
            for (int i = 0; i < pls.length; ++i) {
                if (id != pls[i].getId()) continue;
                return true;
            }
            return false;
        }
        if (this.element instanceof PlayItemImpl) {
            int piId = ((PlayItemImpl)this.element).getPlayItemId();
            int plId = ((PlayItemImpl)this.element).getPlayListId();
            PlayList[] pls = title.getPlayLists();
            for (int i = 0; i < pls.length; ++i) {
                if (plId != pls[i].getId()) continue;
                PlayItem[] pis = pls[i].getPlayItems();
                for (int j = 0; j < pis.length; ++j) {
                    if (piId != ((PlayItemImpl)pis[j]).getPlayItemId()) continue;
                    return true;
                }
            }
            return false;
        }
        if (this.element instanceof ServiceDetails) {
            return this.element.getLocator() == service.getLocator();
        }
        System.err.println("Unsupported SI element");
        return false;
    }
}

