# coding=UTF-8
# SPDX-License-Identifier: GPL-2.0-or-later
# Original plugin.video.mlbbasesloaded © jakecar
# Code integrated here as change_monitor

from resources.lib.utils import Util
from resources.lib.globals import *
from resources.lib.mlb import *

class MLBMonitor(xbmc.Monitor):
    stream_started = False
    stream_start_tries = 5
    verify = True
    broadcast_start_timestamp = None

    #Skip monitor
    #These are the break events to skip
    BREAK_TYPES = ['Game Advisory', 'Pitching Substitution', 'Offensive Substitution', 'Defensive Sub', 'Defensive Switch', 'Runner Placed On Base', 'Injury']
    #These are the action events to keep, in addition to the last event of each at-bat, if we're skipping non-decision pitches
    ACTION_TYPES = ['Wild Pitch', 'Passed Ball', 'Stolen Base', 'Caught Stealing', 'Pickoff', 'Error', 'Out', 'Balk', 'Defensive Indiff', 'Other Advance']
    #Pad events at both start (-) and end (+)
    EVENT_START_PADDING = -3
    PITCH_END_PADDING = 3
    ACTION_END_PADDING = 8
    MINIMUM_BREAK_DURATION = 5

    #Change monitor
    MAX_LEVERAGE = 11

    #Structure of game state to store for each game
    GameState = namedtuple('GameState',
    ['teams',
     'away_score',
     'home_score',
     'inning_half',
     'inning_num',
     'outs',
     'runners_on_base',
     'game_pk',
     'new_batter',
     'leverage_adjust'])

    #Leverage index table, used to comput leverage index from game state
    LI_TABLE = {
        1: {
            "top": {
                "_ _ _": {
                    0: [0.4, 0.6, 0.7, 0.8, 0.9, 0.0, 0.0, 0.0, 0.0],
                    1: [0.3, 0.4, 0.5, 0.6, 0.6, 0.0, 0.0, 0.0, 0.0],
                    2: [0.2, 0.3, 0.3, 0.4, 0.4, 0.0, 0.0, 0.0, 0.0],
                },
                "1 _ _": {
                    0: [0.7, 0.9, 1.1, 1.3, 1.4, 0.0, 0.0, 0.0, 0.0],
                    1: [0.6, 0.7, 0.9, 1.0, 1.1, 0.0, 0.0, 0.0, 0.0],
                    2: [0.4, 0.5, 0.6, 0.7, 0.8, 0.0, 0.0, 0.0, 0.0],
                },
                "_ 2 _": {
                    0: [0.6, 0.7, 0.9, 1.0, 1.2, 0.0, 0.0, 0.0, 0.0],
                    1: [0.6, 0.8, 0.9, 1.1, 1.2, 0.0, 0.0, 0.0, 0.0],
                    2: [0.6, 0.7, 0.9, 1.0, 1.1, 0.0, 0.0, 0.0, 0.0],
                },
                "_ _ 3": {
                    0: [0.5, 0.6, 0.8, 0.9, 1.0, 0.0, 0.0, 0.0, 0.0],
                    1: [0.7, 0.9, 1.0, 1.2, 1.3, 0.0, 0.0, 0.0, 0.0],
                    2: [0.7, 0.9, 1.0, 1.2, 1.3, 0.0, 0.0, 0.0, 0.0],
                },
                "1 2 _": {
                    0: [0.8, 1.1, 1.3, 1.6, 1.8, 0.0, 0.0, 0.0, 0.0],
                    1: [0.9, 1.2, 1.5, 1.7, 1.9, 0.0, 0.0, 0.0, 0.0],
                    2: [0.8, 1.0, 1.3, 1.5, 1.6, 0.0, 0.0, 0.0, 0.0],
                },
                "1 _ 3": {
                    0: [0.6, 0.8, 1.1, 1.3, 1.5, 0.0, 0.0, 0.0, 0.0],
                    1: [0.9, 1.1, 1.3, 1.6, 1.7, 0.0, 0.0, 0.0, 0.0],
                    2: [0.9, 1.1, 1.4, 1.6, 1.7, 0.0, 0.0, 0.0, 0.0],
                },
                "_ 2 3": {
                    0: [0.6, 0.8, 1.0, 1.2, 1.3, 0.0, 0.0, 0.0, 0.0],
                    1: [0.7, 0.9, 1.1, 1.3, 1.4, 0.0, 0.0, 0.0, 0.0],
                    2: [1.0, 1.2, 1.5, 1.7, 1.9, 0.0, 0.0, 0.0, 0.0],
                },
                "1 2 3": {
                    0: [0.8, 1.1, 1.4, 1.7, 2.0, 0.0, 0.0, 0.0, 0.0],
                    1: [1.1, 1.5, 1.8, 2.1, 2.4, 0.0, 0.0, 0.0, 0.0],
                    2: [1.4, 1.8, 2.1, 2.5, 2.7, 0.0, 0.0, 0.0, 0.0],
                },
            },
            "bot": {
                "_ _ _": {
                    0: [0.7, 0.8, 0.9, 0.9, 0.9, 0.8, 0.6, 0.5, 0.4],
                    1: [0.5, 0.6, 0.6, 0.7, 0.6, 0.6, 0.5, 0.4, 0.3],
                    2: [0.3, 0.4, 0.4, 0.4, 0.4, 0.4, 0.3, 0.3, 0.2],
                },
                "1 _ _": {
                    0: [1.2, 1.4, 1.5, 1.5, 1.4, 1.2, 1.0, 0.8, 0.6],
                    1: [1.0, 1.1, 1.2, 1.2, 1.1, 1.0, 0.8, 0.7, 0.5],
                    2: [0.6, 0.7, 0.8, 0.8, 0.8, 0.7, 0.6, 0.5, 0.4],
                },
                "_ 2 _": {
                    0: [1.1, 1.2, 1.3, 1.2, 1.1, 1.0, 0.8, 0.6, 0.5],
                    1: [1.0, 1.1, 1.2, 1.2, 1.2, 1.0, 0.9, 0.7, 0.5],
                    2: [0.8, 1.0, 1.1, 1.1, 1.1, 1.0, 0.8, 0.7, 0.5],
                },
                "_ _ 3": {
                    0: [1.0, 1.1, 1.1, 1.1, 1.0, 0.8, 0.7, 0.5, 0.4],
                    1: [1.0, 1.1, 1.3, 1.3, 1.3, 1.1, 1.0, 0.8, 0.6],
                    2: [1.0, 1.1, 1.3, 1.3, 1.3, 1.2, 1.0, 0.8, 0.6],
                },
                "1 2 _": {
                    0: [1.7, 1.9, 2.0, 1.9, 1.7, 1.5, 1.2, 0.9, 0.7],
                    1: [1.7, 1.9, 2.0, 2.0, 1.8, 1.6, 1.3, 1.0, 0.8],
                    2: [1.3, 1.5, 1.6, 1.7, 1.6, 1.4, 1.2, 0.9, 0.7],
                },
                "1 _ 3": {
                    0: [1.6, 1.7, 1.7, 1.6, 1.4, 1.2, 1.0, 0.7, 0.5],
                    1: [1.5, 1.7, 1.8, 1.8, 1.7, 1.5, 1.2, 1.0, 0.8],
                    2: [1.4, 1.6, 1.7, 1.8, 1.7, 1.5, 1.3, 1.0, 0.8],
                },
                "_ 2 3": {
                    0: [1.4, 1.5, 1.5, 1.4, 1.3, 1.1, 0.9, 0.7, 0.5],
                    1: [1.4, 1.5, 1.6, 1.5, 1.4, 1.2, 1.0, 0.8, 0.6],
                    2: [1.6, 1.8, 2.0, 2.0, 1.9, 1.7, 1.4, 1.1, 0.8],
                },
                "1 2 3": {
                    0: [2.2, 2.3, 2.3, 2.1, 1.9, 1.6, 1.2, 0.9, 0.7],
                    1: [2.4, 2.6, 2.6, 2.6, 2.3, 2.0, 1.6, 1.3, 1.0],
                    2: [2.4, 2.7, 2.9, 2.9, 2.7, 2.4, 2.0, 1.5, 1.2],
                },
            },
        },
        2: {
            "top": {
                "_ _ _": {
                    0: [0.4, 0.6, 0.7, 0.8, 0.9, 1.0, 0.9, 0.8, 0.7],
                    1: [0.3, 0.4, 0.5, 0.6, 0.7, 0.7, 0.6, 0.6, 0.5],
                    2: [0.2, 0.3, 0.3, 0.4, 0.4, 0.4, 0.4, 0.3, 0.3],
                },
                "1 _ _": {
                    0: [0.7, 0.9, 1.1, 1.3, 1.5, 1.5, 1.5, 1.4, 1.2],
                    1: [0.6, 0.7, 0.9, 1.1, 1.2, 1.3, 1.2, 1.1, 0.9],
                    2: [0.4, 0.5, 0.7, 0.8, 0.8, 0.9, 0.8, 0.7, 0.6],
                },
                "_ 2 _": {
                    0: [0.5, 0.7, 0.9, 1.1, 1.2, 1.3, 1.3, 1.2, 1.0],
                    1: [0.6, 0.8, 1.0, 1.1, 1.2, 1.3, 1.2, 1.1, 0.9],
                    2: [0.6, 0.8, 0.9, 1.1, 1.2, 1.2, 1.1, 0.9, 0.8],
                },
                "_ _ 3": {
                    0: [0.4, 0.6, 0.8, 0.9, 1.1, 1.1, 1.2, 1.1, 0.9],
                    1: [0.7, 0.9, 1.1, 1.2, 1.3, 1.3, 1.3, 1.1, 0.9],
                    2: [0.7, 0.9, 1.1, 1.3, 1.4, 1.4, 1.2, 1.1, 0.9],
                },
                "1 2 _": {
                    0: [0.8, 1.1, 1.4, 1.6, 1.9, 2.0, 2.0, 1.9, 1.7],
                    1: [0.9, 1.2, 1.5, 1.8, 2.0, 2.1, 2.0, 1.8, 1.6],
                    2: [0.8, 1.0, 1.3, 1.5, 1.7, 1.7, 1.6, 1.4, 1.2],
                },
                "1 _ 3": {
                    0: [0.6, 0.8, 1.1, 1.3, 1.6, 1.7, 1.8, 1.7, 1.5],
                    1: [0.9, 1.1, 1.4, 1.6, 1.8, 1.8, 1.8, 1.6, 1.4],
                    2: [0.9, 1.1, 1.4, 1.6, 1.8, 1.8, 1.7, 1.5, 1.3],
                },
                "_ 2 3": {
                    0: [0.6, 0.8, 1.0, 1.2, 1.4, 1.5, 1.6, 1.5, 1.4],
                    1: [0.7, 0.9, 1.1, 1.3, 1.5, 1.6, 1.6, 1.5, 1.3],
                    2: [1.0, 1.2, 1.5, 1.8, 2.0, 2.1, 2.0, 1.7, 1.4],
                },
                "1 2 3": {
                    0: [0.8, 1.1, 1.4, 1.7, 2.0, 2.3, 2.4, 2.3, 2.1],
                    1: [1.1, 1.5, 1.8, 2.2, 2.5, 2.7, 2.7, 2.6, 2.3],
                    2: [1.3, 1.7, 2.2, 2.6, 2.9, 3.0, 2.9, 2.6, 2.2],
                },
            },
            "bot": {
                "_ _ _": {
                    0: [0.8, 0.9, 1.0, 1.0, 0.9, 0.8, 0.6, 0.5, 0.4],
                    1: [0.5, 0.6, 0.7, 0.7, 0.7, 0.6, 0.5, 0.4, 0.3],
                    2: [0.3, 0.4, 0.4, 0.5, 0.4, 0.4, 0.3, 0.2, 0.2],
                },
                "1 _ _": {
                    0: [1.3, 1.5, 1.6, 1.6, 1.5, 1.2, 1.0, 0.8, 0.6],
                    1: [1.0, 1.2, 1.3, 1.3, 1.2, 1.0, 0.8, 0.6, 0.5],
                    2: [0.6, 0.8, 0.9, 0.9, 0.8, 0.7, 0.6, 0.5, 0.3],
                },
                "_ 2 _": {
                    0: [1.1, 1.3, 1.3, 1.3, 1.2, 1.0, 0.8, 0.6, 0.4],
                    1: [1.0, 1.2, 1.3, 1.3, 1.2, 1.1, 0.9, 0.7, 0.5],
                    2: [0.8, 1.0, 1.2, 1.2, 1.2, 1.0, 0.9, 0.7, 0.5],
                },
                "_ _ 3": {
                    0: [1.0, 1.2, 1.2, 1.2, 1.0, 0.9, 0.7, 0.5, 0.4],
                    1: [1.0, 1.2, 1.3, 1.4, 1.4, 1.2, 1.0, 0.8, 0.6],
                    2: [1.0, 1.2, 1.3, 1.4, 1.4, 1.2, 1.0, 0.8, 0.6],
                },
                "1 2 _": {
                    0: [1.8, 2.0, 2.1, 2.0, 1.8, 1.5, 1.2, 0.9, 0.7],
                    1: [1.7, 2.0, 2.1, 2.1, 2.0, 1.7, 1.3, 1.0, 0.7],
                    2: [1.3, 1.6, 1.8, 1.8, 1.7, 1.5, 1.2, 0.9, 0.7],
                },
                "1 _ 3": {
                    0: [1.6, 1.8, 1.8, 1.7, 1.5, 1.2, 0.9, 0.7, 0.5],
                    1: [1.5, 1.8, 1.9, 1.9, 1.8, 1.6, 1.3, 1.0, 0.7],
                    2: [1.4, 1.7, 1.9, 1.9, 1.8, 1.6, 1.3, 1.0, 0.7],
                },
                "_ 2 3": {
                    0: [1.5, 1.6, 1.6, 1.5, 1.3, 1.1, 0.9, 0.7, 0.5],
                    1: [1.4, 1.6, 1.7, 1.6, 1.5, 1.3, 1.0, 0.8, 0.6],
                    2: [1.6, 1.9, 2.1, 2.1, 2.0, 1.7, 1.4, 1.1, 0.8],
                },
                "1 2 3": {
                    0: [2.3, 2.4, 2.4, 2.2, 1.9, 1.6, 1.2, 0.9, 0.6],
                    1: [2.5, 2.7, 2.8, 2.7, 2.4, 2.1, 1.7, 1.3, 0.9],
                    2: [2.5, 2.8, 3.1, 3.1, 2.9, 2.5, 2.0, 1.5, 1.1],
                },
            },
        },
        3: {
            "top": {
                "_ _ _": {
                    0: [0.4, 0.6, 0.7, 0.9, 1.0, 1.0, 1.0, 0.9, 0.7],
                    1: [0.3, 0.4, 0.5, 0.6, 0.7, 0.7, 0.7, 0.6, 0.5],
                    2: [0.2, 0.3, 0.4, 0.4, 0.5, 0.5, 0.4, 0.4, 0.3],
                },
                "1 _ _": {
                    0: [0.6, 0.9, 1.1, 1.4, 1.6, 1.7, 1.6, 1.4, 1.2],
                    1: [0.5, 0.7, 1.0, 1.2, 1.3, 1.4, 1.3, 1.1, 0.9],
                    2: [0.4, 0.5, 0.7, 0.8, 0.9, 0.9, 0.8, 0.7, 0.6],
                },
                "_ 2 _": {
                    0: [0.5, 0.7, 0.9, 1.1, 1.3, 1.4, 1.4, 1.2, 1.0],
                    1: [0.6, 0.8, 1.0, 1.2, 1.3, 1.4, 1.3, 1.1, 0.9],
                    2: [0.6, 0.8, 1.0, 1.1, 1.3, 1.3, 1.1, 1.0, 0.8],
                },
                "_ _ 3": {
                    0: [0.4, 0.6, 0.8, 1.0, 1.1, 1.2, 1.2, 1.1, 1.0],
                    1: [0.6, 0.9, 1.1, 1.3, 1.5, 1.5, 1.3, 1.1, 0.9],
                    2: [0.7, 0.9, 1.1, 1.3, 1.5, 1.5, 1.3, 1.1, 0.9],
                },
                "1 2 _": {
                    0: [0.8, 1.0, 1.4, 1.7, 2.0, 2.2, 2.1, 2.0, 1.7],
                    1: [0.9, 1.2, 1.5, 1.8, 2.1, 2.2, 2.1, 1.9, 1.6],
                    2: [0.8, 1.0, 1.3, 1.6, 1.8, 1.9, 1.8, 1.5, 1.2],
                },
                "1 _ 3": {
                    0: [0.6, 0.8, 1.1, 1.4, 1.6, 1.8, 1.9, 1.8, 1.6],
                    1: [0.8, 1.1, 1.4, 1.7, 1.9, 2.0, 1.9, 1.7, 1.5],
                    2: [0.8, 1.1, 1.4, 1.7, 1.9, 2.0, 1.9, 1.6, 1.3],
                },
                "_ 2 3": {
                    0: [0.5, 0.8, 1.0, 1.2, 1.5, 1.6, 1.7, 1.6, 1.4],
                    1: [0.7, 0.9, 1.2, 1.4, 1.6, 1.7, 1.7, 1.6, 1.3],
                    2: [0.9, 1.2, 1.6, 1.9, 2.2, 2.2, 2.1, 1.8, 1.5],
                },
                "1 2 3": {
                    0: [0.7, 1.0, 1.4, 1.8, 2.1, 2.4, 2.6, 2.5, 2.3],
                    1: [1.1, 1.4, 1.9, 2.3, 2.7, 2.9, 2.9, 2.7, 2.4],
                    2: [1.3, 1.7, 2.2, 2.7, 3.1, 3.3, 3.1, 2.7, 2.3],
                },
            },
            "bot": {
                "_ _ _": {
                    0: [0.8, 0.9, 1.0, 1.1, 1.0, 0.8, 0.6, 0.5, 0.3],
                    1: [0.5, 0.7, 0.7, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3],
                    2: [0.3, 0.4, 0.5, 0.5, 0.5, 0.4, 0.3, 0.2, 0.2],
                },
                "1 _ _": {
                    0: [1.3, 1.6, 1.7, 1.7, 1.5, 1.3, 1.0, 0.7, 0.5],
                    1: [1.0, 1.2, 1.4, 1.4, 1.3, 1.1, 0.8, 0.6, 0.4],
                    2: [0.6, 0.8, 0.9, 1.0, 0.9, 0.8, 0.6, 0.5, 0.3],
                },
                "_ 2 _": {
                    0: [1.2, 1.3, 1.5, 1.4, 1.3, 1.1, 0.8, 0.6, 0.4],
                    1: [1.0, 1.3, 1.4, 1.4, 1.3, 1.1, 0.9, 0.6, 0.5],
                    2: [0.9, 1.1, 1.3, 1.3, 1.3, 1.1, 0.9, 0.6, 0.5],
                },
                "_ _ 3": {
                    0: [1.1, 1.2, 1.3, 1.2, 1.1, 0.9, 0.7, 0.5, 0.3],
                    1: [1.0, 1.3, 1.4, 1.5, 1.5, 1.3, 1.0, 0.7, 0.5],
                    2: [1.0, 1.2, 1.4, 1.6, 1.5, 1.3, 1.0, 0.8, 0.5],
                },
                "1 2 _": {
                    0: [1.9, 2.1, 2.3, 2.2, 1.9, 1.6, 1.2, 0.9, 0.6],
                    1: [1.8, 2.1, 2.3, 2.3, 2.1, 1.7, 1.3, 1.0, 0.7],
                    2: [1.4, 1.7, 1.9, 2.0, 1.8, 1.5, 1.2, 0.9, 0.6],
                },
                "1 _ 3": {
                    0: [1.7, 1.9, 2.0, 1.8, 1.5, 1.2, 0.9, 0.7, 0.4],
                    1: [1.6, 1.9, 2.0, 2.1, 1.9, 1.6, 1.3, 0.9, 0.7],
                    2: [1.4, 1.8, 2.0, 2.1, 1.9, 1.6, 1.3, 1.0, 0.7],
                },
                "_ 2 3": {
                    0: [1.6, 1.7, 1.8, 1.6, 1.4, 1.1, 0.9, 0.6, 0.4],
                    1: [1.5, 1.7, 1.8, 1.7, 1.6, 1.3, 1.0, 0.8, 0.5],
                    2: [1.6, 2.0, 2.3, 2.3, 2.2, 1.8, 1.4, 1.0, 0.7],
                },
                "1 2 3": {
                    0: [2.4, 2.6, 2.6, 2.4, 2.0, 1.6, 1.2, 0.8, 0.6],
                    1: [2.6, 2.9, 3.1, 2.9, 2.6, 2.1, 1.6, 1.2, 0.8],
                    2: [2.5, 3.0, 3.3, 3.4, 3.1, 2.5, 2.0, 1.5, 1.0],
                },
            },
        },
        4: {
            "top": {
                "_ _ _": {
                    0: [0.4, 0.5, 0.7, 0.9, 1.1, 1.1, 1.1, 0.9, 0.7],
                    1: [0.3, 0.4, 0.5, 0.7, 0.8, 0.8, 0.7, 0.6, 0.5],
                    2: [0.2, 0.3, 0.4, 0.5, 0.5, 0.5, 0.5, 0.4, 0.3],
                },
                "1 _ _": {
                    0: [0.6, 0.8, 1.1, 1.4, 1.7, 1.8, 1.7, 1.5, 1.2],
                    1: [0.5, 0.7, 1.0, 1.2, 1.4, 1.5, 1.4, 1.2, 0.9],
                    2: [0.4, 0.5, 0.7, 0.9, 1.0, 1.0, 0.9, 0.7, 0.6],
                },
                "_ 2 _": {
                    0: [0.5, 0.7, 0.9, 1.2, 1.4, 1.5, 1.5, 1.3, 1.1],
                    1: [0.5, 0.7, 1.0, 1.2, 1.5, 1.5, 1.4, 1.2, 0.9],
                    2: [0.5, 0.7, 1.0, 1.2, 1.4, 1.4, 1.2, 1.0, 0.7],
                },
                "_ _ 3": {
                    0: [0.4, 0.6, 0.8, 1.0, 1.2, 1.3, 1.3, 1.2, 1.0],
                    1: [0.6, 0.9, 1.1, 1.4, 1.6, 1.6, 1.4, 1.2, 0.9],
                    2: [0.6, 0.9, 1.2, 1.4, 1.6, 1.6, 1.4, 1.1, 0.8],
                },
                "1 2 _": {
                    0: [0.7, 1.0, 1.4, 1.8, 2.1, 2.3, 2.3, 2.1, 1.8],
                    1: [0.8, 1.1, 1.5, 1.9, 2.3, 2.4, 2.3, 2.0, 1.6],
                    2: [0.7, 1.0, 1.4, 1.7, 2.0, 2.1, 1.9, 1.6, 1.2],
                },
                "1 _ 3": {
                    0: [0.5, 0.8, 1.0, 1.4, 1.7, 2.0, 2.1, 1.9, 1.7],
                    1: [0.8, 1.1, 1.4, 1.8, 2.1, 2.2, 2.1, 1.8, 1.5],
                    2: [0.8, 1.1, 1.5, 1.8, 2.1, 2.2, 2.0, 1.7, 1.3],
                },
                "_ 2 3": {
                    0: [0.5, 0.7, 1.0, 1.3, 1.6, 1.8, 1.8, 1.7, 1.5],
                    1: [0.6, 0.9, 1.2, 1.5, 1.7, 1.9, 1.9, 1.7, 1.4],
                    2: [0.9, 1.2, 1.6, 2.0, 2.4, 2.5, 2.3, 1.9, 1.5],
                },
                "1 2 3": {
                    0: [0.7, 1.0, 1.4, 1.8, 2.2, 2.6, 2.8, 2.7, 2.4],
                    1: [1.0, 1.4, 1.9, 2.4, 2.9, 3.1, 3.2, 2.9, 2.4],
                    2: [1.2, 1.7, 2.3, 2.9, 3.4, 3.6, 3.4, 2.9, 2.3],
                },
            },
            "bot": {
                "_ _ _": {
                    0: [0.8, 1.0, 1.1, 1.2, 1.1, 0.9, 0.6, 0.4, 0.3],
                    1: [0.5, 0.7, 0.8, 0.9, 0.8, 0.6, 0.5, 0.3, 0.2],
                    2: [0.3, 0.4, 0.5, 0.6, 0.5, 0.4, 0.3, 0.2, 0.2],
                },
                "1 _ _": {
                    0: [1.4, 1.7, 1.9, 1.9, 1.7, 1.3, 1.0, 0.7, 0.5],
                    1: [1.0, 1.3, 1.5, 1.6, 1.4, 1.1, 0.8, 0.6, 0.4],
                    2: [0.7, 0.8, 1.0, 1.1, 1.0, 0.8, 0.6, 0.4, 0.3],
                },
                "_ 2 _": {
                    0: [1.2, 1.4, 1.6, 1.6, 1.4, 1.1, 0.8, 0.5, 0.4],
                    1: [1.1, 1.3, 1.5, 1.6, 1.4, 1.2, 0.9, 0.6, 0.4],
                    2: [0.9, 1.1, 1.4, 1.5, 1.4, 1.1, 0.9, 0.6, 0.4],
                },
                "_ _ 3": {
                    0: [1.1, 1.3, 1.4, 1.4, 1.1, 0.9, 0.6, 0.4, 0.3],
                    1: [1.0, 1.3, 1.6, 1.7, 1.6, 1.3, 1.0, 0.7, 0.5],
                    2: [1.0, 1.3, 1.6, 1.7, 1.6, 1.3, 1.0, 0.7, 0.5],
                },
                "1 2 _": {
                    0: [2.0, 2.3, 2.5, 2.4, 2.0, 1.6, 1.1, 0.8, 0.5],
                    1: [1.8, 2.2, 2.5, 2.5, 2.2, 1.8, 1.3, 0.9, 0.6],
                    2: [1.4, 1.8, 2.1, 2.2, 2.0, 1.6, 1.2, 0.8, 0.6],
                },
                "1 _ 3": {
                    0: [1.8, 2.1, 2.1, 2.0, 1.6, 1.2, 0.9, 0.6, 0.4],
                    1: [1.7, 2.0, 2.2, 2.3, 2.1, 1.7, 1.3, 0.9, 0.6],
                    2: [1.5, 1.9, 2.2, 2.3, 2.1, 1.7, 1.3, 0.9, 0.6],
                },
                "_ 2 3": {
                    0: [1.7, 1.9, 1.9, 1.8, 1.5, 1.1, 0.8, 0.6, 0.4],
                    1: [1.6, 1.8, 2.0, 1.9, 1.7, 1.4, 1.0, 0.7, 0.5],
                    2: [1.7, 2.1, 2.5, 2.6, 2.3, 1.9, 1.4, 1.0, 0.7],
                },
                "1 2 3": {
                    0: [2.6, 2.8, 2.8, 2.6, 2.1, 1.6, 1.1, 0.8, 0.5],
                    1: [2.7, 3.2, 3.3, 3.2, 2.8, 2.2, 1.6, 1.1, 0.7],
                    2: [2.6, 3.2, 3.6, 3.7, 3.3, 2.6, 1.9, 1.4, 0.9],
                },
            },
        },
        5: {
            "top": {
                "_ _ _": {
                    0: [0.4, 0.5, 0.7, 1.0, 1.2, 1.3, 1.1, 0.9, 0.7],
                    1: [0.3, 0.4, 0.6, 0.7, 0.9, 0.9, 0.8, 0.6, 0.5],
                    2: [0.2, 0.3, 0.4, 0.5, 0.6, 0.6, 0.5, 0.4, 0.3],
                },
                "1 _ _": {
                    0: [0.5, 0.8, 1.1, 1.5, 1.9, 2.0, 1.9, 1.6, 1.2],
                    1: [0.5, 0.7, 1.0, 1.3, 1.6, 1.7, 1.5, 1.2, 0.9],
                    2: [0.3, 0.5, 0.7, 0.9, 1.1, 1.1, 1.0, 0.8, 0.6],
                },
                "_ 2 _": {
                    0: [0.4, 0.6, 0.9, 1.2, 1.5, 1.7, 1.6, 1.4, 1.1],
                    1: [0.5, 0.7, 1.0, 1.3, 1.6, 1.7, 1.5, 1.2, 0.9],
                    2: [0.5, 0.7, 1.0, 1.3, 1.6, 1.6, 1.3, 1.0, 0.7],
                },
                "_ _ 3": {
                    0: [0.3, 0.5, 0.7, 1.0, 1.3, 1.5, 1.5, 1.3, 1.1],
                    1: [0.6, 0.8, 1.1, 1.5, 1.8, 1.8, 1.5, 1.2, 0.9],
                    2: [0.6, 0.8, 1.2, 1.5, 1.8, 1.8, 1.5, 1.1, 0.8],
                },
                "1 2 _": {
                    0: [0.6, 0.9, 1.3, 1.8, 2.3, 2.6, 2.5, 2.3, 1.8],
                    1: [0.7, 1.1, 1.5, 2.0, 2.5, 2.7, 2.5, 2.1, 1.6],
                    2: [0.7, 1.0, 1.4, 1.8, 2.2, 2.3, 2.1, 1.6, 1.2],
                },
                "1 _ 3": {
                    0: [0.5, 0.7, 1.0, 1.4, 1.8, 2.2, 2.3, 2.1, 1.7],
                    1: [0.7, 1.0, 1.4, 1.9, 2.3, 2.4, 2.3, 1.9, 1.5],
                    2: [0.7, 1.1, 1.5, 1.9, 2.4, 2.5, 2.2, 1.7, 1.3],
                },
                "_ 2 3": {
                    0: [0.4, 0.7, 1.0, 1.3, 1.7, 1.9, 2.0, 1.9, 1.6],
                    1: [0.6, 0.8, 1.2, 1.5, 1.9, 2.1, 2.1, 1.8, 1.4],
                    2: [0.8, 1.1, 1.6, 2.1, 2.6, 2.8, 2.5, 2.0, 1.4],
                },
                "1 2 3": {
                    0: [0.6, 0.9, 1.3, 1.8, 2.4, 2.8, 3.0, 2.9, 2.5],
                    1: [0.9, 1.3, 1.9, 2.5, 3.1, 3.5, 3.5, 3.1, 2.5],
                    2: [1.1, 1.6, 2.2, 3.0, 3.7, 4.0, 3.7, 3.0, 2.3],
                },
            },
            "bot": {
                "_ _ _": {
                    0: [0.8, 1.1, 1.3, 1.3, 1.2, 0.9, 0.6, 0.4, 0.3],
                    1: [0.5, 0.7, 0.9, 1.0, 0.9, 0.7, 0.5, 0.3, 0.2],
                    2: [0.3, 0.4, 0.6, 0.6, 0.6, 0.4, 0.3, 0.2, 0.1],
                },
                "1 _ _": {
                    0: [1.4, 1.8, 2.1, 2.1, 1.8, 1.3, 0.9, 0.6, 0.4],
                    1: [1.1, 1.4, 1.7, 1.8, 1.5, 1.2, 0.8, 0.5, 0.3],
                    2: [0.6, 0.9, 1.1, 1.2, 1.1, 0.8, 0.6, 0.4, 0.2],
                },
                "_ 2 _": {
                    0: [1.2, 1.6, 1.8, 1.8, 1.5, 1.1, 0.7, 0.5, 0.3],
                    1: [1.1, 1.4, 1.7, 1.8, 1.6, 1.2, 0.8, 0.5, 0.3],
                    2: [0.8, 1.2, 1.5, 1.7, 1.6, 1.2, 0.8, 0.6, 0.4],
                },
                "_ _ 3": {
                    0: [1.2, 1.5, 1.6, 1.5, 1.2, 0.9, 0.6, 0.4, 0.2],
                    1: [1.0, 1.4, 1.7, 2.0, 1.8, 1.4, 1.0, 0.6, 0.4],
                    2: [0.9, 1.3, 1.7, 2.0, 1.9, 1.4, 1.0, 0.7, 0.4],
                },
                "1 2 _": {
                    0: [2.1, 2.5, 2.7, 2.6, 2.2, 1.6, 1.1, 0.7, 0.4],
                    1: [1.9, 2.4, 2.8, 2.8, 2.4, 1.8, 1.2, 0.8, 0.5],
                    2: [1.4, 1.9, 2.3, 2.5, 2.2, 1.6, 1.1, 0.8, 0.5],
                },
                "1 _ 3": {
                    0: [1.9, 2.3, 2.4, 2.2, 1.7, 1.2, 0.8, 0.5, 0.3],
                    1: [1.7, 2.2, 2.5, 2.6, 2.3, 1.7, 1.2, 0.8, 0.5],
                    2: [1.5, 2.0, 2.4, 2.6, 2.4, 1.8, 1.2, 0.8, 0.5],
                },
                "_ 2 3": {
                    0: [1.8, 2.1, 2.1, 2.0, 1.6, 1.1, 0.8, 0.5, 0.3],
                    1: [1.6, 2.0, 2.2, 2.1, 1.9, 1.4, 1.0, 0.6, 0.4],
                    2: [1.7, 2.3, 2.8, 3.0, 2.6, 1.9, 1.3, 0.9, 0.6],
                },
                "1 2 3": {
                    0: [2.8, 3.1, 3.1, 2.8, 2.2, 1.5, 1.0, 0.7, 0.4],
                    1: [2.9, 3.4, 3.7, 3.5, 3.0, 2.2, 1.5, 1.0, 0.6],
                    2: [2.7, 3.4, 4.0, 4.2, 3.6, 2.7, 1.8, 1.2, 0.8],
                },
            },
        },
        6: {
            "top": {
                "_ _ _": {
                    0: [0.3, 0.5, 0.7, 1.0, 1.3, 1.4, 1.3, 1.0, 0.7],
                    1: [0.2, 0.4, 0.5, 0.8, 1.0, 1.1, 0.9, 0.7, 0.4],
                    2: [0.2, 0.3, 0.4, 0.5, 0.7, 0.7, 0.5, 0.4, 0.2],
                },
                "1 _ _": {
                    0: [0.5, 0.7, 1.1, 1.6, 2.1, 2.3, 2.1, 1.7, 1.2],
                    1: [0.4, 0.6, 0.9, 1.3, 1.8, 1.9, 1.7, 1.3, 0.9],
                    2: [0.3, 0.5, 0.7, 1.0, 1.3, 1.3, 1.1, 0.8, 0.5],
                },
                "_ 2 _": {
                    0: [0.4, 0.6, 0.9, 1.3, 1.7, 1.9, 1.8, 1.5, 1.1],
                    1: [0.4, 0.6, 1.0, 1.4, 1.8, 2.0, 1.7, 1.3, 0.9],
                    2: [0.4, 0.7, 1.0, 1.4, 1.8, 1.8, 1.4, 1.0, 0.7],
                },
                "_ _ 3": {
                    0: [0.3, 0.5, 0.7, 1.0, 1.4, 1.7, 1.7, 1.4, 1.1],
                    1: [0.5, 0.8, 1.1, 1.6, 2.0, 2.1, 1.6, 1.3, 0.9],
                    2: [0.5, 0.8, 1.2, 1.6, 2.1, 2.1, 1.6, 1.1, 0.7],
                },
                "1 2 _": {
                    0: [0.5, 0.8, 1.3, 1.8, 2.5, 2.9, 2.8, 2.4, 1.9],
                    1: [0.6, 1.0, 1.5, 2.1, 2.8, 3.1, 2.8, 2.2, 1.6],
                    2: [0.6, 0.9, 1.3, 1.9, 2.5, 2.6, 2.3, 1.7, 1.1],
                },
                "1 _ 3": {
                    0: [0.4, 0.6, 0.9, 1.4, 1.9, 2.4, 2.6, 2.3, 1.8],
                    1: [0.6, 0.9, 1.4, 2.0, 2.6, 2.8, 2.5, 2.1, 1.5],
                    2: [0.6, 1.0, 1.4, 2.0, 2.7, 2.8, 2.4, 1.8, 1.2],
                },
                "_ 2 3": {
                    0: [0.4, 0.6, 0.9, 1.3, 1.8, 2.2, 2.3, 2.1, 1.7],
                    1: [0.5, 0.8, 1.1, 1.6, 2.1, 2.3, 2.3, 1.9, 1.5],
                    2: [0.7, 1.0, 1.6, 2.2, 2.9, 3.2, 2.7, 2.0, 1.4],
                },
                "1 2 3": {
                    0: [0.5, 0.8, 1.2, 1.8, 2.5, 3.1, 3.4, 3.2, 2.7],
                    1: [0.8, 1.2, 1.8, 2.6, 3.4, 3.9, 3.9, 3.3, 2.6],
                    2: [0.9, 1.4, 2.2, 3.1, 4.1, 4.5, 4.1, 3.2, 2.3],
                },
            },
            "bot": {
                "_ _ _": {
                    0: [0.8, 1.1, 1.4, 1.6, 1.3, 0.9, 0.6, 0.3, 0.2],
                    1: [0.5, 0.8, 1.0, 1.2, 1.0, 0.7, 0.4, 0.3, 0.2],
                    2: [0.3, 0.4, 0.6, 0.8, 0.7, 0.5, 0.3, 0.2, 0.1],
                },
                "1 _ _": {
                    0: [1.4, 1.9, 2.3, 2.4, 2.0, 1.3, 0.8, 0.5, 0.3],
                    1: [1.0, 1.5, 1.9, 2.1, 1.7, 1.1, 0.7, 0.4, 0.3],
                    2: [0.6, 0.9, 1.2, 1.5, 1.3, 0.8, 0.5, 0.3, 0.2],
                },
                "_ 2 _": {
                    0: [1.3, 1.7, 2.0, 2.0, 1.6, 1.1, 0.7, 0.4, 0.2],
                    1: [1.1, 1.5, 1.9, 2.1, 1.8, 1.2, 0.8, 0.5, 0.3],
                    2: [0.8, 1.2, 1.6, 2.0, 1.8, 1.2, 0.8, 0.5, 0.3],
                },
                "_ _ 3": {
                    0: [1.2, 1.6, 1.8, 1.7, 1.3, 0.8, 0.5, 0.3, 0.2],
                    1: [1.0, 1.4, 1.9, 2.3, 2.1, 1.4, 0.9, 0.5, 0.3],
                    2: [0.9, 1.3, 1.9, 2.4, 2.2, 1.4, 0.9, 0.6, 0.3],
                },
                "1 2 _": {
                    0: [2.2, 2.7, 3.1, 3.0, 2.3, 1.5, 0.9, 0.6, 0.3],
                    1: [1.9, 2.6, 3.1, 3.3, 2.7, 1.8, 1.1, 0.7, 0.4],
                    2: [1.4, 2.0, 2.6, 2.9, 2.5, 1.6, 1.0, 0.6, 0.4],
                },
                "1 _ 3": {
                    0: [2.0, 2.5, 2.7, 2.4, 1.7, 1.1, 0.7, 0.4, 0.2],
                    1: [1.8, 2.4, 2.8, 3.0, 2.6, 1.7, 1.1, 0.7, 0.4],
                    2: [1.4, 2.1, 2.7, 3.1, 2.7, 1.8, 1.1, 0.7, 0.4],
                },
                "_ 2 3": {
                    0: [1.9, 2.3, 2.4, 2.2, 1.7, 1.1, 0.7, 0.4, 0.2],
                    1: [1.7, 2.2, 2.5, 2.5, 2.1, 1.4, 0.9, 0.5, 0.3],
                    2: [1.6, 2.4, 3.1, 3.5, 2.9, 1.9, 1.2, 0.7, 0.4],
                },
                "1 2 3": {
                    0: [3.0, 3.5, 3.6, 3.1, 2.2, 1.4, 0.9, 0.5, 0.3],
                    1: [3.0, 3.8, 4.2, 4.0, 3.3, 2.2, 1.4, 0.8, 0.5],
                    2: [2.7, 3.7, 4.5, 4.9, 4.0, 2.6, 1.7, 1.0, 0.6],
                },
            },
        },
        7: {
            "top": {
                "_ _ _": {
                    0: [0.2, 0.4, 0.7, 1.0, 1.5, 1.7, 1.4, 1.0, 0.6],
                    1: [0.2, 0.3, 0.5, 0.8, 1.2, 1.3, 1.0, 0.6, 0.4],
                    2: [0.1, 0.2, 0.4, 0.5, 0.8, 0.8, 0.6, 0.3, 0.2],
                },
                "1 _ _": {
                    0: [0.4, 0.6, 1.0, 1.6, 2.4, 2.7, 2.3, 1.7, 1.2],
                    1: [0.3, 0.5, 0.9, 1.4, 2.0, 2.3, 1.8, 1.3, 0.8],
                    2: [0.2, 0.4, 0.6, 1.0, 1.5, 1.6, 1.2, 0.7, 0.4],
                },
                "_ 2 _": {
                    0: [0.3, 0.5, 0.8, 1.2, 1.9, 2.3, 2.0, 1.5, 1.1],
                    1: [0.3, 0.6, 0.9, 1.4, 2.1, 2.3, 1.8, 1.3, 0.8],
                    2: [0.3, 0.6, 0.9, 1.4, 2.1, 2.2, 1.5, 0.9, 0.6],
                },
                "_ _ 3": {
                    0: [0.2, 0.4, 0.6, 1.0, 1.5, 2.0, 1.9, 1.5, 1.1],
                    1: [0.4, 0.7, 1.1, 1.6, 2.4, 2.5, 1.8, 1.3, 0.8],
                    2: [0.4, 0.7, 1.1, 1.7, 2.5, 2.5, 1.7, 1.1, 0.6],
                },
                "1 2 _": {
                    0: [0.4, 0.7, 1.1, 1.8, 2.7, 3.4, 3.2, 2.6, 1.9],
                    1: [0.5, 0.8, 1.3, 2.1, 3.2, 3.6, 3.1, 2.3, 1.6],
                    2: [0.4, 0.8, 1.2, 1.9, 2.9, 3.2, 2.5, 1.7, 1.0],
                },
                "1 _ 3": {
                    0: [0.3, 0.5, 0.8, 1.3, 2.0, 2.8, 3.0, 2.5, 1.8],
                    1: [0.5, 0.8, 1.3, 2.0, 3.1, 3.3, 2.9, 2.2, 1.5],
                    2: [0.5, 0.8, 1.4, 2.1, 3.1, 3.4, 2.6, 1.7, 1.1],
                },
                "_ 2 3": {
                    0: [0.3, 0.5, 0.8, 1.3, 2.0, 2.5, 2.6, 2.3, 1.7],
                    1: [0.4, 0.7, 1.1, 1.6, 2.5, 2.8, 2.7, 2.1, 1.4],
                    2: [0.5, 0.9, 1.5, 2.3, 3.4, 3.9, 3.1, 2.0, 1.2],
                },
                "1 2 3": {
                    0: [0.4, 0.6, 1.1, 1.7, 2.6, 3.5, 3.9, 3.6, 2.8],
                    1: [0.6, 1.0, 1.6, 2.6, 3.9, 4.5, 4.4, 3.6, 2.6],
                    2: [0.7, 1.2, 2.0, 3.1, 4.7, 5.4, 4.5, 3.3, 2.1],
                },
            },
            "bot": {
                "_ _ _": {
                    0: [0.8, 1.2, 1.6, 1.9, 1.5, 0.8, 0.4, 0.2, 0.1],
                    1: [0.5, 0.8, 1.1, 1.4, 1.2, 0.6, 0.3, 0.2, 0.1],
                    2: [0.2, 0.4, 0.7, 1.0, 0.8, 0.4, 0.2, 0.1, 0.1],
                },
                "1 _ _": {
                    0: [1.4, 2.0, 2.6, 3.0, 2.3, 1.2, 0.7, 0.4, 0.2],
                    1: [1.0, 1.5, 2.1, 2.5, 2.0, 1.1, 0.6, 0.3, 0.2],
                    2: [0.5, 0.9, 1.4, 1.8, 1.5, 0.8, 0.4, 0.2, 0.1],
                },
                "_ 2 _": {
                    0: [1.3, 1.8, 2.3, 2.4, 1.8, 0.9, 0.5, 0.3, 0.1],
                    1: [1.0, 1.5, 2.1, 2.6, 2.1, 1.1, 0.6, 0.3, 0.2],
                    2: [0.7, 1.1, 1.8, 2.6, 2.2, 1.1, 0.7, 0.4, 0.2],
                },
                "_ _ 3": {
                    0: [1.3, 1.8, 2.2, 2.0, 1.5, 0.8, 0.4, 0.2, 0.1],
                    1: [1.0, 1.5, 2.1, 2.9, 2.5, 1.3, 0.7, 0.4, 0.2],
                    2: [0.8, 1.3, 2.0, 3.0, 2.6, 1.4, 0.8, 0.4, 0.2],
                },
                "1 2 _": {
                    0: [2.2, 3.0, 3.6, 3.5, 2.5, 1.3, 0.8, 0.4, 0.2],
                    1: [1.9, 2.7, 3.6, 4.0, 3.0, 1.6, 0.9, 0.5, 0.3],
                    2: [1.2, 2.0, 2.9, 3.6, 2.9, 1.5, 0.8, 0.5, 0.2],
                },
                "1 _ 3": {
                    0: [2.1, 2.8, 3.3, 2.8, 1.7, 0.9, 0.5, 0.3, 0.1],
                    1: [1.8, 2.6, 3.2, 3.7, 3.1, 1.6, 0.9, 0.5, 0.3],
                    2: [1.3, 2.1, 3.0, 3.8, 3.1, 1.6, 0.9, 0.5, 0.3],
                },
                "_ 2 3": {
                    0: [2.0, 2.6, 2.9, 2.6, 1.7, 0.9, 0.5, 0.3, 0.1],
                    1: [1.7, 2.4, 3.0, 3.0, 2.5, 1.3, 0.7, 0.4, 0.2],
                    2: [1.5, 2.4, 3.6, 4.3, 3.3, 1.7, 1.0, 0.5, 0.3],
                },
                "1 2 3": {
                    0: [3.3, 4.0, 4.1, 3.5, 2.3, 1.2, 0.7, 0.4, 0.2],
                    1: [3.1, 4.2, 4.9, 4.8, 3.7, 2.0, 1.1, 0.6, 0.3],
                    2: [2.6, 3.9, 5.2, 5.9, 4.5, 2.4, 1.3, 0.7, 0.4],
                },
            },
        },
        8: {
            "top": {
                "_ _ _": {
                    0: [0.2, 0.3, 0.6, 1.0, 1.9, 2.2, 1.5, 0.9, 0.6],
                    1: [0.1, 0.2, 0.4, 0.7, 1.4, 1.6, 1.0, 0.6, 0.3],
                    2: [0.1, 0.2, 0.3, 0.5, 1.0, 1.1, 0.6, 0.3, 0.1],
                },
                "1 _ _": {
                    0: [0.2, 0.4, 0.8, 1.5, 2.8, 3.4, 2.6, 1.7, 1.0],
                    1: [0.2, 0.4, 0.7, 1.3, 2.4, 2.9, 2.0, 1.2, 0.7],
                    2: [0.2, 0.3, 0.5, 1.0, 1.8, 2.1, 1.3, 0.7, 0.3],
                },
                "_ 2 _": {
                    0: [0.2, 0.4, 0.6, 1.1, 2.2, 2.8, 2.3, 1.6, 1.0],
                    1: [0.2, 0.4, 0.8, 1.3, 2.5, 2.9, 2.0, 1.2, 0.7],
                    2: [0.2, 0.4, 0.8, 1.4, 2.7, 2.8, 1.5, 0.8, 0.4],
                },
                "_ _ 3": {
                    0: [0.2, 0.3, 0.5, 0.9, 1.8, 2.4, 2.3, 1.6, 1.0],
                    1: [0.3, 0.5, 0.9, 1.6, 3.1, 3.2, 2.0, 1.3, 0.7],
                    2: [0.3, 0.5, 0.9, 1.6, 3.2, 3.3, 1.7, 0.9, 0.4],
                },
                "1 2 _": {
                    0: [0.3, 0.5, 0.9, 1.6, 3.1, 4.1, 3.7, 2.8, 1.8],
                    1: [0.3, 0.6, 1.1, 2.0, 3.7, 4.5, 3.5, 2.4, 1.4],
                    2: [0.3, 0.6, 1.0, 1.8, 3.5, 4.0, 2.7, 1.6, 0.8],
                },
                "1 _ 3": {
                    0: [0.2, 0.3, 0.6, 1.1, 2.1, 3.3, 3.6, 2.8, 1.8],
                    1: [0.3, 0.6, 1.1, 2.0, 3.8, 4.2, 3.3, 2.3, 1.4],
                    2: [0.3, 0.6, 1.1, 2.0, 3.8, 4.3, 2.8, 1.6, 0.8],
                },
                "_ 2 3": {
                    0: [0.2, 0.3, 0.6, 1.1, 2.1, 3.1, 3.2, 2.6, 1.7],
                    1: [0.3, 0.5, 0.9, 1.6, 3.0, 3.4, 3.2, 2.2, 1.3],
                    2: [0.3, 0.7, 1.2, 2.1, 4.0, 4.9, 3.5, 1.9, 1.0],
                },
                "1 2 3": {
                    0: [0.2, 0.4, 0.8, 1.5, 2.8, 4.1, 4.6, 4.0, 3.0],
                    1: [0.4, 0.7, 1.4, 2.4, 4.6, 5.6, 5.2, 3.9, 2.6],
                    2: [0.5, 0.9, 1.6, 2.9, 5.6, 6.8, 5.1, 3.3, 1.9],
                },
            },
            "bot": {
                "_ _ _": {
                    0: [0.7, 1.1, 1.8, 2.5, 1.8, 0.6, 0.3, 0.1, 0.1],
                    1: [0.4, 0.7, 1.2, 1.9, 1.4, 0.5, 0.2, 0.1, 0.0],
                    2: [0.2, 0.4, 0.7, 1.3, 1.1, 0.3, 0.2, 0.1, 0.0],
                },
                "1 _ _": {
                    0: [1.3, 2.1, 3.1, 3.8, 2.6, 0.9, 0.4, 0.2, 0.1],
                    1: [0.8, 1.5, 2.4, 3.4, 2.4, 0.8, 0.4, 0.2, 0.1],
                    2: [0.4, 0.8, 1.6, 2.5, 1.8, 0.6, 0.3, 0.1, 0.1],
                },
                "_ 2 _": {
                    0: [1.2, 1.9, 2.7, 3.1, 2.0, 0.7, 0.3, 0.1, 0.1],
                    1: [0.8, 1.5, 2.4, 3.4, 2.5, 0.8, 0.4, 0.2, 0.1],
                    2: [0.5, 1.0, 1.9, 3.5, 2.8, 0.9, 0.4, 0.2, 0.1],
                },
                "_ _ 3": {
                    0: [1.2, 1.9, 2.7, 2.5, 1.7, 0.6, 0.3, 0.1, 0.1],
                    1: [0.9, 1.5, 2.4, 3.9, 3.2, 1.0, 0.5, 0.2, 0.1],
                    2: [0.5, 1.1, 2.1, 4.1, 3.4, 1.0, 0.5, 0.2, 0.1],
                },
                "1 2 _": {
                    0: [2.2, 3.3, 4.2, 4.4, 2.8, 0.9, 0.4, 0.2, 0.1],
                    1: [1.7, 2.9, 4.1, 5.1, 3.5, 1.1, 0.5, 0.3, 0.1],
                    2: [1.0, 2.0, 3.3, 4.7, 3.5, 1.1, 0.5, 0.2, 0.1],
                },
                "1 _ 3": {
                    0: [2.2, 3.2, 4.1, 3.3, 1.8, 0.6, 0.3, 0.1, 0.1],
                    1: [1.7, 2.7, 3.9, 4.9, 3.8, 1.2, 0.6, 0.3, 0.1],
                    2: [1.0, 2.0, 3.4, 5.1, 3.8, 1.2, 0.6, 0.3, 0.1],
                },
                "_ 2 3": {
                    0: [2.1, 3.0, 3.6, 3.3, 1.8, 0.6, 0.3, 0.1, 0.1],
                    1: [1.6, 2.6, 3.7, 4.0, 3.0, 0.9, 0.4, 0.2, 0.1],
                    2: [1.2, 2.3, 4.2, 5.8, 3.9, 1.3, 0.6, 0.3, 0.1],
                },
                "1 2 3": {
                    0: [3.5, 4.6, 5.0, 4.2, 2.2, 0.8, 0.4, 0.2, 0.1],
                    1: [3.1, 4.6, 5.9, 6.2, 4.4, 1.4, 0.7, 0.3, 0.1],
                    2: [2.3, 4.0, 6.1, 7.7, 5.3, 1.7, 0.8, 0.4, 0.2],
                },
            },
        },
        9: {
            "top": {
                "_ _ _": {
                    0: [0.1, 0.2, 0.3, 0.7, 2.4, 2.9, 1.6, 0.8, 0.4],
                    1: [0.1, 0.1, 0.3, 0.6, 1.9, 2.2, 1.0, 0.5, 0.2],
                    2: [0.0, 0.1, 0.2, 0.4, 1.4, 1.5, 0.5, 0.2, 0.1],
                },
                "1 _ _": {
                    0: [0.1, 0.2, 0.5, 1.1, 3.4, 4.6, 2.9, 1.6, 0.8],
                    1: [0.1, 0.2, 0.5, 1.0, 3.1, 3.9, 2.2, 1.0, 0.4],
                    2: [0.1, 0.2, 0.3, 0.7, 2.4, 2.9, 1.3, 0.4, 0.1],
                },
                "_ 2 _": {
                    0: [0.1, 0.2, 0.4, 0.8, 2.6, 3.7, 2.7, 1.5, 0.8],
                    1: [0.1, 0.2, 0.5, 1.0, 3.3, 4.0, 2.2, 1.0, 0.5],
                    2: [0.1, 0.2, 0.5, 1.1, 3.7, 4.0, 1.4, 0.5, 0.2],
                },
                "_ _ 3": {
                    0: [0.1, 0.2, 0.3, 0.7, 2.3, 3.1, 2.9, 1.6, 0.8],
                    1: [0.1, 0.3, 0.6, 1.2, 4.3, 4.4, 2.3, 1.1, 0.5],
                    2: [0.1, 0.3, 0.6, 1.3, 4.4, 4.6, 1.4, 0.5, 0.2],
                },
                "1 2 _": {
                    0: [0.1, 0.3, 0.6, 1.2, 3.6, 5.3, 4.4, 2.9, 1.6],
                    1: [0.1, 0.3, 0.7, 1.4, 4.6, 6.1, 4.0, 2.3, 1.1],
                    2: [0.1, 0.3, 0.7, 1.4, 4.5, 5.5, 2.9, 1.3, 0.4],
                },
                "1 _ 3": {
                    0: [0.1, 0.2, 0.4, 0.8, 2.3, 4.2, 4.6, 3.0, 1.7],
                    1: [0.1, 0.3, 0.7, 1.5, 5.0, 5.7, 4.0, 2.3, 1.1],
                    2: [0.2, 0.3, 0.7, 1.5, 5.0, 5.9, 2.9, 1.3, 0.4],
                },
                "_ 2 3": {
                    0: [0.1, 0.2, 0.4, 0.8, 2.4, 4.0, 4.0, 2.9, 1.6],
                    1: [0.1, 0.3, 0.6, 1.2, 3.9, 4.6, 3.9, 2.3, 1.1],
                    2: [0.2, 0.3, 0.7, 1.6, 5.1, 6.9, 3.9, 1.4, 0.5],
                },
                "1 2 3": {
                    0: [0.1, 0.2, 0.5, 1.0, 2.9, 5.2, 5.7, 4.6, 3.1],
                    1: [0.2, 0.4, 0.8, 1.8, 5.7, 7.3, 6.2, 4.2, 2.4],
                    2: [0.2, 0.5, 1.0, 2.1, 6.9, 9.1, 5.7, 3.1, 1.4],
                },
            },
            "bot": {
                "_ _ _": {
                    0: [0.5, 1.0, 2.0, 3.6, 2.3, 0.0, 0.0, 0.0, 0.0],
                    1: [0.2, 0.6, 1.3, 2.8, 1.9, 0.0, 0.0, 0.0, 0.0],
                    2: [0.1, 0.2, 0.6, 1.9, 1.5, 0.0, 0.0, 0.0, 0.0],
                },
                "1 _ _": {
                    0: [1.0, 2.0, 3.6, 5.4, 3.1, 0.0, 0.0, 0.0, 0.0],
                    1: [0.6, 1.3, 2.8, 4.8, 3.0, 0.0, 0.0, 0.0, 0.0],
                    2: [0.2, 0.5, 1.7, 3.7, 2.4, 0.0, 0.0, 0.0, 0.0],
                },
                "_ 2 _": {
                    0: [1.0, 1.9, 3.3, 4.3, 2.5, 0.0, 0.0, 0.0, 0.0],
                    1: [0.6, 1.3, 2.7, 5.0, 3.2, 0.0, 0.0, 0.0, 0.0],
                    2: [0.2, 0.6, 1.8, 5.2, 3.9, 0.0, 0.0, 0.0, 0.0],
                },
                "_ _ 3": {
                    0: [1.1, 2.0, 3.6, 3.5, 2.1, 0.0, 0.0, 0.0, 0.0],
                    1: [0.6, 1.4, 2.9, 5.8, 4.5, 0.0, 0.0, 0.0, 0.0],
                    2: [0.2, 0.7, 1.8, 6.1, 4.7, 0.0, 0.0, 0.0, 0.0],
                },
                "1 2 _": {
                    0: [2.0, 3.6, 5.2, 6.0, 3.2, 0.0, 0.0, 0.0, 0.0],
                    1: [1.3, 2.9, 4.8, 7.2, 4.3, 0.0, 0.0, 0.0, 0.0],
                    2: [0.6, 1.7, 3.7, 6.8, 4.4, 0.0, 0.0, 0.0, 0.0],
                },
                "1 _ 3": {
                    0: [2.1, 3.7, 5.5, 4.3, 2.1, 0.0, 0.0, 0.0, 0.0],
                    1: [1.4, 2.9, 4.9, 7.1, 5.0, 0.0, 0.0, 0.0, 0.0],
                    2: [0.6, 1.7, 3.7, 7.4, 5.0, 0.0, 0.0, 0.0, 0.0],
                },
                "_ 2 3": {
                    0: [2.0, 3.5, 4.7, 4.3, 2.0, 0.0, 0.0, 0.0, 0.0],
                    1: [1.4, 2.8, 4.8, 5.7, 4.0, 0.0, 0.0, 0.0, 0.0],
                    2: [0.7, 1.8, 5.1, 8.4, 4.7, 0.0, 0.0, 0.0, 0.0],
                },
                "1 2 3": {
                    0: [3.7, 5.4, 6.4, 5.3, 2.4, 0.0, 0.0, 0.0, 0.0],
                    1: [3.0, 5.1, 7.3, 8.6, 5.4, 0.0, 0.0, 0.0, 0.0],
                    2: [1.8, 3.9, 7.0, 10.9, 6.4, 0.0, 0.0, 0.0, 0.0],
                },
            },
        },
    }


    def __init__(self, *args, **kwargs):
        xbmc.log("MLB Monitor init")
        self.monitor = xbmc.Monitor()

    # override the onSettingsChanged method to detect if a new MLB monitor has started (so we can close this one)
    def onSettingsChanged(self):
        xbmc.log("MLB Monitor detected settings changed")
        settings = xbmcaddon.Addon(id='plugin.video.mlbtv')
        new_mlb_monitor_started = str(settings.getSetting(id="mlb_monitor_started"))
        if self.mlb_monitor_started != new_mlb_monitor_started:
            xbmc.log("MLB Monitor from " + self.mlb_monitor_started + " closing due to another monitor starting on " + new_mlb_monitor_started)
            self.mlb_monitor_started = ''

    def skip_monitor(self, skip_type, game_pk, broadcast_start_timestamp, is_live, start_inning, start_inning_half):
        xbmc.log("Skip monitor for " + game_pk + " starting")

        self.mlb_monitor_started = str(datetime.now())
        settings.setSetting(id='mlb_monitor_started', value=self.mlb_monitor_started)
        monitor_name = 'Skip monitor for ' + game_pk
        xbmc.log(monitor_name + ' started at ' + self.mlb_monitor_started)

        # initialize player to monitor play time
        player = xbmc.Player()
        last_time = None

        # fetch skip markers
        self.skip_to_players = None
        skip_markers, self.skip_to_players = self.get_skip_markers(skip_type, game_pk, broadcast_start_timestamp, monitor_name, self.skip_to_players, 0, start_inning, start_inning_half)
        xbmc.log(monitor_name + ' skip markers : ' + str(skip_markers))

        while not self.monitor.abortRequested():
            if self.monitor.waitForAbort(1):
                xbmc.log(monitor_name + " aborting")
                break
            elif len(skip_markers) == 0:
                xbmc.log(monitor_name + " closing due to no more skip markers")
                break
            elif self.stream_started == True and not xbmc.getCondVisibility("Player.HasMedia"):
                xbmc.log(monitor_name + " closing due to stream stopped")
                break
            elif self.mlb_monitor_started == '':
                xbmc.log(monitor_name + " closing due to reset")
                break
            elif xbmc.getCondVisibility("Player.HasMedia"):
                if self.stream_started == False:
                    xbmc.log(monitor_name + ' detected stream start')
                    self.stream_started = True
                    # just for fun, we can log our stream duration, to compare it against skip time detected
                    if start_inning == 0:
                        try:
                            total_stream_time = player.getTotalTime()
                            xbmc.log(monitor_name + ' total stream time ' + str(timedelta(seconds=total_stream_time)))
                        except:
                            pass
                current_time = player.getTime()
                # make sure we're not paused, and current time is valid (less than 10 hours) -- sometimes Kodi was returning a crazy large current time as the stream was starting
                if current_time > 0 and current_time != last_time and current_time < 36000:
                    last_time = current_time
                    # remove any past skip markers so user can seek backward freely
                    while len(skip_markers) > 0 and current_time > skip_markers[0][1]:
                        xbmc.log(monitor_name + " removed skip marker at " + str(skip_markers[0][1]) + ", before current time " + str(current_time))
                        skip_markers.pop(0)
                    # seek to end of break if we fall within skip marker range, then remove marker so user can seek backward freely
                    if len(skip_markers) > 0 and current_time >= skip_markers[0][0] and current_time < skip_markers[0][1]:
                        xbmc.log(monitor_name + " processed skip marker at " + str(skip_markers[0][1]))
                        player.seekTime(skip_markers[0][1])
                        skip_markers.pop(0)
                        # since we just processed a skip marker, we can delay further processing a little bit
                        xbmc.sleep(2000)
                    # if we've run out of skip markers and it's a live event and we're skipping things, check for more
                    if len(skip_markers) == 0 and is_live == True and skip_type > 0:
                        # refresh current time, and look ahead slightly
                        current_time = player.getTime() + 10
                        xbmc.log(monitor_name + ' refreshing skip markers from ' + str(current_time))
                        skip_markers, self.players = self.get_skip_markers(skip_type, game_pk, broadcast_start_timestamp, monitor_name, self.skip_to_players, current_time)
                        xbmc.log(monitor_name + ' refreshed skip markers : ' + str(skip_markers))
            else:
                if self.stream_started == False:
                    xbmc.log(monitor_name + " waiting for stream to start")
                    self.stream_start_tries -= 1
                    if self.stream_start_tries < 1:
                        xbmc.log(monitor_name + " closing due to stream not starting")
                        break

        xbmc.log(monitor_name + " closed")


    # get the gameday data, which contains the event timestamps
    def get_gameday_data(self, game_pk, monitor_name):
        xbmc.log(monitor_name + ' getting gameday data')

        url = API_URL + '/api/v1.1/game/' + game_pk + '/feed/live'
        headers = {
            'User-agent': UA_PC,
            'Origin': 'https://www.mlb.com',
            'Accept-Encoding': 'gzip, deflate, br',
            'Content-type': 'application/json'
        }
        r = requests.get(url, headers=headers, verify=self.verify)
        json_source = r.json()
        return json_source


    # calculate skip markers from gameday events
    def get_skip_markers(self, skip_type, game_pk, broadcast_start_timestamp, monitor_name, skip_to_players, current_time=0, start_inning=0, start_inning_half='top'):
        xbmc.log(monitor_name + ' getting skip markers for skip type ' + str(skip_type))
        if current_time > 0:
            xbmc.log(monitor_name + ' searching beyond ' + str(current_time))

        # initialize our list of skip times
        skip_markers = []

        json_source = self.get_gameday_data(game_pk, monitor_name)

        # calculate total skip time (for fun)
        total_skip_time = 0

        # make sure we have play data
        if 'liveData' in json_source and 'plays' in json_source['liveData'] and 'allPlays' in json_source['liveData']['plays']:
            # assume the game starts in a break
            break_start = 0

            # keep track of inning, if skipping inning breaks only
            previous_inning = 0
            previous_inning_half = None

            # make sure start inning is valid
            if start_inning > 0:
                last_play_index = len(json_source['liveData']['plays']['allPlays']) - 1
                final_inning = json_source['liveData']['plays']['allPlays'][last_play_index]['about']['inning']
                if start_inning >= final_inning:
                    if start_inning > final_inning:
                        start_inning = final_inning
                    final_inning_half = json_source['liveData']['plays']['allPlays'][last_play_index]['about']['halfInning']
                    if start_inning_half == 'bottom' and final_inning_half == 'top':
                        start_inning_half = final_inning_half

            # if skip_type is for specific batters or pitchers, present another dialog to select player name(s)
            if skip_type == 3 and skip_to_players is None:
                xbmc.log(monitor_name + ' prompting for player selection')
                skip_to_players = []
                all_batters = []
                all_pitchers = []
                for play in json_source['liveData']['plays']['allPlays']:
                    current_inning = play['about']['inning']
                    current_inning_half = play['about']['halfInning']
                    # make sure we're past our start inning
                    if current_inning > start_inning or (current_inning == start_inning and (current_inning_half == start_inning_half or current_inning_half == 'bottom')):
                        if 'matchup' in play:
                            if 'batter' in play['matchup'] and 'fullName' in play['matchup']['batter'] and play['matchup']['batter']['fullName'] not in all_batters:
                                all_batters.append(play['matchup']['batter']['fullName'])
                            if 'pitcher' in play['matchup'] and 'fullName' in play['matchup']['pitcher'] and play['matchup']['pitcher']['fullName'] not in all_pitchers and play['matchup']['pitcher']['fullName'] not in all_batters:
                                all_pitchers.append(play['matchup']['pitcher']['fullName'])
                all_players = all_batters + all_pitchers
                player_index = 0
                while player_index > -1:
                    dialog = xbmcgui.Dialog()
                    player_index = dialog.select(LOCAL_STRING(30422), all_players)
                    if player_index > -1:
                        xbmc.log(monitor_name + ' specified player ' + all_players[player_index])
                        skip_to_players.append(all_players[player_index])

            # loop through all plays
            for play in json_source['liveData']['plays']['allPlays']:
                # exit loop after found inning, if not skipping any breaks
                if skip_type == 0 and len(skip_markers) == 1:
                    break
                current_inning = play['about']['inning']
                current_inning_half = play['about']['halfInning']
                # make sure we're past our start inning
                if current_inning > start_inning or (current_inning == start_inning and (current_inning_half == start_inning_half or current_inning_half == 'bottom')):
                    # check for player, if specified
                    if skip_type == 3 and skip_to_players is not None and len(skip_to_players) > 0:
                        skip_to_player_found = False
                        for player in skip_to_players:
                            if 'matchup' in play and 'batter' in play['matchup'] and 'fullName' in play['matchup']['batter'] and 'pitcher' in play['matchup'] and 'fullName' in play['matchup']['pitcher'] and (player == play['matchup']['batter']['fullName'] or player == play['matchup']['pitcher']['fullName']):
                                xbmc.log(monitor_name + ' found specified player ' + player + ' in ' + play['matchup']['pitcher']['fullName'] + ' vs ' + play['matchup']['batter']['fullName'])
                                skip_to_player_found = True
                                break
                        if skip_to_player_found is False:
                            if 'matchup' in play and 'batter' in play['matchup'] and 'fullName' in play['matchup']['batter'] and 'pitcher' in play['matchup'] and 'fullName' in play['matchup']['pitcher']:
                                xbmc.log(monitor_name + ' did not find specified player in ' + play['matchup']['pitcher']['fullName'] + ' vs ' + play['matchup']['batter']['fullName'])
                            else:
                                xbmc.log(monitor_name + ' did not find specified player')
                            continue

                    # loop through events within each play
                    for index, playEvent in enumerate(play['playEvents']):
                        # default to longer action end padding
                        event_end_padding = self.ACTION_END_PADDING
                        # always exclude break types
                        if 'event' in playEvent['details'] and playEvent['details']['event'] in self.BREAK_TYPES:
                            # if we're in the process of skipping inning breaks, treat the first break type we find as another inning break
                            if skip_type == 1 and previous_inning > 0:
                                break_start = (parse(playEvent['startTime']) - broadcast_start_timestamp).total_seconds() + event_end_padding
                                previous_inning = 0
                            continue
                        else:
                            # for non-action plays, use shorter pitch end padding instead
                            if index < (len(play['playEvents'])-1) and ('details' not in playEvent or 'event' not in playEvent['details'] or not any(substring in playEvent['details']['event'] for substring in self.ACTION_TYPES)):
                                event_end_padding = self.PITCH_END_PADDING
                            action_index = None
                            # skip type 1 (breaks) and 2 & 3 (idle time) will look at all plays with an endTime
                            if skip_type <= 3 and 'endTime' in playEvent:
                                action_index = index
                            elif skip_type == 4:
                                # skip type 4 excludes non-action pitches (events that aren't last in the at-bat and don't fall under action types)
                                if index < (len(play['playEvents'])-1) and ('details' not in playEvent or 'event' not in playEvent['details'] or not any(substring in playEvent['details']['event'] for substring in self.ACTION_TYPES)):
                                    continue
                                else:
                                    # if the action is associated with another play or the event doesn't have an end time, use the previous event instead
                                    if ('actionPlayId' in playEvent or 'endTime' not in playEvent) and index > 0:
                                        action_index = index - 1
                                    else:
                                        action_index = index
                            if action_index is None:
                                continue
                            else:
                                break_end = (parse(play['playEvents'][action_index]['startTime']) - broadcast_start_timestamp).total_seconds() + self.EVENT_START_PADDING

                                # attempt to fix erroneous timestamps, like NYY-SEA 2022-08-09, bottom 11
                                # omit this check if we are skipping to specific players
                                if break_end < break_start and skip_type != 3:
                                    xbmc.log(monitor_name + ' adjusting break start for ' + str(break_start) + ', because it is less than ' + str(break_end))
                                    break_start = break_end - 10

                                    prev_break = len(skip_markers) - 1
                                    if prev_break > 0 and break_start < skip_markers[prev_break][1] and skip_markers[prev_break][0] < (skip_markers[prev_break][1] - 40):
                                        xbmc.log(monitor_name + ' adjusting previous break end for ' + str(skip_markers[prev_break][1]) + ', because it is greater than ' + str(break_start) + ' and more than 40 seconds greater than ' + str(skip_markers[prev_break][0]))
                                        skip_markers[prev_break][1] = skip_markers[prev_break][0] + 30

                                # if the break end should be greater than the current playback time
                                # and the break duration should be greater than than our specified minimum
                                # and if skip type is not 1 (inning breaks) or the inning has changed
                                # then we'll add the skip marker
                                # otherwise we'll ignore it and move on to the next one
                                if break_end > current_time and (break_end - break_start) >= self.MINIMUM_BREAK_DURATION and (skip_type != 1 or current_inning != previous_inning or current_inning_half != previous_inning_half):
                                    skip_markers.append([break_start, break_end])
                                    total_skip_time += break_end - break_start
                                    previous_inning = current_inning
                                    previous_inning_half = current_inning_half
                                    # exit loop after found inning, if not skipping breaks
                                    if skip_type == 0:
                                        break
                                break_start = (parse(play['playEvents'][action_index]['endTime']) - broadcast_start_timestamp).total_seconds() + event_end_padding
                                # add extra padding for overturned review plays
                                if 'reviewDetails' in play:
                                    isOverturned = play['reviewDetails']['isOverturned']
                                    if isOverturned == False and 'additionalReviews' in play['reviewDetails'] and len(play['reviewDetails']['additionalReviews']) > 0:
                                        for additionalReview in play['reviewDetails']['additionalReviews']:
                                            isOverturned = additionalReview['isOverturned']
                                            if isOverturned == True:
                                                break
                                    if isOverturned == True:
                                        break_start += 40

        xbmc.log(monitor_name + ' found ' + str(timedelta(seconds=total_skip_time)) + ' total skip time')

        return skip_markers, skip_to_players


    def change_monitor(self, blackouts):
        xbmc.log("Change monitor starting")

        self.mlb_monitor_started = str(datetime.now())
        settings.setSetting(id='mlb_monitor_started', value=self.mlb_monitor_started)
        monitor_name = 'Change monitor from ' + self.mlb_monitor_started
        xbmc.log(monitor_name + ' started')

        # initialize player to monitor video title
        player = xbmc.Player()
        video_title = LOCAL_STRING(30417) + ' ' + self.mlb_monitor_started

        game_refresh_sec = 10
        stream_refresh_sec = 1
        # check games every `refresh_sec` but return data from `delay_sec` ago to account for stream delay/buffering
        refresh_sec = game_refresh_sec
        delay_sec = GAME_CHANGER_DELAY
        games_buffer = deque(maxlen=int((delay_sec / refresh_sec) + 1))
        players_buffer = deque(maxlen=int((delay_sec / refresh_sec) + 1))
        innings_buffer = deque(maxlen=int((delay_sec / refresh_sec) + 1))

        games = []
        players = dict()
        innings = dict()
        self.break_expiries = dict()
        curr_game = None

        u_params = '&name=' + video_title + '&description=' + urllib.quote_plus(LOCAL_STRING(30418)) + '&icon=' + urllib.quote_plus(ICON)

        today = localToEastern()
        date_string = today[0:4] + '/month_' + today[5:7] + '/day_' + today[8:10]

        while not self.monitor.abortRequested():
            if refresh_sec != stream_refresh_sec:
                new_games, new_players, new_innings = self.get_best_games(date_string, blackouts, monitor_name, players, innings, curr_game)
                games_buffer.append(new_games)
                players_buffer.append(new_players)
                innings_buffer.append(new_innings)
                games = games_buffer[0]
                if delay_sec > 0:
                    xbmc.log(monitor_name + ' ' + str(delay_sec) + ' second delayed data ' + json.dumps(games))
                players = players_buffer[0]
                innings = innings_buffer[0]

                if curr_game is not None and len(games) == 0:
                    xbmc.log(monitor_name + ' not switching from ' + curr_game['state'].teams + ' because there are no active games')
                elif curr_game is not None and len(games) > 0 and curr_game['state'].game_pk == games[0]['state'].game_pk:
                    xbmc.log(monitor_name + ' not switching because ' + curr_game['state'].teams + ' is still the best/only game')
                elif curr_game is None and len(games) == 0:
                    dialog = xbmcgui.Dialog()
                    dialog.ok(LOCAL_STRING(30417),LOCAL_STRING(30419))
                    break
                else:
                    # Update state of curr_game
                    if curr_game is not None:
                        new_curr_game = [game for game in games if game['state'].game_pk == curr_game['state'].game_pk]
                        if not new_curr_game:
                            curr_game = None
                        else:
                            curr_game = new_curr_game[0]

                    # Only switch games if:
                    #  curr_game is None (either no curr_game or it's in commercial break)
                    #  The change in leverage is > 1.5 and there's a new batter in curr_game
                    #  game has a better leverage than curr_game and curr_game is below average leverage (1.0) and there's a new batter in curr_game
                    curr_game_none = curr_game is None
                    new_batter = curr_game and curr_game['state'].new_batter
                    curr_game_below_avg = curr_game and curr_game['leverage_index'] < 1.0
                    for game in games:
                        large_leverage_diff = curr_game and (game['leverage_index'] - curr_game['leverage_index'] > 1.5)
                        game_better = curr_game and game['leverage_index'] > curr_game['leverage_index']
                        if curr_game_none or (new_batter and (large_leverage_diff or (curr_game_below_avg and game_better))):
                            curr_game = game
                            xbmc.log(monitor_name + ' loading game ' + game['state'].teams)
                            self.stream_started = False
                            refresh_sec = stream_refresh_sec
                            #player.stop()
                            # next line helps avoid a crash per https://github.com/xbmc/xbmc/issues/14838#issuecomment-750289254
                            xbmc.executebuiltin('Dialog.Close(all,true)')
                            #xbmc.Player().play('plugin://plugin.video.mlbtv/?mode=102&game_pk='+game['state'].game_pk+u_params)
                            xbmc.executebuiltin('PlayMedia("plugin://plugin.video.mlbtv/?mode=102&game_pk='+game['state'].game_pk+u_params+'")')
                            xbmcplugin.endOfDirectory(addon_handle)
                            xbmc.log(monitor_name + ' loaded game ' + game['state'].teams)
                            break
                        elif large_leverage_diff:
                            xbmc.log(monitor_name + ' ' + game['state'].teams + ' is a better game, but ' + curr_game['state'].teams + ' still has a batter at the plate')
                        elif game_better:
                            xbmc.log(monitor_name + ' ' + game['state'].teams + ' is better game, but not enough better to switch from ' + curr_game['state'].teams)

            if xbmc.getCondVisibility("Player.HasMedia"):
                if self.stream_started == False:
                    xbmc.log(monitor_name + " detected stream start")
                    self.stream_started = True
                    refresh_sec = game_refresh_sec
            else:
                if self.stream_started == False:
                    xbmc.log(monitor_name + " waiting for stream to start")
                    self.stream_start_tries -= 1
                    if self.stream_start_tries < 1:
                        xbmc.log(monitor_name + " closing due to stream not starting")
                        break

            if self.monitor.waitForAbort(refresh_sec):
                xbmc.log(monitor_name + " aborting")
                break
            elif self.stream_started == True:
                if not xbmc.getCondVisibility("Player.HasMedia"):
                    xbmc.log(monitor_name + " closing due to stream stopped")
                    break
                elif player.getVideoInfoTag().getTitle() != video_title:
                    xbmc.log(monitor_name + " closing due to stream changed")
                    break
            elif self.mlb_monitor_started == '':
                xbmc.log(monitor_name + " closing due to reset")
                break

        xbmc.log(monitor_name + " closed")


    # get active live games ordered by leverage
    def get_best_games(self, date_string, blackouts, monitor_name, players, innings, curr_game):
        url = 'http://gd2.mlb.com/components/game/mlb/year_' + date_string + '/master_scoreboard.json'
        headers = {
            'User-Agent': UA_PC
        }
        r = requests.get(url,headers=headers, verify=VERIFY)
        json_source = r.json()
        #xbmc.log('Change monitor ' + self.mlb_monitor_started + ' json source : ' + json.dumps(json_source))

        now = datetime.now()

        best_games = []
        new_players = dict()
        new_innings = dict()
        omitted_games = {}

        if 'data' in json_source and 'games' in json_source['data'] and 'game' in json_source['data']['games']:
            games = []
            # if we don't have a current game, and nothing is found on loop #1, expand the criteria to include:
            # 2. challenge/replay review games
            # 3. games in break
            # 4. warmup
            for x in range(1,5):
                new_innings = dict()
                omitted_games = {'blackout': [], 'warmup': [], 'inactive': [], 'break': [], 'pitching_change': [], 'review': []}

                # reset all break expiries if we're on our third loop and including games in break
                if x == 3:
                    self.break_expiries = dict()

                for game in json_source['data']['games']['game']:
                    teams = game['away_name_abbrev'] + '@' + game['home_name_abbrev']
                    game_pk = str(game['game_pk'])

                    # Check break expiry, if available
                    if game_pk in self.break_expiries and self.break_expiries[game_pk] > now:
                        xbmc.log(monitor_name + ' ' + teams + ' still in break')
                        omitted_games['break'].append(teams)
                        continue

                    # Game is blacked out
                    if game_pk in blackouts:
                        omitted_games['blackout'].append(teams)
                        continue

                    game_status = game['status']

                    if 'challenge' in game_status['status'].lower() or 'replay' in game_status['status'].lower():
                        # Game is in challenge/replay review
                        if x < 2:
                            omitted_games['review'].append(teams)
                            continue
                    elif game_status['status'] == 'Warmup':
                        # Game is in warmup
                        if x < 4:
                            omitted_games['warmup'].append(teams)
                            continue
                    elif 'inning' not in game_status or 'o' not in game_status or game_status['status'] != 'In Progress':
                        # Game is otherwise not active (not started or game over)
                        omitted_games['inactive'].append(teams)
                        continue

                    inning_half = self.convert_inning_half(game_status['inning_state'])
                    inning_num = int(game_status['inning'])
                    outs = int(game_status['o'])
                    runners_on_base = self.convert_runners_on_base(game['runners_on_base'])
                    balls = int(game_status['b'])
                    strikes = int(game_status['s'])
                    away_score = int(game['linescore']['r']['away'])
                    home_score = int(game['linescore']['r']['home'])

                    # Game hasn't started yet
                    if x < 4 and inning_num == 1 and inning_half == 'top' and outs == 0 and balls == 0 and strikes == 0 and away_score == 0 and runners_on_base == '_ _ _':
                        omitted_games['inactive'].append(teams)
                        continue

                    # Game is between innings
                    if inning_half == 'Middle' or inning_half == 'End' or outs == 3:
                        if outs == 3:
                            if inning_half == 'top':
                                inning_half = 'Middle'
                            elif inning_half == 'bot':
                                inning_half = 'End'

                        if inning_half == 'Middle' or inning_half == 'End':
                            if inning_half == 'Middle':
                                # check for finished games
                                if inning_num == 9 and away_score < home_score:
                                    omitted_games['inactive'].append(teams)
                                    continue
                                inning_half = 'bot'
                            elif inning_half == 'End':
                                # check for finished games
                                if inning_num >= 9 and away_score != home_score:
                                    omitted_games['inactive'].append(teams)
                                    continue
                                inning_half = 'top'
                                inning_num += 1
                            outs = 0
                            runners_on_base = '_ _ _'
                            balls = 0
                            strikes = 0

                        if x < 3:
                            xbmc.log(monitor_name + ' ' + teams + ' inning break started or in progress')
                            omitted_games['break'].append(teams)

                            # only set break expiry for active games (that already have a stored inning state)
                            if game_pk in innings:
                                self.set_break_expiry(game_pk, now)

                            continue

                    inning_state = inning_half + ',' + str(inning_num)
                    new_innings[game_pk] = inning_state

                    # if the inning has changed, assume a break
                    if x < 3 and game_pk in innings and inning_state != innings[game_pk]:
                        xbmc.log(monitor_name + ' ' + teams + ' inning break detected')
                        omitted_games['break'].append(teams)
                        self.set_break_expiry(game_pk, now)
                        continue

                    # if the pitcher has changed, assume a break
                    pitcher = game['pitcher']['id']
                    new_pitcher = game_pk in players and 'pitcher' in players[game_pk] and players[game_pk]['pitcher'] != pitcher
                    if x < 3 and new_pitcher:
                        xbmc.log(monitor_name + ' ' + teams + ' pitching change break detected')
                        omitted_games['pitching_change'].append(teams)
                        self.set_break_expiry(game_pk, now)
                        continue

                    batter = game['batter']['id']
                    new_batter = (balls == 0 and strikes == 0) or balls == 4 or strikes == 3 or (game_pk in players and 'batter' in players[game_pk] and players[game_pk]['batter'] != batter)

                    # bump perfect games or no hitters in the 9th inning to the top of the leverage list
                    leverage_adjust = 0
                    if inning_num == 9 and (game_status['is_perfect_game'] == 'Y' or game_status['is_no_hitter'] == 'Y'):
                        away_hits = int(game['linescore']['h']['away'])
                        if (away_hits == 0 and inning_half == 'top') or (inning_half == 'bot'):
                            if game_status['is_perfect_game'] == 'Y':
                                xbmc.log(monitor_name + ' adjusting ' + teams + ' for perfect game')
                                leverage_adjust = MAX_LEVERAGE * 2
                            else:
                                xbmc.log(monitor_name + ' adjusting ' + teams + ' for no hitter')
                                leverage_adjust = MAX_LEVERAGE

                    state = self.GameState(
                        teams,
                        away_score,
                        home_score,
                        inning_half,
                        inning_num,
                        outs,
                        runners_on_base,
                        game_pk,
                        new_batter,
                        leverage_adjust)
                    games.append(state)

                    new_players[game_pk] = {'batter': batter, 'pitcher': pitcher}

                # exit loop if we have a current game or we've found new games above
                if curr_game is not None or len(games) > 0:
                    break

            xbmc.log(monitor_name + ' omitted games ' + json.dumps(omitted_games))

            leverage_indices = [{
                                "leverage_index": self.get_li(game.inning_num, game.inning_half, game.runners_on_base, game.outs, game.away_score, game.home_score) + game.leverage_adjust,
                                "state": game
                            } for game in games]
            if len(leverage_indices) > 0:
                best_games = sorted(leverage_indices, key=lambda x: x['leverage_index'], reverse=True)
                xbmc.log(monitor_name + ' live data ' + json.dumps(best_games))
                xbmc.log(monitor_name + ' break expiries ' + json.dumps(self.break_expiries, default=str))

        return best_games, new_players, new_innings


    def convert_inning_half(self, inning_state):
        if inning_state == 'Bottom':
            return 'bot'
        elif inning_state == 'Top':
            return 'top'
        else:
            return inning_state


    def convert_runners_on_base(self, runners_on_base):
        runners_on_str = ''
        runners_on_str += '1 ' if 'runner_on_1b' in runners_on_base else '_ '
        runners_on_str += '2 ' if 'runner_on_2b' in runners_on_base else '_ '
        runners_on_str += '3'  if 'runner_on_3b' in runners_on_base else '_'
        return runners_on_str


    def get_run_differential(self, away_score, home_score):
        MINIMUM = -4
        MAXIMUM = 4
        differential = home_score - away_score
        clamped_differential = max(MINIMUM, min(differential, MAXIMUM))
        return clamped_differential


    def get_li(self, inning_num, inning_half, runners_on_base, num_outs, away_score, home_score):
        run_differential_index = self.get_run_differential(away_score, home_score) + 4
        inning_num_index = min(inning_num, 9)

        return self.LI_TABLE[inning_num_index][inning_half][runners_on_base][num_outs][run_differential_index]


    def set_break_expiry(self, game_pk, now):
        self.break_expiries[game_pk] = now + timedelta(seconds=109)
