// Copyright (C) 2023 The Qt Company Ltd and other contributors.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of other Qt classes.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

// This file was generated by qlalr - DO NOT EDIT!
#ifndef GLSLPARSERTABLE_P_H
#define GLSLPARSERTABLE_P_H

#include <QtCore/qglobal.h>

QT_BEGIN_NAMESPACE

class GLSLParserTable
{
public:
    enum VariousConstants {
        EOF_SYMBOL = 0,
        T_ADD_ASSIGN = 3,
        T_AMPERSAND = 4,
        T_AND_ASSIGN = 5,
        T_AND_OP = 6,
        T_ATOMIC_UINT = 7,
        T_ATTRIBUTE = 8,
        T_BANG = 9,
        T_BOOL = 10,
        T_BREAK = 11,
        T_BUFFER = 15,
        T_BVEC2 = 12,
        T_BVEC3 = 13,
        T_BVEC4 = 14,
        T_CARET = 16,
        T_CASE = 17,
        T_CENTROID = 18,
        T_COHERENT = 19,
        T_COLON = 20,
        T_COMMA = 21,
        T_COMMENT = 255,
        T_CONST = 22,
        T_CONTINUE = 23,
        T_DASH = 24,
        T_DEC_OP = 25,
        T_DEFAULT = 26,
        T_DISCARD = 27,
        T_DIV_ASSIGN = 28,
        T_DMAT2 = 29,
        T_DMAT2X2 = 30,
        T_DMAT2X3 = 31,
        T_DMAT2X4 = 32,
        T_DMAT3 = 33,
        T_DMAT3X2 = 34,
        T_DMAT3X3 = 35,
        T_DMAT3X4 = 36,
        T_DMAT4 = 37,
        T_DMAT4X2 = 38,
        T_DMAT4X3 = 39,
        T_DMAT4X4 = 40,
        T_DO = 41,
        T_DOT = 42,
        T_DOUBLE = 43,
        T_DVEC2 = 44,
        T_DVEC3 = 45,
        T_DVEC4 = 46,
        T_ELSE = 47,
        T_EQUAL = 48,
        T_EQ_OP = 49,
        T_ERROR = 256,
        T_FALSE = 253,
        T_FEED_EXPRESSION = 2,
        T_FEED_GLSL = 1,
        T_FLAT = 50,
        T_FLOAT = 51,
        T_FOR = 52,
        T_GE_OP = 53,
        T_HIGHP = 54,
        T_IDENTIFIER = 55,
        T_IF = 56,
        T_IIMAGE1D = 57,
        T_IIMAGE1DARRAY = 58,
        T_IIMAGE2D = 59,
        T_IIMAGE2DARRAY = 60,
        T_IIMAGE2DMS = 61,
        T_IIMAGE2DMSARRAY = 62,
        T_IIMAGE2DRECT = 63,
        T_IIMAGE3D = 64,
        T_IIMAGEBUFFER = 65,
        T_IIMAGECUBE = 66,
        T_IIMAGECUBEARRAY = 67,
        T_IMAGE1D = 68,
        T_IMAGE1DARRAY = 69,
        T_IMAGE2D = 70,
        T_IMAGE2DARRAY = 71,
        T_IMAGE2DMS = 72,
        T_IMAGE2DMSARRAY = 73,
        T_IMAGE2DRECT = 74,
        T_IMAGE3D = 75,
        T_IMAGEBUFFER = 76,
        T_IMAGECUBE = 77,
        T_IMAGECUBEARRAY = 78,
        T_IN = 79,
        T_INC_OP = 80,
        T_INOUT = 81,
        T_INT = 82,
        T_INVARIANT = 83,
        T_ISAMPLER1D = 84,
        T_ISAMPLER1DARRAY = 85,
        T_ISAMPLER2D = 86,
        T_ISAMPLER2DARRAY = 87,
        T_ISAMPLER2DMS = 88,
        T_ISAMPLER2DMSARRAY = 89,
        T_ISAMPLER2DRECT = 90,
        T_ISAMPLER3D = 91,
        T_ISAMPLERBUFFER = 92,
        T_ISAMPLERCUBE = 93,
        T_ISAMPLERCUBEARRAY = 94,
        T_ISUBPASSINPUT = 95,
        T_ISUBPASSINPUTMS = 96,
        T_ITEXTURE1D = 97,
        T_ITEXTURE1DARRAY = 98,
        T_ITEXTURE2D = 99,
        T_ITEXTURE2DARRAY = 100,
        T_ITEXTURE2DMS = 101,
        T_ITEXTURE2DMSARRAY = 102,
        T_ITEXTURE2DRECT = 103,
        T_ITEXTURE3D = 104,
        T_ITEXTUREBUFFER = 105,
        T_ITEXTURECUBE = 106,
        T_ITEXTURECUBEARRAY = 107,
        T_IVEC2 = 108,
        T_IVEC3 = 109,
        T_IVEC4 = 110,
        T_LAYOUT = 111,
        T_LEFT_ANGLE = 112,
        T_LEFT_ASSIGN = 113,
        T_LEFT_BRACE = 114,
        T_LEFT_BRACKET = 115,
        T_LEFT_OP = 116,
        T_LEFT_PAREN = 117,
        T_LE_OP = 118,
        T_LOWP = 119,
        T_MAT2 = 120,
        T_MAT2X2 = 121,
        T_MAT2X3 = 122,
        T_MAT2X4 = 123,
        T_MAT3 = 124,
        T_MAT3X2 = 125,
        T_MAT3X3 = 126,
        T_MAT3X4 = 127,
        T_MAT4 = 128,
        T_MAT4X2 = 129,
        T_MAT4X3 = 130,
        T_MAT4X4 = 131,
        T_MEDIUMP = 132,
        T_MOD_ASSIGN = 133,
        T_MUL_ASSIGN = 134,
        T_NE_OP = 135,
        T_NOPERSPECTIVE = 136,
        T_NUMBER = 137,
        T_OR_ASSIGN = 138,
        T_OR_OP = 139,
        T_OUT = 140,
        T_PATCH = 141,
        T_PERCENT = 142,
        T_PLUS = 143,
        T_PRECISE = 144,
        T_PRECISION = 145,
        T_PREPROC = 254,
        T_QUESTION = 146,
        T_READONLY = 147,
        T_RESERVED = 257,
        T_RESTRICT = 148,
        T_RETURN = 149,
        T_RIGHT_ANGLE = 150,
        T_RIGHT_ASSIGN = 151,
        T_RIGHT_BRACE = 152,
        T_RIGHT_BRACKET = 153,
        T_RIGHT_OP = 154,
        T_RIGHT_PAREN = 155,
        T_SAMPLE = 156,
        T_SAMPLER = 157,
        T_SAMPLER1D = 158,
        T_SAMPLER1DARRAY = 159,
        T_SAMPLER1DARRAYSHADOW = 160,
        T_SAMPLER1DSHADOW = 161,
        T_SAMPLER2D = 162,
        T_SAMPLER2DARRAY = 163,
        T_SAMPLER2DARRAYSHADOW = 164,
        T_SAMPLER2DMS = 165,
        T_SAMPLER2DMSARRAY = 166,
        T_SAMPLER2DRECT = 167,
        T_SAMPLER2DRECTSHADOW = 168,
        T_SAMPLER2DSHADOW = 169,
        T_SAMPLER3D = 170,
        T_SAMPLERBUFFER = 171,
        T_SAMPLERCUBE = 172,
        T_SAMPLERCUBEARRAY = 173,
        T_SAMPLERCUBEARRAYSHADOW = 174,
        T_SAMPLERCUBESHADOW = 175,
        T_SAMPLERSHADOW = 176,
        T_SEMICOLON = 177,
        T_SHARED = 178,
        T_SLASH = 179,
        T_SMOOTH = 180,
        T_STAR = 181,
        T_STRUCT = 182,
        T_SUBPASSINPUT = 183,
        T_SUBPASSINPUTMS = 184,
        T_SUBROUTINE = 185,
        T_SUB_ASSIGN = 186,
        T_SWITCH = 187,
        T_TEXTURE1D = 188,
        T_TEXTURE1DARRAY = 189,
        T_TEXTURE2D = 190,
        T_TEXTURE2DARRAY = 191,
        T_TEXTURE2DMS = 192,
        T_TEXTURE2DMSARRAY = 193,
        T_TEXTURE2DRECT = 194,
        T_TEXTURE3D = 195,
        T_TEXTUREBUFFER = 196,
        T_TEXTURECUBE = 197,
        T_TEXTURECUBEARRAY = 198,
        T_TILDE = 199,
        T_TRUE = 252,
        T_TYPE_NAME = 200,
        T_UIMAGE1D = 201,
        T_UIMAGE1DARRAY = 202,
        T_UIMAGE2D = 203,
        T_UIMAGE2DARRAY = 204,
        T_UIMAGE2DMS = 205,
        T_UIMAGE2DMSARRAY = 206,
        T_UIMAGE2DRECT = 207,
        T_UIMAGE3D = 208,
        T_UIMAGEBUFFER = 209,
        T_UIMAGECUBE = 210,
        T_UIMAGECUBEARRAY = 211,
        T_UINT = 212,
        T_UNIFORM = 213,
        T_USAMPLER1D = 214,
        T_USAMPLER1DARRAY = 215,
        T_USAMPLER2D = 216,
        T_USAMPLER2DARRAY = 217,
        T_USAMPLER2DMS = 218,
        T_USAMPLER2DMSARRAY = 219,
        T_USAMPLER2DRECT = 220,
        T_USAMPLER3D = 221,
        T_USAMPLERBUFFER = 222,
        T_USAMPLERCUBE = 223,
        T_USAMPLERCUBEARRAY = 224,
        T_USUBPASSINPUT = 225,
        T_USUBPASSINPUTMS = 226,
        T_UTEXTURE1D = 227,
        T_UTEXTURE1DARRAY = 228,
        T_UTEXTURE2D = 229,
        T_UTEXTURE2DARRAY = 230,
        T_UTEXTURE2DMS = 231,
        T_UTEXTURE2DMSARRAY = 232,
        T_UTEXTURE2DRECT = 233,
        T_UTEXTURE3D = 234,
        T_UTEXTUREBUFFER = 235,
        T_UTEXTURECUBE = 236,
        T_UTEXTURECUBEARRAY = 237,
        T_UVEC2 = 238,
        T_UVEC3 = 239,
        T_UVEC4 = 240,
        T_VARYING = 241,
        T_VEC2 = 242,
        T_VEC3 = 243,
        T_VEC4 = 244,
        T_VERTICAL_BAR = 245,
        T_VOID = 246,
        T_VOLATILE = 247,
        T_WHILE = 248,
        T_WRITEONLY = 249,
        T_XOR_ASSIGN = 250,
        T_XOR_OP = 251,

        ACCEPT_STATE = 549,
        RULE_COUNT = 412,
        STATE_COUNT = 550,
        TERMINAL_COUNT = 258,
        NON_TERMINAL_COUNT = 91,

        GOTO_INDEX_OFFSET = 550,
        GOTO_INFO_OFFSET = 6629,
        GOTO_CHECK_OFFSET = 6629
    };

    static const char *const     spell[];
    static const short             lhs[];
    static const short             rhs[];
    static const short    goto_default[];
    static const short  action_default[];
    static const short    action_index[];
    static const short     action_info[];
    static const short    action_check[];

    static inline int nt_action (int state, int nt)
    {
        const int yyn = action_index [GOTO_INDEX_OFFSET + state] + nt;
        if (yyn < 0 || action_check [GOTO_CHECK_OFFSET + yyn] != nt)
            return goto_default [nt];

        return action_info [GOTO_INFO_OFFSET + yyn];
    }

    static inline int t_action (int state, int token)
    {
        const int yyn = action_index [state] + token;

        if (yyn < 0 || action_check [yyn] != token)
            return - action_default [state];

        return action_info [yyn];
    }
};


QT_END_NAMESPACE
#endif // GLSLPARSERTABLE_P_H

