/****************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{
    // Wasm requires host binaries so add a dependency to host binaries
    var hostDependencyStr = "";
    if (installer.value("os") == "x11") {
        hostDependencyStr = "qt.qt6.622.gcc_64"
    }
    if (installer.value("os") == "mac") {
        hostDependencyStr = "qt.qt6.622.clang_64"
    }
    if (installer.value("os") == "win") {
        hostDependencyStr = "qt.qt6.622.win64_mingw"
    }
    component.setValue("Dependencies", hostDependencyStr)
}

Component.prototype.createOperations = function()
{
    component.createOperations();

    var targetDir = installer.value("TargetDir");
    var qtPath = targetDir + "/6.2.2/wasm_32";
    var cmakeBinary = "";
    var platform = "";
    var qmakeScript = "";
    var qtCMakeScript = "";
    var targetQtConf = "";
    var targetQtConf_documentation = "Documentation=../../Docs/Qt-6.2.2";
    var targetQtConf_examples = "Examples=../../Examples/Qt-6.2.2";
    var originalQmakePath = "";
    var newQmakePath = "";
    var originalSetCMakePath ="";
    var newSetCMakePath = "";
    var originalHostPrefix = "HostPrefix=../../";
    var newHostPrefix = "";
    var originalHostData = "HostData=target";
    var newHostData = "";
    var qtToolchainCmake = "";
    var qtBuildInternalsExtraCmake = "";
    var originalQtHostPath = "";
    var newQtHostPath = "";
    var originalQtHostPathCmakeDir = "";
    var newQtHostPathCmakeDir = "";
    var originalQtHostTargetPath = "";
    var newQtHostTargetPath = "";

    if (installer.value("os") == "x11") {
        // CMake is installed under Tools by default for all Qt installations
        cmakeBinary = targetDir + "/Tools/CMake/bin/cmake";
        platform = "linux";

        qmakeScript = qtPath + "/bin/qmake";
        qtCMakeScript = qtPath + "/bin/qt-cmake";
        qtCMakePrivateScript = qtPath + "/bin/qt-cmake-private";
        targetQtConf = qtPath + "/bin/target_qt.conf";
        qtToolchainCmake = qtPath + "/lib/cmake/Qt6/qt.toolchain.cmake";
        qtBuildInternalsExtraCmake = qtPath + "/lib/cmake/Qt6BuildInternals/QtBuildInternalsExtra.cmake";

        // Initialize variables used for patching host qmake location
        // Host is qmake installed via dependencies
        originalQmakePath = "/home/qt/work/install/bin/qmake";
        newQmakePath = targetDir + "/6.2.2/gcc_64/bin/qmake";

        // Initialize variables used for patching CMake to under Tools
        originalSetCMakePath = "/opt/cmake-3.19.2/bin/cmake";
        newSetCMakePath = cmakeBinary;

        // Set new patched values for target_qt.confs
        newHostPrefix = "HostPrefix=../../gcc_64";
        newHostData = "HostData=../wasm_32";

        // Set new patched values for qt.toolchain.cmake
        // __qt_initial_qt_host_path
        originalQtHostPath = "/home/qt/work/install";
        newQtHostPath = targetDir + "/6.2.2/gcc_64";
        //__qt_initial_qt_host_path_cmake_dir
        originalQtHostPathCmakeDir = "/home/qt/work/install/lib/cmake";
        newQtHostPathCmakeDir = targetDir + "/6.2.2/gcc_64/lib/cmake";

        // Set new patched values for QtBuildInternalsExtra.cmake
        originalQtHostTargetPath = "/home/qt/work/install/target";
        newQtHostTargetPath = qtPath;
        }
    if (installer.value("os") == "mac") {
        var macOSTargetInstallBase = "macos";

        // CMake is installed under Tools by default for all Qt installations
        cmakeBinary = targetDir + "/Tools/CMake/bin/cmake";
        platform = "mac";

        qmakeScript = qtPath + "/bin/qmake";
        qtCMakeScript = qtPath + "/bin/qt-cmake";
        qtCMakePrivateScript = qtPath + "/bin/qt-cmake-private";
        targetQtConf = qtPath + "/bin/target_qt.conf";
        qtToolchainCmake = qtPath + "/lib/cmake/Qt6/qt.toolchain.cmake";
        qtBuildInternalsExtraCmake = qtPath + "/lib/cmake/Qt6BuildInternals/QtBuildInternalsExtra.cmake";

        // Initialize variables used for patching host qmake location
        // Host is qmake installed via dependencies
        originalQmakePath = "/Users/qt/work/install/bin/qmake";
        newQmakePath = targetDir + "/6.2.2/" + macOSTargetInstallBase + "/bin/qmake";

        // Initialize variables used for patching CMake to under Tools
        originalSetCMakePath = "/Applications/CMake.app/Contents/bin/cmake";
        newSetCMakePath = cmakeBinary;

        // Set new patched values for target_qt.confs
        newHostPrefix = "HostPrefix=../../" + macOSTargetInstallBase;
        newHostData = "HostData=../wasm_32";

        // Set new patched values for qt.toolchain.cmake
        // __qt_initial_qt_host_path
        originalQtHostPath = "/Users/qt/work/install";
        newQtHostPath = targetDir + "/6.2.2/" + macOSTargetInstallBase;
        //__qt_initial_qt_host_path_cmake_dir
        originalQtHostPathCmakeDir = "/Users/qt/work/install/lib/cmake";
        newQtHostPathCmakeDir = targetDir + "/6.2.2/" + macOSTargetInstallBase + "/lib/cmake";

        // Set new patched values for QtBuildInternalsExtra.cmake
        originalQtHostTargetPath = "/Users/qt/work/install/target";
        newQtHostTargetPath = qtPath;
    }

    if (installer.value("os") == "win") {
        // CMake is installed under Tools by default for all Qt installations
        cmakeBinary = targetDir + "/Tools/CMake_64/bin/cmake.exe";
        platform = "windows";

        qmakeScript = qtPath + "\\bin\\qmake.bat";
        qtCMakeScript = qtPath + "\\bin\\qt-cmake.bat";
        qtCMakePrivateScript = qtPath + "\\bin\\qt-cmake-private.bat";
        targetQtConf = qtPath + "\\bin\\target_qt.conf";
        qtToolchainCmake = qtPath + "\\lib\\cmake\\Qt6\\qt.toolchain.cmake";
        qtBuildInternalsExtraCmake = qtPath + "\\lib\\cmake\\Qt6BuildInternals\\QtBuildInternalsExtra.cmake";

        // Initialize variables used for patching host qmake location
        // Host is qmake installed via dependencies
        originalQmakePath = "/Users/qt/work/install/bin\\qmake.exe";
        newQmakePath = targetDir + "\\6.2.2\\mingw81_64\\bin\\qmake.exe";

        // Initialize variables used for patching CMake to under Tools
        originalSetCMakePath = "C:/CMake/bin/cmake.exe";
        newSetCMakePath =  cmakeBinary.replace(/\\/g, "/");

        // Set new patched values for target_qt.confs
        newHostPrefix = "HostPrefix=../../mingw81_64";
        newHostData = "HostData=../wasm_32";

        // Set new patched values for qt.toolchain.cmake
        var unixTargetDir = targetDir.replace(/\\/g, "/");
        console.log("Converting path for cmake: ");
        console.log("  from targetDir: " + targetDir);
        console.log("  to unixTargetDir: " + unixTargetDir);

        // __qt_initial_qt_host_path
        newQtHostPath = unixTargetDir + "/6.2.2/mingw81_64";

        // __qt_initial_qt_host_path
        originalQtHostPath = "/Users/qt/work/install";
        newQtHostPath = unixTargetDir + "/6.2.2/mingw81_64";
        //__qt_initial_qt_host_path_cmake_dir
        originalQtHostPathCmakeDir = "/Users/qt/work/install/lib/cmake";
        newQtHostPathCmakeDir = unixTargetDir + "/6.2.2/mingw81_64/lib/cmake";

        // Set new patched values for QtBuildInternalsExtra.cmake
        originalQtHostTargetPath = "/home/qt/work/install/target";
        newQtHostTargetPath = qtPath;
    }
    // Patch build time paths from target\bin\qmake(.bat) script
    console.log("Patching qmake script: " + qmakeScript);
    console.log("  from originalQmakePath: " + originalQmakePath);
    console.log("  to newQmakePath: " + newQmakePath);
    component.addOperation("Replace", qmakeScript, originalQmakePath, newQmakePath);

    // Patch build time CMake path from qt-cmake(.bat) script
    console.log("Patching CMake path from qt-cmake script: " + qtCMakeScript);
    console.log("  from originalSetCMakePath: " + originalSetCMakePath);
    console.log("  to newSetCMakePath: " + newSetCMakePath);
    component.addOperation("Replace", qtCMakeScript, originalSetCMakePath, newSetCMakePath);

    // Patch build time CMAke paths from qt-cmake-private(.bat) script
    console.log("Patching CMake path from qt-cmake-private script: " + qtCMakePrivateScript);
    console.log("  from originalSetCMakePath: " + originalSetCMakePath);
    console.log("  to newSetCMakePath: " + newSetCMakePath);
    component.addOperation("Replace", qtCMakePrivateScript, originalSetCMakePath, newSetCMakePath);

    // Patch Host Prefix and Host Data paths from target_qt.conf
    console.log("Patching Host Prefix and Host Data from target_qt.conf: " + targetQtConf);
    console.log("  from originalHostPrefix: " + originalHostPrefix);
    console.log("  to newHostPrefix: " + newHostPrefix);
    console.log("  from originalHostData: " + originalHostData);
    console.log("  to newHostData: " + newHostData);
    component.addOperation("Replace", targetQtConf, originalHostPrefix, newHostPrefix);
    component.addOperation("Replace", targetQtConf , originalHostData, newHostData);

    // Append target_qt.conf with relative paths to documentation and examples
    console.log("Appending " + targetQtConf_documentation + " and " + targetQtConf_examples + " to targetQtConf" + targetQtConf);
    component.addOperation("AppendFile", targetQtConf, targetQtConf_documentation);
    // Add a new line to targetQtConf which AppendFile operation doesn't add automatically
    if (installer.value("os") == "win") {
        // \r\n = CR + LF used as a new line character in Windows
        component.addOperation("AppendFile", targetQtConf, "\r\n");
    }
    else {
        // \n = LF (Line Feed) used as a new line character in Unix/macOS
        component.addOperation("AppendFile", targetQtConf, "\n");
    }
    component.addOperation("AppendFile", targetQtConf, targetQtConf_examples);

    // Patch Qt install path from qt.toolchain.cmake
    console.log("Patching install path from qt.toolchain.cmake : " + qtToolchainCmake);
    console.log("set __qt_initial_qt_host_path");
    console.log("  from originalQtHostPath: " + originalQtHostPath);
    console.log("  to newQtHostPath: " + newQtHostPath);
    component.addOperation("Replace", qtToolchainCmake, originalQtHostPath, newQtHostPath);
    console.log("set __qt_initial_qt_host_path_cmake_dir");
    console.log("  from originalQtHostPathCmakeDir: " + originalQtHostPathCmakeDir);
    console.log("  to newQtHostPathCmakeDir: " + newQtHostPathCmakeDir);
    component.addOperation("Replace", qtToolchainCmake, originalQtHostPathCmakeDir, newQtHostPathCmakeDir);

    // Patch Qt install path from QtBuildInternalsExtra.cmake
    console.log("Patching install path from QtBuildInternalsExtra.cmake : " + qtBuildInternalsExtraCmake);
    console.log("  from originalQtHostTargetPath: " + originalQtHostTargetPath);
    console.log("  to newQtHostTargetPath: " + newQtHostTargetPath);
    component.addOperation("Replace", qtBuildInternalsExtraCmake, originalQtHostTargetPath, newQtHostTargetPath);

    addInitQtPatchOperation(component, platform, qtPath, qmakeScript, "qt5");

    if (installer.value("SDKToolBinary") == "")
        return;

    // add Qt into QtCreator
    component.addOperation("Execute",
                           ["@SDKToolBinary@", "addQt",
                            "--id", component.name,
                            "--name", "Qt %{Qt:Version} WebAssembly",
                            "--type", "Qt4ProjectManager.QtVersion.WebAssembly",
                            "--qmake", qmakeScript,
                            "UNDOEXECUTE",
                            "@SDKToolBinary@", "rmQt", "--id", component.name]);

    var kitName = component.name + "_kit";
    component.addOperation("Execute",
                           ["@SDKToolBinary@", "addKit",
                            "--id", kitName,
                            "--name", "Qt %{Qt:Version} WebAssembly",
                            "--Ctoolchain", "asmjs-unknown-unknown-emscripten-32bit",
                            "--Cxxtoolchain", "asmjs-unknown-unknown-emscripten-32bit",
                            "--qt", component.name,
                            "--devicetype", "WebAssemblyDeviceType",
                            "UNDOEXECUTE",
                            "@SDKToolBinary@", "rmKit", "--id", kitName]);

    // enable WebAssembly Qt Creator plugin
    var settingsFile = installer.value("QtCreatorInstallerSettingsFile");
    component.addOperation("Settings", "path="+settingsFile, "method=add_array_value", "key=Plugins/ForceEnabled", "value=WebAssembly");

    // create qt.conf file
    createQtConfFiles(component, installer.value("TargetDir") + "/6.2.2/wasm_32", "Qt-6.2.2");

    // is this OpenSource installation?
    var isOpenSource = "true";
    if (['true', 'yes', '1'].indexOf(isOpenSource) >= 0) {
        // patch qconfig.pri
        var qconfigFile = qtPath + "/mkspecs/qconfig.pri";
        component.addOperation("LineReplace", qconfigFile, "QT_EDITION =", "QT_EDITION = OpenSource");
        if (installer.value("os") == "x11") {
            component.addOperation("LineReplace", qconfigFile, "QT_LICHECK = licheck64", "QT_LICHECK =");
        } else if (installer.value("os") == "mac") {
            component.addOperation("LineReplace", qconfigFile, "QT_LICHECK = licheck_mac", "QT_LICHECK =");
        } else if (installer.value("os") == "win") {
            component.addOperation("LineReplace", qconfigFile, "QT_LICHECK = licheck.exe", "QT_LICHECK =");
        }
    }
}
