/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android.multimedia;

import android.graphics.ImageFormat;
import android.hardware.Camera;
import java.util.concurrent.locks.ReentrantLock;

public class QtCameraListener
implements Camera.ShutterCallback,
Camera.PictureCallback,
Camera.AutoFocusCallback,
Camera.PreviewCallback {
    private int m_cameraId = -1;
    private byte[][] m_cameraPreviewBuffer = null;
    private volatile int m_actualPreviewBuffer = 0;
    private final ReentrantLock m_buffersLock = new ReentrantLock();
    private boolean m_fetchEachFrame = false;
    private static final String TAG = "Qt Camera";

    private QtCameraListener(int n) {
        this.m_cameraId = n;
    }

    public void preparePreviewBuffer(Camera camera) {
        Camera.Size size = camera.getParameters().getPreviewSize();
        double d = (double)ImageFormat.getBitsPerPixel((int)camera.getParameters().getPreviewFormat()) / 8.0;
        int n = (int)Math.ceil(d * (double)size.width * (double)size.height);
        this.m_buffersLock.lock();
        if (this.m_cameraPreviewBuffer == null || this.m_cameraPreviewBuffer[0].length < n) {
            this.m_cameraPreviewBuffer = new byte[2][n];
        }
        this.m_buffersLock.unlock();
    }

    public void fetchEachFrame(boolean bl) {
        this.m_fetchEachFrame = bl;
    }

    public byte[] lockAndFetchPreviewBuffer() {
        byte[] byArray = null;
        this.m_buffersLock.lock();
        byArray = this.m_cameraPreviewBuffer[this.m_actualPreviewBuffer == 1 ? 0 : 1];
        this.m_actualPreviewBuffer = 0;
        return byArray;
    }

    public void unlockPreviewBuffer() {
        if (this.m_buffersLock.isHeldByCurrentThread()) {
            this.m_buffersLock.unlock();
        }
    }

    public byte[] callbackBuffer() {
        return this.m_cameraPreviewBuffer[this.m_actualPreviewBuffer == 1 ? 1 : 0];
    }

    public void onShutter() {
        QtCameraListener.notifyPictureExposed(this.m_cameraId);
    }

    public void onPictureTaken(byte[] byArray, Camera camera) {
        QtCameraListener.notifyPictureCaptured(this.m_cameraId, byArray);
    }

    public void onPreviewFrame(byte[] byArray, Camera camera) {
        this.m_buffersLock.lock();
        if (byArray != null && this.m_fetchEachFrame) {
            QtCameraListener.notifyFrameFetched(this.m_cameraId, byArray);
        }
        this.m_actualPreviewBuffer = byArray == this.m_cameraPreviewBuffer[0] ? 1 : (byArray == this.m_cameraPreviewBuffer[1] ? 2 : 0);
        camera.addCallbackBuffer(this.m_cameraPreviewBuffer[this.m_actualPreviewBuffer == 1 ? 1 : 0]);
        this.m_buffersLock.unlock();
    }

    public void onAutoFocus(boolean bl, Camera camera) {
        QtCameraListener.notifyAutoFocusComplete(this.m_cameraId, bl);
    }

    private static native void notifyAutoFocusComplete(int var0, boolean var1);

    private static native void notifyPictureExposed(int var0);

    private static native void notifyPictureCaptured(int var0, byte[] var1);

    private static native void notifyFrameFetched(int var0, byte[] var1);
}

