/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android.sensors;

import android.app.Activity;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.SparseArray;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class QtSensors
implements SensorEventListener {
    static final QtSensors m_sensorsListener = new QtSensors();
    static SensorManager m_sensorManager = null;
    static SparseArray<Sensor> m_registeredSensors = new SparseArray();
    static Object m_syncObject = new Object();

    public static void setActivity(Activity activity, Object object) {
        try {
            m_sensorManager = (SensorManager)activity.getSystemService("sensor");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static String getSensorDescription(int n) {
        try {
            Sensor sensor = m_sensorManager.getDefaultSensor(n);
            return sensor.getName() + " " + sensor.getVendor() + " v" + sensor.getVersion();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static int[] getSensorList() {
        try {
            List list = m_sensorManager.getSensorList(-1);
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (Sensor sensor : list) {
                hashSet.add(sensor.getType());
            }
            Object object = new int[hashSet.size()];
            int n = 0;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                object[n++] = n2;
            }
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean registerSensor(int n, int n2) {
        Object object = m_syncObject;
        synchronized (object) {
            try {
                Sensor sensor = m_sensorManager.getDefaultSensor(n);
                m_sensorManager.registerListener((SensorEventListener)m_sensorsListener, sensor, n2);
                m_registeredSensors.put(n, (Object)sensor);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean unregisterSensor(int n) {
        Object object = m_syncObject;
        synchronized (object) {
            try {
                Sensor sensor = (Sensor)m_registeredSensors.get(n);
                if (sensor != null) {
                    m_sensorManager.unregisterListener((SensorEventListener)m_sensorsListener, (Sensor)m_registeredSensors.get(n));
                    m_registeredSensors.remove(n);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private static float[] convertQuaternionToEuler(float[] fArray) {
        float[] fArray2 = new float[9];
        SensorManager.getRotationMatrixFromVector((float[])fArray2, (float[])fArray);
        float[] fArray3 = new float[3];
        SensorManager.getOrientation((float[])fArray2, (float[])fArray3);
        return fArray3;
    }

    public static native void accuracyChanged(int var0, int var1);

    public static native void sensorChanged(int var0, long var1, float[] var3);

    public void onAccuracyChanged(Sensor sensor, int n) {
        QtSensors.accuracyChanged(sensor.getType(), n);
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        if (sensorEvent.sensor.getType() == 11) {
            QtSensors.sensorChanged(sensorEvent.sensor.getType(), sensorEvent.timestamp, QtSensors.convertQuaternionToEuler(sensorEvent.values));
        } else {
            QtSensors.sensorChanged(sensorEvent.sensor.getType(), sensorEvent.timestamp, sensorEvent.values);
        }
    }
}

