import QtQuick
import QtQuick3D
import QtQuick.Timeline 1.0
import Generated.QtQuick3D.Car 1.0
import QtQuick 2.15
import Generated.QtQuick3D.ElectricEngineAllParts 1.0
import Generated.QtQuick3D.FinalWheel_jyri 1.0
import Generated.QtQuick3D.SUV_Outru_ClusterWireframe 1.0
import Generated.QtQuick3D.Suvtextured2 1.0
Node {
    id: rootNode
    property bool nightmode: false
    property real animationScale: 1
    property real tireRotation: 0
    property real tireRotationLeftover: 0
    property bool charge: false
    property Texture specularRefletionTexture
    property real batteryCharge: 1
    property alias glowdotSource: suv_shadow.source
    property alias plane1Opacity: shadow.opacity
    property real shadowX: 0




    Timeline {
        id: timeline
        endFrame: 0
        animations: [
            TimelineAnimation {
                id: timelineAnimation
                duration: (250 - mainScreen.globalDrivespeed) * 21
                running: true
                loops: -1
                to: 4000
                from: 0
                onDurationChanged: {
                    if (duration === 5250) {
                        stop();
                        return;
                    }

                    tireRotationLeftover += tireRotation;
                    if (tireRotationLeftover >= 360)
                        tireRotationLeftover -= 360;

                    restart();
                }
            }
        ]
        enabled: true
        startFrame: 0

        KeyframeGroup {
            target: rootNode
            property: "tireRotation"

            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 4000
                value: 360
            }
        }
    }

    Model {
        id: shadow
        x: -0
        y: 0.557
        opacity: 1
        source: "#Rectangle"
        castsShadows: false
        receivesShadows: false
        z: 1.76452
        scale.z: 6.29375
        scale.y: 7.17134
        scale.x: 8.08678
        eulerRotation.x: -90
        materials: rectMaterial
        DefaultMaterial {
            id: rectMaterial
            opacity: 0.85
            opacityMap: suv_shadow
            diffuseMap: suv_shadow
            opacityChannel: Material.A
            lighting: DefaultMaterial.NoLighting
            diffuseColor: "#989898"

            Texture {
                id: suv_shadow
                source: "../../../images/suv_shadow2.png"
                generateMipmaps: true
            }
        }
    }



    ElectricEngineAllParts {
        id: electricEngineAllParts
        x: -2.362
        y: 0
        visible: false
        z: 0
        charge: batteryCharge
    }

    FinalWheel_jyri {
        id: finalWheel_jyri
        x: -94.588
        y: 38.098
        eulerRotation.y: 0 + carpositioner.carRotation * 25
        eulerRotation.x: (mainScreen.state != "chargeUp"
                          && mainScreen.state != "chargeSide"
                          && mainScreen.state != "chargeBehind")
                         ? (tireRotation + tireRotationLeftover) : 0
        z: 152.89853
    }

    FinalWheel_jyri {
        id: finalWheel_jyri2
        x: 95.67
        y: 38.098
        eulerRotation.x: (mainScreen.state != "chargeUp"
                          && mainScreen.state != "chargeSide"
                          && mainScreen.state != "chargeBehind")
                         ? -(tireRotation + tireRotationLeftover) : 0
        eulerRotation.y: 180 + carpositioner.carRotation * 25
        z: 152.89853
    }

    FinalWheel_jyri {
        id: finalWheel_jyri3
        x: 93.578
        y: 38.098
        eulerRotation.x: (mainScreen.state != "chargeUp"
                          && mainScreen.state != "chargeSide"
                          && mainScreen.state != "chargeBehind")
                         ? -(tireRotation + tireRotationLeftover) : 0
        z: -153.7606
        eulerRotation.y: 180

        FinalWheel_jyri {
            id: finalWheel_jyri1
            x: 188.705
            y: 0
            eulerRotation.x: -0.00001
            eulerRotation.y: -180
            eulerRotation.z: -0
            z: 0.00008
        }
    }

    Model {
        id: backLight
        x: -0
        y: 4.506
        opacity: 0.1
        visible: globalNightMode
        source: "#Rectangle"
        receivesShadows: false
        castsShadows: false
        eulerRotation.z: 179.3286
        eulerRotation.y: -0.44761
        scale.z: 3.3573
        scale.y: 3.67816
        scale.x: 3.69249
        z: -353.19797
        eulerRotation.x: -90
        materials: rectMaterial2
        DefaultMaterial {
            id: rectMaterial2
            opacity: 0.9
            specularTint: "#ffcece"
            lighting: DefaultMaterial.NoLighting
            diffuseMap: car_lights_floor
            diffuseColor: "#ff0000"

            Texture {
                id: car_lights_floor
                source: "../../../images/car_lights_floor.png"
                generateMipmaps: true
            }
        }
    }

    Suvtextured2 {
        id: suvtextured2
        x: -0
        y: -1.747
        z: -7.30883
    }

    SUV_Outru_ClusterWireframe {
        id: sUV_Outru_ClusterWireframe
        y: -3.04
        opacity: 0
        z: -17.24
    }

    Model {
        id: plane2
        x: 1.627
        y: 156.6
        source: "#Rectangle"
        receivesShadows: false
        castsShadows: false
        scale.z: 1.704
        scale.y: 0.24321
        scale.x: 0.54366
        eulerRotation.x: -49.24172
        eulerRotation.z: 180
        eulerRotation.y: -180
        z: -207.89383
        materials: rectMaterial1
        DefaultMaterial {
            id: rectMaterial1
            opacity: 0.1
            cullMode: Material.NoCulling
            depthDrawMode: Material.AlwaysDepthDraw
            emissiveFactor.x: 1
            specularTint: "#ff3434"
            diffuseMap: light_glow
            diffuseColor: "#ff0000"

            Texture {
                id: light_glow
                source: "../../../images/light_glow.png"
                generateMipmaps: true
            }
        }
    }




    states: [
        State {
            name: "base"
            when: !charge

            PropertyChanges {
                target: electricEngineAllParts
                z: 0
            }

            PropertyChanges {
                target: plane2
                x: 1.627
                y: 156.6
                z: -207.89
            }

            PropertyChanges {
                target: shadow
                receivesShadows: false
                castsShadows: false
            }
        },
        State {
            name: "charge"
            when: charge

            PropertyChanges {
                target: electricEngineAllParts
                x: -3.427
                y: 0
                visible: true
                scale.z: 0.95
                scale.y: 0.95
                scale.x: 0.95
                charge: batteryCharge
                z: 0
            }

            PropertyChanges {
                target: plane2
                opacity: 0
            }

            PropertyChanges {
                target: backLight
                opacity: 0
            }

            PropertyChanges {
                target: rectMaterial
                opacity: 0.65
            }

            PropertyChanges {
                target: sUV_Outru_ClusterWireframe
                x: 0
                y: -0.917
                opacity: 1
                z: -14.33533
                scale.z: 96
                scale.y: 96
                scale.x: 96
            }

            PropertyChanges {
                target: suvtextured2
                visible: false
            }
        }
    ]
    transitions: [
        Transition {
            id: transition

            ParallelAnimation {
                SequentialAnimation {
                    PauseAnimation {
                        duration: 50
                    }

                    PropertyAnimation {
                        target: plane2
                        property: "opacity"
                        duration: 150
                    }
                }
            }

            to: "*"
            from: "*"
        }
    ]

}






