import QtQuick
import QtQuick.Controls
import QtQuick.Layouts
import QtQuick.Studio.DesignEffects
import "../FigmaBridgeEffects"

Item {
    id: root
    width: 1560
    height: 860
    SkeuoDesignStudies {
        id: figmaImport
        anchors.verticalCenter: parent.verticalCenter
        anchors.right: parent.right
        anchors.rightMargin: 200
    }
    Text {
        id: dsLabel
        y: 736
        width: 514
        height: 58
        text: qsTr("Figma Design")
        anchors.bottom: parent.bottom
        anchors.bottomMargin: 20
        font.pixelSize: 28
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        anchors.horizontalCenter: figmaColumn.horizontalCenter
        font.family: "Victor Mono"
    }
    Text {
        id: dsLabel2
        y: 736
        width: 514
        height: 58
        text: qsTr("Figma Bridge Import")
        anchors.bottom: parent.bottom
        anchors.bottomMargin: 20
        font.pixelSize: 28
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        anchors.horizontalCenter: figmaImport.horizontalCenter
        font.family: "Victor Mono"
    }

    ColumnLayout {
        id: figmaColumn
        anchors.verticalCenter: parent.verticalCenter
        anchors.left: parent.left
        anchors.leftMargin: 200
        spacing: 20
        Image {
            id: skeuoDesignStudies
            source: "../images/SkeuoDesignStudies.png"
            Layout.alignment: Qt.AlignHCenter | Qt.AlignVCenter
            fillMode: Image.PreserveAspectFit
        }

        Image {
            id: skeuoStudy
            source: "../images/skeuoStudy.png"
            Layout.alignment: Qt.AlignHCenter | Qt.AlignVCenter
            fillMode: Image.PreserveAspectFit
        }
    }
}
